/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.SynchronizationCommitConflictException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.InternalPool;
import com.gemstone.gemfire.internal.cache.TXCommitMessage;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;

public class TXSynchronizationOp {
    public static TXCommitMessage execute(InternalPool pool, int status, int txId, CompletionType type) {
        Impl impl = new Impl(status, txId, type);
        pool.execute(impl);
        return impl.tXCommitMessageResponse;
    }

    static class Impl
    extends AbstractOp {
        private int status;
        private CompletionType type;
        TXCommitMessage tXCommitMessageResponse;

        public Impl(int status, int txId, CompletionType type) {
            super(90, type == CompletionType.AFTER_COMPLETION ? 3 : 2);
            this.status = status;
            this.type = type;
            this.getMessage().addIntPart(type.ordinal());
            this.getMessage().addIntPart(txId);
            if (type == CompletionType.AFTER_COMPLETION) {
                this.getMessage().addIntPart(status);
            }
        }

        public String toString() {
            return "TXSynchronization(threadTxId=" + TXManagerImpl.getCurrentTXUniqueId() + "; " + (Object)((Object)this.type) + "; status=" + this.status + ")";
        }

        @Override
        protected void processAck(Message msg, String opName) throws Exception {
            Throwable t;
            int msgType = msg.getMessageType();
            if (msgType == 6) {
                return;
            }
            Part part = msg.getPart(0);
            if (msgType == 2 && ((t = (Throwable)part.getObject()) instanceof CommitConflictException || t instanceof SynchronizationCommitConflictException)) {
                throw (GemFireException)t;
            }
            super.processAck(msg, opName);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            TXCommitMessage rcs;
            if (this.type == CompletionType.BEFORE_COMPLETION) {
                block3: {
                    try {
                        this.processAck(msg, this.type.toString());
                    }
                    catch (ServerOperationException e) {
                        if (!(e.getCause() instanceof SynchronizationCommitConflictException)) break block3;
                        throw (SynchronizationCommitConflictException)e.getCause();
                    }
                }
                return null;
            }
            this.tXCommitMessageResponse = rcs = (TXCommitMessage)this.processObjResponse(msg, this.type.toString());
            return rcs;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 3;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startTxSynchronization();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endTxSynchronizationSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endTxSynchronization(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }
    }

    public static enum CompletionType {
        BEFORE_COMPLETION,
        AFTER_COMPLETION;

    }
}

