/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;

public class RollbackOp {
    public static void execute(ExecutablePool pool, int txId) {
        RollbackOpImpl op = new RollbackOpImpl(txId);
        pool.execute(op);
    }

    private RollbackOp() {
    }

    private static class RollbackOpImpl
    extends AbstractOp {
        private int txId;

        protected RollbackOpImpl(int txId) {
            super(87, 1);
            this.getMessage().setTransactionId(txId);
            this.txId = txId;
        }

        public String toString() {
            return "Rollback(txId=" + this.txId + ")";
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "rollback");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 2;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startRollback();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endRollbackSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endRollback(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }
    }
}

