/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.internal.InternalInstantiator;
import com.gemstone.gemfire.internal.cache.ClientServerObserver;
import com.gemstone.gemfire.internal.cache.ClientServerObserverHolder;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.IOException;

public class RegisterInstantiatorsOp {
    public static void execute(ExecutablePool pool, Instantiator[] instantiators, EventID eventId) {
        RegisterInstantiatorsOpImpl op = new RegisterInstantiatorsOpImpl(instantiators, eventId);
        pool.execute(op, Integer.MAX_VALUE);
    }

    public static void execute(ExecutablePool pool, Object[] holders, EventID eventId) {
        RegisterInstantiatorsOpImpl op = new RegisterInstantiatorsOpImpl(holders, eventId);
        pool.execute(op, Integer.MAX_VALUE);
    }

    private RegisterInstantiatorsOp() {
    }

    private static class RegisterInstantiatorsOpImpl
    extends AbstractOp {
        public RegisterInstantiatorsOpImpl(Instantiator[] instantiators, EventID eventId) {
            super(51, instantiators.length * 3 + 1);
            for (int i = 0; i < instantiators.length; ++i) {
                Instantiator instantiator = instantiators[i];
                String className = instantiator.getClass().toString().substring(6);
                String instantiatedClassName = instantiator.getInstantiatedClass().toString().substring(6);
                try {
                    this.getMessage().addBytesPart(BlobHelper.serializeToBlob(className));
                    this.getMessage().addBytesPart(BlobHelper.serializeToBlob(instantiatedClassName));
                }
                catch (IOException ex) {
                    throw new SerializationException("failed serializing object", ex);
                }
                this.getMessage().addIntPart(instantiator.getId());
            }
            this.getMessage().addBytesPart(eventId.calcBytes());
            if (PoolImpl.IS_INSTANTIATOR_CALLBACK) {
                ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                bo.beforeSendingToServer(eventId);
            }
        }

        public RegisterInstantiatorsOpImpl(Object[] holders, EventID eventId) {
            super(51, holders.length * 3 + 1);
            for (Object obj : holders) {
                String instantiatorClassName = null;
                String instantiatedClassName = null;
                int id = 0;
                if (obj instanceof Instantiator) {
                    instantiatorClassName = ((Instantiator)obj).getClass().getName();
                    instantiatedClassName = ((Instantiator)obj).getInstantiatedClass().getName();
                    id = ((Instantiator)obj).getId();
                } else {
                    instantiatorClassName = ((InternalInstantiator.InstantiatorAttributesHolder)obj).getInstantiatorClassName();
                    instantiatedClassName = ((InternalInstantiator.InstantiatorAttributesHolder)obj).getInstantiatedClassName();
                    id = ((InternalInstantiator.InstantiatorAttributesHolder)obj).getId();
                }
                try {
                    this.getMessage().addBytesPart(BlobHelper.serializeToBlob(instantiatorClassName));
                    this.getMessage().addBytesPart(BlobHelper.serializeToBlob(instantiatedClassName));
                }
                catch (IOException ex) {
                    throw new SerializationException("failed serializing object", ex);
                }
                this.getMessage().addIntPart(id);
            }
            this.getMessage().addBytesPart(eventId.calcBytes());
            if (PoolImpl.IS_INSTANTIATOR_CALLBACK) {
                ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                bo.beforeSendingToServer(eventId);
            }
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "registerInstantiators");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startRegisterInstantiators();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endRegisterInstantiatorsSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endRegisterInstantiators(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }
    }
}

