/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionImpl;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.Op;
import com.gemstone.gemfire.cache.client.internal.UserAttributes;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import java.util.Properties;

public class ProxyCacheCloseOp {
    public static Object executeOn(ServerLocation location, ExecutablePool pool, Properties securityProps, boolean keepAlive) {
        ProxyCacheCloseOpImpl op = new ProxyCacheCloseOpImpl(pool, securityProps, keepAlive);
        return pool.executeOn(location, (Op)op);
    }

    private ProxyCacheCloseOp() {
    }

    static class ProxyCacheCloseOpImpl
    extends AbstractOp {
        public ProxyCacheCloseOpImpl(ExecutablePool pool, Properties securityProps, boolean keepAlive) {
            super(78, 1);
            byte[] byArray;
            this.getMessage().setMessageHasSecurePartFlag();
            Message message = this.getMessage();
            if (keepAlive) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 1;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 0;
            }
            message.addBytesPart(byArray);
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
            byte[] secureBytes = null;
            hdos.writeLong(cnx.getConnectionID());
            Long userId = UserAttributes.userAttributes.get().getServerToId().get(cnx.getServer());
            if (userId == null) {
                throw new ServerConnectivityException("Connection error while authenticating user");
            }
            hdos.writeLong(userId);
            try {
                secureBytes = ((ConnectionImpl)cnx).getHandShake().encryptBytes(hdos.toByteArray());
            }
            finally {
                hdos.close();
            }
            this.getMessage().setSecurePart(secureBytes);
            this.getMessage().send(false);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            Part part = msg.getPart(0);
            int msgType = msg.getMessageType();
            if (msgType == 6) {
                return part.getObject();
            }
            if (msgType == 2) {
                String s = "While performing a remote proxy cache close";
                throw new ServerOperationException(s, (Throwable)part.getObject());
            }
            if (this.isErrorResponse(msgType)) {
                throw new ServerOperationException(part.getString());
            }
            throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 3;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGet();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGet(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

