/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.Op;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import java.util.Iterator;
import java.util.List;

public class PrimaryAckOp {
    public static void execute(Connection connection, ExecutablePool pool, List events) {
        PrimaryAckOpImpl op = new PrimaryAckOpImpl(events);
        pool.executeOn(connection, (Op)op);
    }

    private PrimaryAckOp() {
    }

    private static class PrimaryAckOpImpl
    extends AbstractOp {
        public PrimaryAckOpImpl(List events) {
            super(52, events.size());
            Iterator i = events.iterator();
            while (i.hasNext()) {
                this.getMessage().addObjPart(i.next());
            }
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "primaryAck");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startPrimaryAck();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endPrimaryAckSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endPrimaryAck(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

