/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.Endpoint;
import com.gemstone.gemfire.cache.client.internal.EndpointManager;
import com.gemstone.gemfire.cache.client.internal.InternalPool;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;

public class PdxRegistryRecoveryListener
extends EndpointManager.EndpointListenerAdapter {
    private static final Logger logger = LogService.getLogger();
    private final AtomicInteger endpointCount = new AtomicInteger();
    private final InternalPool pool;

    public PdxRegistryRecoveryListener(InternalPool pool) {
        this.pool = pool;
    }

    @Override
    public void endpointCrashed(Endpoint endpoint) {
        int count = this.endpointCount.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("PdxRegistryRecoveryListener - EndpointCrashed. Now have {} endpoints", new Object[]{count});
        }
    }

    @Override
    public void endpointNoLongerInUse(Endpoint endpoint) {
        int count = this.endpointCount.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("PdxRegistryRecoveryListener - EndpointNoLongerInUse. Now have {} endpoints", new Object[]{count});
        }
    }

    @Override
    public void endpointNowInUse(Endpoint endpoint) {
        int count = this.endpointCount.incrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("PdxRegistryRecoveryListener - EndpointNowInUse. Now have {} endpoints", new Object[]{count});
        }
        if (count == 1) {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache == null) {
                return;
            }
            TypeRegistry registry = cache.getPdxRegistry();
            if (registry == null) {
                return;
            }
            registry.clear();
        }
    }
}

