/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.client.internal.Endpoint;
import com.gemstone.gemfire.cache.client.internal.EndpointManager;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.InternalPool;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.RegisterInstantiatorsOp;
import com.gemstone.gemfire.internal.InternalInstantiator;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class InstantiatorRecoveryListener
extends EndpointManager.EndpointListenerAdapter {
    private static final Logger logger = LogService.getLogger();
    private final AtomicInteger endpointCount = new AtomicInteger();
    protected final InternalPool pool;
    protected final ScheduledExecutorService background;
    protected final long pingInterval;
    protected final Object recoveryScheduledLock = new Object();
    protected boolean recoveryScheduled;

    public InstantiatorRecoveryListener(ScheduledExecutorService background, InternalPool pool) {
        this.pool = pool;
        this.pingInterval = pool.getPingInterval();
        this.background = background;
    }

    @Override
    public void endpointCrashed(Endpoint endpoint) {
        int count = this.endpointCount.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("InstantiatorRecoveryTask - EndpointCrashed. Now have {} endpoints", new Object[]{count});
        }
    }

    @Override
    public void endpointNoLongerInUse(Endpoint endpoint) {
        int count = this.endpointCount.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("InstantiatorRecoveryTask - EndpointNoLongerInUse. Now have {} endpoints", new Object[]{count});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endpointNowInUse(Endpoint endpoint) {
        int count = this.endpointCount.incrementAndGet();
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("InstantiatorRecoveryTask - EndpointNowInUse. Now have {} endpoints", new Object[]{count});
        }
        if (count == 1) {
            Object object = this.recoveryScheduledLock;
            synchronized (object) {
                if (!this.recoveryScheduled) {
                    try {
                        this.recoveryScheduled = true;
                        this.background.execute(new RecoveryTask());
                        if (isDebugEnabled) {
                            logger.debug("InstantiatorRecoveryTask - Scheduled Recovery Task");
                        }
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected class RecoveryTask
    extends PoolImpl.PoolTask {
        protected RecoveryTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run2() {
            if (InstantiatorRecoveryListener.this.pool.getCancelCriterion().cancelInProgress() != null) {
                return;
            }
            Object object = InstantiatorRecoveryListener.this.recoveryScheduledLock;
            synchronized (object) {
                InstantiatorRecoveryListener.this.recoveryScheduled = false;
            }
            Object[] objects = InternalInstantiator.getInstantiatorsForSerialization();
            if (objects.length == 0) {
                return;
            }
            EventID eventId = InternalInstantiator.generateEventId();
            if (eventId == null) {
                InstantiatorRecoveryListener.this.background.schedule(new RecoveryTask(), InstantiatorRecoveryListener.this.pingInterval, TimeUnit.MILLISECONDS);
                InstantiatorRecoveryListener.this.recoveryScheduled = true;
            } else {
                try {
                    RegisterInstantiatorsOp.execute((ExecutablePool)InstantiatorRecoveryListener.this.pool, objects, eventId);
                }
                catch (CancelException e) {
                    throw e;
                }
                catch (RejectedExecutionException e) {
                    InstantiatorRecoveryListener.this.pool.getCancelCriterion().checkCancelInProgress(e);
                    throw e;
                }
                catch (Exception e) {
                    InstantiatorRecoveryListener.this.pool.getCancelCriterion().checkCancelInProgress(e);
                    Throwable cause = e.getCause();
                    if (cause instanceof ClassNotFoundException) {
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.InstantiatorRecoveryListener_INSTANTIATORRECOVERYTASK_ERROR_CLASSNOTFOUNDEXCEPTION, cause.getMessage()));
                    } else {
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.InstantiatorRecoveryListener_INSTANTIATORRECOVERYTASK_ERROR_RECOVERING_INSTANTIATORS), (Throwable)e);
                    }
                }
                finally {
                    InstantiatorRecoveryListener.this.pool.releaseThreadLocalConnection();
                }
            }
        }
    }
}

