/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.pdx.internal.PdxType;
import java.util.Map;

public class GetPDXTypesOp {
    public static Map<Integer, PdxType> execute(ExecutablePool pool) {
        GetPDXTypesOpImpl op = new GetPDXTypesOpImpl();
        return (Map)pool.execute(op);
    }

    private GetPDXTypesOp() {
    }

    private static class GetPDXTypesOpImpl
    extends AbstractOp {
        public GetPDXTypesOpImpl() {
            super(101, 1);
            this.getMessage().addIntPart(0);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            Part part = msg.getPart(0);
            int msgType = msg.getMessageType();
            if (msgType == 1) {
                return (Map)part.getObject();
            }
            if (msgType == 2) {
                String s = "While performing a remote getPdxTypes";
                throw new ServerOperationException(s, (Throwable)part.getObject());
            }
            if (this.isErrorResponse(msgType)) {
                throw new ServerOperationException(part.getString());
            }
            throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return 0L;
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected boolean participateInTransaction() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }
    }
}

