/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecuteFunctionOp;
import com.gemstone.gemfire.cache.client.internal.Op;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.MemberMappedArgument;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class ExecuteFunctionNoAckOp {
    private static final Logger logger = LogService.getLogger();

    private ExecuteFunctionNoAckOp() {
    }

    public static void execute(PoolImpl pool, Function function, Object args, MemberMappedArgument memberMappedArg, boolean allServers, byte hasResult, boolean isFnSerializationReqd, String[] groups) {
        List<ServerLocation> servers = null;
        ExecuteFunctionNoAckOpImpl op = new ExecuteFunctionNoAckOpImpl(function, args, memberMappedArg, hasResult, isFnSerializationReqd, groups, allServers);
        try {
            if (allServers && groups.length == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ExecuteFunctionNoAckOp#execute : Sending Function Execution Message:" + op.getMessage() + " to all servers using pool: " + pool);
                }
                servers = pool.getCurrentServers();
                Iterator<ServerLocation> i = servers.iterator();
                while (i.hasNext()) {
                    pool.executeOn(i.next(), (Op)op);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("ExecuteFunctionNoAckOp#execute : Sending Function Execution Message:" + op.getMessage() + " to server using pool: " + pool + " with groups:" + Arrays.toString(groups) + " all members:" + allServers);
                }
                pool.execute(op, 0);
            }
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("ExecuteFunctionNoAckOp#execute : Exception occured while Sending Function Execution Message:" + op.getMessage() + " to server using pool: " + pool, (Throwable)ex);
            }
            if (ex.getMessage() != null) {
                throw new FunctionException(ex.getMessage(), ex);
            }
            throw new FunctionException("Unexpected exception during function execution:", ex);
        }
    }

    public static void execute(PoolImpl pool, String functionId, Object args, MemberMappedArgument memberMappedArg, boolean allServers, byte hasResult, boolean isFnSerializationReqd, boolean isHA, boolean optimizeForWrite, String[] groups) {
        List<ServerLocation> servers = null;
        ExecuteFunctionNoAckOpImpl op = new ExecuteFunctionNoAckOpImpl(functionId, args, memberMappedArg, hasResult, isFnSerializationReqd, isHA, optimizeForWrite, groups, allServers);
        try {
            if (allServers && groups.length == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ExecuteFunctionNoAckOp#execute : Sending Function Execution Message:" + op.getMessage() + " to all servers using pool: " + pool);
                }
                servers = pool.getCurrentServers();
                Iterator<ServerLocation> i = servers.iterator();
                while (i.hasNext()) {
                    pool.executeOn(i.next(), (Op)op);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("ExecuteFunctionNoAckOp#execute : Sending Function Execution Message:" + op.getMessage() + " to server using pool: " + pool + " with groups:" + Arrays.toString(groups) + " all members:" + allServers);
                }
                pool.execute(op, 0);
            }
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("ExecuteFunctionNoAckOp#execute : Exception occured while Sending Function Execution Message:" + op.getMessage() + " to server using pool: " + pool, (Throwable)ex);
            }
            if (ex.getMessage() != null) {
                throw new FunctionException(ex.getMessage(), ex);
            }
            throw new FunctionException("Unexpected exception during function execution:", ex);
        }
    }

    private static class ExecuteFunctionNoAckOpImpl
    extends AbstractOp {
        private static final int MSG_PARTS = 6;

        public ExecuteFunctionNoAckOpImpl(Function function, Object args, MemberMappedArgument memberMappedArg, byte hasResult, boolean isFnSerializationReqd, String[] groups, boolean allMembers) {
            super(62, 6);
            byte functionState = AbstractExecution.getFunctionState(function.isHA(), function.hasResult(), function.optimizeForWrite());
            this.getMessage().addBytesPart(new byte[]{functionState});
            if (isFnSerializationReqd) {
                this.getMessage().addStringOrObjPart(function);
            } else {
                this.getMessage().addStringOrObjPart(function.getId());
            }
            this.getMessage().addObjPart(args);
            this.getMessage().addObjPart(memberMappedArg);
            this.getMessage().addObjPart(groups);
            this.getMessage().addBytesPart(ExecuteFunctionOp.getByteArrayForFlags(allMembers));
        }

        public ExecuteFunctionNoAckOpImpl(String functionId, Object args, MemberMappedArgument memberMappedArg, byte hasResult, boolean isFnSerializationReqd, boolean isHA, boolean optimizeForWrite, String[] groups, boolean allMembers) {
            super(62, 6);
            this.getMessage().addBytesPart(new byte[]{AbstractExecution.getFunctionState(isHA, hasResult == 1, optimizeForWrite)});
            this.getMessage().addStringOrObjPart(functionId);
            this.getMessage().addObjPart(args);
            this.getMessage().addObjPart(memberMappedArg);
            this.getMessage().addObjPart(groups);
            this.getMessage().addBytesPart(ExecuteFunctionOp.getByteArrayForFlags(allMembers));
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            int msgType = msg.getMessageType();
            if (msgType == 6) {
                return null;
            }
            Part part = msg.getPart(0);
            if (msgType == 2) {
                Throwable t = (Throwable)part.getObject();
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.EXECUTE_FUNCTION_NO_HAS_RESULT_RECEIVED_EXCEPTION), t);
            } else if (this.isErrorResponse(msgType)) {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.EXECUTE_FUNCTION_NO_HAS_RESULT_RECEIVED_EXCEPTION));
            } else {
                throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
            }
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 64;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startExecuteFunction();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endExecuteFunctionSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endExecuteFunction(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected Message createResponseMessage() {
            return new Message(1, Version.CURRENT);
        }
    }
}

