/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.GatewayConfigurationException;
import com.gemstone.gemfire.cache.client.ServerRefusedConnectionException;
import com.gemstone.gemfire.cache.client.internal.AuthenticateUserOp;
import com.gemstone.gemfire.cache.client.internal.ClientUpdater;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionFactory;
import com.gemstone.gemfire.cache.client.internal.ConnectionImpl;
import com.gemstone.gemfire.cache.client.internal.ConnectionSource;
import com.gemstone.gemfire.cache.client.internal.Endpoint;
import com.gemstone.gemfire.cache.client.internal.EndpointManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.QueueManager;
import com.gemstone.gemfire.cache.client.internal.ServerBlackList;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientUpdater;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.HandShake;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    private static final Logger logger = LogService.getLogger();
    private final HandShake handshake;
    private final int socketBufferSize;
    private final int handShakeTimeout;
    private final boolean usedByGateway;
    private final ServerBlackList blackList;
    private final CancelCriterion cancelCriterion;
    private final SocketCreator socketCreator;
    private ConnectionSource source;
    private int readTimeout;
    private InternalDistributedSystem ds;
    private EndpointManager endpointManager;
    private GatewaySender gatewaySender;
    private PoolImpl pool;
    public static boolean testFailedConnectionToServer = false;

    public ConnectionFactoryImpl(ConnectionSource source, EndpointManager endpointManager, InternalDistributedSystem sys, int socketBufferSize, int handShakeTimeout, int readTimeout, ClientProxyMembershipID proxyId, CancelCriterion cancelCriterion, boolean usedByGateway, GatewaySender sender, long pingInterval, boolean multiuserSecureMode, PoolImpl pool) {
        this.handshake = new HandShake(proxyId, sys);
        this.handshake.setClientReadTimeout(readTimeout);
        this.source = source;
        this.endpointManager = endpointManager;
        this.ds = sys;
        this.socketBufferSize = socketBufferSize;
        this.handShakeTimeout = handShakeTimeout;
        this.handshake.setMultiuserSecureMode(multiuserSecureMode);
        this.readTimeout = readTimeout;
        this.usedByGateway = usedByGateway;
        this.gatewaySender = sender;
        this.blackList = new ServerBlackList(pingInterval);
        this.cancelCriterion = cancelCriterion;
        this.pool = pool;
        DistributionConfig config = InternalDistributedSystem.getConnectedInstance().getConfig();
        if (this.usedByGateway || this.gatewaySender != null) {
            this.socketCreator = SocketCreator.createNonDefaultInstance(config.getGatewaySSLEnabled(), config.getGatewaySSLRequireAuthentication(), config.getGatewaySSLProtocols(), config.getGatewaySSLCiphers(), config.getGatewaySSLProperties());
            if (sender != null && !sender.getGatewayTransportFilters().isEmpty()) {
                this.socketCreator.initializeTransportFilterClientSocketFactory(sender);
            }
        } else {
            this.socketCreator = SocketCreator.createNonDefaultInstance(config.getServerSSLEnabled(), config.getServerSSLRequireAuthentication(), config.getServerSSLProtocols(), config.getServerSSLCiphers(), config.getServerSSLProperties());
        }
    }

    public void start(ScheduledExecutorService background) {
        this.blackList.start(background);
    }

    private byte getCommMode(boolean forQueue) {
        if (this.usedByGateway || this.gatewaySender != null) {
            return 103;
        }
        if (forQueue) {
            return 107;
        }
        return 100;
    }

    @Override
    public ServerBlackList getBlackList() {
        return this.blackList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection createClientToServerConnection(ServerLocation location, boolean forQueue) throws GemFireSecurityException {
        ConnectionImpl connection = new ConnectionImpl(this.ds, this.cancelCriterion);
        ServerBlackList.FailureTracker failureTracker = this.blackList.getFailureTracker(location);
        boolean initialized = false;
        try {
            HandShake connHandShake = new HandShake(this.handshake);
            connection.connect(this.endpointManager, location, connHandShake, this.socketBufferSize, this.handShakeTimeout, this.readTimeout, this.getCommMode(forQueue), this.gatewaySender, this.socketCreator);
            failureTracker.reset();
            connection.setHandShake(connHandShake);
            this.authenticateIfRequired(connection);
            initialized = true;
        }
        catch (CancelException e) {
            throw e;
        }
        catch (GemFireSecurityException e) {
            throw e;
        }
        catch (GatewayConfigurationException e) {
            throw e;
        }
        catch (ServerRefusedConnectionException src) {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_COULD_NOT_CREATE_A_NEW_CONNECTION_TO_SERVER_0, src.getMessage()));
            testFailedConnectionToServer = true;
            throw src;
        }
        catch (Exception e) {
            if (e.getMessage() != null && (e.getMessage().equals("Connection refused") || e.getMessage().equals("Connection reset"))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unable to connect to {}: connection refused", new Object[]{location});
                }
            } else {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.ConnectException_COULD_NOT_CONNECT_TO_0, location), (Throwable)e);
            }
            testFailedConnectionToServer = true;
        }
        finally {
            if (!initialized) {
                connection.destroy();
                failureTracker.addFailure();
                connection = null;
            }
        }
        return connection;
    }

    private void authenticateIfRequired(Connection conn) {
        ServerLocation server;
        this.cancelCriterion.checkCancelInProgress(null);
        if (!this.pool.isUsedByGateway() && !this.pool.getMultiuserAuthentication() && (server = conn.getServer()).getRequiresCredentials() && server.getUserId() == -1L) {
            Long uniqueID = (Long)AuthenticateUserOp.executeOn(conn, this.pool);
            server.setUserId(uniqueID);
            if (logger.isDebugEnabled()) {
                logger.debug("CFI.authenticateIfRequired() Completed authentication on {}", new Object[]{conn});
            }
        }
    }

    @Override
    public ServerLocation findBestServer(ServerLocation currentServer, Set excludedServers) {
        if (currentServer != null && this.source.isBalanced()) {
            return currentServer;
        }
        HashSet origExcludedServers = excludedServers;
        excludedServers = new HashSet(excludedServers);
        Set blackListedServers = this.blackList.getBadServers();
        excludedServers.addAll(blackListedServers);
        ServerLocation server = this.source.findReplacementServer(currentServer, excludedServers);
        if (server == null && excludedServers.size() > origExcludedServers.size()) {
            server = this.source.findReplacementServer(currentServer, origExcludedServers);
        }
        if (server == null && logger.isDebugEnabled()) {
            logger.debug("Source was unable to findForReplacement any servers");
        }
        return server;
    }

    @Override
    public Connection createClientToServerConnection(Set excludedServers) throws GemFireSecurityException {
        HashSet origExcludedServers = excludedServers;
        excludedServers = new HashSet(excludedServers);
        Set blackListedServers = this.blackList.getBadServers();
        excludedServers.addAll(blackListedServers);
        Connection conn = null;
        ServerRefusedConnectionException fatalException = null;
        boolean tryBlackList = true;
        do {
            ServerLocation server;
            if ((server = this.source.findServer(excludedServers)) == null) {
                if (tryBlackList) {
                    tryBlackList = false;
                    int size = excludedServers.size();
                    excludedServers.removeAll(blackListedServers);
                    excludedServers.addAll(origExcludedServers);
                    if (excludedServers.size() < size) continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Source was unable to locate any servers");
                }
                if (fatalException != null) {
                    throw fatalException;
                }
                return null;
            }
            try {
                conn = this.createClientToServerConnection(server, false);
            }
            catch (CancelException e) {
                throw e;
            }
            catch (GemFireSecurityException e) {
                throw e;
            }
            catch (GatewayConfigurationException e) {
                throw e;
            }
            catch (ServerRefusedConnectionException srce) {
                fatalException = srce;
                if (logger.isDebugEnabled()) {
                    logger.debug("ServerRefusedConnectionException attempting to connect to {}", new Object[]{server, srce});
                }
            }
            catch (Exception e) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.ConnectException_COULD_NOT_CONNECT_TO_0, server), (Throwable)e);
            }
            excludedServers.add(server);
        } while (conn == null);
        return conn;
    }

    @Override
    public ClientUpdater createServerToClientConnection(Endpoint endpoint, QueueManager qManager, boolean isPrimary, ClientUpdater failedUpdater) {
        CacheClientUpdater updater;
        String clientUpdateName = "Cache Client Updater Thread  on " + endpoint.getMemberId() + " port " + endpoint.getLocation().getPort();
        if (logger.isDebugEnabled()) {
            logger.debug("Establishing: {}", new Object[]{clientUpdateName});
        }
        if (!(updater = new CacheClientUpdater(clientUpdateName, endpoint.getLocation(), isPrimary, this.ds, new HandShake(this.handshake), qManager, this.endpointManager, endpoint, this.handShakeTimeout, this.socketCreator)).isConnected()) {
            return null;
        }
        updater.setFailedUpdater(failedUpdater);
        updater.start();
        return updater;
    }
}

