/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;

public class CloseConnectionOp {
    public static void execute(Connection con, boolean keepAlive) throws Exception {
        CloseConnectionOpImpl op = new CloseConnectionOpImpl(keepAlive);
        con.execute(op);
    }

    private CloseConnectionOp() {
    }

    private static class CloseConnectionOpImpl
    extends AbstractOp {
        public CloseConnectionOpImpl(boolean keepAlive) {
            super(18, 1);
            this.getMessage().addRawPart(new byte[]{(byte)(keepAlive ? 1 : 0)}, false);
        }

        @Override
        protected Message createResponseMessage() {
            return null;
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            throw new IllegalStateException("should never be called");
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startCloseCon();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endCloseConSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endCloseCon(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

