/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.server.ServerLoad;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.SerialDistributionMessage;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.distributed.internal.ServerLocator;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CacheServerLoadMessage
extends SerialDistributionMessage {
    protected ServerLoad load;
    protected ServerLocation location;
    protected ArrayList clientIds;

    public CacheServerLoadMessage() {
    }

    public CacheServerLoadMessage(ServerLoad load, ServerLocation location, ArrayList clientIds) {
        this.load = load;
        this.location = location;
        this.clientIds = clientIds;
    }

    @Override
    protected void process(DistributionManager dm) {
        this.updateLocalLocators();
    }

    public void updateLocalLocators() {
        List<Locator> locators = Locator.getLocators();
        for (int i = 0; i < locators.size(); ++i) {
            InternalLocator l = (InternalLocator)locators.get(i);
            ServerLocator serverLocator = l.getServerLocatorAdvisee();
            if (serverLocator == null) continue;
            serverLocator.updateLoad(this.location, this.load, this.clientIds);
        }
    }

    @Override
    public int getDSFID() {
        return 24;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.load = new ServerLoad();
        InternalDataSerializer.invokeFromData(this.load, in);
        this.location = new ServerLocation();
        InternalDataSerializer.invokeFromData(this.location, in);
        this.clientIds = DataSerializer.readArrayList(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        InternalDataSerializer.invokeToData(this.load, out);
        InternalDataSerializer.invokeToData(this.location, out);
        DataSerializer.writeArrayList(this.clientIds, out);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

