/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache;

import java.io.ObjectStreamException;
import java.io.Serializable;

public final class Operation
implements Serializable {
    private static final long serialVersionUID = -7521751729852504238L;
    private static byte nextOrdinal = 0;
    private static final Operation[] VALUES = new Operation[55];
    private static final byte OP_TYPE_CREATE = 1;
    private static final byte OP_TYPE_UPDATE = 2;
    private static final byte OP_TYPE_GET = 3;
    private static final byte OP_TYPE_INVALIDATE = 4;
    private static final byte OP_TYPE_GET_ENTRY = 5;
    private static final byte OP_TYPE_CONTAINS_KEY = 6;
    private static final byte OP_TYPE_CONTAINS_VALUE = 7;
    private static final byte OP_TYPE_DESTROY = 8;
    private static final byte OP_TYPE_CONTAINS_VALUE_FOR_KEY = 9;
    private static final byte OP_TYPE_FUNCTION_EXECUTION = 10;
    private static final byte OP_TYPE_CLEAR = 16;
    private static final byte OP_TYPE_MARKER = 32;
    private static final byte OP_TYPE_UPDATE_VERSION = 11;
    private static final int OP_DETAILS_NONE = 0;
    private static final int OP_DETAILS_SEARCH = 1;
    private static final int OP_DETAILS_LOCAL_LOAD = 2;
    private static final int OP_DETAILS_NET_LOAD = 4;
    private static final int OP_DETAILS_EXPIRE = 8;
    private static final int OP_DETAILS_EVICT = 16;
    private static final int OP_DETAILS_PUTALL = 32;
    private static final int OP_DETAILS_GUARANTEES_OLD_VALUE = 64;
    private static final int OP_DETAILS_REMOVEALL = 128;
    public static final Operation MARKER = new Operation("MARKER", false, false, 32, 0);
    public static final Operation CREATE = new Operation("CREATE", false, false, 1, 0);
    public static final Operation PUTALL_CREATE = new Operation("PUTALL_CREATE", false, false, 1, 32);
    public static final Operation GET = new Operation("GET", false, false, 3, 0);
    public static final Operation GET_ENTRY = new Operation("GET_ENTRY", false, false, 5, 0);
    public static final Operation CONTAINS_KEY = new Operation("CONTAINS_KEY", false, false, 6, 0);
    public static final Operation CONTAINS_VALUE = new Operation("CONTAINS_VALUE", false, false, 7, 0);
    public static final Operation CONTAINS_VALUE_FOR_KEY = new Operation("CONTAINS_VALUE_FOR_KEY", false, false, 9, 0);
    public static final Operation FUNCTION_EXECUTION = new Operation("FUNCTION_EXECUTION", false, false, 10, 0);
    public static final Operation SEARCH_CREATE = new Operation("SEARCH_CREATE", false, false, 1, 1);
    public static final Operation LOCAL_LOAD_CREATE = new Operation("LOCAL_LOAD_CREATE", false, false, 1, 2);
    public static final Operation NET_LOAD_CREATE = new Operation("NET_LOAD_CREATE", false, false, 1, 4);
    public static final Operation UPDATE = new Operation("UPDATE", false, false, 2, 0);
    public static final Operation PUTALL_UPDATE = new Operation("PUTALL_UPDATE", false, false, 2, 32);
    public static final Operation SEARCH_UPDATE = new Operation("SEARCH_UPDATE", false, false, 2, 1);
    public static final Operation LOCAL_LOAD_UPDATE = new Operation("LOCAL_LOAD_UPDATE", false, false, 2, 2);
    public static final Operation NET_LOAD_UPDATE = new Operation("NET_LOAD_UPDATE", false, false, 2, 4);
    public static final Operation INVALIDATE = new Operation("INVALIDATE", false, false, 4, 0);
    public static final Operation LOCAL_INVALIDATE = new Operation("LOCAL_INVALIDATE", true, false, 4, 0);
    public static final Operation DESTROY = new Operation("DESTROY", false, false, 8, 0);
    public static final Operation LOCAL_DESTROY = new Operation("LOCAL_DESTROY", true, false, 8, 0);
    public static final Operation EVICT_DESTROY = new Operation("EVICT_DESTROY", true, false, 8, 16);
    public static final Operation REGION_LOAD_SNAPSHOT = new Operation("REGION_LOAD_SNAPSHOT", false, true, 8, 0);
    public static final Operation REGION_LOCAL_DESTROY = new Operation("REGION_LOCAL_DESTROY", true, true, 8, 0);
    public static final Operation REGION_CREATE = new Operation("REGION_CREATE", true, true, 1, 0);
    public static final Operation REGION_CLOSE = new Operation("REGION_CLOSE", true, true, 8, 0);
    public static final Operation REGION_DESTROY = new Operation("REGION_DESTROY", false, true, 8, 0);
    public static final Operation EXPIRE_DESTROY = new Operation("EXPIRE_DESTROY", false, false, 8, 8);
    public static final Operation EXPIRE_LOCAL_DESTROY = new Operation("EXPIRE_LOCAL_DESTROY", true, false, 8, 8);
    public static final Operation EXPIRE_INVALIDATE = new Operation("EXPIRE_INVALIDATE", false, false, 4, 8);
    public static final Operation EXPIRE_LOCAL_INVALIDATE = new Operation("EXPIRE_LOCAL_INVALIDATE", true, false, 4, 8);
    public static final Operation REGION_EXPIRE_DESTROY = new Operation("REGION_EXPIRE_DESTROY", false, true, 8, 8);
    public static final Operation REGION_EXPIRE_LOCAL_DESTROY = new Operation("REGION_EXPIRE_LOCAL_DESTROY", true, true, 8, 8);
    public static final Operation REGION_EXPIRE_INVALIDATE = new Operation("REGION_EXPIRE_INVALIDATE", false, true, 4, 8);
    public static final Operation REGION_EXPIRE_LOCAL_INVALIDATE = new Operation("REGION_EXPIRE_LOCAL_INVALIDATE", true, true, 4, 8);
    public static final Operation REGION_LOCAL_INVALIDATE = new Operation("REGION_LOCAL_INVALIDATE", true, true, 4, 0);
    public static final Operation REGION_INVALIDATE = new Operation("REGION_INVALIDATE", false, true, 4, 0);
    public static final Operation REGION_CLEAR = new Operation("REGION_CLEAR", false, true, 16, 0);
    public static final Operation REGION_LOCAL_CLEAR = new Operation("REGION_LOCAL_CLEAR", true, true, 16, 0);
    public static final Operation CACHE_CREATE = new Operation("CACHE_CREATE", true, true, 1, 0);
    public static final Operation CACHE_CLOSE = new Operation("CACHE_CLOSE", true, true, 8, 0);
    public static final Operation FORCED_DISCONNECT = new Operation("FORCED_DISCONNECT", true, true, 8, 0);
    public static final Operation REGION_REINITIALIZE = new Operation("REGION_REINITIALIZE", true, true, 8, 0);
    public static final Operation CACHE_RECONNECT = new Operation("CACHE_RECONNECT", true, true, 8, 0);
    public static final Operation PUT_IF_ABSENT = new Operation("PUT_IF_ABSENT", false, false, 1, 64);
    public static final Operation REPLACE = new Operation("REPLACE", false, false, 2, 64);
    public static final Operation REMOVE = new Operation("REMOVE", false, false, 8, 0);
    public static final Operation UPDATE_VERSION_STAMP = new Operation("UPDATE_VERSION", false, false, 11, 0);
    public static final Operation REMOVEALL_DESTROY = new Operation("REMOVEALL_DESTROY", false, false, 8, 128);
    public static final Operation CUSTOM_EVICT_DESTROY = new Operation("EVICT_DESTROY", false, false, 8, 16);
    private final transient String name;
    public final byte ordinal;
    private final transient boolean isLocal;
    private final transient boolean isRegion;
    private final transient byte opType;
    private final transient int opDetails;

    private Object readResolve() throws ObjectStreamException {
        return VALUES[this.ordinal];
    }

    private Operation(String name, boolean isLocal, boolean isRegion, byte opType, int opDetails) {
        this.name = name;
        this.isLocal = isLocal;
        this.isRegion = isRegion;
        this.opType = opType;
        this.opDetails = opDetails;
        byte by = nextOrdinal;
        nextOrdinal = (byte)(by + 1);
        this.ordinal = by;
        Operation.VALUES[this.ordinal] = this;
    }

    public static Operation fromOrdinal(byte ordinal) {
        return VALUES[ordinal];
    }

    public boolean isCreate() {
        return this.opType == 1 && this.isEntry();
    }

    public boolean isUpdate() {
        return this.opType == 2 && this.isEntry();
    }

    public boolean isGet() {
        return this.opType == 3;
    }

    public boolean isContainsKey() {
        return this.opType == 6;
    }

    public boolean isContainsValue() {
        return this.opType == 7;
    }

    public boolean isContainsValueForKey() {
        return this.opType == 9;
    }

    public boolean isFunctionExecution() {
        return this.opType == 10;
    }

    public boolean isGetEntry() {
        return this.opType == 5;
    }

    public boolean isInvalidate() {
        return this.opType == 4 && this.isEntry();
    }

    public boolean isDestroy() {
        return this.opType == 8 && this.isEntry();
    }

    public boolean isClear() {
        return this.opType == 16;
    }

    public boolean isClose() {
        return this == REGION_CLOSE || this == CACHE_CLOSE || this == CACHE_RECONNECT || this == FORCED_DISCONNECT;
    }

    public boolean isPutAll() {
        return (this.opDetails & 0x20) != 0;
    }

    public boolean isRemoveAll() {
        return (this.opDetails & 0x80) != 0;
    }

    public boolean isRegionInvalidate() {
        return this.opType == 4 && this.isRegion();
    }

    public boolean isRegionDestroy() {
        return this.opType == 8 && this.isRegion();
    }

    public boolean isRegion() {
        return this.isRegion;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isDistributed() {
        return !this.isLocal();
    }

    public boolean isEntry() {
        return !this.isRegion();
    }

    public boolean isExpiration() {
        return (this.opDetails & 8) != 0;
    }

    public boolean isEviction() {
        return (this.opDetails & 0x10) != 0;
    }

    public boolean isLocalLoad() {
        return (this.opDetails & 2) != 0;
    }

    public boolean isNetLoad() {
        return (this.opDetails & 4) != 0;
    }

    public boolean isLoad() {
        return (this.opDetails & 6) != 0;
    }

    public boolean isNetSearch() {
        return (this.opDetails & 1) != 0;
    }

    public boolean isSearchOrLoad() {
        return (this.opDetails & 7) != 0;
    }

    public boolean guaranteesOldValue() {
        return (this.opDetails & 0x40) != 0;
    }

    public Operation getCorrespondingUpdateOp() {
        if (this.isCreate()) {
            switch (this.opDetails) {
                case 1: {
                    return SEARCH_UPDATE;
                }
                case 2: {
                    return LOCAL_LOAD_UPDATE;
                }
                case 4: {
                    return NET_LOAD_UPDATE;
                }
                case 32: {
                    return PUTALL_UPDATE;
                }
            }
            return UPDATE;
        }
        return this;
    }

    public Operation getCorrespondingCreateOp() {
        if (this.isUpdate()) {
            switch (this.opDetails) {
                case 1: {
                    return SEARCH_CREATE;
                }
                case 2: {
                    return LOCAL_LOAD_CREATE;
                }
                case 4: {
                    return NET_LOAD_CREATE;
                }
                case 32: {
                    return PUTALL_CREATE;
                }
            }
            return CREATE;
        }
        return this;
    }

    public String toString() {
        return this.name;
    }
}

