/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ExpirationAttributes
implements DataSerializable {
    private static final long serialVersionUID = 5956885652945706394L;
    public static final ExpirationAttributes DEFAULT = new ExpirationAttributes();
    private int timeout;
    private ExpirationAction action;

    public ExpirationAttributes() {
        this.timeout = 0;
        this.action = ExpirationAction.INVALIDATE;
    }

    public ExpirationAttributes(int expirationTime) {
        this.timeout = expirationTime;
        this.action = ExpirationAction.INVALIDATE;
    }

    public ExpirationAttributes(int expirationTime, ExpirationAction expirationAction) {
        this.timeout = expirationTime;
        this.action = expirationAction;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ExpirationAction getAction() {
        return this.action;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExpirationAttributes)) {
            return false;
        }
        ExpirationAttributes ea = (ExpirationAttributes)obj;
        return this.timeout == ea.timeout && this.action == ea.action;
    }

    public int hashCode() {
        return this.timeout ^ this.action.hashCode();
    }

    public String toString() {
        if (this.timeout == 0) {
            return "NO EXPIRATION";
        }
        return "timeout: " + this.timeout + ";action: " + this.action;
    }

    public static ExpirationAttributes createFromData(DataInput in) throws IOException, ClassNotFoundException {
        ExpirationAttributes result = new ExpirationAttributes();
        InternalDataSerializer.invokeFromData(result, in);
        return result;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.timeout = in.readInt();
        this.action = (ExpirationAction)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.timeout);
        DataSerializer.writeObject(this.action, out);
    }
}

