/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache;

import javax.print.attribute.EnumSyntax;

public final class EvictionAction
extends EnumSyntax {
    private static final long serialVersionUID = -98840597493242980L;
    public static final EvictionAction NONE = new EvictionAction(0);
    public static final EvictionAction LOCAL_DESTROY = new EvictionAction(1);
    public static final EvictionAction OVERFLOW_TO_DISK = new EvictionAction(2);
    public static final EvictionAction DEFAULT_EVICTION_ACTION = LOCAL_DESTROY;
    private static final String[] stringTable = new String[]{"none", "local-destroy", "overflow-to-disk"};
    private static EvictionAction[] enumValueTable = new EvictionAction[]{NONE, LOCAL_DESTROY, OVERFLOW_TO_DISK};

    private EvictionAction(int val) {
        super(val);
    }

    @Override
    protected final String[] getStringTable() {
        return stringTable;
    }

    @Override
    protected final EnumSyntax[] getEnumValueTable() {
        return enumValueTable;
    }

    public final boolean isLocalDestroy() {
        return this == LOCAL_DESTROY;
    }

    public final boolean isOverflowToDisk() {
        return this == OVERFLOW_TO_DISK;
    }

    public final boolean isNone() {
        return this == NONE;
    }

    public static EvictionAction parseValue(int v) {
        if (v < 0 || v >= enumValueTable.length) {
            return null;
        }
        return enumValueTable[v];
    }

    public static EvictionAction parseAction(String s) {
        if (s == null) {
            return NONE;
        }
        if (s.length() < 1) {
            return NONE;
        }
        for (int i = 0; i < stringTable.length; ++i) {
            if (!s.equals(stringTable[i])) continue;
            return enumValueTable[i];
        }
        return NONE;
    }
}

