/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.jmx.internal;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.UnmodifiableConfigurationException;
import com.gemstone.gemfire.admin.internal.ConfigurationParameterImpl;
import com.gemstone.gemfire.admin.jmx.internal.MBeanUtil;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.logging.log4j.Level;

public class ConfigurationParameterJmxImpl
extends ConfigurationParameterImpl
implements Serializable {
    private static final long serialVersionUID = -7822171853906772375L;
    private boolean deserialized = false;

    protected ConfigurationParameterJmxImpl(String name, String description, Object value, Class type, boolean userModifiable) {
        super(name, description, value, type, userModifiable);
    }

    protected ConfigurationParameterJmxImpl(String name, Object value) {
        super(name, value);
    }

    protected ConfigurationParameterJmxImpl() {
    }

    @Override
    public void setValue(Object value) throws UnmodifiableConfigurationException {
        if (this.deserialized) {
            throw new UnsupportedOperationException(LocalizedStrings.ConfigurationParameterJmxImpl_REMOTE_MUTATION_OF_CONFIGURATIONPARAMETER_IS_CURRENTLY_UNSUPPORTED.toLocalizedString());
        }
        try {
            super.setValue(value);
        }
        catch (UnmodifiableConfigurationException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
            throw e;
        }
        catch (RuntimeException e) {
            MBeanUtil.logStackTrace(Level.WARN, e);
            throw e;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
            MBeanUtil.logStackTrace(Level.ERROR, e);
            throw e;
        }
    }

    public void setJmxValue(Integer value) throws UnmodifiableConfigurationException {
        this.setValue(value);
    }

    public void setJmxValue(String value) throws UnmodifiableConfigurationException {
        this.setValue(value);
    }

    public void setJmxValue(File value) throws UnmodifiableConfigurationException {
        this.setValue(value);
    }

    public void setJmxValue(Boolean value) throws UnmodifiableConfigurationException {
        this.setValue(value);
    }

    public Class getJmxValueType() {
        if (this.isInetAddress() || this.isFile() || this.isOctal()) {
            return String.class;
        }
        return this.getValueType();
    }

    public Object getJmxValue() {
        if (this.isInetAddress() || this.isFile() || this.isOctal()) {
            return this.getValueAsString();
        }
        return this.getValue();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.description);
        out.writeObject(this.value);
        out.writeObject(this.type);
        out.writeBoolean(this.userModifiable);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String inName = (String)in.readObject();
        String inDescription = (String)in.readObject();
        Object inValue = in.readObject();
        Class inClass = (Class)in.readObject();
        boolean inUserModifiable = in.readBoolean();
        Assert.assertTrue(inName != null);
        Assert.assertTrue(inDescription != null);
        Assert.assertTrue(inValue != null);
        Assert.assertTrue(inClass != null);
        this.deserialized = true;
        this.name = inName;
        this.setInternalState(inDescription, inValue, inClass, inUserModifiable);
    }
}

