/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.logging.log4j.Logger;

@Deprecated
public class InetAddressUtil {
    private static final Logger logger = LogService.getLogger();
    public static final InetAddress LOCALHOST = InetAddressUtil.createLocalHost();
    public static final String LOOPBACK_ADDRESS = SocketCreator.preferIPv6Addresses() ? "::1" : "127.0.0.1";
    public static final InetAddress LOOPBACK = InetAddressUtil.toInetAddress(LOOPBACK_ADDRESS);

    private InetAddressUtil() {
    }

    public static String toString(Object val) {
        if (val instanceof String) {
            return InetAddressUtil.trimLeadingSlash((String)val);
        }
        if (val instanceof InetAddress) {
            return ((InetAddress)val).getHostAddress();
        }
        return InetAddressUtil.trimLeadingSlash(val.toString());
    }

    public static InetAddress toInetAddress(String host) {
        if (host == null || host.length() == 0) {
            return null;
        }
        try {
            if (host.indexOf("/") > -1) {
                return InetAddress.getByName(host.substring(host.indexOf("/") + 1));
            }
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            InetAddressUtil.logStackTrace(e);
            Assert.assertTrue(false, "Failed to get InetAddress: " + host);
            return null;
        }
    }

    public static InetAddress createLocalHost() {
        try {
            return SocketCreator.getLocalHost();
        }
        catch (UnknownHostException e) {
            InetAddressUtil.logStackTrace(e);
            Assert.assertTrue(false, "Failed to get local host");
            return null;
        }
    }

    public static String validateHost(String host) {
        if (host == null || host.length() == 0) {
            return null;
        }
        try {
            InetAddress.getByName(InetAddressUtil.trimLeadingSlash(host));
            return host;
        }
        catch (UnknownHostException e) {
            InetAddressUtil.logStackTrace(e);
            return null;
        }
    }

    public static boolean isLocalHost(Object host) {
        if (host instanceof InetAddress) {
            if (LOCALHOST.equals(host)) {
                return true;
            }
            try {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface i = en.nextElement();
                    Enumeration<InetAddress> en2 = i.getInetAddresses();
                    while (en2.hasMoreElements()) {
                        InetAddress addr = en2.nextElement();
                        if (!host.equals(addr)) continue;
                        return true;
                    }
                }
                return false;
            }
            catch (SocketException e) {
                throw new GemFireIOException(LocalizedStrings.InetAddressUtil_UNABLE_TO_QUERY_NETWORK_INTERFACE.toLocalizedString(), e);
            }
        }
        return InetAddressUtil.isLocalHost(InetAddressUtil.toInetAddress(host.toString()));
    }

    public static boolean isLoopback(Object host) {
        if (host instanceof InetAddress) {
            return LOOPBACK.equals(host);
        }
        return InetAddressUtil.isLoopback(InetAddressUtil.toInetAddress(host.toString()));
    }

    private static String trimLeadingSlash(String value) {
        if (value == null) {
            return "";
        }
        while (value.indexOf("/") > -1) {
            value = value.substring(value.indexOf("/") + 1);
        }
        return value;
    }

    private static void logStackTrace(Throwable throwable) {
        AdminDistributedSystemImpl adminDS = AdminDistributedSystemImpl.getConnectedInstance();
        logger.warn(throwable.getMessage(), throwable);
    }
}

