/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.admin.internal.AbstractHealthEvaluator;
import com.gemstone.gemfire.admin.internal.CacheHealthEvaluator;
import com.gemstone.gemfire.admin.internal.MemberHealthEvaluator;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class GemFireHealthEvaluator {
    private static final Logger logger = LogService.getLogger();
    private GemFireHealthConfig config;
    private MemberHealthEvaluator memberHealth;
    private CacheHealthEvaluator cacheHealth;
    private List okayDiagnoses;
    private List poorDiagnoses;

    public GemFireHealthEvaluator(GemFireHealthConfig config, DistributionManager dm) {
        if (config == null) {
            throw new NullPointerException(LocalizedStrings.GemFireHealthEvaluator_NULL_GEMFIREHEALTHCONFIG.toLocalizedString());
        }
        this.config = config;
        this.memberHealth = new MemberHealthEvaluator(config, dm);
        this.cacheHealth = new CacheHealthEvaluator(config, dm);
        this.okayDiagnoses = new ArrayList();
        this.poorDiagnoses = new ArrayList();
    }

    public GemFireHealth.Health evaluate() {
        ArrayList status = new ArrayList();
        this.memberHealth.evaluate(status);
        this.cacheHealth.evaluate(status);
        GemFireHealth.Health overallHealth = GemFireHealth.GOOD_HEALTH;
        this.okayDiagnoses.clear();
        this.poorDiagnoses.clear();
        for (AbstractHealthEvaluator.HealthStatus health : status) {
            GemFireHealth.Health healthCode;
            if (overallHealth == GemFireHealth.GOOD_HEALTH) {
                if (health.getHealthCode() != GemFireHealth.GOOD_HEALTH) {
                    overallHealth = health.getHealthCode();
                }
            } else if (overallHealth == GemFireHealth.OKAY_HEALTH && health.getHealthCode() == GemFireHealth.POOR_HEALTH) {
                overallHealth = GemFireHealth.POOR_HEALTH;
            }
            if ((healthCode = health.getHealthCode()) == GemFireHealth.OKAY_HEALTH) {
                this.okayDiagnoses.add(health.getDiagnosis());
                continue;
            }
            if (healthCode != GemFireHealth.POOR_HEALTH) continue;
            this.poorDiagnoses.add(health.getDiagnosis());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Evaluated health to be {}", new Object[]{overallHealth});
        }
        return overallHealth;
    }

    public String[] getDiagnosis(GemFireHealth.Health healthCode) {
        if (healthCode == GemFireHealth.GOOD_HEALTH) {
            return new String[0];
        }
        if (healthCode == GemFireHealth.OKAY_HEALTH) {
            String[] array = new String[this.okayDiagnoses.size()];
            this.okayDiagnoses.toArray(array);
            return array;
        }
        Assert.assertTrue(healthCode == GemFireHealth.POOR_HEALTH);
        String[] array = new String[this.poorDiagnoses.size()];
        this.poorDiagnoses.toArray(array);
        return array;
    }

    public void reset() {
        this.okayDiagnoses.clear();
        this.poorDiagnoses.clear();
    }

    public int getEvaluationInterval() {
        return this.config.getHealthEvaluationInterval();
    }

    public void close() {
        this.memberHealth.close();
        this.cacheHealth.close();
    }
}

