/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.admin.internal.FlushToDiskResponse;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.internal.admin.remote.AdminMultipleReplyProcessor;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.CliLegacyMessage;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import java.util.Collection;
import java.util.Set;

public class FlushToDiskRequest
extends CliLegacyMessage {
    public static void send(DM dm, Set recipients) {
        FlushToDiskRequest request = new FlushToDiskRequest();
        request.setRecipients(recipients);
        FlushToDiskProcessor replyProcessor = new FlushToDiskProcessor(dm, (Collection)recipients);
        request.msgId = replyProcessor.getProcessorId();
        dm.putOutgoing(request);
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (!(e.getCause() instanceof CancelException)) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        AdminResponse response = request.createResponse((DistributionManager)dm);
        response.setSender(dm.getDistributionManagerId());
        replyProcessor.process(response);
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null) {
            Collection<DiskStoreImpl> diskStores = cache.listDiskStoresIncludingRegionOwned();
            for (DiskStoreImpl store : diskStores) {
                store.flush();
            }
        }
        return new FlushToDiskResponse(this.getSender());
    }

    @Override
    public int getDSFID() {
        return 2126;
    }

    private static class FlushToDiskProcessor
    extends AdminMultipleReplyProcessor {
        public FlushToDiskProcessor(DM dm, Collection initMembers) {
            super(dm, initMembers);
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }
    }
}

