/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.admin;

import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.AlertLevel;
import com.gemstone.gemfire.admin.AlertListener;
import com.gemstone.gemfire.admin.BackupStatus;
import com.gemstone.gemfire.admin.CacheServer;
import com.gemstone.gemfire.admin.CacheVm;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.DistributionLocator;
import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCacheListener;
import com.gemstone.gemfire.admin.SystemMembershipListener;
import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.distributed.DistributedMember;
import java.io.File;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

public interface AdminDistributedSystem {
    public String getId();

    public String getName();

    public String getRemoteCommand();

    public void setRemoteCommand(String var1);

    public void setAlertLevel(AlertLevel var1);

    public AlertLevel getAlertLevel();

    public void setAlertLevelAsString(String var1);

    public String getAlertLevelAsString();

    public void addAlertListener(AlertListener var1);

    public void removeAlertListener(AlertListener var1);

    public String getMcastAddress();

    public int getMcastPort();

    public String getLocators();

    public boolean isMcastEnabled();

    public boolean isRunning();

    public boolean isConnected();

    public void start() throws AdminException;

    public void stop() throws AdminException;

    public String displayMergedLogs();

    public Properties getLicense();

    public DistributionLocator addDistributionLocator();

    public DistributionLocator[] getDistributionLocators();

    public SystemMember[] getSystemMemberApplications() throws AdminException;

    public String getLatestAlert();

    public GemFireHealth getGemFireHealth();

    public void connect();

    public boolean waitToBeConnected(long var1) throws InterruptedException;

    public void disconnect();

    public DistributedSystemConfig getConfig();

    public void addMembershipListener(SystemMembershipListener var1);

    public void removeMembershipListener(SystemMembershipListener var1);

    public void addCacheListener(SystemMemberCacheListener var1);

    public void removeCacheListener(SystemMemberCacheListener var1);

    @Deprecated
    public CacheServer addCacheServer() throws AdminException;

    @Deprecated
    public CacheServer[] getCacheServers() throws AdminException;

    public CacheServer[] getCacheServers(String var1) throws AdminException;

    public CacheVm addCacheVm() throws AdminException;

    public CacheVm[] getCacheVms() throws AdminException;

    public SystemMember lookupSystemMember(DistributedMember var1) throws AdminException;

    public void revokePersistentMember(InetAddress var1, String var2) throws AdminException;

    public void revokePersistentMember(UUID var1) throws AdminException;

    public Set<PersistentID> getMissingPersistentMembers() throws AdminException;

    public Set<DistributedMember> shutDownAllMembers() throws AdminException;

    public Set<DistributedMember> shutDownAllMembers(long var1) throws AdminException;

    public BackupStatus backupAllMembers(File var1) throws AdminException;

    public BackupStatus backupAllMembers(File var1, File var2) throws AdminException;

    public Map<DistributedMember, Set<PersistentID>> compactAllDiskStores() throws AdminException;
}

