/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.springframework.shell.core.ExecutionProcessor;
import org.springframework.shell.core.ExecutionStrategy;
import org.springframework.shell.event.ParseResult;
import org.springframework.shell.support.logging.HandlerUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class SimpleExecutionStrategy
implements ExecutionStrategy {
    private static final Logger logger = HandlerUtils.getLogger(SimpleExecutionStrategy.class);
    private final Class<?> mutex = SimpleExecutionStrategy.class;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(ParseResult parseResult) throws RuntimeException {
        Assert.notNull((Object)parseResult, (String)"Parse result required");
        Class<?> clazz = this.mutex;
        synchronized (clazz) {
            Assert.isTrue((boolean)this.isReadyForCommands(), (String)"SimpleExecutionStrategy not yet ready for commands");
            Object target = parseResult.getInstance();
            if (target instanceof ExecutionProcessor) {
                ExecutionProcessor processor = (ExecutionProcessor)target;
                parseResult = processor.beforeInvocation(parseResult);
                try {
                    Object result = this.invoke(parseResult);
                    processor.afterReturningInvocation(parseResult, result);
                    return result;
                }
                catch (Throwable th) {
                    processor.afterThrowingInvocation(parseResult, th);
                    return this.handleThrowable(th);
                }
            }
            return this.invoke(parseResult);
        }
    }

    private Object invoke(ParseResult parseResult) {
        try {
            return ReflectionUtils.invokeMethod((Method)parseResult.getMethod(), (Object)parseResult.getInstance(), (Object[])parseResult.getArguments());
        }
        catch (Throwable th) {
            logger.severe("Command failed " + th);
            return this.handleThrowable(th);
        }
    }

    private Object handleThrowable(Throwable th) {
        if (th instanceof Error) {
            throw (Error)th;
        }
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        throw new RuntimeException(th);
    }

    @Override
    public boolean isReadyForCommands() {
        return true;
    }

    @Override
    public void terminate() {
    }
}

