
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_TIME_H
#include <time.h>
#endif
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

int fprint_delta(FILE *stream, int seconds)
{
  int len = 0;
  int minutes, hours, days;

  days = seconds / 60 / 60 / 24;

  if (days > 0)
    {
      len += fprintf(stream, "%dd", days);
      seconds -= days * 60 * 60 * 24;
    }

  hours = seconds / 60 / 60;
  if (hours > 0)
    {
      len += fprintf(stream, "%dh", hours);
      seconds -= hours * 60 * 60;
    }

  minutes = seconds / 60;
  if (minutes > 0)
    {
      len += fprintf(stream, "%dm", minutes);
      seconds -= minutes * 60;
    }

  if (seconds > 0)
    len += fprintf(stream, "%ds", seconds);

  return len;
}


