/* gegl.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gegl", lower_case_cprefix = "gegl_")]
namespace Gegl {
	[CCode (cprefix = "GEGL_BLIT_", has_type_id = "0", cheader_filename = "gegl.h")]
	public enum BlitFlags {
		DEFAULT,
		CACHE,
		DIRTY
	}
	[CCode (cprefix = "GEGL_INTERPOLATION_", has_type_id = "0", cheader_filename = "gegl.h")]
	public enum Interpolation {
		NEAREST,
		LINEAR
	}
	[CCode (cprefix = "GEGL_PARAM_PAD_", has_type_id = "0", cheader_filename = "gegl.h")]
	public enum PadType {
		OUTPUT,
		INPUT
	}
	[CCode (cheader_filename = "gegl.h")]
	public class Processor : GLib.Object {
		[CCode (cname = "gegl_node_new_processor")]
		public Processor (Gegl.Node sink, Gegl.Rectangle? rect = null);
		public void destroy ();
		public void set_rectangle (Gegl.Rectangle rectangle);
		public bool work (out double progress);
		[NoAccessorMethod]
		public unowned int chunksize { get; construct; }
		[NoAccessorMethod]
		public unowned Gegl.Node node { set construct; }
		[NoAccessorMethod]
		public unowned double progress { get; set; }
	}
	[CCode (cheader_filename = "gegl.h")]
	public class Node : GLib.Object, Gegl.Visitable {
		public Node ();
		public Node.from_file (string path);
		public Node.from_xml (string xmldata, string path_root);
		public unowned Gegl.Node new_child (...);
		public unowned Gegl.Node create_child (string operation);
		public unowned Gegl.Node adopt_child (Gegl.Node child);
		public unowned Gegl.Node add_child (Gegl.Node child);
		public unowned Gegl.Node remove_child (Gegl.Node child);
		public bool connect_from (string input_pad_name, Gegl.Node source, string output_pad_name);
		public bool connect_to (string output_pad_name, Gegl.Node sink, string input_pad_name);
		public void link (Gegl.Node sink);
		public void link_many (...);
		public bool disconnect (string input_pad);
		public unowned GLib.SList<Gegl.Node> get_children ();
		public int get_consumers (string output_pad, out unowned Gegl.Node nodes, string pads);
		public unowned string get_operation ();
		public unowned Gegl.Node get_input_proxy (string pad_name);
		public unowned Gegl.Node get_output_proxy (string pad_name);
		public unowned Gegl.Node get_parent ();
		public unowned Gegl.Node get_producer (string input_pad_name, string output_pad_name);
		public unowned Gegl.Node detect (int x, int y);
		public Gegl.Rectangle get_bounding_box ();
		public void blit (double scale, Gegl.Rectangle roi, void* format, void* destination_buf, int rowstride, Gegl.BlitFlags flags);
		public void process ();
		public unowned GLib.ParamSpec find_property (string property_name);
		public void get (...);
		public void set (...);
		public void get_property (string property_name, GLib.Value value);
		public void set_property (string property_name, GLib.Value value);
		public unowned string to_xml (string path_root);
		[NoAccessorMethod]
		public unowned string name { get; set construct; }
		[NoAccessorMethod]
		public unowned string operation { get; set construct; }
		public signal void computed (Gegl.Rectangle p0);
		public signal void invalidated (Gegl.Rectangle p0);
	}
	[CCode (cheader_filename = "gegl.h")]
	public struct Point {
	    public float x;
	    public float y;
	}
	[CCode (cheader_filename = "gegl.h")]
	public struct PathItem {
	    public char type;
	    public Point point[4];
	}
	
	[CCode (cheader_filename = "gegl.h")]
	public class Path : GLib.Object {
	    public Path ();
	    public Path.from_string (string instructions);
	    public bool is_empty ();
	    public int get_n_nodes ();
	    public double get_length ();
	    public bool get_node (int index, out unowned Gegl.PathItem node);
	    public unowned string to_string ();
	    public double closest_point (double x, double y, 
	                                 double on_path_x, double on_path_y,
	                                 int node_pos_before);
	    public void calc (double pos, double x, double y);
	    public void calc_values (double num_samples, double xs, double ys);
	    public void get_bounds (out double min_x, out double max_x,
	    						out double min_y, out double max_y);
	    public void clear ();
	    public void insert_node (int pos, Gegl.PathItem node);
	    public void replace_node (int pos, Gegl.PathItem node);
	    public void remove_node (int pos);
	    public void parse_string (string instructions);
	    public void append (...);
	    public void freeze ();
	    public void thaw ();
	    public void add_type (int items, string description);
	    
	}
	[CCode (cheader_filename = "gegl.h")]
	public class Buffer : GLib.Object {
		public void copy (Gegl.Rectangle src_rect, Gegl.Buffer dst, Gegl.Rectangle dst_rect);
		public Gegl.Buffer create_sub_buffer (Gegl.Rectangle extent);
		public void destroy ();
		public Gegl.Buffer dup ();
		public void flush ();
		public void get (double scale, Gegl.Rectangle rect, void* format, void* dest, int rowstride);
		public Gegl.Rectangle get_extent ();
		public static Gegl.Interpolation interpolation_from_string (string str);
		public static unowned Gegl.Buffer load (string path);
		public Buffer (Gegl.Rectangle? extent, void* format);
		public static unowned Gegl.Buffer open (string path);
		public void sample (double x, double y, double scale, void* dest, void* format, Gegl.Interpolation interpolation);
		public void sample_cleanup ();
		public void save (string path, Gegl.Rectangle roi);
		public void set (Gegl.Rectangle rect, void* format, void* src, int rowstride);
		public void* linear_open(Gegl.Rectangle? extent, int? rowstride, Babl.Format format);
		public void linear_close(void* linear);
		public bool set_extent (Gegl.Rectangle extent);
		[NoAccessorMethod]
		public unowned int abyss_height { get; construct; }
		[NoAccessorMethod]
		public unowned int abyss_width { get; construct; }
		[NoAccessorMethod]
		public unowned int abyss_x { get; construct; }
		[NoAccessorMethod]
		public unowned int abyss_y { get; construct; }
		[NoAccessorMethod]
		public unowned void* format { get; set construct; }
		[NoAccessorMethod]
		public unowned int height { get; set construct; }
		[NoAccessorMethod]
		public unowned string path { get; set construct; }
		[NoAccessorMethod]
		public unowned int pixels { get; }
		[NoAccessorMethod]
		public unowned int px_size { get; }
		[NoAccessorMethod]
		public unowned int shift_x { get; construct; }
		[NoAccessorMethod]
		public unowned int shift_y { get; construct; }
		[NoAccessorMethod]
		public unowned int tile_height { get; construct; }
		[NoAccessorMethod]
		public unowned int tile_width { get; construct; }
		[NoAccessorMethod]
		public unowned int width { get; set construct; }
		[NoAccessorMethod]
		public unowned int x { get; set construct; }
		[NoAccessorMethod]
		public unowned int y { get; set construct; }
		public signal void changed (Gegl.Rectangle p0);
		
	}
	[CCode (cheader_filename = "gegl.h")]
	public class Color : GLib.Object {
		public void get_rgba (float r, float g, float b, float a);
		public Color (string str);
		public void set_rgba (float r, float g, float b, float a);
	}
	[CCode (cheader_filename = "gegl.h")]
	public interface Visitable {
	}
	[CCode (cheader_filename = "gegl.h")]
	public struct Rectangle {
		public int x;
		public int y;
		public int width;
		public int height;
		public void bounding_box (Gegl.Rectangle src1, Gegl.Rectangle src2);
		public bool contains (Gegl.Rectangle s);
		public bool equal (Gegl.Rectangle s);
		public bool equal_coords (int x, int y, int width, int height);
		public bool intersect (Gegl.Rectangle src1, Gegl.Rectangle src2);
		public void set (int x, int y, uint width, uint height);
	}
	public const int AUTO_ROWSTRIDE;
	public const int MAJOR_VERSION;
	public const int MICRO_VERSION;
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "gegl.h")]
	public static unowned GLib.Object config ();
	[CCode (cheader_filename = "gegl.h")]
	public static void exit ();
	[CCode (cheader_filename = "gegl.h")]
	public static void get_version (int major, int minor, int micro);
	[CCode (cheader_filename = "gegl.h")]
	public static void init ([CCode (array_length_pos = 0.9)] ref unowned string[] argv);
}
