static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2010 Danny Robson      <danny@blubinc.net>                       \n"
" * (pfstmo)  2007 Grzegorz Krawczyk <krawczyk@mpi-sb.mpg.de>                  \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (brightness, _(\"Brightness\"), 0.0)                          \n"
"    description(_(\"Overall brightness of the image\"))                       \n"
"    value_range (-100.0, 100.0)                                               \n"
"                                                                              \n"
"property_double (chromatic, _(\"Chromatic adaptation\"), 0.0)                 \n"
"    description(_(\"Adaptation to color variation across the image\"))        \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (light, _(\"Light adaptation\"), 1.0)                         \n"
"    description(_(\"Adaptation to light variation across the image\"))        \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_C_SOURCE reinhard05.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"                                                                              \n"
"typedef struct {                                                              \n"
"  gfloat min, max, avg, range;                                                \n"
"  guint  num;                                                                 \n"
"} stats;                                                                      \n"
"                                                                              \n"
"                                                                              \n"
"static const gchar *OUTPUT_FORMAT = \"RGBA float\";                           \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"reinhard05_prepare (GeglOperation *operation)                                 \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (OUTPUT_FORMAT));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (OUTPUT_FORMAT));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"reinhard05_get_required_for_output (GeglOperation       *operation,           \n"
"                                    const gchar         *input_pad,           \n"
"                                    const GeglRectangle *roi)                 \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation,  \n"
"                                                                  \"input\"); \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"reinhard05_get_cached_region (GeglOperation       *operation,                 \n"
"                              const GeglRectangle *roi)                       \n"
"{                                                                             \n"
"  return *gegl_operation_source_get_bounding_box (operation, \"input\");      \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"reinhard05_stats_start (stats *s)                                             \n"
"{                                                                             \n"
"  g_return_if_fail (s);                                                       \n"
"                                                                              \n"
"  s->min   = G_MAXFLOAT;                                                      \n"
"  s->max   = G_MINFLOAT;                                                      \n"
"  s->avg   = 0.0;                                                             \n"
"  s->range = NAN;                                                             \n"
"  s->num   = 0;                                                               \n"
"};                                                                            \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"reinhard05_stats_update (stats *s,                                            \n"
"                         gfloat value)                                        \n"
"{                                                                             \n"
"  g_return_if_fail (s);                                                       \n"
"  g_return_if_fail (!isinf (value));                                          \n"
"  g_return_if_fail (!isnan (value));                                          \n"
"                                                                              \n"
"  s->min  = MIN (s->min, value);                                              \n"
"  s->max  = MAX (s->max, value);                                              \n"
"  s->avg += value;                                                            \n"
"  s->num += 1;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"reinhard05_stats_finish (stats *s)                                            \n"
"{                                                                             \n"
"  g_return_if_fail (s->num !=    0.0);                                        \n"
"  g_return_if_fail (s->max >= s->min);                                        \n"
"                                                                              \n"
"  s->avg   /= s->num;                                                         \n"
"  s->range  = s->max - s->min;                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"reinhard05_process (GeglOperation       *operation,                           \n"
"                    GeglBuffer          *input,                               \n"
"                    GeglBuffer          *output,                              \n"
"                    const GeglRectangle *result,                              \n"
"                    gint                 level)                               \n"
"{                                                                             \n"
"  const GeglProperties *o = GEGL_PROPERTIES (operation);                      \n"
"                                                                              \n"
"  const gint  pix_stride = 4, /* RGBA */                                      \n"
"              RGB        = 3;                                                 \n"
"                                                                              \n"
"  gfloat *lum,                                                                \n"
"         *pix;                                                                \n"
"  gfloat  key, contrast, intensity,                                           \n"
"          chrom      =       o->chromatic,                                    \n"
"          chrom_comp = 1.0 - o->chromatic,                                    \n"
"          light      =       o->light,                                        \n"
"          light_comp = 1.0 - o->light;                                        \n"
"                                                                              \n"
"  stats   world_lin,                                                          \n"
"          world_log,                                                          \n"
"          channel [RGB],                                                      \n"
"          normalise;                                                          \n"
"                                                                              \n"
"  gint    i, c;                                                               \n"
"                                                                              \n"
"  g_return_val_if_fail (operation, FALSE);                                    \n"
"  g_return_val_if_fail (input, FALSE);                                        \n"
"  g_return_val_if_fail (output, FALSE);                                       \n"
"  g_return_val_if_fail (result, FALSE);                                       \n"
"                                                                              \n"
"  g_return_val_if_fail (babl_format_get_n_components (babl_format (OUTPUT_FORMAT)) == pix_stride, FALSE);\n"
"                                                                              \n"
"  g_return_val_if_fail (chrom      >= 0.0 && chrom      <= 1.0, FALSE);       \n"
"  g_return_val_if_fail (chrom_comp >= 0.0 && chrom_comp <= 1.0, FALSE);       \n"
"  g_return_val_if_fail (light      >= 0.0 && light      <= 1.0, FALSE);       \n"
"  g_return_val_if_fail (light_comp >= 0.0 && light_comp <= 1.0, FALSE);       \n"
"                                                                              \n"
"                                                                              \n"
"  /* Obtain the pixel data */                                                 \n"
"  lum = g_new (gfloat, result->width * result->height),                       \n"
"  gegl_buffer_get (input, result, 1.0, babl_format (\"Y float\"),             \n"
"                   lum, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                \n"
"                                                                              \n"
"  pix = g_new (gfloat, result->width * result->height * pix_stride);          \n"
"  gegl_buffer_get (input, result, 1.0, babl_format (OUTPUT_FORMAT),           \n"
"                   pix, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                \n"
"                                                                              \n"
"  /* Collect the image stats, averages, etc */                                \n"
"  reinhard05_stats_start (&world_lin);                                        \n"
"  reinhard05_stats_start (&world_log);                                        \n"
"  reinhard05_stats_start (&normalise);                                        \n"
"  for (i = 0; i < RGB; ++i)                                                   \n"
"    {                                                                         \n"
"      reinhard05_stats_start (channel + i);                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  for (i = 0; i < result->width * result->height; ++i)                        \n"
"    {                                                                         \n"
"      reinhard05_stats_update (&world_lin,                 lum[i] );          \n"
"      reinhard05_stats_update (&world_log, logf (2.3e-5f + lum[i]));          \n"
"                                                                              \n"
"      for (c = 0; c < RGB; ++c)                                               \n"
"        {                                                                     \n"
"          reinhard05_stats_update (channel + c, pix[i * pix_stride + c]);     \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_return_val_if_fail (world_lin.min >= 0.0, FALSE);                         \n"
"                                                                              \n"
"  reinhard05_stats_finish (&world_lin);                                       \n"
"  reinhard05_stats_finish (&world_log);                                       \n"
"  for (i = 0; i < RGB; ++i)                                                   \n"
"    {                                                                         \n"
"      reinhard05_stats_finish (channel + i);                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* Calculate key parameters */                                              \n"
"  key       = (logf (world_lin.max) -                 world_log.avg) /        \n"
"              (logf (world_lin.max) - logf (2.3e-5f + world_lin.min));        \n"
"  contrast  = 0.3 + 0.7 * powf (key, 1.4);                                    \n"
"  intensity = expf (-o->brightness);                                          \n"
"                                                                              \n"
"  g_return_val_if_fail (contrast >= 0.3 && contrast <= 1.0, FALSE);           \n"
"                                                                              \n"
"  /* Apply the operator */                                                    \n"
"  for (i = 0; i < result->width * result->height; ++i)                        \n"
"    {                                                                         \n"
"      gfloat local, global, adapt;                                            \n"
"                                                                              \n"
"      if (lum[i] == 0.0)                                                      \n"
"        continue;                                                             \n"
"                                                                              \n"
"      for (c = 0; c < RGB; ++c)                                               \n"
"        {                                                                     \n"
"          gfloat *_p = pix + i * pix_stride + c,                              \n"
"                   p = *_p;                                                   \n"
"                                                                              \n"
"          local  = chrom      * p +                                           \n"
"                   chrom_comp * lum[i];                                       \n"
"          global = chrom      * channel[c].avg +                              \n"
"                   chrom_comp * world_lin.avg;                                \n"
"          adapt  = light      * local +                                       \n"
"                   light_comp * global;                                       \n"
"                                                                              \n"
"          p  /= p + powf (intensity * adapt, contrast);                       \n"
"          *_p = p;                                                            \n"
"          reinhard05_stats_update (&normalise, p);                            \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* Normalise the pixel values */                                            \n"
"  reinhard05_stats_finish (&normalise);                                       \n"
"                                                                              \n"
"  for (i = 0; i < result->width * result->height; ++i)                        \n"
"    {                                                                         \n"
"      for (c = 0; c < pix_stride; ++c)                                        \n"
"        {                                                                     \n"
"          gfloat *p = pix + i * pix_stride + c;                               \n"
"          *p        = (*p - normalise.min) / normalise.range;                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* Cleanup and set the output */                                            \n"
"  gegl_buffer_set (output, result, 0, babl_format (OUTPUT_FORMAT), pix,       \n"
"                   GEGL_AUTO_ROWSTRIDE);                                      \n"
"  g_free (pix);                                                               \n"
"  g_free (lum);                                                               \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"/*                                                                            \n"
" */                                                                           \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process = reinhard05_process;                                 \n"
"                                                                              \n"
"  operation_class->prepare                 = reinhard05_prepare;              \n"
"  operation_class->get_required_for_output = reinhard05_get_required_for_output;\n"
"  operation_class->get_cached_region       = reinhard05_get_cached_region;    \n"
"  operation_class->threaded                = FALSE;                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"  \"name\",      \"gegl:reinhard05\",                                         \n"
"  \"title\",      _(\"Reinhard 2005 Tone Mapping\"),                          \n"
"  \"categories\" , \"tonemapping\",                                           \n"
"  \"description\",                                                            \n"
"        _(\"Adapt an image, which may have a high dynamic range, for \"       \n"
"          \"presentation using a low dynamic range. This is an efficient \"   \n"
"          \"global operator derived from simple physiological observations, \"\n"
"          \"producing luminance within the range 0.0-1.0\"),                  \n"
"        NULL);                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
