static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"/*  Here in the top of the file the properties of the operation is declared,  \n"
" *  this causes the declaration of a structure for containing the data.       \n"
" *                                                                            \n"
" *  The first member of each property_ macro becomes a struct member          \n"
" *  in the GeglProperties struct used when processing.                        \n"
" */                                                                           \n"
"                                                                              \n"
"property_double (contrast, _(\"Contrast\"),  1.0)                             \n"
"   description  (_(\"Magnitude of contrast scaling >1.0 brighten < 1.0 darken\"))\n"
"   value_range  (-5.0, 5.0)                                                   \n"
"   ui_range     (0.0, 2.0)                                                    \n"
"                                                                              \n"
"property_double (brightness, _(\"Brightness\"), 0.0)                          \n"
"   description  (_(\"Amount to increase brightness\"))                        \n"
"   value_range  (-3.0, 3.0)                                                   \n"
"   ui_range     (-1.0, 1.0)                                                   \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"/* Specify the base class we're building our operation on, the base           \n"
" * class provides a lot of the legwork so we do not have to. For              \n"
" * brightness contrast the best base class is the POINT_FILTER base           \n"
" * class.                                                                     \n"
" */                                                                           \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"                                                                              \n"
"/* We specify the file we're in, this is needed to make the code              \n"
" * generation for the properties work.                                        \n"
" */                                                                           \n"
"#define GEGL_OP_C_SOURCE brightness-contrast.c                                \n"
"                                                                              \n"
"/* Including gegl-op.h creates most of the GObject boiler plate               \n"
" * needed, creating a GeglOp instance structure a GeglOpClass                 \n"
" * structure for our operation, as well as the needed code to register        \n"
" * our new gobject with GEGL.                                                 \n"
" */                                                                           \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"/* prepare() is called on each operation providing data to a node that        \n"
" * is requested to provide a rendered result. When prepare is called          \n"
" * all properties are known. For brightness contrast we use this              \n"
" * opportunity to dictate the formats of the input and output buffers.        \n"
" */                                                                           \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"/* For GeglOperationPointFilter subclasses, we operate on linear              \n"
" * buffers with a pixel count.                                                \n"
" */                                                                           \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  /* Retrieve a pointer to GeglProperties structure which contains all the    \n"
"   * chanted properties                                                       \n"
"   */                                                                         \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"  gfloat     * GEGL_ALIGNED in_pixel;                                         \n"
"  gfloat     * GEGL_ALIGNED out_pixel;                                        \n"
"  gfloat      brightness, contrast;                                           \n"
"  glong       i;                                                              \n"
"                                                                              \n"
"  in_pixel   = in_buf;                                                        \n"
"  out_pixel  = out_buf;                                                       \n"
"                                                                              \n"
"  brightness = o->brightness;                                                 \n"
"  contrast   = o->contrast;                                                   \n"
"                                                                              \n"
"  for (i=0; i<n_pixels; i++)                                                  \n"
"    {                                                                         \n"
"      out_pixel[0] = (in_pixel[0] - 0.5f) * contrast + brightness + 0.5;      \n"
"      out_pixel[1] = (in_pixel[1] - 0.5f) * contrast + brightness + 0.5;      \n"
"      out_pixel[2] = (in_pixel[2] - 0.5f) * contrast + brightness + 0.5;      \n"
"      out_pixel[3] = in_pixel[3]; /* copy the alpha */                        \n"
"      in_pixel  += 4;                                                         \n"
"      out_pixel += 4;                                                         \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/brightness-contrast.cl.h\"                                  \n"
"                                                                              \n"
"/*                                                                            \n"
" * The class init function sets up information needed for this operations class\n"
" * (template) in the GObject OO framework.                                    \n"
" */                                                                           \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"  gchar                         *composition = \"<?xml version='1.0' encoding='UTF-8'?>\"\n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:brightness-contrast'>\"                           \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='contrast'>1.8</param>\"                                \n"
"    \"    <param name='brightness'>0.25</param>\"                             \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:load'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='path'>standard-input.png</param>\"                     \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  /* override the prepare methods of the GeglOperation class */               \n"
"  operation_class->prepare = prepare;                                         \n"
"  /* override the process method of the point filter class (the process methods\n"
"   * of our superclasses deal with the handling on their level of abstraction)\n"
"   */                                                                         \n"
"  point_filter_class->process = process;                                      \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"      \"name\",       \"gegl:brightness-contrast\",                           \n"
"      \"title\",      _(\"Brightness Contrast\"),                             \n"
"      \"categories\", \"color\",                                              \n"
"      \"description\", _(\"Changes the light level and contrast. This operation operates in linear light, 'contrast' is a scale factor around 50%% gray, and 'brightness' a constant offset to apply after contrast scaling.\"),\n"
"      \"cl-source\"  , brightness_contrast_cl_source,                         \n"
"      \"reference-composition\", composition,                                 \n"
"      NULL);                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"#endif /* closing #ifdef GEGL_PROPERTIES ... else ... */                      \n"
;
