static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2009 Henrik Akesson <h.m.akesson (a) gmail.com>                  \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path  (path, _(\"File\"), \"\")                                 \n"
"    description     (_(\"Target path and filename, use '-' for stdout.\"))    \n"
"                                                                              \n"
"property_boolean (rawformat, _(\"Raw format\"), TRUE)                         \n"
"property_int     (bitdepth, _(\"Bitdepth\"), 16)                              \n"
"    description (_(\"8 and 16 are the currently accepted values.\"))          \n"
"    value_range (8, 16)                                                       \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_NAME ppm_save                                                 \n"
"#define GEGL_OP_C_SOURCE ppm-save.c                                           \n"
"                                                                              \n"
"#define CHANNEL_COUNT           3                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"typedef enum {                                                                \n"
"  PIXMAP_ASCII  = 51,                                                         \n"
"  PIXMAP_RAW    = 54,                                                         \n"
"} map_type;                                                                   \n"
"                                                                              \n"
"static void                                                                   \n"
"ppm_save_write(FILE    *fp,                                                   \n"
"               gint     width,                                                \n"
"               gint     height,                                               \n"
"               gsize    numsamples,                                           \n"
"               gsize    bpc,                                                  \n"
"               guchar  *data,                                                 \n"
"               map_type type)                                                 \n"
"{                                                                             \n"
"  guint i;                                                                    \n"
"                                                                              \n"
"  /* Write the header */                                                      \n"
"  fprintf (fp, \"P%c\\n%d %d\\n\", type, width, height );                     \n"
"  fprintf (fp, \"%d\\n\", (bpc == sizeof (guchar)) ? 255 : 65535);            \n"
"                                                                              \n"
"  /* Raw images writes the data in binary form */                             \n"
"  if (type == PIXMAP_RAW)                                                     \n"
"    {                                                                         \n"
"      /* Fix endianness if necessary */                                       \n"
"      if (bpc > 1)                                                            \n"
"        {                                                                     \n"
"          gushort *ptr = (gushort *) data;                                    \n"
"                                                                              \n"
"          for (i = 0; i < numsamples; i++)                                    \n"
"            {                                                                 \n"
"              *ptr = GUINT16_TO_BE (*ptr);                                    \n"
"              ptr++;                                                          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      fwrite (data, bpc, numsamples, fp);                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      /* Plain PPM format */                                                  \n"
"                                                                              \n"
"      if (bpc == sizeof (guchar))                                             \n"
"        {                                                                     \n"
"          guchar *ptr = data;                                                 \n"
"                                                                              \n"
"          for (i = 0; i < numsamples; i++)                                    \n"
"            {                                                                 \n"
"              fprintf (fp, \"%u \", (unsigned int) *ptr++);                   \n"
"              if ((i + 1) % (width * CHANNEL_COUNT) == 0)                     \n"
"                fprintf (fp, \"\\n\");                                        \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      else if (bpc == sizeof (gushort))                                       \n"
"        {                                                                     \n"
"          gushort *ptr = (gushort *) data;                                    \n"
"                                                                              \n"
"          for (i = 0; i < numsamples; i++)                                    \n"
"            {                                                                 \n"
"              fprintf (fp, \"%u \", (unsigned int) *ptr++);                   \n"
"              if ((i + 1) % (width * CHANNEL_COUNT) == 0)                     \n"
"                fprintf (fp, \"\\n\");                                        \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          g_warning (\"%s: Programmer stupidity error\", G_STRLOC);           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         const GeglRectangle *rect,                                           \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  FILE     *fp;                                                               \n"
"  guchar   *data;                                                             \n"
"  map_type  type;                                                             \n"
"  gsize     bpc;                                                              \n"
"  gsize     numsamples;                                                       \n"
"  gboolean  ret = FALSE;                                                      \n"
"                                                                              \n"
"  fp = (!strcmp (o->path, \"-\") ? stdout : fopen(o->path, \"wb\") );         \n"
"                                                                              \n"
"  if (!fp)                                                                    \n"
"    return FALSE;                                                             \n"
"                                                                              \n"
"  if ((o->bitdepth != 8) && (o->bitdepth != 16))                              \n"
"    {                                                                         \n"
"      g_warning (\"Bitdepths of 8 and 16 are only accepted currently.\");     \n"
"      goto out;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  type = (o->rawformat ? PIXMAP_RAW : PIXMAP_ASCII);                          \n"
"  bpc = (o->bitdepth == 8) ? (sizeof (guchar)) : (sizeof (gushort));          \n"
"  numsamples = rect->width * rect->height * CHANNEL_COUNT;                    \n"
"                                                                              \n"
"  data = g_malloc (numsamples * bpc);                                         \n"
"                                                                              \n"
"  switch (bpc)                                                                \n"
"    {                                                                         \n"
"    case 1:                                                                   \n"
"      gegl_buffer_get (input, rect, 1.0, babl_format (\"R'G'B' u8\"), data,   \n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                 \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case 2:                                                                   \n"
"      gegl_buffer_get (input, rect, 1.0, babl_format (\"R'G'B' u16\"), data,  \n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                 \n"
"      break;                                                                  \n"
"                                                                              \n"
"    default:                                                                  \n"
"      g_warning (\"%s: Programmer stupidity error\", G_STRLOC);               \n"
"    }                                                                         \n"
"                                                                              \n"
"  ppm_save_write (fp, rect->width, rect->height, numsamples, bpc, data, type);\n"
"                                                                              \n"
"  g_free (data);                                                              \n"
"                                                                              \n"
"  ret = TRUE;                                                                 \n"
"                                                                              \n"
" out:                                                                         \n"
"  if (fp != stdout)                                                           \n"
"    fclose( fp );                                                             \n"
"                                                                              \n"
"  return ret;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  sink_class->process = process;                                              \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:ppm-save\",                                       \n"
"    \"title\",       _(\"PPM File Saver\"),                                   \n"
"    \"categories\",  \"output\",                                              \n"
"    \"description\",                                                          \n"
"        _(\"PPM image saver (Portable pixmap saver.)\"),                      \n"
"        NULL);                                                                \n"
"                                                                              \n"
"  gegl_operation_handlers_register_saver (                                    \n"
"    \".ppm\", \"gegl:ppm-save\");                                             \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
