static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright Dov Grobgeld 2013 <dov.grobgeld (a) gmail.com>                   \n"
" *                                                                            \n"
" * This operation saves a buffer in the npy file format. It may be            \n"
" * read into python as follows:                                               \n"
" *                                                                            \n"
" *   import numpy                                                             \n"
" *   img = numpy.load('image.npy')                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"    description (_(\"Target path and filename, use '-' for stdout.\"))        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_NAME npy_save                                                 \n"
"#define GEGL_OP_C_SOURCE npy-save.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"static int npywrite_header(FILE *fp, int width, int height, int num_channels) \n"
"{                                                                             \n"
"  const gchar* format;                                                        \n"
"  gsize header_len;                                                           \n"
"  gchar *header;                                                              \n"
"                                                                              \n"
"  // Write header and version number to file                                  \n"
"  fwrite(\"\\223NUMPY\"                                                       \n"
"         \"\\001\\000\"                                                       \n"
"         , 1, 8, fp);                                                         \n"
"                                                                              \n"
"                                                                              \n"
"  if (num_channels == 3)                                                      \n"
"    format = \"{'descr': '<f4', 'fortran_order': False, 'shape': (%d, %d, 3), } \\n\";\n"
"  else                                                                        \n"
"    format = \"{'descr': '<f4', 'fortran_order': False, 'shape': (%d, %d), } \\n\";\n"
"                                                                              \n"
"  header = g_strdup_printf(format, height, width);                            \n"
"  header_len = strlen(header);                                                \n"
"  fwrite(&header_len, 2, 1, fp);                                              \n"
"  fwrite(header, header_len, 1, fp);                                          \n"
"  g_free(header);                                                             \n"
"                                                                              \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         const GeglRectangle *rect,                                           \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  FILE     *fp;                                                               \n"
"  guchar   *data;                                                             \n"
"  gsize     bpc;                                                              \n"
"  gsize     numbytes_scanline;                                                \n"
"  gsize     numchannels;                                                      \n"
"  gboolean  ret = FALSE;                                                      \n"
"  gint      row;                                                              \n"
"  gint      slice_thickness = 32;                                             \n"
"  const Babl *output_format;                                                  \n"
"  const Babl *input_format = gegl_buffer_get_format(input);                   \n"
"                                                                              \n"
"  // Get the current format and use it to decide whether to save              \n"
"  // the output in color or gray level formats.                               \n"
"  bpc = sizeof(gfloat);                                                       \n"
"  if (babl_format_get_n_components(input_format) >= 3)                        \n"
"    {                                                                         \n"
"      numchannels = 3;                                                        \n"
"      output_format = babl_format(\"RGB float\");                             \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      numchannels = 1;                                                        \n"
"      output_format = babl_format (\"Y float\");                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  numbytes_scanline = rect->width * numchannels * bpc;                        \n"
"                                                                              \n"
"  fp = (!strcmp (o->path, \"-\") ? stdout : fopen(o->path, \"wb\") );         \n"
"                                                                              \n"
"  npywrite_header(fp, rect->width, rect->height, numchannels);                \n"
"                                                                              \n"
"  data = g_malloc (numbytes_scanline * slice_thickness);                      \n"
"                                                                              \n"
"  for (row=0; row < rect->height; row+= slice_thickness)                      \n"
"    {                                                                         \n"
"      GeglRectangle rect_slice;                                               \n"
"      rect_slice.x = rect->x;                                                 \n"
"      rect_slice.width = rect->width;                                         \n"
"      rect_slice.y = rect->y+row;                                             \n"
"      rect_slice.height = MIN(slice_thickness, rect->height-row);             \n"
"                                                                              \n"
"      gegl_buffer_get (input, &rect_slice, 1.0, output_format, data,          \n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                 \n"
"                                                                              \n"
"      fwrite(data, numbytes_scanline, rect_slice.height, fp);                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (data);                                                              \n"
"                                                                              \n"
"  return ret;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  sink_class->process = process;                                              \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",       \"gegl:npy-save\",                                        \n"
"    \"title\",      _(\"NPY File Saver\"),                                    \n"
"    \"categories\", \"output\",                                               \n"
"    \"description\",                                                          \n"
"        _(\"NPY image saver (Numerical python file saver.)\"),                \n"
"        NULL);                                                                \n"
"                                                                              \n"
"  gegl_operation_handlers_register_saver (                                    \n"
"    \".npy\", \"gegl:npy-save\");                                             \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
