static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Original author:                                                           \n"
" *     Tim Rowley <tor@cs.brown.edu>                                          \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     tile_seamless                                        \n"
"#define GEGL_OP_C_SOURCE tile-seamless.c                                      \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",                            \n"
"                             babl_format (\"R'G'B'A float\"));                \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"R'G'B'A float\"));                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  const GeglRectangle *whole_region;                                          \n"
"  GeglRectangle        shift_region;                                          \n"
"  GeglBufferIterator  *gi;                                                    \n"
"  gint                 half_width;                                            \n"
"  gint                 half_height;                                           \n"
"  gint                 index_iter;                                            \n"
"  gint                 index_iter2;                                           \n"
"                                                                              \n"
"  whole_region = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  half_width  = whole_region->width / 2;                                      \n"
"  half_height = whole_region->height / 2;                                     \n"
"                                                                              \n"
"  shift_region.x = whole_region->x + half_width;                              \n"
"  shift_region.y = whole_region->y + half_height;                             \n"
"  shift_region.width  = whole_region->width;                                  \n"
"  shift_region.height = whole_region->height;                                 \n"
"                                                                              \n"
"  gi = gegl_buffer_iterator_new (output, whole_region,                        \n"
"                                 0, babl_format (\"R'G'B'A float\"),          \n"
"                                 GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);         \n"
"                                                                              \n"
"  index_iter = gegl_buffer_iterator_add (gi, input, whole_region,             \n"
"                                         0, babl_format (\"R'G'B'A float\"),  \n"
"                                         GEGL_ACCESS_READ, GEGL_ABYSS_NONE);  \n"
"                                                                              \n"
"  index_iter2 = gegl_buffer_iterator_add (gi, input, &shift_region,           \n"
"                                          0, babl_format (\"R'G'B'A float\"), \n"
"                                          GEGL_ACCESS_READ, GEGL_ABYSS_LOOP); \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (gi))                                      \n"
"    {                                                                         \n"
"      guint   k;                                                              \n"
"      gfloat *data_out;                                                       \n"
"      gfloat *data_in1;                                                       \n"
"      gfloat *data_in2;                                                       \n"
"                                                                              \n"
"      data_out = (gfloat*) gi->data[0];                                       \n"
"      data_in1 = (gfloat*) gi->data[index_iter];                              \n"
"      data_in2 = (gfloat*) gi->data[index_iter2];                             \n"
"                                                                              \n"
"      for (k = 0; k < gi->length; k++)                                        \n"
"        {                                                                     \n"
"          gint x, y, b;                                                       \n"
"          gfloat alpha;                                                       \n"
"          gfloat val_x, val_y;                                                \n"
"          gfloat w, w1, w2;                                                   \n"
"          const gfloat eps = 1e-4;                                            \n"
"                                                                              \n"
"          x = gi->roi[0].x + k % gi->roi[0].width;                            \n"
"          y = gi->roi[0].y + k / gi->roi[0].width;                            \n"
"                                                                              \n"
"          val_x = (half_width - x) / (gfloat) half_width;                     \n"
"          val_y = (half_height - y) / (gfloat) half_height;                   \n"
"                                                                              \n"
"          val_x = ABS (CLAMP (val_x, -1.0, 1.0));                             \n"
"          val_y = ABS (CLAMP (val_y, -1.0, 1.0));                             \n"
"                                                                              \n"
"          /* ambiguous position */                                            \n"
"          if (ABS (val_x - val_y) >= 1.0 - eps)                               \n"
"            w = 0.0;                                                          \n"
"          else                                                                \n"
"            w = val_x * val_y / (val_x * val_y + (1.0 - val_x) * (1.0 - val_y));\n"
"                                                                              \n"
"          alpha = data_in1[3] * (1.0 - w) + data_in2[3] * w;                  \n"
"                                                                              \n"
"          w1 = (1.0 - w) * data_in1[3] / alpha;                               \n"
"          w2 = w * data_in2[3] / alpha;                                       \n"
"                                                                              \n"
"          for (b = 0; b < 3; b++)                                             \n"
"            data_out[b] = data_in1[b] * w1 + data_in2[b] * w2;                \n"
"                                                                              \n"
"          data_out[3] = alpha;                                                \n"
"                                                                              \n"
"          data_out += 4;                                                      \n"
"          data_in1 += 4;                                                      \n"
"          data_in2 += 4;                                                      \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  return *gegl_operation_source_get_bounding_box (operation, \"input\");      \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return *gegl_operation_source_get_bounding_box (operation, \"input\");      \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process                    = process;                         \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  operation_class->get_cached_region       = get_cached_region;               \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",              \"gegl:tile-seamless\",                            \n"
"    \"title\",             _(\"Make Seamlessly tileable\"),                   \n"
"    \"categories\",        \"tile\",                                          \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"description\", _(\"Make the input buffer seamlessly tileable.\"         \n"
"                     \" The algorithm is not content-aware,\"                 \n"
"                     \" so the result may need post-processing.\"),           \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
