static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (in_low, _(\"Low input\"), 0.0)                               \n"
"    description ( _(\"Input luminance level to become lowest output\"))       \n"
"    value_range (-1.0, 4.0)                                                   \n"
"    ui_range    (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (in_high, _(\"High input\"), 1.0)                             \n"
"    description (_(\"Input luminance level to become white\"))                \n"
"    value_range (-1.0, 4.0)                                                   \n"
"    ui_range    (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (out_low, _(\"Low output\"), 0.0)                             \n"
"    description (_(\"Lowest luminance level in output\"))                     \n"
"    value_range (-1.0, 4.0)                                                   \n"
"    ui_range    (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (out_high, _(\"High output\"), 1.0)                           \n"
"    description (_(\"Highest luminance level in output\"))                    \n"
"    value_range (-1.0, 4.0)                                                   \n"
"    ui_range    (0.0, 1.0)                                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     levels                                               \n"
"#define GEGL_OP_C_SOURCE levels.c                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"/* GeglOperationPointFilter gives us a linear buffer to operate on            \n"
" * in our requested pixel format                                              \n"
" */                                                                           \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"  gfloat     *in_pixel;                                                       \n"
"  gfloat     *out_pixel;                                                      \n"
"  gfloat      in_range;                                                       \n"
"  gfloat      out_range;                                                      \n"
"  gfloat      in_offset;                                                      \n"
"  gfloat      out_offset;                                                     \n"
"  gfloat      scale;                                                          \n"
"  glong       i;                                                              \n"
"                                                                              \n"
"  in_pixel = in_buf;                                                          \n"
"  out_pixel = out_buf;                                                        \n"
"                                                                              \n"
"  in_offset = o->in_low * 1.0;                                                \n"
"  out_offset = o->out_low * 1.0;                                              \n"
"  in_range = o->in_high-o->in_low;                                            \n"
"  out_range = o->out_high-o->out_low;                                         \n"
"                                                                              \n"
"  if (in_range == 0.0)                                                        \n"
"    in_range = 0.00000001;                                                    \n"
"                                                                              \n"
"  scale = out_range/in_range;                                                 \n"
"                                                                              \n"
"  for (i=0; i<n_pixels; i++)                                                  \n"
"    {                                                                         \n"
"      int c;                                                                  \n"
"      for (c=0;c<3;c++)                                                       \n"
"        out_pixel[c] = (in_pixel[c]- in_offset) * scale + out_offset;         \n"
"      out_pixel[3] = in_pixel[3];                                             \n"
"      out_pixel += 4;                                                         \n"
"      in_pixel += 4;                                                          \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"                                                                              \n"
"#include \"opencl/levels.cl.h\"                                               \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"/* OpenCL processing function */                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *op,                                          \n"
"            cl_mem               in_tex,                                      \n"
"            cl_mem               out_tex,                                     \n"
"            size_t               global_worksize,                             \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                 level)                                       \n"
"{                                                                             \n"
"  /* Retrieve a pointer to GeglProperties structure which contains all the    \n"
"   * chanted properties                                                       \n"
"   */                                                                         \n"
"                                                                              \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"                                                                              \n"
"  gfloat      in_range;                                                       \n"
"  gfloat      out_range;                                                      \n"
"  gfloat      in_offset;                                                      \n"
"  gfloat      out_offset;                                                     \n"
"  gfloat      scale;                                                          \n"
"                                                                              \n"
"  cl_int cl_err = 0;                                                          \n"
"                                                                              \n"
"  in_offset = o->in_low * 1.0;                                                \n"
"  out_offset = o->out_low * 1.0;                                              \n"
"  in_range = o->in_high-o->in_low;                                            \n"
"  out_range = o->out_high-o->out_low;                                         \n"
"                                                                              \n"
"  if (in_range == 0.0)                                                        \n"
"    in_range = 0.00000001;                                                    \n"
"                                                                              \n"
"  scale = out_range/in_range;                                                 \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"kernel_levels\", NULL};                  \n"
"      cl_data = gegl_cl_compile_and_build (levels_cl_source, kernel_name);    \n"
"    }                                                                         \n"
"  if (!cl_data) return TRUE;                                                  \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 0, sizeof(cl_mem),   (void*)&in_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 1, sizeof(cl_mem),   (void*)&out_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 2, sizeof(cl_float), (void*)&in_offset);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 3, sizeof(cl_float), (void*)&out_offset);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 4, sizeof(cl_float), (void*)&scale);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),          \n"
"                                        cl_data->kernel[0], 1,                \n"
"                                        NULL, &global_worksize, NULL,         \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"  gchar                         *composition = \"<?xml version='1.0' encoding='UTF-8'?>\"\n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:levels'>\"                                        \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='in-low'>0.54</param>\"                                 \n"
"    \"    <param name='in-high'>0.60</param>\"                                \n"
"    \"    <param name='out-low'>0.57</param>\"                                \n"
"    \"    <param name='out-high'>0.68</param>\"                               \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:load'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='path'>standard-input.png</param>\"                     \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  point_filter_class->process = process;                                      \n"
"  point_filter_class->cl_process = cl_process;                                \n"
"                                                                              \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:levels\",                                         \n"
"    \"title\",       _(\"Levels\"),                                           \n"
"    \"categories\" , \"color\",                                               \n"
"    \"description\", _(\"Remaps the intensity range of the image\"),          \n"
"    \"reference-composition\", composition,                                   \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
