//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
#include "G4DetailedBalancePhaseSpaceIntegral.hh"
#include "G4SystemOfUnits.hh"
#include "G4ResonanceID.hh"

  G4double G4DetailedBalancePhaseSpaceIntegral::sqrts[120] = 
  { 
  .100, .162, .224, .285, .347, .409, .471, .532, .594, .656, .718, .779, .841, .903, .965, 1.026, 1.088, 1.150, 1.212, 1.274, 1.335, 1.397, 1.459, 1.521, 1.582, 1.644, 1.706, 1.768, 1.829, 1.891, 1.953, 2.015, 2.076, 2.138, 2.200, 2.262, 2.324, 2.385, 2.447, 2.509, 2.571, 2.632, 2.694, 2.756, 2.818, 2.879, 2.941, 3.003, 3.065, 3.126, 3.188, 3.250, 3.312, 3.374, 3.435, 3.497, 3.559, 3.621, 3.682, 3.744, 3.806, 3.868, 3.929, 3.991, 4.053, 4.115, 4.176, 4.238, 4.300, 4.362, 4.424, 4.485, 4.547, 4.609, 4.671, 4.732, 4.794, 4.856, 4.918, 4.979, 5.000, 6.134, 7.269, 8.403, 9.538, 10.672, 11.807, 12.941, 14.076, 15.210, 16.345, 17.479, 18.613, 19.748, 20.882, 22.017, 23.151, 24.286, 25.420, 26.555, 27.689, 28.824, 29.958, 31.092, 32.227, 33.361, 34.496, 35.630, 36.765, 37.899, 39.034, 40.168, 41.303, 42.437, 43.571, 44.706, 45.840, 46.975, 48.109, 49.244
  };
  
  G4double G4DetailedBalancePhaseSpaceIntegral::delta[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.791463, 0.18346, 0.135791, 0.131618, 0.154292, 0.218466, 0.306349, 0.385893, 0.450964, 0.505565, 0.550962, 0.589159, 0.621194, 0.649251, 0.673632, 0.695004, 0.713597, 0.730421, 0.745477, 0.759025, 0.77109, 0.782239, 0.792409, 0.801722, 0.810279, 0.818044, 0.825345, 0.832112, 0.838401, 0.844168, 0.849643, 0.854765, 0.859565, 0.864004, 0.868251, 0.872251, 0.876017, 0.879519, 0.882908, 0.886106, 0.889116, 0.892023, 0.894707, 0.897298, 0.899828, 0.902129, 0.904438, 0.906504, 0.908681, 0.910531, 0.912546, 0.913134, 0.937217, 0.952382, 0.963662, 0.96815, 0.975873, 0.981432, 0.970877, 1.00491, 1.00921, 0.930845, 1.06913, 0.923998, 1.10739, 0.901394, 0.890996, 1.17401, 0.919388, 0.924739, 0.843633, 1.1356, 1.21094, 0.824869, 0.887236, 0.920237, 0.765227, 0.930248, 1.42698, 1.40765, 0.919243, 0.70883, 0.749762, 0.97507, 1.03521, 0.798182, 0.652524, 0.657148, 0.806743, 1.1505, 1.69862
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::delta1600[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.841847, 0.180378, 0.120167, 0.10034, 0.0922057, 0.089713, 0.0906924, 0.0943819, 0.100546, 0.109707, 0.122512, 0.140037, 0.162838, 0.191498, 0.223873, 0.2576, 0.290411, 0.322436, 0.352698, 0.38106, 0.407122, 0.431823, 0.454835, 0.476287, 0.496305, 0.514715, 0.532232, 0.548645, 0.564047, 0.578296, 0.591934, 0.604788, 0.61692, 0.628206, 0.639066, 0.649356, 0.659117, 0.668241, 0.677061, 0.685454, 0.693451, 0.701076, 0.708239, 0.715197, 0.721849, 0.728215, 0.734215, 0.740061, 0.745668, 0.751049, 0.756136, 0.757841, 0.824679, 0.862464, 0.886177, 0.902193, 0.913577, 0.922009, 0.928382, 0.933312, 0.937227, 0.940249, 0.943612, 0.9467, 0.945823, 0.951972, 0.947481, 0.954609, 0.954075, 0.947239, 0.96075, 0.962163, 0.946002, 0.947292, 0.968474, 0.977239, 0.955266, 0.937823, 0.937755, 0.956283, 0.989065, 1.00195, 0.976921, 0.94292, 0.925931, 0.922103, 0.922856, 0.935726, 0.970315, 1.01796, 1.05137
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::delta1620[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.408076, 0.0877172, 0.0586604, 0.0492052, 0.0454755, 0.0445697, 0.0454907, 0.0479702, 0.0520729, 0.0585309, 0.0687595, 0.0862874, 0.116842, 0.161041, 0.208932, 0.255076, 0.297228, 0.336519, 0.372397, 0.405159, 0.434661, 0.462167, 0.487445, 0.510736, 0.532252, 0.551868, 0.570388, 0.587619, 0.603685, 0.618463, 0.63253, 0.645723, 0.658117, 0.669596, 0.680597, 0.690979, 0.700791, 0.709931, 0.718737, 0.72709, 0.735023, 0.742565, 0.749631, 0.756475, 0.763001, 0.769228, 0.775084, 0.780778, 0.786223, 0.791437, 0.79636, 0.798004, 0.861525, 0.896638, 0.918549, 0.933902, 0.941016, 0.954744, 0.945585, 0.957981, 0.962151, 0.947429, 0.945121, 1.01356, 0.936352, 1.01831, 0.92844, 1.05991, 0.924946, 0.916956, 1.10311, 0.938846, 0.920384, 0.904647, 1.15349, 1.03022, 0.867957, 0.927374, 0.851192, 0.971168, 1.28404, 1.14606, 0.859455, 0.821988, 0.94225, 0.906299, 0.783429, 0.812784, 1.04285, 1.41072, 1.48924
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::delta1700[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.777927, 0.166211, 0.110372, 0.0918253, 0.0840178, 0.0813322, 0.0817223, 0.0844227, 0.0891403, 0.0961833, 0.105967, 0.119314, 0.136997, 0.160446, 0.18901, 0.220788, 0.253073, 0.285423, 0.316487, 0.345896, 0.3731, 0.399, 0.423212, 0.445837, 0.466989, 0.486473, 0.505033, 0.522441, 0.538791, 0.553927, 0.568422, 0.582092, 0.595, 0.607012, 0.618576, 0.629535, 0.639935, 0.649658, 0.659059, 0.668009, 0.676536, 0.684668, 0.69231, 0.699733, 0.706831, 0.713624, 0.720027, 0.726267, 0.732252, 0.737997, 0.743428, 0.745248, 0.816631, 0.856983, 0.88229, 0.89937, 0.91148, 0.920432, 0.927343, 0.932698, 0.936926, 0.94071, 0.943999, 0.944592, 0.948309, 0.948986, 0.952043, 0.948862, 0.959505, 0.949899, 0.950663, 0.967053, 0.958166, 0.943667, 0.951274, 0.975734, 0.977556, 0.951478, 0.936027, 0.937725, 0.958755, 0.99412, 1.00694, 0.979553, 0.943152, 0.925058, 0.921155, 0.920717, 0.930328, 0.962098, 1.01185
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::delta1900[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.509133, 0.108362, 0.0716469, 0.0593223, 0.0539782, 0.0519208, 0.051785, 0.0530338, 0.0554351, 0.0590924, 0.0641838, 0.0711512, 0.0806243, 0.0943098, 0.114151, 0.141512, 0.174052, 0.209382, 0.244531, 0.278308, 0.309742, 0.339733, 0.367774, 0.393961, 0.418414, 0.440909, 0.462307, 0.482349, 0.501146, 0.518523, 0.535144, 0.550797, 0.565561, 0.579284, 0.592479, 0.604972, 0.616813, 0.627873, 0.638556, 0.648716, 0.658387, 0.667602, 0.676253, 0.684649, 0.692671, 0.700341, 0.707566, 0.714601, 0.721343, 0.727809, 0.733916, 0.735963, 0.815735, 0.860312, 0.888002, 0.906553, 0.919434, 0.928811, 0.93672, 0.940726, 0.944825, 0.947096, 0.949754, 0.96112, 0.955619, 0.957278, 0.961905, 0.964641, 0.948935, 0.990353, 0.951994, 0.943815, 0.997524, 0.985787, 0.935233, 0.933804, 0.985334, 1.04291, 0.976454, 0.92317, 0.920953, 0.919673, 0.977725, 1.08003, 1.08345, 0.980161, 0.905147, 0.90153, 0.915476, 0.896648, 0.882291
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::delta1905[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.642785, 0.1365, 0.0900211, 0.0743221, 0.0673988, 0.0645734, 0.0641012, 0.0652714, 0.0677509, 0.0715689, 0.0768104, 0.0837606, 0.0927478, 0.104825, 0.120892, 0.141857, 0.167166, 0.19618, 0.226592, 0.256959, 0.285982, 0.314204, 0.34097, 0.36624, 0.390042, 0.412091, 0.43319, 0.453051, 0.47176, 0.489123, 0.505787, 0.521529, 0.536418, 0.550294, 0.563668, 0.576357, 0.588409, 0.599688, 0.610602, 0.621, 0.630913, 0.640374, 0.649269, 0.657913, 0.666184, 0.674102, 0.68157, 0.688849, 0.695834, 0.702541, 0.708882, 0.711009, 0.794509, 0.841765, 0.871382, 0.891339, 0.90548, 0.915921, 0.923885, 0.930107, 0.934857, 0.938856, 0.942882, 0.94593, 0.945534, 0.95181, 0.948039, 0.957268, 0.948426, 0.958109, 0.96074, 0.94682, 0.957739, 0.974396, 0.956243, 0.941841, 0.951844, 0.981697, 0.987557, 0.956974, 0.935519, 0.932688, 0.946039, 0.983422, 1.01902, 1.01099, 0.967849, 0.931925, 0.919857, 0.918323, 0.916217
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::delta1910[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.449928, 0.0955152, 0.0629718, 0.0519733, 0.0471165, 0.0451275, 0.0447853, 0.0455942, 0.0473242, 0.0500031, 0.0537076, 0.0586774, 0.0652364, 0.074392, 0.0874664, 0.106602, 0.132769, 0.16505, 0.19957, 0.233939, 0.266508, 0.297899, 0.327435, 0.355129, 0.381064, 0.40497, 0.427747, 0.449106, 0.469158, 0.487711, 0.505468, 0.522201, 0.537991, 0.552675, 0.566799, 0.580175, 0.592858, 0.604708, 0.616157, 0.627047, 0.637416, 0.647298, 0.656576, 0.665582, 0.674188, 0.682419, 0.690171, 0.697721, 0.704957, 0.711898, 0.718454, 0.720651, 0.806315, 0.854174, 0.883891, 0.903666, 0.917875, 0.928377, 0.935201, 0.943274, 0.947442, 0.952235, 0.959253, 0.955805, 0.950321, 0.973535, 0.947111, 0.982651, 0.949274, 0.960446, 0.995374, 0.940787, 0.947799, 1.01847, 0.975906, 0.929431, 0.93021, 0.995413, 1.061, 0.975879, 0.91672, 0.919052, 0.910013, 0.962214, 1.08601, 1.1201, 1.00679, 0.904396, 0.888803, 0.915317, 0.904622
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::delta1920[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.351127, 0.0744941, 0.049079, 0.0404765, 0.0366628, 0.0350815, 0.0347778, 0.0353622, 0.0366528, 0.0386641, 0.0414497, 0.0451869, 0.0501229, 0.057049, 0.0671447, 0.0828747, 0.107105, 0.140173, 0.176845, 0.213563, 0.248287, 0.281641, 0.312917, 0.342157, 0.36947, 0.39459, 0.418478, 0.440841, 0.461804, 0.481174, 0.499689, 0.517119, 0.533548, 0.548813, 0.563482, 0.577364, 0.590515, 0.602794, 0.614648, 0.625917, 0.636639, 0.646852, 0.656434, 0.665731, 0.67461, 0.683096, 0.691086, 0.698863, 0.706313, 0.713456, 0.7202, 0.722459, 0.81025, 0.859017, 0.889124, 0.909326, 0.9233, 0.934393, 0.937768, 0.95121, 0.959742, 0.966937, 0.970407, 0.948933, 0.955382, 0.984892, 0.942159, 0.990688, 0.953738, 0.938332, 1.04362, 0.933986, 0.923866, 1.0322, 1.02548, 0.912188, 0.913538, 0.949419, 1.13362, 1.03296, 0.888289, 0.915975, 0.890958, 0.887978, 1.06807, 1.24907, 1.10363, 0.891688, 0.834544, 0.903427, 0.937526
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::delta1930[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.569218, 0.120465, 0.0791458, 0.0650716, 0.0587292, 0.055963, 0.0552089, 0.0558117, 0.0574496, 0.0600759, 0.0636902, 0.0684151, 0.0743803, 0.0821714, 0.0923152, 0.10569, 0.122977, 0.145229, 0.171424, 0.199858, 0.228473, 0.257185, 0.284963, 0.311531, 0.336784, 0.360329, 0.382967, 0.404359, 0.42457, 0.443373, 0.461454, 0.478567, 0.494775, 0.5099, 0.524494, 0.538356, 0.551534, 0.563876, 0.575828, 0.587222, 0.598092, 0.608472, 0.618235, 0.627729, 0.636816, 0.64552, 0.653732, 0.661739, 0.669426, 0.676808, 0.68379, 0.686132, 0.778238, 0.830454, 0.863187, 0.885232, 0.900837, 0.912328, 0.921146, 0.927763, 0.933247, 0.937633, 0.940666, 0.943616, 0.948854, 0.94724, 0.953032, 0.949476, 0.959689, 0.948458, 0.959477, 0.964498, 0.947038, 0.954625, 0.977974, 0.964645, 0.942541, 0.944273, 0.971945, 0.997763, 0.976433, 0.942466, 0.930759, 0.932864, 0.955282, 1.00152, 1.03235, 1.01079, 0.960698, 0.925973, 0.917134
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::delta1950[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.554622, 0.117296, 0.077005, 0.0632591, 0.0570397, 0.0542954, 0.0534991, 0.0540082, 0.0555051, 0.0579325, 0.0612789, 0.0656443, 0.0711312, 0.0782536, 0.087462, 0.0995406, 0.115188, 0.135663, 0.160431, 0.188005, 0.216235, 0.244863, 0.272737, 0.299509, 0.325023, 0.348856, 0.371804, 0.393509, 0.414035, 0.433142, 0.451526, 0.468933, 0.485427, 0.500823, 0.515683, 0.5298, 0.543225, 0.555801, 0.567981, 0.579595, 0.590676, 0.60126, 0.611215, 0.620898, 0.630166, 0.639045, 0.647422, 0.655592, 0.663434, 0.670967, 0.678093, 0.680483, 0.774521, 0.827858, 0.861297, 0.883817, 0.899764, 0.911518, 0.920493, 0.927311, 0.93267, 0.936995, 0.940315, 0.944298, 0.948512, 0.946468, 0.954348, 0.948211, 0.960121, 0.950243, 0.955092, 0.96795, 0.949896, 0.949637, 0.974362, 0.972852, 0.94639, 0.940893, 0.961186, 0.995115, 0.988971, 0.951651, 0.932193, 0.93022, 0.943166, 0.983525, 1.02785, 1.02749, 0.981705, 0.936266, 0.917812
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N1440[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.35658, 0.297152, 0.203158, 0.174856, 0.166748, 0.169729, 0.181237, 0.201068, 0.22873, 0.263555, 0.301812, 0.340295, 0.3765, 0.410781, 0.442297, 0.471115, 0.49702, 0.52109, 0.543112, 0.563304, 0.581577, 0.598704, 0.614526, 0.629179, 0.642783, 0.655244, 0.667062, 0.678106, 0.688446, 0.697994, 0.707117, 0.715706, 0.723802, 0.731328, 0.738563, 0.745413, 0.751908, 0.757976, 0.763839, 0.769418, 0.774731, 0.779796, 0.784553, 0.789174, 0.793592, 0.797819, 0.801803, 0.805685, 0.809409, 0.812983, 0.816362, 0.817495, 0.861991, 0.887317, 0.90334, 0.914254, 0.922069, 0.927906, 0.932321, 0.935784, 0.938531, 0.941419, 0.943295, 0.94391, 0.947164, 0.946779, 0.946552, 0.954033, 0.94703, 0.945319, 0.958005, 0.960135, 0.945531, 0.939265, 0.949346, 0.970123, 0.976721, 0.958395, 0.937371, 0.928483, 0.929705, 0.94289, 0.970898, 1.00151, 1.0119, 0.992784, 0.958286, 0.928894, 0.914032, 0.91034, 0.909191
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N1520[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.411336, 0.0897028, 0.0610322, 0.0522659, 0.0495967, 0.0503116, 0.0538352, 0.0608698, 0.0739261, 0.102011, 0.154523, 0.215922, 0.273046, 0.325292, 0.371745, 0.413024, 0.449258, 0.482251, 0.511916, 0.538707, 0.562632, 0.584792, 0.605045, 0.623621, 0.640713, 0.656242, 0.670857, 0.684417, 0.697029, 0.708601, 0.719593, 0.729882, 0.73953, 0.748451, 0.756986, 0.765029, 0.772618, 0.779675, 0.786464, 0.792898, 0.79901, 0.804818, 0.810234, 0.815466, 0.820487, 0.82527, 0.829705, 0.834091, 0.838256, 0.84218, 0.846021, 0.847244, 0.895165, 0.920155, 0.93883, 0.954209, 0.968607, 0.943533, 0.985424, 1.01068, 1.00663, 0.93709, 0.929831, 1.06348, 0.920052, 1.07425, 0.899784, 0.888587, 1.19818, 0.867335, 0.897437, 0.996813, 1.22934, 0.82479, 0.946999, 0.809511, 0.945749, 1.45329, 1.06595, 0.750515, 0.855056, 1.00429, 0.768188, 0.713859, 0.962332, 1.53919, 1.6505, 1.07221, 0.728062, 0.630033, 0.708231
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N1535[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.447503, 0.0972124, 0.0658293, 0.0560465, 0.0527778, 0.0529825, 0.0558388, 0.0616168, 0.0716145, 0.0904343, 0.127033, 0.180328, 0.235344, 0.287607, 0.334899, 0.37734, 0.414826, 0.449109, 0.480035, 0.508038, 0.533099, 0.556352, 0.577638, 0.597186, 0.615195, 0.631575, 0.647006, 0.661336, 0.674674, 0.686924, 0.698568, 0.709474, 0.719706, 0.729173, 0.738236, 0.746781, 0.754848, 0.762356, 0.769584, 0.776435, 0.782938, 0.789117, 0.794898, 0.800492, 0.805829, 0.810922, 0.815696, 0.820343, 0.824794, 0.82903, 0.833055, 0.834384, 0.885923, 0.914821, 0.931313, 0.939221, 0.944808, 0.957111, 0.947436, 0.955702, 0.947258, 0.939, 1.00255, 0.952886, 0.952257, 0.94236, 1.0162, 0.921623, 1.03109, 0.999897, 0.915295, 0.885316, 1.17325, 1.00996, 0.863428, 0.921136, 0.837098, 1.10389, 1.33207, 0.953998, 0.789266, 0.91086, 0.941532, 0.776648, 0.786064, 1.04877, 1.4918, 1.48727, 1.05195, 0.770583, 0.68413
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N1650[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.399475, 0.0860281, 0.0576561, 0.0484859, 0.0449515, 0.0442284, 0.0453695, 0.0481658, 0.0527791, 0.0602009, 0.0725074, 0.0949854, 0.133342, 0.182389, 0.231846, 0.278186, 0.31999, 0.358692, 0.393884, 0.425928, 0.454722, 0.481525, 0.506125, 0.528767, 0.549664, 0.568701, 0.586661, 0.603362, 0.618924, 0.633231, 0.646844, 0.659605, 0.671588, 0.682683, 0.693312, 0.703339, 0.712813, 0.721635, 0.730132, 0.738191, 0.745842, 0.753115, 0.759927, 0.766522, 0.772809, 0.77881, 0.784453, 0.789932, 0.795174, 0.800201, 0.804929, 0.80652, 0.867575, 0.900735, 0.9207, 0.934172, 0.939936, 0.94792, 0.956272, 0.978829, 0.988334, 0.970454, 0.937321, 0.989319, 0.951971, 0.965555, 0.929103, 1.06463, 0.918502, 0.941359, 1.11414, 0.894101, 0.90536, 0.971843, 1.20696, 0.908638, 0.893119, 0.895816, 0.851682, 1.14018, 1.32215, 0.967089, 0.792375, 0.882987, 0.96454, 0.814736, 0.758811, 0.91297, 1.28909, 1.57901, 1.30591
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N1675[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.357466, 0.0768466, 0.0513976, 0.0431202, 0.0398605, 0.0390782, 0.0399027, 0.0421046, 0.0457532, 0.0515288, 0.0608036, 0.0772901, 0.108232, 0.154746, 0.204758, 0.252465, 0.295761, 0.335944, 0.372522, 0.405846, 0.435799, 0.463684, 0.489278, 0.512835, 0.534577, 0.554382, 0.573067, 0.59044, 0.606629, 0.62151, 0.635669, 0.648941, 0.661403, 0.67294, 0.683993, 0.69442, 0.70427, 0.713442, 0.722276, 0.730652, 0.738605, 0.746164, 0.753244, 0.760102, 0.766636, 0.772866, 0.778728, 0.784431, 0.789873, 0.795083, 0.800018, 0.801654, 0.865042, 0.900339, 0.922651, 0.938952, 0.942952, 0.961983, 0.94248, 0.959126, 0.96321, 0.941101, 0.937402, 1.03919, 0.927144, 1.03956, 0.92127, 1.0992, 0.906324, 0.897798, 1.15471, 0.916621, 0.924916, 0.873877, 1.2137, 1.03252, 0.836693, 0.943856, 0.816012, 0.949852, 1.37906, 1.17576, 0.815123, 0.787266, 0.968762, 0.913305, 0.73915, 0.761967, 1.02747, 1.5123, 1.62055
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N1680[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.304124, 0.0653626, 0.0437039, 0.0366534, 0.0338695, 0.0331896, 0.0338714, 0.0357172, 0.0387829, 0.043643, 0.0514843, 0.0657569, 0.0951163, 0.143198, 0.195339, 0.244789, 0.289452, 0.330758, 0.368262, 0.402361, 0.432962, 0.461413, 0.487497, 0.511482, 0.5336, 0.553733, 0.572715, 0.590352, 0.606779, 0.621871, 0.636223, 0.649671, 0.662293, 0.673972, 0.685156, 0.695703, 0.705664, 0.714935, 0.723861, 0.732323, 0.740355, 0.747992, 0.755149, 0.762072, 0.768647, 0.774918, 0.780856, 0.786618, 0.792054, 0.797331, 0.802334, 0.803986, 0.867921, 0.904047, 0.927846, 0.945777, 0.94768, 0.97582, 0.935472, 0.949766, 0.951417, 0.928448, 0.927438, 1.08112, 0.917535, 1.09139, 0.919234, 1.13808, 0.87928, 0.875424, 1.20437, 0.902065, 0.935811, 0.821748, 1.25376, 1.07635, 0.786033, 0.977018, 0.780268, 0.875222, 1.466, 1.2724, 0.778215, 0.725016, 0.983913, 0.959505, 0.696881, 0.681507, 0.940078, 1.55518, 1.85089
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N1700[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.280146, 0.0600131, 0.0399757, 0.0333805, 0.0306819, 0.0298716, 0.0302374, 0.0315475, 0.0337684, 0.0371989, 0.0423871, 0.0507482, 0.0659827, 0.0980879, 0.145607, 0.195314, 0.241556, 0.284851, 0.324413, 0.360521, 0.393007, 0.423266, 0.451048, 0.476622, 0.500227, 0.521732, 0.54202, 0.560883, 0.578461, 0.594618, 0.609991, 0.6244, 0.637928, 0.650453, 0.662453, 0.673772, 0.684464, 0.69442, 0.704007, 0.7131, 0.721731, 0.729931, 0.737602, 0.745027, 0.752119, 0.758906, 0.765268, 0.771404, 0.777317, 0.78303, 0.788299, 0.790145, 0.858899, 0.897049, 0.917419, 0.928557, 0.942001, 0.935969, 0.984157, 0.941516, 0.933171, 0.947757, 1.05517, 0.930952, 0.919216, 0.992539, 0.903396, 0.894172, 1.12095, 0.908794, 0.878243, 1.26183, 0.832946, 0.933626, 0.844886, 1.37428, 0.970152, 0.791826, 0.983933, 0.758197, 0.889004, 1.50701, 1.28047, 0.773706, 0.707601, 0.963279, 1.0005, 0.711104, 0.653548, 0.850062, 1.39815
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N1710[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.265363, 0.0569198, 0.0379719, 0.0317621, 0.0292554, 0.0285554, 0.0289977, 0.0303798, 0.0326993, 0.0363169, 0.0419307, 0.0514629, 0.0705764, 0.110738, 0.162319, 0.213154, 0.259543, 0.302605, 0.341768, 0.377404, 0.409398, 0.439152, 0.466435, 0.491525, 0.514662, 0.535726, 0.555583, 0.574036, 0.591221, 0.607011, 0.622024, 0.636096, 0.649302, 0.661518, 0.673215, 0.684249, 0.694671, 0.704371, 0.713708, 0.722556, 0.730951, 0.738932, 0.746424, 0.753693, 0.760594, 0.767115, 0.773268, 0.779366, 0.785108, 0.790471, 0.795792, 0.797391, 0.863445, 0.897879, 0.91751, 0.928673, 0.965118, 0.954081, 0.953731, 0.927602, 0.924991, 0.921207, 1.00118, 0.991378, 0.908159, 1.11823, 0.892603, 0.949576, 0.97849, 0.93357, 0.96684, 1.13984, 0.838078, 0.860022, 0.9477, 1.43396, 0.804664, 0.863621, 0.917662, 0.715211, 1.08315, 1.68606, 1.00175, 0.669466, 0.768241, 1.10362, 0.84635, 0.622676, 0.679245, 1.04938, 1.83925
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N1720[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.355382, 0.0761682, 0.0507655, 0.0424174, 0.0390176, 0.0380208, 0.0385274, 0.0402488, 0.0431507, 0.0476303, 0.054406, 0.0652618, 0.0841947, 0.118387, 0.163726, 0.21067, 0.2546, 0.295959, 0.333914, 0.368669, 0.400018, 0.429278, 0.456189, 0.481, 0.503929, 0.524842, 0.54459, 0.562969, 0.58011, 0.595877, 0.61089, 0.62497, 0.638199, 0.650454, 0.662198, 0.673283, 0.68376, 0.693519, 0.702922, 0.711842, 0.720314, 0.72837, 0.735915, 0.743224, 0.750192, 0.756844, 0.763101, 0.769181, 0.774993, 0.780565, 0.785823, 0.78758, 0.855346, 0.892457, 0.914364, 0.927952, 0.943437, 0.944723, 0.960463, 0.944613, 0.941922, 0.94772, 1.00041, 0.965615, 0.935287, 1.01632, 0.927059, 0.94999, 1.0296, 0.920198, 0.95443, 1.11873, 0.886318, 0.907027, 0.942592, 1.23755, 0.943319, 0.86477, 0.925869, 0.822561, 1.00978, 1.36976, 1.125, 0.818069, 0.803429, 0.961289, 0.912383, 0.756675, 0.770971, 1.00087, 1.43023
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N1900[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.941957, 0.200052, 0.131941, 0.108929, 0.0987696, 0.0946015, 0.0938589, 0.0954849, 0.098966, 0.104289, 0.111485, 0.12078, 0.132317, 0.146882, 0.16462, 0.185498, 0.208571, 0.233683, 0.259504, 0.285261, 0.310035, 0.334334, 0.357583, 0.379712, 0.400713, 0.420296, 0.439146, 0.456986, 0.473873, 0.489613, 0.504779, 0.519161, 0.53281, 0.54557, 0.557904, 0.56964, 0.580816, 0.591301, 0.601471, 0.611181, 0.620459, 0.629332, 0.637689, 0.645827, 0.653627, 0.661108, 0.668174, 0.675075, 0.681706, 0.688083, 0.694122, 0.696149, 0.776591, 0.822985, 0.852488, 0.872608, 0.887008, 0.897736, 0.905962, 0.912433, 0.917622, 0.921857, 0.925382, 0.928448, 0.930796, 0.933072, 0.934836, 0.936794, 0.937263, 0.940247, 0.940094, 0.939763, 0.943845, 0.945177, 0.941429, 0.940808, 0.946446, 0.951989, 0.949646, 0.942266, 0.938057, 0.940761, 0.949896, 0.960443, 0.964064, 0.957244, 0.945082, 0.934934, 0.930032, 0.930384, 0.93625
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N1990[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.899838, 0.190335, 0.12497, 0.102668, 0.0925717, 0.0881047, 0.086784, 0.087558, 0.0898983, 0.0936837, 0.0988512, 0.105481, 0.113604, 0.123743, 0.136093, 0.150946, 0.168127, 0.188019, 0.209834, 0.232847, 0.255972, 0.279413, 0.302403, 0.324697, 0.346156, 0.366389, 0.386035, 0.404762, 0.422595, 0.439299, 0.455463, 0.470847, 0.485494, 0.499226, 0.512533, 0.525224, 0.537335, 0.548718, 0.559777, 0.570354, 0.580474, 0.590166, 0.599306, 0.608218, 0.616768, 0.624977, 0.63274, 0.640326, 0.647624, 0.654647, 0.661303, 0.663539, 0.752687, 0.804468, 0.837525, 0.860124, 0.876322, 0.888402, 0.89767, 0.904969, 0.91083, 0.915625, 0.919587, 0.922891, 0.92581, 0.928178, 0.930306, 0.932092, 0.933998, 0.934632, 0.93705, 0.937842, 0.937275, 0.93985, 0.942493, 0.940804, 0.938668, 0.940976, 0.946354, 0.948678, 0.944916, 0.939328, 0.937265, 0.940696, 0.948612, 0.956768, 0.959367, 0.954155, 0.94453, 0.935762, 0.930811
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N2090[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.547537, 0.115759, 0.075968, 0.0623821, 0.0562232, 0.0534908, 0.0526756, 0.0531413, 0.0545725, 0.0569075, 0.0601297, 0.0643292, 0.0695965, 0.0764136, 0.0851963, 0.096681, 0.111557, 0.131145, 0.155145, 0.182223, 0.210212, 0.238763, 0.266665, 0.293523, 0.319158, 0.343129, 0.366225, 0.388084, 0.408763, 0.428021, 0.446554, 0.464107, 0.480742, 0.496272, 0.511264, 0.525509, 0.539056, 0.551748, 0.564043, 0.575766, 0.586953, 0.597638, 0.60769, 0.617466, 0.626825, 0.635791, 0.644251, 0.652502, 0.660423, 0.668031, 0.675228, 0.677643, 0.772649, 0.826549, 0.860343, 0.883103, 0.899216, 0.911105, 0.920137, 0.927115, 0.932448, 0.93677, 0.940311, 0.944655, 0.948044, 0.946439, 0.954568, 0.94806, 0.959633, 0.951661, 0.953052, 0.968774, 0.952005, 0.947827, 0.971458, 0.976397, 0.94919, 0.940037, 0.956257, 0.99176, 0.994232, 0.957433, 0.933579, 0.929618, 0.93862, 0.974378, 1.0225, 1.03334, 0.992903, 0.943441, 0.919132
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N2190[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.64419, 0.13552, 0.0884539, 0.0722069, 0.064645, 0.0610451, 0.0596095, 0.0595612, 0.0605041, 0.0622879, 0.0648255, 0.0681073, 0.072105, 0.0770437, 0.0830145, 0.0902334, 0.0988366, 0.109466, 0.122391, 0.137912, 0.155724, 0.176014, 0.197812, 0.22038, 0.243113, 0.265229, 0.287188, 0.30846, 0.32896, 0.348336, 0.367216, 0.385286, 0.402566, 0.418826, 0.43463, 0.44974, 0.46419, 0.477796, 0.491036, 0.503715, 0.515863, 0.527507, 0.538499, 0.549224, 0.559522, 0.569415, 0.578775, 0.587928, 0.596735, 0.605215, 0.613254, 0.615955, 0.72376, 0.786306, 0.826092, 0.853171, 0.87249, 0.88683, 0.89778, 0.906372, 0.913222, 0.918799, 0.923387, 0.927252, 0.93071, 0.933319, 0.935661, 0.938117, 0.939511, 0.941116, 0.943896, 0.942259, 0.945769, 0.948729, 0.944694, 0.944996, 0.952322, 0.954684, 0.94764, 0.942782, 0.947159, 0.958328, 0.964927, 0.958481, 0.94611, 0.938491, 0.938902, 0.947795, 0.96383, 0.978927, 0.982018
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N2220[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.652174, 0.136947, 0.089207, 0.0726658, 0.0649009, 0.061126, 0.0595153, 0.059275, 0.0599991, 0.0615159, 0.0637249, 0.0665942, 0.0700759, 0.0743378, 0.0794222, 0.0854668, 0.0925334, 0.101093, 0.111331, 0.123549, 0.137719, 0.154318, 0.172854, 0.192811, 0.213601, 0.234367, 0.2554, 0.276093, 0.29627, 0.315518, 0.33441, 0.3526, 0.370083, 0.386601, 0.402715, 0.418169, 0.432988, 0.446976, 0.460618, 0.473707, 0.486269, 0.498332, 0.509735, 0.520877, 0.531589, 0.541894, 0.551653, 0.561206, 0.570409, 0.579277, 0.587692, 0.590521, 0.704068, 0.770489, 0.812948, 0.841943, 0.86268, 0.878101, 0.889896, 0.899156, 0.906568, 0.912612, 0.917611, 0.921808, 0.925295, 0.928268, 0.931138, 0.932961, 0.935632, 0.936473, 0.938938, 0.940248, 0.939891, 0.943316, 0.944714, 0.942076, 0.943238, 0.948743, 0.950258, 0.94535, 0.941803, 0.944912, 0.953138, 0.958909, 0.955678, 0.946628, 0.939529, 0.938348, 0.943804, 0.955107, 0.967785
  };
  G4double G4DetailedBalancePhaseSpaceIntegral::N2250[120] ={
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.542759, 0.113929, 0.0741844, 0.0604044, 0.0539265, 0.050767, 0.0494059, 0.0491821, 0.0497579, 0.0509891, 0.0527922, 0.055141, 0.0579969, 0.0615006, 0.0656931, 0.0707003, 0.0765961, 0.0838194, 0.0926149, 0.103398, 0.116368, 0.132232, 0.150697, 0.171215, 0.19301, 0.215, 0.237373, 0.259414, 0.2809, 0.301375, 0.321445, 0.34074, 0.359257, 0.376728, 0.393746, 0.410046, 0.425659, 0.440377, 0.454716, 0.468459, 0.481637, 0.494278, 0.506218, 0.517874, 0.529072, 0.539835, 0.550021, 0.559985, 0.569577, 0.578814, 0.587573, 0.590516, 0.708123, 0.776373, 0.819735, 0.849195, 0.870171, 0.885711, 0.897553, 0.906816, 0.914212, 0.920259, 0.925245, 0.929333, 0.932567, 0.935876, 0.938643, 0.940018, 0.943325, 0.943691, 0.945354, 0.949409, 0.945395, 0.949301, 0.95534, 0.949088, 0.945845, 0.954916, 0.963318, 0.955738, 0.944675, 0.944206, 0.956147, 0.97232, 0.974246, 0.958813, 0.94258, 0.935782, 0.938211, 0.95113, 0.973955
  };

G4DetailedBalancePhaseSpaceIntegral::
G4DetailedBalancePhaseSpaceIntegral(G4ParticleDefinition * aR) : theR(aR)
{
  G4ResonanceID theID;
  G4int pdg=theR->GetPDGEncoding();
  data=0;
       if(theID.IsDelta1232(pdg)) data = delta;
  else if(theID.IsDelta1600(pdg)) data = delta1600;
  else if(theID.IsDelta1620(pdg)) data = delta1620;
  else if(theID.IsDelta1700(pdg)) data = delta1700;
  else if(theID.IsDelta1900(pdg)) data = delta1900;
  else if(theID.IsDelta1905(pdg)) data = delta1905;
  else if(theID.IsDelta1910(pdg)) data = delta1910;
  else if(theID.IsDelta1920(pdg)) data = delta1920;
  else if(theID.IsDelta1930(pdg)) data = delta1930;
  else if(theID.IsDelta1950(pdg)) data = delta1950;
  
  else if(theID.IsN1440(pdg)) data = N1440;
  else if(theID.IsN1520(pdg)) data = N1520;
  else if(theID.IsN1535(pdg)) data = N1535;
  else if(theID.IsN1650(pdg)) data = N1650;
  else if(theID.IsN1675(pdg)) data = N1675;
  else if(theID.IsN1680(pdg)) data = N1680;
  else if(theID.IsN1700(pdg)) data = N1700;
  else if(theID.IsN1710(pdg)) data = N1710;
  else if(theID.IsN1720(pdg)) data = N1720;
  else if(theID.IsN1900(pdg)) data = N1900;
  else if(theID.IsN1990(pdg)) data = N1990;
  else if(theID.IsN2090(pdg)) data = N2090;
  else if(theID.IsN2190(pdg)) data = N2190;
  else if(theID.IsN2220(pdg)) data = N2220;
  else if(theID.IsN2250(pdg)) data = N2250;
}

G4double G4DetailedBalancePhaseSpaceIntegral::
GetPhaseSpaceIntegral(G4double sqs)
{
  G4double result = 0;
  G4int it=0;
  for(G4int ie=0; ie<120; ie++)
  {
    if(sqrts[ie]*GeV>sqs) break;
    it = ie;
  }
  G4double x1=sqrts[it]*GeV;
  G4double x2=sqrts[it+1]*GeV;
  G4double y1=data[it];
  G4double y2=data[it+1];
  result = y1+(sqs-x1)*(y2-y1)/(x2-x1);
  return result;
}

