//$Id: momo.java,v 1.9 2004/11/11 05:34:46 suzuki Exp $
// 2001 Dec start
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// 2010 Nov 19 for Geant4.9.4

import GPE.*;

//import GAG.*;
import GAG.*;
//import Gain.*;

import GGE.*;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.lang.Runtime.*;
import java.io.*;
import javax.swing.text.*;
import java.lang.System.*;
import javax.swing.*;
import javax.swing.filechooser.*;

//import ExampleFileFilter;


public class momo{
  public static void main(String[] args){
  TabbedPaneFrame frame = new TabbedPaneFrame();
      frame.setVisible(true);     ////show();
      frame.gagrun();
   }
}
class TabbedPaneFrame extends JFrame implements ChangeListener, ActionListener{

   private JFileChooser fileChooser;
   private String fileName;
   JMenuBar mbar;
   JMenu fileJM, projectJM, helpJM;
   JMenuItem openMI, exitMI, makefileMI, compileMI, /*executeMI,*/ cleanMI,
       makeMainMI, aboutMOMO, aboutEnvMI, aboutGGEMI, aboutGPEMI, aboutGAGMI;

   JButton g4workdirBT;
   JTextField g4target, g4workdir;
    private MOMOpipe pipeMake, pipeClean;
    private ErrStream errStreamMake, errStreamClean;
    EnvPanel envPanel;
    EnvVariable envVars;
    String envName[], g4workdirpath;
    PhysicsFrame physicsFrame;
    VolumesFrame volumesFrame;
    GGE.SourceFrame momomake, mainprog;
    GAG  gagPanel;
 //   Gain gainPanel;

  public TabbedPaneFrame(){
      setTitle("Momo");
      mbar = new JMenuBar();
         mbar.setBorderPainted(true);
      setJMenuBar(mbar);         

      Container container = getContentPane();
      BoxLayout containerlayout = new BoxLayout(container,BoxLayout.Y_AXIS);
      container.setLayout(containerlayout);

      JPanel g4targetbase = new JPanel();
      g4targetbase.setLayout(new BoxLayout(g4targetbase, BoxLayout.X_AXIS));

      container.add(g4targetbase);

      fileJM = new JMenu("File");
         fileJM.setFont(new Font("Serif", Font.BOLD, 14));
	  fileJM.setBackground(Color.green);
      mbar.add(fileJM);
         fileJM.add(openMI = new JMenuItem("Open"));
	  fileJM.addSeparator();
	  fileJM.add(exitMI = new JMenuItem("exit"));


      projectJM = new JMenu("Project");
         projectJM.setFont(new Font("Serif", Font.BOLD, 14));
      mbar.add(projectJM);
         projectJM.add(makeMainMI = new JMenuItem("Main Program"));
         projectJM.add(makefileMI = new JMenuItem("Makefile"));
	  projectJM.add(compileMI = new JMenuItem("Compile"));
	 //projectJM.add(executeMI = new JMenuItem("Execute"));
	  projectJM.add(cleanMI = new JMenuItem("make Clean"));



      helpJM = new JMenu("Help");
         helpJM.setFont(new Font("Serif", Font.BOLD, 14));
         //      mbar.setHelpMenu(helpJM);  // not implemented
      mbar.add(helpJM);
         helpJM.add(aboutMOMO = new JMenuItem("About MOMO"));

         momomake = new GGE.SourceFrame();
         mainprog = new GGE.SourceFrame();

      openMI.addActionListener(this);
      exitMI.addActionListener(this);
      makeMainMI.addActionListener(this);
      makefileMI.addActionListener(this);
      compileMI.addActionListener(this);
      //executeMI.addActionListener(this);
      cleanMI.addActionListener(this);
      aboutMOMO.addActionListener(this);


      //      g4target = new JTextField(", that is, the name of the main program.");
      g4target = new JTextField();
      g4target.setColumns(30);
      g4targetbase.add(new JLabel("Typein G4TARGET name"));
      g4targetbase.add(g4target);
      g4targetbase.add(Box.createHorizontalGlue());   // not effective???

      //set Geant4 WorkDirectory
      g4workdirBT = new JButton("set GEANT4 WORKDIR");
      EnvVariable envVars = new EnvVariable();
      g4workdirpath = String.valueOf(envVars.get("G4WORKDIR"));
      g4workdir   = new JTextField(g4workdirpath);
      g4workdirBT.addActionListener(this);
      g4workdir.addActionListener(this);
      g4targetbase.add(g4workdirBT);
      g4targetbase.add(g4workdir);



      setSize(900,700);  //width for MaterialTable, height for PhysicsFrame

      addWindowListener(new WindowAdapter(){  
	      public void windowClosing(WindowEvent e){
		  System.exit(0);
            }
         } );


      JTabbedPane momotabbedPane = new JTabbedPane();
      momotabbedPane.addChangeListener(this);


      envPanel = new EnvPanel();

      physicsFrame = new PhysicsFrame();
       //VolumesFrame 
      volumesFrame = new VolumesFrame();

	//GAG
	gagPanel = new GAG();
	    //gagPanel.mainLoop();

        //Gain
//	    gainPanel = new Gain();

      ImageIcon icon = new ImageIcon("yellow-ball.gif");
      // Env Variables
      momotabbedPane.addTab("Env Vars",icon,envPanel);
        momotabbedPane.setForegroundAt(0, Color.red);
//	momotabbedPane.addTab("em Physics", icon, physicsFrame);
//	momotabbedPane.setForegroundAt(1, Color.blue);

      momotabbedPane.addTab("Volumes", icon, volumesFrame);
      momotabbedPane.addTab("Materials", icon, volumesFrame.matFrame);
         momotabbedPane.setForegroundAt(1, Color.cyan);
	  momotabbedPane.setForegroundAt(2, Color.magenta);
      momotabbedPane.addTab("GAG", icon, gagPanel);        
	momotabbedPane.setForegroundAt(3, Color.darkGray);
//      momotabbedPane.addTab("Gain", icon, gainPanel);
//	momotabbedPane.setForegroundAt(4, Color.pink);
      container.add(momotabbedPane, "Center");

      setPath( g4workdirpath );
   }

// For medical project
   public void getPath(){
     JFrame frame = new JFrame("HIBMC HOME PATH");
     Container c = frame.getContentPane();

     JLabel label = new JLabel("Enter the Absolute Path of HIBMC");
     c.add(label);
     JTextField text = new JTextField("/home/");
     text.setColumns(20);
     c.add(text);

     JButton button = new JButton("...");
     button.addActionListener(this);

     JFileChooser dataPath = new JFileChooser(".");

    dataPath.setDialogTitle("HIBMC Data Directory");
    dataPath.setDialogType(JFileChooser.CUSTOM_DIALOG);
    dataPath.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY );

    if(dataPath.showDialog(this,"choose") == JFileChooser.CANCEL_OPTION) return;
    File fl = dataPath.getCurrentDirectory();
    text.setText( fl.getPath() );
   }


public void gagrun(){
	gagPanel.mainLoop();
}

public void actionPerformed(ActionEvent ae){

    Object o = ae.getSource();

    if( o == aboutMOMO ){
	FileView fv = new FileView();
	fv.setVisible(true);
	}


    if( o == makefileMI ){ 

	if ( g4target.getText().trim().equals("")){
	JFrame noTframe = new JFrame();
	JOptionPane.showMessageDialog(noTframe, "Please Specify the Target Name or main program name",
				      "Warning Dialog", JOptionPane.WARNING_MESSAGE);
	return;
	}
         try{
	     // create Makefile just like binmake.gmk
     StringBuffer gmake = new StringBuffer(getMakefile());
     momomake.setVisible(true);
     momomake.editor.setText(getMakefile());
     momomake.setPath("."  ); /// was g4workdirpath
     // show in the editor and output to a file
     fileName = "GNUmakefile";
     FileOutputStream libfile = new FileOutputStream(fileName);
     PrintWriter liboutPut = new PrintWriter(new DataOutputStream(libfile));
     liboutPut.println(gmake.toString());
     liboutPut.close();

         }catch(IOException ie){
         System.out.println(ie.toString());
         }
 }

    if( o == makeMainMI ){ 

	if ( g4target.getText().trim().equals("")){
	JFrame noTframe = new JFrame();
	JOptionPane.showMessageDialog(noTframe, "Please Specify the Target Name or main program name",
				      "Warning Dialog", JOptionPane.WARNING_MESSAGE);

	return;
	}
         try{

     StringBuffer maincc = new StringBuffer( getMain() );
     mainprog.setVisible(true);
     mainprog.editor.setText(getMain());
     mainprog.setPath( "." );///was g4workdirpath
     // show in the editor and
     // save to file
     String mainfileName = g4target.getText() + ".cc";
     FileOutputStream mainfile = new FileOutputStream(mainfileName);
     PrintWriter mainoutPut = new PrintWriter(new DataOutputStream(mainfile));
     mainoutPut.println(maincc.toString());
     mainoutPut.close();

         }catch(IOException ie){
         System.out.println(ie.toString());
         }
 }
   else if( o == compileMI ){ 
       //try{
	    String cmdMake="make"; 
	    //System.out.println("Make Started");
	    if((pipeMake = new MOMOpipe(cmdMake)) == null){
		System.out.println("MOMOpipe error");}
	    else {
                 errStreamMake = new ErrStream(pipeMake);
		 errStreamMake.start();
              }
	    //}catch(IOException ie){
	    //System.out.println(ie.toString());
	    //}
    }
   /*else if( o == executeMI ){
	try{
	    //	    System.out.println("GAG Started");
	    //	    String cmdGAG="java -cp ./GAG.jar gag";  // G4OBJECT name will be specifed
	    String cmdGAG="gag";  // G4OBJECT name will be specifed
	    Runtime rGAG = Runtime.getRuntime();
	    Process pGAG = rGAG.exec(cmdGAG);
        }catch(IOException ie){
	    System.out.println(ie.toString());
	}
    }*/
   else if( o == cleanMI ){ 
       //try{
	    String cmdClean="make clean"; 
	    //System.out.println("Make clean Started");
	    if((pipeClean = new MOMOpipe(cmdClean)) == null){
		System.out.println("MOMOpipe error");
            }else {
		errStreamClean = new ErrStream(pipeClean);
		errStreamClean.start();
	    }
	    //} catch(IOException ie){
	    //System.out.println(ie.toString());
	    //}
    }

    else if( o == openMI ){ ; } // not implemented
   else if( o == exitMI ){ System.exit(0); }
   else if( o == g4workdirBT ){ loadPath(); setPath(g4workdir.getText()); }
   else if( o == g4workdir ){  g4workdirpath = g4workdir.getText();
    setPath( g4workdirpath );
   }
}

   public void setPath(String path){
 if( path.equals("null")){ path = "."; }
// temporarily set to the currect dir before better one is set
    String currentDir = ".";
    volumesFrame.workdirpath = currentDir; //path;
    volumesFrame.sf.workdirpath = currentDir; //path;
    volumesFrame.includesf.workdirpath = currentDir; //path;
    volumesFrame.xmlf.workdirpath = currentDir; //path;
    volumesFrame.matFrame.workdirpath = currentDir; //path;

    physicsFrame.workdirpath  = currentDir; //path;
    physicsFrame.source.workdirpath  = currentDir; //path;
    physicsFrame.include.workdirpath  = currentDir; //path;

     gagPanel.workdirpath = path; // use as it is

     momomake.workdirpath = currentDir; //path;
     mainprog.workdirpath = currentDir; //path;
   }

   public void stateChanged(ChangeEvent event){
      JTabbedPane pane = (JTabbedPane)event.getSource();

      // check if this tab still has a null component

      if (pane.getSelectedComponent() == null)

      {  // set the component to the image icon

         int n = pane.getSelectedIndex();

         String title = pane.getTitleAt(n);
         ImageIcon planetIcon = new ImageIcon(title + ".gif");
         pane.setComponentAt(n, new JLabel(planetIcon));

         // indicate that this tab has been visited--just for fun

         pane.setIconAt(n, new ImageIcon("red-ball.gif"));
      }
   }


    String getMakefile(){
 // create Makefile just like binmake.gmk
     StringBuffer gmake = new StringBuffer("##### GNUmakefile #####\n");
     gmake.append("# ----------------------------------------------------------\n");
     gmake.append("# Script defining rules and paths for making binaries.\n");
     gmake.append("# ----------------------------------------------------------\n");
     gmake.append("# Automatic creation of GNUmakefile for Momo environment.\n");
     gmake.append("# with users selection of G4TARGET, UI and VIS variables\n" );
     gmake.append("#  Momo is the name of legendary samurai who conquered the malicious geants. ----   H. Yoshida.\n");
     gmake.append("\n");

    // define target, VIS and UI macros
     gmake.append("name := " + g4target.getText() + "\n");
     gmake.append("G4TARGET := $(name)\n");
     gmake.append("G4EXLIB := true\n");
     gmake.append("\n");
     gmake.append("# Vis/GUI used\n");
     for(int i = 0; i < envPanel.visguiuseName.length; i++){
     if( envPanel.checkU[i].isSelected())gmake.append(envPanel.visguiuseName[i]+" := 1\n");
     }
//     gmake.append("# Vis/GUI built\n");
//     for(int i = 0; i < envPanel.visguibuildName.length; i++){
//     if( envPanel.checkB[i].isSelected())gmake.append(envPanel.visguibuildName[i]+" := 1\n");
//     }
     gmake.append("\n");
     gmake.append("# General Envs defined\n");

     for(int i = 0; i < envPanel.envName.length; i++){
	 if( !(envPanel.textF[i].getText().trim().equals("null"))){
	          gmake.append((String)envPanel.envName[i] + ":="+
			    (String)envPanel.textF[i].getText() +   "\n");
	 }
     }
     gmake.append("\n");
     gmake.append("ifndef G4INSTALL\n");
     gmake.append("   G4INSTALL = ../../..\n");
     gmake.append("endif\n");

     gmake.append("\n");
     gmake.append(".PHONY: all\n");
     gmake.append("all: lib bin\n");
     gmake.append("\n");
     gmake.append("  include $(G4INSTALL)/config/binmake.gmk\n");
     gmake.append("\n");

     return gmake.toString();

    }//getMakefile

    String getMain(){
     Date today = new Date();
     StringBuffer maincc = new StringBuffer("//##### MOMO Main program #####\n");
     maincc.append("//# ----------------------------------------------------------\n");
     maincc.append("//# Automatic creation of the main program for Momo environment.\n");
     maincc.append("// 2010 December, updated for  geant4.9.4\n");
//     maincc.append("//\n");
//     maincc.append("//  MOMO main program\n");
     maincc.append("// --------------------------------------------------------------\n");

     maincc.append("//   " +  g4target.getText() + ".cc generated by Geant4 Momo\n");
     maincc.append("//     at " + today.toString() + "  \n\n");

     maincc.append("\n");
     ///////////////////////////////////////
     maincc.append("// This code implementation is the intellectual property of\n");
     maincc.append("// the  GEANT4 collaboration.\n");
     maincc.append("//\n");
     maincc.append("// By copying, distributing or modifying the Program (or any work\n");
     maincc.append("// based on the Program) you indicate your acceptance of this statement,\n");
     maincc.append("// and all its terms.\n");
     maincc.append("//\n");
     maincc.append("// \n");

     maincc.append("#include \"G4RunManager.hh\"\n");
     maincc.append("#include \"G4UImanager.hh\"\n");
     maincc.append("// Your choice of User Interface driver\n");

     maincc.append("#include \"G4UIGAG.hh\"\n");

     maincc.append("// Detector geometry generated by Momo's GGE\n");

     maincc.append("#include \""+ volumesFrame.classNameField.getText().trim() +".hh\"\n");

   maincc.append("// temporary using a pre-tuned Physics List\n");
     maincc.append("#include \"QGSP_BERT.hh\"\n");
//     maincc.append("#include \""+ physicsFrame.physicsClassName.getText().trim()+".hh\"\n");

     maincc.append("// Momo's default PrimaryGeneratorAction\n");

     maincc.append("#include \"MomoPrimaryGeneratorAction.hh\"\n");
     maincc.append("#include \"MomoRunAction.hh\"\n");
     maincc.append("#include \"MomoEventAction.hh\"\n");

     maincc.append("#ifdef G4VIS_USE\n");
     maincc.append("#include \"G4VisExecutive.hh\"\n");
     maincc.append("#endif\n");

     maincc.append("int main()\n");
     maincc.append("{\n");
     maincc.append("  // Construct the default run manager\n");
     maincc.append("  G4RunManager* runManager = new G4RunManager;\n");

     maincc.append("  // set mandatory initialization classes\n");
     maincc.append("  runManager->SetUserInitialization(new "+  volumesFrame.classNameField.getText().trim()+");\n");
//     maincc.append("  runManager->SetUserInitialization(new " +physicsFrame.physicsClassName.getText().trim() +");\n");
     maincc.append("  G4VUserPhysicsList* physics = new QGSP_BERT();\n");
     maincc.append("  runManager->SetUserInitialization(physics);\n");
     maincc.append("#ifdef G4VIS_USE\n");
     maincc.append("  // visualization manager\n");
     maincc.append("  G4VisManager* visManager = new G4VisExecutive;\n");
     maincc.append("  visManager->Initialize();\n");
     maincc.append("#endif\n");

     maincc.append("  // set mandatory user action class\n");
     maincc.append("  runManager->SetUserAction(new MomoPrimaryGeneratorAction);\n");
     maincc.append("  // set user action classes to visualise trajectories\n");
     maincc.append("  runManager->SetUserAction(new MomoRunAction);\n");
     maincc.append("  runManager->SetUserAction(new MomoEventAction);\n");

     maincc.append("  // Initialize G4 kernel\n");
     maincc.append("  runManager->Initialize();\n");

     maincc.append("  // get the pointer to the User Interface manager \n");
     maincc.append("  G4UImanager* UI = G4UImanager::GetUIpointer();\n");

     maincc.append("      G4UIsession * session = new G4UIGAG;\n");
     maincc.append("      session->SessionStart();\n");
     maincc.append("      delete session;\n");
 

     maincc.append("  // job termination\n");
     maincc.append("#ifdef G4VIS_USE\n");
     maincc.append("  delete visManager;\n");
     maincc.append("#endif\n");

     maincc.append("  delete runManager;\n");
     maincc.append("  return 0;\n");
     maincc.append("}\n");

     return maincc.toString();
    }//getMain

   public void loadPath(){
     if( g4workdirpath.equals("null")){ g4workdirpath = "."; }
     JFileChooser dataPath = new JFileChooser( g4workdirpath );

    dataPath.setDialogTitle("set GEANT4 WORKDIR");
    dataPath.setDialogType(JFileChooser.CUSTOM_DIALOG);
    dataPath.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES );

    if(dataPath.showDialog(this,"choose") == JFileChooser.CANCEL_OPTION) return;
    //dataPath.setMultiSelectionEnabled(true);
    //File fl = dataPath.getSelectedFile();
    File fl = dataPath.getCurrentDirectory();

    g4workdir.setText( fl.getPath() );
    g4workdirpath = fl.getPath();
   }
}





