/*
# <<BEGIN-copyright>>
# Copyright (c) 2010, Lawrence Livermore National Security, LLC. 
# Produced at the Lawrence Livermore National Laboratory 
# Written by Bret R. Beck, beck6@llnl.gov. 
# CODE-461393
# All rights reserved. 
#  
# This file is part of GIDI. For details, see nuclear.llnl.gov. 
# Please also read the "Additional BSD Notice" at nuclear.llnl.gov. 
# 
# Redistribution and use in source and binary forms, with or without modification, 
# are permitted provided that the following conditions are met: 
#
#      1) Redistributions of source code must retain the above copyright notice, 
#         this list of conditions and the disclaimer below.
#      2) Redistributions in binary form must reproduce the above copyright notice, 
#         this list of conditions and the disclaimer (as noted below) in the 
#          documentation and/or other materials provided with the distribution.
#      3) Neither the name of the LLNS/LLNL nor the names of its contributors may be 
#         used to endorse or promote products derived from this software without 
#         specific prior written permission. 
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT 
# SHALL LAWRENCE LIVERMORE NATIONAL SECURITY, LLC, THE U.S. DEPARTMENT OF ENERGY OR 
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
# OR SERVICES;  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
# AND ON  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
# <<END-copyright>>
*/
#include <string.h>
#include <statusMessageReporting.h>
#include <tpia_mass.h>

#include <string>

#if defined __cplusplus
namespace GIDI {
using namespace GIDI;
#endif

struct ZAMass {
    //char *symbol;
    std::string symbol;
    double mass;
};

static struct ZAMass ZAMasses[] = {
         { "Am_242_m1", 2.420595491590000e+02 + 0.048 },
         { "FissionProductENDL99120", 117.5 },
         { "FissionProductENDL99121", 116.546 },
         { "FissionProductENDL99122", 118.544 },
         { "FissionProductENDL99125", 117.5 },
         { "gamma",      0. },
         { "n_1",        1.008664915740000e+00 }, { "H_natural",  1.007900000000000e+00 }, { "H_1",        1.007825032070000e+00 }, { "H_2",        2.014101777850000e+00 },
         { "H_3",        3.016049277670000e+00 }, { "H_4",        4.027806424000000e+00 }, { "H_5",        5.035311488000000e+00 }, { "H_6",        6.044942594000000e+00 },
         { "H_7",        7.052749000000000e+00 }, { "He_natural", 4.002600000000000e+00 }, { "He_3",       3.016029319140000e+00 }, { "He_4",       4.002603254150000e+00 },
         { "He_5",       5.012223624000000e+00 }, { "He_6",       6.018889124000000e+00 }, { "He_7",       7.028020618000000e+00 }, { "He_8",       8.033921897000001e+00 },
         { "He_9",       9.043950285999999e+00 }, { "He_10",      1.005239883700000e+01 }, { "Li_natural", 6.941000000000000e+00 }, { "Li_3",       3.030775000000000e+00 },
         { "Li_4",       4.027185558000000e+00 }, { "Li_5",       5.012537800000000e+00 }, { "Li_6",       6.015122794000000e+00 }, { "Li_7",       7.016004548000000e+00 },
         { "Li_8",       8.022487362000000e+00 }, { "Li_9",       9.026789505000000e+00 }, { "Li_10",      1.003548125900000e+01 }, { "Li_11",      1.104379771500000e+01 },
         { "Li_12",      1.205378000000000e+01 }, { "Be_natural", 9.012180000000001e+00 }, { "Be_5",       5.040790000000000e+00 }, { "Be_6",       6.019726317000000e+00 },
         { "Be_7",       7.016929828000000e+00 }, { "Be_8",       8.005305103000000e+00 }, { "Be_9",       9.012182201000000e+00 }, { "Be_10",      1.001353381800000e+01 },
         { "Be_11",      1.102165774900000e+01 }, { "Be_12",      1.202692073700000e+01 }, { "Be_13",      1.303569300700000e+01 }, { "Be_14",      1.404289292000000e+01 },
         { "Be_15",      1.505346000000000e+01 }, { "Be_16",      1.606192000000000e+01 }, { "B_natural",  1.081000000000000e+01 }, { "B_6",        6.046810000000000e+00 },
         { "B_7",        7.029917901000000e+00 }, { "B_8",        8.024607232999999e+00 }, { "B_9",        9.013328782000000e+00 }, { "B_10",       1.001293699200000e+01 },
         { "B_11",       1.100930540600000e+01 }, { "B_12",       1.201435210400000e+01 }, { "B_13",       1.301778021700000e+01 }, { "B_14",       1.402540400900000e+01 },
         { "B_15",       1.503110302100000e+01 }, { "B_16",       1.603980882900000e+01 }, { "B_17",       1.704698990600000e+01 }, { "B_18",       1.805617000000000e+01 },
         { "B_19",       1.906373000000000e+01 }, { "C_natural",  1.201100000000000e+01 }, { "C_8",        8.037675025000000e+00 }, { "C_9",        9.031036689000000e+00 },
         { "C_10",       1.001685322800000e+01 }, { "C_11",       1.101143361300000e+01 }, { "C_12",       1.200000000000000e+01 }, { "C_13",       1.300335483778000e+01 },
         { "C_14",       1.400324198870000e+01 }, { "C_15",       1.501059925600000e+01 }, { "C_16",       1.601470125200000e+01 }, { "C_17",       1.702258611600000e+01 },
         { "C_18",       1.802675935400000e+01 }, { "C_19",       1.903480501800000e+01 }, { "C_20",       2.004031975400000e+01 }, { "C_21",       2.104934000000000e+01 },
         { "C_23",       2.205720000000000e+01 }, { "N_natural",  1.400670000000000e+01 }, { "N_10",       1.004165367400000e+01 }, { "N_11",       1.102609095600000e+01 },
         { "N_12",       1.201861319700000e+01 }, { "N_13",       1.300573860900000e+01 }, { "N_14",       1.400307400478000e+01 }, { "N_15",       1.500010889823000e+01 },
         { "N_16",       1.600610165800000e+01 }, { "N_17",       1.700845026100000e+01 }, { "N_18",       1.801407895900000e+01 }, { "N_19",       1.901702869700000e+01 },
         { "N_20",       2.002336580700000e+01 }, { "N_21",       2.102710824000000e+01 }, { "N_22",       2.203439493400000e+01 }, { "N_23",       2.304122000000000e+01 },
         { "N_24",       2.405104000000000e+01 }, { "N_25",       2.506066000000000e+01 }, { "O_natural",  1.599940000000000e+01 }, { "O_12",       1.203440489500000e+01 },
         { "O_13",       1.302481221300000e+01 }, { "O_14",       1.400859625000000e+01 }, { "O_15",       1.500306561700000e+01 }, { "O_16",       1.599491461956000e+01 },
         { "O_17",       1.699913170300000e+01 }, { "O_18",       1.799916100100000e+01 }, { "O_19",       1.900358013000000e+01 }, { "O_20",       2.000407674200000e+01 },
         { "O_21",       2.100865588600000e+01 }, { "O_22",       2.200996694700000e+01 }, { "O_23",       2.301568765900000e+01 }, { "O_24",       2.402047291700000e+01 },
         { "O_25",       2.502946000000000e+01 }, { "O_26",       2.603834000000000e+01 }, { "O_27",       2.704826000000000e+01 }, { "O_28",       2.805781000000000e+01 },
         { "F_natural",  1.899840300000000e+01 }, { "F_14",       1.403506000000000e+01 }, { "F_15",       1.501800910300000e+01 }, { "F_16",       1.601146572400000e+01 },
         { "F_17",       1.700209523700000e+01 }, { "F_18",       1.800093795600000e+01 }, { "F_19",       1.899840322400000e+01 }, { "F_20",       1.999998131500000e+01 },
         { "F_21",       2.099994895100000e+01 }, { "F_22",       2.200299881500000e+01 }, { "F_23",       2.300357463100000e+01 }, { "F_24",       2.400811548500000e+01 },
         { "F_25",       2.501210174700000e+01 }, { "F_26",       2.601961555500000e+01 }, { "F_27",       2.702676008600000e+01 }, { "F_28",       2.803567000000000e+01 },
         { "F_29",       2.904326000000000e+01 }, { "F_30",       3.005250000000000e+01 }, { "F_31",       3.106042900000000e+01 }, { "Ne_natural", 2.017900000000000e+01 },
         { "Ne_16",      1.602576126200000e+01 }, { "Ne_17",      1.701767150400000e+01 }, { "Ne_18",      1.800570821300000e+01 }, { "Ne_19",      1.900188024800000e+01 },
         { "Ne_20",      1.999244017542000e+01 }, { "Ne_21",      2.099384668400000e+01 }, { "Ne_22",      2.199138511300000e+01 }, { "Ne_23",      2.299446690400000e+01 },
         { "Ne_24",      2.399361077900000e+01 }, { "Ne_25",      2.499773688800000e+01 }, { "Ne_26",      2.600046120600000e+01 }, { "Ne_27",      2.700758990300000e+01 },
         { "Ne_28",      2.801207157500000e+01 }, { "Ne_29",      2.901938593300000e+01 }, { "Ne_30",      3.002480104500000e+01 }, { "Ne_31",      3.103311000000000e+01 },
         { "Ne_32",      3.204002000000000e+01 }, { "Ne_33",      3.304938000000000e+01 }, { "Ne_34",      3.405702800000000e+01 }, { "Na_natural", 2.298977000000000e+01 },
         { "Na_18",      1.802596900000000e+01 }, { "Na_19",      1.901387749900000e+01 }, { "Na_20",      2.000735132800000e+01 }, { "Na_21",      2.099765520600000e+01 },
         { "Na_22",      2.199443642500000e+01 }, { "Na_23",      2.298976928087000e+01 }, { "Na_24",      2.399096278200000e+01 }, { "Na_25",      2.498995396800000e+01 },
         { "Na_26",      2.599263300000000e+01 }, { "Na_27",      2.699407678800000e+01 }, { "Na_28",      2.799893800000000e+01 }, { "Na_29",      2.900286100000000e+01 },
         { "Na_30",      3.000897600000000e+01 }, { "Na_31",      3.101358545200000e+01 }, { "Na_32",      3.202046656000000e+01 }, { "Na_33",      3.302671975600000e+01 },
         { "Na_34",      3.403517000000000e+01 }, { "Na_35",      3.504249300000000e+01 }, { "Na_36",      3.605148000000000e+01 }, { "Na_37",      3.705934000000000e+01 },
         { "Mg_natural", 2.430500000000000e+01 }, { "Mg_19",      1.903547000000000e+01 }, { "Mg_20",      2.001886254500000e+01 }, { "Mg_21",      2.101171291000000e+01 },
         { "Mg_22",      2.199957384300000e+01 }, { "Mg_23",      2.299412366900000e+01 }, { "Mg_24",      2.398504169900000e+01 }, { "Mg_25",      2.498583691700000e+01 },
         { "Mg_26",      2.598259292900000e+01 }, { "Mg_27",      2.698434058500000e+01 }, { "Mg_28",      2.798387682500000e+01 }, { "Mg_29",      2.898860000000000e+01 },
         { "Mg_30",      2.999043400000000e+01 }, { "Mg_31",      3.099654600000000e+01 }, { "Mg_32",      3.199897500000000e+01 }, { "Mg_33",      3.300525400000000e+01 },
         { "Mg_34",      3.400945642400000e+01 }, { "Mg_35",      3.501734000000000e+01 }, { "Mg_36",      3.602300000000000e+01 }, { "Mg_37",      3.703140000000000e+01 },
         { "Mg_38",      3.803757000000000e+01 }, { "Mg_39",      3.904677200000000e+01 }, { "Mg_40",      4.005393000000000e+01 }, { "Al_natural", 2.698154000000000e+01 },
         { "Al_21",      2.102804000000000e+01 }, { "Al_22",      2.201952000000000e+01 }, { "Al_23",      2.300726743200000e+01 }, { "Al_24",      2.399993886500000e+01 },
         { "Al_25",      2.499042809500000e+01 }, { "Al_26",      2.598689169200000e+01 }, { "Al_27",      2.698153862700000e+01 }, { "Al_28",      2.798191030600000e+01 },
         { "Al_29",      2.898044504600000e+01 }, { "Al_30",      2.998296025600000e+01 }, { "Al_31",      3.098394661900000e+01 }, { "Al_32",      3.198812448900000e+01 },
         { "Al_33",      3.299084333600000e+01 }, { "Al_34",      3.399685183700000e+01 }, { "Al_35",      3.499986023500000e+01 }, { "Al_36",      3.600620720400000e+01 },
         { "Al_37",      3.701067782000000e+01 }, { "Al_38",      3.801723102100000e+01 }, { "Al_39",      3.902297000000000e+01 }, { "Al_40",      4.003145000000000e+01 },
         { "Al_41",      4.103833000000000e+01 }, { "Al_42",      4.204689000000000e+01 }, { "Si_natural", 2.808550000000000e+01 }, { "Si_22",      2.203453000000000e+01 },
         { "Si_23",      2.302552000000000e+01 }, { "Si_24",      2.401154561600000e+01 }, { "Si_25",      2.500410557400000e+01 }, { "Si_26",      2.599232992100000e+01 },
         { "Si_27",      2.698670490500000e+01 }, { "Si_28",      2.797692653246000e+01 }, { "Si_29",      2.897649470000000e+01 }, { "Si_30",      2.997377017100000e+01 },
         { "Si_31",      3.097536322700000e+01 }, { "Si_32",      3.197414808200000e+01 }, { "Si_33",      3.297800022000000e+01 }, { "Si_34",      3.397857552400000e+01 },
         { "Si_35",      3.498458357500000e+01 }, { "Si_36",      3.598659947700000e+01 }, { "Si_37",      3.699293608000000e+01 }, { "Si_38",      3.799563360100000e+01 },
         { "Si_39",      3.900207001300000e+01 }, { "Si_40",      4.000586912100000e+01 }, { "Si_41",      4.101456000000000e+01 }, { "Si_42",      4.201979000000000e+01 },
         { "Si_43",      4.302866000000000e+01 }, { "Si_44",      4.403526000000000e+01 }, { "P_natural",  3.097376000000000e+01 }, { "P_24",       2.403435000000000e+01 },
         { "P_25",       2.502026000000000e+01 }, { "P_26",       2.601178000000000e+01 }, { "P_27",       2.699923023600000e+01 }, { "P_28",       2.799231476100000e+01 },
         { "P_29",       2.898180060600000e+01 }, { "P_30",       2.997831378900000e+01 }, { "P_31",       3.097376162900000e+01 }, { "P_32",       3.197390727400000e+01 },
         { "P_33",       3.297172554300000e+01 }, { "P_34",       3.397363625700000e+01 }, { "P_35",       3.497331411700000e+01 }, { "P_36",       3.597825968000000e+01 },
         { "P_37",       3.697960894600000e+01 }, { "P_38",       3.798415682700000e+01 }, { "P_39",       3.898617947500000e+01 }, { "P_40",       3.999129695100000e+01 },
         { "P_41",       4.099433543500000e+01 }, { "P_42",       4.200100791300000e+01 }, { "P_43",       4.300619000000000e+01 }, { "P_44",       4.401299000000000e+01 },
         { "P_45",       4.501922000000000e+01 }, { "P_46",       4.602738000000000e+01 }, { "S_natural",  3.206000000000000e+01 }, { "S_26",       2.602788000000000e+01 },
         { "S_27",       2.701883300000000e+01 }, { "S_28",       2.800437276300000e+01 }, { "S_29",       2.899660804900000e+01 }, { "S_30",       2.998490324900000e+01 },
         { "S_31",       3.097955472800000e+01 }, { "S_32",       3.197207099900000e+01 }, { "S_33",       3.297145875900000e+01 }, { "S_34",       3.396786690200000e+01 },
         { "S_35",       3.496903216100000e+01 }, { "S_36",       3.596708076000000e+01 }, { "S_37",       3.697112556700000e+01 }, { "S_38",       3.797116331700000e+01 },
         { "S_39",       3.897513430600000e+01 }, { "S_40",       3.997545172800000e+01 }, { "S_41",       4.097958214900000e+01 }, { "S_42",       4.198102241900000e+01 },
         { "S_43",       4.298715479000000e+01 }, { "S_44",       4.399021339000000e+01 }, { "S_45",       4.499650811200000e+01 }, { "S_46",       4.600075000000000e+01 },
         { "S_47",       4.700859000000000e+01 }, { "S_48",       4.801417000000000e+01 }, { "S_49",       4.902361900000000e+01 }, { "Cl_natural", 3.545300000000000e+01 },
         { "Cl_28",      2.802851000000000e+01 }, { "Cl_29",      2.901411000000000e+01 }, { "Cl_30",      3.000477000000000e+01 }, { "Cl_31",      3.099241308600000e+01 },
         { "Cl_32",      3.198568990100000e+01 }, { "Cl_33",      3.297745188700000e+01 }, { "Cl_34",      3.397376281900000e+01 }, { "Cl_35",      3.496885268200000e+01 },
         { "Cl_36",      3.596830698100000e+01 }, { "Cl_37",      3.696590259100000e+01 }, { "Cl_38",      3.796801042500000e+01 }, { "Cl_39",      3.896800816400000e+01 },
         { "Cl_40",      3.997041547200000e+01 }, { "Cl_41",      4.097068452500000e+01 }, { "Cl_42",      4.197325480400000e+01 }, { "Cl_43",      4.297405440300000e+01 },
         { "Cl_44",      4.397828107100000e+01 }, { "Cl_45",      4.498028688600000e+01 }, { "Cl_46",      4.598421004000000e+01 }, { "Cl_47",      4.698871000000000e+01 },
         { "Cl_48",      4.799495000000000e+01 }, { "Cl_49",      4.900032000000000e+01 }, { "Cl_50",      5.000784000000000e+01 }, { "Cl_51",      5.101449000000000e+01 },
         { "Ar_natural", 3.994800000000000e+01 }, { "Ar_30",      3.002156000000000e+01 }, { "Ar_31",      3.101212300000000e+01 }, { "Ar_32",      3.199763798400000e+01 },
         { "Ar_33",      3.298992570900000e+01 }, { "Ar_34",      3.398027124400000e+01 }, { "Ar_35",      3.497525758500000e+01 }, { "Ar_36",      3.596754510500000e+01 },
         { "Ar_37",      3.696677632000000e+01 }, { "Ar_38",      3.796273239400000e+01 }, { "Ar_39",      3.896431323100000e+01 }, { "Ar_40",      3.996238312251000e+01 },
         { "Ar_41",      4.096450061100000e+01 }, { "Ar_42",      4.196304573600000e+01 }, { "Ar_43",      4.296563605600000e+01 }, { "Ar_44",      4.396492403300000e+01 },
         { "Ar_45",      4.496803995600000e+01 }, { "Ar_46",      4.596809412900000e+01 }, { "Ar_47",      4.697218679200000e+01 }, { "Ar_48",      4.797454000000000e+01 },
         { "Ar_49",      4.898052000000000e+01 }, { "Ar_50",      4.998443000000000e+01 }, { "Ar_51",      5.099163000000000e+01 }, { "Ar_52",      5.199678000000000e+01 },
         { "Ar_53",      5.300494000000000e+01 }, { "K_natural",  3.909830000000000e+01 }, { "K_32",       3.202192000000000e+01 }, { "K_33",       3.300726000000000e+01 },
         { "K_34",       3.399841000000000e+01 }, { "K_35",       3.498800969200000e+01 }, { "K_36",       3.598129223500000e+01 }, { "K_37",       3.697337588900000e+01 },
         { "K_38",       3.796908118400000e+01 }, { "K_39",       3.896370667900000e+01 }, { "K_40",       3.996399847500000e+01 }, { "K_41",       4.096182576200000e+01 },
         { "K_42",       4.196240281000000e+01 }, { "K_43",       4.296071554000000e+01 }, { "K_44",       4.396155680400000e+01 }, { "K_45",       4.496069949300000e+01 },
         { "K_46",       4.596197686400000e+01 }, { "K_47",       4.696167847300000e+01 }, { "K_48",       4.796551353500000e+01 }, { "K_49",       4.896745092800000e+01 },
         { "K_50",       4.997278335500000e+01 }, { "K_51",       5.097638000000000e+01 }, { "K_52",       5.198261000000000e+01 }, { "K_53",       5.298712000000000e+01 },
         { "K_54",       5.399420000000000e+01 }, { "K_55",       5.499971000000000e+01 }, { "Ca_natural", 4.008000000000000e+01 }, { "Ca_34",      3.401412000000000e+01 },
         { "Ca_35",      3.500494000000000e+01 }, { "Ca_36",      3.599308706300000e+01 }, { "Ca_37",      3.698587026900000e+01 }, { "Ca_38",      3.797631845200000e+01 },
         { "Ca_39",      3.897071972500000e+01 }, { "Ca_40",      3.996259098300000e+01 }, { "Ca_41",      4.096227806200000e+01 }, { "Ca_42",      4.195861801400000e+01 },
         { "Ca_43",      4.295876662800000e+01 }, { "Ca_44",      4.395548175400000e+01 }, { "Ca_45",      4.495618656600000e+01 }, { "Ca_46",      4.595369258700000e+01 },
         { "Ca_47",      4.695454600600000e+01 }, { "Ca_48",      4.795253417700000e+01 }, { "Ca_49",      4.895567414800000e+01 }, { "Ca_50",      4.995751896200000e+01 },
         { "Ca_51",      5.096149921400000e+01 }, { "Ca_52",      5.196510000000000e+01 }, { "Ca_53",      5.297005000000000e+01 }, { "Ca_54",      5.397435000000000e+01 },
         { "Ca_55",      5.498055000000000e+01 }, { "Ca_56",      5.598557000000000e+01 }, { "Ca_57",      5.699235600000000e+01 }, { "Sc_natural", 4.495590000000000e+01 },
         { "Sc_36",      3.601492000000000e+01 }, { "Sc_37",      3.700305000000000e+01 }, { "Sc_38",      3.799470000000000e+01 }, { "Sc_39",      3.898479000200000e+01 },
         { "Sc_40",      3.997796740700000e+01 }, { "Sc_41",      4.096925112500000e+01 }, { "Sc_42",      4.196551642900000e+01 }, { "Sc_43",      4.296115065800000e+01 },
         { "Sc_44",      4.395940275200000e+01 }, { "Sc_45",      4.495591190900000e+01 }, { "Sc_46",      4.595517189000000e+01 }, { "Sc_47",      4.695240750800000e+01 },
         { "Sc_48",      4.795223146800000e+01 }, { "Sc_49",      4.895002397500000e+01 }, { "Sc_50",      4.995218768500000e+01 }, { "Sc_51",      5.095360336800000e+01 },
         { "Sc_52",      5.195667546800000e+01 }, { "Sc_53",      5.295961000000000e+01 }, { "Sc_54",      5.396326456100000e+01 }, { "Sc_55",      5.496824394900000e+01 },
         { "Sc_56",      5.597287000000000e+01 }, { "Sc_57",      5.697779000000000e+01 }, { "Sc_58",      5.798371000000000e+01 }, { "Sc_59",      5.898922000000000e+01 },
         { "Sc_60",      5.999571000000000e+01 }, { "Ti_natural", 4.790000000000000e+01 }, { "Ti_38",      3.800977000000000e+01 }, { "Ti_39",      3.900161000000000e+01 },
         { "Ti_40",      3.999049883800000e+01 }, { "Ti_41",      4.098314500000000e+01 }, { "Ti_42",      4.197303090200000e+01 }, { "Ti_43",      4.296852249900000e+01 },
         { "Ti_44",      4.395969006900000e+01 }, { "Ti_45",      4.495812561600000e+01 }, { "Ti_46",      4.595263155500000e+01 }, { "Ti_47",      4.695176308800000e+01 },
         { "Ti_48",      4.794794628100000e+01 }, { "Ti_49",      4.894786998200000e+01 }, { "Ti_50",      4.994479119400000e+01 }, { "Ti_51",      5.094661495500000e+01 },
         { "Ti_52",      5.194689731100000e+01 }, { "Ti_53",      5.294972717100000e+01 }, { "Ti_54",      5.395105240100000e+01 }, { "Ti_55",      5.495526505600000e+01 },
         { "Ti_56",      5.595819963900000e+01 }, { "Ti_57",      5.696398913700000e+01 }, { "Ti_58",      5.796697000000000e+01 }, { "Ti_59",      5.897293000000000e+01 },
         { "Ti_60",      5.997676000000000e+01 }, { "Ti_61",      6.098320000000000e+01 }, { "Ti_62",      6.198749000000000e+01 }, { "Ti_63",      6.299442000000000e+01 },
         { "V_natural",  5.094150000000000e+01 }, { "V_40",       4.001109000000000e+01 }, { "V_41",       4.099978000000000e+01 }, { "V_42",       4.199123000000000e+01 },
         { "V_43",       4.298065000000000e+01 }, { "V_44",       4.397411000000000e+01 }, { "V_45",       4.496577580800000e+01 }, { "V_46",       4.596020048100000e+01 },
         { "V_47",       4.695490894000000e+01 }, { "V_48",       4.795225370700000e+01 }, { "V_49",       4.894851610100000e+01 }, { "V_50",       4.994715848500000e+01 },
         { "V_51",       5.094395950700000e+01 }, { "V_52",       5.194477547900000e+01 }, { "V_53",       5.294433797900000e+01 }, { "V_54",       5.394643985400000e+01 },
         { "V_55",       5.494723370100000e+01 }, { "V_56",       5.595053096600000e+01 }, { "V_57",       5.695256143200000e+01 }, { "V_58",       5.795683413600000e+01 },
         { "V_59",       5.896020740700000e+01 }, { "V_60",       5.996502686200000e+01 }, { "V_61",       6.096848000000000e+01 }, { "V_62",       6.197378000000000e+01 },
         { "V_63",       6.297755000000000e+01 }, { "V_64",       6.398347000000000e+01 }, { "V_65",       6.498792000000000e+01 }, { "Cr_natural", 5.199600000000000e+01 },
         { "Cr_42",      4.200643000000000e+01 }, { "Cr_43",      4.299771000000000e+01 }, { "Cr_44",      4.398554900000000e+01 }, { "Cr_45",      4.497964000000000e+01 },
         { "Cr_46",      4.596835863500000e+01 }, { "Cr_47",      4.696290004600000e+01 }, { "Cr_48",      4.795403171600000e+01 }, { "Cr_49",      4.895133572100000e+01 },
         { "Cr_50",      4.994604420500000e+01 }, { "Cr_51",      5.094476743100000e+01 }, { "Cr_52",      5.194050747200000e+01 }, { "Cr_53",      5.294064938600000e+01 },
         { "Cr_54",      5.393888039500000e+01 }, { "Cr_55",      5.494083967200000e+01 }, { "Cr_56",      5.594065313900000e+01 }, { "Cr_57",      5.694361301300000e+01 },
         { "Cr_58",      5.794435312900000e+01 }, { "Cr_59",      5.894858636700000e+01 }, { "Cr_60",      5.995007603300000e+01 }, { "Cr_61",      6.095471720400000e+01 },
         { "Cr_62",      6.195661319000000e+01 }, { "Cr_63",      6.296186000000000e+01 }, { "Cr_64",      6.396441000000000e+01 }, { "Cr_65",      6.497016000000001e+01 },
         { "Cr_66",      6.597338000000001e+01 }, { "Cr_67",      6.697955000000000e+01 }, { "Mn_natural", 5.493800000000000e+01 }, { "Mn_44",      4.400687000000000e+01 },
         { "Mn_45",      4.499451000000000e+01 }, { "Mn_46",      4.598672000000000e+01 }, { "Mn_47",      4.697610000000000e+01 }, { "Mn_48",      4.796852000000000e+01 },
         { "Mn_49",      4.895961800500000e+01 }, { "Mn_50",      4.995423823000000e+01 }, { "Mn_51",      5.094821078700000e+01 }, { "Mn_52",      5.194556546400000e+01 },
         { "Mn_53",      5.294129011700000e+01 }, { "Mn_54",      5.394035885400000e+01 }, { "Mn_55",      5.493804514100000e+01 }, { "Mn_56",      5.593890491000000e+01 },
         { "Mn_57",      5.693828537800000e+01 }, { "Mn_58",      5.793998154900000e+01 }, { "Mn_59",      5.894044023700000e+01 }, { "Mn_60",      5.994291124600000e+01 },
         { "Mn_61",      6.094465263800000e+01 }, { "Mn_62",      6.194842822000000e+01 }, { "Mn_63",      6.295023999000000e+01 }, { "Mn_64",      6.395424909000000e+01 },
         { "Mn_65",      6.495633606500000e+01 }, { "Mn_66",      6.596108000000000e+01 }, { "Mn_67",      6.696414000000000e+01 }, { "Mn_68",      6.796930000000000e+01 },
         { "Mn_69",      6.897284000000001e+01 }, { "Fe_natural", 5.584700000000000e+01 }, { "Fe_45",      4.501457800000000e+01 }, { "Fe_46",      4.600081000000000e+01 },
         { "Fe_47",      4.699289000000000e+01 }, { "Fe_48",      4.798050400000000e+01 }, { "Fe_49",      4.897361000000000e+01 }, { "Fe_50",      4.996298898200000e+01 },
         { "Fe_51",      5.095681953800000e+01 }, { "Fe_52",      5.194811387500000e+01 }, { "Fe_53",      5.294530794200000e+01 }, { "Fe_54",      5.393961050100000e+01 },
         { "Fe_55",      5.493829335700000e+01 }, { "Fe_56",      5.593493747500000e+01 }, { "Fe_57",      5.693539396900000e+01 }, { "Fe_58",      5.793327555800000e+01 },
         { "Fe_59",      5.893487546400000e+01 }, { "Fe_60",      5.993407168300000e+01 }, { "Fe_61",      6.093674528100000e+01 }, { "Fe_62",      6.193676744200000e+01 },
         { "Fe_63",      6.294036909100000e+01 }, { "Fe_64",      6.394120126500000e+01 }, { "Fe_65",      6.494538027000000e+01 }, { "Fe_66",      6.594678063800001e+01 },
         { "Fe_67",      6.695094724400001e+01 }, { "Fe_68",      6.795370000000000e+01 }, { "Fe_69",      6.895878000000000e+01 }, { "Fe_70",      6.996146000000000e+01 },
         { "Fe_71",      7.096672000000000e+01 }, { "Fe_72",      7.196962000000001e+01 }, { "Co_natural", 5.893320000000000e+01 }, { "Co_47",      4.701149000000000e+01 },
         { "Co_48",      4.800176000000000e+01 }, { "Co_49",      4.898972000000000e+01 }, { "Co_50",      4.998154000000000e+01 }, { "Co_51",      5.097072000000000e+01 },
         { "Co_52",      5.196359000000000e+01 }, { "Co_53",      5.295421889600000e+01 }, { "Co_54",      5.394845963500000e+01 }, { "Co_55",      5.494199902900000e+01 },
         { "Co_56",      5.593983927800000e+01 }, { "Co_57",      5.693629137300000e+01 }, { "Co_58",      5.793575281400000e+01 }, { "Co_59",      5.893319504800000e+01 },
         { "Co_60",      5.993381705900000e+01 }, { "Co_61",      6.093247576300000e+01 }, { "Co_62",      6.193405056300000e+01 }, { "Co_63",      6.293361161100000e+01 },
         { "Co_64",      6.393580990800000e+01 }, { "Co_65",      6.493647846000000e+01 }, { "Co_66",      6.593976200400000e+01 }, { "Co_67",      6.694088952900000e+01 },
         { "Co_68",      6.794487305800000e+01 }, { "Co_69",      6.894632000000000e+01 }, { "Co_70",      6.995099999999999e+01 }, { "Co_71",      7.095290000000000e+01 },
         { "Co_72",      7.195780999999999e+01 }, { "Co_73",      7.296024000000000e+01 }, { "Co_74",      7.396538000000000e+01 }, { "Co_75",      7.496832999999999e+01 },
         { "Ni_natural", 5.870000000000000e+01 }, { "Ni_48",      4.801975000000000e+01 }, { "Ni_49",      4.900966000000000e+01 }, { "Ni_50",      4.999593000000000e+01 },
         { "Ni_51",      5.098772000000000e+01 }, { "Ni_52",      5.197568000000000e+01 }, { "Ni_53",      5.296847000000000e+01 }, { "Ni_54",      5.395790549500000e+01 },
         { "Ni_55",      5.495133025100000e+01 }, { "Ni_56",      5.594213202200000e+01 }, { "Ni_57",      5.693979352600000e+01 }, { "Ni_58",      5.793534290700000e+01 },
         { "Ni_59",      5.893434670500000e+01 }, { "Ni_60",      5.993078637200000e+01 }, { "Ni_61",      6.093105603300000e+01 }, { "Ni_62",      6.192834511500000e+01 },
         { "Ni_63",      6.292966937400000e+01 }, { "Ni_64",      6.392796595900000e+01 }, { "Ni_65",      6.493008430400000e+01 }, { "Ni_66",      6.592913933400000e+01 },
         { "Ni_67",      6.693156941399999e+01 }, { "Ni_68",      6.793186878900001e+01 }, { "Ni_69",      6.893561026899999e+01 }, { "Ni_70",      6.993650000000000e+01 },
         { "Ni_71",      7.094073628300001e+01 }, { "Ni_72",      7.194209268199999e+01 }, { "Ni_73",      7.294647000000001e+01 }, { "Ni_74",      7.394807000000000e+01 },
         { "Ni_75",      7.495287000000000e+01 }, { "Ni_76",      7.595533000000000e+01 }, { "Ni_77",      7.696055000000000e+01 }, { "Ni_78",      7.796317999999999e+01 },
         { "Cu_natural", 6.354600000000000e+01 }, { "Cu_52",      5.199718000000000e+01 }, { "Cu_53",      5.298555000000000e+01 }, { "Cu_54",      5.397671000000000e+01 },
         { "Cu_55",      5.496605000000000e+01 }, { "Cu_56",      5.595856000000000e+01 }, { "Cu_57",      5.694921107800000e+01 }, { "Cu_58",      5.794453849900000e+01 },
         { "Cu_59",      5.893949802800000e+01 }, { "Cu_60",      5.993736503000000e+01 }, { "Cu_61",      6.093345782100000e+01 }, { "Cu_62",      6.193258374500000e+01 },
         { "Cu_63",      6.292959747400000e+01 }, { "Cu_64",      6.392976418300000e+01 }, { "Cu_65",      6.492778948500001e+01 }, { "Cu_66",      6.592886881299999e+01 },
         { "Cu_67",      6.692773031400000e+01 }, { "Cu_68",      6.792961088900000e+01 }, { "Cu_69",      6.892942926900000e+01 }, { "Cu_70",      6.993239234300000e+01 },
         { "Cu_71",      7.093267683300000e+01 }, { "Cu_72",      7.193582030700000e+01 }, { "Cu_73",      7.293667528200000e+01 }, { "Cu_74",      7.393987486200000e+01 },
         { "Cu_75",      7.494190000000000e+01 }, { "Cu_76",      7.594527502600000e+01 }, { "Cu_77",      7.694785000000000e+01 }, { "Cu_78",      7.795196000000000e+01 },
         { "Cu_79",      7.895456000000000e+01 }, { "Cu_80",      7.996087000000000e+01 }, { "Zn_natural", 6.538000000000000e+01 }, { "Zn_54",      5.399295000000000e+01 },
         { "Zn_55",      5.498398000000000e+01 }, { "Zn_56",      5.597238000000000e+01 }, { "Zn_57",      5.696478800000000e+01 }, { "Zn_58",      5.795459155500000e+01 },
         { "Zn_59",      5.894926376400000e+01 }, { "Zn_60",      5.994182703500000e+01 }, { "Zn_61",      6.093951063500000e+01 }, { "Zn_62",      6.193432976400000e+01 },
         { "Zn_63",      6.293321156600000e+01 }, { "Zn_64",      6.392914222200000e+01 }, { "Zn_65",      6.492924098400000e+01 }, { "Zn_66",      6.592603341900001e+01 },
         { "Zn_67",      6.692712734500000e+01 }, { "Zn_68",      6.792484415400000e+01 }, { "Zn_69",      6.892655028100000e+01 }, { "Zn_70",      6.992531927400000e+01 },
         { "Zn_71",      7.092772159899999e+01 }, { "Zn_72",      7.192685795100000e+01 }, { "Zn_73",      7.292977910400000e+01 }, { "Zn_74",      7.392945860899999e+01 },
         { "Zn_75",      7.493293674100001e+01 }, { "Zn_76",      7.593329357000000e+01 }, { "Zn_77",      7.693695896700000e+01 }, { "Zn_78",      7.793844021600000e+01 },
         { "Zn_79",      7.894265200000000e+01 }, { "Zn_80",      7.994434234800001e+01 }, { "Zn_81",      8.095048000000000e+01 }, { "Zn_82",      8.195442000000000e+01 },
         { "Zn_83",      8.296102999999999e+01 }, { "Ga_natural", 6.972000000000000e+01 }, { "Ga_56",      5.599491000000000e+01 }, { "Ga_57",      5.698293000000000e+01 },
         { "Ga_58",      5.797425000000000e+01 }, { "Ga_59",      5.896337000000000e+01 }, { "Ga_60",      5.995706000000000e+01 }, { "Ga_61",      6.094944628700000e+01 },
         { "Ga_62",      6.194417523800000e+01 }, { "Ga_63",      6.293929419600000e+01 }, { "Ga_64",      6.393683874700000e+01 }, { "Ga_65",      6.493273475399999e+01 },
         { "Ga_66",      6.593158901000000e+01 }, { "Ga_67",      6.692820170300000e+01 }, { "Ga_68",      6.792798008400000e+01 }, { "Ga_69",      6.892557358700000e+01 },
         { "Ga_70",      6.992602197200000e+01 }, { "Ga_71",      7.092470134900000e+01 }, { "Ga_72",      7.192636626800000e+01 }, { "Ga_73",      7.292517468200001e+01 },
         { "Ga_74",      7.392694576200000e+01 }, { "Ga_75",      7.492650024600000e+01 }, { "Ga_76",      7.592882762600000e+01 }, { "Ga_77",      7.692915429999999e+01 },
         { "Ga_78",      7.793160818000000e+01 }, { "Ga_79",      7.893289326000000e+01 }, { "Ga_80",      7.993651578100000e+01 }, { "Ga_81",      8.093775235500000e+01 },
         { "Ga_82",      8.194298999999999e+01 }, { "Ga_83",      8.294698000000000e+01 }, { "Ga_84",      8.395265000000001e+01 }, { "Ga_85",      8.495699999999999e+01 },
         { "Ga_86",      8.596312000000000e+01 }, { "Ge_natural", 7.259000000000000e+01 }, { "Ge_58",      5.799101000000000e+01 }, { "Ge_59",      5.898175000000000e+01 },
         { "Ge_60",      5.997019000000000e+01 }, { "Ge_61",      6.096379000000000e+01 }, { "Ge_62",      6.195465000000000e+01 }, { "Ge_63",      6.294964000000000e+01 },
         { "Ge_64",      6.394165300000000e+01 }, { "Ge_65",      6.493943640600000e+01 }, { "Ge_66",      6.593384345299999e+01 }, { "Ge_67",      6.693273407000000e+01 },
         { "Ge_68",      6.792809423999999e+01 }, { "Ge_69",      6.892796453299999e+01 }, { "Ge_70",      6.992424738100000e+01 }, { "Ge_71",      7.092495095400000e+01 },
         { "Ge_72",      7.192207581500000e+01 }, { "Ge_73",      7.292345894499999e+01 }, { "Ge_74",      7.392117776700000e+01 }, { "Ge_75",      7.492285894800000e+01 },
         { "Ge_76",      7.592140255699999e+01 }, { "Ge_77",      7.692354859100000e+01 }, { "Ge_78",      7.792285273900001e+01 }, { "Ge_79",      7.892540099500000e+01 },
         { "Ge_80",      7.992537239200000e+01 }, { "Ge_81",      8.092882046699999e+01 }, { "Ge_82",      8.192954972500000e+01 }, { "Ge_83",      8.293462000000000e+01 },
         { "Ge_84",      8.393747000000000e+01 }, { "Ge_85",      8.494302999999999e+01 }, { "Ge_86",      8.594649000000000e+01 }, { "Ge_87",      8.695251000000000e+01 },
         { "Ge_88",      8.795690999999999e+01 }, { "Ge_89",      8.896383000000000e+01 }, { "As_natural", 7.492160000000000e+01 }, { "As_60",      5.999313000000000e+01 },
         { "As_61",      6.098062000000000e+01 }, { "As_62",      6.197320000000000e+01 }, { "As_63",      6.296369000000000e+01 }, { "As_64",      6.395757200000000e+01 },
         { "As_65",      6.494956400000000e+01 }, { "As_66",      6.594471000000000e+01 }, { "As_67",      6.693918607099999e+01 }, { "As_68",      6.793676906899999e+01 },
         { "As_69",      6.893227367500000e+01 }, { "As_70",      6.993092482599999e+01 }, { "As_71",      7.092711242800000e+01 }, { "As_72",      7.192675228300000e+01 },
         { "As_73",      7.292382484399999e+01 }, { "As_74",      7.392392869200000e+01 }, { "As_75",      7.492159647800000e+01 }, { "As_76",      7.592239402100000e+01 },
         { "As_77",      7.692064728600000e+01 }, { "As_78",      7.792182728100001e+01 }, { "As_79",      7.892094793400000e+01 }, { "As_80",      7.992253381600000e+01 },
         { "As_81",      8.092213228700000e+01 }, { "As_82",      8.192450406700000e+01 }, { "As_83",      8.292498002400001e+01 }, { "As_84",      8.392905800000000e+01 },
         { "As_85",      8.493201999999999e+01 }, { "As_86",      8.593650000000000e+01 }, { "As_87",      8.693989999999999e+01 }, { "As_88",      8.794494000000000e+01 },
         { "As_89",      8.894938999999999e+01 }, { "As_90",      8.995550000000000e+01 }, { "As_91",      9.096043000000000e+01 }, { "As_92",      9.196680000000001e+01 },
         { "Se_natural", 7.895999999999999e+01 }, { "Se_65",      6.496465999999999e+01 }, { "Se_66",      6.595520999999999e+01 }, { "Se_67",      6.695009000000000e+01 },
         { "Se_68",      6.794179800000001e+01 }, { "Se_69",      6.893955781699999e+01 }, { "Se_70",      6.993339064400000e+01 }, { "Se_71",      7.093224182199999e+01 },
         { "Se_72",      7.192711235199999e+01 }, { "Se_73",      7.292676534500001e+01 }, { "Se_74",      7.392247643600000e+01 }, { "Se_75",      7.492252336800000e+01 },
         { "Se_76",      7.591921359700000e+01 }, { "Se_77",      7.691991403800000e+01 }, { "Se_78",      7.791730909000000e+01 }, { "Se_79",      7.891849909800000e+01 },
         { "Se_80",      7.991652127099999e+01 }, { "Se_81",      8.091799247400000e+01 }, { "Se_82",      8.191669940100000e+01 }, { "Se_83",      8.291911847300000e+01 },
         { "Se_84",      8.391846235400000e+01 }, { "Se_85",      8.492224505300000e+01 }, { "Se_86",      8.592427157900001e+01 }, { "Se_87",      8.692852135800000e+01 },
         { "Se_88",      8.793142399800000e+01 }, { "Se_89",      8.893644999999999e+01 }, { "Se_90",      8.993996000000000e+01 }, { "Se_91",      9.094596000000000e+01 },
         { "Se_92",      9.194992000000001e+01 }, { "Se_93",      9.295629000000000e+01 }, { "Se_94",      9.396048999999999e+01 }, { "Br_natural", 7.990400000000000e+01 },
         { "Br_67",      6.696478999999999e+01 }, { "Br_68",      6.795851600000000e+01 }, { "Br_69",      6.895010600000001e+01 }, { "Br_70",      6.994479200000001e+01 },
         { "Br_71",      7.093874000000000e+01 }, { "Br_72",      7.193664457200001e+01 }, { "Br_73",      7.293169152400000e+01 }, { "Br_74",      7.392989103399999e+01 },
         { "Br_75",      7.492577620700000e+01 }, { "Br_76",      7.592454146900000e+01 }, { "Br_77",      7.692137908200000e+01 }, { "Br_78",      7.792114570600000e+01 },
         { "Br_79",      7.891833708700000e+01 }, { "Br_80",      7.991852929600000e+01 }, { "Br_81",      8.091629056300000e+01 }, { "Br_82",      8.191680411900001e+01 },
         { "Br_83",      8.291518042100000e+01 }, { "Br_84",      8.391647897400000e+01 }, { "Br_85",      8.491560840299999e+01 }, { "Br_86",      8.591879757700001e+01 },
         { "Br_87",      8.692071132400000e+01 }, { "Br_88",      8.792406592600000e+01 }, { "Br_89",      8.892638533400000e+01 }, { "Br_90",      8.993062773699999e+01 },
         { "Br_91",      9.093396809500000e+01 }, { "Br_92",      9.193925871400000e+01 }, { "Br_93",      9.294305000000000e+01 }, { "Br_94",      9.394868000000000e+01 },
         { "Br_95",      9.495287000000000e+01 }, { "Br_96",      9.595853000000000e+01 }, { "Br_97",      9.696280000000000e+01 }, { "Kr_natural", 8.380000000000000e+01 },
         { "Kr_69",      6.896518000000000e+01 }, { "Kr_70",      6.995525900000000e+01 }, { "Kr_71",      7.094962573799999e+01 }, { "Kr_72",      7.194209203800000e+01 },
         { "Kr_73",      7.293928919500000e+01 }, { "Kr_74",      7.393308436900000e+01 }, { "Kr_75",      7.493094574600001e+01 }, { "Kr_76",      7.592591007800000e+01 },
         { "Kr_77",      7.692467000000001e+01 }, { "Kr_78",      7.792036478300000e+01 }, { "Kr_79",      7.892008243100000e+01 }, { "Kr_80",      7.991637896500001e+01 },
         { "Kr_81",      8.091659201500001e+01 }, { "Kr_82",      8.191348360000001e+01 }, { "Kr_83",      8.291413609900000e+01 }, { "Kr_84",      8.391150668700000e+01 },
         { "Kr_85",      8.491252733100001e+01 }, { "Kr_86",      8.591061072900000e+01 }, { "Kr_87",      8.691335486200001e+01 }, { "Kr_88",      8.791444696900000e+01 },
         { "Kr_89",      8.891763058100000e+01 }, { "Kr_90",      8.991951655500000e+01 }, { "Kr_91",      9.092344521500000e+01 }, { "Kr_92",      9.192615621000000e+01 },
         { "Kr_93",      9.293127435700001e+01 }, { "Kr_94",      9.393436000000000e+01 }, { "Kr_95",      9.493984000000000e+01 }, { "Kr_96",      9.594307000000001e+01 },
         { "Kr_97",      9.694856000000000e+01 }, { "Kr_98",      9.795191000000000e+01 }, { "Kr_99",      9.895760000000000e+01 }, { "Kr_100",     9.996114000000000e+01 },
         { "Rb_natural", 8.546780000000000e+01 }, { "Rb_71",      7.096532000000001e+01 }, { "Rb_72",      7.195908000000000e+01 }, { "Rb_73",      7.295056099999999e+01 },
         { "Rb_74",      7.394426475100001e+01 }, { "Rb_75",      7.493857000000000e+01 }, { "Rb_76",      7.593507222600000e+01 }, { "Rb_77",      7.693040800000000e+01 },
         { "Rb_78",      7.792814100000000e+01 }, { "Rb_79",      7.892398946000000e+01 }, { "Rb_80",      7.992251924999999e+01 }, { "Rb_81",      8.091899591300000e+01 },
         { "Rb_82",      8.191820859800001e+01 }, { "Rb_83",      8.291510970100001e+01 }, { "Rb_84",      8.391438482100000e+01 }, { "Rb_85",      8.491178973700001e+01 },
         { "Rb_86",      8.591116741899999e+01 }, { "Rb_87",      8.690918052600000e+01 }, { "Rb_88",      8.791131558799999e+01 }, { "Rb_89",      8.891227801600000e+01 },
         { "Rb_90",      8.991480169400000e+01 }, { "Rb_91",      9.091653695799999e+01 }, { "Rb_92",      9.191972890000000e+01 }, { "Rb_93",      9.292204187599999e+01 },
         { "Rb_94",      9.392640494600001e+01 }, { "Rb_95",      9.492930288900000e+01 }, { "Rb_96",      9.593427263700001e+01 }, { "Rb_97",      9.693735191600000e+01 },
         { "Rb_98",      9.794179066800000e+01 }, { "Rb_99",      9.894537928299999e+01 }, { "Rb_100",     9.994987000000000e+01 }, { "Rb_101",     1.009531964450000e+02 },
         { "Rb_102",     1.019588700000000e+02 }, { "Sr_natural", 8.762000000000000e+01 }, { "Sr_73",      7.296597000000000e+01 }, { "Sr_74",      7.395631000000000e+01 },
         { "Sr_75",      7.494994956799999e+01 }, { "Sr_76",      7.594176678200000e+01 }, { "Sr_77",      7.693794478200000e+01 }, { "Sr_78",      7.793218000000000e+01 },
         { "Sr_79",      7.892970800000001e+01 }, { "Sr_80",      7.992452101300000e+01 }, { "Sr_81",      8.092321184600000e+01 }, { "Sr_82",      8.191840163900000e+01 },
         { "Sr_83",      8.291755670100000e+01 }, { "Sr_84",      8.391342527499999e+01 }, { "Sr_85",      8.491293280300000e+01 }, { "Sr_86",      8.590926020400001e+01 },
         { "Sr_87",      8.690887712400000e+01 }, { "Sr_88",      8.790561212400000e+01 }, { "Sr_89",      8.890745067500001e+01 }, { "Sr_90",      8.990773788800000e+01 },
         { "Sr_91",      9.091020309500000e+01 }, { "Sr_92",      9.191103785800000e+01 }, { "Sr_93",      9.291402563400000e+01 }, { "Sr_94",      9.391536131200000e+01 },
         { "Sr_95",      9.491935876600000e+01 }, { "Sr_96",      9.592169680200000e+01 }, { "Sr_97",      9.692615292300000e+01 }, { "Sr_98",      9.792845293400001e+01 },
         { "Sr_99",      9.893324092600000e+01 }, { "Sr_100",     9.993535191100000e+01 }, { "Sr_101",     1.009405178880000e+02 }, { "Sr_102",     1.019430189870000e+02 },
         { "Sr_103",     1.029489500000000e+02 }, { "Sr_104",     1.039523300000000e+02 }, { "Sr_105",     1.049585800000000e+02 }, { "Y_natural",  8.890590000000000e+01 },
         { "Y_76",       7.595845000000000e+01 }, { "Y_77",       7.694964500000000e+01 }, { "Y_78",       7.794361000000001e+01 }, { "Y_79",       7.893735163400000e+01 },
         { "Y_80",       7.993428000000000e+01 }, { "Y_81",       8.092912746800000e+01 }, { "Y_82",       8.192679245100000e+01 }, { "Y_83",       8.292235424300000e+01 },
         { "Y_84",       8.392038826400000e+01 }, { "Y_85",       8.491643303900000e+01 }, { "Y_86",       8.591488557600000e+01 }, { "Y_87",       8.691087573000000e+01 },
         { "Y_88",       8.790950114600000e+01 }, { "Y_89",       8.890584829500000e+01 }, { "Y_90",       8.990715188599999e+01 }, { "Y_91",       9.090730479100000e+01 },
         { "Y_92",       9.190894914300000e+01 }, { "Y_93",       9.290958271300001e+01 }, { "Y_94",       9.391159524500000e+01 }, { "Y_95",       9.491282062099999e+01 },
         { "Y_96",       9.591589134300000e+01 }, { "Y_97",       9.691813399500001e+01 }, { "Y_98",       9.792220302000000e+01 }, { "Y_99",       9.892463620400000e+01 },
         { "Y_100",      9.992775658600000e+01 }, { "Y_101",      1.009303138500000e+02 }, { "Y_102",      1.019335556950000e+02 }, { "Y_103",      1.029367300000000e+02 },
         { "Y_104",      1.039410500000000e+02 }, { "Y_105",      1.049448700000000e+02 }, { "Y_106",      1.059497900000000e+02 }, { "Y_107",      1.069541400000000e+02 },
         { "Y_108",      1.079594800000000e+02 }, { "Zr_natural", 9.122000000000000e+01 }, { "Zr_78",      7.795523000000000e+01 }, { "Zr_79",      7.894916000000001e+01 },
         { "Zr_80",      7.994040000000000e+01 }, { "Zr_81",      8.093721002600000e+01 }, { "Zr_82",      8.193108700000001e+01 }, { "Zr_83",      8.292865380100000e+01 },
         { "Zr_84",      8.392325000000000e+01 }, { "Zr_85",      8.492147118200000e+01 }, { "Zr_86",      8.591647359100000e+01 }, { "Zr_87",      8.691481625199999e+01 },
         { "Zr_88",      8.791022690400000e+01 }, { "Zr_89",      8.890888950000000e+01 }, { "Zr_90",      8.990470441600000e+01 }, { "Zr_91",      9.090564576700000e+01 },
         { "Zr_92",      9.190504084700000e+01 }, { "Zr_93",      9.290647600600001e+01 }, { "Zr_94",      9.390631519199999e+01 }, { "Zr_95",      9.490804260000000e+01 },
         { "Zr_96",      9.590827338600000e+01 }, { "Zr_97",      9.691095310900000e+01 }, { "Zr_98",      9.791273489200000e+01 }, { "Zr_99",      9.891651210600000e+01 },
         { "Zr_100",     9.991776188900000e+01 }, { "Zr_101",     1.009211404150000e+02 }, { "Zr_102",     1.019229812850000e+02 }, { "Zr_103",     1.029265996060000e+02 },
         { "Zr_104",     1.039287800000000e+02 }, { "Zr_105",     1.049330500000000e+02 }, { "Zr_106",     1.059359100000000e+02 }, { "Zr_107",     1.069407500000000e+02 },
         { "Zr_108",     1.079439600000000e+02 }, { "Zr_109",     1.089492400000000e+02 }, { "Zr_110",     1.099528700000000e+02 }, { "Nb_natural", 9.290640000000000e+01 },
         { "Nb_81",      8.094902999999999e+01 }, { "Nb_82",      8.194313000000000e+01 }, { "Nb_83",      8.293670538200000e+01 }, { "Nb_84",      8.393357000000000e+01 },
         { "Nb_85",      8.492791244700000e+01 }, { "Nb_86",      8.592503832600001e+01 }, { "Nb_87",      8.692036110799999e+01 }, { "Nb_88",      8.791833216300000e+01 },
         { "Nb_89",      8.891341824500000e+01 }, { "Nb_90",      8.991126484500001e+01 }, { "Nb_91",      9.090699624299999e+01 }, { "Nb_92",      9.190719388799999e+01 },
         { "Nb_93",      9.290637805800000e+01 }, { "Nb_94",      9.390728388799999e+01 }, { "Nb_95",      9.490683579200000e+01 }, { "Nb_96",      9.590810064700000e+01 },
         { "Nb_97",      9.690809855600000e+01 }, { "Nb_98",      9.791032841200000e+01 }, { "Nb_99",      9.891161837500000e+01 }, { "Nb_100",     9.991418161900000e+01 },
         { "Nb_101",     1.009152520250000e+02 }, { "Nb_102",     1.019180376140000e+02 }, { "Nb_103",     1.029191438420000e+02 }, { "Nb_104",     1.039224647010000e+02 },
         { "Nb_105",     1.049239365450000e+02 }, { "Nb_106",     1.059279700000000e+02 }, { "Nb_107",     1.069303100000000e+02 }, { "Nb_108",     1.079348400000000e+02 },
         { "Nb_109",     1.089376300000000e+02 }, { "Nb_110",     1.099424400000000e+02 }, { "Nb_111",     1.109456500000000e+02 }, { "Nb_112",     1.119508300000000e+02 },
         { "Nb_113",     1.129547000000000e+02 }, { "Mo_natural", 9.594000000000000e+01 }, { "Mo_83",      8.294874000000000e+01 }, { "Mo_84",      8.394009000000000e+01 },
         { "Mo_85",      8.493655000000000e+01 }, { "Mo_86",      8.593069590400000e+01 }, { "Mo_87",      8.692732650200000e+01 }, { "Mo_88",      8.792195324100000e+01 },
         { "Mo_89",      8.891948000900000e+01 }, { "Mo_90",      8.991393689600000e+01 }, { "Mo_91",      9.091175019400001e+01 }, { "Mo_92",      9.190681099100000e+01 },
         { "Mo_93",      9.290681261000000e+01 }, { "Mo_94",      9.390508826900000e+01 }, { "Mo_95",      9.490584212900001e+01 }, { "Mo_96",      9.590467947700000e+01 },
         { "Mo_97",      9.690602146499999e+01 }, { "Mo_98",      9.790540816900000e+01 }, { "Mo_99",      9.890771187000000e+01 }, { "Mo_100",     9.990747733600000e+01 },
         { "Mo_101",     1.009103470010000e+02 }, { "Mo_102",     1.019102973600000e+02 }, { "Mo_103",     1.029132071420000e+02 }, { "Mo_104",     1.039137636250000e+02 },
         { "Mo_105",     1.049169746100000e+02 }, { "Mo_106",     1.059181368020000e+02 }, { "Mo_107",     1.069216926040000e+02 }, { "Mo_108",     1.079234530000000e+02 },
         { "Mo_109",     1.089278100000000e+02 }, { "Mo_110",     1.099297300000000e+02 }, { "Mo_111",     1.109344100000000e+02 }, { "Mo_112",     1.119368400000000e+02 },
         { "Mo_113",     1.129418800000000e+02 }, { "Mo_114",     1.139449200000000e+02 }, { "Mo_115",     1.149502900000000e+02 }, { "Tc_natural", 9.800000000000000e+01 },
         { "Tc_85",      8.494883000000000e+01 }, { "Tc_86",      8.594288000000000e+01 }, { "Tc_87",      8.693653000000000e+01 }, { "Tc_88",      8.793267800000000e+01 },
         { "Tc_89",      8.892716700000000e+01 }, { "Tc_90",      8.992355656399999e+01 }, { "Tc_91",      9.091842763900000e+01 }, { "Tc_92",      9.191526016600000e+01 },
         { "Tc_93",      9.291024898400001e+01 }, { "Tc_94",      9.390965700200000e+01 }, { "Tc_95",      9.490765708399999e+01 }, { "Tc_96",      9.590787138300000e+01 },
         { "Tc_97",      9.690636535800000e+01 }, { "Tc_98",      9.790721596600000e+01 }, { "Tc_99",      9.890625474700001e+01 }, { "Tc_100",     9.990765777999999e+01 },
         { "Tc_101",     1.009073146590000e+02 }, { "Tc_102",     1.019092150190000e+02 }, { "Tc_103",     1.029091813510000e+02 }, { "Tc_104",     1.039114474540000e+02 },
         { "Tc_105",     1.049116605660000e+02 }, { "Tc_106",     1.059143579270000e+02 }, { "Tc_107",     1.069150795720000e+02 }, { "Tc_108",     1.079184612260000e+02 },
         { "Tc_109",     1.089199826650000e+02 }, { "Tc_110",     1.099238204830000e+02 }, { "Tc_111",     1.109256928300000e+02 }, { "Tc_112",     1.119291464930000e+02 },
         { "Tc_113",     1.129315900000000e+02 }, { "Tc_114",     1.139358800000000e+02 }, { "Tc_115",     1.149386900000000e+02 }, { "Tc_116",     1.159433700000000e+02 },
         { "Tc_117",     1.169464800000000e+02 }, { "Tc_118",     1.179514800000000e+02 }, { "Ru_natural", 1.010700000000000e+02 }, { "Ru_87",      8.694918000000000e+01 },
         { "Ru_88",      8.794025999999999e+01 }, { "Ru_89",      8.893611000000000e+01 }, { "Ru_90",      8.992989000000000e+01 }, { "Ru_91",      9.092629200000000e+01 },
         { "Ru_92",      9.192012000000000e+01 }, { "Ru_93",      9.291705203399999e+01 }, { "Ru_94",      9.391135971100000e+01 }, { "Ru_95",      9.491041292900000e+01 },
         { "Ru_96",      9.590759783500000e+01 }, { "Ru_97",      9.690755470000001e+01 }, { "Ru_98",      9.790528713200000e+01 }, { "Ru_99",      9.890593930199999e+01 },
         { "Ru_100",     9.990421947599999e+01 }, { "Ru_101",     1.009055820870000e+02 }, { "Ru_102",     1.019043493120000e+02 }, { "Ru_103",     1.029063238470000e+02 },
         { "Ru_104",     1.039054327010000e+02 }, { "Ru_105",     1.049077528660000e+02 }, { "Ru_106",     1.059073294330000e+02 }, { "Ru_107",     1.069099050890000e+02 },
         { "Ru_108",     1.079101734650000e+02 }, { "Ru_109",     1.089132032330000e+02 }, { "Ru_110",     1.099141360410000e+02 }, { "Ru_111",     1.109176960000000e+02 },
         { "Ru_112",     1.119189650000000e+02 }, { "Ru_113",     1.129224871940000e+02 }, { "Ru_114",     1.139242810000000e+02 }, { "Ru_115",     1.149286861730000e+02 },
         { "Ru_116",     1.159308100000000e+02 }, { "Ru_117",     1.169355800000000e+02 }, { "Ru_118",     1.179378200000000e+02 }, { "Ru_119",     1.189428400000000e+02 },
         { "Ru_120",     1.199453100000000e+02 }, { "Rh_natural", 1.029055000000000e+02 }, { "Rh_89",      8.894883700000000e+01 }, { "Rh_90",      8.994287000000000e+01 },
         { "Rh_91",      9.093655000000000e+01 }, { "Rh_92",      9.193198000000000e+01 }, { "Rh_93",      9.292574000000000e+01 }, { "Rh_94",      9.392169800000001e+01 },
         { "Rh_95",      9.491589874000000e+01 }, { "Rh_96",      9.591446063100000e+01 }, { "Rh_97",      9.691133679700000e+01 }, { "Rh_98",      9.791070815800001e+01 },
         { "Rh_99",      9.890813210400000e+01 }, { "Rh_100",     9.990812155000000e+01 }, { "Rh_101",     1.009061636250000e+02 }, { "Rh_102",     1.019068431960000e+02 },
         { "Rh_103",     1.029055042920000e+02 }, { "Rh_104",     1.039066555180000e+02 }, { "Rh_105",     1.049056938210000e+02 }, { "Rh_106",     1.059072871350000e+02 },
         { "Rh_107",     1.069067484230000e+02 }, { "Rh_108",     1.079087280180000e+02 }, { "Rh_109",     1.089087372890000e+02 }, { "Rh_110",     1.099111364110000e+02 },
         { "Rh_111",     1.109115859130000e+02 }, { "Rh_112",     1.119143941590000e+02 }, { "Rh_113",     1.129155306270000e+02 }, { "Rh_114",     1.139188060000000e+02 },
         { "Rh_115",     1.149203340000000e+02 }, { "Rh_116",     1.159240620000000e+02 }, { "Rh_117",     1.169259800000000e+02 }, { "Rh_118",     1.179300700000000e+02 },
         { "Rh_119",     1.189321100000000e+02 }, { "Rh_120",     1.199364100000000e+02 }, { "Rh_121",     1.209387200000000e+02 }, { "Rh_122",     1.219432100000000e+02 },
         { "Pd_natural", 1.064000000000000e+02 }, { "Pd_91",      9.094911000000000e+01 }, { "Pd_92",      9.194042000000000e+01 }, { "Pd_93",      9.293591000000001e+01 },
         { "Pd_94",      9.392877000000000e+01 }, { "Pd_95",      9.492469000000000e+01 }, { "Pd_96",      9.591816435900000e+01 }, { "Pd_97",      9.691647907300000e+01 },
         { "Pd_98",      9.791272090200000e+01 }, { "Pd_99",      9.891176783300000e+01 }, { "Pd_100",     9.990850588600000e+01 }, { "Pd_101",     1.009082892420000e+02 },
         { "Pd_102",     1.019056085440000e+02 }, { "Pd_103",     1.029060873070000e+02 }, { "Pd_104",     1.039040358340000e+02 }, { "Pd_105",     1.049050849200000e+02 },
         { "Pd_106",     1.059034857150000e+02 }, { "Pd_107",     1.069051334810000e+02 }, { "Pd_108",     1.079038917010000e+02 }, { "Pd_109",     1.089059504510000e+02 },
         { "Pd_110",     1.099051532540000e+02 }, { "Pd_111",     1.109076707340000e+02 }, { "Pd_112",     1.119073140580000e+02 }, { "Pd_113",     1.129101529080000e+02 },
         { "Pd_114",     1.139103626380000e+02 }, { "Pd_115",     1.149136838240000e+02 }, { "Pd_116",     1.159141586620000e+02 }, { "Pd_117",     1.169178413380000e+02 },
         { "Pd_118",     1.179189843000000e+02 }, { "Pd_119",     1.189231100000000e+02 }, { "Pd_120",     1.199246918780000e+02 }, { "Pd_121",     1.209288700000000e+02 },
         { "Pd_122",     1.219305500000000e+02 }, { "Pd_123",     1.229349300000000e+02 }, { "Pd_124",     1.239368800000000e+02 }, { "Ag_natural", 1.078680000000000e+02 },
         { "Ag_93",      9.294978000000000e+01 }, { "Ag_94",      9.394278000000000e+01 }, { "Ag_95",      9.493548000000000e+01 }, { "Ag_96",      9.593068000000000e+01 },
         { "Ag_97",      9.692397241200000e+01 }, { "Ag_98",      9.792156620100000e+01 }, { "Ag_99",      9.891759717799999e+01 }, { "Ag_100",     9.991610425499999e+01 },
         { "Ag_101",     1.009128022330000e+02 }, { "Ag_102",     1.019116850000000e+02 }, { "Ag_103",     1.029089727200000e+02 }, { "Ag_104",     1.039086291570000e+02 },
         { "Ag_105",     1.049065286610000e+02 }, { "Ag_106",     1.059066689210000e+02 }, { "Ag_107",     1.069050968200000e+02 }, { "Ag_108",     1.079059555560000e+02 },
         { "Ag_109",     1.089047522920000e+02 }, { "Ag_110",     1.099061072310000e+02 }, { "Ag_111",     1.109052911570000e+02 }, { "Ag_112",     1.119070048140000e+02 },
         { "Ag_113",     1.129065665790000e+02 }, { "Ag_114",     1.139088037040000e+02 }, { "Ag_115",     1.149087626980000e+02 }, { "Ag_116",     1.159113599330000e+02 },
         { "Ag_117",     1.169116845620000e+02 }, { "Ag_118",     1.179145827680000e+02 }, { "Ag_119",     1.189156650590000e+02 }, { "Ag_120",     1.199187873840000e+02 },
         { "Ag_121",     1.209198480460000e+02 }, { "Ag_122",     1.219235300000000e+02 }, { "Ag_123",     1.229249000000000e+02 }, { "Ag_124",     1.239286400000000e+02 },
         { "Ag_125",     1.249304300000000e+02 }, { "Ag_126",     1.259345000000000e+02 }, { "Ag_127",     1.269367700000000e+02 }, { "Ag_128",     1.279411700000000e+02 },
         { "Ag_129",     1.289436900000000e+02 }, { "Ag_130",     1.299504480000000e+02 }, { "Cd_natural", 1.124100000000000e+02 }, { "Cd_95",      9.494987000000000e+01 },
         { "Cd_96",      9.593977000000000e+01 }, { "Cd_97",      9.693494000000000e+01 }, { "Cd_98",      9.792739554600000e+01 }, { "Cd_99",      9.892501000000000e+01 },
         { "Cd_100",     9.992028952500000e+01 }, { "Cd_101",     1.009186815380000e+02 }, { "Cd_102",     1.019144622580000e+02 }, { "Cd_103",     1.029134192460000e+02 },
         { "Cd_104",     1.039098494750000e+02 }, { "Cd_105",     1.049094679050000e+02 }, { "Cd_106",     1.059064594100000e+02 }, { "Cd_107",     1.069066179280000e+02 },
         { "Cd_108",     1.079041836830000e+02 }, { "Cd_109",     1.089049822930000e+02 }, { "Cd_110",     1.099030020700000e+02 }, { "Cd_111",     1.109041781070000e+02 },
         { "Cd_112",     1.119027578090000e+02 }, { "Cd_113",     1.129044016620000e+02 }, { "Cd_114",     1.139033585400000e+02 }, { "Cd_115",     1.149054309690000e+02 },
         { "Cd_116",     1.159047558090000e+02 }, { "Cd_117",     1.169072186180000e+02 }, { "Cd_118",     1.179069145300000e+02 }, { "Cd_119",     1.189099215970000e+02 },
         { "Cd_120",     1.199098501290000e+02 }, { "Cd_121",     1.209129773630000e+02 }, { "Cd_122",     1.219133324320000e+02 }, { "Cd_123",     1.229170029990000e+02 },
         { "Cd_124",     1.239176476160000e+02 }, { "Cd_125",     1.249212463700000e+02 }, { "Cd_126",     1.259223533210000e+02 }, { "Cd_127",     1.269264438640000e+02 },
         { "Cd_128",     1.279277622850000e+02 }, { "Cd_129",     1.289321500000000e+02 }, { "Cd_130",     1.299339019370000e+02 }, { "Cd_131",     1.309406700000000e+02 },
         { "Cd_132",     1.319455500000000e+02 }, { "In_natural", 1.148200000000000e+02 }, { "In_97",      9.694954000000000e+01 }, { "In_98",      9.794213999999999e+01 },
         { "In_99",      9.893422000000000e+01 }, { "In_100",     9.993111085100000e+01 }, { "In_101",     1.009263400000000e+02 }, { "In_102",     1.019240902380000e+02 },
         { "In_103",     1.029199141880000e+02 }, { "In_104",     1.039182961710000e+02 }, { "In_105",     1.049146735400000e+02 }, { "In_106",     1.059134654110000e+02 },
         { "In_107",     1.069102951000000e+02 }, { "In_108",     1.079096981800000e+02 }, { "In_109",     1.089071505070000e+02 }, { "In_110",     1.099071652740000e+02 },
         { "In_111",     1.109051032780000e+02 }, { "In_112",     1.119055323310000e+02 }, { "In_113",     1.129040577610000e+02 }, { "In_114",     1.139049138760000e+02 },
         { "In_115",     1.149038784840000e+02 }, { "In_116",     1.159052597030000e+02 }, { "In_117",     1.169045135640000e+02 }, { "In_118",     1.179063543670000e+02 },
         { "In_119",     1.189058453500000e+02 }, { "In_120",     1.199079596080000e+02 }, { "In_121",     1.209078458220000e+02 }, { "In_122",     1.219102760100000e+02 },
         { "In_123",     1.229104382760000e+02 }, { "In_124",     1.239131752310000e+02 }, { "In_125",     1.249136005880000e+02 }, { "In_126",     1.259164638570000e+02 },
         { "In_127",     1.269173530910000e+02 }, { "In_128",     1.279201723280000e+02 }, { "In_129",     1.289216969800000e+02 }, { "In_130",     1.299249700490000e+02 },
         { "In_131",     1.309268517670000e+02 }, { "In_132",     1.319329902600000e+02 }, { "In_133",     1.329378100000000e+02 }, { "In_134",     1.339441500000000e+02 },
         { "In_135",     1.349493300000000e+02 }, { "Sn_natural", 1.186900000000000e+02 }, { "Sn_99",      9.894933000000000e+01 }, { "Sn_100",     9.993904434300001e+01 },
         { "Sn_101",     1.009360600000000e+02 }, { "Sn_102",     1.019302953240000e+02 }, { "Sn_103",     1.029281000000000e+02 }, { "Sn_104",     1.039231432230000e+02 },
         { "Sn_105",     1.049213494370000e+02 }, { "Sn_106",     1.059168806200000e+02 }, { "Sn_107",     1.069156443290000e+02 }, { "Sn_108",     1.079119253780000e+02 },
         { "Sn_109",     1.089112832140000e+02 }, { "Sn_110",     1.099078427910000e+02 }, { "Sn_111",     1.109077344600000e+02 }, { "Sn_112",     1.119048182070000e+02 },
         { "Sn_113",     1.129051705770000e+02 }, { "Sn_114",     1.139027788690000e+02 }, { "Sn_115",     1.149033423970000e+02 }, { "Sn_116",     1.159017405300000e+02 },
         { "Sn_117",     1.169029516560000e+02 }, { "Sn_118",     1.179016031670000e+02 }, { "Sn_119",     1.189033076300000e+02 }, { "Sn_120",     1.199021946760000e+02 },
         { "Sn_121",     1.209042354800000e+02 }, { "Sn_122",     1.219034390460000e+02 }, { "Sn_123",     1.229057208380000e+02 }, { "Sn_124",     1.239052739460000e+02 },
         { "Sn_125",     1.249077841250000e+02 }, { "Sn_126",     1.259076532800000e+02 }, { "Sn_127",     1.269103600240000e+02 }, { "Sn_128",     1.279105366240000e+02 },
         { "Sn_129",     1.289134790000000e+02 }, { "Sn_130",     1.299139672950000e+02 }, { "Sn_131",     1.309169997690000e+02 }, { "Sn_132",     1.319178157130000e+02 },
         { "Sn_133",     1.329238292490000e+02 }, { "Sn_134",     1.339282917650000e+02 }, { "Sn_135",     1.349347300000000e+02 }, { "Sn_136",     1.359393400000000e+02 },
         { "Sn_137",     1.369459900000000e+02 }, { "Sb_natural", 1.217500000000000e+02 }, { "Sb_103",     1.029396900000000e+02 }, { "Sb_104",     1.039364720000000e+02 },
         { "Sb_105",     1.049314863480000e+02 }, { "Sb_106",     1.059287910000000e+02 }, { "Sb_107",     1.069241500000000e+02 }, { "Sb_108",     1.079221600000000e+02 },
         { "Sb_109",     1.089181324260000e+02 }, { "Sb_110",     1.099167530000000e+02 }, { "Sb_111",     1.109131630000000e+02 }, { "Sb_112",     1.119123980090000e+02 },
         { "Sb_113",     1.129093716720000e+02 }, { "Sb_114",     1.139092690000000e+02 }, { "Sb_115",     1.149065980000000e+02 }, { "Sb_116",     1.159067936290000e+02 },
         { "Sb_117",     1.169048359410000e+02 }, { "Sb_118",     1.179055287310000e+02 }, { "Sb_119",     1.189039420090000e+02 }, { "Sb_120",     1.199050724270000e+02 },
         { "Sb_121",     1.209038156860000e+02 }, { "Sb_122",     1.219051736510000e+02 }, { "Sb_123",     1.229042139700000e+02 }, { "Sb_124",     1.239059357430000e+02 },
         { "Sb_125",     1.249052538180000e+02 }, { "Sb_126",     1.259072474800000e+02 }, { "Sb_127",     1.269069236090000e+02 }, { "Sb_128",     1.279091690010000e+02 },
         { "Sb_129",     1.289091484420000e+02 }, { "Sb_130",     1.299116563240000e+02 }, { "Sb_131",     1.309119822750000e+02 }, { "Sb_132",     1.319144668960000e+02 },
         { "Sb_133",     1.329152516300000e+02 }, { "Sb_134",     1.339203797440000e+02 }, { "Sb_135",     1.349251657710000e+02 }, { "Sb_136",     1.359303500000000e+02 },
         { "Sb_137",     1.369353100000000e+02 }, { "Sb_138",     1.379407900000000e+02 }, { "Sb_139",     1.389459800000000e+02 }, { "Te_natural", 1.276000000000000e+02 },
         { "Te_105",     1.049436400000000e+02 }, { "Te_106",     1.059375042370000e+02 }, { "Te_107",     1.069350060000000e+02 }, { "Te_108",     1.079294445970000e+02 },
         { "Te_109",     1.089274155150000e+02 }, { "Te_110",     1.099224073160000e+02 }, { "Te_111",     1.109211106920000e+02 }, { "Te_112",     1.119170136720000e+02 },
         { "Te_113",     1.129158910000000e+02 }, { "Te_114",     1.139120890000000e+02 }, { "Te_115",     1.149119020000000e+02 }, { "Te_116",     1.159084600000000e+02 },
         { "Te_117",     1.169086447190000e+02 }, { "Te_118",     1.179058275810000e+02 }, { "Te_119",     1.189064036450000e+02 }, { "Te_120",     1.199040202220000e+02 },
         { "Te_121",     1.209049364240000e+02 }, { "Te_122",     1.219030438980000e+02 }, { "Te_123",     1.229042700290000e+02 }, { "Te_124",     1.239028178960000e+02 },
         { "Te_125",     1.249044307310000e+02 }, { "Te_126",     1.259033116960000e+02 }, { "Te_127",     1.269052263360000e+02 }, { "Te_128",     1.279044630560000e+02 },
         { "Te_129",     1.289065982380000e+02 }, { "Te_130",     1.299062243990000e+02 }, { "Te_131",     1.309085238640000e+02 }, { "Te_132",     1.319085531600000e+02 },
         { "Te_133",     1.329109553060000e+02 }, { "Te_134",     1.339113687370000e+02 }, { "Te_135",     1.349164485920000e+02 }, { "Te_136",     1.359201012460000e+02 },
         { "Te_137",     1.369253229540000e+02 }, { "Te_138",     1.379292200000000e+02 }, { "Te_139",     1.389347300000000e+02 }, { "Te_140",     1.399388500000000e+02 },
         { "Te_141",     1.409446500000000e+02 }, { "Te_142",     1.419490800000000e+02 }, { "I_natural",  1.269045000000000e+02 }, { "I_108",      1.079434750000000e+02 },
         { "I_109",      1.089381494170000e+02 }, { "I_110",      1.099352420000000e+02 }, { "I_111",      1.109302760000000e+02 }, { "I_112",      1.119279700000000e+02 },
         { "I_113",      1.129236405830000e+02 }, { "I_114",      1.139218500000000e+02 }, { "I_115",      1.149180480000000e+02 }, { "I_116",      1.159168086330000e+02 },
         { "I_117",      1.169136500000000e+02 }, { "I_118",      1.179130740000000e+02 }, { "I_119",      1.189100740000000e+02 }, { "I_120",      1.199100481730000e+02 },
         { "I_121",      1.209073668110000e+02 }, { "I_122",      1.219075892840000e+02 }, { "I_123",      1.229055889650000e+02 }, { "I_124",      1.239062098520000e+02 },
         { "I_125",      1.249046301640000e+02 }, { "I_126",      1.259056241530000e+02 }, { "I_127",      1.269044726810000e+02 }, { "I_128",      1.279058094430000e+02 },
         { "I_129",      1.289049877220000e+02 }, { "I_130",      1.299066742470000e+02 }, { "I_131",      1.309061246090000e+02 }, { "I_132",      1.319079973810000e+02 },
         { "I_133",      1.329077969390000e+02 }, { "I_134",      1.339097444650000e+02 }, { "I_135",      1.349100481210000e+02 }, { "I_136",      1.359146539930000e+02 },
         { "I_137",      1.369178708400000e+02 }, { "I_138",      1.379223495910000e+02 }, { "I_139",      1.389260994780000e+02 }, { "I_140",      1.399310000000000e+02 },
         { "I_141",      1.409350300000000e+02 }, { "I_142",      1.419401800000000e+02 }, { "I_143",      1.429445600000000e+02 }, { "I_144",      1.439499900000000e+02 },
         { "Xe_natural", 1.313000000000000e+02 }, { "Xe_110",     1.099442780680000e+02 }, { "Xe_111",     1.109416020000000e+02 }, { "Xe_112",     1.119356231120000e+02 },
         { "Xe_113",     1.129333411740000e+02 }, { "Xe_114",     1.139279803060000e+02 }, { "Xe_115",     1.149262939200000e+02 }, { "Xe_116",     1.159215810870000e+02 },
         { "Xe_117",     1.169203587350000e+02 }, { "Xe_118",     1.179161786550000e+02 }, { "Xe_119",     1.189154106880000e+02 }, { "Xe_120",     1.199117842440000e+02 },
         { "Xe_121",     1.209114618290000e+02 }, { "Xe_122",     1.219083676320000e+02 }, { "Xe_123",     1.229084819100000e+02 }, { "Xe_124",     1.239058930030000e+02 },
         { "Xe_125",     1.249063954640000e+02 }, { "Xe_126",     1.259042736340000e+02 }, { "Xe_127",     1.269051837230000e+02 }, { "Xe_128",     1.279035312750000e+02 },
         { "Xe_129",     1.289047794350000e+02 }, { "Xe_130",     1.299035080070000e+02 }, { "Xe_131",     1.309050823620000e+02 }, { "Xe_132",     1.319041534570000e+02 },
         { "Xe_133",     1.329059107220000e+02 }, { "Xe_134",     1.339053944640000e+02 }, { "Xe_135",     1.349072274950000e+02 }, { "Xe_136",     1.359072187940000e+02 },
         { "Xe_137",     1.369115621250000e+02 }, { "Xe_138",     1.379139544750000e+02 }, { "Xe_139",     1.389187929360000e+02 }, { "Xe_140",     1.399216409430000e+02 },
         { "Xe_141",     1.409266480490000e+02 }, { "Xe_142",     1.419297095900000e+02 }, { "Xe_143",     1.429351100000000e+02 }, { "Xe_144",     1.439385100000000e+02 },
         { "Xe_145",     1.449440700000000e+02 }, { "Xe_146",     1.459477500000000e+02 }, { "Xe_147",     1.469535600000000e+02 }, { "Cs_natural", 1.329054000000000e+02 },
         { "Cs_112",     1.119503010000000e+02 }, { "Cs_113",     1.129444932740000e+02 }, { "Cs_114",     1.139414500000000e+02 }, { "Cs_115",     1.149359100000000e+02 },
         { "Cs_116",     1.159333670000000e+02 }, { "Cs_117",     1.169286707010000e+02 }, { "Cs_118",     1.179265594940000e+02 }, { "Cs_119",     1.189223773040000e+02 },
         { "Cs_120",     1.199206772530000e+02 }, { "Cs_121",     1.209172292090000e+02 }, { "Cs_122",     1.219161134340000e+02 }, { "Cs_123",     1.229129960360000e+02 },
         { "Cs_124",     1.239122577980000e+02 }, { "Cs_125",     1.249097282700000e+02 }, { "Cs_126",     1.259094519770000e+02 }, { "Cs_127",     1.269074175250000e+02 },
         { "Cs_128",     1.279077488660000e+02 }, { "Cs_129",     1.289060644260000e+02 }, { "Cs_130",     1.299067085520000e+02 }, { "Cs_131",     1.309054639260000e+02 },
         { "Cs_132",     1.319064342600000e+02 }, { "Cs_133",     1.329054519320000e+02 }, { "Cs_134",     1.339067184750000e+02 }, { "Cs_135",     1.349059770080000e+02 },
         { "Cs_136",     1.359073115760000e+02 }, { "Cs_137",     1.369070894730000e+02 }, { "Cs_138",     1.379110167040000e+02 }, { "Cs_139",     1.389133639990000e+02 },
         { "Cs_140",     1.399172823540000e+02 }, { "Cs_141",     1.409200457520000e+02 }, { "Cs_142",     1.419242989270000e+02 }, { "Cs_143",     1.429273517500000e+02 },
         { "Cs_144",     1.439320769140000e+02 }, { "Cs_145",     1.449355261700000e+02 }, { "Cs_146",     1.459402894230000e+02 }, { "Cs_147",     1.469441550080000e+02 },
         { "Cs_148",     1.479492181530000e+02 }, { "Cs_149",     1.489529300000000e+02 }, { "Cs_150",     1.499581700000000e+02 }, { "Cs_151",     1.509621900000000e+02 },
         { "Ba_natural", 1.373300000000000e+02 }, { "Ba_114",     1.139506754050000e+02 }, { "Ba_115",     1.149473700000000e+02 }, { "Ba_116",     1.159413800000000e+02 },
         { "Ba_117",     1.169384990000000e+02 }, { "Ba_118",     1.179330400000000e+02 }, { "Ba_119",     1.189306596610000e+02 }, { "Ba_120",     1.199260449740000e+02 },
         { "Ba_121",     1.209240544990000e+02 }, { "Ba_122",     1.219199040000000e+02 }, { "Ba_123",     1.229187810360000e+02 }, { "Ba_124",     1.239150936030000e+02 },
         { "Ba_125",     1.249144729120000e+02 }, { "Ba_126",     1.259112501770000e+02 }, { "Ba_127",     1.269110937970000e+02 }, { "Ba_128",     1.279083176980000e+02 },
         { "Ba_129",     1.289086794390000e+02 }, { "Ba_130",     1.299063208110000e+02 }, { "Ba_131",     1.309069411180000e+02 }, { "Ba_132",     1.319050612880000e+02 },
         { "Ba_133",     1.329060074900000e+02 }, { "Ba_134",     1.339045083830000e+02 }, { "Ba_135",     1.349056885910000e+02 }, { "Ba_136",     1.359045759450000e+02 },
         { "Ba_137",     1.369058273840000e+02 }, { "Ba_138",     1.379052472370000e+02 }, { "Ba_139",     1.389088413410000e+02 }, { "Ba_140",     1.399106045050000e+02 },
         { "Ba_141",     1.409144110090000e+02 }, { "Ba_142",     1.419164534100000e+02 }, { "Ba_143",     1.429206267190000e+02 }, { "Ba_144",     1.439229528530000e+02 },
         { "Ba_145",     1.449276270320000e+02 }, { "Ba_146",     1.459302195720000e+02 }, { "Ba_147",     1.469349450000000e+02 }, { "Ba_148",     1.479377200470000e+02 },
         { "Ba_149",     1.489425800000000e+02 }, { "Ba_150",     1.499456800000000e+02 }, { "Ba_151",     1.509508100000000e+02 }, { "Ba_152",     1.519542700000000e+02 },
         { "Ba_153",     1.529596100000000e+02 }, { "La_natural", 1.389055000000000e+02 }, { "La_117",     1.169500680000000e+02 }, { "La_118",     1.179467300000000e+02 },
         { "La_119",     1.189409900000000e+02 }, { "La_120",     1.199380700000000e+02 }, { "La_121",     1.209330100000000e+02 }, { "La_122",     1.219307100000000e+02 },
         { "La_123",     1.229262400000000e+02 }, { "La_124",     1.239245742750000e+02 }, { "La_125",     1.249208160340000e+02 }, { "La_126",     1.259195126670000e+02 },
         { "La_127",     1.269163754480000e+02 }, { "La_128",     1.279155851770000e+02 }, { "La_129",     1.289126928150000e+02 }, { "La_130",     1.299123687240000e+02 },
         { "La_131",     1.309100700000000e+02 }, { "La_132",     1.319101011450000e+02 }, { "La_133",     1.329082180000000e+02 }, { "La_134",     1.339085140110000e+02 },
         { "La_135",     1.349069768440000e+02 }, { "La_136",     1.359076355360000e+02 }, { "La_137",     1.369064935980000e+02 }, { "La_138",     1.379071119300000e+02 },
         { "La_139",     1.389063532670000e+02 }, { "La_140",     1.399094776450000e+02 }, { "La_141",     1.409109621520000e+02 }, { "La_142",     1.419140791300000e+02 },
         { "La_143",     1.429160627200000e+02 }, { "La_144",     1.439195996470000e+02 }, { "La_145",     1.449216454010000e+02 }, { "La_146",     1.459257934600000e+02 },
         { "La_147",     1.469282352840000e+02 }, { "La_148",     1.479322288680000e+02 }, { "La_149",     1.489347340000000e+02 }, { "La_150",     1.499387700000000e+02 },
         { "La_151",     1.509417200000000e+02 }, { "La_152",     1.519462500000000e+02 }, { "La_153",     1.529496200000000e+02 }, { "La_154",     1.539545000000000e+02 },
         { "La_155",     1.549583500000000e+02 }, { "Ce_natural", 1.401200000000000e+02 }, { "Ce_119",     1.189527600000000e+02 }, { "Ce_120",     1.199466400000000e+02 },
         { "Ce_121",     1.209434200000000e+02 }, { "Ce_122",     1.219379100000000e+02 }, { "Ce_123",     1.229354000000000e+02 }, { "Ce_124",     1.239304100000000e+02 },
         { "Ce_125",     1.249284400000000e+02 }, { "Ce_126",     1.259239710000000e+02 }, { "Ce_127",     1.269227310000000e+02 }, { "Ce_128",     1.279189110000000e+02 },
         { "Ce_129",     1.289181020000000e+02 }, { "Ce_130",     1.299147360000000e+02 }, { "Ce_131",     1.309144220000000e+02 }, { "Ce_132",     1.319114604870000e+02 },
         { "Ce_133",     1.329115150200000e+02 }, { "Ce_134",     1.339089248210000e+02 }, { "Ce_135",     1.349091513960000e+02 }, { "Ce_136",     1.359071724220000e+02 },
         { "Ce_137",     1.369078055770000e+02 }, { "Ce_138",     1.379059913210000e+02 }, { "Ce_139",     1.389066526510000e+02 }, { "Ce_140",     1.399054387060000e+02 },
         { "Ce_141",     1.409082762700000e+02 }, { "Ce_142",     1.419092442050000e+02 }, { "Ce_143",     1.429123859100000e+02 }, { "Ce_144",     1.439136473360000e+02 },
         { "Ce_145",     1.449172331350000e+02 }, { "Ce_146",     1.459187590090000e+02 }, { "Ce_147",     1.469226739540000e+02 }, { "Ce_148",     1.479244324100000e+02 },
         { "Ce_149",     1.489283998830000e+02 }, { "Ce_150",     1.499304089310000e+02 }, { "Ce_151",     1.509339761960000e+02 }, { "Ce_152",     1.519365400000000e+02 },
         { "Ce_153",     1.529405800000000e+02 }, { "Ce_154",     1.539434200000000e+02 }, { "Ce_155",     1.549480400000000e+02 }, { "Ce_156",     1.559512600000000e+02 },
         { "Ce_157",     1.569563400000000e+02 }, { "Pr_natural", 1.409077000000000e+02 }, { "Pr_121",     1.209553640000000e+02 }, { "Pr_122",     1.219518100000000e+02 },
         { "Pr_123",     1.229459600000000e+02 }, { "Pr_124",     1.239429600000000e+02 }, { "Pr_125",     1.249378300000000e+02 }, { "Pr_126",     1.259353100000000e+02 },
         { "Pr_127",     1.269308300000000e+02 }, { "Pr_128",     1.279287910000000e+02 }, { "Pr_129",     1.289250950000000e+02 }, { "Pr_130",     1.299235900000000e+02 },
         { "Pr_131",     1.309202590000000e+02 }, { "Pr_132",     1.319192550000000e+02 }, { "Pr_133",     1.329163305320000e+02 }, { "Pr_134",     1.339157117370000e+02 },
         { "Pr_135",     1.349131117450000e+02 }, { "Pr_136",     1.359126916110000e+02 }, { "Pr_137",     1.369107054550000e+02 }, { "Pr_138",     1.379107546360000e+02 },
         { "Pr_139",     1.389089383990000e+02 }, { "Pr_140",     1.399090758740000e+02 }, { "Pr_141",     1.409076527690000e+02 }, { "Pr_142",     1.419100448060000e+02 },
         { "Pr_143",     1.429108169260000e+02 }, { "Pr_144",     1.439133052450000e+02 }, { "Pr_145",     1.449145117000000e+02 }, { "Pr_146",     1.459176443360000e+02 },
         { "Pr_147",     1.469189959920000e+02 }, { "Pr_148",     1.479221350260000e+02 }, { "Pr_149",     1.489237176510000e+02 }, { "Pr_150",     1.499266729970000e+02 },
         { "Pr_151",     1.509283186180000e+02 }, { "Pr_152",     1.519314992250000e+02 }, { "Pr_153",     1.529338389050000e+02 }, { "Pr_154",     1.539375181530000e+02 },
         { "Pr_155",     1.549401200000000e+02 }, { "Pr_156",     1.559442700000000e+02 }, { "Pr_157",     1.569474300000000e+02 }, { "Pr_158",     1.579519800000000e+02 },
         { "Pr_159",     1.589555000000000e+02 }, { "Nd_natural", 1.442400000000000e+02 }, { "Nd_124",     1.239522300000000e+02 }, { "Nd_125",     1.249488800000000e+02 },
         { "Nd_126",     1.259432200000000e+02 }, { "Nd_127",     1.269405000000000e+02 }, { "Nd_128",     1.279353900000000e+02 }, { "Nd_129",     1.289331880000000e+02 },
         { "Nd_130",     1.299285060000000e+02 }, { "Nd_131",     1.309272470000000e+02 }, { "Nd_132",     1.319233212370000e+02 }, { "Nd_133",     1.329223480000000e+02 },
         { "Nd_134",     1.339187901810000e+02 }, { "Nd_135",     1.349181811600000e+02 }, { "Nd_136",     1.359149760350000e+02 }, { "Nd_137",     1.369145671370000e+02 },
         { "Nd_138",     1.379119499610000e+02 }, { "Nd_139",     1.389119782880000e+02 }, { "Nd_140",     1.399095520000000e+02 }, { "Nd_141",     1.409096098540000e+02 },
         { "Nd_142",     1.419077232970000e+02 }, { "Nd_143",     1.429098142900000e+02 }, { "Nd_144",     1.439100872740000e+02 }, { "Nd_145",     1.449125736360000e+02 },
         { "Nd_146",     1.459131169390000e+02 }, { "Nd_147",     1.469161004410000e+02 }, { "Nd_148",     1.479168932880000e+02 }, { "Nd_149",     1.489201488420000e+02 },
         { "Nd_150",     1.499208908880000e+02 }, { "Nd_151",     1.509238289290000e+02 }, { "Nd_152",     1.519246822190000e+02 }, { "Nd_153",     1.529276982320000e+02 },
         { "Nd_154",     1.539294773070000e+02 }, { "Nd_155",     1.549329320000000e+02 }, { "Nd_156",     1.559350181140000e+02 }, { "Nd_157",     1.569390300000000e+02 },
         { "Nd_158",     1.579416000000000e+02 }, { "Nd_159",     1.589460900000000e+02 }, { "Nd_160",     1.599490900000000e+02 }, { "Nd_161",     1.609538800000000e+02 },
         { "Pm_natural", 1.450000000000000e+02 }, { "Pm_126",     1.259575200000000e+02 }, { "Pm_127",     1.269516300000000e+02 }, { "Pm_128",     1.279484200000000e+02 },
         { "Pm_129",     1.289431600000000e+02 }, { "Pm_130",     1.299404500000000e+02 }, { "Pm_131",     1.309358700000000e+02 }, { "Pm_132",     1.319337500000000e+02 },
         { "Pm_133",     1.329297820000000e+02 }, { "Pm_134",     1.339283530000000e+02 }, { "Pm_135",     1.349248760000000e+02 }, { "Pm_136",     1.359235658290000e+02 },
         { "Pm_137",     1.369204794930000e+02 }, { "Pm_138",     1.379195482810000e+02 }, { "Pm_139",     1.389168040820000e+02 }, { "Pm_140",     1.399160417890000e+02 },
         { "Pm_141",     1.409135550540000e+02 }, { "Pm_142",     1.419128744710000e+02 }, { "Pm_143",     1.429109326160000e+02 }, { "Pm_144",     1.439125908430000e+02 },
         { "Pm_145",     1.449127490230000e+02 }, { "Pm_146",     1.459146963050000e+02 }, { "Pm_147",     1.469151385450000e+02 }, { "Pm_148",     1.479174746180000e+02 },
         { "Pm_149",     1.489183341550000e+02 }, { "Pm_150",     1.499209835610000e+02 }, { "Pm_151",     1.509212069730000e+02 }, { "Pm_152",     1.519234967950000e+02 },
         { "Pm_153",     1.529241168890000e+02 }, { "Pm_154",     1.539264639430000e+02 }, { "Pm_155",     1.549281012670000e+02 }, { "Pm_156",     1.559310567360000e+02 },
         { "Pm_157",     1.569330393690000e+02 }, { "Pm_158",     1.579365614070000e+02 }, { "Pm_159",     1.589389700000000e+02 }, { "Pm_160",     1.599429900000000e+02 },
         { "Pm_161",     1.609458600000000e+02 }, { "Pm_162",     1.619502900000000e+02 }, { "Pm_163",     1.629536800000000e+02 }, { "Sm_natural", 1.504000000000000e+02 },
         { "Sm_128",     1.279580800000000e+02 }, { "Sm_129",     1.289546400000000e+02 }, { "Sm_130",     1.299489200000000e+02 }, { "Sm_131",     1.309461100000000e+02 },
         { "Sm_132",     1.319406900000000e+02 }, { "Sm_133",     1.329386700000000e+02 }, { "Sm_134",     1.339339700000000e+02 }, { "Sm_135",     1.349325200000000e+02 },
         { "Sm_136",     1.359282755270000e+02 }, { "Sm_137",     1.369269717460000e+02 }, { "Sm_138",     1.379232439610000e+02 }, { "Sm_139",     1.389222966050000e+02 },
         { "Sm_140",     1.399189946870000e+02 }, { "Sm_141",     1.409184764880000e+02 }, { "Sm_142",     1.419151976410000e+02 }, { "Sm_143",     1.429146283380000e+02 },
         { "Sm_144",     1.439119994780000e+02 }, { "Sm_145",     1.449134103530000e+02 }, { "Sm_146",     1.459130409000000e+02 }, { "Sm_147",     1.469148979230000e+02 },
         { "Sm_148",     1.479148226740000e+02 }, { "Sm_149",     1.489171847350000e+02 }, { "Sm_150",     1.499172755390000e+02 }, { "Sm_151",     1.509199324090000e+02 },
         { "Sm_152",     1.519197324250000e+02 }, { "Sm_153",     1.529220973560000e+02 }, { "Sm_154",     1.539222092730000e+02 }, { "Sm_155",     1.549246401610000e+02 },
         { "Sm_156",     1.559255278870000e+02 }, { "Sm_157",     1.569283587170000e+02 }, { "Sm_158",     1.579299913170000e+02 }, { "Sm_159",     1.589332112710000e+02 },
         { "Sm_160",     1.599351400000000e+02 }, { "Sm_161",     1.609388300000000e+02 }, { "Sm_162",     1.619412200000000e+02 }, { "Sm_163",     1.629453600000000e+02 },
         { "Sm_164",     1.639482800000000e+02 }, { "Sm_165",     1.649529800000000e+02 }, { "Eu_natural", 1.519600000000000e+02 }, { "Eu_130",     1.299635690000000e+02 },
         { "Eu_131",     1.309577530000000e+02 }, { "Eu_132",     1.319543700000000e+02 }, { "Eu_133",     1.329492400000000e+02 }, { "Eu_134",     1.339465100000000e+02 },
         { "Eu_135",     1.349418200000000e+02 }, { "Eu_136",     1.359396000000000e+02 }, { "Eu_137",     1.369355700000000e+02 }, { "Eu_138",     1.379337090000000e+02 },
         { "Eu_139",     1.389297922800000e+02 }, { "Eu_140",     1.399280876070000e+02 }, { "Eu_141",     1.409249307200000e+02 }, { "Eu_142",     1.419234349450000e+02 },
         { "Eu_143",     1.429202975090000e+02 }, { "Eu_144",     1.439188168230000e+02 }, { "Eu_145",     1.449162652370000e+02 }, { "Eu_146",     1.459172058170000e+02 },
         { "Eu_147",     1.469167461110000e+02 }, { "Eu_148",     1.479180858950000e+02 }, { "Eu_149",     1.489179312380000e+02 }, { "Eu_150",     1.499197018190000e+02 },
         { "Eu_151",     1.509198501610000e+02 }, { "Eu_152",     1.519217445340000e+02 }, { "Eu_153",     1.529212303390000e+02 }, { "Eu_154",     1.539229792370000e+02 },
         { "Eu_155",     1.549228932600000e+02 }, { "Eu_156",     1.559247522490000e+02 }, { "Eu_157",     1.569254236470000e+02 }, { "Eu_158",     1.579278453020000e+02 },
         { "Eu_159",     1.589290888610000e+02 }, { "Eu_160",     1.599319710000000e+02 }, { "Eu_161",     1.609336800000000e+02 }, { "Eu_162",     1.619370400000000e+02 },
         { "Eu_163",     1.629392100000000e+02 }, { "Eu_164",     1.639429900000000e+02 }, { "Eu_165",     1.649457200000000e+02 }, { "Eu_166",     1.659499700000000e+02 },
         { "Eu_167",     1.669532100000000e+02 }, { "Gd_natural", 1.572500000000000e+02 }, { "Gd_134",     1.339553700000000e+02 }, { "Gd_135",     1.349525700000000e+02 },
         { "Gd_136",     1.359473400000000e+02 }, { "Gd_137",     1.369450200000000e+02 }, { "Gd_138",     1.379401200000000e+02 }, { "Gd_139",     1.389382400000000e+02 },
         { "Gd_140",     1.399336740000000e+02 }, { "Gd_141",     1.409321260000000e+02 }, { "Gd_142",     1.419281160000000e+02 }, { "Gd_143",     1.429267495100000e+02 },
         { "Gd_144",     1.439229630000000e+02 }, { "Gd_145",     1.449217092520000e+02 }, { "Gd_146",     1.459183106080000e+02 }, { "Gd_147",     1.469190944200000e+02 },
         { "Gd_148",     1.479181145240000e+02 }, { "Gd_149",     1.489193409150000e+02 }, { "Gd_150",     1.499186588760000e+02 }, { "Gd_151",     1.509203484820000e+02 },
         { "Gd_152",     1.519197909960000e+02 }, { "Gd_153",     1.529217495430000e+02 }, { "Gd_154",     1.539208655980000e+02 }, { "Gd_155",     1.549226220220000e+02 },
         { "Gd_156",     1.559221227430000e+02 }, { "Gd_157",     1.569239601350000e+02 }, { "Gd_158",     1.579241039120000e+02 }, { "Gd_159",     1.589263886580000e+02 },
         { "Gd_160",     1.599270541460000e+02 }, { "Gd_161",     1.609296692110000e+02 }, { "Gd_162",     1.619309847510000e+02 }, { "Gd_163",     1.629339900000000e+02 },
         { "Gd_164",     1.639358600000000e+02 }, { "Gd_165",     1.649393800000000e+02 }, { "Gd_166",     1.659416000000000e+02 }, { "Gd_167",     1.669455700000000e+02 },
         { "Gd_168",     1.679483600000000e+02 }, { "Gd_169",     1.689528700000000e+02 }, { "Tb_natural", 1.589254000000000e+02 }, { "Tb_136",     1.359613800000000e+02 },
         { "Tb_137",     1.369559800000000e+02 }, { "Tb_138",     1.379531600000000e+02 }, { "Tb_139",     1.389482900000000e+02 }, { "Tb_140",     1.399458050490000e+02 },
         { "Tb_141",     1.409414480000000e+02 }, { "Tb_142",     1.419387440000000e+02 }, { "Tb_143",     1.429351210000000e+02 }, { "Tb_144",     1.439330450000000e+02 },
         { "Tb_145",     1.449292740000000e+02 }, { "Tb_146",     1.459272465840000e+02 }, { "Tb_147",     1.469240445850000e+02 }, { "Tb_148",     1.479242717010000e+02 },
         { "Tb_149",     1.489232459090000e+02 }, { "Tb_150",     1.499236596860000e+02 }, { "Tb_151",     1.509231025430000e+02 }, { "Tb_152",     1.519240744380000e+02 },
         { "Tb_153",     1.529234345880000e+02 }, { "Tb_154",     1.539246780190000e+02 }, { "Tb_155",     1.549235052360000e+02 }, { "Tb_156",     1.559247472130000e+02 },
         { "Tb_157",     1.569240246040000e+02 }, { "Tb_158",     1.579254131370000e+02 }, { "Tb_159",     1.589253467570000e+02 }, { "Tb_160",     1.599271676060000e+02 },
         { "Tb_161",     1.609275699190000e+02 }, { "Tb_162",     1.619294882340000e+02 }, { "Tb_163",     1.629306475360000e+02 }, { "Tb_164",     1.639333508380000e+02 },
         { "Tb_165",     1.649348800000000e+02 }, { "Tb_166",     1.659379919590000e+02 }, { "Tb_167",     1.669400500000000e+02 }, { "Tb_168",     1.679436400000000e+02 },
         { "Tb_169",     1.689462200000000e+02 }, { "Tb_170",     1.699502500000000e+02 }, { "Tb_171",     1.709533000000000e+02 }, { "Dy_natural", 1.625000000000000e+02 },
         { "Dy_138",     1.379624900000000e+02 }, { "Dy_139",     1.389595400000000e+02 }, { "Dy_140",     1.399540100000000e+02 }, { "Dy_141",     1.409513500000000e+02 },
         { "Dy_142",     1.419463660000000e+02 }, { "Dy_143",     1.429438300000000e+02 }, { "Dy_144",     1.439392540000000e+02 }, { "Dy_145",     1.449374250000000e+02 },
         { "Dy_146",     1.459328453690000e+02 }, { "Dy_147",     1.469310915000000e+02 }, { "Dy_148",     1.479271498310000e+02 }, { "Dy_149",     1.489273047870000e+02 },
         { "Dy_150",     1.499255851840000e+02 }, { "Dy_151",     1.509261846010000e+02 }, { "Dy_152",     1.519247183000000e+02 }, { "Dy_153",     1.529257646700000e+02 },
         { "Dy_154",     1.539244244570000e+02 }, { "Dy_155",     1.549257537750000e+02 }, { "Dy_156",     1.559242831100000e+02 }, { "Dy_157",     1.569254660950000e+02 },
         { "Dy_158",     1.579244094870000e+02 }, { "Dy_159",     1.589257392140000e+02 }, { "Dy_160",     1.599251975170000e+02 }, { "Dy_161",     1.609269333640000e+02 },
         { "Dy_162",     1.619267984470000e+02 }, { "Dy_163",     1.629287311590000e+02 }, { "Dy_164",     1.639291747510000e+02 }, { "Dy_165",     1.649317033330000e+02 },
         { "Dy_166",     1.659328067410000e+02 }, { "Dy_167",     1.669356554620000e+02 }, { "Dy_168",     1.679371287690000e+02 }, { "Dy_169",     1.689403076140000e+02 },
         { "Dy_170",     1.699423900000000e+02 }, { "Dy_171",     1.709462000000000e+02 }, { "Dy_172",     1.719487600000000e+02 }, { "Dy_173",     1.729530000000000e+02 },
         { "Ho_natural", 1.649304000000000e+02 }, { "Ho_140",     1.399685390000000e+02 }, { "Ho_141",     1.409630980000000e+02 }, { "Ho_142",     1.419597700000000e+02 },
         { "Ho_143",     1.429546100000000e+02 }, { "Ho_144",     1.439514800000000e+02 }, { "Ho_145",     1.449472000000000e+02 }, { "Ho_146",     1.459446400000000e+02 },
         { "Ho_147",     1.469400560000000e+02 }, { "Ho_148",     1.479377180000000e+02 }, { "Ho_149",     1.489337747710000e+02 }, { "Ho_150",     1.499334961820000e+02 },
         { "Ho_151",     1.509316881420000e+02 }, { "Ho_152",     1.519317137140000e+02 }, { "Ho_153",     1.529301987890000e+02 }, { "Ho_154",     1.539306015790000e+02 },
         { "Ho_155",     1.549291034910000e+02 }, { "Ho_156",     1.559298390000000e+02 }, { "Ho_157",     1.569282561880000e+02 }, { "Ho_158",     1.579289410070000e+02 },
         { "Ho_159",     1.589277119590000e+02 }, { "Ho_160",     1.599287294780000e+02 }, { "Ho_161",     1.609278547760000e+02 }, { "Ho_162",     1.619290955040000e+02 },
         { "Ho_163",     1.629287339030000e+02 }, { "Ho_164",     1.639302335070000e+02 }, { "Ho_165",     1.649303220700000e+02 }, { "Ho_166",     1.659322841620000e+02 },
         { "Ho_167",     1.669331326330000e+02 }, { "Ho_168",     1.679355157080000e+02 }, { "Ho_169",     1.689368722730000e+02 }, { "Ho_170",     1.699396189290000e+02 },
         { "Ho_171",     1.709414651500000e+02 }, { "Ho_172",     1.719448200000000e+02 }, { "Ho_173",     1.729472900000000e+02 }, { "Ho_174",     1.739511500000000e+02 },
         { "Ho_175",     1.749540500000000e+02 }, { "Er_natural", 1.672600000000000e+02 }, { "Er_143",     1.429663400000000e+02 }, { "Er_144",     1.439603800000000e+02 },
         { "Er_145",     1.449573900000000e+02 }, { "Er_146",     1.459520000000000e+02 }, { "Er_147",     1.469494900000000e+02 }, { "Er_148",     1.479445500000000e+02 },
         { "Er_149",     1.489423060000000e+02 }, { "Er_150",     1.499379138390000e+02 }, { "Er_151",     1.509374489030000e+02 }, { "Er_152",     1.519350503890000e+02 },
         { "Er_153",     1.529350634920000e+02 }, { "Er_154",     1.539327830810000e+02 }, { "Er_155",     1.549332089490000e+02 }, { "Er_156",     1.559310646980000e+02 },
         { "Er_157",     1.569319160000000e+02 }, { "Er_158",     1.579298934740000e+02 }, { "Er_159",     1.589306840660000e+02 }, { "Er_160",     1.599290832920000e+02 },
         { "Er_161",     1.609299953090000e+02 }, { "Er_162",     1.619287782640000e+02 }, { "Er_163",     1.629300327490000e+02 }, { "Er_164",     1.639292002290000e+02 },
         { "Er_165",     1.649307260030000e+02 }, { "Er_166",     1.659302930610000e+02 }, { "Er_167",     1.669320481590000e+02 }, { "Er_168",     1.679323702240000e+02 },
         { "Er_169",     1.689345903640000e+02 }, { "Er_170",     1.699354643120000e+02 }, { "Er_171",     1.709380298080000e+02 }, { "Er_172",     1.719393561130000e+02 },
         { "Er_173",     1.729424000000000e+02 }, { "Er_174",     1.739442300000000e+02 }, { "Er_175",     1.749477700000000e+02 }, { "Er_176",     1.759500800000000e+02 },
         { "Er_177",     1.769540500000000e+02 }, { "Tm_natural", 1.689342000000000e+02 }, { "Tm_145",     1.449700730000000e+02 }, { "Tm_146",     1.459664250000000e+02 },
         { "Tm_147",     1.469609610000000e+02 }, { "Tm_148",     1.479578400000000e+02 }, { "Tm_149",     1.489527200000000e+02 }, { "Tm_150",     1.499499600000000e+02 },
         { "Tm_151",     1.509454834900000e+02 }, { "Tm_152",     1.519444220000000e+02 }, { "Tm_153",     1.529420121120000e+02 }, { "Tm_154",     1.539415678080000e+02 },
         { "Tm_155",     1.549391994590000e+02 }, { "Tm_156",     1.559389799330000e+02 }, { "Tm_157",     1.569369730000000e+02 }, { "Tm_158",     1.579369795250000e+02 },
         { "Tm_159",     1.589349750000000e+02 }, { "Tm_160",     1.599352628010000e+02 }, { "Tm_161",     1.609335490000000e+02 }, { "Tm_162",     1.619339946820000e+02 },
         { "Tm_163",     1.629326511240000e+02 }, { "Tm_164",     1.639335600000000e+02 }, { "Tm_165",     1.649324354920000e+02 }, { "Tm_166",     1.659335541310000e+02 },
         { "Tm_167",     1.669328516220000e+02 }, { "Tm_168",     1.679341727760000e+02 }, { "Tm_169",     1.689342132500000e+02 }, { "Tm_170",     1.699358013970000e+02 },
         { "Tm_171",     1.709364294400000e+02 }, { "Tm_172",     1.719384000440000e+02 }, { "Tm_173",     1.729396036070000e+02 }, { "Tm_174",     1.739421686050000e+02 },
         { "Tm_175",     1.749438368530000e+02 }, { "Tm_176",     1.759469946850000e+02 }, { "Tm_177",     1.769490400000000e+02 }, { "Tm_178",     1.779526400000000e+02 },
         { "Tm_179",     1.789553400000000e+02 }, { "Yb_natural", 1.730400000000000e+02 }, { "Yb_148",     1.479674200000000e+02 }, { "Yb_149",     1.489640400000000e+02 },
         { "Yb_150",     1.499584200000000e+02 }, { "Yb_151",     1.509554007690000e+02 }, { "Yb_152",     1.519502889190000e+02 }, { "Yb_153",     1.529494800000000e+02 },
         { "Yb_154",     1.539463939280000e+02 }, { "Yb_155",     1.549457823320000e+02 }, { "Yb_156",     1.559428182150000e+02 }, { "Yb_157",     1.569426278480000e+02 },
         { "Yb_158",     1.579398656170000e+02 }, { "Yb_159",     1.589400500990000e+02 }, { "Yb_160",     1.599375523440000e+02 }, { "Yb_161",     1.609379016780000e+02 },
         { "Yb_162",     1.619357682100000e+02 }, { "Yb_163",     1.629363343050000e+02 }, { "Yb_164",     1.639344894160000e+02 }, { "Yb_165",     1.649352790000000e+02 },
         { "Yb_166",     1.659338820420000e+02 }, { "Yb_167",     1.669349496050000e+02 }, { "Yb_168",     1.679338968950000e+02 }, { "Yb_169",     1.689351898020000e+02 },
         { "Yb_170",     1.699347618370000e+02 }, { "Yb_171",     1.709363257990000e+02 }, { "Yb_172",     1.719363814690000e+02 }, { "Yb_173",     1.729382107870000e+02 },
         { "Yb_174",     1.739388620890000e+02 }, { "Yb_175",     1.749412764500000e+02 }, { "Yb_176",     1.759425716830000e+02 }, { "Yb_177",     1.769452608220000e+02 },
         { "Yb_178",     1.779466466800000e+02 }, { "Yb_179",     1.789501700000000e+02 }, { "Yb_180",     1.799523300000000e+02 }, { "Yb_181",     1.809561500000000e+02 },
         { "Lu_natural", 1.749670000000000e+02 }, { "Lu_150",     1.499732280000000e+02 }, { "Lu_151",     1.509675770000000e+02 }, { "Lu_152",     1.519641200000000e+02 },
         { "Lu_153",     1.529587673310000e+02 }, { "Lu_154",     1.539575220000000e+02 }, { "Lu_155",     1.549543162160000e+02 }, { "Lu_156",     1.559530325230000e+02 },
         { "Lu_157",     1.569500983000000e+02 }, { "Lu_158",     1.579493132830000e+02 }, { "Lu_159",     1.589466287760000e+02 }, { "Lu_160",     1.599460330000000e+02 },
         { "Lu_161",     1.609435720000000e+02 }, { "Lu_162",     1.619432772880000e+02 }, { "Lu_163",     1.629411790000000e+02 }, { "Lu_164",     1.639413390000000e+02 },
         { "Lu_165",     1.649394067240000e+02 }, { "Lu_166",     1.659398590000000e+02 }, { "Lu_167",     1.669382700000000e+02 }, { "Lu_168",     1.679387391110000e+02 },
         { "Lu_169",     1.689376514390000e+02 }, { "Lu_170",     1.699384749680000e+02 }, { "Lu_171",     1.709379131360000e+02 }, { "Lu_172",     1.719390856690000e+02 },
         { "Lu_173",     1.729389306020000e+02 }, { "Lu_174",     1.739403374800000e+02 }, { "Lu_175",     1.749407718190000e+02 }, { "Lu_176",     1.759426863100000e+02 },
         { "Lu_177",     1.769437580550000e+02 }, { "Lu_178",     1.779459545590000e+02 }, { "Lu_179",     1.789473274430000e+02 }, { "Lu_180",     1.799498811600000e+02 },
         { "Lu_181",     1.809519700000000e+02 }, { "Lu_182",     1.819550400000000e+02 }, { "Lu_183",     1.829575700000000e+02 }, { "Lu_184",     1.839609100000000e+02 },
         { "Hf_natural", 1.784900000000000e+02 }, { "Hf_153",     1.529706900000000e+02 }, { "Hf_154",     1.539648600000000e+02 }, { "Hf_155",     1.549633900000000e+02 },
         { "Hf_156",     1.559593640250000e+02 }, { "Hf_157",     1.569583960000000e+02 }, { "Hf_158",     1.579547993660000e+02 }, { "Hf_159",     1.589539948700000e+02 },
         { "Hf_160",     1.599506843790000e+02 }, { "Hf_161",     1.609502748440000e+02 }, { "Hf_162",     1.619472104980000e+02 }, { "Hf_163",     1.629470890000000e+02 },
         { "Hf_164",     1.639443672840000e+02 }, { "Hf_165",     1.649445670000000e+02 }, { "Hf_166",     1.659421800000000e+02 }, { "Hf_167",     1.669426000000000e+02 },
         { "Hf_168",     1.679405680000000e+02 }, { "Hf_169",     1.689412590000000e+02 }, { "Hf_170",     1.699396090000000e+02 }, { "Hf_171",     1.709404920000000e+02 },
         { "Hf_172",     1.719394483010000e+02 }, { "Hf_173",     1.729405130000000e+02 }, { "Hf_174",     1.739400461780000e+02 }, { "Hf_175",     1.749415091810000e+02 },
         { "Hf_176",     1.759414086310000e+02 }, { "Hf_177",     1.769432206510000e+02 }, { "Hf_178",     1.779436987660000e+02 }, { "Hf_179",     1.789458161450000e+02 },
         { "Hf_180",     1.799465499530000e+02 }, { "Hf_181",     1.809491012460000e+02 }, { "Hf_182",     1.819505540960000e+02 }, { "Hf_183",     1.829535304390000e+02 },
         { "Hf_184",     1.839554465150000e+02 }, { "Hf_185",     1.849588200000000e+02 }, { "Hf_186",     1.859608900000000e+02 }, { "Hf_187",     1.869645900000000e+02 },
         { "Hf_188",     1.879668500000000e+02 }, { "Ta_natural", 1.809479000000000e+02 }, { "Ta_155",     1.549745920000000e+02 }, { "Ta_156",     1.559723030000000e+02 },
         { "Ta_157",     1.569681924450000e+02 }, { "Ta_158",     1.579666990000000e+02 }, { "Ta_159",     1.589630181730000e+02 }, { "Ta_160",     1.599614860560000e+02 },
         { "Ta_161",     1.609584170000000e+02 }, { "Ta_162",     1.619572918590000e+02 }, { "Ta_163",     1.629543302710000e+02 }, { "Ta_164",     1.639535340000000e+02 },
         { "Ta_165",     1.649507725140000e+02 }, { "Ta_166",     1.659505120000000e+02 }, { "Ta_167",     1.669480930000000e+02 }, { "Ta_168",     1.679480470000000e+02 },
         { "Ta_169",     1.689460110000000e+02 }, { "Ta_170",     1.699461750000000e+02 }, { "Ta_171",     1.709444760000000e+02 }, { "Ta_172",     1.719448950000000e+02 },
         { "Ta_173",     1.729437500000000e+02 }, { "Ta_174",     1.739444540000000e+02 }, { "Ta_175",     1.749437370000000e+02 }, { "Ta_176",     1.759448570000000e+02 },
         { "Ta_177",     1.769444724030000e+02 }, { "Ta_178",     1.779457782210000e+02 }, { "Ta_179",     1.789459295350000e+02 }, { "Ta_180",     1.799474648310000e+02 },
         { "Ta_181",     1.809479957630000e+02 }, { "Ta_182",     1.819501518490000e+02 }, { "Ta_183",     1.829513726160000e+02 }, { "Ta_184",     1.839540079660000e+02 },
         { "Ta_185",     1.849555593750000e+02 }, { "Ta_186",     1.859585520230000e+02 }, { "Ta_187",     1.869605300000000e+02 }, { "Ta_188",     1.879637000000000e+02 },
         { "Ta_189",     1.889658300000000e+02 }, { "Ta_190",     1.899692300000000e+02 }, { "W_natural",  1.838500000000000e+02 }, { "W_158",      1.579745620000000e+02 },
         { "W_159",      1.589729180000000e+02 }, { "W_160",      1.599684788050000e+02 }, { "W_161",      1.609673570000000e+02 }, { "W_162",      1.619634974170000e+02 },
         { "W_163",      1.629625235420000e+02 }, { "W_164",      1.639589543820000e+02 }, { "W_165",      1.649582799490000e+02 }, { "W_166",      1.659550272530000e+02 },
         { "W_167",      1.669548160140000e+02 }, { "W_168",      1.679518083940000e+02 }, { "W_169",      1.689517787900000e+02 }, { "W_170",      1.699492284820000e+02 },
         { "W_171",      1.709494510000000e+02 }, { "W_172",      1.719472920000000e+02 }, { "W_173",      1.729476890000000e+02 }, { "W_174",      1.739460790000000e+02 },
         { "W_175",      1.749467170000000e+02 }, { "W_176",      1.759456340000000e+02 }, { "W_177",      1.769466430000000e+02 }, { "W_178",      1.779458762360000e+02 },
         { "W_179",      1.789470704470000e+02 }, { "W_180",      1.799467044590000e+02 }, { "W_181",      1.809481972480000e+02 }, { "W_182",      1.819482041560000e+02 },
         { "W_183",      1.829502229510000e+02 }, { "W_184",      1.839509311880000e+02 }, { "W_185",      1.849534192640000e+02 }, { "W_186",      1.859543641270000e+02 },
         { "W_187",      1.869571604660000e+02 }, { "W_188",      1.879584891050000e+02 }, { "W_189",      1.889619128680000e+02 }, { "W_190",      1.899631813780000e+02 },
         { "W_191",      1.909666000000000e+02 }, { "W_192",      1.919681700000000e+02 }, { "Re_natural", 1.862070000000000e+02 }, { "Re_160",     1.599821150000000e+02 },
         { "Re_161",     1.609775891190000e+02 }, { "Re_162",     1.619760020000000e+02 }, { "Re_163",     1.629720805350000e+02 }, { "Re_164",     1.639703230000000e+02 },
         { "Re_165",     1.649670885570000e+02 }, { "Re_166",     1.659658080000000e+02 }, { "Re_167",     1.669626010000000e+02 }, { "Re_168",     1.679615726080000e+02 },
         { "Re_169",     1.689587910960000e+02 }, { "Re_170",     1.699582200710000e+02 }, { "Re_171",     1.709557160000000e+02 }, { "Re_172",     1.719554229610000e+02 },
         { "Re_173",     1.729532430000000e+02 }, { "Re_174",     1.739531150000000e+02 }, { "Re_175",     1.749513810000000e+02 }, { "Re_176",     1.759516230000000e+02 },
         { "Re_177",     1.769503280000000e+02 }, { "Re_178",     1.779509890000000e+02 }, { "Re_179",     1.789499876410000e+02 }, { "Re_180",     1.799507890840000e+02 },
         { "Re_181",     1.809500679160000e+02 }, { "Re_182",     1.819512100800000e+02 }, { "Re_183",     1.829508198410000e+02 }, { "Re_184",     1.839525207560000e+02 },
         { "Re_185",     1.849529549820000e+02 }, { "Re_186",     1.859549860840000e+02 }, { "Re_187",     1.869557531090000e+02 }, { "Re_188",     1.879581144380000e+02 },
         { "Re_189",     1.889592290070000e+02 }, { "Re_190",     1.899618179770000e+02 }, { "Re_191",     1.909631252420000e+02 }, { "Re_192",     1.919659600000000e+02 },
         { "Re_193",     1.929674700000000e+02 }, { "Re_194",     1.939704200000000e+02 }, { "Os_natural", 1.902000000000000e+02 }, { "Os_162",     1.619844310000000e+02 },
         { "Os_163",     1.629826900000000e+02 }, { "Os_164",     1.639780356490000e+02 }, { "Os_165",     1.649767620000000e+02 }, { "Os_166",     1.659726907530000e+02 },
         { "Os_167",     1.669715479690000e+02 }, { "Os_168",     1.679678036780000e+02 }, { "Os_169",     1.689670192700000e+02 }, { "Os_170",     1.699635770280000e+02 },
         { "Os_171",     1.709631848190000e+02 }, { "Os_172",     1.719600233030000e+02 }, { "Os_173",     1.729598084090000e+02 }, { "Os_174",     1.739570622020000e+02 },
         { "Os_175",     1.749569458350000e+02 }, { "Os_176",     1.759548060000000e+02 }, { "Os_177",     1.769549653240000e+02 }, { "Os_178",     1.779532512410000e+02 },
         { "Os_179",     1.789538160170000e+02 }, { "Os_180",     1.799523788030000e+02 }, { "Os_181",     1.809532440000000e+02 }, { "Os_182",     1.819521101860000e+02 },
         { "Os_183",     1.829531261020000e+02 }, { "Os_184",     1.839524890710000e+02 }, { "Os_185",     1.849540422650000e+02 }, { "Os_186",     1.859538381580000e+02 },
         { "Os_187",     1.869557504580000e+02 }, { "Os_188",     1.879558382280000e+02 }, { "Os_189",     1.889581474700000e+02 }, { "Os_190",     1.899584470480000e+02 },
         { "Os_191",     1.909609297180000e+02 }, { "Os_192",     1.919614806900000e+02 }, { "Os_193",     1.929641515630000e+02 }, { "Os_194",     1.939651820830000e+02 },
         { "Os_195",     1.949681266610000e+02 }, { "Os_196",     1.959696393330000e+02 }, { "Ir_natural", 1.922200000000000e+02 }, { "Ir_164",     1.639922010000000e+02 },
         { "Ir_165",     1.649875200000000e+02 }, { "Ir_166",     1.659858240000000e+02 }, { "Ir_167",     1.669816651560000e+02 }, { "Ir_168",     1.679798810000000e+02 },
         { "Ir_169",     1.689762949420000e+02 }, { "Ir_170",     1.699749650000000e+02 }, { "Ir_171",     1.709716260420000e+02 }, { "Ir_172",     1.719704560000000e+02 },
         { "Ir_173",     1.729675017390000e+02 }, { "Ir_174",     1.739668610450000e+02 }, { "Ir_175",     1.749641128950000e+02 }, { "Ir_176",     1.759636486880000e+02 },
         { "Ir_177",     1.769613015000000e+02 }, { "Ir_178",     1.779610820000000e+02 }, { "Ir_179",     1.789591222660000e+02 }, { "Ir_180",     1.799592294460000e+02 },
         { "Ir_181",     1.809576252970000e+02 }, { "Ir_182",     1.819580762960000e+02 }, { "Ir_183",     1.829568464580000e+02 }, { "Ir_184",     1.839574760000000e+02 },
         { "Ir_185",     1.849566980000000e+02 }, { "Ir_186",     1.859579461040000e+02 }, { "Ir_187",     1.869573633610000e+02 }, { "Ir_188",     1.879588531210000e+02 },
         { "Ir_189",     1.889587189350000e+02 }, { "Ir_190",     1.899605459680000e+02 }, { "Ir_191",     1.909605940460000e+02 }, { "Ir_192",     1.919626050120000e+02 },
         { "Ir_193",     1.929629264300000e+02 }, { "Ir_194",     1.939650783780000e+02 }, { "Ir_195",     1.949659795730000e+02 }, { "Ir_196",     1.959683965420000e+02 },
         { "Ir_197",     1.969696532850000e+02 }, { "Ir_198",     1.979722800000000e+02 }, { "Ir_199",     1.989738045830000e+02 }, { "Pt_natural", 1.950900000000000e+02 },
         { "Pt_166",     1.659948550000000e+02 }, { "Pt_167",     1.669929790000000e+02 }, { "Pt_168",     1.679881507420000e+02 }, { "Pt_169",     1.689867150000000e+02 },
         { "Pt_170",     1.699824952890000e+02 }, { "Pt_171",     1.709812445420000e+02 }, { "Pt_172",     1.719773471280000e+02 }, { "Pt_173",     1.729764447540000e+02 },
         { "Pt_174",     1.739728187670000e+02 }, { "Pt_175",     1.749724205520000e+02 }, { "Pt_176",     1.759689446220000e+02 }, { "Pt_177",     1.769684694810000e+02 },
         { "Pt_178",     1.779656487240000e+02 }, { "Pt_179",     1.789653634040000e+02 }, { "Pt_180",     1.799630314770000e+02 }, { "Pt_181",     1.809630972850000e+02 },
         { "Pt_182",     1.819611706560000e+02 }, { "Pt_183",     1.829615967030000e+02 }, { "Pt_184",     1.839599222510000e+02 }, { "Pt_185",     1.849606190000000e+02 },
         { "Pt_186",     1.859593508130000e+02 }, { "Pt_187",     1.869605870000000e+02 }, { "Pt_188",     1.879593953910000e+02 }, { "Pt_189",     1.889608336860000e+02 },
         { "Pt_190",     1.899599316550000e+02 }, { "Pt_191",     1.909616766610000e+02 }, { "Pt_192",     1.919610380050000e+02 }, { "Pt_193",     1.929629874010000e+02 },
         { "Pt_194",     1.939626802530000e+02 }, { "Pt_195",     1.949647911340000e+02 }, { "Pt_196",     1.959649515210000e+02 }, { "Pt_197",     1.969673401820000e+02 },
         { "Pt_198",     1.979678927900000e+02 }, { "Pt_199",     1.989705930940000e+02 }, { "Pt_200",     1.999714406770000e+02 }, { "Pt_201",     2.009745128680000e+02 },
         { "Pt_202",     2.019757400000000e+02 }, { "Au_natural", 1.969665000000000e+02 }, { "Au_169",     1.689980800000000e+02 }, { "Au_170",     1.699961220000000e+02 },
         { "Au_171",     1.709918788810000e+02 }, { "Au_172",     1.719900350000000e+02 }, { "Au_173",     1.729862373800000e+02 }, { "Au_174",     1.739847610000000e+02 },
         { "Au_175",     1.749812741070000e+02 }, { "Au_176",     1.759800990000000e+02 }, { "Au_177",     1.769768649080000e+02 }, { "Au_178",     1.779760319200000e+02 },
         { "Au_179",     1.789732128120000e+02 }, { "Au_180",     1.799725211240000e+02 }, { "Au_181",     1.809700790480000e+02 }, { "Au_182",     1.819696178740000e+02 },
         { "Au_183",     1.829675930340000e+02 }, { "Au_184",     1.839674515240000e+02 }, { "Au_185",     1.849657894110000e+02 }, { "Au_186",     1.859659527030000e+02 },
         { "Au_187",     1.869645675410000e+02 }, { "Au_188",     1.879653236610000e+02 }, { "Au_189",     1.889639482860000e+02 }, { "Au_190",     1.899647003390000e+02 },
         { "Au_191",     1.909637042250000e+02 }, { "Au_192",     1.919648129530000e+02 }, { "Au_193",     1.929641497150000e+02 }, { "Au_194",     1.939653652500000e+02 },
         { "Au_195",     1.949650346400000e+02 }, { "Au_196",     1.959665698130000e+02 }, { "Au_197",     1.969665686620000e+02 }, { "Au_198",     1.979682423030000e+02 },
         { "Au_199",     1.989687651930000e+02 }, { "Au_200",     1.999707256470000e+02 }, { "Au_201",     2.009716572400000e+02 }, { "Au_202",     2.019738058380000e+02 },
         { "Au_203",     2.029751545420000e+02 }, { "Au_204",     2.039777240000000e+02 }, { "Au_205",     2.049798700000000e+02 }, { "Hg_natural", 2.005900000000000e+02 },
         { "Hg_171",     1.710037600000000e+02 }, { "Hg_172",     1.719988326860000e+02 }, { "Hg_173",     1.729972420000000e+02 }, { "Hg_174",     1.739928636950000e+02 },
         { "Hg_175",     1.749914232700000e+02 }, { "Hg_176",     1.759873545800000e+02 }, { "Hg_177",     1.769862791580000e+02 }, { "Hg_178",     1.779824831430000e+02 },
         { "Hg_179",     1.789818338610000e+02 }, { "Hg_180",     1.799782663940000e+02 }, { "Hg_181",     1.809778193110000e+02 }, { "Hg_182",     1.819746899640000e+02 },
         { "Hg_183",     1.829744498410000e+02 }, { "Hg_184",     1.839717130510000e+02 }, { "Hg_185",     1.849718990860000e+02 }, { "Hg_186",     1.859693617900000e+02 },
         { "Hg_187",     1.869698142360000e+02 }, { "Hg_188",     1.879675770490000e+02 }, { "Hg_189",     1.889681900340000e+02 }, { "Hg_190",     1.899663224490000e+02 },
         { "Hg_191",     1.909671571050000e+02 }, { "Hg_192",     1.919656343270000e+02 }, { "Hg_193",     1.929666654210000e+02 }, { "Hg_194",     1.939654394090000e+02 },
         { "Hg_195",     1.949667201130000e+02 }, { "Hg_196",     1.959658326490000e+02 }, { "Hg_197",     1.969672129080000e+02 }, { "Hg_198",     1.979667690320000e+02 },
         { "Hg_199",     1.989682799320000e+02 }, { "Hg_200",     1.999683260040000e+02 }, { "Hg_201",     2.009703022680000e+02 }, { "Hg_202",     2.019706430110000e+02 },
         { "Hg_203",     2.029728724840000e+02 }, { "Hg_204",     2.039734939330000e+02 }, { "Hg_205",     2.049760733860000e+02 }, { "Hg_206",     2.059775140660000e+02 },
         { "Hg_207",     2.069825885450000e+02 }, { "Hg_208",     2.079859400000000e+02 }, { "Hg_209",     2.089910400000000e+02 }, { "Hg_210",     2.099945100000000e+02 },
         { "Tl_natural", 2.043700000000000e+02 }, { "Tl_176",     1.760005900000000e+02 }, { "Tl_177",     1.769964272860000e+02 }, { "Tl_178",     1.779948970000000e+02 },
         { "Tl_179",     1.789910890820000e+02 }, { "Tl_180",     1.799899060000000e+02 }, { "Tl_181",     1.809862574470000e+02 }, { "Tl_182",     1.819856671040000e+02 },
         { "Tl_183",     1.829821928020000e+02 }, { "Tl_184",     1.839818731220000e+02 }, { "Tl_185",     1.849787913050000e+02 }, { "Tl_186",     1.859783250000000e+02 },
         { "Tl_187",     1.869759058970000e+02 }, { "Tl_188",     1.879760097820000e+02 }, { "Tl_189",     1.889735884280000e+02 }, { "Tl_190",     1.899738771490000e+02 },
         { "Tl_191",     1.909717861540000e+02 }, { "Tl_192",     1.919722250000000e+02 }, { "Tl_193",     1.929706720000000e+02 }, { "Tl_194",     1.939712000000000e+02 },
         { "Tl_195",     1.949697743350000e+02 }, { "Tl_196",     1.959704811510000e+02 }, { "Tl_197",     1.969695745110000e+02 }, { "Tl_198",     1.979704834950000e+02 },
         { "Tl_199",     1.989698770000000e+02 }, { "Tl_200",     1.999709626720000e+02 }, { "Tl_201",     2.009708188910000e+02 }, { "Tl_202",     2.019721058080000e+02 },
         { "Tl_203",     2.029723442200000e+02 }, { "Tl_204",     2.039738635220000e+02 }, { "Tl_205",     2.049744275410000e+02 }, { "Tl_206",     2.059761103200000e+02 },
         { "Tl_207",     2.069774194290000e+02 }, { "Tl_208",     2.079820187000000e+02 }, { "Tl_209",     2.089853589520000e+02 }, { "Tl_210",     2.099900736890000e+02 },
         { "Tl_211",     2.109934770000000e+02 }, { "Tl_212",     2.119982280000000e+02 }, { "Pb_natural", 2.072000000000000e+02 }, { "Pb_178",     1.780038301910000e+02 },
         { "Pb_179",     1.790021500000000e+02 }, { "Pb_180",     1.799979181730000e+02 }, { "Pb_181",     1.809966239580000e+02 }, { "Pb_182",     1.819926718420000e+02 },
         { "Pb_183",     1.829918746290000e+02 }, { "Pb_184",     1.839881423390000e+02 }, { "Pb_185",     1.849876099440000e+02 }, { "Pb_186",     1.859842389450000e+02 },
         { "Pb_187",     1.869839183700000e+02 }, { "Pb_188",     1.879808743380000e+02 }, { "Pb_189",     1.889808070000000e+02 }, { "Pb_190",     1.899780815170000e+02 },
         { "Pb_191",     1.909782650000000e+02 }, { "Pb_192",     1.919757851710000e+02 }, { "Pb_193",     1.929761732340000e+02 }, { "Pb_194",     1.939740120700000e+02 },
         { "Pb_195",     1.949745420500000e+02 }, { "Pb_196",     1.959727741090000e+02 }, { "Pb_197",     1.969734311240000e+02 }, { "Pb_198",     1.979720339590000e+02 },
         { "Pb_199",     1.989729166500000e+02 }, { "Pb_200",     1.999718266750000e+02 }, { "Pb_201",     2.009728845110000e+02 }, { "Pb_202",     2.019721591330000e+02 },
         { "Pb_203",     2.029733905210000e+02 }, { "Pb_204",     2.039730435890000e+02 }, { "Pb_205",     2.049744817550000e+02 }, { "Pb_206",     2.059744652780000e+02 },
         { "Pb_207",     2.069758968870000e+02 }, { "Pb_208",     2.079766520710000e+02 }, { "Pb_209",     2.089810901200000e+02 }, { "Pb_210",     2.099841885270000e+02 },
         { "Pb_211",     2.109887369640000e+02 }, { "Pb_212",     2.119918975430000e+02 }, { "Pb_213",     2.129965814990000e+02 }, { "Pb_214",     2.139998054080000e+02 },
         { "Pb_215",     2.150048070000000e+02 }, { "Bi_natural", 2.089804000000000e+02 }, { "Bi_184",     1.840011240000000e+02 }, { "Bi_185",     1.849976250000000e+02 },
         { "Bi_186",     1.859965976250000e+02 }, { "Bi_187",     1.869931578350000e+02 }, { "Bi_188",     1.879922651540000e+02 }, { "Bi_189",     1.889891990120000e+02 },
         { "Bi_190",     1.899882951290000e+02 }, { "Bi_191",     1.909857861190000e+02 }, { "Bi_192",     1.919854579540000e+02 }, { "Bi_193",     1.929829597710000e+02 },
         { "Bi_194",     1.939828339600000e+02 }, { "Bi_195",     1.949806507370000e+02 }, { "Bi_196",     1.959806665090000e+02 }, { "Bi_197",     1.969788644540000e+02 },
         { "Bi_198",     1.979792060000000e+02 }, { "Bi_199",     1.989776719610000e+02 }, { "Bi_200",     1.999781318290000e+02 }, { "Bi_201",     2.009770090360000e+02 },
         { "Bi_202",     2.019777423240000e+02 }, { "Bi_203",     2.029768760010000e+02 }, { "Bi_204",     2.039778127360000e+02 }, { "Bi_205",     2.049773893660000e+02 },
         { "Bi_206",     2.059784991300000e+02 }, { "Bi_207",     2.069784706790000e+02 }, { "Bi_208",     2.079797421960000e+02 }, { "Bi_209",     2.089803987340000e+02 },
         { "Bi_210",     2.099841203710000e+02 }, { "Bi_211",     2.109872694600000e+02 }, { "Bi_212",     2.119912857240000e+02 }, { "Bi_213",     2.129943846660000e+02 },
         { "Bi_214",     2.139987115390000e+02 }, { "Bi_215",     2.150017697760000e+02 }, { "Bi_216",     2.160063059430000e+02 }, { "Bi_217",     2.170094700000000e+02 },
         { "Bi_218",     2.180143160000000e+02 }, { "Po_natural", 2.090000000000000e+02 }, { "Po_188",     1.879994220480000e+02 }, { "Po_189",     1.889984805620000e+02 },
         { "Po_190",     1.899951011850000e+02 }, { "Po_191",     1.909945744850000e+02 }, { "Po_192",     1.919913351490000e+02 }, { "Po_193",     1.929910252750000e+02 },
         { "Po_194",     1.939881856060000e+02 }, { "Po_195",     1.949881107280000e+02 }, { "Po_196",     1.959855345800000e+02 }, { "Po_197",     1.969856596300000e+02 },
         { "Po_198",     1.979833886160000e+02 }, { "Po_199",     1.989836660630000e+02 }, { "Po_200",     1.999817986040000e+02 }, { "Po_201",     2.009822597640000e+02 },
         { "Po_202",     2.019807575410000e+02 }, { "Po_203",     2.029814201030000e+02 }, { "Po_204",     2.039803181210000e+02 }, { "Po_205",     2.049812033220000e+02 },
         { "Po_206",     2.059804810990000e+02 }, { "Po_207",     2.069815931730000e+02 }, { "Po_208",     2.079812457020000e+02 }, { "Po_209",     2.089824304350000e+02 },
         { "Po_210",     2.099828736730000e+02 }, { "Po_211",     2.109866531540000e+02 }, { "Po_212",     2.119888679690000e+02 }, { "Po_213",     2.129928572800000e+02 },
         { "Po_214",     2.139952013500000e+02 }, { "Po_215",     2.149994199880000e+02 }, { "Po_216",     2.160019150350000e+02 }, { "Po_217",     2.170063347960000e+02 },
         { "Po_218",     2.180089730370000e+02 }, { "Po_219",     2.190137440000000e+02 }, { "Po_220",     2.200166020000000e+02 }, { "At_natural", 2.100000000000000e+02 },
         { "At_193",     1.929998431120000e+02 }, { "At_194",     1.939987250850000e+02 }, { "At_195",     1.949962680980000e+02 }, { "At_196",     1.959957880770000e+02 },
         { "At_197",     1.969931892150000e+02 }, { "At_198",     1.979928372020000e+02 }, { "At_199",     1.989905322540000e+02 }, { "At_200",     1.999903512640000e+02 },
         { "At_201",     2.009884169990000e+02 }, { "At_202",     2.019886302360000e+02 }, { "At_203",     2.029869419840000e+02 }, { "At_204",     2.039872513260000e+02 },
         { "At_205",     2.049860744830000e+02 }, { "At_206",     2.059866670360000e+02 }, { "At_207",     2.069857835020000e+02 }, { "At_208",     2.079865899770000e+02 },
         { "At_209",     2.089861731430000e+02 }, { "At_210",     2.099871477100000e+02 }, { "At_211",     2.109874962710000e+02 }, { "At_212",     2.119907447710000e+02 },
         { "At_213",     2.129929366460000e+02 }, { "At_214",     2.139963717330000e+02 }, { "At_215",     2.149986525700000e+02 }, { "At_216",     2.160024232570000e+02 },
         { "At_217",     2.170047188220000e+02 }, { "At_218",     2.180086943360000e+02 }, { "At_219",     2.190111616910000e+02 }, { "At_220",     2.200154076820000e+02 },
         { "At_221",     2.210180500000000e+02 }, { "At_222",     2.220223300000000e+02 }, { "At_223",     2.230251900000000e+02 }, { "Rn_natural", 2.220000000000000e+02 },
         { "Rn_195",     1.950054376960000e+02 }, { "Rn_196",     1.960021152230000e+02 }, { "Rn_197",     1.970015843510000e+02 }, { "Rn_198",     1.979986786630000e+02 },
         { "Rn_199",     1.989983702970000e+02 }, { "Rn_200",     1.999956993000000e+02 }, { "Rn_201",     2.009956283350000e+02 }, { "Rn_202",     2.019932634920000e+02 },
         { "Rn_203",     2.029933866870000e+02 }, { "Rn_204",     2.039914287400000e+02 }, { "Rn_205",     2.049917187990000e+02 }, { "Rn_206",     2.059902141040000e+02 },
         { "Rn_207",     2.069907342250000e+02 }, { "Rn_208",     2.079896424700000e+02 }, { "Rn_209",     2.089904147420000e+02 }, { "Rn_210",     2.099896962160000e+02 },
         { "Rn_211",     2.109906005230000e+02 }, { "Rn_212",     2.119907035290000e+02 }, { "Rn_213",     2.129938826680000e+02 }, { "Rn_214",     2.139953625540000e+02 },
         { "Rn_215",     2.149987454830000e+02 }, { "Rn_216",     2.160002743700000e+02 }, { "Rn_217",     2.170039276750000e+02 }, { "Rn_218",     2.180056012560000e+02 },
         { "Rn_219",     2.190094802040000e+02 }, { "Rn_220",     2.200113939810000e+02 }, { "Rn_221",     2.210155367820000e+02 }, { "Rn_222",     2.220175777380000e+02 },
         { "Rn_223",     2.230217900000000e+02 }, { "Rn_224",     2.240240900000000e+02 }, { "Rn_225",     2.250284400000000e+02 }, { "Rn_226",     2.260308900000000e+02 },
         { "Rn_227",     2.270354070000000e+02 }, { "Rn_228",     2.280379860000000e+02 }, { "Fr_natural", 2.230000000000000e+02 }, { "Fr_199",     1.990072581470000e+02 },
         { "Fr_200",     2.000065724900000e+02 }, { "Fr_201",     2.010038608670000e+02 }, { "Fr_202",     2.020033728470000e+02 }, { "Fr_203",     2.030009246470000e+02 },
         { "Fr_204",     2.040006532040000e+02 }, { "Fr_205",     2.049985939600000e+02 }, { "Fr_206",     2.059986660660000e+02 }, { "Fr_207",     2.069969494140000e+02 },
         { "Fr_208",     2.079971387830000e+02 }, { "Fr_209",     2.089959535550000e+02 }, { "Fr_210",     2.099964077380000e+02 }, { "Fr_211",     2.109955365440000e+02 },
         { "Fr_212",     2.119962022440000e+02 }, { "Fr_213",     2.129961890810000e+02 }, { "Fr_214",     2.139989711450000e+02 }, { "Fr_215",     2.150003414970000e+02 },
         { "Fr_216",     2.160031979900000e+02 }, { "Fr_217",     2.170046319510000e+02 }, { "Fr_218",     2.180075783220000e+02 }, { "Fr_219",     2.190092521490000e+02 },
         { "Fr_220",     2.200123274050000e+02 }, { "Fr_221",     2.210142547620000e+02 }, { "Fr_222",     2.220175517300000e+02 }, { "Fr_223",     2.230197358570000e+02 },
         { "Fr_224",     2.240232499510000e+02 }, { "Fr_225",     2.250255654140000e+02 }, { "Fr_226",     2.260293862310000e+02 }, { "Fr_227",     2.270318359380000e+02 },
         { "Fr_228",     2.280357290000000e+02 }, { "Fr_229",     2.290384502280000e+02 }, { "Fr_230",     2.300425100000000e+02 }, { "Fr_231",     2.310454400000000e+02 },
         { "Fr_232",     2.320497720000000e+02 }, { "Ra_natural", 2.260000000000000e+02 }, { "Ra_202",     2.020098906860000e+02 }, { "Ra_203",     2.030092716190000e+02 },
         { "Ra_204",     2.040064996680000e+02 }, { "Ra_205",     2.050062685700000e+02 }, { "Ra_206",     2.060038272700000e+02 }, { "Ra_207",     2.070037981050000e+02 },
         { "Ra_208",     2.080018399400000e+02 }, { "Ra_209",     2.090019913730000e+02 }, { "Ra_210",     2.100004949780000e+02 }, { "Ra_211",     2.110008979870000e+02 },
         { "Ra_212",     2.119997944990000e+02 }, { "Ra_213",     2.130003839590000e+02 }, { "Ra_214",     2.140001078940000e+02 }, { "Ra_215",     2.150027198340000e+02 },
         { "Ra_216",     2.160035330350000e+02 }, { "Ra_217",     2.170063203270000e+02 }, { "Ra_218",     2.180071402300000e+02 }, { "Ra_219",     2.190100850780000e+02 },
         { "Ra_220",     2.200110283840000e+02 }, { "Ra_221",     2.210139173380000e+02 }, { "Ra_222",     2.220153745300000e+02 }, { "Ra_223",     2.230185021710000e+02 },
         { "Ra_224",     2.240202118210000e+02 }, { "Ra_225",     2.250236115640000e+02 }, { "Ra_226",     2.260254098230000e+02 }, { "Ra_227",     2.270291778420000e+02 },
         { "Ra_228",     2.280310702920000e+02 }, { "Ra_229",     2.290349575770000e+02 }, { "Ra_230",     2.300370563940000e+02 }, { "Ra_231",     2.310412200000000e+02 },
         { "Ra_232",     2.320436380000000e+02 }, { "Ra_233",     2.330480600000000e+02 }, { "Ra_234",     2.340507040000000e+02 }, { "Ac_natural", 2.270000000000000e+02 },
         { "Ac_206",     2.060145049800000e+02 }, { "Ac_207",     2.070119497480000e+02 }, { "Ac_208",     2.080115515510000e+02 }, { "Ac_209",     2.090094948630000e+02 },
         { "Ac_210",     2.100094359860000e+02 }, { "Ac_211",     2.110077348350000e+02 }, { "Ac_212",     2.120078138220000e+02 }, { "Ac_213",     2.130066076430000e+02 },
         { "Ac_214",     2.140069017980000e+02 }, { "Ac_215",     2.150064536250000e+02 }, { "Ac_216",     2.160087200750000e+02 }, { "Ac_217",     2.170093469140000e+02 },
         { "Ac_218",     2.180116414530000e+02 }, { "Ac_219",     2.190124203890000e+02 }, { "Ac_220",     2.200147629790000e+02 }, { "Ac_221",     2.210155912480000e+02 },
         { "Ac_222",     2.220178438510000e+02 }, { "Ac_223",     2.230191374680000e+02 }, { "Ac_224",     2.240217228660000e+02 }, { "Ac_225",     2.250232295850000e+02 },
         { "Ac_226",     2.260260980890000e+02 }, { "Ac_227",     2.270277521270000e+02 }, { "Ac_228",     2.280310211120000e+02 }, { "Ac_229",     2.290330152430000e+02 },
         { "Ac_230",     2.300362941780000e+02 }, { "Ac_231",     2.310385587860000e+02 }, { "Ac_232",     2.320420274380000e+02 }, { "Ac_233",     2.330445500000000e+02 },
         { "Ac_234",     2.340484200000000e+02 }, { "Ac_235",     2.350512320000000e+02 }, { "Ac_236",     2.360552960000000e+02 }, { "Th_natural", 2.320381000000000e+02 },
         { "Th_209",     2.090177156820000e+02 }, { "Th_210",     2.100150753420000e+02 }, { "Th_211",     2.110149284130000e+02 }, { "Th_212",     2.120129802880000e+02 },
         { "Th_213",     2.130130101400000e+02 }, { "Th_214",     2.140114997700000e+02 }, { "Th_215",     2.150117303300000e+02 }, { "Th_216",     2.160110621150000e+02 },
         { "Th_217",     2.170131143280000e+02 }, { "Th_218",     2.180132844990000e+02 }, { "Th_219",     2.190155368950000e+02 }, { "Th_220",     2.200157477620000e+02 },
         { "Th_221",     2.210181836740000e+02 }, { "Th_222",     2.220184681210000e+02 }, { "Th_223",     2.230208114480000e+02 }, { "Th_224",     2.240214668950000e+02 },
         { "Th_225",     2.250239510210000e+02 }, { "Th_226",     2.260249030690000e+02 }, { "Th_227",     2.270277040700000e+02 }, { "Th_228",     2.280287411270000e+02 },
         { "Th_229",     2.290317624300000e+02 }, { "Th_230",     2.300331338430000e+02 }, { "Th_231",     2.310363043430000e+02 }, { "Th_232",     2.320380553250000e+02 },
         { "Th_233",     2.330415818430000e+02 }, { "Th_234",     2.340436012300000e+02 }, { "Th_235",     2.350475100740000e+02 }, { "Th_236",     2.360498700000000e+02 },
         { "Th_237",     2.370538940000000e+02 }, { "Th_238",     2.380564960000000e+02 }, { "Pa_natural", 2.310000000000000e+02 }, { "Pa_212",     2.120232041380000e+02 },
         { "Pa_213",     2.130211093400000e+02 }, { "Pa_214",     2.140209184170000e+02 }, { "Pa_215",     2.150191858650000e+02 }, { "Pa_216",     2.160191095640000e+02 },
         { "Pa_217",     2.170183239860000e+02 }, { "Pa_218",     2.180200418890000e+02 }, { "Pa_219",     2.190198831430000e+02 }, { "Pa_220",     2.200218753030000e+02 },
         { "Pa_221",     2.210218779830000e+02 }, { "Pa_222",     2.220237420000000e+02 }, { "Pa_223",     2.230239622730000e+02 }, { "Pa_224",     2.240256257380000e+02 },
         { "Pa_225",     2.250261306780000e+02 }, { "Pa_226",     2.260279477530000e+02 }, { "Pa_227",     2.270288050720000e+02 }, { "Pa_228",     2.280310513760000e+02 },
         { "Pa_229",     2.290320967930000e+02 }, { "Pa_230",     2.300345407540000e+02 }, { "Pa_231",     2.310358839900000e+02 }, { "Pa_232",     2.320385915920000e+02 },
         { "Pa_233",     2.330402472770000e+02 }, { "Pa_234",     2.340433080580000e+02 }, { "Pa_235",     2.350454436150000e+02 }, { "Pa_236",     2.360486812840000e+02 },
         { "Pa_237",     2.370511456590000e+02 }, { "Pa_238",     2.380545027100000e+02 }, { "Pa_239",     2.390572600000000e+02 }, { "Pa_240",     2.400609800000000e+02 },
         { "U_natural",  2.380290000000000e+02 }, { "U_217",      2.170243687910000e+02 }, { "U_218",      2.180235356710000e+02 }, { "U_219",      2.190249191600000e+02 },
         { "U_220",      2.200247230000000e+02 }, { "U_221",      2.210263990000000e+02 }, { "U_222",      2.220260860000000e+02 }, { "U_223",      2.230277386000000e+02 },
         { "U_224",      2.240276047780000e+02 }, { "U_225",      2.250293907170000e+02 }, { "U_226",      2.260293387020000e+02 }, { "U_227",      2.270311563670000e+02 },
         { "U_228",      2.280313740060000e+02 }, { "U_229",      2.290335059390000e+02 }, { "U_230",      2.300339397840000e+02 }, { "U_231",      2.310362937040000e+02 },
         { "U_232",      2.320371561520000e+02 }, { "U_233",      2.330396352070000e+02 }, { "U_234",      2.340409520880000e+02 }, { "U_235",      2.350439299180000e+02 },
         { "U_236",      2.360455680060000e+02 }, { "U_237",      2.370487301840000e+02 }, { "U_238",      2.380507882470000e+02 }, { "U_239",      2.390542932990000e+02 },
         { "U_240",      2.400565919880000e+02 }, { "U_241",      2.410603300000000e+02 }, { "U_242",      2.420629310000000e+02 }, { "Np_natural", 2.370000000000000e+02 },
         { "Np_225",     2.250339139330000e+02 }, { "Np_226",     2.260351450000000e+02 }, { "Np_227",     2.270349567890000e+02 }, { "Np_228",     2.280361800000000e+02 },
         { "Np_229",     2.290362638080000e+02 }, { "Np_230",     2.300378275970000e+02 }, { "Np_231",     2.310382450850000e+02 }, { "Np_232",     2.320401080000000e+02 },
         { "Np_233",     2.330407405460000e+02 }, { "Np_234",     2.340428950380000e+02 }, { "Np_235",     2.350440632670000e+02 }, { "Np_236",     2.360465696000000e+02 },
         { "Np_237",     2.370481734440000e+02 }, { "Np_238",     2.380509464050000e+02 }, { "Np_239",     2.390529390250000e+02 }, { "Np_240",     2.400561621820000e+02 },
         { "Np_241",     2.410582524310000e+02 }, { "Np_242",     2.420616411800000e+02 }, { "Np_243",     2.430642790000000e+02 }, { "Np_244",     2.440678500000000e+02 },
         { "Pu_natural", 2.440000000000000e+02 }, { "Pu_228",     2.280387423280000e+02 }, { "Pu_229",     2.290401502120000e+02 }, { "Pu_230",     2.300396498860000e+02 },
         { "Pu_231",     2.310411011070000e+02 }, { "Pu_232",     2.320411870970000e+02 }, { "Pu_233",     2.330429973750000e+02 }, { "Pu_234",     2.340433170760000e+02 },
         { "Pu_235",     2.350452860500000e+02 }, { "Pu_236",     2.360460579640000e+02 }, { "Pu_237",     2.370484096580000e+02 }, { "Pu_238",     2.380495598940000e+02 },
         { "Pu_239",     2.390521633810000e+02 }, { "Pu_240",     2.400538135450000e+02 }, { "Pu_241",     2.410568514560000e+02 }, { "Pu_242",     2.420587426110000e+02 },
         { "Pu_243",     2.430620030920000e+02 }, { "Pu_244",     2.440642039070000e+02 }, { "Pu_245",     2.450677471540000e+02 }, { "Pu_246",     2.460702046270000e+02 },
         { "Pu_247",     2.470740700000000e+02 }, { "Am_natural", 2.430000000000000e+02 }, { "Am_231",     2.310455600000000e+02 }, { "Am_232",     2.320465900000000e+02 },
         { "Am_233",     2.330463480000000e+02 }, { "Am_234",     2.340478090000000e+02 }, { "Am_235",     2.350479460000000e+02 }, { "Am_236",     2.360495790000000e+02 },
         { "Am_237",     2.370499960000000e+02 }, { "Am_238",     2.380519843240000e+02 }, { "Am_239",     2.390530244790000e+02 }, { "Am_240",     2.400553001790000e+02 },
         { "Am_241",     2.410568291440000e+02 }, { "Am_242",     2.420595491590000e+02 }, { "Am_243",     2.430613810800000e+02 }, { "Am_244",     2.440642848470000e+02 },
         { "Am_245",     2.450664521140000e+02 }, { "Am_246",     2.460697746190000e+02 }, { "Am_247",     2.470720930000000e+02 }, { "Am_248",     2.480757520000000e+02 },
         { "Am_249",     2.490784800000000e+02 }, { "Cm_natural", 2.470000000000000e+02 }, { "Cm_233",     2.330507712320000e+02 }, { "Cm_234",     2.340501598410000e+02 },
         { "Cm_235",     2.350514340000000e+02 }, { "Cm_236",     2.360514130000000e+02 }, { "Cm_237",     2.370529010000000e+02 }, { "Cm_238",     2.380530286970000e+02 },
         { "Cm_239",     2.390549570000000e+02 }, { "Cm_240",     2.400555295390000e+02 }, { "Cm_241",     2.410576530010000e+02 }, { "Cm_242",     2.420588358240000e+02 },
         { "Cm_243",     2.430613891140000e+02 }, { "Cm_244",     2.440627525780000e+02 }, { "Cm_245",     2.450654912490000e+02 }, { "Cm_246",     2.460672236620000e+02 },
         { "Cm_247",     2.470703535400000e+02 }, { "Cm_248",     2.480723485080000e+02 }, { "Cm_249",     2.490759534130000e+02 }, { "Cm_250",     2.500783569590000e+02 },
         { "Cm_251",     2.510822846050000e+02 }, { "Cm_252",     2.520848700000000e+02 }, { "Bk_natural", 2.470000000000000e+02 }, { "Bk_235",     2.350565800000000e+02 },
         { "Bk_236",     2.360573300000000e+02 }, { "Bk_237",     2.370570030000000e+02 }, { "Bk_238",     2.380582810000000e+02 }, { "Bk_239",     2.390582790000000e+02 },
         { "Bk_240",     2.400597590000000e+02 }, { "Bk_241",     2.410602300000000e+02 }, { "Bk_242",     2.420619810000000e+02 }, { "Bk_243",     2.430630075720000e+02 },
         { "Bk_244",     2.440651807740000e+02 }, { "Bk_245",     2.450663616160000e+02 }, { "Bk_246",     2.460686729470000e+02 }, { "Bk_247",     2.470703070800000e+02 },
         { "Bk_248",     2.480730860000000e+02 }, { "Bk_249",     2.490749866570000e+02 }, { "Bk_250",     2.500783165200000e+02 }, { "Bk_251",     2.510807601720000e+02 },
         { "Bk_252",     2.520843100000000e+02 }, { "Bk_253",     2.530868800000000e+02 }, { "Bk_254",     2.540906000000000e+02 }, { "Cf_natural", 2.510000000000000e+02 },
         { "Cf_237",     2.370620700000000e+02 }, { "Cf_238",     2.380614100000000e+02 }, { "Cf_239",     2.390624220000000e+02 }, { "Cf_240",     2.400623020000000e+02 },
         { "Cf_241",     2.410637260000000e+02 }, { "Cf_242",     2.420637015520000e+02 }, { "Cf_243",     2.430654270000000e+02 }, { "Cf_244",     2.440660006890000e+02 },
         { "Cf_245",     2.450680486120000e+02 }, { "Cf_246",     2.460688053090000e+02 }, { "Cf_247",     2.470710005890000e+02 }, { "Cf_248",     2.480721848610000e+02 },
         { "Cf_249",     2.490748535370000e+02 }, { "Cf_250",     2.500764060660000e+02 }, { "Cf_251",     2.510795867880000e+02 }, { "Cf_252",     2.520816258460000e+02 },
         { "Cf_253",     2.530851331450000e+02 }, { "Cf_254",     2.540873229090000e+02 }, { "Cf_255",     2.550910460000000e+02 }, { "Cf_256",     2.560934400000000e+02 },
         { "Es_natural", 2.520000000000000e+02 }, { "Es_120",     1.175000000000000e+02 }, { "Es_121",     1.165460000000000e+02 }, { "Es_122",     1.185440000000000e+02 },
         { "Es_125",     1.175000000000000e+02 }, { "Es_240",     2.400689200000000e+02 }, { "Es_241",     2.410685380000000e+02 }, { "Es_242",     2.420697450000000e+02 },
         { "Es_243",     2.430695480000000e+02 }, { "Es_244",     2.440708830000000e+02 }, { "Es_245",     2.450713240000000e+02 }, { "Es_246",     2.460728960000000e+02 },
         { "Es_247",     2.470736560000000e+02 }, { "Es_248",     2.480754710000000e+02 }, { "Es_249",     2.490764110000000e+02 }, { "Es_250",     2.500786120000000e+02 },
         { "Es_251",     2.510799921420000e+02 }, { "Es_252",     2.520829785120000e+02 }, { "Es_253",     2.530848246970000e+02 }, { "Es_254",     2.540880220210000e+02 },
         { "Es_255",     2.550902731220000e+02 }, { "Es_256",     2.560935980000000e+02 }, { "Es_257",     2.570959790000000e+02 }, { "Es_258",     2.580995200000000e+02 },
         { "Fm_natural", 2.570000000000000e+02 }, { "Fm_242",     2.420734300000000e+02 }, { "Fm_243",     2.430743530000000e+02 }, { "Fm_244",     2.440740840000000e+02 },
         { "Fm_245",     2.450753850000000e+02 }, { "Fm_246",     2.460752990230000e+02 }, { "Fm_247",     2.470768470000000e+02 }, { "Fm_248",     2.480771947140000e+02 },
         { "Fm_249",     2.490790340000000e+02 }, { "Fm_250",     2.500795212640000e+02 }, { "Fm_251",     2.510815750170000e+02 }, { "Fm_252",     2.520824668550000e+02 },
         { "Fm_253",     2.530851852360000e+02 }, { "Fm_254",     2.540868542200000e+02 }, { "Fm_255",     2.550899622020000e+02 }, { "Fm_256",     2.560917731170000e+02 },
         { "Fm_257",     2.570951047240000e+02 }, { "Fm_258",     2.580970760000000e+02 }, { "Fm_259",     2.591005950000000e+02 }, { "Fm_260",     2.601026780000000e+02 },
         { "Md_natural", 2.580000000000000e+02 }, { "Md_245",     2.450808290000000e+02 }, { "Md_246",     2.460818860000000e+02 }, { "Md_247",     2.470816350000000e+02 },
         { "Md_248",     2.480828230000000e+02 }, { "Md_249",     2.490830130000000e+02 }, { "Md_250",     2.500844200000000e+02 }, { "Md_251",     2.510848390000000e+02 },
         { "Md_252",     2.520865600000000e+02 }, { "Md_253",     2.530872800000000e+02 }, { "Md_254",     2.540896560000000e+02 }, { "Md_255",     2.550910827050000e+02 },
         { "Md_256",     2.560940590250000e+02 }, { "Md_257",     2.570955413680000e+02 }, { "Md_258",     2.580984313190000e+02 }, { "Md_259",     2.591005090000000e+02 },
         { "Md_260",     2.601036520000000e+02 }, { "Md_261",     2.611057210000000e+02 }, { "Md_262",     2.621088650000000e+02 }, { "No_natural", 2.590000000000000e+02 },
         { "No_248",     2.480865960000000e+02 }, { "No_249",     2.490878330000000e+02 }, { "No_250",     2.500875100000000e+02 }, { "No_251",     2.510890120000000e+02 },
         { "No_252",     2.520889765210000e+02 }, { "No_253",     2.530906780000000e+02 }, { "No_254",     2.540909552530000e+02 }, { "No_255",     2.550932411310000e+02 },
         { "No_256",     2.560942826660000e+02 }, { "No_257",     2.570968771900000e+02 }, { "No_258",     2.580982070000000e+02 }, { "No_259",     2.591010310000000e+02 },
         { "No_260",     2.601026430000000e+02 }, { "No_261",     2.611057490000000e+02 }, { "No_262",     2.621073010000000e+02 }, { "No_263",     2.631105520000000e+02 },
         { "No_264",     2.641123450000000e+02 }, { "Lr_natural", 2.600000000000000e+02 }, { "Lr_251",     2.510943600000000e+02 }, { "Lr_252",     2.520953710000000e+02 },
         { "Lr_253",     2.530952100000000e+02 }, { "Lr_254",     2.540964540000000e+02 }, { "Lr_255",     2.550966810000000e+02 }, { "Lr_256",     2.560986290000000e+02 },
         { "Lr_257",     2.570995550000000e+02 }, { "Lr_258",     2.581018140000000e+02 }, { "Lr_259",     2.591029010000000e+02 }, { "Lr_260",     2.601055040000000e+02 },
         { "Lr_261",     2.611068830000000e+02 }, { "Lr_262",     2.621096340000000e+02 }, { "Lr_263",     2.631112930000000e+02 }, { "Lr_264",     2.641140380000000e+02 },
         { "Lr_265",     2.651158390000000e+02 }, { "Lr_266",     2.661193050000000e+02 }, { "Rf_natural", 2.610000000000000e+02 }, { "Rf_253",     2.531006890000000e+02 },
         { "Rf_254",     2.541001840000000e+02 }, { "Rf_255",     2.551013400000000e+02 }, { "Rf_256",     2.561011661940000e+02 }, { "Rf_257",     2.571029900000000e+02 },
         { "Rf_258",     2.581034890000000e+02 }, { "Rf_259",     2.591056370000000e+02 }, { "Rf_260",     2.601064400000000e+02 }, { "Rf_261",     2.611087665560000e+02 },
         { "Rf_262",     2.621099250000000e+02 }, { "Rf_263",     2.631125470000000e+02 }, { "Rf_264",     2.641139850000000e+02 }, { "Rf_265",     2.651167040000000e+02 },
         { "Rf_266",     2.661179560000000e+02 }, { "Rf_267",     2.671215290000000e+02 }, { "Rf_268",     2.681236440000000e+02 }, { "Db_natural", 2.620000000000000e+02 },
         { "Db_255",     2.551073980000000e+02 }, { "Db_256",     2.561081270000000e+02 }, { "Db_257",     2.571077220000000e+02 }, { "Db_258",     2.581092310000000e+02 },
         { "Db_259",     2.591096100000000e+02 }, { "Db_260",     2.601113000000000e+02 }, { "Db_261",     2.611120560000000e+02 }, { "Db_262",     2.621140840000000e+02 },
         { "Db_263",     2.631149880000000e+02 }, { "Db_264",     2.641174040000000e+02 }, { "Db_265",     2.651186010000000e+02 }, { "Db_266",     2.661210290000000e+02 },
         { "Db_267",     2.671223770000000e+02 }, { "Db_268",     2.681254450000000e+02 }, { "Db_269",     2.691274600000000e+02 }, { "Db_270",     2.701307120000000e+02 },
         { "Sg_natural", 2.630000000000000e+02 }, { "Sg_258",     2.581131680000000e+02 }, { "Sg_259",     2.591145000000000e+02 }, { "Sg_260",     2.601144220710000e+02 },
         { "Sg_261",     2.611161170000000e+02 }, { "Sg_262",     2.621163980000000e+02 }, { "Sg_263",     2.631183220000000e+02 }, { "Sg_264",     2.641189310000000e+02 },
         { "Sg_265",     2.651211146930000e+02 }, { "Sg_266",     2.661220650000000e+02 }, { "Sg_267",     2.671244250000000e+02 }, { "Sg_268",     2.681256060000000e+02 },
         { "Sg_269",     2.691287550000000e+02 }, { "Sg_270",     2.701303290000000e+02 }, { "Sg_271",     2.711334720000000e+02 }, { "Sg_272",     2.721351580000000e+02 },
         { "Sg_273",     2.731382200000000e+02 }, { "Bh_260",     2.601219700000000e+02 }, { "Bh_261",     2.611216640000000e+02 }, { "Bh_262",     2.621228920000000e+02 },
         { "Bh_263",     2.631230350000000e+02 }, { "Bh_264",     2.641246040000000e+02 }, { "Bh_265",     2.651251470000000e+02 }, { "Bh_266",     2.661269420000000e+02 },
         { "Bh_267",     2.671276500000000e+02 }, { "Bh_268",     2.681297550000000e+02 }, { "Bh_269",     2.691306940000000e+02 }, { "Bh_270",     2.701336160000000e+02 },
         { "Bh_271",     2.711351790000000e+02 }, { "Bh_272",     2.721380320000000e+02 }, { "Bh_273",     2.731396180000000e+02 }, { "Bh_274",     2.741424400000000e+02 },
         { "Bh_275",     2.751442500000000e+02 }, { "Hs_263",     2.631285580000000e+02 }, { "Hs_264",     2.641283948850000e+02 }, { "Hs_265",     2.651300850000000e+02 },
         { "Hs_266",     2.661300970000000e+02 }, { "Hs_267",     2.671317890000000e+02 }, { "Hs_268",     2.681321620000000e+02 }, { "Hs_269",     2.691340560000000e+02 },
         { "Hs_270",     2.701346500000000e+02 }, { "Hs_271",     2.711376570000000e+02 }, { "Hs_272",     2.721390520000000e+02 }, { "Hs_273",     2.731419860000000e+02 },
         { "Hs_274",     2.741431310000000e+02 }, { "Hs_275",     2.751459520000000e+02 }, { "Hs_276",     2.761472080000000e+02 }, { "Hs_277",     2.771498410000000e+02 },
         { "Mt_265",     2.651361510000000e+02 }, { "Mt_266",     2.661372990000000e+02 }, { "Mt_267",     2.671373070000000e+02 }, { "Mt_268",     2.681387280000000e+02 },
         { "Mt_269",     2.691390550000000e+02 }, { "Mt_270",     2.701406570000000e+02 }, { "Mt_271",     2.711411390000000e+02 }, { "Mt_272",     2.721437380000000e+02 },
         { "Mt_273",     2.731449130000000e+02 }, { "Mt_274",     2.741474920000000e+02 }, { "Mt_275",     2.751486470000000e+02 }, { "Mt_276",     2.761511560000000e+02 },
         { "Mt_277",     2.771524200000000e+02 }, { "Mt_278",     2.781548120000000e+02 }, { "Mt_279",     2.791561930000000e+02 }, { "Uun_267",    2.671443410000000e+02 },
         { "Uun_268",    2.681437950000000e+02 }, { "Uun_269",    2.691451240000000e+02 }, { "Uun_270",    2.701447200000000e+02 }, { "Uun_271",    2.711460620000000e+02 },
         { "Uun_272",    2.721463170000000e+02 }, { "Uun_273",    2.731488630000000e+02 }, { "Uun_274",    2.741494920000000e+02 }, { "Uun_275",    2.751521760000000e+02 },
         { "Uun_276",    2.761530340000000e+02 }, { "Uun_277",    2.771556470000000e+02 }, { "Uun_278",    2.781564690000000e+02 }, { "Uun_279",    2.791588610000000e+02 },
         { "Uun_280",    2.801597950000000e+02 }, { "Uun_281",    2.811620610000000e+02 }, { "Uuu_272",    2.721536150000000e+02 }, { "Uuu_273",    2.731536820000000e+02 },
         { "Uuu_274",    2.741557130000000e+02 }, { "Uuu_275",    2.751561420000000e+02 }, { "Uuu_276",    2.761584930000000e+02 }, { "Uuu_277",    2.771595190000000e+02 },
         { "Uuu_278",    2.781616040000000e+02 }, { "Uuu_279",    2.791624680000000e+02 }, { "Uuu_280",    2.801644730000000e+02 }, { "Uuu_281",    2.811653720000000e+02 },
         { "Uuu_282",    2.821674860000000e+02 }, { "Uuu_283",    2.831684150000000e+02 }, { "Uub_277",    2.771639430000000e+02 }, { "Uub_278",    2.781643120000000e+02 },
         { "Uub_279",    2.791665460000000e+02 }, { "Uub_280",    2.801670390000000e+02 }, { "Uub_281",    2.811692860000000e+02 }, { "Uub_282",    2.821697650000000e+02 },
         { "Uub_283",    2.831717920000000e+02 }, { "Uub_284",    2.841723840000000e+02 }, { "Uub_285",    2.851741050000000e+02 }, { "_283",       2.831764510000000e+02 },
         { "_284",       2.841780800000000e+02 }, { "_285",       2.851787320000000e+02 }, { "_286",       2.861804810000000e+02 }, { "_287",       2.871810450000000e+02 },
         { "Uuq_285",    2.851836980000000e+02 }, { "Uuq_286",    2.861838550000000e+02 }, { "Uuq_287",    2.871855990000000e+02 }, { "Uuq_288",    2.881856890000000e+02 },
         { "Uuq_289",    2.891872790000000e+02 }, { "_287",       2.871911860000000e+02 }, { "_288",       2.881924920000000e+02 }, { "_289",       2.891927150000000e+02 },
         { "_290",       2.901941410000000e+02 }, { "_291",       2.911943840000000e+02 }, { "Uuh_289",    2.891988620000000e+02 }, { "Uuh_290",    2.901985900000000e+02 },
         { "Uuh_291",    2.912000110000000e+02 }, { "Uuh_292",    2.921997860000000e+02 }, { "_291",       2.912065640000000e+02 }, { "_292",       2.922075490000000e+02 },
         { "Uuo_293",    2.932146700000000e+02 } };

/*
***************************************************************
*/
double tpia_particleMass_AMU( statusMessageReporting *smr, const char *name ) {

    int i, n = sizeof( ZAMasses ) / sizeof( ZAMasses[0] );
    double mass = -1.;

    //TK modified 
    std::string target(name);
    for( i = 0; i < n; i++ ) {
        //TK modified 
        //if( !strcmp( ZAMasses[i].symbol, name ) ) {
        if( ZAMasses[i].symbol == target ) {
            mass = ZAMasses[i].mass;
            break;
        }
    }
    if( mass == -1. ) smr_setMessageError( smr, NULL, __FILE__, __LINE__, 1, "particle %s not in mass table", name );
    return( mass );
}

#if defined __cplusplus
}
#endif
