//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//

 // G4 Low energy model: n-p scattering -- Data
 // THIS FILE contains static array initialization
 // F.W. Jones, L.G. Greeniaus, H.P. Wellisch

// FWJ 27-AUG-2010: extended to 5 GeV by Tony Kwan TRIUMF

// Table of Cumulative np Scattering Probabilities
// To be used for generation as a function of std::cos(theta cm)
// NOTE: Assumes angle range to be generated is 0-180 degrees
//       This allows tracking of
//       well-defined GEANT4 particles and generation of secondary
// Range of validity of tables: 10 - 1200 MeV
// Results are extracted from RA Arndt"s PSA of 1998
// CM Angle range: 0.5 - 179.5 degrees in 1 degree steps
// Data written 8 values/line, delimited by commas
// Appended at end: cm momentum (GeV/c), Lab Energy (GeV), max 
// dsigma/domega-CM (mb/sr), total cross section 

 #include "G4Types.hh"

 G4float G4AngularDistributionNP::sig[NENERGY][NANGLE] = {
   //------------  0.01 GeV
  {0.00007,   0.00030,   0.00066,   0.00118,   0.00184,   0.00265,   0.00360,
   0.00471,   0.00595,   0.00735,   0.00888,   0.01057,   0.01239,   0.01436,
   0.01648,   0.01874,   0.02113,   0.02367,   0.02635,   0.02917,   0.03213,
   0.03523,   0.03847,   0.04184,   0.04534,   0.04899,   0.05276,   0.05667,
   0.06071,   0.06488,   0.06917,   0.07360,   0.07815,   0.08283,   0.08763,
   0.09255,   0.09760,   0.10276,   0.10805,   0.11345,   0.11896,   0.12459,
   0.13033,   0.13618,   0.14214,   0.14821,   0.15438,   0.16066,   0.16704,
   0.17352,   0.18009,   0.18677,   0.19353,   0.20039,   0.20734,   0.21438,
   0.22151,   0.22871,   0.23601,   0.24338,   0.25083,   0.25835,   0.26595,
   0.27362,   0.28136,   0.28917,   0.29704,   0.30497,   0.31297,   0.32102,
   0.32913,   0.33729,   0.34550,   0.35376,   0.36207,   0.37042,   0.37881,
   0.38724,   0.39570,   0.40420,   0.41273,   0.42129,   0.42988,   0.43848,
   0.44711,   0.45576,   0.46443,   0.47310,   0.48179,   0.49049,   0.49919,
   0.50789,   0.51659,   0.52530,   0.53399,   0.54268,   0.55136,   0.56003,
   0.56868,   0.57731,   0.58592,   0.59451,   0.60307,   0.61161,   0.62011,
   0.62858,   0.63701,   0.64540,   0.65376,   0.66206,   0.67032,   0.67853,
   0.68669,   0.69480,   0.70285,   0.71083,   0.71876,   0.72662,   0.73442,
   0.74214,   0.74979,   0.75737,   0.76487,   0.77230,   0.77964,   0.78689,
   0.79407,   0.80115,   0.80814,   0.81504,   0.82184,   0.82854,   0.83515,
   0.84165,   0.84805,   0.85434,   0.86052,   0.86659,   0.87255,   0.87840,
   0.88413,   0.88974,   0.89523,   0.90060,   0.90584,   0.91096,   0.91595,
   0.92081,   0.92554,   0.93014,   0.93460,   0.93892,   0.94311,   0.94716,
   0.95107,   0.95484,   0.95847,   0.96195,   0.96528,   0.96847,   0.97151,
   0.97440,   0.97714,   0.97973,   0.98217,   0.98445,   0.98658,   0.98856,
   0.99038,   0.99204,   0.99355,   0.99490,   0.99610,   0.99713,   0.99801,
   0.99872,   0.99928,   0.99968,   0.99992,   1.00000},
   //---------  0.02 GeV
  {0.00008,   0.00030,   0.00068,   0.00120,   0.00188,   0.00271,   0.00368,
   0.00480,   0.00608,   0.00750,   0.00906,   0.01078,   0.01264,   0.01465,
   0.01680,   0.01909,   0.02153,   0.02411,   0.02684,   0.02970,   0.03270,
   0.03584,   0.03912,   0.04254,   0.04609,   0.04977,   0.05359,   0.05753,
   0.06161,   0.06582,   0.07015,   0.07461,   0.07919,   0.08390,   0.08873,
   0.09367,   0.09874,   0.10392,   0.10922,   0.11463,   0.12015,   0.12578,
   0.13152,   0.13737,   0.14332,   0.14937,   0.15553,   0.16178,   0.16813,
   0.17458,   0.18112,   0.18775,   0.19447,   0.20128,   0.20817,   0.21515,
   0.22221,   0.22935,   0.23657,   0.24386,   0.25123,   0.25866,   0.26617,
   0.27374,   0.28138,   0.28908,   0.29685,   0.30467,   0.31255,   0.32048,
   0.32846,   0.33650,   0.34458,   0.35271,   0.36088,   0.36909,   0.37734,
   0.38563,   0.39395,   0.40231,   0.41069,   0.41911,   0.42754,   0.43600,
   0.44448,   0.45298,   0.46150,   0.47003,   0.47857,   0.48712,   0.49568,
   0.50424,   0.51280,   0.52136,   0.52992,   0.53848,   0.54703,   0.55557,
   0.56409,   0.57260,   0.58110,   0.58957,   0.59803,   0.60645,   0.61486,
   0.62323,   0.63157,   0.63988,   0.64815,   0.65639,   0.66458,   0.67273,
   0.68083,   0.68889,   0.69689,   0.70484,   0.71274,   0.72057,   0.72835,
   0.73607,   0.74372,   0.75130,   0.75881,   0.76625,   0.77362,   0.78090,
   0.78811,   0.79524,   0.80228,   0.80924,   0.81611,   0.82289,   0.82957,
   0.83616,   0.84265,   0.84904,   0.85533,   0.86151,   0.86759,   0.87356,
   0.87942,   0.88516,   0.89079,   0.89630,   0.90168,   0.90695,   0.91209,
   0.91711,   0.92200,   0.92675,   0.93138,   0.93587,   0.94022,   0.94443,
   0.94851,   0.95244,   0.95623,   0.95987,   0.96336,   0.96670,   0.96989,
   0.97293,   0.97582,   0.97854,   0.98111,   0.98352,   0.98578,   0.98786,
   0.98979,   0.99155,   0.99315,   0.99459,   0.99585,   0.99695,   0.99788,
   0.99864,   0.99924,   0.99966,   0.99992,   1.00000},
   //---------  0.03 GeV
  {0.00008,   0.00032,   0.00073,   0.00129,   0.00201,   0.00289,   0.00393,
   0.00513,   0.00649,   0.00801,   0.00968,   0.01150,   0.01348,   0.01561,
   0.01790,   0.02033,   0.02291,   0.02564,   0.02852,   0.03154,   0.03470,
   0.03801,   0.04145,   0.04503,   0.04875,   0.05261,   0.05659,   0.06071,
   0.06495,   0.06932,   0.07382,   0.07844,   0.08318,   0.08804,   0.09302,
   0.09811,   0.10331,   0.10863,   0.11405,   0.11958,   0.12522,   0.13096,
   0.13679,   0.14273,   0.14876,   0.15489,   0.16111,   0.16742,   0.17382,
   0.18030,   0.18687,   0.19352,   0.20025,   0.20705,   0.21394,   0.22089,
   0.22792,   0.23501,   0.24218,   0.24941,   0.25670,   0.26405,   0.27147,
   0.27894,   0.28646,   0.29404,   0.30167,   0.30935,   0.31708,   0.32486,
   0.33268,   0.34054,   0.34844,   0.35638,   0.36435,   0.37236,   0.38040,
   0.38848,   0.39658,   0.40471,   0.41286,   0.42104,   0.42924,   0.43746,
   0.44569,   0.45395,   0.46221,   0.47049,   0.47878,   0.48708,   0.49538,
   0.50369,   0.51201,   0.52032,   0.52863,   0.53694,   0.54524,   0.55354,
   0.56183,   0.57010,   0.57837,   0.58662,   0.59485,   0.60306,   0.61125,
   0.61942,   0.62756,   0.63568,   0.64377,   0.65182,   0.65984,   0.66783,
   0.67577,   0.68368,   0.69155,   0.69937,   0.70714,   0.71486,   0.72253,
   0.73015,   0.73772,   0.74522,   0.75267,   0.76005,   0.76737,   0.77462,
   0.78180,   0.78891,   0.79594,   0.80290,   0.80978,   0.81658,   0.82329,
   0.82993,   0.83647,   0.84292,   0.84928,   0.85554,   0.86171,   0.86777,
   0.87374,   0.87960,   0.88535,   0.89099,   0.89652,   0.90194,   0.90724,
   0.91242,   0.91747,   0.92241,   0.92721,   0.93188,   0.93643,   0.94083,
   0.94510,   0.94923,   0.95322,   0.95706,   0.96075,   0.96429,   0.96767,
   0.97091,   0.97398,   0.97689,   0.97964,   0.98222,   0.98464,   0.98688,
   0.98896,   0.99086,   0.99258,   0.99413,   0.99550,   0.99669,   0.99770,
   0.99853,   0.99917,   0.99963,   0.99991,   1.00000},
   //---------  0.05 GeV
  {0.00010,   0.00040,   0.00089,   0.00157,   0.00245,   0.00352,   0.00478,
   0.00623,   0.00787,   0.00970,   0.01170,   0.01389,   0.01626,   0.01880,
   0.02151,   0.02439,   0.02744,   0.03065,   0.03402,   0.03754,   0.04122,
   0.04505,   0.04902,   0.05313,   0.05738,   0.06176,   0.06628,   0.07092,
   0.07568,   0.08057,   0.08557,   0.09068,   0.09590,   0.10123,   0.10666,
   0.11219,   0.11781,   0.12353,   0.12933,   0.13522,   0.14119,   0.14725,
   0.15337,   0.15957,   0.16585,   0.17218,   0.17859,   0.18505,   0.19157,
   0.19816,   0.20479,   0.21148,   0.21821,   0.22499,   0.23182,   0.23869,
   0.24560,   0.25255,   0.25953,   0.26655,   0.27361,   0.28069,   0.28781,
   0.29495,   0.30212,   0.30932,   0.31654,   0.32378,   0.33105,   0.33834,
   0.34565,   0.35298,   0.36032,   0.36769,   0.37507,   0.38247,   0.38988,
   0.39731,   0.40476,   0.41221,   0.41968,   0.42717,   0.43466,   0.44217,
   0.44969,   0.45722,   0.46476,   0.47231,   0.47987,   0.48744,   0.49501,
   0.50260,   0.51019,   0.51778,   0.52539,   0.53300,   0.54061,   0.54823,
   0.55584,   0.56347,   0.57109,   0.57871,   0.58633,   0.59395,   0.60157,
   0.60918,   0.61678,   0.62438,   0.63197,   0.63955,   0.64711,   0.65467,
   0.66221,   0.66973,   0.67723,   0.68472,   0.69218,   0.69961,   0.70702,
   0.71440,   0.72175,   0.72907,   0.73635,   0.74360,   0.75080,   0.75796,
   0.76508,   0.77215,   0.77918,   0.78615,   0.79306,   0.79992,   0.80672,
   0.81346,   0.82013,   0.82674,   0.83328,   0.83974,   0.84613,   0.85244,
   0.85867,   0.86482,   0.87088,   0.87685,   0.88273,   0.88851,   0.89420,
   0.89978,   0.90526,   0.91063,   0.91589,   0.92103,   0.92605,   0.93095,
   0.93572,   0.94036,   0.94487,   0.94923,   0.95345,   0.95751,   0.96143,
   0.96518,   0.96876,   0.97218,   0.97542,   0.97849,   0.98136,   0.98405,
   0.98654,   0.98884,   0.99093,   0.99281,   0.99448,   0.99593,   0.99717,
   0.99819,   0.99898,   0.99955,   0.99989,   1.00000},
   //---------  0.07 GeV
  {0.00012,   0.00048,   0.00108,   0.00191,   0.00298,   0.00427,   0.00580,
   0.00755,   0.00952,   0.01171,   0.01412,   0.01673,   0.01954,   0.02256,
   0.02577,   0.02916,   0.03274,   0.03649,   0.04041,   0.04450,   0.04874,
   0.05314,   0.05768,   0.06237,   0.06719,   0.07214,   0.07722,   0.08241,
   0.08772,   0.09313,   0.09865,   0.10426,   0.10996,   0.11575,   0.12162,
   0.12757,   0.13359,   0.13968,   0.14583,   0.15204,   0.15830,   0.16462,
   0.17098,   0.17738,   0.18382,   0.19029,   0.19679,   0.20333,   0.20988,
   0.21646,   0.22306,   0.22968,   0.23630,   0.24294,   0.24959,   0.25625,
   0.26291,   0.26958,   0.27625,   0.28291,   0.28958,   0.29625,   0.30292,
   0.30958,   0.31624,   0.32290,   0.32955,   0.33620,   0.34284,   0.34948,
   0.35612,   0.36275,   0.36939,   0.37601,   0.38264,   0.38927,   0.39589,
   0.40252,   0.40915,   0.41578,   0.42241,   0.42905,   0.43570,   0.44235,
   0.44901,   0.45568,   0.46237,   0.46906,   0.47576,   0.48248,   0.48922,
   0.49597,   0.50274,   0.50952,   0.51633,   0.52315,   0.53000,   0.53686,
   0.54375,   0.55066,   0.55759,   0.56454,   0.57152,   0.57851,   0.58553,
   0.59257,   0.59963,   0.60671,   0.61381,   0.62093,   0.62807,   0.63523,
   0.64239,   0.64958,   0.65677,   0.66398,   0.67119,   0.67841,   0.68564,
   0.69286,   0.70009,   0.70731,   0.71453,   0.72174,   0.72894,   0.73613,
   0.74329,   0.75044,   0.75757,   0.76467,   0.77174,   0.77879,   0.78579,
   0.79276,   0.79968,   0.80656,   0.81340,   0.82018,   0.82690,   0.83357,
   0.84018,   0.84672,   0.85320,   0.85960,   0.86593,   0.87218,   0.87835,
   0.88443,   0.89042,   0.89632,   0.90212,   0.90782,   0.91341,   0.91890,
   0.92426,   0.92950,   0.93462,   0.93960,   0.94443,   0.94913,   0.95366,
   0.95804,   0.96225,   0.96628,   0.97012,   0.97377,   0.97722,   0.98045,
   0.98347,   0.98625,   0.98880,   0.99111,   0.99316,   0.99495,   0.99648,
   0.99774,   0.99873,   0.99943,   0.99986,   1.00000},
   //---------  0.10 GeV
  {0.00015,   0.00060,   0.00133,   0.00235,   0.00366,   0.00524,   0.00710,
   0.00923,   0.01162,   0.01427,   0.01716,   0.02030,   0.02366,   0.02724,
   0.03104,   0.03503,   0.03922,   0.04360,   0.04815,   0.05287,   0.05775,
   0.06278,   0.06795,   0.07325,   0.07868,   0.08423,   0.08988,   0.09563,
   0.10148,   0.10742,   0.11343,   0.11951,   0.12567,   0.13187,   0.13813,
   0.14444,   0.15078,   0.15716,   0.16357,   0.17000,   0.17644,   0.18290,
   0.18936,   0.19582,   0.20228,   0.20874,   0.21519,   0.22162,   0.22803,
   0.23442,   0.24080,   0.24714,   0.25346,   0.25974,   0.26600,   0.27222,
   0.27841,   0.28456,   0.29068,   0.29676,   0.30280,   0.30881,   0.31478,
   0.32071,   0.32661,   0.33247,   0.33830,   0.34410,   0.34987,   0.35560,
   0.36131,   0.36700,   0.37266,   0.37830,   0.38392,   0.38953,   0.39512,
   0.40070,   0.40628,   0.41185,   0.41741,   0.42298,   0.42856,   0.43414,
   0.43973,   0.44533,   0.45095,   0.45659,   0.46226,   0.46795,   0.47367,
   0.47942,   0.48520,   0.49102,   0.49689,   0.50279,   0.50874,   0.51474,
   0.52078,   0.52688,   0.53303,   0.53924,   0.54550,   0.55181,   0.55819,
   0.56462,   0.57111,   0.57766,   0.58427,   0.59094,   0.59767,   0.60445,
   0.61129,   0.61819,   0.62514,   0.63215,   0.63920,   0.64631,   0.65346,
   0.66065,   0.66789,   0.67516,   0.68246,   0.68980,   0.69717,   0.70455,
   0.71196,   0.71938,   0.72681,   0.73425,   0.74169,   0.74913,   0.75656,
   0.76398,   0.77138,   0.77876,   0.78611,   0.79344,   0.80072,   0.80797,
   0.81517,   0.82232,   0.82942,   0.83646,   0.84343,   0.85034,   0.85718,
   0.86395,   0.87063,   0.87724,   0.88375,   0.89017,   0.89650,   0.90273,
   0.90885,   0.91485,   0.92074,   0.92650,   0.93213,   0.93762,   0.94297,
   0.94815,   0.95316,   0.95800,   0.96264,   0.96707,   0.97129,   0.97528,
   0.97902,   0.98250,   0.98570,   0.98861,   0.99122,   0.99351,   0.99547,
   0.99708,   0.99835,   0.99927,   0.99982,   1.00000},
   //---------  0.14 GeV
  {0.00018,   0.00069,   0.00154,   0.00271,   0.00421,   0.00603,   0.00816,
   0.01058,   0.01329,   0.01628,   0.01953,   0.02304,   0.02678,   0.03075,
   0.03494,   0.03933,   0.04391,   0.04867,   0.05360,   0.05868,   0.06391,
   0.06928,   0.07478,   0.08039,   0.08611,   0.09193,   0.09784,   0.10383,
   0.10989,   0.11602,   0.12220,   0.12843,   0.13470,   0.14101,   0.14734,
   0.15369,   0.16005,   0.16642,   0.17279,   0.17915,   0.18550,   0.19183,
   0.19815,   0.20443,   0.21069,   0.21690,   0.22309,   0.22922,   0.23532,
   0.24136,   0.24736,   0.25330,   0.25919,   0.26502,   0.27079,   0.27651,
   0.28217,   0.28777,   0.29331,   0.29879,   0.30421,   0.30958,   0.31489,
   0.32015,   0.32536,   0.33051,   0.33562,   0.34068,   0.34569,   0.35067,
   0.35561,   0.36051,   0.36538,   0.37022,   0.37504,   0.37984,   0.38462,
   0.38939,   0.39414,   0.39890,   0.40365,   0.40840,   0.41316,   0.41794,
   0.42273,   0.42754,   0.43237,   0.43723,   0.44213,   0.44706,   0.45204,
   0.45706,   0.46213,   0.46725,   0.47243,   0.47768,   0.48298,   0.48836,
   0.49380,   0.49933,   0.50492,   0.51060,   0.51636,   0.52221,   0.52814,
   0.53416,   0.54027,   0.54647,   0.55277,   0.55915,   0.56563,   0.57221,
   0.57887,   0.58563,   0.59248,   0.59941,   0.60644,   0.61355,   0.62075,
   0.62803,   0.63538,   0.64281,   0.65031,   0.65788,   0.66551,   0.67320,
   0.68094,   0.68873,   0.69656,   0.70443,   0.71233,   0.72025,   0.72819,
   0.73614,   0.74409,   0.75205,   0.75999,   0.76792,   0.77583,   0.78370,
   0.79155,   0.79935,   0.80710,   0.81480,   0.82244,   0.83001,   0.83752,
   0.84495,   0.85230,   0.85956,   0.86674,   0.87382,   0.88080,   0.88769,
   0.89446,   0.90113,   0.90769,   0.91412,   0.92043,   0.92660,   0.93263,
   0.93852,   0.94424,   0.94978,   0.95514,   0.96030,   0.96524,   0.96994,
   0.97438,   0.97854,   0.98240,   0.98593,   0.98912,   0.99193,   0.99435,
   0.99636,   0.99794,   0.99908,   0.99977,   1.00000},
   //---------  0.18 GeV
  {0.00019,   0.00073,   0.00162,   0.00286,   0.00444,   0.00635,   0.00857,
   0.01110,   0.01391,   0.01701,   0.02036,   0.02396,   0.02779,   0.03185,
   0.03610,   0.04055,   0.04518,   0.04998,   0.05494,   0.06004,   0.06528,
   0.07065,   0.07613,   0.08172,   0.08741,   0.09319,   0.09906,   0.10499,
   0.11099,   0.11705,   0.12316,   0.12931,   0.13550,   0.14171,   0.14794,
   0.15419,   0.16045,   0.16670,   0.17296,   0.17920,   0.18543,   0.19163,
   0.19781,   0.20396,   0.21008,   0.21615,   0.22219,   0.22817,   0.23411,
   0.24000,   0.24584,   0.25162,   0.25734,   0.26300,   0.26861,   0.27415,
   0.27963,   0.28505,   0.29041,   0.29571,   0.30094,   0.30612,   0.31124,
   0.31630,   0.32131,   0.32627,   0.33117,   0.33603,   0.34084,   0.34560,
   0.35033,   0.35502,   0.35968,   0.36430,   0.36890,   0.37348,   0.37804,
   0.38258,   0.38711,   0.39163,   0.39615,   0.40067,   0.40520,   0.40974,
   0.41429,   0.41886,   0.42345,   0.42808,   0.43273,   0.43742,   0.44215,
   0.44693,   0.45175,   0.45663,   0.46156,   0.46656,   0.47163,   0.47676,
   0.48197,   0.48725,   0.49261,   0.49806,   0.50359,   0.50921,   0.51493,
   0.52074,   0.52664,   0.53265,   0.53875,   0.54496,   0.55127,   0.55768,
   0.56420,   0.57082,   0.57755,   0.58439,   0.59132,   0.59836,   0.60550,
   0.61274,   0.62008,   0.62751,   0.63503,   0.64264,   0.65033,   0.65810,
   0.66594,   0.67385,   0.68182,   0.68985,   0.69793,   0.70606,   0.71422,
   0.72240,   0.73061,   0.73884,   0.74706,   0.75529,   0.76350,   0.77170,
   0.77987,   0.78800,   0.79609,   0.80412,   0.81210,   0.82001,   0.82785,
   0.83561,   0.84329,   0.85087,   0.85836,   0.86575,   0.87303,   0.88021,
   0.88727,   0.89422,   0.90105,   0.90776,   0.91435,   0.92080,   0.92712,
   0.93329,   0.93931,   0.94517,   0.95086,   0.95636,   0.96165,   0.96672,
   0.97153,   0.97607,   0.98030,   0.98420,   0.98774,   0.99088,   0.99360,
   0.99587,   0.99766,   0.99895,   0.99974,   1.00000},
   //---------  0.24 GeV
  {0.00019,   0.00074,   0.00163,   0.00288,   0.00445,   0.00635,   0.00855,
   0.01104,   0.01381,   0.01683,   0.02010,   0.02360,   0.02732,   0.03123,
   0.03534,   0.03962,   0.04408,   0.04869,   0.05346,   0.05837,   0.06341,
   0.06858,   0.07388,   0.07929,   0.08480,   0.09042,   0.09613,   0.10192,
   0.10780,   0.11374,   0.11976,   0.12583,   0.13196,   0.13813,   0.14434,
   0.15058,   0.15686,   0.16315,   0.16945,   0.17577,   0.18208,   0.18840,
   0.19470,   0.20099,   0.20727,   0.21352,   0.21974,   0.22593,   0.23208,
   0.23819,   0.24426,   0.25029,   0.25626,   0.26219,   0.26805,   0.27387,
   0.27962,   0.28532,   0.29095,   0.29653,   0.30205,   0.30750,   0.31290,
   0.31824,   0.32351,   0.32873,   0.33390,   0.33901,   0.34407,   0.34907,
   0.35403,   0.35895,   0.36382,   0.36865,   0.37344,   0.37820,   0.38294,
   0.38764,   0.39232,   0.39698,   0.40163,   0.40626,   0.41089,   0.41551,
   0.42013,   0.42475,   0.42939,   0.43403,   0.43869,   0.44337,   0.44807,
   0.45280,   0.45757,   0.46236,   0.46720,   0.47208,   0.47701,   0.48199,
   0.48703,   0.49213,   0.49729,   0.50251,   0.50781,   0.51318,   0.51862,
   0.52415,   0.52976,   0.53545,   0.54124,   0.54712,   0.55309,   0.55916,
   0.56532,   0.57159,   0.57796,   0.58443,   0.59101,   0.59769,   0.60448,
   0.61137,   0.61837,   0.62547,   0.63267,   0.63997,   0.64737,   0.65486,
   0.66245,   0.67012,   0.67788,   0.68571,   0.69362,   0.70159,   0.70962,
   0.71770,   0.72583,   0.73400,   0.74220,   0.75041,   0.75864,   0.76687,
   0.77509,   0.78329,   0.79146,   0.79960,   0.80768,   0.81571,   0.82368,
   0.83157,   0.83937,   0.84708,   0.85470,   0.86220,   0.86960,   0.87688,
   0.88403,   0.89106,   0.89797,   0.90474,   0.91138,   0.91788,   0.92425,
   0.93048,   0.93656,   0.94249,   0.94827,   0.95387,   0.95929,   0.96451,
   0.96950,   0.97424,   0.97870,   0.98284,   0.98662,   0.99001,   0.99296,
   0.99544,   0.99741,   0.99884,   0.99971,   1.00000},
   //---------  0.34 GeV
  {0.00019,   0.00072,   0.00159,   0.00279,   0.00431,   0.00612,   0.00823,
   0.01060,   0.01322,   0.01608,   0.01917,   0.02247,   0.02598,   0.02969,
   0.03359,   0.03768,   0.04195,   0.04641,   0.05104,   0.05584,   0.06082,
   0.06596,   0.07126,   0.07673,   0.08235,   0.08811,   0.09403,   0.10008,
   0.10626,   0.11257,   0.11900,   0.12554,   0.13219,   0.13893,   0.14576,
   0.15267,   0.15965,   0.16669,   0.17379,   0.18094,   0.18812,   0.19533,
   0.20257,   0.20981,   0.21706,   0.22430,   0.23153,   0.23874,   0.24592,
   0.25307,   0.26017,   0.26724,   0.27424,   0.28120,   0.28808,   0.29491,
   0.30166,   0.30834,   0.31494,   0.32147,   0.32791,   0.33427,   0.34055,
   0.34674,   0.35285,   0.35888,   0.36483,   0.37069,   0.37647,   0.38217,
   0.38779,   0.39334,   0.39882,   0.40422,   0.40956,   0.41483,   0.42004,
   0.42519,   0.43028,   0.43532,   0.44031,   0.44525,   0.45015,   0.45501,
   0.45984,   0.46463,   0.46940,   0.47414,   0.47886,   0.48356,   0.48825,
   0.49292,   0.49759,   0.50226,   0.50693,   0.51160,   0.51629,   0.52098,
   0.52568,   0.53041,   0.53516,   0.53994,   0.54474,   0.54958,   0.55446,
   0.55937,   0.56434,   0.56935,   0.57441,   0.57953,   0.58471,   0.58996,
   0.59527,   0.60065,   0.60611,   0.61165,   0.61727,   0.62297,   0.62877,
   0.63465,   0.64063,   0.64670,   0.65287,   0.65914,   0.66552,   0.67199,
   0.67857,   0.68525,   0.69202,   0.69890,   0.70588,   0.71295,   0.72011,
   0.72736,   0.73469,   0.74209,   0.74957,   0.75711,   0.76470,   0.77233,
   0.78001,   0.78771,   0.79542,   0.80314,   0.81086,   0.81855,   0.82621,
   0.83383,   0.84140,   0.84889,   0.85631,   0.86365,   0.87088,   0.87800,
   0.88500,   0.89188,   0.89864,   0.90525,   0.91173,   0.91806,   0.92425,
   0.93030,   0.93621,   0.94197,   0.94758,   0.95304,   0.95835,   0.96348,
   0.96843,   0.97316,   0.97766,   0.98188,   0.98579,   0.98932,   0.99244,
   0.99508,   0.99719,   0.99874,   0.99968,   1.00000},
   //---------  0.42 GeV
  {0.00020,   0.00075,   0.00165,   0.00289,   0.00445,   0.00633,   0.00849,
   0.01094,   0.01364,   0.01660,   0.01979,   0.02322,   0.02688,   0.03077,
   0.03487,   0.03920,   0.04375,   0.04852,   0.05350,   0.05870,   0.06411,
   0.06973,   0.07556,   0.08159,   0.08782,   0.09423,   0.10084,   0.10761,
   0.11456,   0.12167,   0.12893,   0.13633,   0.14386,   0.15152,   0.15928,
   0.16715,   0.17510,   0.18313,   0.19123,   0.19938,   0.20757,   0.21580,
   0.22404,   0.23229,   0.24054,   0.24877,   0.25698,   0.26515,   0.27328,
   0.28135,   0.28937,   0.29732,   0.30519,   0.31298,   0.32068,   0.32829,
   0.33580,   0.34320,   0.35051,   0.35771,   0.36479,   0.37177,   0.37864,
   0.38539,   0.39204,   0.39857,   0.40499,   0.41131,   0.41751,   0.42362,
   0.42962,   0.43551,   0.44132,   0.44702,   0.45264,   0.45816,   0.46361,
   0.46896,   0.47424,   0.47945,   0.48458,   0.48964,   0.49464,   0.49958,
   0.50446,   0.50928,   0.51405,   0.51878,   0.52345,   0.52809,   0.53269,
   0.53725,   0.54178,   0.54628,   0.55076,   0.55521,   0.55965,   0.56407,
   0.56847,   0.57287,   0.57726,   0.58165,   0.58604,   0.59044,   0.59484,
   0.59925,   0.60368,   0.60813,   0.61260,   0.61710,   0.62163,   0.62620,
   0.63080,   0.63545,   0.64015,   0.64490,   0.64970,   0.65457,   0.65950,
   0.66450,   0.66958,   0.67473,   0.67997,   0.68529,   0.69070,   0.69620,
   0.70179,   0.70749,   0.71328,   0.71917,   0.72516,   0.73126,   0.73745,
   0.74374,   0.75014,   0.75662,   0.76320,   0.76987,   0.77661,   0.78343,
   0.79032,   0.79727,   0.80427,   0.81131,   0.81839,   0.82548,   0.83258,
   0.83967,   0.84675,   0.85380,   0.86081,   0.86776,   0.87464,   0.88144,
   0.88815,   0.89475,   0.90125,   0.90762,   0.91386,   0.91997,   0.92594,
   0.93177,   0.93746,   0.94301,   0.94842,   0.95368,   0.95880,   0.96376,
   0.96855,   0.97316,   0.97757,   0.98173,   0.98560,   0.98913,   0.99227,
   0.99495,   0.99711,   0.99870,   0.99967,   1.00000},
   //---------  0.50 GeV
  {0.00023,   0.00086,   0.00190,   0.00333,   0.00513,   0.00729,   0.00979,
   0.01261,   0.01574,   0.01917,   0.02288,   0.02688,   0.03115,   0.03570,
   0.04053,   0.04562,   0.05098,   0.05661,   0.06251,   0.06866,   0.07507,
   0.08173,   0.08863,   0.09577,   0.10314,   0.11072,   0.11851,   0.12650,
   0.13468,   0.14303,   0.15154,   0.16020,   0.16900,   0.17791,   0.18693,
   0.19605,   0.20524,   0.21449,   0.22379,   0.23312,   0.24247,   0.25182,
   0.26117,   0.27048,   0.27977,   0.28900,   0.29818,   0.30728,   0.31630,
   0.32523,   0.33406,   0.34278,   0.35138,   0.35987,   0.36823,   0.37645,
   0.38454,   0.39250,   0.40031,   0.40798,   0.41551,   0.42289,   0.43013,
   0.43723,   0.44419,   0.45101,   0.45769,   0.46424,   0.47065,   0.47694,
   0.48310,   0.48913,   0.49505,   0.50085,   0.50654,   0.51212,   0.51759,
   0.52297,   0.52824,   0.53342,   0.53852,   0.54352,   0.54845,   0.55329,
   0.55806,   0.56276,   0.56739,   0.57195,   0.57645,   0.58089,   0.58528,
   0.58961,   0.59390,   0.59814,   0.60233,   0.60648,   0.61060,   0.61468,
   0.61873,   0.62275,   0.62675,   0.63072,   0.63467,   0.63861,   0.64253,
   0.64645,   0.65035,   0.65426,   0.65816,   0.66207,   0.66598,   0.66991,
   0.67385,   0.67781,   0.68180,   0.68581,   0.68985,   0.69393,   0.69806,
   0.70222,   0.70644,   0.71071,   0.71505,   0.71944,   0.72391,   0.72844,
   0.73306,   0.73776,   0.74254,   0.74741,   0.75237,   0.75742,   0.76257,
   0.76782,   0.77317,   0.77862,   0.78416,   0.78980,   0.79553,   0.80136,
   0.80727,   0.81327,   0.81934,   0.82548,   0.83168,   0.83794,   0.84423,
   0.85056,   0.85690,   0.86325,   0.86960,   0.87592,   0.88222,   0.88846,
   0.89465,   0.90076,   0.90678,   0.91271,   0.91853,   0.92424,   0.92982,
   0.93528,   0.94061,   0.94580,   0.95086,   0.95579,   0.96058,   0.96523,
   0.96973,   0.97408,   0.97825,   0.98221,   0.98592,   0.98933,   0.99238,
   0.99500,   0.99713,   0.99871,   0.99967,   1.00000},
   //---------  0.58 GeV
  {0.00029,   0.00110,   0.00243,   0.00427,   0.00660,   0.00938,   0.01260,
   0.01623,   0.02027,   0.02469,   0.02948,   0.03464,   0.04015,   0.04601,
   0.05222,   0.05876,   0.06564,   0.07283,   0.08034,   0.08815,   0.09626,
   0.10465,   0.11331,   0.12223,   0.13138,   0.14077,   0.15037,   0.16017,
   0.17014,   0.18027,   0.19055,   0.20096,   0.21147,   0.22207,   0.23275,
   0.24347,   0.25423,   0.26500,   0.27577,   0.28652,   0.29723,   0.30789,
   0.31847,   0.32897,   0.33938,   0.34967,   0.35984,   0.36987,   0.37975,
   0.38948,   0.39905,   0.40845,   0.41767,   0.42671,   0.43556,   0.44423,
   0.45271,   0.46099,   0.46909,   0.47699,   0.48471,   0.49223,   0.49957,
   0.50673,   0.51371,   0.52051,   0.52714,   0.53360,   0.53989,   0.54603,
   0.55201,   0.55785,   0.56354,   0.56908,   0.57450,   0.57978,   0.58494,
   0.58997,   0.59489,   0.59970,   0.60440,   0.60900,   0.61350,   0.61790,
   0.62221,   0.62644,   0.63059,   0.63465,   0.63865,   0.64257,   0.64643,
   0.65022,   0.65395,   0.65763,   0.66125,   0.66483,   0.66836,   0.67184,
   0.67529,   0.67870,   0.68208,   0.68543,   0.68876,   0.69206,   0.69534,
   0.69860,   0.70185,   0.70509,   0.70832,   0.71155,   0.71478,   0.71802,
   0.72126,   0.72451,   0.72777,   0.73105,   0.73436,   0.73769,   0.74105,
   0.74444,   0.74787,   0.75134,   0.75486,   0.75843,   0.76206,   0.76575,
   0.76949,   0.77331,   0.77720,   0.78116,   0.78520,   0.78933,   0.79354,
   0.79784,   0.80222,   0.80670,   0.81128,   0.81594,   0.82070,   0.82555,
   0.83049,   0.83552,   0.84064,   0.84583,   0.85110,   0.85643,   0.86182,
   0.86726,   0.87274,   0.87825,   0.88378,   0.88931,   0.89484,   0.90034,
   0.90581,   0.91122,   0.91657,   0.92185,   0.92703,   0.93212,   0.93710,
   0.94196,   0.94671,   0.95132,   0.95582,   0.96018,   0.96443,   0.96855,
   0.97254,   0.97640,   0.98011,   0.98366,   0.98701,   0.99011,   0.99290,
   0.99532,   0.99731,   0.99878,   0.99969,   1.00000},
   //---------  0.62 GeV
  {0.00033,   0.00125,   0.00277,   0.00487,   0.00752,   0.01069,   0.01436,
   0.01850,   0.02311,   0.02815,   0.03361,   0.03949,   0.04576,   0.05243,
   0.05948,   0.06691,   0.07469,   0.08283,   0.09130,   0.10010,   0.10920,
   0.11860,   0.12828,   0.13822,   0.14841,   0.15881,   0.16943,   0.18023,
   0.19119,   0.20230,   0.21354,   0.22488,   0.23630,   0.24779,   0.25931,
   0.27086,   0.28241,   0.29393,   0.30542,   0.31686,   0.32821,   0.33948,
   0.35063,   0.36166,   0.37255,   0.38329,   0.39387,   0.40427,   0.41448,
   0.42451,   0.43433,   0.44395,   0.45335,   0.46254,   0.47151,   0.48026,
   0.48880,   0.49711,   0.50520,   0.51307,   0.52073,   0.52818,   0.53541,
   0.54245,   0.54928,   0.55592,   0.56236,   0.56862,   0.57470,   0.58061,
   0.58635,   0.59192,   0.59734,   0.60260,   0.60772,   0.61270,   0.61754,
   0.62225,   0.62684,   0.63131,   0.63566,   0.63990,   0.64404,   0.64808,
   0.65203,   0.65588,   0.65965,   0.66334,   0.66695,   0.67049,   0.67396,
   0.67736,   0.68071,   0.68399,   0.68723,   0.69042,   0.69356,   0.69666,
   0.69973,   0.70276,   0.70576,   0.70874,   0.71169,   0.71462,   0.71753,
   0.72043,   0.72332,   0.72620,   0.72908,   0.73195,   0.73483,   0.73772,
   0.74062,   0.74353,   0.74645,   0.74939,   0.75236,   0.75535,   0.75838,
   0.76143,   0.76453,   0.76767,   0.77085,   0.77408,   0.77736,   0.78070,
   0.78410,   0.78756,   0.79110,   0.79470,   0.79838,   0.80214,   0.80598,
   0.80990,   0.81391,   0.81801,   0.82220,   0.82648,   0.83086,   0.83532,
   0.83988,   0.84452,   0.84925,   0.85406,   0.85895,   0.86392,   0.86894,
   0.87403,   0.87916,   0.88433,   0.88952,   0.89474,   0.89995,   0.90515,
   0.91032,   0.91546,   0.92054,   0.92555,   0.93049,   0.93533,   0.94007,
   0.94470,   0.94921,   0.95360,   0.95786,   0.96201,   0.96603,   0.96993,
   0.97371,   0.97737,   0.98090,   0.98427,   0.98746,   0.99043,   0.99312,
   0.99546,   0.99738,   0.99881,   0.99970,   1.00000},
   //---------  0.68 GeV
  {0.00038,   0.00148,   0.00327,   0.00575,   0.00888,   0.01263,   0.01698,
   0.02189,   0.02733,   0.03330,   0.03977,   0.04672,   0.05414,   0.06201,
   0.07032,   0.07906,   0.08819,   0.09771,   0.10760,   0.11783,   0.12839,
   0.13924,   0.15038,   0.16178,   0.17340,   0.18524,   0.19725,   0.20943,
   0.22173,   0.23415,   0.24665,   0.25920,   0.27179,   0.28438,   0.29697,
   0.30951,   0.32199,   0.33439,   0.34669,   0.35887,   0.37091,   0.38279,
   0.39449,   0.40600,   0.41732,   0.42841,   0.43928,   0.44992,   0.46031,
   0.47046,   0.48034,   0.48997,   0.49934,   0.50844,   0.51728,   0.52586,
   0.53418,   0.54223,   0.55003,   0.55758,   0.56489,   0.57195,   0.57877,
   0.58536,   0.59173,   0.59789,   0.60383,   0.60957,   0.61511,   0.62047,
   0.62564,   0.63064,   0.63546,   0.64013,   0.64464,   0.64901,   0.65323,
   0.65732,   0.66128,   0.66512,   0.66884,   0.67245,   0.67596,   0.67937,
   0.68269,   0.68592,   0.68907,   0.69215,   0.69515,   0.69809,   0.70097,
   0.70379,   0.70656,   0.70928,   0.71196,   0.71460,   0.71721,   0.71978,
   0.72233,   0.72486,   0.72737,   0.72986,   0.73234,   0.73481,   0.73728,
   0.73974,   0.74221,   0.74467,   0.74715,   0.74963,   0.75212,   0.75463,
   0.75715,   0.75970,   0.76227,   0.76486,   0.76748,   0.77013,   0.77282,
   0.77554,   0.77830,   0.78110,   0.78395,   0.78685,   0.78980,   0.79281,
   0.79587,   0.79899,   0.80218,   0.80544,   0.80877,   0.81217,   0.81565,
   0.81921,   0.82286,   0.82659,   0.83040,   0.83431,   0.83831,   0.84240,
   0.84658,   0.85085,   0.85521,   0.85966,   0.86419,   0.86881,   0.87350,
   0.87825,   0.88307,   0.88794,   0.89285,   0.89779,   0.90274,   0.90771,
   0.91266,   0.91760,   0.92249,   0.92733,   0.93211,   0.93681,   0.94141,
   0.94592,   0.95031,   0.95459,   0.95874,   0.96278,   0.96669,   0.97048,
   0.97416,   0.97772,   0.98115,   0.98444,   0.98757,   0.99048,   0.99313,
   0.99546,   0.99737,   0.99881,   0.99970,   1.00000},
   //---------  0.74 GeV
  {0.00043,   0.00168,   0.00373,   0.00655,   0.01012,   0.01440,   0.01935,
   0.02495,   0.03117,   0.03798,   0.04537,   0.05330,   0.06176,   0.07073,
   0.08018,   0.09010,   0.10045,   0.11121,   0.12235,   0.13386,   0.14569,
   0.15782,   0.17022,   0.18285,   0.19570,   0.20873,   0.22190,   0.23519,
   0.24856,   0.26200,   0.27546,   0.28892,   0.30236,   0.31574,   0.32905,
   0.34225,   0.35532,   0.36824,   0.38099,   0.39355,   0.40591,   0.41803,
   0.42992,   0.44155,   0.45292,   0.46401,   0.47482,   0.48533,   0.49555,
   0.50547,   0.51509,   0.52440,   0.53341,   0.54212,   0.55052,   0.55863,
   0.56645,   0.57398,   0.58123,   0.58821,   0.59492,   0.60137,   0.60757,
   0.61353,   0.61925,   0.62475,   0.63002,   0.63509,   0.63996,   0.64464,
   0.64913,   0.65345,   0.65761,   0.66160,   0.66545,   0.66915,   0.67272,
   0.67616,   0.67948,   0.68269,   0.68580,   0.68880,   0.69171,   0.69454,
   0.69729,   0.69997,   0.70258,   0.70512,   0.70762,   0.71006,   0.71246,
   0.71482,   0.71714,   0.71943,   0.72170,   0.72395,   0.72618,   0.72840,
   0.73060,   0.73280,   0.73500,   0.73720,   0.73941,   0.74162,   0.74384,
   0.74607,   0.74831,   0.75057,   0.75286,   0.75516,   0.75748,   0.75983,
   0.76221,   0.76461,   0.76705,   0.76952,   0.77202,   0.77456,   0.77713,
   0.77975,   0.78240,   0.78510,   0.78784,   0.79063,   0.79348,   0.79637,
   0.79932,   0.80232,   0.80538,   0.80851,   0.81170,   0.81497,   0.81830,
   0.82170,   0.82519,   0.82875,   0.83240,   0.83613,   0.83995,   0.84386,
   0.84785,   0.85194,   0.85612,   0.86038,   0.86474,   0.86918,   0.87370,
   0.87829,   0.88296,   0.88769,   0.89247,   0.89730,   0.90216,   0.90704,
   0.91193,   0.91682,   0.92168,   0.92650,   0.93127,   0.93598,   0.94061,
   0.94514,   0.94957,   0.95389,   0.95809,   0.96217,   0.96613,   0.96997,
   0.97368,   0.97728,   0.98075,   0.98409,   0.98726,   0.99022,   0.99293,
   0.99531,   0.99728,   0.99877,   0.99969,   1.00000},
   //---------  0.80 GeV
  {0.00048,   0.00187,   0.00414,   0.00728,   0.01125,   0.01601,   0.02152,
   0.02775,   0.03467,   0.04225,   0.05046,   0.05928,   0.06868,   0.07863,
   0.08910,   0.10007,   0.11150,   0.12335,   0.13560,   0.14821,   0.16114,
   0.17435,   0.18782,   0.20150,   0.21536,   0.22936,   0.24347,   0.25764,
   0.27186,   0.28608,   0.30027,   0.31440,   0.32844,   0.34237,   0.35615,
   0.36976,   0.38318,   0.39638,   0.40935,   0.42206,   0.43450,   0.44666,
   0.45851,   0.47006,   0.48128,   0.49218,   0.50275,   0.51298,   0.52287,
   0.53242,   0.54164,   0.55052,   0.55906,   0.56728,   0.57518,   0.58275,
   0.59002,   0.59699,   0.60366,   0.61005,   0.61617,   0.62202,   0.62761,
   0.63296,   0.63808,   0.64296,   0.64764,   0.65210,   0.65637,   0.66046,
   0.66436,   0.66811,   0.67169,   0.67512,   0.67841,   0.68157,   0.68461,
   0.68753,   0.69035,   0.69306,   0.69568,   0.69822,   0.70068,   0.70307,
   0.70539,   0.70766,   0.70987,   0.71204,   0.71417,   0.71626,   0.71833,
   0.72037,   0.72239,   0.72440,   0.72639,   0.72838,   0.73037,   0.73236,
   0.73436,   0.73636,   0.73838,   0.74041,   0.74246,   0.74452,   0.74661,
   0.74873,   0.75086,   0.75303,   0.75523,   0.75745,   0.75971,   0.76200,
   0.76433,   0.76669,   0.76909,   0.77153,   0.77400,   0.77651,   0.77907,
   0.78166,   0.78429,   0.78697,   0.78969,   0.79245,   0.79526,   0.79812,
   0.80103,   0.80399,   0.80700,   0.81007,   0.81320,   0.81639,   0.81964,
   0.82296,   0.82635,   0.82981,   0.83334,   0.83696,   0.84066,   0.84444,
   0.84831,   0.85226,   0.85630,   0.86044,   0.86466,   0.86896,   0.87336,
   0.87783,   0.88238,   0.88701,   0.89170,   0.89644,   0.90123,   0.90605,
   0.91089,   0.91575,   0.92059,   0.92542,   0.93020,   0.93493,   0.93959,
   0.94417,   0.94865,   0.95303,   0.95729,   0.96143,   0.96545,   0.96935,
   0.97312,   0.97677,   0.98030,   0.98369,   0.98691,   0.98994,   0.99271,
   0.99516,   0.99719,   0.99872,   0.99968,   1.00000},
   //---------  0.90 GeV
  {0.00056,   0.00217,   0.00482,   0.00847,   0.01308,   0.01861,   0.02502,
   0.03227,   0.04031,   0.04912,   0.05865,   0.06887,   0.07974,   0.09123,
   0.10329,   0.11587,   0.12895,   0.14246,   0.15636,   0.17061,   0.18515,
   0.19995,   0.21495,   0.23011,   0.24538,   0.26072,   0.27608,   0.29143,
   0.30673,   0.32194,   0.33703,   0.35195,   0.36668,   0.38120,   0.39547,
   0.40947,   0.42318,   0.43658,   0.44965,   0.46238,   0.47475,   0.48676,
   0.49839,   0.50964,   0.52050,   0.53098,   0.54108,   0.55078,   0.56011,
   0.56906,   0.57764,   0.58586,   0.59372,   0.60123,   0.60840,   0.61525,
   0.62178,   0.62800,   0.63392,   0.63957,   0.64494,   0.65004,   0.65490,
   0.65952,   0.66392,   0.66809,   0.67206,   0.67584,   0.67943,   0.68285,
   0.68611,   0.68921,   0.69217,   0.69499,   0.69768,   0.70026,   0.70273,
   0.70511,   0.70739,   0.70958,   0.71170,   0.71376,   0.71575,   0.71768,
   0.71958,   0.72142,   0.72324,   0.72502,   0.72679,   0.72853,   0.73026,
   0.73199,   0.73371,   0.73543,   0.73715,   0.73889,   0.74063,   0.74239,
   0.74417,   0.74597,   0.74779,   0.74964,   0.75151,   0.75342,   0.75535,
   0.75732,   0.75933,   0.76137,   0.76345,   0.76556,   0.76771,   0.76990,
   0.77213,   0.77440,   0.77671,   0.77905,   0.78144,   0.78386,   0.78632,
   0.78882,   0.79135,   0.79393,   0.79654,   0.79919,   0.80188,   0.80461,
   0.80739,   0.81020,   0.81306,   0.81596,   0.81891,   0.82191,   0.82497,
   0.82808,   0.83125,   0.83448,   0.83778,   0.84115,   0.84459,   0.84811,
   0.85170,   0.85538,   0.85914,   0.86299,   0.86693,   0.87095,   0.87507,
   0.87927,   0.88355,   0.88792,   0.89236,   0.89687,   0.90145,   0.90608,
   0.91075,   0.91545,   0.92017,   0.92489,   0.92960,   0.93427,   0.93890,
   0.94346,   0.94794,   0.95233,   0.95661,   0.96078,   0.96484,   0.96877,
   0.97257,   0.97626,   0.97982,   0.98324,   0.98651,   0.98960,   0.99244,
   0.99495,   0.99706,   0.99866,   0.99966,   1.00000},
   //---------  1.00 GeV
  {0.00064,   0.00248,   0.00552,   0.00970,   0.01498,   0.02132,   0.02865,
   0.03694,   0.04614,   0.05619,   0.06706,   0.07870,   0.09105,   0.10406,
   0.11768,   0.13184,   0.14650,   0.16159,   0.17704,   0.19281,   0.20883,
   0.22505,   0.24140,   0.25784,   0.27431,   0.29076,   0.30714,   0.32342,
   0.33955,   0.35548,   0.37119,   0.38664,   0.40181,   0.41666,   0.43117,
   0.44532,   0.45910,   0.47248,   0.48546,   0.49803,   0.51018,   0.52191,
   0.53321,   0.54408,   0.55453,   0.56457,   0.57418,   0.58339,   0.59220,
   0.60062,   0.60867,   0.61634,   0.62365,   0.63062,   0.63725,   0.64356,
   0.64957,   0.65527,   0.66069,   0.66583,   0.67071,   0.67534,   0.67973,
   0.68389,   0.68784,   0.69158,   0.69512,   0.69848,   0.70167,   0.70468,
   0.70755,   0.71027,   0.71285,   0.71530,   0.71764,   0.71987,   0.72201,
   0.72405,   0.72601,   0.72789,   0.72971,   0.73147,   0.73319,   0.73485,
   0.73649,   0.73809,   0.73967,   0.74123,   0.74278,   0.74432,   0.74586,
   0.74740,   0.74894,   0.75050,   0.75206,   0.75365,   0.75525,   0.75687,
   0.75852,   0.76020,   0.76190,   0.76363,   0.76539,   0.76719,   0.76902,
   0.77088,   0.77278,   0.77472,   0.77669,   0.77871,   0.78076,   0.78284,
   0.78497,   0.78713,   0.78932,   0.79156,   0.79382,   0.79613,   0.79846,
   0.80083,   0.80322,   0.80565,   0.80811,   0.81060,   0.81311,   0.81566,
   0.81824,   0.82085,   0.82349,   0.82617,   0.82889,   0.83164,   0.83444,
   0.83728,   0.84017,   0.84311,   0.84611,   0.84916,   0.85228,   0.85547,
   0.85872,   0.86205,   0.86546,   0.86895,   0.87252,   0.87618,   0.87992,
   0.88376,   0.88768,   0.89169,   0.89578,   0.89995,   0.90420,   0.90852,
   0.91289,   0.91732,   0.92179,   0.92627,   0.93077,   0.93526,   0.93973,
   0.94415,   0.94851,   0.95279,   0.95699,   0.96108,   0.96506,   0.96892,
   0.97267,   0.97630,   0.97980,   0.98319,   0.98642,   0.98949,   0.99233,
   0.99486,   0.99700,   0.99863,   0.99965,   1.00000},
   //---------  1.10 GeV
  {0.00072,   0.00280,   0.00623,   0.01096,   0.01693,   0.02409,   0.03237,
   0.04173,   0.05210,   0.06342,   0.07565,   0.08870,   0.10253,   0.11705,
   0.13220,   0.14790,   0.16408,   0.18067,   0.19759,   0.21477,   0.23214,
   0.24964,   0.26719,   0.28474,   0.30223,   0.31961,   0.33682,   0.35382,
   0.37056,   0.38702,   0.40315,   0.41893,   0.43433,   0.44933,   0.46390,
   0.47804,   0.49173,   0.50497,   0.51774,   0.53005,   0.54190,   0.55328,
   0.56421,   0.57468,   0.58471,   0.59431,   0.60348,   0.61224,   0.62059,
   0.62856,   0.63616,   0.64339,   0.65028,   0.65683,   0.66306,   0.66897,
   0.67460,   0.67993,   0.68499,   0.68979,   0.69434,   0.69865,   0.70273,
   0.70659,   0.71025,   0.71370,   0.71696,   0.72004,   0.72295,   0.72570,
   0.72830,   0.73076,   0.73309,   0.73529,   0.73738,   0.73937,   0.74127,
   0.74308,   0.74481,   0.74648,   0.74809,   0.74964,   0.75116,   0.75264,
   0.75410,   0.75554,   0.75696,   0.75837,   0.75978,   0.76120,   0.76262,
   0.76405,   0.76550,   0.76697,   0.76845,   0.76996,   0.77150,   0.77306,
   0.77465,   0.77627,   0.77792,   0.77961,   0.78133,   0.78308,   0.78487,
   0.78669,   0.78855,   0.79045,   0.79238,   0.79435,   0.79636,   0.79840,
   0.80047,   0.80258,   0.80472,   0.80690,   0.80910,   0.81133,   0.81358,
   0.81586,   0.81816,   0.82049,   0.82283,   0.82519,   0.82757,   0.82997,
   0.83238,   0.83482,   0.83727,   0.83974,   0.84224,   0.84476,   0.84730,
   0.84988,   0.85249,   0.85514,   0.85782,   0.86056,   0.86334,   0.86617,
   0.86906,   0.87201,   0.87502,   0.87811,   0.88127,   0.88450,   0.88782,
   0.89121,   0.89469,   0.89826,   0.90191,   0.90565,   0.90947,   0.91337,
   0.91734,   0.92138,   0.92547,   0.92961,   0.93377,   0.93795,   0.94213,
   0.94628,   0.95040,   0.95446,   0.95845,   0.96235,   0.96616,   0.96986,
   0.97345,   0.97693,   0.98029,   0.98355,   0.98667,   0.98964,   0.99241,
   0.99489,   0.99700,   0.99862,   0.99965,   1.00000},
   //---------  1.20 GeV
  {0.00080,   0.00312,   0.00693,   0.01219,   0.01884,   0.02680,   0.03601,
   0.04640,   0.05791,   0.07047,   0.08400,   0.09841,   0.11364,   0.12959,
   0.14617,   0.16331,   0.18089,   0.19885,   0.21709,   0.23553,   0.25408,
   0.27268,   0.29125,   0.30973,   0.32804,   0.34614,   0.36398,   0.38151,
   0.39868,   0.41547,   0.43184,   0.44777,   0.46324,   0.47822,   0.49272,
   0.50672,   0.52021,   0.53319,   0.54567,   0.55765,   0.56914,   0.58014,
   0.59067,   0.60074,   0.61035,   0.61953,   0.62829,   0.63665,   0.64461,
   0.65220,   0.65943,   0.66631,   0.67286,   0.67909,   0.68501,   0.69065,
   0.69600,   0.70108,   0.70589,   0.71046,   0.71479,   0.71889,   0.72276,
   0.72642,   0.72988,   0.73314,   0.73621,   0.73910,   0.74183,   0.74439,
   0.74681,   0.74908,   0.75123,   0.75325,   0.75516,   0.75697,   0.75869,
   0.76033,   0.76190,   0.76341,   0.76486,   0.76628,   0.76766,   0.76902,
   0.77036,   0.77169,   0.77301,   0.77434,   0.77568,   0.77704,   0.77841,
   0.77980,   0.78121,   0.78266,   0.78413,   0.78563,   0.78717,   0.78873,
   0.79034,   0.79197,   0.79364,   0.79535,   0.79710,   0.79888,   0.80069,
   0.80255,   0.80444,   0.80636,   0.80833,   0.81033,   0.81236,   0.81443,
   0.81653,   0.81866,   0.82082,   0.82301,   0.82522,   0.82746,   0.82971,
   0.83198,   0.83427,   0.83656,   0.83887,   0.84118,   0.84350,   0.84582,
   0.84815,   0.85047,   0.85280,   0.85514,   0.85747,   0.85982,   0.86217,
   0.86453,   0.86690,   0.86929,   0.87171,   0.87414,   0.87661,   0.87910,
   0.88163,   0.88421,   0.88683,   0.88950,   0.89223,   0.89502,   0.89788,
   0.90080,   0.90380,   0.90688,   0.91003,   0.91328,   0.91660,   0.92001,
   0.92349,   0.92705,   0.93068,   0.93437,   0.93811,   0.94189,   0.94568,
   0.94948,   0.95326,   0.95701,   0.96071,   0.96434,   0.96789,   0.97135,
   0.97472,   0.97798,   0.98115,   0.98421,   0.98717,   0.98999,   0.99263,
   0.99502,   0.99707,   0.99865,   0.99965,   1.00000},
   //---------  1.3 GeV
  {0.00044,   0.00170,   0.00506,   0.01004,   0.01659,   0.02465,   0.03416,
   0.04506,   0.05727,   0.07071,   0.08529,   0.10091,   0.11749,   0.13490,
   0.15303,   0.17179,   0.19105,   0.21070,   0.23062,   0.25072,   0.27089,
   0.29104,   0.31108,   0.33093,   0.35050,   0.36974,   0.38858,   0.40696,
   0.42485,   0.44221,   0.45900,   0.47520,   0.49079,   0.50576,   0.52012,
   0.53384,   0.54695,   0.55944,   0.57133,   0.58264,   0.59338,   0.60357,
   0.61323,   0.62239,   0.63107,   0.63930,   0.64709,   0.65448,   0.66148,
   0.66812,   0.67441,   0.68038,   0.68605,   0.69143,   0.69654,   0.70138,
   0.70599,   0.71035,   0.71450,   0.71843,   0.72215,   0.72567,   0.72900,
   0.73214,   0.73511,   0.73790,   0.74052,   0.74298,   0.74529,   0.74744,
   0.74945,   0.75133,   0.75308,   0.75470,   0.75622,   0.75763,   0.75895,
   0.76018,   0.76133,   0.76242,   0.76344,   0.76442,   0.76536,   0.76628,
   0.76717,   0.76805,   0.76893,   0.76981,   0.77071,   0.77164,   0.77259,
   0.77358,   0.77461,   0.77569,   0.77682,   0.77801,   0.77927,   0.78059,
   0.78198,   0.78344,   0.78497,   0.78658,   0.78826,   0.79002,   0.79185,
   0.79376,   0.79574,   0.79778,   0.79990,   0.80207,   0.80431,   0.80660,
   0.80894,   0.81133,   0.81376,   0.81623,   0.81872,   0.82125,   0.82379,
   0.82635,   0.82893,   0.83151,   0.83409,   0.83668,   0.83927,   0.84185,
   0.84443,   0.84701,   0.84958,   0.85215,   0.85471,   0.85727,   0.85982,
   0.86238,   0.86494,   0.86750,   0.87007,   0.87264,   0.87523,   0.87783,
   0.88044,   0.88308,   0.88573,   0.88841,   0.89113,   0.89388,   0.89667,
   0.89951,   0.90239,   0.90534,   0.90836,   0.91144,   0.91460,   0.91784,
   0.92115,   0.92455,   0.92803,   0.93158,   0.93520,   0.93889,   0.94262,
   0.94638,   0.95016,   0.95394,   0.95769,   0.96141,   0.96508,   0.96867,
   0.97219,   0.97561,   0.97894,   0.98217,   0.98529,   0.98828,   0.99112,
   0.99373,   0.99605,   0.99794,   0.99929,   1.00000},
   //---------  1.4 GeV
  {0.00047,   0.00183,   0.00543,   0.01078,   0.01782,   0.02649,   0.03671,
   0.04843,   0.06154,   0.07596,   0.09158,   0.10830,   0.12599,   0.14453,
   0.16381,   0.18368,   0.20401,   0.22469,   0.24558,   0.26658,   0.28758,
   0.30846,   0.32913,   0.34951,   0.36951,   0.38907,   0.40813,   0.42664,
   0.44456,   0.46184,   0.47847,   0.49443,   0.50971,   0.52431,   0.53821,
   0.55145,   0.56402,   0.57594,   0.58723,   0.59792,   0.60803,   0.61758,
   0.62661,   0.63515,   0.64321,   0.65084,   0.65805,   0.66488,   0.67135,
   0.67748,   0.68330,   0.68883,   0.69408,   0.69908,   0.70383,   0.70835,
   0.71265,   0.71674,   0.72063,   0.72433,   0.72784,   0.73117,   0.73432,
   0.73729,   0.74010,   0.74274,   0.74522,   0.74754,   0.74971,   0.75173,
   0.75361,   0.75535,   0.75697,   0.75846,   0.75985,   0.76112,   0.76230,
   0.76340,   0.76441,   0.76536,   0.76625,   0.76710,   0.76791,   0.76869,
   0.76946,   0.77022,   0.77098,   0.77175,   0.77255,   0.77338,   0.77424,
   0.77515,   0.77612,   0.77714,   0.77823,   0.77939,   0.78062,   0.78193,
   0.78333,   0.78481,   0.78637,   0.78803,   0.78977,   0.79160,   0.79352,
   0.79553,   0.79762,   0.79980,   0.80205,   0.80439,   0.80679,   0.80925,
   0.81178,   0.81437,   0.81700,   0.81967,   0.82238,   0.82512,   0.82788,
   0.83066,   0.83345,   0.83625,   0.83905,   0.84184,   0.84463,   0.84740,
   0.85016,   0.85291,   0.85564,   0.85835,   0.86105,   0.86373,   0.86639,
   0.86903,   0.87166,   0.87427,   0.87687,   0.87945,   0.88203,   0.88459,
   0.88715,   0.88970,   0.89224,   0.89480,   0.89735,   0.89992,   0.90250,
   0.90511,   0.90775,   0.91043,   0.91316,   0.91594,   0.91878,   0.92170,
   0.92469,   0.92776,   0.93092,   0.93416,   0.93747,   0.94087,   0.94432,
   0.94784,   0.95139,   0.95496,   0.95854,   0.96211,   0.96564,   0.96912,
   0.97254,   0.97588,   0.97914,   0.98231,   0.98538,   0.98833,   0.99113,
   0.99373,   0.99603,   0.99793,   0.99929,   1.00000},
   //---------  1.5 GeV
  {0.00049,   0.00194,   0.00576,   0.01143,   0.01890,   0.02810,   0.03895,
   0.05136,   0.06525,   0.08051,   0.09702,   0.11466,   0.13329,   0.15278,
   0.17297,   0.19374,   0.21493,   0.23642,   0.25807,   0.27974,   0.30132,
   0.32270,   0.34379,   0.36448,   0.38471,   0.40440,   0.42350,   0.44196,
   0.45974,   0.47682,   0.49316,   0.50877,   0.52364,   0.53776,   0.55116,
   0.56384,   0.57583,   0.58715,   0.59782,   0.60788,   0.61736,   0.62629,
   0.63471,   0.64264,   0.65013,   0.65719,   0.66387,   0.67019,   0.67618,
   0.68187,   0.68727,   0.69240,   0.69730,   0.70196,   0.70641,   0.71066,
   0.71472,   0.71859,   0.72228,   0.72580,   0.72915,   0.73233,   0.73534,
   0.73820,   0.74090,   0.74344,   0.74583,   0.74806,   0.75015,   0.75209,
   0.75390,   0.75557,   0.75711,   0.75853,   0.75984,   0.76105,   0.76215,
   0.76318,   0.76412,   0.76500,   0.76582,   0.76660,   0.76734,   0.76806,
   0.76877,   0.76947,   0.77018,   0.77091,   0.77167,   0.77247,   0.77331,
   0.77420,   0.77516,   0.77618,   0.77728,   0.77845,   0.77972,   0.78107,
   0.78251,   0.78405,   0.78569,   0.78743,   0.78927,   0.79121,   0.79325,
   0.79539,   0.79763,   0.79996,   0.80238,   0.80489,   0.80747,   0.81014,
   0.81287,   0.81567,   0.81852,   0.82142,   0.82435,   0.82732,   0.83032,
   0.83333,   0.83635,   0.83937,   0.84239,   0.84540,   0.84839,   0.85136,
   0.85431,   0.85724,   0.86014,   0.86300,   0.86584,   0.86864,   0.87141,
   0.87414,   0.87684,   0.87951,   0.88215,   0.88475,   0.88732,   0.88986,
   0.89237,   0.89485,   0.89731,   0.89974,   0.90216,   0.90457,   0.90697,
   0.90938,   0.91180,   0.91424,   0.91671,   0.91923,   0.92180,   0.92443,
   0.92714,   0.92993,   0.93281,   0.93578,   0.93885,   0.94200,   0.94524,
   0.94855,   0.95193,   0.95535,   0.95880,   0.96226,   0.96571,   0.96913,
   0.97250,   0.97582,   0.97906,   0.98222,   0.98528,   0.98824,   0.99105,
   0.99366,   0.99598,   0.99790,   0.99928,   1.00000},
   //---------  1.6 GeV
  {0.00052,   0.00203,   0.00605,   0.01201,   0.01986,   0.02952,   0.04091,
   0.05394,   0.06851,   0.08449,   0.10176,   0.12018,   0.13960,   0.15987,
   0.18083,   0.20233,   0.22421,   0.24632,   0.26852,   0.29069,   0.31269,
   0.33440,   0.35574,   0.37661,   0.39692,   0.41662,   0.43563,   0.45393,
   0.47148,   0.48825,   0.50423,   0.51942,   0.53381,   0.54743,   0.56029,
   0.57240,   0.58380,   0.59452,   0.60458,   0.61404,   0.62291,   0.63125,
   0.63908,   0.64645,   0.65339,   0.65993,   0.66612,   0.67198,   0.67753,
   0.68281,   0.68783,   0.69262,   0.69720,   0.70157,   0.70576,   0.70977,
   0.71361,   0.71729,   0.72081,   0.72417,   0.72739,   0.73045,   0.73336,
   0.73612,   0.73874,   0.74121,   0.74353,   0.74571,   0.74774,   0.74964,
   0.75140,   0.75303,   0.75454,   0.75592,   0.75720,   0.75837,   0.75945,
   0.76045,   0.76136,   0.76222,   0.76302,   0.76378,   0.76451,   0.76522,
   0.76592,   0.76662,   0.76734,   0.76807,   0.76885,   0.76966,   0.77052,
   0.77145,   0.77244,   0.77351,   0.77466,   0.77590,   0.77723,   0.77865,
   0.78018,   0.78181,   0.78355,   0.78540,   0.78736,   0.78943,   0.79161,
   0.79390,   0.79629,   0.79879,   0.80138,   0.80407,   0.80685,   0.80972,
   0.81266,   0.81566,   0.81873,   0.82185,   0.82501,   0.82820,   0.83142,
   0.83465,   0.83789,   0.84113,   0.84435,   0.84756,   0.85075,   0.85391,
   0.85704,   0.86012,   0.86317,   0.86618,   0.86914,   0.87205,   0.87491,
   0.87773,   0.88049,   0.88320,   0.88587,   0.88848,   0.89104,   0.89355,
   0.89601,   0.89843,   0.90080,   0.90313,   0.90543,   0.90769,   0.90993,
   0.91216,   0.91439,   0.91663,   0.91888,   0.92118,   0.92352,   0.92592,
   0.92839,   0.93095,   0.93361,   0.93637,   0.93924,   0.94221,   0.94529,
   0.94846,   0.95172,   0.95505,   0.95843,   0.96184,   0.96527,   0.96868,
   0.97207,   0.97541,   0.97868,   0.98188,   0.98500,   0.98800,   0.99086,
   0.99352,   0.99589,   0.99784,   0.99926,   1.00000},
   //---------  1.7 GeV
  {0.00054,   0.00212,   0.00631,   0.01254,   0.02072,   0.03080,   0.04268,
   0.05626,   0.07142,   0.08804,   0.10598,   0.12508,   0.14517,   0.16611,
   0.18771,   0.20981,   0.23225,   0.25488,   0.27753,   0.30007,   0.32237,
   0.34432,   0.36580,   0.38673,   0.40703,   0.42664,   0.44549,   0.46356,
   0.48082,   0.49724,   0.51282,   0.52756,   0.54147,   0.55456,   0.56687,
   0.57842,   0.58925,   0.59938,   0.60886,   0.61773,   0.62604,   0.63381,
   0.64110,   0.64795,   0.65439,   0.66045,   0.66619,   0.67161,   0.67677,
   0.68167,   0.68635,   0.69082,   0.69510,   0.69920,   0.70315,   0.70694,
   0.71058,   0.71408,   0.71744,   0.72066,   0.72375,   0.72670,   0.72951,
   0.73219,   0.73473,   0.73714,   0.73940,   0.74153,   0.74353,   0.74539,
   0.74712,   0.74873,   0.75021,   0.75159,   0.75285,   0.75402,   0.75509,
   0.75609,   0.75701,   0.75788,   0.75870,   0.75947,   0.76022,   0.76096,
   0.76169,   0.76243,   0.76319,   0.76397,   0.76479,   0.76566,   0.76659,
   0.76758,   0.76865,   0.76979,   0.77102,   0.77235,   0.77377,   0.77530,
   0.77693,   0.77867,   0.78053,   0.78250,   0.78459,   0.78679,   0.78911,
   0.79155,   0.79410,   0.79676,   0.79952,   0.80239,   0.80535,   0.80840,
   0.81153,   0.81473,   0.81800,   0.82132,   0.82468,   0.82808,   0.83149,
   0.83493,   0.83836,   0.84179,   0.84520,   0.84859,   0.85194,   0.85526,
   0.85854,   0.86177,   0.86494,   0.86806,   0.87112,   0.87412,   0.87706,
   0.87994,   0.88275,   0.88549,   0.88817,   0.89078,   0.89333,   0.89580,
   0.89822,   0.90057,   0.90286,   0.90509,   0.90728,   0.90941,   0.91152,
   0.91359,   0.91566,   0.91772,   0.91980,   0.92190,   0.92406,   0.92627,
   0.92856,   0.93095,   0.93344,   0.93604,   0.93877,   0.94161,   0.94459,
   0.94768,   0.95088,   0.95417,   0.95754,   0.96096,   0.96441,   0.96787,
   0.97132,   0.97473,   0.97809,   0.98137,   0.98456,   0.98765,   0.99059,
   0.99332,   0.99576,   0.99777,   0.99923,   1.00000},
   //---------  1.8 GeV
  {0.00056,   0.00220,   0.00656,   0.01302,   0.02152,   0.03198,   0.04430,
   0.05838,   0.07409,   0.09129,   0.10983,   0.12954,   0.15025,   0.17178,
   0.19395,   0.21658,   0.23950,   0.26255,   0.28557,   0.30841,   0.33095,
   0.35306,   0.37463,   0.39557,   0.41581,   0.43528,   0.45394,   0.47175,
   0.48869,   0.50474,   0.51991,   0.53420,   0.54762,   0.56021,   0.57199,
   0.58299,   0.59326,   0.60284,   0.61177,   0.62009,   0.62786,   0.63511,
   0.64190,   0.64825,   0.65422,   0.65984,   0.66515,   0.67018,   0.67496,
   0.67951,   0.68386,   0.68803,   0.69203,   0.69588,   0.69958,   0.70316,
   0.70660,   0.70992,   0.71312,   0.71620,   0.71916,   0.72199,   0.72470,
   0.72729,   0.72976,   0.73209,   0.73430,   0.73638,   0.73834,   0.74017,
   0.74188,   0.74347,   0.74494,   0.74631,   0.74758,   0.74876,   0.74985,
   0.75087,   0.75182,   0.75272,   0.75357,   0.75439,   0.75519,   0.75598,
   0.75677,   0.75758,   0.75840,   0.75926,   0.76016,   0.76112,   0.76213,
   0.76321,   0.76437,   0.76561,   0.76694,   0.76837,   0.76990,   0.77153,
   0.77328,   0.77514,   0.77711,   0.77920,   0.78142,   0.78375,   0.78620,
   0.78878,   0.79147,   0.79427,   0.79719,   0.80021,   0.80333,   0.80654,
   0.80984,   0.81321,   0.81664,   0.82013,   0.82367,   0.82723,   0.83082,
   0.83442,   0.83802,   0.84160,   0.84517,   0.84870,   0.85219,   0.85564,
   0.85904,   0.86238,   0.86566,   0.86886,   0.87200,   0.87507,   0.87806,
   0.88098,   0.88382,   0.88658,   0.88926,   0.89187,   0.89439,   0.89683,
   0.89920,   0.90149,   0.90370,   0.90585,   0.90793,   0.90996,   0.91195,
   0.91390,   0.91582,   0.91775,   0.91968,   0.92164,   0.92365,   0.92572,
   0.92787,   0.93013,   0.93250,   0.93499,   0.93763,   0.94041,   0.94333,
   0.94638,   0.94957,   0.95287,   0.95627,   0.95974,   0.96326,   0.96681,
   0.97035,   0.97387,   0.97734,   0.98073,   0.98404,   0.98723,   0.99027,
   0.99309,   0.99561,   0.99770,   0.99920,   1.00000},
   //---------  1.9 GeV
  {0.00058,   0.00228,   0.00679,   0.01347,   0.02227,   0.03309,   0.04583,
   0.06038,   0.07659,   0.09433,   0.11343,   0.13370,   0.15496,   0.17703,
   0.19971,   0.22282,   0.24617,   0.26960,   0.29294,   0.31604,   0.33877,
   0.36099,   0.38262,   0.40355,   0.42370,   0.44303,   0.46148,   0.47903,
   0.49565,   0.51134,   0.52610,   0.53995,   0.55292,   0.56502,   0.57629,
   0.58679,   0.59654,   0.60559,   0.61400,   0.62181,   0.62908,   0.63584,
   0.64215,   0.64805,   0.65358,   0.65879,   0.66370,   0.66835,   0.67277,
   0.67699,   0.68103,   0.68490,   0.68863,   0.69223,   0.69570,   0.69905,
   0.70230,   0.70544,   0.70847,   0.71140,   0.71422,   0.71693,   0.71954,
   0.72203,   0.72441,   0.72667,   0.72882,   0.73085,   0.73277,   0.73456,
   0.73625,   0.73783,   0.73930,   0.74068,   0.74196,   0.74316,   0.74428,
   0.74533,   0.74633,   0.74728,   0.74819,   0.74907,   0.74994,   0.75081,
   0.75168,   0.75257,   0.75349,   0.75444,   0.75544,   0.75649,   0.75760,
   0.75879,   0.76005,   0.76140,   0.76284,   0.76438,   0.76601,   0.76776,
   0.76961,   0.77158,   0.77366,   0.77586,   0.77819,   0.78063,   0.78320,
   0.78589,   0.78869,   0.79162,   0.79466,   0.79780,   0.80105,   0.80439,
   0.80781,   0.81131,   0.81488,   0.81850,   0.82217,   0.82587,   0.82959,
   0.83332,   0.83704,   0.84075,   0.84443,   0.84807,   0.85167,   0.85522,
   0.85871,   0.86213,   0.86548,   0.86875,   0.87195,   0.87506,   0.87809,
   0.88103,   0.88389,   0.88666,   0.88933,   0.89192,   0.89442,   0.89683,
   0.89915,   0.90138,   0.90353,   0.90561,   0.90761,   0.90955,   0.91143,
   0.91328,   0.91510,   0.91691,   0.91873,   0.92058,   0.92248,   0.92445,
   0.92651,   0.92868,   0.93097,   0.93341,   0.93599,   0.93874,   0.94165,
   0.94472,   0.94793,   0.95128,   0.95474,   0.95830,   0.96192,   0.96558,
   0.96925,   0.97290,   0.97650,   0.98003,   0.98346,   0.98677,   0.98992,
   0.99284,   0.99545,   0.99761,   0.99917,   1.00000},
   //---------  2.0 GeV
  {0.00060,   0.00235,   0.00701,   0.01391,   0.02299,   0.03416,   0.04730,
   0.06230,   0.07900,   0.09725,   0.11687,   0.13768,   0.15947,   0.18206,
   0.20522,   0.22877,   0.25253,   0.27630,   0.29993,   0.32327,   0.34617,
   0.36850,   0.39016,   0.41107,   0.43114,   0.45031,   0.46856,   0.48584,
   0.50216,   0.51750,   0.53188,   0.54532,   0.55784,   0.56948,   0.58028,
   0.59029,   0.59955,   0.60812,   0.61604,   0.62338,   0.63017,   0.63648,
   0.64234,   0.64781,   0.65294,   0.65775,   0.66228,   0.66658,   0.67066,
   0.67456,   0.67830,   0.68189,   0.68535,   0.68870,   0.69194,   0.69508,
   0.69812,   0.70107,   0.70394,   0.70671,   0.70939,   0.71197,   0.71446,
   0.71685,   0.71914,   0.72133,   0.72341,   0.72539,   0.72726,   0.72903,
   0.73070,   0.73226,   0.73374,   0.73513,   0.73643,   0.73766,   0.73882,
   0.73993,   0.74098,   0.74199,   0.74298,   0.74395,   0.74490,   0.74586,
   0.74683,   0.74782,   0.74884,   0.74990,   0.75100,   0.75217,   0.75339,
   0.75469,   0.75606,   0.75752,   0.75906,   0.76070,   0.76244,   0.76428,
   0.76623,   0.76829,   0.77046,   0.77276,   0.77517,   0.77770,   0.78035,
   0.78312,   0.78601,   0.78902,   0.79214,   0.79537,   0.79871,   0.80214,
   0.80565,   0.80924,   0.81290,   0.81662,   0.82038,   0.82417,   0.82798,
   0.83180,   0.83561,   0.83940,   0.84316,   0.84689,   0.85056,   0.85418,
   0.85773,   0.86121,   0.86461,   0.86792,   0.87115,   0.87429,   0.87734,
   0.88030,   0.88316,   0.88592,   0.88859,   0.89116,   0.89363,   0.89601,
   0.89829,   0.90047,   0.90257,   0.90458,   0.90652,   0.90839,   0.91020,
   0.91196,   0.91370,   0.91543,   0.91717,   0.91894,   0.92076,   0.92266,
   0.92466,   0.92677,   0.92903,   0.93144,   0.93401,   0.93677,   0.93970,
   0.94280,   0.94607,   0.94950,   0.95306,   0.95672,   0.96047,   0.96426,
   0.96807,   0.97186,   0.97561,   0.97928,   0.98285,   0.98629,   0.98956,
   0.99259,   0.99529,   0.99752,   0.99914,   1.00000},
   //---------  2.2 GeV
  {0.00063,   0.00250,   0.00744,   0.01476,   0.02440,   0.03623,   0.05015,
   0.06601,   0.08365,   0.10288,   0.12351,   0.14533,   0.16812,   0.19166,
   0.21574,   0.24014,   0.26465,   0.28908,   0.31326,   0.33703,   0.36024,
   0.38276,   0.40448,   0.42533,   0.44523,   0.46412,   0.48198,   0.49879,
   0.51454,   0.52924,   0.54292,   0.55560,   0.56731,   0.57812,   0.58806,
   0.59719,   0.60557,   0.61326,   0.62031,   0.62678,   0.63274,   0.63822,
   0.64329,   0.64799,   0.65236,   0.65646,   0.66031,   0.66395,   0.66740,
   0.67070,   0.67387,   0.67692,   0.67988,   0.68274,   0.68553,   0.68824,
   0.69089,   0.69347,   0.69599,   0.69844,   0.70083,   0.70315,   0.70540,
   0.70758,   0.70969,   0.71172,   0.71367,   0.71555,   0.71734,   0.71906,
   0.72070,   0.72227,   0.72377,   0.72520,   0.72658,   0.72790,   0.72917,
   0.73041,   0.73161,   0.73279,   0.73395,   0.73511,   0.73628,   0.73745,
   0.73864,   0.73986,   0.74111,   0.74240,   0.74373,   0.74512,   0.74657,
   0.74808,   0.74966,   0.75131,   0.75304,   0.75485,   0.75675,   0.75874,
   0.76082,   0.76300,   0.76528,   0.76767,   0.77017,   0.77278,   0.77551,
   0.77835,   0.78130,   0.78437,   0.78755,   0.79084,   0.79423,   0.79772,
   0.80129,   0.80495,   0.80868,   0.81247,   0.81631,   0.82017,   0.82406,
   0.82796,   0.83185,   0.83573,   0.83957,   0.84337,   0.84711,   0.85079,
   0.85440,   0.85793,   0.86138,   0.86473,   0.86799,   0.87115,   0.87421,
   0.87717,   0.88002,   0.88276,   0.88540,   0.88793,   0.89036,   0.89268,
   0.89489,   0.89700,   0.89902,   0.90094,   0.90278,   0.90455,   0.90626,
   0.90792,   0.90955,   0.91118,   0.91283,   0.91451,   0.91626,   0.91810,
   0.92005,   0.92215,   0.92440,   0.92684,   0.92947,   0.93230,   0.93535,
   0.93860,   0.94205,   0.94569,   0.94948,   0.95341,   0.95744,   0.96153,
   0.96565,   0.96976,   0.97382,   0.97779,   0.98165,   0.98535,   0.98885,
   0.99209,   0.99497,   0.99736,   0.99909,   1.00000},
   //---------  2.4 GeV
  {0.00067,   0.00264,   0.00785,   0.01558,   0.02574,   0.03821,   0.05286,
   0.06954,   0.08806,   0.10823,   0.12981,   0.15259,   0.17632,   0.20077,
   0.22570,   0.25088,   0.27610,   0.30116,   0.32586,   0.35003,   0.37354,
   0.39624,   0.41803,   0.43884,   0.45859,   0.47724,   0.49476,   0.51114,
   0.52639,   0.54053,   0.55358,   0.56559,   0.57660,   0.58667,   0.59586,
   0.60423,   0.61184,   0.61876,   0.62505,   0.63077,   0.63599,   0.64076,
   0.64513,   0.64915,   0.65287,   0.65634,   0.65958,   0.66264,   0.66554,
   0.66830,   0.67096,   0.67352,   0.67601,   0.67843,   0.68079,   0.68311,
   0.68538,   0.68761,   0.68980,   0.69195,   0.69406,   0.69613,   0.69815,
   0.70014,   0.70207,   0.70396,   0.70579,   0.70758,   0.70931,   0.71100,
   0.71263,   0.71422,   0.71576,   0.71727,   0.71874,   0.72017,   0.72158,
   0.72298,   0.72436,   0.72573,   0.72710,   0.72848,   0.72986,   0.73127,
   0.73269,   0.73415,   0.73563,   0.73715,   0.73871,   0.74031,   0.74195,
   0.74365,   0.74539,   0.74720,   0.74905,   0.75098,   0.75296,   0.75502,
   0.75715,   0.75936,   0.76166,   0.76404,   0.76652,   0.76910,   0.77178,
   0.77457,   0.77746,   0.78047,   0.78359,   0.78681,   0.79014,   0.79357,
   0.79710,   0.80071,   0.80441,   0.80816,   0.81198,   0.81583,   0.81972,
   0.82361,   0.82751,   0.83139,   0.83525,   0.83907,   0.84283,   0.84653,
   0.85016,   0.85371,   0.85717,   0.86054,   0.86381,   0.86698,   0.87004,
   0.87299,   0.87584,   0.87857,   0.88118,   0.88369,   0.88608,   0.88836,
   0.89053,   0.89259,   0.89455,   0.89642,   0.89820,   0.89991,   0.90156,
   0.90317,   0.90475,   0.90634,   0.90794,   0.90960,   0.91133,   0.91317,
   0.91514,   0.91728,   0.91959,   0.92211,   0.92485,   0.92782,   0.93103,
   0.93446,   0.93813,   0.94200,   0.94605,   0.95026,   0.95458,   0.95898,
   0.96341,   0.96783,   0.97218,   0.97645,   0.98057,   0.98451,   0.98823,
   0.99166,   0.99470,   0.99721,   0.99904,   1.00000},
   //---------  2.6 GeV
  {0.00070,   0.00277,   0.00824,   0.01635,   0.02700,   0.04007,   0.05542,
   0.07286,   0.09220,   0.11323,   0.13570,   0.15936,   0.18397,   0.20926,
   0.23498,   0.26089,   0.28675,   0.31237,   0.33754,   0.36209,   0.38586,
   0.40874,   0.43061,   0.45138,   0.47101,   0.48944,   0.50666,   0.52267,
   0.53748,   0.55112,   0.56362,   0.57504,   0.58544,   0.59487,   0.60341,
   0.61111,   0.61806,   0.62431,   0.62995,   0.63503,   0.63962,   0.64377,
   0.64755,   0.65100,   0.65416,   0.65709,   0.65981,   0.66237,   0.66479,
   0.66709,   0.66930,   0.67143,   0.67351,   0.67554,   0.67754,   0.67950,
   0.68144,   0.68336,   0.68526,   0.68715,   0.68902,   0.69087,   0.69270,
   0.69451,   0.69630,   0.69807,   0.69982,   0.70154,   0.70323,   0.70491,
   0.70655,   0.70818,   0.70979,   0.71138,   0.71296,   0.71453,   0.71609,
   0.71765,   0.71921,   0.72078,   0.72236,   0.72395,   0.72556,   0.72719,
   0.72884,   0.73051,   0.73221,   0.73393,   0.73568,   0.73746,   0.73927,
   0.74110,   0.74297,   0.74487,   0.74680,   0.74877,   0.75079,   0.75285,
   0.75496,   0.75712,   0.75935,   0.76166,   0.76404,   0.76650,   0.76906,
   0.77172,   0.77447,   0.77734,   0.78032,   0.78341,   0.78661,   0.78993,
   0.79334,   0.79686,   0.80046,   0.80414,   0.80789,   0.81170,   0.81555,
   0.81942,   0.82331,   0.82719,   0.83105,   0.83488,   0.83867,   0.84239,
   0.84605,   0.84963,   0.85313,   0.85653,   0.85983,   0.86302,   0.86610,
   0.86908,   0.87193,   0.87467,   0.87729,   0.87979,   0.88217,   0.88444,
   0.88659,   0.88863,   0.89056,   0.89239,   0.89414,   0.89582,   0.89743,
   0.89900,   0.90056,   0.90212,   0.90371,   0.90536,   0.90710,   0.90896,
   0.91096,   0.91315,   0.91553,   0.91814,   0.92099,   0.92409,   0.92745,
   0.93107,   0.93492,   0.93901,   0.94329,   0.94774,   0.95231,   0.95697,
   0.96166,   0.96633,   0.97094,   0.97543,   0.97977,   0.98390,   0.98778,
   0.99135,   0.99450,   0.99711,   0.99900,   1.00000},
   //---------  2.8 GeV
  {0.00073,   0.00289,   0.00860,   0.01706,   0.02817,   0.04179,   0.05777,
   0.07591,   0.09600,   0.11781,   0.14108,   0.16554,   0.19093,   0.21697,
   0.24340,   0.26997,   0.29643,   0.32256,   0.34817,   0.37305,   0.39708,
   0.42011,   0.44204,   0.46280,   0.48233,   0.50059,   0.51757,   0.53327,
   0.54771,   0.56093,   0.57298,   0.58392,   0.59380,   0.60270,   0.61070,
   0.61785,   0.62425,   0.62997,   0.63507,   0.63962,   0.64370,   0.64735,
   0.65064,   0.65362,   0.65633,   0.65883,   0.66113,   0.66328,   0.66531,
   0.66725,   0.66910,   0.67090,   0.67266,   0.67438,   0.67609,   0.67778,
   0.67947,   0.68116,   0.68285,   0.68454,   0.68624,   0.68794,   0.68965,
   0.69136,   0.69307,   0.69478,   0.69649,   0.69820,   0.69991,   0.70161,
   0.70332,   0.70502,   0.70672,   0.70843,   0.71014,   0.71186,   0.71358,
   0.71532,   0.71707,   0.71883,   0.72061,   0.72241,   0.72423,   0.72606,
   0.72791,   0.72977,   0.73166,   0.73355,   0.73545,   0.73737,   0.73929,
   0.74122,   0.74316,   0.74511,   0.74706,   0.74903,   0.75101,   0.75301,
   0.75504,   0.75710,   0.75921,   0.76136,   0.76358,   0.76587,   0.76825,
   0.77071,   0.77327,   0.77594,   0.77872,   0.78162,   0.78463,   0.78777,
   0.79102,   0.79438,   0.79785,   0.80141,   0.80505,   0.80877,   0.81254,
   0.81636,   0.82020,   0.82405,   0.82789,   0.83172,   0.83551,   0.83925,
   0.84293,   0.84653,   0.85005,   0.85348,   0.85681,   0.86004,   0.86315,
   0.86615,   0.86903,   0.87179,   0.87442,   0.87693,   0.87932,   0.88159,
   0.88373,   0.88577,   0.88769,   0.88951,   0.89124,   0.89290,   0.89450,
   0.89606,   0.89760,   0.89916,   0.90075,   0.90240,   0.90416,   0.90604,
   0.90809,   0.91032,   0.91277,   0.91545,   0.91839,   0.92160,   0.92508,
   0.92883,   0.93283,   0.93708,   0.94153,   0.94616,   0.95091,   0.95575,
   0.96063,   0.96548,   0.97025,   0.97489,   0.97936,   0.98360,   0.98757,
   0.99121,   0.99442,   0.99707,   0.99898,   1.00000},
   //---------  3.0 GeV
  {0.00076,   0.00300,   0.00892,   0.01769,   0.02919,   0.04329,   0.05981,
   0.07854,   0.09927,   0.12174,   0.14569,   0.17082,   0.19686,   0.22353,
   0.25054,   0.27764,   0.30457,   0.33111,   0.35706,   0.38222,   0.40644,
   0.42960,   0.45158,   0.47231,   0.49173,   0.50983,   0.52659,   0.54202,
   0.55615,   0.56902,   0.58069,   0.59122,   0.60068,   0.60915,   0.61670,
   0.62342,   0.62938,   0.63466,   0.63934,   0.64349,   0.64717,   0.65044,
   0.65337,   0.65600,   0.65838,   0.66056,   0.66257,   0.66444,   0.66621,
   0.66790,   0.66953,   0.67112,   0.67268,   0.67424,   0.67579,   0.67735,
   0.67893,   0.68052,   0.68214,   0.68378,   0.68544,   0.68713,   0.68884,
   0.69058,   0.69234,   0.69412,   0.69592,   0.69773,   0.69956,   0.70141,
   0.70327,   0.70514,   0.70702,   0.70892,   0.71083,   0.71276,   0.71470,
   0.71666,   0.71863,   0.72061,   0.72262,   0.72463,   0.72666,   0.72869,
   0.73074,   0.73278,   0.73483,   0.73687,   0.73890,   0.74092,   0.74293,
   0.74492,   0.74688,   0.74883,   0.75076,   0.75267,   0.75457,   0.75646,
   0.75835,   0.76025,   0.76217,   0.76412,   0.76611,   0.76815,   0.77027,
   0.77246,   0.77475,   0.77714,   0.77964,   0.78226,   0.78500,   0.78787,
   0.79086,   0.79397,   0.79721,   0.80055,   0.80399,   0.80753,   0.81113,
   0.81479,   0.81850,   0.82224,   0.82598,   0.82972,   0.83343,   0.83711,
   0.84074,   0.84431,   0.84781,   0.85122,   0.85454,   0.85776,   0.86087,
   0.86387,   0.86676,   0.86953,   0.87218,   0.87470,   0.87711,   0.87939,
   0.88155,   0.88360,   0.88554,   0.88738,   0.88914,   0.89082,   0.89244,
   0.89403,   0.89560,   0.89719,   0.89882,   0.90052,   0.90233,   0.90426,
   0.90637,   0.90867,   0.91119,   0.91396,   0.91699,   0.92030,   0.92388,
   0.92774,   0.93186,   0.93622,   0.94079,   0.94554,   0.95041,   0.95537,
   0.96035,   0.96529,   0.97015,   0.97486,   0.97938,   0.98365,   0.98763,
   0.99126,   0.99445,   0.99708,   0.99899,   1.00000},
   //---------  3.4 GeV
  {0.00079,   0.00310,   0.00922,   0.01828,   0.03014,   0.04465,   0.06161,
   0.08081,   0.10201,   0.12494,   0.14932,   0.17485,   0.20124,   0.22819,
   0.25542,   0.28267,   0.30967,   0.33619,   0.36203,   0.38701,   0.41098,
   0.43380,   0.45539,   0.47567,   0.49459,   0.51214,   0.52831,   0.54314,
   0.55665,   0.56889,   0.57993,   0.58985,   0.59871,   0.60661,   0.61362,
   0.61982,   0.62530,   0.63014,   0.63442,   0.63820,   0.64155,   0.64454,
   0.64722,   0.64964,   0.65185,   0.65389,   0.65580,   0.65761,   0.65935,
   0.66105,   0.66273,   0.66440,   0.66609,   0.66781,   0.66957,   0.67138,
   0.67325,   0.67518,   0.67717,   0.67923,   0.68136,   0.68355,   0.68581,
   0.68813,   0.69051,   0.69294,   0.69541,   0.69793,   0.70048,   0.70307,
   0.70568,   0.70832,   0.71097,   0.71364,   0.71632,   0.71901,   0.72170,
   0.72439,   0.72708,   0.72976,   0.73243,   0.73508,   0.73771,   0.74031,
   0.74288,   0.74541,   0.74789,   0.75031,   0.75267,   0.75497,   0.75719,
   0.75933,   0.76138,   0.76336,   0.76525,   0.76706,   0.76879,   0.77045,
   0.77206,   0.77361,   0.77513,   0.77663,   0.77813,   0.77964,   0.78119,
   0.78279,   0.78446,   0.78621,   0.78806,   0.79003,   0.79213,   0.79436,
   0.79672,   0.79923,   0.80188,   0.80466,   0.80757,   0.81060,   0.81373,
   0.81697,   0.82028,   0.82365,   0.82708,   0.83053,   0.83400,   0.83747,
   0.84093,   0.84435,   0.84773,   0.85106,   0.85432,   0.85751,   0.86062,
   0.86364,   0.86656,   0.86938,   0.87210,   0.87471,   0.87721,   0.87959,
   0.88187,   0.88405,   0.88612,   0.88810,   0.88999,   0.89182,   0.89359,
   0.89532,   0.89704,   0.89877,   0.90054,   0.90237,   0.90431,   0.90637,
   0.90859,   0.91099,   0.91361,   0.91646,   0.91956,   0.92293,   0.92655,
   0.93044,   0.93456,   0.93892,   0.94346,   0.94816,   0.95296,   0.95783,
   0.96269,   0.96750,   0.97218,   0.97670,   0.98099,   0.98500,   0.98870,
   0.99204,   0.99496,   0.99735,   0.99908,   1.00000},
   //---------  3.8 GeV
  {0.00077,   0.00304,   0.00904,   0.01792,   0.02952,   0.04371,   0.06028,
   0.07902,   0.09967,   0.12198,   0.14567,   0.17043,   0.19598,   0.22204,
   0.24832,   0.27455,   0.30049,   0.32592,   0.35063,   0.37445,   0.39725,
   0.41890,   0.43933,   0.45845,   0.47625,   0.49269,   0.50780,   0.52161,
   0.53414,   0.54547,   0.55565,   0.56477,   0.57289,   0.58010,   0.58649,
   0.59213,   0.59710,   0.60149,   0.60536,   0.60879,   0.61183,   0.61455,
   0.61700,   0.61923,   0.62129,   0.62322,   0.62505,   0.62681,   0.62855,
   0.63028,   0.63203,   0.63382,   0.63567,   0.63760,   0.63961,   0.64173,
   0.64396,   0.64630,   0.64877,   0.65136,   0.65407,   0.65691,   0.65986,
   0.66293,   0.66611,   0.66939,   0.67276,   0.67621,   0.67975,   0.68334,
   0.68700,   0.69071,   0.69446,   0.69825,   0.70206,   0.70590,   0.70974,
   0.71360,   0.71744,   0.72128,   0.72510,   0.72889,   0.73264,   0.73634,
   0.73999,   0.74356,   0.74705,   0.75044,   0.75372,   0.75689,   0.75993,
   0.76284,   0.76560,   0.76821,   0.77067,   0.77299,   0.77516,   0.77719,
   0.77909,   0.78088,   0.78257,   0.78418,   0.78573,   0.78724,   0.78873,
   0.79024,   0.79178,   0.79338,   0.79506,   0.79684,   0.79873,   0.80076,
   0.80292,   0.80524,   0.80771,   0.81033,   0.81311,   0.81603,   0.81909,
   0.82228,   0.82558,   0.82897,   0.83245,   0.83599,   0.83957,   0.84318,
   0.84680,   0.85042,   0.85401,   0.85756,   0.86106,   0.86450,   0.86786,
   0.87113,   0.87430,   0.87737,   0.88032,   0.88315,   0.88585,   0.88842,
   0.89086,   0.89318,   0.89536,   0.89742,   0.89937,   0.90122,   0.90298,
   0.90467,   0.90632,   0.90795,   0.90959,   0.91126,   0.91300,   0.91484,
   0.91681,   0.91894,   0.92126,   0.92379,   0.92655,   0.92956,   0.93281,
   0.93631,   0.94004,   0.94400,   0.94814,   0.95244,   0.95685,   0.96131,
   0.96579,   0.97022,   0.97454,   0.97869,   0.98264,   0.98632,   0.98970,
   0.99274,   0.99540,   0.99757,   0.99916,   1.00000},
   //---------  4.2 GeV
  {0.00078,   0.00307,   0.00913,   0.01809,   0.02982,   0.04417,   0.06093,
   0.07989,   0.10079,   0.12334,   0.14725,   0.17223,   0.19797,   0.22417,
   0.25054,   0.27681,   0.30272,   0.32806,   0.35261,   0.37621,   0.39871,
   0.42000,   0.43999,   0.45863,   0.47589,   0.49175,   0.50624,   0.51940,
   0.53127,   0.54191,   0.55141,   0.55983,   0.56728,   0.57382,   0.57956,
   0.58458,   0.58897,   0.59280,   0.59615,   0.59910,   0.60170,   0.60402,
   0.60612,   0.60804,   0.60983,   0.61153,   0.61318,   0.61480,   0.61643,
   0.61809,   0.61981,   0.62160,   0.62348,   0.62545,   0.62754,   0.62975,
   0.63208,   0.63453,   0.63711,   0.63981,   0.64263,   0.64556,   0.64860,
   0.65173,   0.65495,   0.65825,   0.66162,   0.66506,   0.66855,   0.67209,
   0.67567,   0.67929,   0.68294,   0.68663,   0.69035,   0.69409,   0.69787,
   0.70167,   0.70550,   0.70935,   0.71322,   0.71711,   0.72101,   0.72491,
   0.72881,   0.73269,   0.73653,   0.74033,   0.74407,   0.74773,   0.75129,
   0.75476,   0.75810,   0.76130,   0.76437,   0.76728,   0.77004,   0.77265,
   0.77511,   0.77742,   0.77960,   0.78166,   0.78362,   0.78550,   0.78731,
   0.78909,   0.79086,   0.79264,   0.79445,   0.79632,   0.79827,   0.80031,
   0.80246,   0.80474,   0.80714,   0.80968,   0.81235,   0.81516,   0.81809,
   0.82114,   0.82430,   0.82755,   0.83087,   0.83426,   0.83770,   0.84116,
   0.84464,   0.84811,   0.85156,   0.85497,   0.85834,   0.86164,   0.86486,
   0.86800,   0.87104,   0.87397,   0.87679,   0.87949,   0.88207,   0.88451,
   0.88683,   0.88902,   0.89108,   0.89303,   0.89486,   0.89660,   0.89827,
   0.89987,   0.90144,   0.90299,   0.90457,   0.90620,   0.90791,   0.90974,
   0.91171,   0.91387,   0.91624,   0.91884,   0.92169,   0.92481,   0.92820,
   0.93186,   0.93578,   0.93993,   0.94430,   0.94884,   0.95352,   0.95826,
   0.96303,   0.96776,   0.97239,   0.97686,   0.98111,   0.98509,   0.98876,
   0.99206,   0.99495,   0.99734,   0.99907,   1.00000},
   //---------  4.6 GeV
  {0.00078,   0.00309,   0.00920,   0.01824,   0.03008,   0.04457,   0.06151,
   0.08066,   0.10176,   0.12452,   0.14865,   0.17384,   0.19977,   0.22615,
   0.25267,   0.27907,   0.30508,   0.33048,   0.35506,   0.37866,   0.40112,
   0.42234,   0.44222,   0.46073,   0.47784,   0.49353,   0.50784,   0.52079,
   0.53245,   0.54288,   0.55216,   0.56037,   0.56760,   0.57395,   0.57951,
   0.58435,   0.58858,   0.59227,   0.59550,   0.59835,   0.60087,   0.60314,
   0.60520,   0.60711,   0.60892,   0.61066,   0.61237,   0.61408,   0.61583,
   0.61763,   0.61950,   0.62147,   0.62355,   0.62574,   0.62806,   0.63050,
   0.63308,   0.63577,   0.63859,   0.64153,   0.64456,   0.64770,   0.65091,
   0.65419,   0.65753,   0.66092,   0.66433,   0.66778,   0.67123,   0.67470,
   0.67817,   0.68165,   0.68512,   0.68860,   0.69209,   0.69559,   0.69911,
   0.70264,   0.70621,   0.70981,   0.71344,   0.71711,   0.72081,   0.72455,
   0.72830,   0.73208,   0.73585,   0.73962,   0.74335,   0.74705,   0.75068,
   0.75423,   0.75768,   0.76102,   0.76422,   0.76729,   0.77020,   0.77295,
   0.77555,   0.77799,   0.78028,   0.78244,   0.78448,   0.78641,   0.78826,
   0.79005,   0.79180,   0.79355,   0.79531,   0.79711,   0.79897,   0.80092,
   0.80296,   0.80511,   0.80739,   0.80979,   0.81233,   0.81499,   0.81777,
   0.82067,   0.82367,   0.82677,   0.82993,   0.83315,   0.83641,   0.83970,
   0.84298,   0.84626,   0.84950,   0.85270,   0.85584,   0.85890,   0.86188,
   0.86477,   0.86755,   0.87022,   0.87278,   0.87521,   0.87752,   0.87971,
   0.88178,   0.88373,   0.88557,   0.88731,   0.88897,   0.89055,   0.89207,
   0.89357,   0.89505,   0.89656,   0.89812,   0.89976,   0.90152,   0.90342,
   0.90551,   0.90780,   0.91033,   0.91313,   0.91620,   0.91956,   0.92321,
   0.92716,   0.93137,   0.93584,   0.94053,   0.94540,   0.95041,   0.95549,
   0.96059,   0.96565,   0.97059,   0.97536,   0.97990,   0.98414,   0.98805,
   0.99157,   0.99464,   0.99717,   0.99901,   1.00000},
   //---------  5.0 GeV
  {0.00079,   0.00311,   0.00924,   0.01833,   0.03024,   0.04481,   0.06184,
   0.08109,   0.10230,   0.12518,   0.14941,   0.17470,   0.20071,   0.22715,
   0.25372,   0.28014,   0.30616,   0.33154,   0.35608,   0.37960,   0.40197,
   0.42308,   0.44285,   0.46121,   0.47816,   0.49369,   0.50783,   0.52061,
   0.53209,   0.54235,   0.55146,   0.55951,   0.56660,   0.57280,   0.57823,
   0.58295,   0.58707,   0.59067,   0.59382,   0.59660,   0.59907,   0.60130,
   0.60334,   0.60524,   0.60706,   0.60882,   0.61058,   0.61236,   0.61419,
   0.61609,   0.61809,   0.62020,   0.62244,   0.62481,   0.62732,   0.62996,
   0.63275,   0.63566,   0.63870,   0.64185,   0.64510,   0.64843,   0.65182,
   0.65526,   0.65873,   0.66222,   0.66571,   0.66919,   0.67265,   0.67608,
   0.67948,   0.68284,   0.68618,   0.68949,   0.69278,   0.69606,   0.69935,
   0.70264,   0.70596,   0.70931,   0.71271,   0.71615,   0.71965,   0.72319,
   0.72679,   0.73043,   0.73410,   0.73779,   0.74148,   0.74515,   0.74879,
   0.75237,   0.75587,   0.75927,   0.76256,   0.76571,   0.76871,   0.77155,
   0.77424,   0.77676,   0.77912,   0.78134,   0.78343,   0.78539,   0.78726,
   0.78906,   0.79081,   0.79254,   0.79427,   0.79604,   0.79786,   0.79976,
   0.80175,   0.80386,   0.80608,   0.80843,   0.81092,   0.81353,   0.81626,
   0.81911,   0.82206,   0.82509,   0.82820,   0.83135,   0.83454,   0.83774,
   0.84094,   0.84411,   0.84724,   0.85031,   0.85330,   0.85621,   0.85903,
   0.86174,   0.86434,   0.86682,   0.86919,   0.87143,   0.87355,   0.87555,
   0.87744,   0.87923,   0.88092,   0.88252,   0.88406,   0.88554,   0.88699,
   0.88844,   0.88990,   0.89142,   0.89300,   0.89470,   0.89654,   0.89855,
   0.90076,   0.90321,   0.90591,   0.90889,   0.91217,   0.91575,   0.91963,
   0.92382,   0.92828,   0.93300,   0.93794,   0.94307,   0.94833,   0.95366,
   0.95900,   0.96429,   0.96945,   0.97443,   0.97916,   0.98357,   0.98763,
   0.99127,   0.99445,   0.99707,   0.99898,   1.00000}
 };

 // CM momentum (GeV/c)
 G4float G4AngularDistributionNP::pcm[NENERGY] = {
   0.685E-01, 0.969E-01, 0.119, 0.153, 0.181, 0.217, 0.256,
   0.291, 0.336, 0.399, 0.444, 0.484, 0.522, 0.539,
   0.565, 0.589, 0.613, 0.650, 0.685, 0.718, 0.750,
   0.781, 0.810, 0.839, 0.866, 0.893, 0.919, 0.944,
   0.969, 1.016, 1.061, 1.104, 1.146, 1.186, 1.263,
   1.335, 1.404, 1.469, 1.532
};

 // Lab energy (GeV)
 G4float G4AngularDistributionNP::elab[NENERGY] = {
   0.100E-01, 0.200E-01, 0.300E-01, 0.500E-01, 0.700E-01, 0.100, 0.140,
   0.180, 0.240, 0.340, 0.420, 0.500, 0.580, 0.620,
   0.680, 0.740, 0.800, 0.900,  1.00,  1.10, 1.200,
   1.300, 1.400, 1.500, 1.600, 1.700, 1.800, 1.900,
   2.000, 2.200, 2.400, 2.600, 2.800, 3.000, 3.400,
   3.800, 4.200, 4.600, 5.000
};

 // Max dsigma/domega-CM (mb/sr)
 G4float G4AngularDistributionNP::dsigmax[NENERGY] = {
   79.0,  43.0,  29.8,  20.0,  16.3,  14.5,  13.3,
   12.6,  11.9,  11.3,  11.1,  10.7,  9.69,  10.1,
   11.4,  12.5,  13.3,  14.5,  15.6,  16.9,  18.3,
   20.070, 21.620, 23.090, 24.460, 25.710, 26.870, 27.950,
   28.990, 30.950, 32.790, 34.570, 36.370, 38.090, 40.810,
   40.950, 40.230, 39.840, 39.010
};


 // Total cross section
 G4float G4AngularDistributionNP::sigtot[NENERGY] = {
   947.,  485.,  310.,  168.,  110.,  75.7,  55.2,
   45.9,  39.1,  34.1,  32.3,  31.3,  30.1,  29.5,
   28.4,  27.4,  26.4,  24.8,  23.4,  22.4,  21.9,
   22.074, 22.182, 22.380, 22.589, 22.777, 22.939, 23.072,
   23.182, 23.339, 23.443, 23.561, 23.752, 23.996, 24.841,
   25.406, 24.742, 24.314, 23.695
};
