//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//

#include "globals.hh"
#include "G4BaryonPartialWidth.hh"
#include "G4PhysicsVector.hh"
#include "G4PartialWidthTable.hh"

const G4double G4BaryonPartialWidth::energies[120] = 
{ 
    .100,    .162,    .224,    .285,    .347,    .409,    .471,    .532,
    .594,    .656,    .718,    .779,    .841,    .903,    .965,   1.026,
   1.088,   1.150,   1.212,   1.274,   1.335,   1.397,   1.459,   1.521,
   1.582,   1.644,   1.706,   1.768,   1.829,   1.891,   1.953,   2.015,
   2.076,   2.138,   2.200,   2.262,   2.324,   2.385,   2.447,   2.509,
   2.571,   2.632,   2.694,   2.756,   2.818,   2.879,   2.941,   3.003,
   3.065,   3.126,   3.188,   3.250,   3.312,   3.374,   3.435,   3.497,
   3.559,   3.621,   3.682,   3.744,   3.806,   3.868,   3.929,   3.991,
   4.053,   4.115,   4.176,   4.238,   4.300,   4.362,   4.424,   4.485,
   4.547,   4.609,   4.671,   4.732,   4.794,   4.856,   4.918,   4.979,
   5.000,   6.134,   7.269,   8.403,   9.538,  10.672,  11.807,  12.941,
  14.076,  15.210,  16.345,  17.479,  18.613,  19.748,  20.882,  22.017,
  23.151,  24.286,  25.420,  26.555,  27.689,  28.824,  29.958,  31.092,
  32.227,  33.361,  34.496,  35.630,  36.765,  37.899,  39.034,  40.168,
  41.303,  42.437,  43.571,  44.706,  45.840,  46.975,  48.109,  49.244
};

const G4double G4BaryonPartialWidth::pwN1440_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6.98204, 45.8544, 87.4461, 130.335, 172.833, 215.694, 257.809, 298.922, 338.249, 377.002, 414.495, 450.727, 485.164, 518.969, 551.607, 583.125, 613.087, 642.525, 670.986, 698.518, 725.164, 750.56, 775.577, 799.831, 823.36, 845.834, 868.024, 889.586, 910.548, 930.615, 950.467, 969.798, 988.628, 1006.69, 1024.59, 1042.05, 1059.09, 1075.72, 1091.71, 1107.59, 1123.1, 1138.27, 1152.87, 1167.4, 1181.61, 1195.52, 1208.92, 1222.27, 1235.35, 1248.17, 1260.54, 1272.86, 1284.95, 1296.81, 1308.45, 1319.69, 1330.91, 1341.93, 1352.75, 1363.21, 1373.65, 1383.92, 1394.01, 1403.77, 1407.1, 1562.47, 1682.29, 1777.77, 1855.98, 1921.2, 1976.56, 2024.11, 2065.47, 2101.72, 2133.83, 2162.42, 2188.06, 2211.21, 2232.18, 2251.31, 2268.78, 2284.85, 2299.64, 2313.33, 2326.01, 2337.81, 2348.8, 2359.08, 2368.71, 2377.74, 2386.24, 2394.24, 2401.8, 2408.94, 2415.7, 2422.11, 2428.2, 2433.99, 2439.49, 2444.75, 2449.75, 2454.54, 2459.11, 2463.49
};

const G4double G4BaryonPartialWidth::pwN1440_Npipi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.161006, 5.04877, 9.80256, 14.4185, 18.8311, 23.048, 27.0133, 30.8652, 34.5462, 38.0656, 41.3793, 44.605, 47.6957, 50.6597, 53.4596, 56.1944, 58.824, 61.3548, 63.7925, 66.1053, 68.374, 70.5647, 72.6816, 74.6964, 76.6788, 78.5986, 80.459, 82.2345, 83.9859, 85.6863, 87.3382, 88.9182, 90.4804, 92.0004, 93.48, 94.9211, 96.303, 97.6724, 99.0079, 100.311, 101.562, 102.804, 104.018, 105.203, 106.344, 107.477, 108.586, 109.67, 110.715, 111.754, 112.772, 113.77, 114.747, 115.689, 116.628, 117.548, 118.451, 119.323, 120.193, 121.046, 121.884, 122.693, 122.968, 135.71, 145.368, 152.964, 159.12, 164.21, 168.501, 172.162, 175.331, 178.096, 180.535, 182.699, 184.634, 186.376, 187.95, 189.382, 190.688, 191.886, 192.988, 194.005, 194.946, 195.821, 196.635, 197.394, 198.106, 198.772, 199.398, 199.987, 200.544, 201.068, 201.565, 202.035, 202.482, 202.906, 203.309, 203.694, 204.06, 204.41, 204.745, 205.065
};

const G4double G4BaryonPartialWidth::pwN1440_Dpi[120] =
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.87216e-06, 0.230077, 4.54349, 37.5458, 113.519, 205.776, 300.769, 397.385, 492.034, 583.626, 670.198, 754.322, 834.464, 910.66, 981.879, 1050.6, 1115.81, 1177.68, 1236.4, 1291.28, 1344.3, 1394.71, 1442.66, 1487.59, 1531.12, 1572.63, 1612.24, 1649.47, 1685.66, 1720.27, 1753.4, 1784.63, 1815.08, 1844.29, 1872.34, 1899.28, 1924.78, 1949.71, 1973.72, 1996.84, 2018.77, 2040.28, 2061.03, 2081.07, 2100.12, 2118.84, 2136.95, 2154.47, 2171.15, 2187.58, 2203.49, 2218.92, 2233.9, 2248.2, 2262.33, 2276.05, 2289.38, 2302.11, 2314.68, 2326.88, 2338.74, 2350.08, 2353.92, 2520.01, 2637.65, 2705.62, 2751.71, 2848.55, 2941.05, 2933.68, 2859.91, 2806.92, 2794.15, 2791.59, 2776.72, 2757.49, 2758.21, 2799.93, 2893.23, 3040.11, 3236.1, 3472.64, 3736.02, 4008.89, 4269.31, 4494.45, 4663.22, 4759.85, 4777.72, 4719.52, 4595.66, 4421.57, 4213.43, 3986.73, 3753.44, 3523.12, 3301.73, 3092.83, 2898.74, 2719.77, 2556.09, 2406.73
};


const G4double G4BaryonPartialWidth::pwN1520_Ngamma[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
const G4double G4BaryonPartialWidth::pwN1520_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.208063, 3.69544, 10.218, 19.3142, 30.3983, 43.454, 57.9495, 73.5494, 89.6868, 106.636, 123.919, 141.352, 158.503, 175.812, 192.898, 209.684, 225.847, 241.872, 257.459, 272.583, 287.23, 301.168, 314.852, 328.05, 340.77, 352.824, 364.619, 375.965, 386.875, 397.197, 407.283, 416.976, 426.291, 435.1, 443.706, 451.977, 459.927, 467.568, 474.798, 481.867, 488.666, 495.206, 501.399, 507.459, 513.294, 518.912, 524.237, 529.454, 534.482, 539.329, 543.929, 548.44, 552.792, 556.993, 561.048, 564.903, 568.688, 572.346, 575.882, 579.246, 582.554, 585.754, 588.851, 591.8, 592.794, 633.658, 658.234, 674.027, 684.754, 692.344, 697.913, 702.109, 705.353, 707.907, 709.956, 711.623, 712.998, 714.145, 715.112, 715.934, 716.639, 717.249, 717.778, 718.242, 718.651, 719.012, 719.333, 719.62, 719.877, 720.108, 720.317, 720.506, 720.679, 720.836, 720.979, 721.111, 721.232, 721.343, 721.446, 721.541, 721.629, 721.711, 721.787, 721.858
};
const G4double G4BaryonPartialWidth::pwN1520_Npipi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0123777, 1.68696, 4.77717, 8.79837, 13.438, 18.5046, 23.7637, 29.2741, 34.8609, 40.4534, 45.9085, 51.3641, 56.6992, 61.8913, 66.8448, 71.7119, 76.4039, 80.9178, 85.2535, 89.3469, 93.3352, 97.1541, 100.809, 104.249, 107.594, 110.793, 113.85, 116.727, 119.523, 122.196, 124.753, 127.159, 129.5, 131.74, 133.884, 135.937, 137.872, 139.758, 141.565, 143.298, 144.933, 146.529, 148.061, 149.532, 150.922, 152.281, 153.587, 154.844, 156.033, 157.197, 158.318, 159.397, 160.437, 161.424, 162.391, 163.324, 164.225, 165.08, 165.92, 166.731, 167.514, 168.26, 168.511, 178.728, 184.78, 188.635, 191.237, 193.071, 194.412, 195.42, 196.199, 196.811, 197.302, 197.7, 198.029, 198.303, 198.534, 198.73, 198.898, 199.044, 199.17, 199.281, 199.378, 199.464, 199.541, 199.609, 199.67, 199.725, 199.775, 199.82, 199.861, 199.899, 199.933, 199.964, 199.993, 200.02, 200.044, 200.067, 200.088, 200.107, 200.125, 200.142
};
const G4double G4BaryonPartialWidth::pwN1520_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00361943, 0.975, 4.30923, 12.5932, 22.4252, 30.742, 37.668, 43.7624, 49.1155, 53.8681, 58.0553, 61.8893, 65.3571, 68.5069, 71.3341, 73.964, 76.3763, 78.5951, 80.6409, 82.5023, 84.2556, 85.8829, 87.3961, 88.7837, 90.1006, 91.3315, 92.4838, 93.5473, 94.5626, 95.5172, 96.4157, 97.2494, 98.0493, 98.8051, 99.5198, 100.196, 100.828, 101.437, 102.015, 102.564, 103.079, 103.577, 104.051, 104.504, 104.929, 105.342, 105.737, 106.114, 106.469, 106.815, 107.146, 107.464, 107.769, 108.058, 108.34, 108.612, 108.873, 109.12, 109.36, 109.591, 109.813, 110.023, 110.094, 112.933, 114.811, 115.402, 115.576, 117.958, 120.389, 119.238, 115.727, 113.101, 112.067, 111.485, 110.499, 109.396, 109.077, 110.322, 113.521, 118.743, 125.818, 134.421, 144.041, 154.028, 163.565, 171.799, 177.944, 181.41, 181.952, 179.665, 174.938, 168.345, 160.487, 151.943, 143.157, 134.485, 126.151, 118.285, 110.975, 104.232, 98.0621, 92.4291
};

const G4double G4BaryonPartialWidth::pwN1535_Ngamma[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.012071, 0.0361725, 0.056634, 0.0738762, 0.0885406, 0.101117, 0.111819, 0.121293, 0.129584, 0.136883, 0.143243, 0.148995, 0.154131, 0.158737, 0.162819, 0.16657, 0.169969, 0.173059, 0.175833, 0.178413, 0.180778, 0.182951, 0.184953, 0.186772, 0.188483, 0.190069, 0.191541, 0.192889, 0.194167, 0.19536, 0.196474, 0.197501, 0.19848, 0.199399, 0.200263, 0.201064, 0.20183, 0.202554, 0.203237, 0.203883, 0.204484, 0.205064, 0.205613, 0.206134, 0.206622, 0.207093, 0.207542, 0.207969, 0.208369, 0.208758, 0.209129, 0.209483, 0.209816, 0.21014, 0.21045, 0.210747, 0.211032, 0.2113, 0.211562, 0.211813, 0.212055, 0.212283, 0.212507, 0.212721, 0.212928, 0.213124, 0.21319, 0.215801, 0.217289, 0.218216, 0.218833, 0.219263, 0.219576, 0.219809, 0.219989, 0.22013, 0.220243, 0.220334, 0.22041, 0.220472, 0.220525, 0.22057, 0.220608, 0.220641, 0.22067, 0.220695, 0.220717, 0.220737, 0.220754, 0.22077, 0.220784, 0.220796, 0.220808, 0.220818, 0.220827, 0.220836, 0.220843, 0.22085, 0.220857, 0.220863, 0.220869, 0.220874, 0.220878, 0.220883, 0.220887, 0.220891
};
const G4double G4BaryonPartialWidth::pwN1535_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12.3126, 31.5849, 43.1208, 51.9969, 59.1503, 65.2784, 70.526, 75.0745, 78.9933, 82.5073, 85.6237, 88.4026, 90.8545, 93.099, 95.1267, 96.965, 98.6116, 100.14, 101.538, 102.821, 104.001, 105.071, 106.078, 107.009, 107.874, 108.664, 109.413, 110.112, 110.764, 111.365, 111.937, 112.474, 112.979, 113.446, 113.893, 114.315, 114.714, 115.09, 115.441, 115.778, 116.098, 116.402, 116.686, 116.96, 117.221, 117.47, 117.703, 117.929, 118.144, 118.35, 118.544, 118.732, 118.913, 119.085, 119.25, 119.406, 119.559, 119.705, 119.845, 119.978, 120.107, 120.232, 120.352, 120.466, 120.504, 122.018, 122.881, 123.418, 123.775, 124.025, 124.206, 124.341, 124.445, 124.527, 124.592, 124.645, 124.688, 124.725, 124.755, 124.781, 124.803, 124.822, 124.839, 124.854, 124.866, 124.878, 124.888, 124.897, 124.905, 124.912, 124.919, 124.925, 124.93, 124.935, 124.939, 124.943, 124.947, 124.951, 124.954, 124.957, 124.96, 124.962, 124.965, 124.967
};
const G4double G4BaryonPartialWidth::pwN1535_Neta[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36.8028, 59.1225, 73.8347, 84.9352, 93.8449, 101.136, 107.439, 112.878, 117.628, 121.754, 125.484, 128.821, 131.824, 134.539, 136.966, 139.217, 141.277, 143.167, 144.88, 146.488, 147.976, 149.355, 150.618, 151.813, 152.928, 153.97, 154.93, 155.846, 156.706, 157.515, 158.276, 158.983, 159.661, 160.302, 160.908, 161.474, 162.019, 162.536, 163.028, 163.488, 163.933, 164.357, 164.761, 165.14, 165.509, 165.861, 166.197, 166.519, 166.822, 167.118, 167.401, 167.673, 167.93, 168.18, 168.421, 168.653, 168.872, 168.945, 171.845, 173.481, 174.494, 175.165, 175.633, 175.972, 176.225, 176.419, 176.572, 176.694, 176.792, 176.873, 176.941, 176.998, 177.046, 177.088, 177.123, 177.154, 177.182, 177.205, 177.227, 177.245, 177.262, 177.277, 177.29, 177.303, 177.314, 177.324, 177.333, 177.341, 177.349, 177.356, 177.362, 177.368, 177.374, 177.379, 177.384, 177.388, 177.392
};
const G4double G4BaryonPartialWidth::pwN1535_Npipi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.40742, 3.2479, 4.50972, 5.43179, 6.15766, 6.75447, 7.25036, 7.68334, 8.05951, 8.38955, 8.67699, 8.93731, 9.17036, 9.38004, 9.56661, 9.73879, 9.89555, 10.0387, 10.1699, 10.2886, 10.3998, 10.5024, 10.5974, 10.6841, 10.766, 10.8422, 10.9133, 10.9787, 11.0409, 11.0992, 11.1539, 11.2045, 11.2529, 11.2985, 11.3414, 11.382, 11.4198, 11.4562, 11.4906, 11.5232, 11.5537, 11.5832, 11.6112, 11.6378, 11.6628, 11.687, 11.7101, 11.7322, 11.7529, 11.773, 11.7923, 11.8107, 11.8284, 11.8451, 11.8613, 11.8769, 11.8918, 11.906, 11.9198, 11.9331, 11.9459, 11.958, 11.9621, 12.1232, 12.2148, 12.2717, 12.3095, 12.3359, 12.3551, 12.3694, 12.3804, 12.389, 12.3959, 12.4015, 12.4061, 12.4099, 12.4132, 12.4159, 12.4182, 12.4203, 12.422, 12.4236, 12.4249, 12.4261, 12.4272, 12.4281, 12.429, 12.4298, 12.4304, 12.4311, 12.4316, 12.4322, 12.4326, 12.4331, 12.4335, 12.4338, 12.4342, 12.4345, 12.4348, 12.435, 12.4353, 12.4355
};
const G4double G4BaryonPartialWidth::pwN1535_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

const G4double G4BaryonPartialWidth::pwN1650_Ngamma[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
const G4double G4BaryonPartialWidth::pwN1650_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14.4948, 37.1813, 50.7609, 61.2097, 69.6305, 76.8442, 83.0216, 88.376, 92.9892, 97.1258, 100.794, 104.066, 106.952, 109.594, 111.981, 114.145, 116.083, 117.882, 119.528, 121.038, 122.427, 123.688, 124.872, 125.969, 126.986, 127.917, 128.799, 129.621, 130.389, 131.096, 131.77, 132.402, 132.996, 133.546, 134.073, 134.569, 135.038, 135.482, 135.894, 136.292, 136.668, 137.026, 137.36, 137.683, 137.99, 138.283, 138.557, 138.823, 139.077, 139.319, 139.547, 139.769, 139.981, 140.184, 140.379, 140.562, 140.742, 140.913, 141.079, 141.235, 141.387, 141.534, 141.675, 141.809, 141.854, 143.637, 144.653, 145.285, 145.705, 145.999, 146.212, 146.371, 146.494, 146.59, 146.667, 146.729, 146.78, 146.823, 146.859, 146.889, 146.915, 146.938, 146.958, 146.975, 146.99, 147.003, 147.015, 147.026, 147.035, 147.044, 147.051, 147.058, 147.065, 147.07, 147.076, 147.08, 147.085, 147.089, 147.093, 147.096, 147.1, 147.103, 147.105, 147.108
};
const G4double G4BaryonPartialWidth::pwN1650_Neta[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.67859, 5.90954, 7.38008, 8.48962, 9.38018, 10.109, 10.739, 11.2826, 11.7574, 12.1698, 12.5426, 12.8762, 13.1763, 13.4477, 13.6903, 13.9154, 14.1212, 14.3102, 14.4814, 14.6421, 14.7908, 14.9287, 15.0548, 15.1743, 15.2858, 15.3899, 15.4859, 15.5775, 15.6634, 15.7442, 15.8203, 15.891, 15.9588, 16.0228, 16.0835, 16.14, 16.1945, 16.2462, 16.2953, 16.3413, 16.3858, 16.4281, 16.4685, 16.5065, 16.5433, 16.5785, 16.6121, 16.6443, 16.6746, 16.7041, 16.7324, 16.7596, 16.7853, 16.8103, 16.8344, 16.8575, 16.8794, 16.8868, 17.1766, 17.3402, 17.4414, 17.5085, 17.5552, 17.5891, 17.6144, 17.6339, 17.6491, 17.6613, 17.6711, 17.6792, 17.686, 17.6917, 17.6965, 17.7006, 17.7042, 17.7073, 17.71, 17.7124, 17.7145, 17.7164, 17.7181, 17.7196, 17.7209, 17.7221, 17.7232, 17.7242, 17.7252, 17.726, 17.7268, 17.7275, 17.7281, 17.7287, 17.7293, 17.7298, 17.7302, 17.7307, 17.7311
};
const G4double G4BaryonPartialWidth::pwN1650_Npipi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.396225, 3.15465, 4.38013, 5.27566, 5.98064, 6.56028, 7.0419, 7.46242, 7.82778, 8.14833, 8.4275, 8.68033, 8.90667, 9.11032, 9.29153, 9.45875, 9.611, 9.75008, 9.87749, 9.99274, 10.1007, 10.2004, 10.2926, 10.3768, 10.4564, 10.5305, 10.5995, 10.663, 10.7234, 10.78, 10.8332, 10.8823, 10.9293, 10.9736, 11.0153, 11.0547, 11.0914, 11.1267, 11.1602, 11.1919, 11.2215, 11.2501, 11.2773, 11.3032, 11.3274, 11.3509, 11.3734, 11.3948, 11.4149, 11.4345, 11.4532, 11.4711, 11.4883, 11.5044, 11.5202, 11.5353, 11.5499, 11.5636, 11.577, 11.59, 11.6024, 11.6141, 11.6181, 11.7746, 11.8636, 11.9188, 11.9556, 11.9812, 11.9998, 12.0137, 12.0244, 12.0327, 12.0394, 12.0449, 12.0493, 12.0531, 12.0562, 12.0589, 12.0611, 12.0631, 12.0648, 12.0663, 12.0676, 12.0688, 12.0698, 12.0707, 12.0716, 12.0723, 12.073, 12.0736, 12.0742, 12.0747, 12.0751, 12.0755, 12.0759, 12.0763, 12.0766, 12.0769, 12.0772, 12.0775, 12.0777, 12.0779
};
const G4double G4BaryonPartialWidth::pwN1650_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.84815e-11, 0.000117562, 0.0109052, 0.293417, 1.75473, 4.72211, 8.97337, 14.4217, 20.7542, 27.7234, 34.9853, 42.5923, 50.2751, 57.9149, 65.3027, 72.6169, 79.6904, 86.4943, 93.0115, 99.1366, 105.069, 110.71, 116.068, 121.071, 125.895, 130.467, 134.801, 138.844, 142.741, 146.436, 149.941, 153.214, 156.374, 159.375, 162.226, 164.938, 167.476, 169.934, 172.274, 174.504, 176.598, 178.629, 180.568, 182.42, 184.163, 185.857, 187.479, 189.032, 190.495, 191.921, 193.289, 194.601, 195.862, 197.054, 198.22, 199.342, 200.42, 201.44, 202.438, 203.397, 204.319, 205.194, 205.488, 217.277, 224.576, 227.917, 229.694, 235.609, 241.332, 239.502, 232.714, 227.665, 225.822, 224.856, 223.028, 220.929, 220.408, 223.058, 229.674, 240.394, 254.867, 272.434, 292.053, 312.407, 331.834, 348.607, 361.127, 368.201, 369.326, 364.702, 355.115, 341.732, 325.777, 308.423, 290.576, 272.96, 256.027, 240.046, 225.193, 211.492, 198.955, 187.509
};
const G4double G4BaryonPartialWidth::pwN1650_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00118441, 0.18267, 0.570164, 1.19764, 2.13181, 3.46343, 5.19982, 7.2885, 9.48988, 11.6394, 13.6326, 15.5154, 17.2557, 18.8626, 20.3242, 21.6993, 22.9732, 24.1554, 25.2541, 26.261, 27.2158, 28.1075, 28.9415, 29.7104, 30.4438, 31.1326, 31.7804, 32.3807, 32.9563, 33.4995, 34.0127, 34.4906, 34.9507, 35.3868, 35.8006, 36.1936, 36.5612, 36.9169, 37.2555, 37.5783, 37.8812, 38.1752, 38.4561, 38.7245, 38.9773, 39.2233, 39.4589, 39.6848, 39.898, 40.106, 40.3058, 40.4977, 40.6822, 40.8569, 41.0278, 41.1924, 41.351, 41.5014, 41.6488, 41.7911, 41.9284, 42.0589, 42.1028, 43.8854, 44.9476, 45.6351, 46.109, 46.4502, 46.7072, 46.9005, 47.0541, 47.1939, 47.3081, 47.3703, 47.3886, 47.4058, 47.4651, 47.5858, 47.7581, 47.9493, 48.1127, 48.2031, 48.1914, 48.0721, 47.8636, 47.5981, 47.3116, 47.0354, 46.7898, 46.585, 46.4214, 46.2941, 46.1957, 46.1199, 46.0629, 46.0247, 46.0087, 46.0213, 46.0706, 46.1655, 46.3143, 46.5248
};
const G4double G4BaryonPartialWidth::pwN1650_LK[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13.8778, 22.6835, 28.4539, 32.8057, 36.4056, 39.4289, 42.023, 44.2487, 46.2437, 48.017, 49.6048, 51.0353, 52.3107, 53.4909, 54.5687, 55.5566, 56.4508, 57.2895, 58.0648, 58.7835, 59.4407, 60.0628, 60.6431, 61.1852, 61.6848, 62.161, 62.6082, 63.0286, 63.4245, 63.7919, 64.1446, 64.4779, 64.7933, 65.0873, 65.3708, 65.6398, 65.8954, 66.1346, 66.3661, 66.5866, 66.7968, 66.9941, 67.1858, 67.3688, 67.5439, 67.7114, 67.8693, 68.023, 68.1704, 68.3118, 68.4454, 68.5758, 68.7011, 68.8216, 68.9357, 68.974, 70.4839, 71.3365, 71.8644, 72.2144, 72.4582, 72.6349, 72.767, 72.8685, 72.948, 73.0115, 73.063, 73.1054, 73.1407, 73.1703, 73.1956, 73.2171, 73.2358, 73.252, 73.2661, 73.2786, 73.2896, 73.2994, 73.3081, 73.3159, 73.323, 73.3293, 73.3351, 73.3403, 73.3451, 73.3495, 73.3535, 73.3571, 73.3605, 73.3636, 73.3665, 73.3692, 73.3717, 73.374, 73.3761
};

const G4double G4BaryonPartialWidth::pwN1675_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.104352, 1.86366, 5.19128, 9.89543, 15.7148, 22.6823, 30.5539, 39.1794, 48.2668, 57.9899, 68.0919, 78.4735, 88.8765, 99.5674, 110.312, 121.055, 131.578, 142.186, 152.672, 163.01, 173.177, 182.995, 192.773, 202.336, 211.676, 220.643, 229.526, 238.175, 246.589, 254.639, 262.589, 270.31, 277.804, 284.96, 292.016, 298.859, 305.493, 311.923, 318.055, 324.097, 329.952, 335.625, 341.034, 346.363, 351.526, 356.529, 361.299, 366, 370.555, 374.971, 379.183, 383.335, 387.36, 391.264, 395.05, 398.664, 402.229, 405.688, 409.044, 412.25, 415.415, 418.487, 421.47, 424.322, 425.285, 465.83, 491.141, 507.791, 519.276, 527.49, 533.563, 538.166, 541.74, 544.563, 546.835, 548.687, 550.217, 551.496, 552.575, 553.494, 554.282, 554.964, 555.557, 556.077, 556.535, 556.94, 557.3, 557.622, 557.911, 558.171, 558.406, 558.619, 558.812, 558.989, 559.15, 559.298, 559.434, 559.559, 559.675, 559.782, 559.881, 559.973, 560.059, 560.139
};
const G4double G4BaryonPartialWidth::pwN1675_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.08973e-10, 0.000506157, 0.0469517, 1.26474, 7.5878, 20.5105, 39.1727, 63.3024, 91.6101, 123.057, 156.125, 191.071, 226.665, 262.342, 297.098, 331.745, 365.468, 398.099, 429.527, 459.212, 488.098, 515.684, 541.986, 566.637, 590.486, 613.163, 634.718, 654.88, 674.362, 692.876, 710.474, 726.942, 742.868, 758.019, 772.441, 786.173, 799.05, 811.529, 823.43, 834.785, 845.453, 855.814, 865.715, 875.182, 884.096, 892.773, 901.081, 909.042, 916.551, 923.872, 930.897, 937.643, 944.126, 950.262, 956.264, 962.039, 967.595, 972.855, 977.999, 982.948, 987.711, 992.226, 993.744, 1054.77, 1092.54, 1110.19, 1119.77, 1149.38, 1177.86, 1169.24, 1136.27, 1111.78, 1102.93, 1098.35, 1089.52, 1079.36, 1076.89, 1089.93, 1122.36, 1174.85, 1245.68, 1331.63, 1427.61, 1527.17, 1622.19, 1704.23, 1765.47, 1800.08, 1805.59, 1782.99, 1736.13, 1670.7, 1592.69, 1507.84, 1420.58, 1334.45, 1251.66, 1173.52, 1100.9, 1033.91, 972.605, 916.639
};

const G4double G4BaryonPartialWidth::pwN1680_Ngamma[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
const G4double G4BaryonPartialWidth::pwN1680_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0125742, 0.588859, 2.37597, 5.77382, 10.9723, 18.3193, 27.8173, 39.4395, 52.8395, 68.2802, 85.3292, 103.726, 122.872, 143.121, 163.9, 184.959, 205.733, 226.712, 247.388, 267.624, 287.31, 306.061, 324.432, 342.067, 358.942, 374.793, 390.138, 404.721, 418.558, 431.465, 443.89, 455.643, 466.754, 477.089, 487.016, 496.393, 505.25, 513.615, 521.393, 528.867, 535.929, 542.606, 548.821, 554.8, 560.459, 565.818, 570.814, 575.629, 580.195, 584.527, 588.575, 592.483, 596.198, 599.729, 603.088, 606.234, 609.281, 612.184, 614.951, 617.549, 620.069, 622.475, 624.774, 626.936, 627.658, 654.682, 668.344, 676.045, 680.764, 683.838, 685.944, 687.442, 688.544, 689.376, 690.019, 690.525, 690.931, 691.26, 691.531, 691.757, 691.947, 692.108, 692.245, 692.364, 692.467, 692.557, 692.636, 692.706, 692.768, 692.823, 692.872, 692.916, 692.956, 692.992, 693.025, 693.055, 693.082, 693.107, 693.13, 693.151, 693.17, 693.188, 693.205, 693.22
};
const G4double G4BaryonPartialWidth::pwN1680_Npipi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.000613339, 0.35736, 1.50207, 3.55477, 6.5317, 10.4128, 15.0555, 20.5226, 26.633, 33.2637, 40.1723, 47.4642, 54.9144, 62.4205, 69.7743, 77.1437, 84.3479, 91.3404, 98.0866, 104.46, 110.655, 116.555, 122.159, 127.386, 132.413, 137.159, 141.636, 145.788, 149.764, 153.507, 157.029, 160.29, 163.411, 166.348, 169.112, 171.715, 174.127, 176.439, 178.618, 180.673, 182.582, 184.415, 186.146, 187.783, 189.307, 190.773, 192.161, 193.477, 194.705, 195.89, 197.015, 198.083, 199.098, 200.049, 200.969, 201.845, 202.679, 203.463, 204.222, 204.947, 205.639, 206.29, 206.508, 214.639, 218.761, 221.098, 222.539, 223.483, 224.133, 224.598, 224.942, 225.203, 225.406, 225.566, 225.694, 225.799, 225.886, 225.958, 226.019, 226.071, 226.115, 226.153, 226.187, 226.216, 226.242, 226.264, 226.285, 226.303, 226.319, 226.333, 226.346, 226.358, 226.369, 226.379, 226.388, 226.396, 226.404, 226.411, 226.417, 226.423, 226.428, 226.433
};
const G4double G4BaryonPartialWidth::pwN1680_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.81397e-07, 0.00711046, 0.142892, 1.23798, 3.95228, 7.49578, 11.3739, 15.5308, 19.7974, 24.1024, 28.3277, 32.5779, 36.7596, 40.8564, 44.7938, 48.694, 52.488, 56.174, 59.7519, 63.1677, 66.5351, 69.7999, 72.9648, 75.9842, 78.9604, 81.8463, 84.6453, 87.3176, 89.9539, 92.5131, 94.9981, 97.3736, 99.7202, 102.001, 104.219, 106.377, 108.443, 110.488, 112.479, 114.419, 116.279, 118.122, 119.919, 121.673, 123.357, 125.028, 126.659, 128.252, 129.784, 131.305, 132.792, 134.247, 135.67, 137.041, 138.405, 139.741, 141.049, 142.308, 143.561, 144.788, 145.988, 147.145, 147.539, 165.532, 179.343, 188.707, 195.801, 206.603, 216.78, 218.451, 214.318, 211.641, 212.113, 213.279, 213.28, 212.791, 213.869, 218.312, 227.043, 240.264, 257.623, 278.418, 301.493, 325.377, 348.196, 367.999, 382.974, 391.768, 393.808, 389.317, 379.185, 364.73, 347.337, 328.333, 308.745, 289.392, 270.786, 253.235, 236.934, 221.915, 208.19, 195.679
};

const G4double G4BaryonPartialWidth::pwN1700_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0169982, 0.303937, 0.847991, 1.6194, 2.57689, 3.7275, 5.03255, 6.46854, 7.9879, 9.62069, 11.3247, 13.0839, 14.8547, 16.6828, 18.5284, 20.3821, 22.2058, 24.0522, 25.8854, 27.7004, 29.4928, 31.2307, 32.9683, 34.6744, 36.3471, 37.9588, 39.5612, 41.1268, 42.6551, 44.1219, 45.5755, 46.9914, 48.3698, 49.6899, 50.9954, 52.2647, 53.4987, 54.6978, 55.8444, 56.9768, 58.0767, 59.1448, 60.1656, 61.1733, 62.1517, 63.1017, 64.0094, 64.9054, 65.7754, 66.6201, 67.4274, 68.2244, 68.9984, 69.7502, 70.4804, 71.1785, 71.8681, 72.5381, 73.1892, 73.8119, 74.4273, 75.0255, 75.6072, 76.1638, 76.3519, 84.3381, 89.3901, 92.7416, 95.0666, 96.736, 97.974, 98.9143, 99.6456, 100.224, 100.69, 101.07, 101.384, 101.647, 101.869, 102.058, 102.22, 102.361, 102.483, 102.59, 102.684, 102.768, 102.842, 102.908, 102.968, 103.021, 103.07, 103.114, 103.154, 103.19, 103.223, 103.254, 103.282, 103.308, 103.332, 103.354, 103.374, 103.393, 103.411, 103.427
};
const G4double G4BaryonPartialWidth::pwN1700_Neta[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.388548, 1.66515, 3.34381, 5.23335, 7.2399, 9.27047, 11.3518, 13.4228, 15.4635, 17.4285, 19.3726, 21.2568, 23.0772, 24.8314, 26.492, 28.1134, 29.6686, 31.1591, 32.5639, 33.9311, 35.2394, 36.4909, 37.6691, 38.815, 39.911, 40.9595, 41.9469, 42.9076, 43.8271, 44.7075, 45.5507, 46.3457, 47.1203, 47.8628, 48.5749, 49.2472, 49.9031, 50.5328, 51.1376, 51.7094, 52.2681, 52.8053, 53.322, 53.8112, 54.29, 54.751, 55.195, 55.6229, 56.0288, 56.4268, 56.8107, 57.1811, 57.533, 57.8785, 58.2122, 58.5347, 58.8415, 58.9447, 63.1502, 65.6423, 67.2295, 68.3012, 69.0564, 69.609, 70.0244, 70.345, 70.5972, 70.7993, 70.9636, 71.0989, 71.2119, 71.3069, 71.3878, 71.4571, 71.517, 71.5691, 71.6147, 71.6548, 71.6902, 71.7218, 71.7499, 71.7751, 71.7978, 71.8184, 71.8369, 71.8539, 71.8693, 71.8833, 71.8962, 71.9081, 71.919, 71.9291, 71.9384, 71.9471, 71.9551, 71.9626, 71.9695
};
const G4double G4BaryonPartialWidth::pwN1700_Nrho[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0404415, 0.13258, 0.282856, 0.512447, 0.869368, 1.4505, 2.54995, 4.77764, 8.05081, 11.0231, 13.4824, 15.4972, 17.1847, 18.6033, 19.8535, 20.9492, 21.9186, 22.783, 23.5472, 24.2489, 24.8856, 25.4657, 25.9883, 26.4761, 26.9254, 27.3404, 27.7187, 28.0758, 28.4081, 28.7179, 29.0028, 29.2739, 29.5281, 29.7668, 29.9913, 30.1994, 30.3989, 30.5874, 30.7656, 30.9317, 31.0917, 31.2436, 31.3878, 31.5227, 31.6532, 31.7776, 31.8961, 32.0074, 32.1155, 32.2188, 32.3175, 32.412, 32.5011, 32.5879, 32.6712, 32.7511, 32.8265, 32.9003, 32.9713, 33.0394, 33.1039, 33.1256, 33.984, 34.4719, 34.7662, 34.9237, 35.1047, 35.4054, 35.1967, 35.0646, 36.3603, 35.4167, 34.4032, 34.5818, 36.4001, 38.4529, 37.3006, 34.6248, 33.4044, 33.5186, 33.3785, 32.6911, 32.6449, 34.1823, 37.41, 41.6247, 45.2569, 46.4966, 44.7002, 40.9014, 36.6674, 33.0198, 30.3572, 28.7199, 28.0348, 28.2016, 29.1186, 30.6531, 32.6033, 34.6478, 36.3667
};
const G4double G4BaryonPartialWidth::pwN1700_Npipi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0157252, 2.15978, 6.21623, 11.6508, 18.1171, 25.405, 33.2129, 41.6576, 50.4956, 59.6247, 68.8057, 78.2663, 87.7939, 97.3351, 106.692, 116.133, 125.474, 134.689, 143.757, 152.517, 161.245, 169.784, 178.127, 186.139, 194.078, 201.809, 209.332, 216.53, 223.641, 230.548, 237.253, 243.656, 249.971, 256.095, 262.034, 267.79, 273.281, 278.692, 283.935, 289.016, 293.862, 298.635, 303.261, 307.743, 312.018, 316.23, 320.313, 324.271, 328.046, 331.768, 335.377, 338.877, 342.271, 345.512, 348.708, 351.81, 354.82, 357.695, 360.533, 363.289, 365.965, 368.523, 369.387, 405.772, 428.499, 443.454, 453.773, 461.154, 466.612, 470.749, 473.962, 476.5, 478.542, 480.207, 481.583, 482.733, 483.702, 484.529, 485.237, 485.851, 486.384, 486.852, 487.263, 487.628, 487.951, 488.241, 488.5, 488.734, 488.945, 489.137, 489.311, 489.469, 489.615, 489.748, 489.87, 489.983, 490.087, 490.183, 490.272, 490.355, 490.432, 490.504
};
const G4double G4BaryonPartialWidth::pwN1700_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00300083, 0.803004, 3.54823, 10.368, 18.4614, 25.3075, 31.0088, 36.0255, 40.432, 44.3443, 47.7911, 50.9472, 53.8018, 56.3947, 58.722, 60.8869, 62.8727, 64.6991, 66.3832, 67.9155, 69.3588, 70.6984, 71.944, 73.0863, 74.1704, 75.1836, 76.1322, 77.0076, 77.8434, 78.6292, 79.3689, 80.0551, 80.7136, 81.3357, 81.9241, 82.4811, 83.0008, 83.502, 83.978, 84.4304, 84.8539, 85.2639, 85.6545, 86.027, 86.377, 86.7169, 87.0418, 87.3524, 87.6448, 87.9294, 88.2021, 88.4638, 88.715, 88.9527, 89.1851, 89.4086, 89.6234, 89.8265, 90.0246, 90.2148, 90.3975, 90.5704, 90.6285, 92.9656, 94.5118, 94.9984, 95.1406, 97.1011, 99.1041, 98.158, 95.2672, 93.1044, 92.2528, 91.774, 90.9626, 90.0535, 89.7897, 90.8128, 93.4446, 97.7419, 103.564, 110.646, 118.564, 126.786, 134.638, 141.419, 146.481, 149.339, 149.788, 147.909, 144.021, 138.595, 132.128, 125.094, 117.861, 110.722, 103.86, 97.3842, 91.3655, 85.8137, 80.7336, 76.0957
};

const G4double G4BaryonPartialWidth::pwN1710_Npi[120] =
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.258418, 1.71929, 3.30813, 4.96774, 6.6309, 8.32575, 10.0074, 11.6644, 13.2632, 14.8519, 16.4014, 17.9106, 19.3558, 20.7847, 22.1742, 23.5253, 24.8183, 26.0969, 27.341, 28.5519, 29.7311, 30.8615, 31.9815, 33.0735, 34.1388, 35.1618, 36.1772, 37.169, 38.1382, 39.0705, 39.9975, 40.9044, 41.792, 42.6472, 43.4987, 44.333, 45.1507, 45.9524, 46.7261, 47.4978, 48.255, 48.9983, 49.7164, 50.4334, 51.1377, 51.8299, 52.4992, 53.1682, 53.8259, 54.4728, 55.0991, 55.7254, 56.3418, 56.9485, 57.5458, 58.1245, 58.7039, 59.2746, 59.8368, 60.3819, 60.928, 61.4662, 61.9967, 62.5115, 62.687, 71.086, 77.8329, 83.3895, 88.0657, 92.0554, 95.509, 98.5248, 101.187, 103.551, 105.668, 107.573, 109.297, 110.867, 112.299, 113.615, 114.824, 115.943, 116.978, 117.941, 118.837, 119.674, 120.458, 121.193, 121.884, 122.534, 123.148, 123.727, 124.276, 124.796, 125.29, 125.759, 126.206, 126.631, 127.036, 127.424, 127.794, 128.149, 128.488, 128.813
};
const G4double G4BaryonPartialWidth::pwN1710_Neta[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.03525, 10.3386, 16.209, 21.6609, 26.7629, 31.4871, 36.0236, 40.3211, 44.4034, 48.2291, 51.9405, 55.4881, 58.8851, 62.1428, 65.222, 68.2326, 71.1313, 73.9256, 76.5793, 79.1853, 81.7051, 84.1436, 86.4679, 88.7583, 90.9802, 93.1371, 95.199, 97.2366, 99.2184, 101.147, 103.025, 104.826, 106.61, 108.35, 110.048, 111.678, 113.297, 114.879, 116.424, 117.911, 119.39, 120.837, 122.252, 123.616, 124.974, 126.305, 127.608, 128.886, 130.119, 131.348, 132.554, 133.737, 134.88, 136.02, 137.14, 138.24, 139.303, 139.665, 156.488, 169.365, 179.583, 187.929, 194.877, 200.77, 205.826, 210.222, 214.075, 217.485, 220.522, 223.245, 225.704, 227.931, 229.962, 231.819, 233.525, 235.096, 236.55, 237.897, 239.15, 240.318, 241.41, 242.433, 243.393, 244.296, 245.147, 245.95, 246.709, 247.428, 248.109, 248.756, 249.371, 249.957, 250.515, 251.047, 251.556, 252.043, 252.509
};
const G4double G4BaryonPartialWidth::pwN1710_Nrho[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.000325604, 0.00365134, 0.0172994, 0.0588125, 0.174142, 0.493255, 1.51974, 5.10354, 13.4082, 23.5437, 33.5586, 42.7897, 51.2164, 58.7943, 65.8562, 72.3507, 78.3456, 83.8986, 88.9787, 93.7938, 98.2936, 102.509, 106.406, 110.135, 113.651, 116.972, 120.065, 123.046, 125.875, 128.564, 131.084, 133.525, 135.854, 138.079, 140.207, 142.212, 144.165, 146.038, 147.836, 149.536, 151.198, 152.797, 154.338, 155.799, 157.231, 158.613, 159.948, 161.217, 162.465, 163.672, 164.841, 165.972, 167.051, 168.114, 169.146, 170.147, 171.103, 172.047, 172.965, 173.856, 174.709, 174.998, 187.395, 195.655, 201.482, 205.606, 209.298, 213.347, 213.711, 214.32, 224.151, 219.032, 213.309, 215.351, 228.152, 242.437, 235.436, 218.283, 210.715, 211.941, 211.444, 207.287, 207.347, 217.875, 239.591, 267.838, 292.211, 300.699, 289.03, 264.061, 236.193, 212.205, 194.739, 184.062, 179.689, 180.957, 187.192, 197.516, 210.592, 224.29, 235.823
};
const G4double G4BaryonPartialWidth::pwN1710_Npipi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0940989, 2.99992, 5.90395, 8.77849, 11.5711, 14.2784, 16.8575, 19.3934, 21.8447, 24.2141, 26.4682, 28.6842, 30.8281, 32.9031, 34.8808, 36.8292, 38.7186, 40.5519, 42.3319, 44.0338, 45.7157, 47.3519, 48.9444, 50.4707, 51.9827, 53.4568, 54.8948, 56.2758, 57.6467, 58.9859, 60.2947, 61.554, 62.8062, 64.0315, 65.231, 66.4056, 67.538, 68.666, 69.7717, 70.8561, 71.9027, 72.9466, 73.9711, 74.9769, 75.9489, 76.9193, 77.8727, 78.8097, 79.716, 80.6217, 81.5123, 82.3884, 83.2502, 84.0846, 84.9194, 85.7412, 86.5502, 87.3341, 88.1188, 88.8918, 89.6534, 90.3917, 90.6435, 102.631, 112.186, 120.007, 126.557, 132.123, 136.925, 141.106, 144.787, 148.05, 150.966, 153.584, 155.951, 158.103, 160.065, 161.863, 163.516, 165.042, 166.454, 167.766, 168.986, 170.125, 171.19, 172.188, 173.127, 174.009, 174.842, 175.628, 176.371, 177.076, 177.744, 178.379, 178.983, 179.558, 180.106, 180.63, 181.13, 181.609, 182.067, 182.506
};
const G4double G4BaryonPartialWidth::pwN1710_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.05018e-07, 0.0077029, 0.154905, 1.34457, 4.30226, 8.17567, 12.4266, 16.9947, 21.6943, 26.4464, 31.1198, 35.8296, 40.4718, 45.0275, 49.4131, 53.764, 58.0028, 62.1268, 66.1355, 69.9676, 73.7504, 77.4224, 80.9864, 84.3906, 87.7497, 91.0107, 94.1769, 97.2029, 100.191, 103.095, 105.918, 108.618, 111.288, 113.886, 116.415, 118.877, 121.236, 123.573, 125.85, 128.071, 130.202, 132.315, 134.377, 136.39, 138.325, 140.246, 142.124, 143.958, 145.723, 147.477, 149.193, 150.872, 152.515, 154.1, 155.678, 157.224, 158.738, 160.197, 161.65, 163.072, 164.466, 165.809, 166.266, 187.257, 203.476, 214.579, 223.048, 235.767, 247.755, 249.905, 245.328, 242.408, 243.109, 244.599, 244.728, 244.28, 245.636, 250.879, 261.083, 276.486, 296.685, 320.868, 347.696, 375.466, 402.003, 425.039, 442.477, 452.74, 455.165, 450.01, 438.308, 421.586, 401.453, 379.449, 356.765, 334.352, 312.804, 292.477, 273.601, 256.21, 240.319, 225.836
};
const G4double G4BaryonPartialWidth::pwN1710_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.84278e-07, 0.00354223, 0.0358171, 0.163484, 0.53179, 1.42713, 3.23639, 6.34445, 10.6846, 15.9467, 21.712, 27.9298, 34.3386, 40.8194, 47.1844, 53.5844, 59.8733, 66.0228, 72.0138, 77.742, 83.3884, 88.8544, 94.1397, 99.1651, 104.098, 108.86, 113.455, 117.818, 122.099, 126.229, 130.215, 134.002, 137.719, 141.309, 144.778, 148.129, 151.318, 154.454, 157.487, 160.422, 163.219, 165.973, 168.641, 171.227, 173.694, 176.128, 178.489, 180.781, 182.971, 185.134, 187.235, 189.278, 191.265, 193.167, 195.048, 196.879, 198.662, 200.371, 202.063, 203.713, 205.321, 206.864, 207.387, 230.282, 246.003, 257.434, 266.132, 272.958, 278.479, 282.992, 286.784, 290.116, 292.98, 295.243, 297.004, 298.586, 300.306, 302.321, 304.579, 306.874, 308.896, 310.349, 311.038, 310.938, 310.174, 308.976, 307.592, 306.241, 305.065, 304.137, 303.462, 303.01, 302.733, 302.588, 302.553, 302.627, 302.837, 303.226, 303.852, 304.777, 306.059, 307.751
};
const G4double G4BaryonPartialWidth::pwN1710_LK[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.10055, 10.6044, 16.4826, 21.813, 26.852, 31.5631, 35.986, 40.0866, 44.0245, 47.7521, 51.2879, 54.6478, 57.7955, 60.8466, 63.7594, 66.5438, 69.1667, 71.7221, 74.1735, 76.5275, 78.7545, 80.933, 83.031, 85.053, 86.9727, 88.8567, 90.6769, 92.4366, 94.1391, 95.761, 97.3583, 98.9066, 100.408, 101.842, 103.258, 104.632, 105.969, 107.247, 108.512, 109.743, 110.941, 112.09, 113.228, 114.338, 115.42, 116.475, 117.489, 118.496, 119.478, 120.438, 121.362, 122.279, 123.177, 124.054, 124.899, 125.186, 138.107, 147.468, 154.587, 160.21, 164.765, 168.54, 171.718, 174.437, 176.785, 178.839, 180.647, 182.253, 183.691, 184.983, 186.153, 187.215, 188.186, 189.075, 189.894, 190.649, 191.349, 191.998, 192.603, 193.168, 193.696, 194.192, 194.657, 195.096, 195.509, 195.899, 196.268, 196.619, 196.95, 197.266, 197.566, 197.852, 198.125, 198.385, 198.634
};

const G4double G4BaryonPartialWidth::pwN1720_Ngamma[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
const G4double G4BaryonPartialWidth::pwN1720_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.346639, 2.30696, 4.43983, 6.6684, 8.90235, 11.1795, 13.4394, 15.6666, 17.8162, 19.9526, 22.0368, 24.0671, 26.0117, 27.9348, 29.8051, 31.6241, 33.3651, 35.0871, 36.7629, 38.3942, 39.9831, 41.5065, 43.016, 44.4881, 45.9243, 47.3038, 48.6732, 50.0109, 51.3183, 52.5762, 53.827, 55.0508, 56.2488, 57.4032, 58.5528, 59.6792, 60.7834, 61.8661, 62.9112, 63.9535, 64.9764, 65.9807, 66.9511, 67.92, 68.872, 69.8075, 70.7124, 71.6167, 72.5061, 73.3808, 74.2277, 75.0748, 75.9085, 76.7292, 77.5372, 78.3202, 79.1042, 79.8764, 80.6373, 81.3751, 82.1142, 82.8427, 83.561, 84.2579, 84.4955, 95.8747, 105.026, 112.571, 118.925, 124.35, 129.049, 133.154, 136.78, 140, 142.886, 145.483, 147.834, 149.975, 151.93, 153.725, 155.377, 156.904, 158.317, 159.632, 160.856, 162, 163.071, 164.075, 165.019, 165.908, 166.747, 167.539, 168.29, 169.001, 169.676, 170.317, 170.928, 171.51, 172.064, 172.594, 173.101, 173.586, 174.05, 174.495
};
const G4double G4BaryonPartialWidth::pwN1720_Nrho[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00182001, 0.0204155, 0.096773, 0.329257, 0.976147, 2.77061, 8.56868, 28.9772, 76.8129, 135.836, 194.657, 249.233, 299.318, 344.554, 386.871, 425.918, 462.07, 495.649, 526.445, 555.703, 583.104, 608.829, 632.652, 655.491, 677.062, 697.472, 716.511, 734.886, 752.354, 768.98, 784.577, 799.709, 814.167, 827.993, 841.231, 853.717, 865.895, 877.587, 888.823, 899.458, 909.866, 919.89, 929.554, 938.727, 947.73, 956.426, 964.83, 972.829, 980.698, 988.316, 995.696, 1002.85, 1009.67, 1016.41, 1022.94, 1029.29, 1035.35, 1041.35, 1047.18, 1052.85, 1058.27, 1060.11, 1139.39, 1192.69, 1230.56, 1257.6, 1281.71, 1307.85, 1311.05, 1315.64, 1377.15, 1346.13, 1311.29, 1324.42, 1404.07, 1492.87, 1449.92, 1344.12, 1297.6, 1305.46, 1302.65, 1277.16, 1277.76, 1343.12, 1477.72, 1652.75, 1803.79, 1856.5, 1784.41, 1630, 1457.64, 1309.28, 1201.29, 1135.31, 1108.35, 1116.3, 1154.99, 1218.99, 1300.02, 1384.89, 1456.37
};
const G4double G4BaryonPartialWidth::pwN1720_Npipi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.283212, 9.03259, 17.7817, 26.4455, 34.8655, 43.0307, 50.8116, 58.464, 65.8635, 73.0172, 79.8247, 86.5186, 92.9959, 99.2666, 105.245, 111.135, 116.848, 122.393, 127.778, 132.927, 138.017, 142.969, 147.79, 152.411, 156.989, 161.454, 165.81, 169.994, 174.148, 178.206, 182.173, 185.991, 189.787, 193.503, 197.14, 200.703, 204.138, 207.561, 210.916, 214.206, 217.383, 220.552, 223.662, 226.716, 229.667, 232.614, 235.51, 238.356, 241.11, 243.861, 246.568, 249.23, 251.849, 254.386, 256.923, 259.421, 261.881, 264.265, 266.651, 269.002, 271.319, 273.565, 274.33, 310.825, 339.951, 363.82, 383.827, 400.843, 415.531, 428.328, 439.602, 449.596, 458.533, 466.562, 473.821, 480.422, 486.441, 491.962, 497.036, 501.722, 506.058, 510.087, 513.835, 517.336, 520.608, 523.677, 526.561, 529.274, 531.835, 534.251, 536.539, 538.705, 540.761, 542.714, 544.572, 546.341, 548.028, 549.64, 551.179, 552.652, 554.062, 555.414
};
const G4double G4BaryonPartialWidth::pwN1720_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.00294e-07, 0.00505738, 0.101725, 0.883468, 2.82879, 5.37882, 8.1798, 11.192, 14.2932, 17.431, 20.5188, 23.6324, 26.7031, 29.7181, 32.622, 35.5043, 38.3136, 41.0481, 43.7073, 46.2504, 48.7617, 51.2004, 53.5684, 55.8309, 58.0643, 60.2332, 62.3398, 64.3538, 66.3433, 68.2771, 70.1574, 71.9569, 73.7368, 75.469, 77.1554, 78.7977, 80.3721, 81.9319, 83.4525, 84.9353, 86.3587, 87.7706, 89.1488, 90.4946, 91.7881, 93.073, 94.3286, 95.556, 96.7369, 97.9108, 99.0594, 100.184, 101.285, 102.346, 103.403, 104.439, 105.454, 106.432, 107.406, 108.36, 109.294, 110.196, 110.502, 124.604, 135.524, 143.021, 148.751, 157.323, 165.403, 166.891, 163.866, 161.947, 162.45, 163.479, 163.594, 163.318, 164.25, 167.787, 174.649, 184.996, 198.559, 214.796, 232.807, 251.45, 269.266, 284.734, 296.446, 303.345, 304.985, 301.539, 293.699, 282.492, 268.995, 254.242, 239.033, 224.005, 209.557, 195.928, 183.273, 171.613, 160.959, 151.249
};
const G4double G4BaryonPartialWidth::pwN1720_LK[120] =  
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.55867, 6.63645, 10.335, 13.6974, 16.8827, 19.8662, 22.6719, 25.2769, 27.7822, 30.1567, 32.4117, 34.557, 36.5691, 38.5214, 40.3871, 42.1723, 43.8555, 45.4968, 47.0727, 48.5873, 50.0212, 51.4251, 52.7781, 54.0831, 55.3228, 56.5405, 57.7177, 58.8565, 59.959, 61.01, 62.0457, 63.0501, 64.0249, 64.9563, 65.8762, 66.7702, 67.6396, 68.472, 69.2956, 70.0977, 70.879, 71.6283, 72.371, 73.0953, 73.8021, 74.4919, 75.1547, 75.8129, 76.4559, 77.0844, 77.689, 78.2901, 78.8781, 79.4535, 80.0077, 80.1959, 88.6978, 94.8896, 99.6179, 103.364, 106.407, 108.935, 111.067, 112.893, 114.473, 115.856, 117.075, 118.159, 119.13, 120.004, 120.795, 121.514, 122.172, 122.774, 123.329, 123.841, 124.316, 124.757, 125.168, 125.552, 125.91, 126.247, 126.564, 126.862, 127.143, 127.408, 127.66, 127.898, 128.124, 128.338, 128.543, 128.738, 128.923, 129.101, 129.27
};

const G4double G4BaryonPartialWidth::pwN1900_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.22722, 14.8739, 28.6939, 43.1843, 57.7547, 72.6492, 87.4718, 102.117, 116.287, 130.404, 144.208, 157.685, 170.621, 183.441, 195.935, 208.111, 219.788, 231.359, 242.641, 253.644, 264.38, 274.692, 284.928, 294.928, 304.699, 314.101, 323.448, 332.594, 341.546, 350.173, 358.764, 367.182, 375.435, 383.398, 391.339, 399.132, 406.781, 414.291, 421.55, 428.799, 435.922, 442.924, 449.699, 456.472, 463.134, 469.688, 476.036, 482.387, 488.64, 494.798, 500.765, 506.741, 512.629, 518.431, 524.149, 529.696, 535.256, 540.738, 546.145, 551.392, 556.655, 561.847, 566.971, 571.946, 573.645, 655.577, 722.389, 778.1, 825.475, 866.257, 901.83, 933.103, 960.872, 985.662, 1007.97, 1028.12, 1046.44, 1063.17, 1078.49, 1092.59, 1105.6, 1117.65, 1128.84, 1139.26, 1148.98, 1158.09, 1166.61, 1174.63, 1182.18, 1189.29, 1196.01, 1202.37, 1208.4, 1214.11, 1219.55, 1224.71, 1229.64, 1234.33, 1238.81, 1243.09, 1247.19, 1251.12, 1254.88, 1258.48
};
const G4double G4BaryonPartialWidth::pwN1900_Nomega[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.12005e-05, 0.00021688, 0.00131956, 0.005832, 0.0284025, 0.441936, 110.086, 235.357, 352.791, 458.13, 570.692, 638.147, 720.69, 850.82, 951.843, 918.713, 1100.61, 1195.9, 1090.62, 1127.17, 1218.04, 1553.53, 1241.32, 1272.76, 1308.49, 1303.96, 1459.82, 2255.37, 1438.09, 1550.33, 2077.49, 1399.96, 1376.93, 1871.1, 1428.66, 1854.76, 1380.62, 1375.62, 2420.28, 2053.95, 2474.51, 1511.58, 1985.58, 2590.96, 1762.13, 2315.95, 1377.33, 4715.34, 1290.08, 2533.51, 1352.18, 5333.34, 1537.54, 2032.81, 1663.93, 1669.98, 6121.34, 1686.18, 1425.21, 2102.51, 1376.88, 824.621, 706.757, 17208.3, 3819.77, 18874.1, 504.521, 964.869, 857.523, 8503.25, 381.199, 519.275, 20638.6, 573.128, 240.8, 366.661, 1275.07, 14851.5, 7992.36, 1128.33, 395.654, 217.013, 165.306, 167.134, 220.72, 382.002, 893.659, 3262.12, 31784.2, 7533.8, 1625.42, 642.535, 338.849, 214.68, 155.282, 124.342, 107.814, 99.6581, 97.0177
};
const G4double G4BaryonPartialWidth::pwN1900_Nrho[120] =  
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.000238211, 0.00267676, 0.0127227, 0.0434716, 0.12976, 0.372459, 1.17636, 4.14204, 11.5931, 21.4607, 31.8886, 42.0353, 51.723, 60.7743, 69.4982, 77.7696, 85.6199, 93.0802, 100.068, 106.84, 113.303, 119.479, 125.296, 130.963, 136.399, 141.619, 146.559, 151.392, 156.047, 160.536, 164.798, 168.984, 173.03, 176.943, 180.732, 184.343, 187.901, 191.353, 194.703, 197.904, 201.066, 204.139, 207.129, 209.992, 212.825, 215.585, 218.274, 220.853, 223.411, 225.906, 228.341, 230.719, 233.004, 235.274, 237.492, 239.661, 241.748, 243.824, 245.856, 247.844, 249.759, 250.409, 279.872, 301.413, 317.798, 330.365, 341.489, 352.739, 356.777, 360.867, 381.693, 374.563, 366.032, 371.722, 397.344, 425.677, 414.025, 383.214, 370.245, 373.65, 373.744, 366.891, 367.896, 388.531, 430.223, 484.263, 531.008, 547.728, 526.316, 479.745, 427.686, 382.943, 350.493, 330.826, 323.019, 325.823, 337.982, 357.85, 382.916, 409.157, 431.302
};
const G4double G4BaryonPartialWidth::pwN1900_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.22524e-07, 0.00561103, 0.113092, 0.987611, 3.18352, 6.08921, 9.30788, 12.796, 16.4127, 20.0967, 23.7446, 27.4448, 31.1147, 34.7377, 38.2451, 41.7439, 45.1705, 48.5213, 51.7945, 54.9384, 58.0561, 61.0961, 64.0596, 66.9022, 69.7187, 72.464, 75.1399, 77.7072, 80.2519, 82.7337, 85.1545, 87.479, 89.7851, 92.0364, 94.2346, 96.3818, 98.446, 100.497, 102.502, 104.462, 106.349, 108.225, 110.062, 111.859, 113.592, 115.316, 117.006, 118.661, 120.258, 121.848, 123.408, 124.938, 126.439, 127.89, 129.338, 130.759, 132.155, 133.503, 134.847, 136.167, 137.462, 138.714, 139.14, 159.044, 174.832, 186.025, 194.779, 207.367, 219.266, 222.054, 218.541, 216.476, 217.702, 219.613, 220.216, 220.242, 221.915, 227.191, 237.089, 251.853, 271.12, 294.145, 319.673, 346.102, 371.38, 393.365, 410.068, 419.997, 422.521, 417.88, 407.048, 391.466, 372.655, 352.068, 330.832, 309.844, 289.667, 270.637, 252.97, 236.699, 221.839, 208.302
};

const G4double G4BaryonPartialWidth::pwN1990_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00176227, 0.0826059, 0.334496, 0.817416, 1.5651, 2.63853, 4.05379, 5.82656, 7.92581, 10.4183, 13.263, 16.4439, 19.8808, 23.6609, 27.701, 31.9696, 36.3602, 40.9836, 45.7359, 50.5843, 55.4978, 60.3671, 65.3249, 70.2669, 75.1709, 79.9395, 84.7123, 89.3958, 93.9778, 98.377, 102.73, 106.957, 111.054, 114.955, 118.785, 122.481, 126.041, 129.467, 132.709, 135.875, 138.915, 141.831, 144.583, 147.265, 149.835, 152.296, 154.615, 156.873, 159.035, 161.104, 163.053, 164.951, 166.767, 168.505, 170.17, 171.738, 173.266, 174.729, 176.131, 177.453, 178.741, 179.976, 181.16, 182.277, 182.652, 196.909, 204.232, 208.34, 210.826, 212.421, 213.496, 214.249, 214.794, 215.2, 215.509, 215.749, 215.938, 216.091, 216.215, 216.317, 216.402, 216.474, 216.534, 216.586, 216.631, 216.669, 216.703, 216.732, 216.758, 216.781, 216.802, 216.82, 216.837, 216.851, 216.865, 216.877, 216.888, 216.898, 216.907, 216.915, 216.923, 216.93, 216.936, 216.942
};
const G4double G4BaryonPartialWidth::pwN1990_Nrho[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.32065e-09, 1.74362e-07, 4.13558e-06, 5.07385e-05, 0.000476144, 0.00415139, 0.0444789, 0.610455, 5.38562, 20.1799, 47.1646, 84.5046, 129.401, 178.172, 229.985, 282.149, 333.287, 382.479, 428.437, 472.378, 513.419, 551.577, 586.399, 619.167, 649.457, 677.447, 702.913, 726.862, 749.022, 769.549, 788.285, 805.975, 822.418, 837.721, 851.982, 865.082, 877.53, 889.175, 900.083, 910.155, 919.773, 928.815, 937.326, 945.221, 952.795, 959.948, 966.71, 973.009, 979.077, 984.829, 990.289, 995.476, 1000.33, 1005.02, 1009.5, 1013.76, 1017.76, 1021.64, 1025.35, 1028.9, 1032.23, 1033.35, 1075.66, 1097.98, 1110.85, 1117.85, 1124.87, 1135.33, 1129.1, 1125.22, 1167.18, 1136.99, 1104.54, 1110.42, 1168.98, 1235.02, 1198, 1112.04, 1072.87, 1076.58, 1072.1, 1050.03, 1048.59, 1098.03, 1201.78, 1337.21, 1453.89, 1493.69, 1435.94, 1313.88, 1177.85, 1060.68, 975.149, 922.562, 900.57, 905.949, 935.431, 984.748, 1047.41, 1113.1, 1168.31
};
const G4double G4BaryonPartialWidth::pwN1990_Npipi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00125527, 0.730498, 3.09155, 7.39299, 13.768, 22.307, 32.8498, 45.7194, 60.6914, 77.6562, 96.1541, 116.626, 138.595, 161.861, 185.818, 211.045, 236.956, 263.355, 290.055, 316.454, 343.263, 369.909, 396.27, 421.822, 447.313, 472.246, 496.557, 519.822, 542.767, 564.977, 586.436, 606.805, 626.75, 645.934, 664.364, 682.052, 698.747, 715.012, 730.588, 745.498, 759.537, 773.189, 786.243, 798.723, 810.463, 821.872, 832.775, 843.196, 852.999, 862.526, 871.633, 880.341, 888.667, 896.505, 904.129, 911.423, 918.404, 924.982, 931.386, 937.52, 943.397, 948.94, 950.796, 1021.17, 1057.14, 1077.3, 1089.52, 1097.37, 1102.68, 1106.41, 1109.11, 1111.13, 1112.67, 1113.87, 1114.82, 1115.59, 1116.21, 1116.72, 1117.15, 1117.52, 1117.82, 1118.09, 1118.31, 1118.51, 1118.68, 1118.83, 1118.96, 1119.08, 1119.19, 1119.28, 1119.37, 1119.44, 1119.51, 1119.57, 1119.63, 1119.68, 1119.73, 1119.77, 1119.81, 1119.85, 1119.88, 1119.91
};
const G4double G4BaryonPartialWidth::pwN1990_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.2621e-14, 2.92857e-06, 0.00123232, 0.101783, 1.15807, 4.6006, 11.5444, 23.245, 40.3923, 63.4413, 92.0021, 126.831, 167.062, 212.039, 260.155, 312.133, 366.339, 421.934, 478.147, 533.401, 588.941, 643.39, 696.378, 746.816, 796.161, 843.441, 888.584, 930.885, 971.74, 1010.47, 1047.14, 1081.27, 1114.06, 1145.02, 1174.25, 1201.84, 1227.47, 1252.06, 1275.28, 1297.21, 1317.6, 1337.19, 1355.71, 1373.23, 1389.56, 1405.28, 1420.18, 1434.3, 1447.49, 1460.21, 1472.3, 1483.79, 1494.73, 1504.98, 1514.91, 1524.38, 1533.4, 1541.87, 1550.08, 1557.9, 1565.37, 1572.39, 1574.74, 1663.43, 1713.09, 1732.82, 1741.61, 1781.95, 1821.56, 1805.58, 1753.14, 1713.95, 1698.86, 1690.52, 1675.92, 1659.44, 1654.82, 1673.92, 1722.69, 1802.15, 1909.71, 2040.47, 2186.64, 2338.39, 2483.29, 2608.43, 2701.84, 2754.59, 2762.9, 2728.27, 2656.56, 2556.48, 2437.19, 2307.44, 2174.02, 2042.33, 1915.74, 1796.28, 1685.25, 1582.83, 1489.11, 1403.54
};
const G4double G4BaryonPartialWidth::pwN1990_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.41404e-15, 3.63254e-07, 3.88625e-05, 0.000863552, 0.00986111, 0.0777349, 0.443222, 1.90753, 6.04437, 14.8762, 29.958, 53.0053, 84.1916, 122.98, 167.343, 217.082, 269.723, 323.598, 377.311, 428.96, 479.493, 527.57, 572.928, 614.802, 654.576, 691.628, 726.088, 757.617, 787.415, 815.116, 840.886, 864.507, 886.901, 907.802, 927.334, 945.613, 962.475, 978.565, 993.684, 1007.91, 1021.1, 1033.76, 1045.71, 1057.01, 1067.54, 1077.69, 1087.33, 1096.47, 1105.03, 1113.32, 1121.21, 1128.73, 1135.91, 1142.66, 1149.23, 1155.5, 1161.51, 1167.18, 1172.7, 1178, 1183.08, 1187.89, 1189.51, 1252.77, 1288.51, 1310.89, 1325.99, 1336.69, 1344.65, 1350.6, 1355.28, 1359.49, 1362.92, 1364.82, 1365.42, 1365.98, 1367.74, 1371.25, 1376.25, 1381.79, 1386.52, 1389.15, 1388.82, 1385.4, 1379.4, 1371.76, 1363.51, 1355.55, 1348.48, 1342.58, 1337.87, 1334.2, 1331.37, 1329.19, 1327.55, 1326.45, 1326, 1326.36, 1327.78, 1330.52, 1334.81, 1340.88
};
const G4double G4BaryonPartialWidth::pwN1990_LK[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.612161, 4.78512, 12.8015, 24.142, 38.7329, 55.8801, 75.0163, 95.2451, 116.722, 138.674, 160.716, 182.538, 203.558, 224.284, 244.239, 263.335, 281.237, 298.508, 314.846, 330.265, 344.563, 358.243, 371.1, 383.178, 394.341, 404.999, 415.005, 424.401, 433.227, 441.39, 449.194, 456.534, 463.443, 469.846, 475.983, 481.77, 487.231, 492.307, 497.184, 501.797, 506.162, 510.232, 514.153, 517.873, 521.403, 524.755, 527.892, 530.924, 533.811, 536.559, 539.137, 541.637, 544.022, 546.299, 548.44, 549.155, 575.921, 589.598, 597.441, 602.337, 605.584, 607.847, 609.482, 610.703, 611.636, 612.367, 612.948, 613.418, 613.804, 614.124, 614.393, 614.62, 614.815, 614.982, 615.128, 615.254, 615.366, 615.464, 615.551, 615.629, 615.698, 615.761, 615.817, 615.868, 615.914, 615.956, 615.995, 616.03, 616.062, 616.092, 616.119, 616.144, 616.168, 616.19, 616.21
};

const G4double G4BaryonPartialWidth::pwN2090_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.161627, 2.90013, 8.13026, 15.6123, 24.9935, 36.3932, 49.4808, 64.0679, 79.7096, 96.7535, 114.799, 133.703, 153.016, 173.253, 193.997, 215.151, 236.278, 257.993, 279.88, 301.877, 323.924, 345.614, 367.614, 389.526, 411.313, 432.595, 454.041, 475.277, 496.279, 516.696, 537.18, 557.381, 577.286, 596.572, 615.862, 634.832, 653.475, 671.788, 689.481, 707.132, 724.448, 741.428, 757.809, 774.128, 790.116, 805.777, 820.868, 835.888, 850.591, 864.982, 878.839, 892.622, 906.106, 919.297, 932.199, 944.617, 956.963, 969.036, 980.843, 992.204, 1003.5, 1014.54, 1025.34, 1035.73, 1039.25, 1195, 1300.13, 1372.94, 1424.96, 1463.11, 1491.85, 1513.92, 1531.25, 1545.06, 1556.24, 1565.4, 1573.01, 1579.39, 1584.79, 1589.4, 1593.37, 1596.8, 1599.8, 1602.43, 1604.74, 1606.8, 1608.63, 1610.26, 1611.73, 1613.05, 1614.24, 1615.33, 1616.31, 1617.21, 1618.04, 1618.79, 1619.49, 1620.13, 1620.72, 1621.26, 1621.77, 1622.24, 1622.68, 1623.09
};
const G4double G4BaryonPartialWidth::pwN2090_Neta[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.378193, 1.66226, 3.42324, 5.49134, 7.78152, 10.1957, 12.771, 15.4361, 18.1648, 20.8905, 23.6855, 26.4905, 29.2934, 32.0841, 34.8095, 37.5521, 40.2611, 42.9317, 45.518, 48.1014, 50.6369, 53.1223, 55.5173, 57.8994, 60.2282, 62.5033, 64.6891, 66.8575, 68.9723, 71.0341, 73.0434, 74.9698, 76.8772, 78.7344, 80.5425, 82.2744, 83.9879, 85.6553, 87.2777, 88.831, 90.3672, 91.8618, 93.3157, 94.7075, 96.084, 97.4231, 98.7258, 99.9932, 101.207, 102.407, 103.575, 104.712, 105.801, 106.878, 107.926, 108.947, 109.925, 110.256, 124.422, 133.507, 139.588, 143.832, 146.892, 149.169, 150.902, 152.252, 153.321, 154.184, 154.888, 155.471, 155.958, 156.37, 156.721, 157.022, 157.283, 157.51, 157.709, 157.885, 158.04, 158.178, 158.301, 158.412, 158.512, 158.602, 158.683, 158.758, 158.826, 158.888, 158.944, 158.997, 159.045, 159.089, 159.13, 159.168, 159.204, 159.237, 159.267
};
const G4double G4BaryonPartialWidth::pwN2090_Nrho[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.210585, 0.690415, 1.47302, 2.6687, 4.52749, 7.55397, 13.2798, 24.8815, 41.9276, 57.4065, 70.2142, 80.707, 89.4948, 96.8826, 103.394, 109.1, 114.148, 118.65, 122.629, 126.284, 129.6, 132.621, 135.342, 137.883, 140.223, 142.384, 144.354, 146.214, 147.944, 149.558, 151.041, 152.453, 153.777, 155.02, 156.189, 157.273, 158.312, 159.294, 160.222, 161.087, 161.92, 162.711, 163.462, 164.164, 164.844, 165.492, 166.109, 166.689, 167.252, 167.789, 168.304, 168.796, 169.26, 169.712, 170.146, 170.562, 170.955, 171.339, 171.708, 172.063, 172.399, 172.512, 176.982, 179.523, 181.056, 181.876, 182.818, 184.385, 183.297, 182.611, 189.358, 184.442, 179.165, 180.097, 189.568, 200.256, 194.25, 180.316, 173.964, 174.559, 173.828, 170.248, 170.011, 178.02, 194.833, 216.783, 235.695, 242.144, 232.782, 212.995, 190.946, 171.953, 158.089, 149.565, 146, 146.871, 151.649, 159.642, 169.799, 180.446, 189.395
};
const G4double G4BaryonPartialWidth::pwN2090_Npipi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00259002, 0.35705, 1.03541, 1.95679, 3.06954, 4.34353, 5.7308, 7.25652, 8.88114, 10.589, 12.337, 14.1704, 16.0502, 17.9665, 19.8792, 21.8434, 23.8211, 25.806, 27.7929, 29.7448, 31.7216, 33.6876, 35.6392, 37.5427, 39.4579, 41.3512, 43.2208, 45.0354, 46.8532, 48.6431, 50.4042, 52.1078, 53.8094, 55.4802, 57.1199, 58.7283, 60.2801, 61.8261, 63.3408, 64.8242, 66.2533, 67.6753, 69.0667, 70.428, 71.7382, 73.0408, 74.3144, 75.5595, 76.7573, 77.9473, 79.1104, 80.247, 81.3576, 82.4255, 83.4863, 84.5226, 85.5352, 86.5086, 87.4755, 88.4201, 89.343, 90.2302, 90.531, 103.745, 112.578, 118.654, 122.976, 126.135, 128.508, 130.328, 131.754, 132.889, 133.808, 134.56, 135.184, 135.707, 136.15, 136.527, 136.852, 137.134, 137.379, 137.594, 137.783, 137.951, 138.101, 138.235, 138.355, 138.463, 138.56, 138.649, 138.73, 138.803, 138.871, 138.932, 138.989, 139.041, 139.089, 139.134, 139.176, 139.214, 139.25, 139.283
};
const G4double G4BaryonPartialWidth::pwN2090_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.000942882, 0.251914, 1.11307, 3.25234, 5.79103, 7.93848, 9.72683, 11.3005, 12.6827, 13.9099, 14.9911, 15.9811, 16.8765, 17.6898, 18.4198, 19.0989, 19.7218, 20.2947, 20.823, 21.3036, 21.7564, 22.1766, 22.5673, 22.9256, 23.2656, 23.5835, 23.881, 24.1556, 24.4178, 24.6643, 24.8963, 25.1116, 25.3181, 25.5133, 25.6978, 25.8726, 26.0356, 26.1928, 26.3421, 26.484, 26.6168, 26.7454, 26.868, 26.9848, 27.0946, 27.2012, 27.3031, 27.4006, 27.4923, 27.5816, 27.6671, 27.7492, 27.828, 27.9025, 27.9754, 28.0455, 28.1129, 28.1766, 28.2388, 28.2985, 28.3558, 28.41, 28.4282, 29.1613, 29.6463, 29.799, 29.8435, 30.4585, 31.0868, 30.7902, 29.8834, 29.2049, 28.9377, 28.7875, 28.533, 28.2478, 28.165, 28.4858, 29.3112, 30.659, 32.4852, 34.7065, 37.1902, 39.7694, 42.2325, 44.3598, 45.9478, 46.8445, 46.9857, 46.3966, 45.1771, 43.4753, 41.4467, 39.2404, 36.9716, 34.7322, 32.5797, 30.5483, 28.6603, 26.9187, 25.3251, 23.8702
};

const G4double G4BaryonPartialWidth::pwN2190_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0004401, 0.0530579, 0.309607, 0.962228, 2.20588, 4.3179, 7.53169, 12.0952, 18.1347, 26.0685, 36.0103, 48.1283, 62.3012, 79.0792, 98.2879, 119.916, 143.494, 169.684, 197.96, 228.12, 259.93, 292.585, 326.881, 362.009, 397.685, 433.052, 469.013, 504.747, 540.039, 574.145, 608.023, 640.971, 672.883, 703.185, 732.813, 761.221, 788.385, 814.3, 838.586, 862.055, 884.327, 905.435, 925.104, 944.021, 961.901, 978.79, 994.485, 1009.55, 1023.76, 1037.17, 1049.63, 1061.57, 1072.85, 1083.48, 1093.53, 1102.86, 1111.82, 1120.28, 1128.28, 1135.73, 1142.89, 1149.66, 1156.07, 1162.05, 1164.04, 1233.14, 1263.3, 1278.46, 1287.01, 1292.24, 1295.66, 1298.02, 1299.71, 1300.96, 1301.92, 1302.67, 1303.26, 1303.75, 1304.14, 1304.47, 1304.75, 1304.98, 1305.19, 1305.36, 1305.51, 1305.65, 1305.76, 1305.87, 1305.96, 1306.04, 1306.12, 1306.19, 1306.25, 1306.3, 1306.35, 1306.4, 1306.44, 1306.48, 1306.51, 1306.54, 1306.58, 1306.6, 1306.63, 1306.65
};
const G4double G4BaryonPartialWidth::pwN2190_Nrho[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5.18465e-07, 1.99956e-05, 0.000212542, 0.00137833, 0.00731313, 0.0367319, 0.215238, 1.51662, 7.6822, 20.6595, 39.4201, 62.1952, 87.8444, 115.092, 144.232, 174.368, 205.136, 236.25, 266.979, 298.149, 329.111, 359.747, 389.482, 419.218, 448.406, 477.001, 504.525, 531.857, 558.524, 584.517, 609.426, 634.07, 658.037, 681.334, 703.968, 725.602, 746.955, 767.682, 787.796, 807.002, 825.946, 844.322, 862.147, 879.162, 895.94, 912.214, 928, 943.069, 957.931, 972.349, 986.338, 999.912, 1012.88, 1025.67, 1038.08, 1050.14, 1061.65, 1073.02, 1084.07, 1094.79, 1105.05, 1108.51, 1254.49, 1345.65, 1405.12, 1444.3, 1475.72, 1506.83, 1509.98, 1513.99, 1581.78, 1544.7, 1503.49, 1516.16, 1602.88, 1699.22, 1649.29, 1529.95, 1476.55, 1483.54, 1478.75, 1448.99, 1448.19, 1518.88, 1665.63, 1856.43, 2020.57, 2076.81, 1996.41, 1825.89, 1635.73, 1471.88, 1352.33, 1278.96, 1248.52, 1256.49, 1298.24, 1367.72, 1455.82, 1548.06, 1625.57
};
const G4double G4BaryonPartialWidth::pwN2190_Npipi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.86494e-05, 0.0455491, 0.280589, 0.849874, 1.88598, 3.52032, 5.83418, 9.01852, 13.1455, 18.3029, 24.4484, 31.8282, 40.371, 50.0707, 60.7116, 72.5851, 85.4443, 99.1871, 113.695, 128.588, 144.22, 160.21, 176.419, 192.453, 208.714, 224.827, 240.693, 255.978, 271.112, 285.783, 299.945, 313.351, 326.417, 338.906, 350.813, 362.139, 372.724, 382.926, 392.584, 401.715, 410.205, 418.353, 426.039, 433.285, 440.008, 446.45, 452.519, 458.237, 463.541, 468.623, 473.413, 477.928, 482.186, 486.14, 489.934, 493.516, 496.899, 500.046, 503.07, 505.931, 508.638, 511.16, 511.998, 541.143, 553.912, 560.385, 564.062, 566.331, 567.828, 568.864, 569.613, 570.172, 570.6, 570.936, 571.204, 571.422, 571.601, 571.751, 571.877, 571.985, 572.077, 572.157, 572.226, 572.288, 572.341, 572.389, 572.432, 572.47, 572.504, 572.535, 572.563, 572.588, 572.611, 572.632, 572.652, 572.669, 572.686, 572.701, 572.715, 572.728, 572.74, 572.751
};
const G4double G4BaryonPartialWidth::pwN2190_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.04055e-11, 7.31546e-05, 0.00678539, 0.183967, 1.12409, 3.11909, 6.14224, 10.2743, 15.4269, 21.5318, 28.3888, 36.136, 44.5772, 53.6228, 63.0286, 73.0219, 83.3758, 94.0195, 104.888, 115.745, 126.892, 138.107, 149.347, 160.394, 171.578, 182.69, 193.705, 204.427, 215.189, 225.8, 236.247, 246.356, 256.448, 266.35, 276.057, 285.565, 294.722, 303.829, 312.731, 321.429, 329.789, 338.086, 346.183, 354.083, 361.666, 369.184, 376.513, 383.657, 390.508, 397.293, 403.906, 410.349, 416.628, 422.651, 428.619, 434.433, 440.097, 445.523, 450.894, 456.121, 461.208, 466.084, 467.733, 538.798, 586.171, 613.924, 631.976, 659.665, 684.315, 683.962, 667.317, 655.283, 652.482, 651.886, 648.288, 643.579, 643.416, 652.64, 673.636, 706.792, 751.02, 804.336, 863.611, 924.93, 983.355, 1033.76, 1071.4, 1092.75, 1096.31, 1082.7, 1054.28, 1014.51, 967.06, 915.422, 862.3, 809.853, 759.43, 711.837, 667.597, 626.784, 589.437, 555.338
};
const G4double G4BaryonPartialWidth::pwN2190_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.29974e-20, 1.54597e-10, 5.33523e-08, 2.59886e-06, 5.51247e-05, 0.000736056, 0.00656451, 0.0413684, 0.17909, 0.570698, 1.42871, 3.07386, 5.82548, 9.99775, 15.7267, 23.3229, 32.6792, 43.6128, 55.8135, 68.6774, 82.2228, 95.8633, 109.278, 122.017, 134.332, 145.906, 156.692, 166.528, 175.754, 184.243, 192.043, 199.096, 205.686, 211.746, 217.325, 222.469, 227.147, 231.55, 235.632, 239.424, 242.899, 246.195, 249.274, 252.157, 254.818, 257.36, 259.752, 262.006, 264.101, 266.114, 268.02, 269.827, 271.542, 273.146, 274.697, 276.175, 277.584, 278.908, 280.193, 281.423, 282.6, 283.709, 284.081, 298.44, 306.441, 311.448, 314.834, 317.244, 319.045, 320.393, 321.459, 322.425, 323.214, 323.644, 323.773, 323.893, 324.3, 325.126, 326.305, 327.613, 328.73, 329.349, 329.269, 328.455, 327.03, 325.216, 323.259, 321.372, 319.694, 318.295, 317.177, 316.307, 315.634, 315.117, 314.727, 314.466, 314.357, 314.443, 314.78, 315.428, 316.444, 317.883
};

const G4double G4BaryonPartialWidth::pwN2220_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.49404e-05, 0.00764588, 0.0641504, 0.252857, 0.691767, 1.56638, 3.08952, 5.52031, 9.0851, 14.2229, 21.2337, 30.476, 42.091, 56.789, 74.6965, 96.0504, 120.578, 149.151, 181.357, 217.048, 255.964, 297.05, 341.212, 387.288, 434.73, 482.192, 530.686, 578.921, 626.429, 672.066, 716.997, 760.196, 801.463, 840.049, 877.139, 912.054, 944.8, 975.419, 1003.53, 1030.14, 1054.86, 1077.81, 1098.75, 1118.47, 1136.74, 1153.65, 1169.05, 1183.56, 1197, 1209.44, 1220.8, 1231.51, 1241.45, 1250.68, 1259.26, 1267.11, 1274.55, 1281.47, 1287.93, 1293.87, 1299.51, 1304.78, 1309.72, 1314.27, 1315.78, 1364.9, 1384.71, 1394.57, 1400.26, 1403.87, 1406.33, 1408.09, 1409.4, 1410.41, 1411.2, 1411.83, 1412.35, 1412.78, 1413.13, 1413.44, 1413.69, 1413.92, 1414.11, 1414.28, 1414.42, 1414.55, 1414.67, 1414.77, 1414.86, 1414.94, 1415.02, 1415.09, 1415.15, 1415.2, 1415.26, 1415.3, 1415.35, 1415.38, 1415.42, 1415.46, 1415.49, 1415.52, 1415.54, 1415.57
};
const G4double G4BaryonPartialWidth::pwN2220_Nrho[120] =
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.10251e-10, 5.41776e-08, 1.28511e-06, 1.57674e-05, 0.000147971, 0.00129023, 0.0138288, 0.190284, 1.70005, 6.5486, 15.9471, 30.0492, 48.6884, 71.1133, 97.6072, 127.319, 159.706, 194.231, 229.779, 267.039, 304.998, 343.262, 380.876, 418.786, 456.132, 492.716, 527.814, 562.458, 595.977, 628.31, 658.925, 688.81, 717.448, 744.85, 771.035, 795.637, 819.495, 842.236, 863.899, 884.204, 903.858, 922.565, 940.37, 957.048, 973.189, 988.553, 1003.18, 1016.89, 1030.17, 1042.82, 1054.87, 1066.37, 1077.15, 1087.62, 1097.61, 1107.14, 1116.11, 1124.82, 1133.15, 1141.11, 1148.6, 1151.11, 1245.43, 1293.47, 1320.29, 1335.26, 1347.8, 1363.15, 1357.3, 1353.83, 1405.63, 1369.68, 1330.88, 1338.4, 1409.57, 1489.64, 1445.06, 1341.3, 1294.1, 1298.7, 1293.38, 1266.81, 1265.14, 1324.94, 1450.29, 1613.87, 1754.78, 1802.83, 1733.11, 1585.76, 1421.54, 1280.08, 1176.82, 1113.34, 1086.81, 1093.33, 1128.95, 1188.51, 1264.18, 1343.5, 1410.16
};
const G4double G4BaryonPartialWidth::pwN2220_Npipi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9.90157e-07, 0.0101514, 0.0906523, 0.3463, 0.911455, 1.95034, 3.61961, 6.18344, 9.84869, 14.8523, 21.3104, 29.6554, 39.9934, 52.4844, 66.9802, 84.0009, 103.302, 124.783, 148.269, 173.098, 199.794, 227.625, 256.233, 284.787, 313.877, 342.714, 371.011, 398.088, 424.638, 450.06, 474.246, 496.771, 518.341, 538.569, 557.475, 575.094, 591.222, 606.444, 620.551, 633.61, 645.502, 656.684, 667.02, 676.573, 685.267, 693.444, 701.007, 708.008, 714.392, 720.409, 725.99, 731.171, 735.985, 740.393, 744.565, 748.454, 752.08, 755.413, 758.581, 761.545, 764.32, 766.881, 767.726, 795.539, 806.953, 812.735, 816.114, 818.281, 819.769, 820.84, 821.641, 822.257, 822.742, 823.132, 823.449, 823.712, 823.932, 824.118, 824.277, 824.414, 824.533, 824.636, 824.727, 824.807, 824.879, 824.942, 824.999, 825.05, 825.096, 825.138, 825.176, 825.211, 825.242, 825.271, 825.298, 825.322, 825.345, 825.366, 825.385, 825.403, 825.42, 825.435
};
const G4double G4BaryonPartialWidth::pwN2220_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.92152e-15, 6.76645e-07, 0.000284625, 0.0235115, 0.267933, 1.06843, 2.69754, 5.47998, 9.63374, 15.35, 22.6359, 31.8175, 42.8269, 55.6521, 69.9875, 86.2091, 103.968, 123.111, 143.467, 164.501, 186.717, 209.592, 232.944, 256.218, 280.019, 303.822, 327.494, 350.547, 373.637, 396.3, 418.467, 439.737, 460.764, 481.161, 500.905, 519.981, 538.089, 555.822, 572.882, 589.276, 604.767, 619.877, 634.364, 648.246, 661.333, 674.075, 686.272, 697.944, 708.936, 719.628, 729.859, 739.65, 749.023, 757.856, 766.457, 774.692, 782.576, 790.004, 797.231, 804.148, 810.77, 817.014, 819.104, 898.764, 942.009, 961.278, 971.014, 997.042, 1021.49, 1013.66, 984.806, 963.284, 955.275, 950.972, 943.041, 933.982, 931.581, 942.541, 970.207, 1015.16, 1075.93, 1149.74, 1232.22, 1317.82, 1399.54, 1470.11, 1522.79, 1552.54, 1557.24, 1537.73, 1497.32, 1440.91, 1373.67, 1300.54, 1225.33, 1151.09, 1079.74, 1012.4, 949.805, 892.068, 839.236, 791.001
};

const G4double G4BaryonPartialWidth::pwN2250_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.000265834, 0.0320445, 0.187008, 0.581348, 1.33328, 2.61152, 4.55941, 7.33091, 11.0084, 15.8554, 21.954, 29.4244, 38.2117, 48.6837, 60.7644, 74.4829, 89.5791, 106.52, 125.013, 144.973, 166.289, 188.457, 212.052, 236.557, 261.797, 287.174, 313.345, 339.724, 366.144, 392.029, 418.088, 443.768, 468.958, 493.171, 517.124, 540.35, 562.801, 584.439, 604.912, 624.878, 643.99, 662.251, 679.397, 696.005, 711.808, 726.829, 740.87, 754.418, 767.268, 779.448, 790.808, 801.75, 812.113, 821.926, 831.218, 839.879, 848.218, 856.115, 863.595, 870.57, 877.291, 883.661, 889.7, 895.338, 897.212, 962.773, 991.323, 1005.51, 1013.39, 1018.14, 1021.21, 1023.29, 1024.77, 1025.86, 1026.68, 1027.32, 1027.82, 1028.23, 1028.56, 1028.83, 1029.06, 1029.26, 1029.42, 1029.57, 1029.69, 1029.8, 1029.89, 1029.98, 1030.05, 1030.12, 1030.18, 1030.23, 1030.28, 1030.33, 1030.37, 1030.4, 1030.44, 1030.47, 1030.5, 1030.52, 1030.55, 1030.57, 1030.59, 1030.61
};
const G4double G4BaryonPartialWidth::pwN2250_Nrho[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.26985e-13, 1.47698e-10, 7.8168e-09, 1.81436e-07, 3.01127e-06, 4.55656e-05, 0.00089233, 0.0238918, 0.373931, 2.0517, 6.36016, 14.3138, 26.6528, 43.5077, 65.5817, 92.5073, 123.899, 159.166, 196.936, 237.649, 279.89, 322.878, 365.22, 407.713, 449.17, 489.215, 526.971, 563.496, 598.05, 630.591, 660.648, 689.248, 715.95, 740.839, 764.012, 785.236, 805.312, 823.98, 841.343, 857.245, 872.298, 886.318, 899.385, 911.383, 922.774, 933.418, 943.373, 952.548, 961.292, 969.494, 977.197, 984.437, 991.142, 997.565, 1003.62, 1009.34, 1014.65, 1019.76, 1024.6, 1029.18, 1033.45, 1034.87, 1085.61, 1109.83, 1123.02, 1129.91, 1136.76, 1147.09, 1140.63, 1136.57, 1178.77, 1148.22, 1115.42, 1121.28, 1180.32, 1246.91, 1209.52, 1122.75, 1083.2, 1086.92, 1082.37, 1060.09, 1058.62, 1108.51, 1213.21, 1349.9, 1467.67, 1507.82, 1449.52, 1326.3, 1189, 1070.73, 984.402, 931.324, 909.126, 914.554, 944.31, 994.088, 1057.34, 1123.64, 1179.36
};
const G4double G4BaryonPartialWidth::pwN2250_Npipi[120] =
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.72585e-05, 0.0421292, 0.259571, 0.786588, 1.74691, 3.26443, 5.41824, 8.392, 12.2622, 17.1233, 22.9509, 29.9986, 38.2238, 47.6494, 58.0949, 69.8806, 82.8, 96.7866, 111.755, 127.339, 143.937, 161.173, 178.916, 196.736, 215.089, 233.555, 252.014, 270.06, 288.184, 306.001, 323.433, 340.147, 356.638, 372.587, 387.964, 402.747, 416.699, 430.274, 443.237, 455.595, 467.174, 478.367, 488.996, 499.081, 508.49, 517.555, 526.139, 534.263, 541.83, 549.109, 555.994, 562.506, 568.666, 574.402, 579.92, 585.141, 590.082, 594.687, 599.12, 603.32, 607.299, 611.012, 612.246, 655.335, 674.12, 683.509, 688.756, 691.943, 694.014, 695.43, 696.442, 697.188, 697.755, 698.196, 698.546, 698.829, 699.061, 699.253, 699.415, 699.552, 699.669, 699.771, 699.859, 699.936, 700.004, 700.063, 700.117, 700.164, 700.207, 700.246, 700.281, 700.312, 700.341, 700.367, 700.391, 700.413, 700.434, 700.452, 700.47, 700.486, 700.5, 700.514
};
const G4double G4BaryonPartialWidth::pwN2250_Dpi[120] =
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.71431e-19, 3.85944e-09, 7.30979e-06, 0.001833, 0.0387871, 0.221369, 0.714128, 1.75737, 3.61167, 6.56628, 10.8345, 16.8372, 24.7715, 34.8445, 46.9818, 61.6486, 78.6509, 97.8914, 119.194, 141.931, 166.557, 192.384, 219.069, 245.828, 273.218, 300.506, 327.431, 353.351, 378.941, 403.631, 427.318, 449.579, 471.104, 491.504, 510.783, 528.959, 545.797, 561.886, 576.989, 591.154, 604.223, 616.676, 628.344, 639.276, 649.361, 658.975, 667.99, 676.446, 684.259, 691.719, 698.731, 705.327, 711.537, 717.299, 722.824, 728.038, 732.96, 737.533, 741.926, 746.076, 750, 753.657, 754.873, 798.119, 820.168, 828.044, 831.077, 849.331, 867.49, 859.495, 834.319, 815.484, 808.121, 804.002, 796.945, 789.017, 786.735, 795.727, 818.813, 856.491, 907.526, 969.597, 1039, 1111.06, 1179.88, 1239.32, 1283.69, 1308.74, 1312.69, 1296.24, 1262.17, 1214.62, 1157.95, 1096.31, 1032.92, 970.357, 910.218, 853.464, 800.716, 752.059, 707.535, 666.887
};
const G4double G4BaryonPartialWidth::pwN2250_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.17185e-20, 7.87105e-11, 2.71582e-08, 1.32282e-06, 2.80576e-05, 0.000374638, 0.00334135, 0.0210618, 0.0912509, 0.291309, 0.731725, 1.58321, 3.02605, 5.25522, 8.3933, 12.6876, 18.1826, 24.8911, 32.7452, 41.4534, 51.1049, 61.3325, 71.8947, 82.3908, 92.9666, 103.286, 113.225, 122.547, 131.505, 139.917, 147.775, 154.976, 161.776, 168.08, 173.918, 179.324, 184.253, 188.897, 193.203, 197.2, 200.857, 204.318, 207.543, 210.552, 213.321, 215.956, 218.427, 220.746, 222.891, 224.946, 226.882, 228.71, 230.438, 232.048, 233.599, 235.071, 236.469, 237.777, 239.043, 240.25, 241.4, 242.482, 242.843, 256.49, 263.828, 268.33, 271.338, 273.463, 275.042, 276.221, 277.151, 277.991, 278.675, 279.049, 279.162, 279.268, 279.62, 280.333, 281.351, 282.479, 283.442, 283.976, 283.908, 283.206, 281.978, 280.414, 278.726, 277.099, 275.653, 274.446, 273.482, 272.732, 272.153, 271.706, 271.371, 271.146, 271.052, 271.126, 271.416, 271.975, 272.851, 274.091
};

const G4double G4BaryonPartialWidth::pwD1232_Ngamma[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0179216, 0.16395, 0.409686, 0.710651, 1.0404, 1.38255, 1.72139, 2.06182, 2.39441, 2.71691, 3.02319, 3.32273, 3.6103, 3.88604, 4.14611, 4.39947, 4.64223, 4.8749, 5.09449, 5.30868, 5.51431, 5.71184, 5.90172, 6.08149, 6.25743, 6.42692, 6.59031, 6.74544, 6.89768, 7.04475, 7.18691, 7.32222, 7.45537, 7.58431, 7.70925, 7.82846, 7.94602, 8.06012, 8.17092, 8.27857, 8.38154, 8.48334, 8.58239, 8.67879, 8.77117, 8.86265, 8.95181, 9.03873, 9.12215, 9.20489, 9.28564, 9.36448, 9.44025, 9.5155, 9.58904, 9.66092, 9.73122, 9.79888, 9.86618, 9.93205, 9.99652, 10.0587, 10.1205, 10.1811, 10.2405, 10.2978, 10.3172, 11.2053, 11.8619, 12.3682, 12.7719, 13.1012, 13.3758, 13.6078, 13.807, 13.9796, 14.1308, 14.2643, 14.383, 14.4894, 14.5852, 14.672, 14.7509, 14.8231, 14.8892, 14.9502, 15.0064, 15.0586, 15.107, 15.1521, 15.1943, 15.2337, 15.2707, 15.3055, 15.3383, 15.3691, 15.3983, 15.426, 15.4521, 15.477, 15.5006, 15.5231, 15.5445, 15.5649, 15.5844, 15.603
};
const G4double G4BaryonPartialWidth::pwD1232_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.27334, 52.8477, 98.9005, 145.145, 189.938, 234.202, 276.882, 317.822, 356.35, 393.734, 429.374, 463.334, 495.184, 526.052, 555.488, 583.576, 609.974, 635.625, 660.16, 683.646, 706.149, 727.387, 748.111, 768.018, 787.156, 805.278, 823.019, 840.114, 856.6, 872.257, 887.629, 902.484, 916.849, 930.527, 943.99, 957.032, 969.674, 981.935, 993.642, 1005.2, 1016.42, 1027.33, 1037.76, 1048.08, 1058.12, 1067.9, 1077.27, 1086.55, 1095.59, 1104.41, 1112.87, 1121.27, 1129.46, 1137.46, 1145.28, 1152.79, 1160.26, 1167.55, 1174.69, 1181.56, 1188.39, 1195.07, 1201.62, 1207.92, 1210.07, 1307.04, 1377.8, 1431.81, 1474.54, 1509.19, 1537.91, 1562.09, 1582.76, 1600.61, 1616.21, 1629.95, 1642.14, 1653.04, 1662.84, 1671.7, 1679.75, 1687.1, 1693.83, 1700.03, 1705.74, 1711.03, 1715.93, 1720.5, 1724.77, 1728.75, 1732.49, 1736, 1739.31, 1742.43, 1745.37, 1748.15, 1750.79, 1753.29, 1755.66, 1757.92, 1760.08, 1762.13, 1764.09, 1765.96
};

const G4double G4BaryonPartialWidth::pwD1600_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.902724, 5.6193, 10.7485, 16.1049, 21.4717, 26.9396, 32.3639, 37.7072, 42.8621, 47.9835, 52.9776, 57.8408, 62.497, 67.1001, 71.5753, 75.9261, 80.0892, 84.2054, 88.2097, 92.1069, 95.9012, 99.5381, 103.141, 106.653, 110.079, 113.369, 116.633, 119.822, 122.937, 125.933, 128.912, 131.826, 134.678, 137.425, 140.16, 142.839, 145.465, 148.039, 150.523, 153, 155.431, 157.816, 160.121, 162.422, 164.682, 166.902, 169.049, 171.195, 173.305, 175.379, 177.387, 179.396, 181.372, 183.317, 185.232, 187.087, 188.944, 190.773, 192.574, 194.321, 196.07, 197.795, 199.494, 201.143, 201.705, 228.591, 250.164, 267.914, 282.84, 295.567, 306.577, 316.187, 324.665, 332.192, 338.931, 344.991, 350.475, 355.467, 360.022, 364.203, 368.047, 371.601, 374.89, 377.948, 380.794, 383.454, 385.941, 388.273, 390.467, 392.531, 394.48, 396.319, 398.061, 399.711, 401.278, 402.765, 404.182, 405.531, 406.817, 408.046, 409.22, 410.344, 411.419, 412.451
};
const G4double G4BaryonPartialWidth::pwD1600_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5.54878e-07, 0.0648566, 1.34566, 11.916, 38.7017, 73.9081, 112.537, 154.017, 196.655, 239.736, 282.073, 324.71, 366.709, 407.899, 447.528, 486.822, 525.083, 562.289, 598.437, 632.977, 667.056, 700.123, 732.204, 762.834, 793.047, 822.366, 850.822, 878.008, 904.846, 930.916, 956.247, 980.476, 1004.43, 1027.72, 1050.38, 1072.44, 1093.58, 1114.51, 1134.9, 1154.77, 1173.84, 1192.74, 1211.19, 1229.19, 1246.48, 1263.65, 1280.43, 1296.81, 1312.57, 1328.23, 1343.55, 1358.53, 1373.2, 1387.34, 1401.41, 1415.2, 1428.7, 1441.71, 1454.65, 1467.33, 1479.74, 1491.71, 1495.77, 1682.44, 1826.37, 1924.53, 1999.18, 2112.02, 2218.44, 2236.81, 2195.18, 2168.63, 2174.54, 2187.43, 2188.07, 2183.54, 2195.17, 2241.56, 2332.24, 2469.33, 2649.21, 2864.65, 3103.73, 3351.24, 3587.77, 3793.07, 3948.35, 4039.55, 4060.76, 4014.31, 3909.49, 3759.98, 3580.16, 3383.78, 3181.43, 2981.58, 2789.5, 2608.34, 2440.14, 2285.18, 2143.59, 2014.55
};
const G4double G4BaryonPartialWidth::pwD1600_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.91978e-06, 0.0381512, 0.37737, 1.70911, 5.5358, 14.8068, 33.4672, 65.379, 109.756, 163.384, 221.989, 285.06, 349.947, 415.455, 479.697, 544.205, 607.513, 669.344, 729.517, 786.991, 843.589, 898.33, 951.215, 1001.46, 1050.74, 1098.28, 1144.12, 1187.61, 1230.26, 1271.38, 1311.04, 1348.7, 1385.65, 1421.31, 1455.74, 1489, 1520.63, 1551.72, 1581.77, 1610.85, 1638.54, 1665.79, 1692.18, 1717.75, 1742.14, 1766.19, 1789.51, 1812.14, 1833.75, 1855.09, 1875.82, 1895.97, 1915.55, 1934.29, 1952.82, 1970.85, 1988.4, 2005.22, 2021.87, 2038.1, 2053.91, 2069.08, 2074.22, 2298.79, 2452.42, 2563.82, 2648.39, 2714.64, 2768.14, 2811.81, 2848.45, 2880.65, 2908.31, 2930.11, 2946.97, 2962.1, 2978.63, 2998.12, 3020.07, 3042.44, 3062.17, 3076.33, 3082.95, 3081.77, 3074.02, 3061.95, 3048.03, 3034.43, 3022.57, 3013.17, 3006.29, 3001.62, 2998.7, 2997.11, 2996.59, 2997.17, 2999.07, 3002.75, 3008.76, 3017.72, 3030.2, 3046.73
};

const G4double G4BaryonPartialWidth::pwD1620_Ngamma[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
const G4double G4BaryonPartialWidth::pwD1620_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6.09438, 15.1009, 20.5564, 24.762, 28.154, 31.0612, 33.5513, 35.7101, 37.5703, 39.2386, 40.7181, 42.0376, 43.2018, 44.2676, 45.2304, 46.1035, 46.8854, 47.6111, 48.2751, 48.8844, 49.4447, 49.9533, 50.4312, 50.8737, 51.2842, 51.6598, 52.0155, 52.3471, 52.657, 52.9423, 53.2142, 53.4693, 53.709, 53.9309, 54.1434, 54.3439, 54.5331, 54.7119, 54.8784, 55.0388, 55.1908, 55.335, 55.4699, 55.6002, 55.7241, 55.8422, 55.9528, 56.0602, 56.1626, 56.2604, 56.3524, 56.4419, 56.5275, 56.6094, 56.688, 56.7621, 56.8344, 56.9037, 56.9703, 57.0333, 57.0949, 57.1541, 57.2111, 57.2651, 57.2833, 58.0028, 58.4127, 58.6677, 58.8374, 58.9557, 59.0417, 59.106, 59.1555, 59.1942, 59.2252, 59.2503, 59.271, 59.2883, 59.3027, 59.3151, 59.3256, 59.3347, 59.3426, 59.3495, 59.3556, 59.361, 59.3658, 59.3701, 59.3739, 59.3773, 59.3804, 59.3833, 59.3858, 59.3881, 59.3903, 59.3922, 59.394, 59.3957, 59.3972, 59.3986, 59.3999, 59.4011, 59.4023, 59.4033
};
const G4double G4BaryonPartialWidth::pwD1620_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5.21075e-11, 0.000557029, 0.0545049, 1.51676, 9.32412, 25.4204, 48.7225, 78.8775, 114.265, 153.58, 194.921, 238.606, 283.096, 327.684, 371.116, 414.407, 456.537, 497.299, 536.554, 573.627, 609.7, 644.145, 676.984, 707.761, 737.533, 765.84, 792.745, 817.909, 842.224, 865.329, 887.291, 907.841, 927.713, 946.619, 964.613, 981.747, 997.812, 1013.38, 1028.23, 1042.39, 1055.7, 1068.63, 1080.98, 1092.79, 1103.91, 1114.73, 1125.1, 1135.02, 1144.39, 1153.52, 1162.28, 1170.7, 1178.78, 1186.44, 1193.92, 1201.13, 1208.05, 1214.62, 1221.03, 1227.2, 1233.14, 1238.77, 1240.67, 1316.77, 1363.87, 1385.86, 1397.76, 1434.76, 1470.41, 1459.55, 1418.29, 1387.72, 1376.75, 1371.05, 1359.96, 1347.17, 1344.03, 1360.28, 1400.77, 1466.33, 1554.81, 1662.22, 1782.16, 1906.62, 2025.41, 2127.97, 2204.5, 2247.69, 2254.46, 2226.06, 2167.34, 2085.46, 1987.9, 1881.86, 1772.85, 1665.29, 1561.92, 1464.39, 1373.76, 1290.16, 1213.68, 1143.85
};
const G4double G4BaryonPartialWidth::pwD1620_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00452334, 0.533317, 1.64619, 3.44509, 6.12145, 9.93389, 14.8995, 20.8638, 27.1431, 33.2716, 38.954, 44.3219, 49.2841, 53.8664, 58.0348, 61.9566, 65.5902, 68.9621, 72.0962, 74.9687, 77.6926, 80.2365, 82.6158, 84.8096, 86.902, 88.8672, 90.7154, 92.4283, 94.0704, 95.6203, 97.0848, 98.4483, 99.7612, 101.006, 102.186, 103.308, 104.357, 105.371, 106.338, 107.259, 108.123, 108.962, 109.764, 110.53, 111.251, 111.953, 112.625, 113.27, 113.878, 114.472, 115.042, 115.589, 116.116, 116.614, 117.102, 117.572, 118.024, 118.454, 118.874, 119.28, 119.672, 120.045, 120.17, 125.257, 128.288, 130.25, 131.602, 132.576, 133.309, 133.861, 134.299, 134.698, 135.025, 135.203, 135.255, 135.303, 135.47, 135.813, 136.305, 136.852, 137.32, 137.582, 137.551, 137.214, 136.62, 135.863, 135.044, 134.254, 133.551, 132.964, 132.495, 132.13, 131.848, 131.63, 131.466, 131.356, 131.308, 131.341, 131.479, 131.746, 132.166, 132.763
};

const G4double G4BaryonPartialWidth::pwD1700_Ngamma[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
const G4double G4BaryonPartialWidth::pwD1700_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.105048, 1.70825, 4.72752, 9.00542, 14.3171, 20.7052, 27.9583, 35.9486, 44.4136, 53.5229, 63.0432, 72.886, 82.8081, 93.0663, 103.439, 113.872, 124.151, 134.574, 144.937, 155.212, 165.373, 175.24, 185.117, 194.829, 204.363, 213.561, 222.717, 231.674, 240.427, 248.839, 257.184, 265.321, 273.252, 280.854, 288.38, 295.705, 302.832, 309.765, 316.4, 322.959, 329.334, 335.531, 341.457, 347.312, 353.001, 358.529, 363.815, 369.036, 374.109, 379.038, 383.751, 388.407, 392.932, 397.329, 401.602, 405.69, 409.729, 413.657, 417.475, 421.128, 424.741, 428.254, 431.671, 434.943, 436.049, 483.148, 513.09, 533.017, 546.871, 556.833, 564.228, 569.85, 574.225, 577.688, 580.479, 582.755, 584.638, 586.214, 587.543, 588.677, 589.649, 590.491, 591.224, 591.866, 592.431, 592.932, 593.378, 593.775, 594.132, 594.454, 594.744, 595.008, 595.247, 595.465, 595.665, 595.848, 596.017, 596.172, 596.315, 596.447, 596.57, 596.684, 596.79, 596.889
};
const G4double G4BaryonPartialWidth::pwD1700_Nrho[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.197174, 0.651142, 1.39254, 2.52596, 4.28883, 7.16065, 12.5976, 23.6164, 39.7817, 54.4452, 66.5761, 76.5147, 84.8386, 91.8365, 98.0044, 103.41, 108.192, 112.456, 116.226, 119.688, 122.829, 125.691, 128.269, 130.676, 132.893, 134.94, 136.807, 138.569, 140.208, 141.736, 143.142, 144.48, 145.734, 146.911, 148.019, 149.046, 150.03, 150.96, 151.839, 152.659, 153.448, 154.197, 154.909, 155.574, 156.219, 156.832, 157.417, 157.966, 158.499, 159.009, 159.496, 159.962, 160.402, 160.83, 161.241, 161.635, 162.007, 162.371, 162.721, 163.058, 163.376, 163.483, 167.718, 170.123, 171.585, 172.363, 173.209, 174.786, 173.623, 173.126, 179.48, 174.618, 169.763, 170.77, 179.944, 189.819, 183.712, 170.583, 164.831, 165.459, 164.643, 161.258, 161.265, 169.182, 185.388, 206.236, 223.819, 229.283, 219.828, 200.834, 180, 162.214, 149.33, 141.5, 138.353, 139.39, 144.104, 151.824, 161.52, 171.566, 179.863
};
const G4double G4BaryonPartialWidth::pwD1700_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00267161, 3.44743, 15.4393, 45.5488, 81.7335, 112.359, 137.838, 160.24, 179.908, 197.364, 212.739, 226.814, 239.544, 251.105, 261.48, 271.131, 279.983, 288.124, 295.63, 302.46, 308.893, 314.863, 320.414, 325.504, 330.335, 334.851, 339.078, 342.979, 346.703, 350.205, 353.501, 356.559, 359.493, 362.265, 364.887, 367.369, 369.684, 371.917, 374.038, 376.054, 377.941, 379.768, 381.508, 383.168, 384.727, 386.242, 387.689, 389.073, 390.376, 391.644, 392.859, 394.025, 395.144, 396.203, 397.239, 398.234, 399.192, 400.096, 400.979, 401.827, 402.64, 403.411, 403.669, 414.082, 420.974, 423.136, 423.76, 432.51, 441.46, 437.223, 424.315, 414.685, 410.913, 408.786, 405.153, 401.076, 399.881, 404.432, 416.159, 435.313, 461.269, 492.846, 528.16, 564.836, 599.865, 630.114, 652.684, 665.408, 667.375, 658.95, 641.564, 617.333, 588.472, 557.102, 524.859, 493.047, 462.477, 433.635, 406.832, 382.111, 359.492, 338.843
};
const G4double G4BaryonPartialWidth::pwD1700_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.01857e-10, 0.000163371, 0.00523212, 0.0523742, 0.31914, 1.46767, 5.24523, 14.9627, 33.4993, 61.5949, 97.3661, 139.877, 186.363, 234.878, 283.112, 331.556, 378.667, 423.966, 467.18, 507.534, 546.32, 582.888, 617.313, 649.184, 679.656, 708.305, 735.249, 760.205, 784.097, 806.607, 827.833, 847.55, 866.488, 884.392, 901.334, 917.38, 932.352, 946.796, 960.513, 973.55, 985.756, 997.572, 1008.83, 1019.56, 1029.65, 1039.44, 1048.79, 1057.74, 1066.17, 1074.37, 1082.24, 1089.77, 1097.01, 1103.84, 1110.52, 1116.93, 1123.1, 1128.95, 1134.67, 1140.17, 1145.48, 1150.52, 1152.21, 1220.15, 1259.85, 1285.17, 1302.43, 1314.75, 1323.94, 1330.84, 1336.27, 1341.09, 1345.01, 1347.32, 1348.27, 1349.11, 1351.1, 1354.79, 1359.93, 1365.58, 1370.44, 1373.2, 1373.02, 1369.75, 1363.92, 1356.43, 1348.32, 1340.49, 1333.53, 1327.72, 1323.08, 1319.49, 1316.71, 1314.58, 1312.98, 1311.91, 1311.46, 1311.83, 1313.23, 1315.92, 1320.15, 1326.13
};

const G4double G4BaryonPartialWidth::pwD1900_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10.9537, 27.1407, 36.9456, 44.5042, 50.6006, 55.8255, 60.3009, 64.1809, 67.5242, 70.5225, 73.1817, 75.5531, 77.6455, 79.561, 81.2915, 82.8605, 84.2659, 85.5702, 86.7636, 87.8586, 88.8657, 89.7798, 90.6387, 91.434, 92.1718, 92.8469, 93.486, 94.0822, 94.639, 95.1519, 95.6405, 96.099, 96.5297, 96.9286, 97.3106, 97.6708, 98.0109, 98.3323, 98.6316, 98.9198, 99.193, 99.4522, 99.6945, 99.9287, 100.152, 100.364, 100.563, 100.755, 100.94, 101.115, 101.281, 101.442, 101.595, 101.743, 101.884, 102.017, 102.147, 102.272, 102.391, 102.505, 102.615, 102.722, 102.824, 102.921, 102.954, 104.247, 104.984, 105.442, 105.747, 105.96, 106.114, 106.23, 106.319, 106.388, 106.444, 106.489, 106.526, 106.557, 106.583, 106.605, 106.624, 106.641, 106.655, 106.667, 106.678, 106.688, 106.697, 106.704, 106.711, 106.717, 106.723, 106.728, 106.733, 106.737, 106.741, 106.744, 106.747, 106.75, 106.753, 106.756, 106.758, 106.76, 106.762, 106.764
};
const G4double G4BaryonPartialWidth::pwD1900_Nrho[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.135402, 0.447163, 0.95632, 1.7347, 2.94536, 4.91761, 8.65148, 16.2188, 27.3204, 37.3906, 45.7215, 52.5468, 58.2633, 63.0691, 67.3049, 71.017, 74.3012, 77.2299, 79.8188, 82.1964, 84.3534, 86.3191, 88.0895, 89.7426, 91.2649, 92.6708, 93.9526, 95.1626, 96.2884, 97.338, 98.3033, 99.2219, 100.083, 100.892, 101.652, 102.358, 103.034, 103.672, 104.276, 104.839, 105.381, 105.896, 106.384, 106.841, 107.284, 107.705, 108.107, 108.484, 108.85, 109.2, 109.534, 109.855, 110.157, 110.451, 110.733, 111.003, 111.259, 111.509, 111.75, 111.98, 112.199, 112.272, 115.181, 116.832, 117.836, 118.371, 118.952, 120.035, 119.236, 118.895, 123.259, 119.919, 116.585, 117.278, 123.578, 130.359, 126.163, 117.147, 113.198, 113.63, 113.069, 110.744, 110.75, 116.188, 127.319, 141.636, 153.71, 157.46, 150.965, 137.92, 123.613, 111.398, 102.551, 97.1751, 95.0143, 95.7271, 98.9656, 104.267, 110.926, 117.825, 123.523
};
const G4double G4BaryonPartialWidth::pwD1900_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.74997e-11, 0.000185826, 0.0181884, 0.508259, 3.16083, 8.75941, 17.1089, 28.2861, 41.8925, 57.5955, 74.7519, 93.5844, 113.501, 134.206, 155.094, 176.625, 198.266, 219.856, 241.261, 262.035, 282.775, 303.069, 322.867, 341.825, 360.539, 378.679, 396.233, 412.933, 429.326, 445.143, 460.392, 474.852, 489.013, 502.648, 515.773, 528.405, 540.369, 552.075, 563.34, 574.18, 584.449, 594.497, 604.171, 613.486, 622.316, 630.963, 639.294, 647.322, 654.937, 662.4, 669.597, 676.541, 683.244, 689.615, 695.872, 701.916, 707.754, 713.302, 718.748, 724.007, 729.086, 733.917, 735.545, 802.291, 844.125, 865.828, 878.721, 906.557, 932.47, 927.463, 902.295, 883.784, 877.751, 874.95, 868.518, 860.874, 859.375, 870.322, 896.839, 939.452, 996.767, 1066.2, 1143.63, 1223.91, 1300.5, 1366.61, 1415.95, 1443.81, 1448.24, 1430.04, 1392.33, 1339.71, 1277.01, 1208.84, 1138.76, 1069.61, 1003.15, 940.444, 882.167, 828.414, 779.23, 734.329
};
const G4double G4BaryonPartialWidth::pwD1900_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00738292, 0.868222, 2.67961, 5.60757, 9.96368, 16.1689, 24.2508, 33.9581, 44.178, 54.1523, 63.4007, 72.1371, 80.2132, 87.6712, 94.4553, 100.838, 106.752, 112.24, 117.341, 122.016, 126.449, 130.59, 134.462, 138.033, 141.438, 144.637, 147.645, 150.432, 153.105, 155.628, 158.011, 160.23, 162.367, 164.392, 166.314, 168.139, 169.846, 171.498, 173.071, 174.57, 175.977, 177.342, 178.646, 179.893, 181.067, 182.21, 183.304, 184.353, 185.343, 186.309, 187.237, 188.128, 188.985, 189.797, 190.591, 191.355, 192.091, 192.79, 193.475, 194.135, 194.773, 195.379, 195.583, 203.862, 208.796, 211.989, 214.19, 215.775, 216.969, 217.867, 218.58, 219.229, 219.76, 220.05, 220.135, 220.213, 220.486, 221.044, 221.844, 222.734, 223.496, 223.922, 223.873, 223.323, 222.357, 221.124, 219.792, 218.506, 217.361, 216.406, 215.643, 215.049, 214.59, 214.236, 213.969, 213.789, 213.711, 213.765, 213.989, 214.423, 215.108, 216.078
};

const G4double G4BaryonPartialWidth::pwD1905_Ngamma[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
const G4double G4BaryonPartialWidth::pwD1905_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00636486, 0.26456, 1.05845, 2.5735, 4.91123, 8.25598, 12.6491, 18.1285, 24.5857, 32.2115, 40.8633, 50.4752, 60.7893, 72.0508, 83.9946, 96.5129, 109.284, 122.62, 136.211, 149.959, 163.771, 177.344, 191.047, 204.592, 217.924, 230.784, 243.557, 255.996, 268.076, 279.593, 290.911, 301.83, 312.346, 322.299, 332.018, 341.342, 350.277, 358.833, 366.89, 374.725, 382.213, 389.368, 396.094, 402.624, 408.859, 414.811, 420.403, 425.831, 431.012, 435.959, 440.607, 445.12, 449.431, 453.549, 457.483, 461.184, 464.781, 468.22, 471.51, 474.608, 477.622, 480.508, 483.271, 485.876, 486.748, 519.727, 536.53, 545.94, 551.643, 555.309, 557.788, 559.528, 560.793, 561.737, 562.458, 563.02, 563.465, 563.824, 564.116, 564.358, 564.559, 564.729, 564.873, 564.997, 565.103, 565.196, 565.277, 565.347, 565.41, 565.465, 565.515, 565.559, 565.599, 565.634, 565.667, 565.696, 565.723, 565.747, 565.769, 565.789, 565.808, 565.825, 565.841, 565.856
};
const G4double G4BaryonPartialWidth::pwD1905_Nrho[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00159192, 0.0181558, 0.0867299, 0.297176, 0.888987, 2.55749, 8.10299, 28.658, 80.536, 149.596, 222.966, 294.698, 363.472, 427.966, 490.334, 549.652, 606.112, 659.913, 710.436, 759.512, 806.457, 851.421, 893.859, 935.284, 975.1, 1013.41, 1049.72, 1085.32, 1119.66, 1152.83, 1184.38, 1215.41, 1245.45, 1274.55, 1302.76, 1329.7, 1356.27, 1382.08, 1407.17, 1431.17, 1454.9, 1478.01, 1500.51, 1522.08, 1543.45, 1564.29, 1584.62, 1604.15, 1623.53, 1642.45, 1660.94, 1679.02, 1696.4, 1713.69, 1730.6, 1747.15, 1763.09, 1778.96, 1794.51, 1809.73, 1824.41, 1829.39, 2056.92, 2225.23, 2354.73, 2454.87, 2542.81, 2633.88, 2665.76, 2702.99, 2863.51, 2808.15, 2748.48, 2796.38, 2997.36, 3210.31, 3115.26, 2883.52, 2791.32, 2819.9, 2819.48, 2768.54, 2781.82, 2946.65, 3271.19, 3685.69, 4036.98, 4152.93, 3978.83, 3619.17, 3223.56, 2886.78, 2644.64, 2499.96, 2445.43, 2471.49, 2568.48, 2723.52, 2916.83, 3116.89, 3282.93
};
const G4double G4BaryonPartialWidth::pwD1905_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5.77051e-08, 0.00672262, 0.13989, 1.24822, 4.09217, 7.87924, 12.0833, 16.6458, 21.3822, 26.2122, 30.9997, 35.8606, 40.6863, 45.4548, 50.0752, 54.6881, 59.2096, 63.6348, 67.9609, 72.1192, 76.2459, 80.2727, 84.201, 87.9716, 91.7101, 95.3564, 98.913, 102.327, 105.714, 109.018, 112.244, 115.343, 118.419, 121.423, 124.359, 127.228, 129.987, 132.73, 135.413, 138.038, 140.565, 143.08, 145.542, 147.954, 150.279, 152.594, 154.864, 157.088, 159.235, 161.374, 163.473, 165.532, 167.554, 169.509, 171.46, 173.377, 175.259, 177.078, 178.893, 180.675, 182.424, 184.116, 184.692, 211.671, 233.175, 248.506, 260.544, 277.767, 294.073, 298.016, 293.414, 290.783, 292.604, 295.325, 296.246, 296.367, 298.719, 305.958, 319.467, 339.581, 365.814, 397.159, 431.916, 467.911, 502.347, 532.305, 555.073, 568.614, 572.07, 565.773, 551.056, 529.889, 504.344, 476.398, 447.582, 419.113, 391.751, 365.952, 342.006, 319.957, 299.823, 281.485
};
const G4double G4BaryonPartialWidth::pwD1905_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.53902e-15, 3.04746e-07, 3.131e-05, 0.000685997, 0.00777943, 0.0610318, 0.346172, 1.47851, 4.63299, 11.2253, 22.1508, 38.2088, 58.9452, 83.4363, 109.995, 138.248, 166.694, 194.514, 221.158, 245.911, 269.436, 291.277, 311.476, 329.827, 347.038, 362.911, 377.561, 390.89, 403.435, 415.065, 425.865, 435.756, 445.132, 453.886, 462.074, 469.746, 476.833, 483.608, 489.985, 495.997, 501.584, 506.954, 512.037, 516.854, 521.353, 525.698, 529.829, 533.761, 537.448, 541.023, 544.436, 547.696, 550.813, 553.749, 556.607, 559.346, 561.973, 564.454, 566.877, 569.205, 571.443, 573.562, 574.274, 602.47, 618.674, 628.936, 635.909, 640.879, 644.593, 647.374, 649.571, 651.556, 653.177, 654.069, 654.343, 654.594, 655.42, 657.092, 659.479, 662.133, 664.406, 665.677, 665.536, 663.906, 661.037, 657.374, 653.414, 649.593, 646.192, 643.355, 641.086, 639.321, 637.957, 636.905, 636.113, 635.578, 635.348, 635.51, 636.175, 637.468, 639.503, 642.389
};

const G4double G4BaryonPartialWidth::pwD1910_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.12809, 7.05827, 13.5492, 20.363, 27.2216, 34.2395, 41.2298, 48.1426, 54.8364, 61.5104, 68.0412, 74.4222, 80.5515, 86.6302, 92.5584, 98.3392, 103.887, 109.388, 114.755, 119.993, 125.106, 130.02, 134.902, 139.672, 144.337, 148.828, 153.295, 157.668, 161.951, 166.08, 170.194, 174.228, 178.184, 182.003, 185.813, 189.554, 193.228, 196.836, 200.325, 203.812, 207.239, 210.609, 213.871, 217.134, 220.344, 223.505, 226.566, 229.63, 232.649, 235.622, 238.505, 241.392, 244.238, 247.044, 249.811, 252.495, 255.186, 257.841, 260.46, 263.003, 265.554, 268.072, 270.557, 272.972, 273.796, 313.665, 346.332, 373.679, 397.012, 417.155, 434.77, 450.29, 464.097, 476.444, 487.573, 497.64, 506.8, 515.178, 522.858, 529.935, 536.468, 542.528, 548.155, 553.402, 558.299, 562.887, 567.188, 571.232, 575.043, 578.636, 582.034, 585.248, 588.296, 591.188, 593.939, 596.555, 599.049, 601.427, 603.697, 605.87, 607.947, 609.938, 611.846, 613.678
};
const G4double G4BaryonPartialWidth::pwD1910_Nrho[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.000674262, 0.00769051, 0.0367417, 0.125916, 0.376779, 1.08446, 3.43906, 12.1851, 34.3317, 63.9188, 95.4518, 126.364, 156.07, 183.985, 211.031, 236.799, 261.365, 284.809, 306.856, 328.301, 348.842, 368.54, 387.154, 405.344, 422.847, 439.706, 455.704, 471.399, 486.559, 501.215, 515.169, 528.904, 542.212, 555.116, 567.636, 579.597, 591.41, 602.892, 614.059, 624.752, 635.335, 645.644, 655.689, 665.326, 674.882, 684.206, 693.308, 702.055, 710.741, 719.23, 727.528, 735.644, 743.455, 751.227, 758.835, 766.282, 773.46, 780.61, 787.618, 794.485, 801.108, 803.359, 906.475, 983.298, 1042.74, 1088.96, 1129.62, 1171.59, 1186.89, 1204.51, 1277.49, 1253.33, 1227.14, 1249.3, 1340.36, 1436.81, 1394.48, 1290.52, 1249.38, 1262.63, 1262.79, 1240.16, 1246.45, 1321.04, 1467.67, 1654.89, 1813.64, 1866.2, 1787.89, 1625.84, 1447.58, 1295.85, 1186.81, 1121.73, 1097.29, 1109.19, 1153.08, 1223.15, 1310.5, 1400.89, 1475.94
};
const G4double G4BaryonPartialWidth::pwD1910_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5.89027e-08, 0.00686081, 0.142796, 1.27488, 4.18253, 8.05829, 12.3647, 17.042, 21.9015, 26.8604, 31.7792, 36.7767, 41.7411, 46.6495, 51.4083, 56.162, 60.824, 65.3891, 69.8543, 74.1484, 78.4119, 82.5742, 86.6365, 90.5375, 94.4069, 98.1826, 101.867, 105.405, 108.916, 112.343, 115.69, 118.906, 122.1, 125.221, 128.271, 131.253, 134.122, 136.975, 139.767, 142.498, 145.13, 147.749, 150.314, 152.827, 155.25, 157.665, 160.032, 162.353, 164.592, 166.826, 169.017, 171.168, 173.28, 175.323, 177.362, 179.366, 181.334, 183.237, 185.136, 187, 188.832, 190.603, 191.206, 219.51, 242.138, 258.333, 271.084, 289.257, 306.471, 310.733, 306.031, 303.38, 305.386, 308.329, 309.377, 309.58, 312.117, 319.778, 334.016, 355.187, 382.785, 415.753, 452.311, 490.172, 526.4, 557.923, 581.893, 596.166, 599.841, 593.265, 577.839, 555.633, 528.824, 499.492, 469.243, 439.358, 410.636, 383.554, 358.419, 335.276, 314.145, 294.899
};
const G4double G4BaryonPartialWidth::pwD1910_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.91098e-07, 0.00282452, 0.028014, 0.127537, 0.416483, 1.12734, 2.58815, 5.15117, 8.81793, 13.3776, 18.4979, 24.1511, 30.1089, 36.2601, 42.4195, 48.7259, 55.0306, 61.2962, 67.4949, 73.5078, 79.5166, 85.4106, 91.182, 96.7354, 102.25, 107.632, 112.88, 117.916, 122.904, 127.763, 132.496, 137.032, 141.523, 145.897, 150.157, 154.307, 158.285, 162.225, 166.064, 169.806, 173.396, 176.954, 180.424, 183.809, 187.059, 190.283, 193.431, 196.503, 199.457, 202.389, 205.254, 208.054, 210.791, 213.425, 216.043, 218.604, 221.11, 223.523, 225.924, 228.275, 230.577, 232.796, 233.55, 267.716, 292.634, 311.619, 326.614, 338.751, 348.818, 357.243, 364.453, 370.828, 376.391, 380.98, 384.743, 388.141, 391.622, 395.418, 399.471, 403.51, 407.115, 409.886, 411.555, 412.087, 411.658, 410.585, 409.216, 407.856, 406.707, 405.871, 405.361, 405.136, 405.132, 405.292, 405.585, 406.013, 406.61, 407.44, 408.582, 410.122, 412.143, 414.72
};

const G4double G4BaryonPartialWidth::pwD1920_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.377455, 2.36263, 4.53662, 6.81972, 9.11866, 11.4718, 13.8164, 16.1358, 18.3824, 20.6229, 22.816, 24.9594, 27.0188, 29.0617, 31.0545, 32.9983, 34.8642, 36.7147, 38.5206, 40.2834, 42.0048, 43.6595, 45.3033, 46.9103, 48.482, 49.9952, 51.5009, 52.9752, 54.4194, 55.812, 57.1997, 58.5605, 59.8954, 61.1844, 62.4707, 63.7336, 64.9741, 66.1929, 67.3715, 68.5492, 69.7073, 70.8463, 71.949, 73.0519, 74.1374, 75.2061, 76.2415, 77.2781, 78.2992, 79.3052, 80.2807, 81.2581, 82.2215, 83.1714, 84.1081, 85.0172, 85.9287, 86.8279, 87.7152, 88.5768, 89.4412, 90.2945, 91.1368, 91.9552, 92.2346, 105.764, 116.869, 126.18, 134.135, 141.009, 147.026, 152.333, 157.057, 161.284, 165.097, 168.547, 171.689, 174.563, 177.199, 179.629, 181.873, 183.955, 185.889, 187.692, 189.376, 190.955, 192.434, 193.826, 195.138, 196.374, 197.544, 198.651, 199.701, 200.697, 201.645, 202.546, 203.406, 204.225, 205.008, 205.757, 206.473, 207.16, 207.817, 208.449
};
const G4double G4BaryonPartialWidth::pwD1920_Nrho[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00036402, 0.00415222, 0.0198393, 0.0680009, 0.203529, 0.586044, 1.85993, 6.60028, 18.638, 34.7697, 52.0098, 68.9502, 85.2633, 100.62, 115.524, 129.745, 143.322, 156.297, 168.513, 180.411, 191.82, 202.773, 213.134, 223.27, 233.033, 242.446, 251.386, 260.165, 268.652, 276.863, 284.688, 292.397, 299.872, 307.125, 314.168, 320.901, 327.556, 334.029, 340.329, 346.365, 352.344, 358.171, 363.853, 369.307, 374.719, 380.002, 385.163, 390.125, 395.056, 399.877, 404.592, 409.207, 413.65, 418.074, 422.406, 426.649, 430.74, 434.818, 438.817, 442.736, 446.519, 447.805, 506.927, 551.261, 585.743, 612.691, 636.429, 660.877, 670.106, 680.606, 722.622, 709.239, 694.657, 707.615, 759.868, 815.212, 791.306, 732.186, 708.918, 716.682, 716.961, 704.209, 707.963, 750.734, 834.668, 941.828, 1032.72, 1062.91, 1018.27, 925.739, 823.938, 737.312, 675.086, 637.976, 624.092, 630.974, 656.136, 696.269, 746.276, 798.032, 841.015
};
const G4double G4BaryonPartialWidth::pwD1920_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.99645e-08, 0.0104769, 0.218104, 1.94827, 6.39599, 12.3301, 18.9292, 26.1023, 33.56, 41.1757, 48.7346, 56.4191, 64.0573, 71.6137, 78.9438, 86.2699, 93.4584, 100.501, 107.393, 114.024, 120.61, 127.043, 133.325, 139.359, 145.347, 151.192, 156.899, 162.381, 167.822, 173.137, 178.328, 183.318, 188.276, 193.122, 197.86, 202.493, 206.953, 211.389, 215.73, 219.98, 224.075, 228.152, 232.146, 236.06, 239.836, 243.599, 247.289, 250.908, 254.402, 257.886, 261.306, 264.664, 267.962, 271.151, 274.337, 277.468, 280.545, 283.519, 286.488, 289.404, 292.269, 295.04, 295.984, 340.356, 375.935, 401.492, 421.668, 450.317, 477.471, 484.345, 477.164, 473.174, 476.464, 481.211, 482.978, 483.413, 487.498, 499.613, 522.04, 555.345, 598.74, 650.571, 708.043, 767.568, 824.533, 874.113, 911.831, 934.318, 940.157, 929.892, 905.723, 870.901, 828.846, 782.824, 735.363, 688.469, 643.401, 600.908, 561.471, 525.163, 492.012, 461.822
};
const G4double G4BaryonPartialWidth::pwD1920_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5.36864e-07, 0.00520843, 0.051665, 0.235273, 0.768622, 2.08179, 4.78323, 9.52943, 16.33, 24.7999, 34.3259, 44.859, 55.9755, 67.4683, 78.9909, 90.803, 102.625, 114.388, 126.037, 137.348, 148.663, 159.772, 170.659, 181.145, 191.565, 201.744, 211.678, 221.216, 230.671, 239.888, 248.873, 257.489, 266.026, 274.345, 282.453, 290.355, 297.935, 305.447, 312.771, 319.914, 326.769, 333.568, 340.202, 346.676, 352.896, 359.069, 365.097, 370.986, 376.648, 382.272, 387.771, 393.146, 398.403, 403.463, 408.496, 413.42, 418.241, 422.885, 427.508, 432.035, 436.471, 440.747, 442.2, 508.254, 556.67, 593.705, 623.05, 646.864, 666.658, 683.259, 697.486, 710.078, 721.079, 730.179, 737.667, 744.434, 751.344, 758.846, 766.832, 774.778, 781.879, 787.361, 790.709, 791.855, 791.141, 789.177, 786.637, 784.107, 781.979, 780.451, 779.546, 779.187, 779.251, 779.629, 780.259, 781.145, 782.357, 784.015, 786.272, 789.297, 793.245, 798.267
};

const G4double G4BaryonPartialWidth::pwD1930_Npi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0638218, 1.04091, 2.89195, 5.53376, 8.84115, 12.8551, 17.4579, 22.5821, 28.0703, 34.0434, 40.3598, 46.9689, 53.7122, 60.7695, 67.9944, 75.3524, 82.6919, 90.2261, 97.8104, 105.422, 113.042, 120.529, 128.114, 135.658, 143.15, 150.46, 157.817, 165.093, 172.28, 179.259, 186.254, 193.143, 199.924, 206.487, 213.044, 219.486, 225.81, 232.016, 238.005, 243.975, 249.826, 255.558, 261.082, 266.581, 271.963, 277.231, 282.303, 287.346, 292.28, 297.104, 301.746, 306.36, 310.871, 315.28, 319.589, 323.734, 327.852, 331.877, 335.81, 339.593, 343.35, 347.022, 350.61, 354.061, 355.231, 406.718, 441.229, 465.016, 481.956, 494.348, 503.664, 510.814, 516.419, 520.88, 524.492, 527.451, 529.904, 531.963, 533.704, 535.191, 536.469, 537.577, 538.541, 539.388, 540.134, 540.796, 541.384, 541.91, 542.383, 542.808, 543.193, 543.542, 543.86, 544.149, 544.414, 544.657, 544.881, 545.086, 545.276, 545.452, 545.615, 545.767, 545.908, 546.039
};
const G4double G4BaryonPartialWidth::pwD1930_Nrho[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6.86792e-07, 2.7078e-05, 0.000289904, 0.0018869, 0.010035, 0.05049, 0.296166, 2.0808, 10.3995, 27.4459, 51.3148, 79.3295, 109.828, 141.172, 173.627, 206.149, 238.356, 269.983, 300.356, 330.348, 359.376, 387.392, 413.948, 439.908, 464.839, 488.757, 511.325, 533.313, 554.375, 574.545, 593.555, 612.062, 629.784, 646.757, 663.014, 678.344, 693.28, 707.597, 721.324, 734.281, 746.922, 759.053, 770.701, 781.71, 792.465, 802.802, 812.741, 822.15, 831.354, 840.214, 848.746, 856.964, 864.758, 872.397, 879.765, 886.871, 893.619, 900.245, 906.644, 912.823, 918.698, 920.676, 1001.08, 1048.54, 1078.44, 1097.25, 1112.6, 1130.37, 1127.71, 1128.45, 1174.62, 1144.35, 1113.76, 1122.33, 1185.43, 1252.8, 1212.84, 1125.76, 1088.04, 1092.96, 1088.11, 1066.02, 1066.57, 1119.94, 1228.54, 1367.93, 1485.37, 1521.95, 1459.11, 1332.69, 1193.99, 1075.56, 989.802, 937.753, 916.935, 924.03, 955.64, 1007.26, 1072.01, 1139.05, 1194.41
};
const G4double G4BaryonPartialWidth::pwD1930_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.1974e-11, 0.000126855, 0.0124175, 0.347488, 2.1696, 6.04695, 11.8911, 19.8122, 29.5894, 41.0424, 53.7506, 67.925, 83.1625, 99.2669, 115.78, 133.079, 150.747, 168.653, 186.68, 204.437, 222.42, 240.266, 257.914, 275.033, 292.145, 308.933, 325.37, 341.182, 356.87, 372.163, 387.055, 401.31, 415.396, 429.079, 442.36, 455.246, 467.545, 479.666, 491.414, 502.797, 513.649, 524.336, 534.686, 544.709, 554.263, 563.669, 572.779, 581.6, 590.006, 598.283, 606.3, 614.068, 621.597, 628.781, 635.861, 642.726, 649.38, 655.725, 661.975, 668.03, 673.897, 679.496, 681.385, 760.414, 811.07, 838.924, 856.229, 887.454, 915.894, 912.687, 888.887, 871.511, 866.444, 864.45, 858.691, 851.619, 850.611, 861.967, 888.803, 931.633, 989.055, 1058.49, 1135.83, 1215.96, 1292.36, 1358.29, 1407.5, 1435.32, 1439.8, 1421.75, 1384.26, 1331.94, 1269.57, 1201.75, 1132.03, 1063.23, 997.103, 934.706, 876.718, 823.229, 774.287, 729.606
};
const G4double G4BaryonPartialWidth::pwD1930_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7.76222e-11, 6.2529e-05, 0.00200145, 0.0200462, 0.122449, 0.566851, 2.05514, 6.01841, 14.0022, 27.0097, 45.0182, 68.4446, 96.557, 128.704, 163.564, 201.557, 241.438, 282.577, 324.422, 365.823, 407.756, 449.225, 489.982, 529.202, 568.03, 605.712, 642.18, 676.835, 710.795, 743.479, 774.896, 804.593, 833.57, 861.364, 888.015, 913.563, 937.663, 961.148, 983.657, 1005.23, 1025.59, 1045.44, 1064.47, 1082.73, 1099.98, 1116.81, 1132.97, 1148.49, 1163.18, 1177.52, 1191.32, 1204.59, 1217.36, 1229.46, 1241.31, 1252.73, 1263.73, 1274.17, 1284.4, 1294.28, 1303.81, 1312.87, 1315.92, 1439.2, 1511.68, 1557.86, 1589.19, 1611.43, 1627.9, 1640.26, 1649.93, 1658.21, 1664.92, 1669.27, 1671.66, 1673.71, 1677.03, 1682.37, 1689.41, 1697.02, 1703.54, 1707.39, 1707.52, 1703.75, 1696.73, 1687.63, 1677.73, 1668.16, 1659.64, 1652.56, 1646.93, 1642.58, 1639.24, 1636.7, 1634.81, 1633.57, 1633.11, 1633.65, 1635.48, 1638.92, 1644.26, 1651.79
};

const G4double G4BaryonPartialWidth::pwD1950_Ngamma[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.16591e-05, 0.0011297, 0.00808729, 0.0275992, 0.0664532, 0.130705, 0.223594, 0.35205, 0.517674, 0.722317, 0.962624, 1.24653, 1.56972, 1.9308, 2.32115, 2.75112, 3.21177, 3.69995, 4.20387, 4.73662, 5.2866, 5.85033, 6.42438, 6.99608, 7.58111, 8.16729, 8.75195, 9.32339, 9.89822, 10.4651, 11.0225, 11.5603, 12.0948, 12.6163, 13.124, 13.6095, 14.0883, 14.552, 15.0005, 15.4337, 15.845, 16.2482, 16.6365, 17.0102, 17.3639, 17.7096, 18.0417, 18.3607, 18.662, 18.956, 19.2381, 19.5088, 19.7643, 20.0134, 20.2523, 20.4815, 20.7012, 20.9086, 21.1109, 21.305, 21.4911, 21.6669, 21.8384, 22.003, 22.161, 22.3103, 22.3603, 24.278, 25.2706, 25.8285, 26.1662, 26.3824, 26.528, 26.6296, 26.7031, 26.7576, 26.7991, 26.8312, 26.8565, 26.8768, 26.8933, 26.9069, 26.9182, 26.9276, 26.9356, 26.9424, 26.9483, 26.9534, 26.9578, 26.9617, 26.9651, 26.9681, 26.9707, 26.9731, 26.9752, 26.9772, 26.9789, 26.9805, 26.9819, 26.9832, 26.9843, 26.9854, 26.9864, 26.9873, 26.9881, 26.9889
};
const G4double G4BaryonPartialWidth::pwD1950_Npi[120] =
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0101729, 0.422951, 1.6936, 4.12336, 7.88332, 13.2837, 20.4111, 29.3528, 39.9616, 52.5865, 67.034, 83.2369, 100.8, 120.184, 140.979, 163.036, 185.814, 209.901, 234.765, 260.243, 286.177, 311.991, 338.389, 364.818, 391.158, 416.88, 442.731, 468.203, 493.222, 517.336, 541.285, 564.627, 587.33, 609.019, 630.389, 651.067, 671.049, 690.334, 708.632, 726.552, 743.797, 760.381, 776.068, 791.387, 806.095, 820.211, 833.54, 846.538, 859.002, 870.953, 882.229, 893.219, 903.755, 913.854, 923.535, 932.669, 941.574, 950.112, 958.3, 966.03, 973.569, 980.802, 987.744, 994.301, 996.498, 1080.58, 1124, 1148.4, 1163.17, 1172.64, 1179.01, 1183.46, 1186.68, 1189.08, 1190.9, 1192.31, 1193.42, 1194.32, 1195.04, 1195.64, 1196.14, 1196.56, 1196.91, 1197.21, 1197.47, 1197.69, 1197.89, 1198.06, 1198.21, 1198.34, 1198.46, 1198.57, 1198.66, 1198.75, 1198.82, 1198.89, 1198.96, 1199.01, 1199.07, 1199.11, 1199.16, 1199.2, 1199.24, 1199.27
};
const G4double G4BaryonPartialWidth::pwD1950_Nrho[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5.66346e-10, 7.70282e-08, 1.84481e-06, 2.27462e-05, 0.000214163, 0.00187243, 0.0201233, 0.277027, 2.45033, 9.24585, 21.8636, 39.7456, 61.839, 86.5264, 113.5, 141.403, 169.458, 197.081, 223.432, 249.102, 273.484, 296.491, 317.76, 338.004, 356.905, 374.523, 390.675, 405.964, 420.193, 433.438, 445.581, 457.087, 467.815, 477.827, 487.179, 495.786, 503.978, 511.652, 518.849, 525.499, 531.854, 537.832, 543.462, 548.685, 553.696, 558.429, 562.903, 567.07, 571.084, 574.888, 578.497, 581.924, 585.129, 588.23, 591.181, 593.992, 596.628, 599.187, 601.631, 603.963, 606.157, 606.89, 634.561, 648.977, 657.275, 661.786, 665.984, 672.689, 668.577, 666.938, 691.712, 673.056, 654.412, 658.401, 693.907, 732.077, 708.524, 657.875, 635.708, 638.164, 635.031, 621.985, 622.035, 652.616, 715.177, 795.634, 863.469, 884.534, 848.042, 774.749, 694.37, 625.749, 576.045, 545.847, 533.712, 537.725, 555.927, 585.72, 623.136, 661.898, 693.908
};
const G4double G4BaryonPartialWidth::pwD1950_Dpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.89389e-16, 8.58774e-07, 0.000391611, 0.0338673, 0.398615, 1.60372, 4.05019, 8.19392, 14.2996, 22.5572, 32.8608, 45.5241, 60.2778, 76.9254, 94.9067, 114.525, 135.194, 156.607, 178.477, 200.182, 222.204, 243.989, 265.371, 285.888, 306.113, 325.629, 344.385, 362.068, 379.242, 395.608, 411.176, 425.73, 439.769, 453.075, 465.677, 477.606, 488.719, 499.412, 509.529, 519.102, 528.02, 536.604, 544.732, 552.432, 559.614, 566.538, 573.106, 579.338, 585.161, 590.784, 596.129, 601.212, 606.052, 610.59, 614.988, 619.181, 623.179, 626.931, 630.568, 634.037, 637.348, 640.46, 641.501, 680.783, 702.58, 711.398, 715.409, 732.313, 748.835, 742.322, 720.756, 704.692, 698.564, 695.178, 689.166, 682.359, 680.444, 688.309, 708.391, 741.114, 785.408, 839.26, 899.463, 961.974, 1021.67, 1073.21, 1111.67, 1133.36, 1136.72, 1122.37, 1092.76, 1051.49, 1002.33, 948.895, 893.972, 839.782, 787.708, 738.575, 692.917, 650.805, 612.273, 577.097
};
const G4double G4BaryonPartialWidth::pwD1950_Nstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.70553e-15, 2.48362e-07, 2.55073e-05, 0.000558795, 0.00633721, 0.0497407, 0.282629, 1.21319, 3.84233, 9.47956, 19.1922, 34.235, 54.9492, 81.2501, 112.018, 147.338, 185.618, 225.704, 266.536, 306.57, 346.426, 384.935, 421.754, 456.134, 489.105, 520.069, 549.062, 575.735, 601.055, 624.678, 646.716, 666.96, 686.183, 704.144, 720.943, 736.671, 751.181, 765.027, 778.033, 790.266, 801.605, 812.475, 822.734, 832.428, 841.454, 850.145, 858.384, 866.202, 873.511, 880.578, 887.303, 893.71, 899.817, 905.554, 911.124, 916.447, 921.539, 926.336, 931.008, 935.487, 939.782, 943.841, 945.201, 998.229, 1027.87, 1046.31, 1058.68, 1067.42, 1073.9, 1078.73, 1082.52, 1085.93, 1088.7, 1090.24, 1090.74, 1091.19, 1092.59, 1095.4, 1099.4, 1103.84, 1107.64, 1109.77, 1109.54, 1106.83, 1102.05, 1095.95, 1089.35, 1082.98, 1077.32, 1072.59, 1068.81, 1065.87, 1063.59, 1061.84, 1060.52, 1059.63, 1059.25, 1059.52, 1060.63, 1062.79, 1066.18, 1070.99
};

const G4double G4BaryonPartialWidth::pwL1405_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9.39894, 46.389, 66.0136, 81.3803, 94.0398, 105.12, 114.805, 123.359, 130.859, 137.694, 143.849, 149.415, 154.391, 159.002, 163.216, 167.079, 170.629, 173.849, 176.874, 179.673, 182.268, 184.642, 186.89, 188.985, 190.942, 192.745, 194.461, 196.072, 197.585, 198.986, 200.327, 201.592, 202.786, 203.914, 204.965, 205.977, 206.936, 207.846, 208.696, 209.518, 210.3, 211.044, 211.743, 212.42, 213.066, 213.683, 214.263, 214.827, 215.367, 215.884, 216.379, 216.846, 217.302, 217.739, 218.16, 218.557, 218.945, 219.319, 219.678, 220.019, 220.133, 224.67, 227.254, 228.862, 229.932, 230.678, 231.22, 231.625, 231.937, 232.181, 232.377, 232.535, 232.665, 232.774, 232.865, 232.943, 233.01, 233.067, 233.117, 233.16, 233.199, 233.233, 233.263, 233.29, 233.314, 233.336, 233.355, 233.373, 233.389, 233.404, 233.417, 233.43, 233.441, 233.451, 233.461, 233.47, 233.478, 233.486, 233.493, 233.5
};

const G4double G4BaryonPartialWidth::pwL1520_NKbar[120] = 
{
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.2455, 7.31234, 14.4928, 21.9416, 29.1406, 35.9259, 42.1425, 47.9876, 53.373, 58.3276, 62.8139, 67.0122, 70.8786, 74.4434, 77.7348, 80.7308, 83.5525, 86.1695, 88.6005, 90.8269, 92.9366, 94.9051, 96.7446, 98.439, 100.054, 101.568, 102.992, 104.309, 105.571, 106.76, 107.883, 108.944, 109.931, 110.882, 111.783, 112.637, 113.436, 114.208, 114.941, 115.64, 116.295, 116.929, 117.535, 118.113, 118.657, 119.185, 119.691, 120.174, 120.638, 121.075, 121.502, 121.911, 122.304, 122.675, 123.038, 123.387, 123.723, 124.041, 124.148, 128.379, 130.783, 132.277, 133.27, 133.962, 134.465, 134.84, 135.129, 135.355, 135.536, 135.683, 135.804, 135.904, 135.989, 136.061, 136.122, 136.176, 136.222, 136.262, 136.298, 136.329, 136.357, 136.382, 136.404, 136.424, 136.442, 136.459, 136.474, 136.487, 136.5, 136.511, 136.522, 136.531, 136.54, 136.548, 136.556, 136.563, 136.57, 136.576
};
const G4double G4BaryonPartialWidth::pwL1520_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0231592, 1.23725, 3.65034, 6.9386, 10.778, 15.0701, 19.5696, 24.1329, 28.5831, 32.9945, 37.2457, 41.3078, 45.1048, 48.7556, 52.1969, 55.4338, 58.4744, 61.2835, 63.9635, 66.4776, 68.8365, 71.0159, 73.0971, 75.0527, 76.8915, 78.5947, 80.2257, 81.7629, 83.2129, 84.5604, 85.8551, 87.0795, 88.2383, 89.336, 90.3603, 91.3486, 92.287, 93.1788, 94.0136, 94.8215, 95.591, 96.3244, 97.0129, 97.681, 98.3192, 98.9291, 99.5031, 100.062, 100.596, 101.109, 101.6, 102.064, 102.516, 102.951, 103.368, 103.763, 104.149, 104.52, 104.878, 105.217, 105.33, 109.853, 112.433, 114.04, 115.11, 115.856, 116.398, 116.803, 117.115, 117.359, 117.554, 117.713, 117.843, 117.952, 118.043, 118.121, 118.188, 118.245, 118.295, 118.338, 118.377, 118.411, 118.441, 118.468, 118.492, 118.514, 118.533, 118.551, 118.567, 118.582, 118.595, 118.608, 118.619, 118.629, 118.639, 118.648, 118.656, 118.664, 118.671, 118.678
};
const G4double G4BaryonPartialWidth::pwL1520_Sstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00251799, 0.0697787, 0.610144, 1.95783, 2.89958, 3.65371, 4.2957, 4.84837, 5.34703, 5.79346, 6.19585, 6.55486, 6.8872, 7.19077, 7.46895, 7.72462, 7.95663, 8.17465, 8.37611, 8.56345, 8.73498, 8.89657, 9.04854, 9.19059, 9.31699, 9.44837, 9.56047, 9.66282, 9.77728, 9.87947, 9.95124, 10.03, 10.1358, 10.2347, 10.2922, 10.3222, 10.3705, 10.4576, 10.5711, 10.665, 10.7018, 10.6913, 10.6758, 10.6909, 10.7506, 10.8529, 10.9855, 11.1104, 11.1834, 11.1821, 11.1232, 11.0439, 10.9809, 10.9517, 10.9575, 10.997, 11.0737, 11.1927, 11.3487, 11.4088, 11.2288, 11.4434, 10.9078, 13.007, 15.9661, 10.0389, 9.18256, 12.1499, 13.0314, 9.59687, 7.33862, 6.61768, 6.86791, 7.90481, 9.82577, 12.9439, 17.7795, 24.8098, 33.4907, 40.36, 40.6083, 34.6399, 27.0657, 20.6868, 15.9907, 12.6391, 10.2389, 8.48431, 7.17514, 6.17469, 5.39575, 4.7769, 4.27801, 3.86955, 3.53054, 3.24646, 3.00556, 2.7998, 2.62233
};
const G4double G4BaryonPartialWidth::pwL1520_Lgamma[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0203936, 0.0529432, 0.0808573, 0.104614, 0.125641, 0.144046, 0.160246, 0.174362, 0.18713, 0.198531, 0.208754, 0.217814, 0.226139, 0.233685, 0.240544, 0.246702, 0.252428, 0.257678, 0.262501, 0.266944, 0.270981, 0.274779, 0.278299, 0.281567, 0.28456, 0.287396, 0.290043, 0.292517, 0.294796, 0.29697, 0.29901, 0.300927, 0.302704, 0.304406, 0.306011, 0.307527, 0.308961, 0.310296, 0.311582, 0.312801, 0.313959, 0.315041, 0.316087, 0.317083, 0.31803, 0.31892, 0.319782, 0.320605, 0.321391, 0.322131, 0.32285, 0.323538, 0.324197, 0.324829, 0.325425, 0.326006, 0.326564, 0.3271, 0.327607, 0.328103, 0.32858, 0.329038, 0.329473, 0.329619, 0.335415, 0.338719, 0.340776, 0.342145, 0.3431, 0.343793, 0.344313, 0.344712, 0.345024, 0.345275, 0.345478, 0.345645, 0.345784, 0.345901, 0.346, 0.346085, 0.346159, 0.346223, 0.346279, 0.346328, 0.346371, 0.34641, 0.346444, 0.346475, 0.346503, 0.346528, 0.346551, 0.346571, 0.34659, 0.346607, 0.346623, 0.346638, 0.346651, 0.346663, 0.346675, 0.346685, 0.346695, 0.346704, 0.346713
};

const G4double G4BaryonPartialWidth::pwL1600_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.88058, 29.257, 47.4193, 64.4572, 80.3135, 95.1562, 108.891, 122.066, 134.53, 146.35, 157.408, 168.115, 178.33, 188.092, 197.435, 206.248, 214.847, 223.109, 231.057, 238.59, 245.973, 253.097, 259.977, 266.521, 272.958, 279.19, 285.228, 290.989, 296.671, 302.187, 307.546, 312.754, 317.739, 322.669, 327.469, 332.144, 336.627, 341.07, 345.404, 349.632, 353.693, 357.725, 361.663, 365.512, 369.214, 372.894, 376.494, 380.017, 383.465, 386.787, 390.094, 393.334, 396.509, 399.571, 402.623, 405.616, 408.552, 411.386, 412.35, 456.703, 490.036, 516.1, 537.135, 554.474, 569.052, 581.47, 592.199, 601.55, 609.788, 617.09, 623.614, 629.484, 634.784, 639.603, 643.996, 648.024, 651.725, 655.142, 658.303, 661.24, 663.971, 666.519, 668.905, 671.14, 673.24, 675.215, 677.079, 678.837, 680.502, 682.077, 683.574, 684.993, 686.344, 687.632, 688.858, 690.03, 691.148, 692.219
};
const G4double G4BaryonPartialWidth::pwL1600_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.37425, 21.4182, 43.6184, 66.9852, 90.5174, 114.562, 138.439, 161.95, 184.594, 207.03, 228.831, 249.971, 270.113, 289.921, 309.069, 327.572, 345.448, 362.447, 379.146, 395.287, 410.891, 425.744, 440.354, 454.495, 468.189, 481.245, 494.109, 506.584, 518.685, 530.244, 541.655, 552.74, 563.514, 573.989, 584.017, 593.937, 603.595, 613.002, 622.021, 630.958, 639.672, 648.172, 656.334, 664.433, 672.341, 680.066, 687.493, 694.873, 702.089, 709.145, 716.048, 722.695, 729.309, 735.785, 742.127, 748.241, 754.33, 760.298, 766.148, 771.793, 773.712, 861.569, 926.98, 977.744, 1018.47, 1051.88, 1079.87, 1103.63, 1124.11, 1141.92, 1157.58, 1171.44, 1183.8, 1194.91, 1204.93, 1214.03, 1222.32, 1229.91, 1236.89, 1243.32, 1249.27, 1254.79, 1259.93, 1264.71, 1269.19, 1273.39, 1277.33, 1281.04, 1284.53, 1287.83, 1290.95, 1293.9, 1296.7, 1299.36, 1301.89, 1304.3, 1306.6, 1308.79, 1310.88, 1312.88
};

const G4double G4BaryonPartialWidth::pwL1670_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.45697, 4.50705, 5.73858, 6.67027, 7.4119, 8.02477, 8.5357, 8.98308, 9.37289, 9.71593, 10.0156, 10.2879, 10.5326, 10.7534, 10.9537, 11.1333, 11.3002, 11.4532, 11.5939, 11.7216, 11.8416, 11.9528, 12.056, 12.1506, 12.2402, 12.3239, 12.4022, 12.4744, 12.5433, 12.608, 12.6689, 12.7263, 12.7796, 12.8308, 12.8791, 12.9249, 12.9677, 13.0089, 13.048, 13.0852, 13.12, 13.1536, 13.1857, 13.2163, 13.2451, 13.273, 13.2997, 13.3252, 13.3496, 13.3726, 13.395, 13.4165, 13.4371, 13.4566, 13.4756, 13.4939, 13.5115, 13.5281, 13.5337, 13.7541, 13.8787, 13.9559, 14.007, 14.0427, 14.0685, 14.0879, 14.1027, 14.1143, 14.1236, 14.1311, 14.1373, 14.1425, 14.1468, 14.1505, 14.1537, 14.1564, 14.1588, 14.1609, 14.1627, 14.1643, 14.1657, 14.167, 14.1681, 14.1692, 14.1701, 14.1709, 14.1717, 14.1724, 14.173, 14.1736, 14.1742, 14.1747, 14.1751, 14.1755, 14.1759, 14.1763, 14.1766, 14.1769
};
const G4double G4BaryonPartialWidth::pwL1670_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.52932, 7.42962, 10.5688, 13.0273, 15.0528, 16.8258, 18.3754, 19.7442, 20.9443, 22.0379, 23.0227, 23.9134, 24.7096, 25.4474, 26.1218, 26.7399, 27.308, 27.8233, 28.3072, 28.7551, 29.1704, 29.5503, 29.9099, 30.2452, 30.5584, 30.8468, 31.1215, 31.3792, 31.6213, 31.8454, 32.0601, 32.2625, 32.4535, 32.6341, 32.8022, 32.9641, 33.1176, 33.2632, 33.3993, 33.5308, 33.6559, 33.775, 33.8868, 33.9951, 34.0985, 34.1972, 34.29, 34.3803, 34.4667, 34.5494, 34.6286, 34.7034, 34.7764, 34.8464, 34.9136, 34.9771, 35.0393, 35.099, 35.1566, 35.211, 35.2293, 35.9553, 36.3688, 36.6261, 36.7973, 36.9167, 37.0034, 37.0683, 37.1182, 37.1573, 37.1885, 37.2139, 37.2347, 37.2521, 37.2667, 37.2792, 37.2898, 37.299, 37.307, 37.314, 37.3201, 37.3255, 37.3304, 37.3347, 37.3385, 37.342, 37.3451, 37.348, 37.3506, 37.3529, 37.3551, 37.357, 37.3588, 37.3605, 37.362, 37.3635, 37.3648, 37.366, 37.3672, 37.3682
};
const G4double G4BaryonPartialWidth::pwL1670_Leta[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25.6575, 39.2052, 48.2528, 55.3689, 61.1762, 66.0671, 70.2088, 73.8851, 77.1277, 80.0132, 82.5994, 84.8958, 87.0128, 88.9403, 90.702, 92.2929, 93.7819, 95.1559, 96.4272, 97.588, 98.6853, 99.7075, 100.662, 101.54, 102.376, 103.16, 103.897, 104.591, 105.234, 105.851, 106.434, 106.985, 107.498, 107.993, 108.462, 108.908, 109.325, 109.728, 110.112, 110.478, 110.821, 111.155, 111.473, 111.778, 112.069, 112.343, 112.61, 112.866, 113.112, 113.344, 113.57, 113.788, 113.997, 114.194, 114.261, 116.877, 118.351, 119.263, 119.868, 120.288, 120.593, 120.821, 120.996, 121.133, 121.243, 121.332, 121.405, 121.466, 121.517, 121.56, 121.597, 121.629, 121.657, 121.682, 121.703, 121.722, 121.739, 121.754, 121.768, 121.78, 121.791, 121.801, 121.81, 121.818, 121.825, 121.832, 121.839, 121.844, 121.85, 121.855, 121.859, 121.864, 121.868, 121.871
};

const G4double G4BaryonPartialWidth::pwL1690_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.520214, 3.31757, 7.09023, 11.4999, 16.2482, 21.1807, 26.1108, 31.1261, 36.0922, 40.9706, 45.6581, 50.2898, 54.7752, 59.1065, 63.2794, 67.2293, 71.0862, 74.7863, 78.3331, 81.677, 84.9323, 88.0482, 91.0299, 93.838, 96.5698, 99.1838, 101.685, 104.042, 106.335, 108.531, 110.634, 112.648, 114.549, 116.4, 118.176, 119.879, 121.488, 123.058, 124.565, 126.013, 127.382, 128.721, 130.008, 131.246, 132.418, 133.566, 134.671, 135.736, 136.762, 137.736, 138.691, 139.612, 140.501, 141.345, 142.175, 142.976, 143.75, 144.487, 144.735, 154.843, 160.84, 164.663, 167.245, 169.066, 170.398, 171.4, 172.173, 172.781, 173.269, 173.665, 173.992, 174.264, 174.494, 174.689, 174.856, 175.001, 175.126, 175.236, 175.333, 175.419, 175.495, 175.562, 175.623, 175.678, 175.728, 175.773, 175.813, 175.851, 175.885, 175.916, 175.944, 175.971, 175.995, 176.018, 176.038, 176.058, 176.076, 176.093
};
const G4double G4BaryonPartialWidth::pwL1690_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0280814, 1.52614, 4.65518, 9.17993, 14.8049, 21.508, 28.9965, 37.0739, 45.4248, 54.1729, 63.0557, 71.9678, 80.6827, 89.42, 97.9849, 106.339, 114.454, 122.187, 129.779, 137.094, 144.131, 150.783, 157.272, 163.493, 169.453, 175.07, 180.536, 185.768, 190.774, 195.488, 200.074, 204.462, 208.663, 212.684, 216.473, 220.162, 223.697, 227.084, 230.28, 233.396, 236.385, 239.253, 241.962, 244.608, 247.149, 249.592, 251.903, 254.163, 256.337, 258.429, 260.444, 262.354, 264.225, 266.028, 267.767, 269.418, 271.038, 272.601, 274.111, 275.546, 276.029, 295.601, 307.105, 314.392, 319.295, 322.741, 325.257, 327.147, 328.604, 329.748, 330.665, 331.41, 332.023, 332.535, 332.965, 333.331, 333.645, 333.916, 334.152, 334.358, 334.539, 334.7, 334.842, 334.969, 335.084, 335.186, 335.279, 335.363, 335.439, 335.509, 335.573, 335.631, 335.685, 335.734, 335.78, 335.822, 335.861, 335.897, 335.931, 335.962
};
const G4double G4BaryonPartialWidth::pwL1690_Sstarpi[120] =
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00510432, 0.320144, 2.82869, 9.97983, 14.9817, 18.9587, 22.3338, 25.2345, 27.849, 30.1879, 32.295, 34.1743, 35.9135, 37.5017, 38.9569, 40.294, 41.507, 42.6468, 43.702, 44.6787, 45.5778, 46.4197, 47.2202, 47.9475, 48.6346, 49.2979, 49.8715, 50.4594, 51.0373, 51.5024, 51.9157, 52.42, 52.9577, 53.3477, 53.5861, 53.8369, 54.2445, 54.7729, 55.2647, 55.5367, 55.5841, 55.5664, 55.6565, 55.9495, 56.45, 57.0627, 57.6418, 57.9942, 58.0304, 57.8104, 57.4974, 57.2356, 57.1213, 57.1846, 57.429, 57.8724, 58.5117, 59.303, 60.1267, 60.3945, 59.947, 58.3043, 56.1337, 73.6007, 76.5631, 50.1158, 50.8424, 66.5527, 63.0734, 46.126, 37.1597, 35.3007, 38.2437, 45.5934, 58.3552, 78.6391, 109.176, 150.07, 191.051, 209.065, 192.48, 156.637, 120.929, 92.9438, 72.7032, 58.2267, 47.7631, 40.0279, 34.1909, 29.6832, 26.1399, 23.3008, 20.9946, 19.0938, 17.5067, 16.1698, 15.0308, 14.054, 13.2083
};

const G4double G4BaryonPartialWidth::pwL1800_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35.5147, 65.1429, 82.9418, 96.4075, 107.126, 115.984, 123.368, 129.834, 135.468, 140.426, 144.758, 148.693, 152.229, 155.421, 158.316, 160.912, 163.324, 165.535, 167.568, 169.414, 171.148, 172.756, 174.248, 175.614, 176.91, 178.119, 179.251, 180.294, 181.29, 182.225, 183.106, 183.935, 184.705, 185.445, 186.144, 186.806, 187.424, 188.019, 188.584, 189.122, 189.625, 190.111, 190.575, 191.018, 191.433, 191.836, 192.222, 192.591, 192.943, 193.276, 193.6, 193.91, 194.208, 194.49, 194.765, 195.029, 195.283, 195.524, 195.604, 198.79, 200.591, 201.706, 202.446, 202.961, 203.334, 203.614, 203.828, 203.996, 204.131, 204.239, 204.329, 204.404, 204.466, 204.52, 204.565, 204.605, 204.639, 204.669, 204.695, 204.718, 204.739, 204.758, 204.774, 204.789, 204.803, 204.815, 204.826, 204.836, 204.845, 204.854, 204.861, 204.868, 204.875, 204.881, 204.887, 204.892, 204.897, 204.901
};
const G4double G4BaryonPartialWidth::pwL1800_NKstarbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
const G4double G4BaryonPartialWidth::pwL1800_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.50627, 21.8634, 31.1002, 38.3344, 44.2944, 49.5114, 54.071, 58.0987, 61.63, 64.8482, 67.7459, 70.3666, 72.7094, 74.8806, 76.8649, 78.6837, 80.3553, 81.8715, 83.2955, 84.6134, 85.8355, 86.9534, 88.0116, 88.9982, 89.9197, 90.7682, 91.5766, 92.3349, 93.0472, 93.7068, 94.3384, 94.934, 95.4962, 96.0275, 96.5222, 96.9985, 97.4501, 97.8785, 98.279, 98.666, 99.0342, 99.3847, 99.7135, 100.032, 100.336, 100.627, 100.9, 101.166, 101.42, 101.663, 101.896, 102.116, 102.331, 102.537, 102.735, 102.922, 103.105, 103.281, 103.45, 103.61, 103.664, 105.8, 107.017, 107.774, 108.278, 108.629, 108.884, 109.075, 109.222, 109.337, 109.429, 109.504, 109.565, 109.616, 109.659, 109.696, 109.727, 109.754, 109.777, 109.798, 109.816, 109.832, 109.846, 109.859, 109.87, 109.881, 109.89, 109.898, 109.906, 109.913, 109.919, 109.925, 109.93, 109.935, 109.94, 109.944, 109.948, 109.951, 109.955, 109.958
};
const G4double G4BaryonPartialWidth::pwL1800_Sstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.38321e-09, 0.000116876, 0.0870355, 3.94551, 13.884, 29.0026, 48.5055, 71.1209, 96.723, 124.155, 152.713, 181.34, 210.511, 239.396, 267.723, 295.293, 321.548, 347.267, 371.952, 395.549, 417.819, 439.258, 459.931, 479.261, 497.646, 515.565, 531.774, 548.01, 563.77, 577.502, 590.135, 604.094, 618.409, 629.939, 638.789, 647.654, 658.975, 672.079, 684.458, 692.978, 697.578, 700.884, 705.914, 714.191, 725.779, 739.035, 751.644, 760.374, 763.771, 762.845, 760.26, 758.479, 759.04, 762.438, 768.679, 778.122, 790.66, 805.563, 820.852, 825.836, 845.051, 835.198, 811.759, 1087.95, 1137.57, 735.464, 749.673, 991.882, 940.673, 683.702, 547.721, 520.528, 566.76, 679.656, 873.844, 1180.87, 1641.84, 2258.43, 2876.21, 3148.17, 2898.8, 2358.91, 1820.78, 1398.87, 1093.61, 875.2, 717.26, 600.442, 512.243, 444.091, 390.493, 347.526, 312.611, 283.824, 259.786, 239.536, 222.287, 207.497, 194.699
};

const G4double G4BaryonPartialWidth::pwL1810_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.17424, 14.031, 23.0368, 31.6404, 39.7715, 47.487, 54.7149, 61.7272, 68.4324, 74.8563, 80.9237, 86.8531, 92.5602, 98.0609, 103.369, 108.416, 113.378, 118.182, 122.837, 127.281, 131.665, 135.924, 140.065, 144.029, 147.953, 151.774, 155.499, 159.074, 162.62, 166.082, 169.463, 172.767, 175.946, 179.107, 182.2, 185.227, 188.145, 191.049, 193.896, 196.686, 199.379, 202.063, 204.697, 207.282, 209.779, 212.272, 214.72, 217.125, 219.489, 221.775, 224.06, 226.306, 228.516, 230.655, 232.795, 234.9, 236.972, 238.98, 239.664, 272.031, 297.563, 318.311, 335.592, 350.214, 362.784, 373.697, 383.283, 391.759, 399.323, 406.104, 412.224, 417.782, 422.842, 427.478, 431.733, 435.66, 439.289, 442.658, 445.79, 448.713, 451.444, 454.002, 456.406, 458.666, 460.797, 462.808, 464.71, 466.511, 468.22, 469.841, 471.384, 472.853, 474.252, 475.589, 476.865, 478.086, 479.254, 480.375
};
const G4double G4BaryonPartialWidth::pwL1810_NKstarbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
const G4double G4BaryonPartialWidth::pwL1810_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.163031, 2.57372, 5.29973, 8.21435, 11.1896, 14.2671, 17.3583, 20.4348, 23.4277, 26.4215, 29.3573, 32.229, 34.9883, 37.7236, 40.3884, 42.9831, 45.5083, 47.9265, 50.3184, 52.6458, 54.9107, 57.0801, 59.2271, 61.3179, 63.3544, 65.3072, 67.2422, 69.1289, 70.9691, 72.736, 74.4891, 76.2008, 77.8727, 79.5062, 81.0773, 82.6388, 84.1659, 85.66, 87.0988, 88.5306, 89.9327, 91.306, 92.6301, 93.9492, 95.2424, 96.5104, 97.7343, 98.9549, 100.153, 101.328, 102.482, 103.598, 104.711, 105.805, 106.88, 107.92, 108.959, 109.98, 110.985, 111.957, 112.288, 127.83, 139.919, 149.632, 157.648, 164.381, 170.133, 175.102, 179.447, 183.274, 186.678, 189.721, 192.461, 194.943, 197.198, 199.26, 201.149, 202.89, 204.497, 205.987, 207.37, 208.659, 209.863, 210.989, 212.047, 213.04, 213.976, 214.858, 215.692, 216.481, 217.23, 217.939, 218.615, 219.256, 219.868, 220.452, 221.009, 221.542, 222.052, 222.54
};
const G4double G4BaryonPartialWidth::pwL1810_Sstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6.79135e-07, 0.00126114, 0.10071, 1.23144, 2.77934, 4.47758, 6.26263, 8.06406, 9.91264, 11.7586, 13.5872, 15.3594, 17.1261, 18.8531, 20.5373, 22.1767, 23.7452, 25.2944, 26.7981, 28.2548, 29.6509, 31.0169, 32.3585, 33.6361, 34.8753, 36.1075, 37.2448, 38.4076, 39.5594, 40.5865, 41.5525, 42.6363, 43.7677, 44.7062, 45.4547, 46.217, 47.1854, 48.3108, 49.3978, 50.1878, 50.6675, 51.0444, 51.5707, 52.3756, 53.4714, 54.723, 55.9379, 56.8306, 57.2655, 57.3229, 57.2307, 57.2103, 57.3975, 57.8395, 58.5387, 59.5373, 60.8295, 62.3547, 63.9305, 64.4507, 69.1948, 70.8194, 70.6337, 103.421, 111.368, 67.4267, 70.3142, 99.4703, 94.7238, 65.9216, 51.2294, 48.8026, 54.6572, 68.3555, 91.9636, 129.504, 186.081, 261.912, 338.042, 371.891, 341.905, 276.341, 211.007, 159.915, 123.105, 96.9146, 78.1042, 64.3003, 53.9683, 46.0593, 39.9001, 35.0126, 31.082, 27.8751, 25.2249, 23.0154, 21.1524, 19.5711, 18.2162
};

const G4double G4BaryonPartialWidth::pwL1820_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.25961, 3.23297, 9.34009, 18.574, 30.5464, 44.8737, 60.8606, 78.6087, 97.4566, 117.021, 136.64, 156.664, 176.532, 196.045, 215.049, 233.139, 250.828, 267.759, 283.902, 299.003, 313.56, 327.331, 340.339, 352.416, 363.99, 374.889, 385.149, 394.653, 403.747, 412.305, 420.358, 427.939, 434.965, 441.696, 448.038, 454.018, 459.571, 464.901, 469.934, 474.69, 479.116, 483.375, 487.406, 491.225, 494.788, 498.225, 501.487, 504.584, 507.528, 510.283, 512.948, 515.485, 517.902, 520.17, 522.369, 524.467, 526.471, 528.354, 528.984, 552.502, 564.429, 571.199, 575.382, 578.128, 580.025, 581.384, 582.392, 583.156, 583.751, 584.222, 584.601, 584.91, 585.166, 585.379, 585.56, 585.713, 585.845, 585.959, 586.058, 586.145, 586.222, 586.289, 586.35, 586.403, 586.452, 586.495, 586.534, 586.57, 586.602, 586.631, 586.658, 586.683, 586.706, 586.726, 586.746, 586.763, 586.78, 586.795
};
const G4double G4BaryonPartialWidth::pwL1820_Spi[120] =
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.000612464, 0.113735, 0.523445, 1.34779, 2.64825, 4.5172, 6.95011, 9.92451, 13.3298, 17.2067, 21.4191, 25.8785, 30.423, 35.1226, 39.8337, 44.497, 49.0647, 53.4297, 57.7084, 61.8092, 65.7207, 69.3785, 72.9014, 76.2298, 79.3685, 82.2775, 85.06, 87.6751, 90.1319, 92.4032, 94.5724, 96.6097, 98.5237, 100.322, 101.987, 103.579, 105.078, 106.489, 107.797, 109.052, 110.237, 111.355, 112.395, 113.394, 114.341, 115.237, 116.072, 116.878, 117.643, 118.369, 119.059, 119.704, 120.329, 120.924, 121.491, 122.023, 122.539, 123.032, 123.502, 123.945, 124.093, 129.647, 132.504, 134.15, 135.181, 135.867, 136.346, 136.693, 136.953, 137.152, 137.307, 137.431, 137.532, 137.614, 137.683, 137.74, 137.789, 137.831, 137.867, 137.898, 137.925, 137.949, 137.97, 137.989, 138.006, 138.021, 138.034, 138.046, 138.057, 138.067, 138.076, 138.084, 138.092, 138.099, 138.105, 138.111, 138.117, 138.122, 138.126, 138.131
};
const G4double G4BaryonPartialWidth::pwL1820_Sstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7.6365e-07, 0.00141779, 0.113265, 1.3865, 3.1318, 5.04871, 7.0655, 9.1025, 11.1944, 13.2848, 15.3571, 17.3666, 19.3711, 21.3316, 23.2446, 25.1078, 26.8912, 28.6535, 30.3649, 32.0234, 33.6137, 35.1704, 36.6998, 38.1569, 39.5708, 40.977, 42.2756, 43.6036, 44.9195, 46.0936, 47.1983, 48.4375, 49.7314, 50.8054, 51.663, 52.5365, 53.6452, 54.9334, 56.1781, 57.084, 57.6355, 58.0697, 58.6745, 59.5977, 60.8534, 62.2873, 63.6798, 64.7041, 65.2051, 65.2746, 65.1729, 65.1532, 65.3709, 65.88, 66.6833, 67.8291, 69.3112, 71.0601, 72.8671, 73.4638, 78.9616, 80.88, 80.7141, 118.409, 127.593, 77.1381, 80.4808, 114.02, 108.591, 75.4998, 58.6334, 55.8586, 62.598, 78.3588, 105.529, 148.745, 213.892, 301.218, 388.898, 427.894, 393.381, 317.897, 242.675, 183.856, 141.484, 111.341, 89.6961, 73.8152, 61.9315, 52.8368, 45.756, 40.1386, 35.6221, 31.938, 28.8943, 26.3573, 24.2187, 22.4038, 20.8491
};

const G4double G4BaryonPartialWidth::pwL1830_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.171906, 1.11392, 2.41901, 3.98656, 5.72088, 7.57103, 9.46842, 11.4475, 13.4556, 15.4754, 17.4606, 19.4654, 21.4483, 23.4025, 25.3225, 27.1739, 29.0144, 30.8108, 32.5615, 34.2383, 35.8955, 37.5051, 39.0671, 40.5579, 42.0268, 43.4498, 44.8277, 46.1404, 47.4319, 48.6814, 49.8902, 51.0594, 52.1723, 53.2665, 54.3248, 55.3482, 56.3223, 57.2801, 58.2066, 59.1028, 59.9561, 60.7954, 61.6077, 62.3938, 63.1426, 63.8797, 64.5934, 65.2845, 65.954, 66.5923, 67.2211, 67.8305, 68.4213, 68.9849, 69.5406, 70.0796, 70.6025, 71.1018, 71.2703, 78.3165, 82.6678, 85.5105, 87.4623, 88.8538, 89.8803, 90.6569, 91.2591, 91.7344, 92.1165, 92.4277, 92.6847, 92.8995, 93.0806, 93.2348, 93.367, 93.4814, 93.5809, 93.6681, 93.7447, 93.8127, 93.873, 93.9269, 93.9753, 94.0188, 94.0582, 94.0938, 94.1263, 94.1558, 94.1829, 94.2076, 94.2304, 94.2514, 94.2708, 94.2887, 94.3053, 94.3207, 94.335, 94.3484
};
const G4double G4BaryonPartialWidth::pwL1830_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0374798, 2.04587, 6.30045, 12.5627, 20.5026, 30.167, 41.2077, 53.3927, 66.2824, 80.0973, 94.4485, 109.173, 123.886, 138.95, 154.022, 169.017, 183.863, 198.267, 212.656, 226.756, 240.537, 253.765, 266.858, 279.587, 291.945, 303.739, 315.358, 326.607, 337.49, 347.848, 358.027, 367.862, 377.362, 386.537, 395.256, 403.815, 412.078, 420.055, 427.634, 435.074, 442.257, 449.193, 455.785, 462.259, 468.512, 474.553, 480.299, 485.944, 491.401, 496.678, 501.78, 506.637, 511.415, 516.038, 520.513, 524.776, 528.973, 533.038, 536.977, 540.732, 541.999, 594.432, 626.285, 646.87, 660.9, 670.849, 678.16, 683.676, 687.943, 691.305, 694.005, 696.201, 698.013, 699.526, 700.8, 701.885, 702.815, 703.619, 704.318, 704.931, 705.469, 705.946, 706.37, 706.748, 707.088, 707.393, 707.669, 707.919, 708.147, 708.354, 708.544, 708.718, 708.877, 709.024, 709.16, 709.286, 709.402, 709.51, 709.611, 709.704
};
const G4double G4BaryonPartialWidth::pwL1830_Sstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6.17942e-10, 3.0272e-05, 0.0225487, 1.02531, 3.62522, 7.61432, 12.8094, 18.8934, 25.8504, 33.3798, 41.2946, 49.3023, 57.5343, 65.754, 73.8781, 81.8432, 89.4794, 97.0068, 104.274, 111.259, 117.884, 124.292, 130.497, 136.323, 141.884, 147.322, 152.262, 157.219, 162.04, 166.263, 170.162, 174.46, 178.869, 182.443, 185.215, 187.992, 191.506, 195.555, 199.388, 202.058, 203.548, 204.644, 206.259, 208.85, 212.437, 216.524, 220.416, 223.138, 224.25, 224.055, 223.357, 222.901, 223.148, 224.249, 226.205, 229.125, 232.977, 237.541, 242.218, 243.743, 250.498, 248.158, 241.533, 324.787, 339.866, 219.316, 223.715, 296.481, 281.203, 204.191, 163.44, 155.335, 169.262, 203.161, 261.391, 353.384, 491.445, 676.081, 861.069, 942.518, 867.876, 706.234, 545.104, 418.766, 327.356, 261.947, 214.645, 179.656, 153.236, 132.82, 116.763, 103.89, 93.4282, 84.8027, 77.6, 71.5323, 66.3639, 61.9327, 58.0986
};

const G4double G4BaryonPartialWidth::pwL1890_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.47038, 8.33618, 13.7216, 18.8852, 23.7804, 28.4384, 32.813, 37.0672, 41.1442, 45.0586, 48.7633, 52.3907, 55.8888, 59.2666, 62.532, 65.6421, 68.7051, 71.6753, 74.5581, 77.3139, 80.0375, 82.6873, 85.2671, 87.7404, 90.1915, 92.5825, 94.916, 97.1585, 99.3859, 101.563, 103.692, 105.776, 107.783, 109.78, 111.737, 113.655, 115.505, 117.349, 119.158, 120.934, 122.648, 124.36, 126.041, 127.693, 129.29, 130.885, 132.454, 133.997, 135.514, 136.983, 138.452, 139.899, 141.322, 142.701, 144.082, 145.442, 146.782, 148.081, 148.524, 169.619, 186.459, 200.279, 211.883, 221.769, 230.318, 237.778, 244.361, 250.204, 255.437, 260.143, 264.403, 268.281, 271.82, 275.07, 278.059, 280.822, 283.379, 285.758, 287.972, 290.042, 291.977, 293.793, 295.501, 297.108, 298.625, 300.058, 301.415, 302.7, 303.92, 305.08, 306.184, 307.235, 308.237, 309.195, 310.111, 310.987, 311.826, 312.631
};
const G4double G4BaryonPartialWidth::pwL1890_NKstarbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7.56779e-06, 0.00225411, 0.0250444, 0.193381, 2.82226, 21.3478, 42.216, 61.261, 78.34, 94.2586, 108.933, 122.53, 135.183, 146.82, 157.91, 168.333, 178.156, 187.289, 196.079, 204.416, 212.336, 219.755, 226.945, 233.81, 240.371, 246.537, 252.562, 258.342, 263.852, 269.232, 274.2, 279.215, 283.92, 288.461, 293.021, 297.005, 301.26, 305.561, 308.905, 312.566, 316.884, 320.317, 322.822, 326.176, 330.49, 333.978, 335.864, 337.707, 341.071, 345.585, 349.331, 350.94, 351.408, 352.677, 355.823, 360.492, 362.221, 394.115, 437.272, 415.218, 452.973, 421.135, 577.539, 465.662, 423.85, 451.336, 367.704, 495.078, 830.851, 841.398, 523.811, 349.011, 292.683, 309.907, 397.788, 561.527, 710.374, 660.051, 491.311, 356.903, 276.358, 231.789, 209.019, 200.335, 201.811, 211.693, 229.561, 255.881, 292.041, 340.23, 403.861, 487.914, 599.149, 747.226, 943.999, 1203
};
const G4double G4BaryonPartialWidth::pwL1890_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0668762, 1.05886, 2.18572, 3.39477, 4.63275, 5.91689, 7.21019, 8.50051, 9.75875, 11.0202, 12.2599, 13.4751, 14.6451, 15.8072, 16.9415, 18.048, 19.1268, 20.1617, 21.1871, 22.1865, 23.1606, 24.0952, 25.0215, 25.925, 26.8063, 27.6527, 28.4925, 29.3125, 30.1134, 30.8834, 31.6485, 32.3964, 33.1279, 33.8435, 34.5326, 35.2183, 35.8898, 36.5474, 37.1815, 37.8132, 38.4325, 39.0397, 39.6258, 40.2103, 40.784, 41.347, 41.891, 42.4341, 42.9675, 43.4916, 44.0067, 44.5048, 45.0027, 45.4922, 45.9737, 46.4397, 46.9059, 47.3645, 47.816, 48.2533, 48.4023, 55.4453, 60.9903, 65.4897, 69.2337, 72.3998, 75.1209, 77.4831, 79.558, 81.3929, 83.0306, 84.4991, 85.8248, 87.0288, 88.1254, 89.1302, 90.0527, 90.9042, 91.6913, 92.4223, 93.1019, 93.7364, 94.3291, 94.8846, 95.4066, 95.8974, 96.3604, 96.7971, 97.2106, 97.6018, 97.9732, 98.3257, 98.6613, 98.9805, 99.2849, 99.5756, 99.8532, 100.119, 100.373, 100.617
};
const G4double G4BaryonPartialWidth::pwL1890_Sstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.06826e-06, 0.00383583, 0.307159, 3.78403, 8.58719, 13.8964, 19.513, 25.2139, 31.0952, 36.9973, 42.8715, 48.5893, 54.3132, 59.931, 65.4305, 70.8036, 75.9621, 81.0743, 86.0526, 90.8907, 95.5416, 100.106, 104.601, 108.895, 113.07, 117.232, 121.087, 125.034, 128.951, 132.46, 135.769, 139.479, 143.357, 146.59, 149.188, 151.835, 155.183, 159.066, 162.827, 165.585, 167.292, 168.65, 170.517, 173.334, 177.147, 181.495, 185.727, 188.862, 190.433, 190.711, 190.473, 190.481, 191.2, 192.793, 195.271, 198.78, 203.305, 208.639, 214.154, 215.978, 233.83, 240.734, 241.125, 358.192, 387.643, 232.16, 242.993, 347.592, 331.262, 228.875, 176.968, 168.645, 189.753, 238.975, 323.999, 459.542, 664.191, 938.777, 1214.67, 1337.62, 1229.47, 992.481, 756.332, 571.773, 438.934, 344.538, 276.842, 227.248, 190.195, 161.884, 139.88, 122.453, 108.465, 97.0742, 87.6785, 79.8591, 73.2777, 67.7006, 62.93
};

const G4double G4BaryonPartialWidth::pwL2100_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0169316, 0.404011, 1.57301, 3.86223, 7.50576, 12.6982, 19.4551, 28.0795, 38.4959, 50.6635, 64.2474, 79.5432, 96.1468, 113.832, 132.355, 151.153, 170.6, 190.161, 209.626, 228.508, 247.271, 265.48, 283.036, 299.605, 315.681, 330.96, 345.43, 358.881, 371.766, 383.879, 395.25, 405.91, 415.737, 425.091, 433.84, 442.022, 449.553, 456.715, 463.413, 469.678, 475.449, 480.944, 486.09, 490.913, 495.365, 499.612, 503.6, 507.347, 510.87, 514.133, 517.257, 520.2, 522.976, 525.554, 528.03, 530.37, 532.582, 534.644, 535.328, 559.281, 570.105, 575.818, 579.195, 581.353, 582.821, 583.865, 584.636, 585.221, 585.677, 586.04, 586.333, 586.573, 586.773, 586.941, 587.084, 587.206, 587.311, 587.403, 587.483, 587.554, 587.616, 587.672, 587.722, 587.766, 587.806, 587.842, 587.875, 587.905, 587.932, 587.957, 587.98, 588.001, 588.021, 588.039, 588.055, 588.071, 588.085, 588.098
};
const G4double G4BaryonPartialWidth::pwL2100_NKstarbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7.33053e-10, 3.33352e-06, 0.000125869, 0.00279658, 0.171484, 4.12946, 12.5586, 23.285, 35.1209, 47.8963, 61.0614, 74.3694, 87.6482, 100.566, 113.463, 126.065, 138.33, 150.044, 161.574, 172.715, 183.466, 193.664, 203.649, 213.262, 222.508, 231.24, 239.798, 248.025, 255.881, 263.535, 270.622, 277.73, 284.409, 290.835, 297.209, 302.852, 308.765, 314.671, 319.375, 324.417, 330.176, 334.838, 338.358, 342.838, 348.381, 352.909, 355.547, 358.096, 362.365, 367.899, 372.501, 374.633, 375.458, 377.17, 380.968, 386.427, 388.431, 424.314, 466.942, 441.333, 475.216, 440.675, 586.537, 477.125, 434.686, 458.073, 376.892, 494.371, 800.607, 807.604, 514.822, 351.355, 297.37, 312.51, 393.07, 542.16, 676.535, 629.464, 474.553, 350.476, 275.351, 233.253, 211.408, 202.781, 203.71, 212.501, 228.674, 252.574, 285.398, 329.082, 386.69, 462.709, 563.245, 697.033, 874.791, 1108.76
};
const G4double G4BaryonPartialWidth::pwL2100_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.80338e-06, 0.00549659, 0.0377661, 0.126416, 0.303254, 0.612768, 1.09293, 1.78175, 2.69523, 3.8886, 5.36489, 7.12888, 9.13839, 11.4412, 13.9782, 16.7129, 19.6036, 22.5566, 25.6249, 28.7185, 31.7989, 34.7843, 37.7452, 40.6099, 43.3619, 45.9482, 48.4463, 50.8092, 53.0363, 55.0966, 57.0611, 58.8996, 60.6179, 62.2221, 63.6956, 65.093, 66.396, 67.611, 68.7264, 69.7847, 70.7723, 71.6946, 72.5429, 73.3496, 74.1043, 74.8111, 75.4632, 76.0851, 76.669, 77.2176, 77.7335, 78.2115, 78.6695, 79.1012, 79.5087, 79.8875, 80.2517, 80.5962, 80.9225, 81.2268, 81.328, 84.9167, 86.5992, 87.5196, 88.0805, 88.4481, 88.7032, 88.8876, 89.0257, 89.1317, 89.2151, 89.2818, 89.3362, 89.381, 89.4184, 89.45, 89.4769, 89.5, 89.52, 89.5374, 89.5527, 89.5662, 89.5781, 89.5888, 89.5983, 89.6068, 89.6145, 89.6215, 89.6278, 89.6336, 89.6388, 89.6436, 89.6481, 89.6521, 89.6559, 89.6593, 89.6625, 89.6655, 89.6683, 89.6709
};
const G4double G4BaryonPartialWidth::pwL2100_Sstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5.67742e-10, 2.7698e-05, 0.0206517, 0.95025, 3.42383, 7.35267, 12.6757, 19.1809, 26.9599, 35.7778, 45.4903, 55.7806, 66.8513, 78.4121, 90.3468, 102.551, 114.731, 127.209, 139.714, 152.169, 164.384, 176.591, 188.769, 200.565, 212.121, 223.714, 234.575, 245.67, 256.662, 266.635, 276.075, 286.469, 297.226, 306.304, 313.763, 321.281, 330.461, 340.865, 350.896, 358.393, 363.261, 367.214, 372.356, 379.722, 389.389, 400.22, 410.667, 418.427, 422.445, 423.4, 423.125, 423.403, 425.302, 429.181, 435.034, 443.175, 453.517, 465.551, 477.846, 481.879, 516.497, 523.854, 517.283, 720.458, 760.109, 480.692, 494.211, 666.675, 632.901, 454.863, 360.778, 343.145, 377.041, 457.046, 592.613, 805.045, 1122.44, 1546, 1970.07, 2156.92, 1986.17, 1615.98, 1246.79, 957.184, 747.532, 597.414, 488.767, 408.334, 347.547, 300.535, 263.532, 233.848, 209.716, 189.816, 173.198, 159.203, 147.289, 137.082, 128.26
};
const G4double G4BaryonPartialWidth::pwL2100_Leta[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0122592, 0.116912, 0.372754, 0.828572, 1.50542, 2.41001, 3.51285, 4.82653, 6.30026, 7.89337, 9.56334, 11.2419, 12.9486, 14.626, 16.2507, 17.7814, 19.257, 20.6455, 21.9441, 23.1343, 24.2573, 25.2966, 26.2567, 27.1289, 27.9471, 28.7017, 29.3976, 30.0397, 30.6235, 31.1721, 31.6797, 32.1497, 32.5788, 32.9838, 33.3602, 33.7105, 34.0318, 34.3367, 34.6215, 34.8879, 35.1334, 35.3676, 35.5874, 35.794, 35.9884, 36.1687, 36.3416, 36.5048, 36.6591, 36.8027, 36.941, 37.0722, 37.1966, 37.3128, 37.3515, 38.7511, 39.4366, 39.8254, 40.0689, 40.2319, 40.3469, 40.431, 40.4946, 40.5438, 40.5827, 40.6141, 40.6397, 40.6609, 40.6786, 40.6937, 40.7065, 40.7176, 40.7271, 40.7355, 40.7428, 40.7493, 40.755, 40.7601, 40.7647, 40.7689, 40.7726, 40.7759, 40.779, 40.7818, 40.7843, 40.7866, 40.7888, 40.7907, 40.7926, 40.7942, 40.7958, 40.7972, 40.7986, 40.7998
};
const G4double G4BaryonPartialWidth::pwL2100_Lomega[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.05582e-10, 6.314e-09, 8.90869e-08, 8.69802e-07, 9.89137e-06, 0.00169735, 2.51283, 7.43148, 13.3761, 20.1553, 25.7058, 32.7937, 40.436, 43.3808, 49.2508, 65.1159, 67.1573, 76.5873, 86.3587, 73.0872, 105.26, 85.6851, 84.7162, 89.4715, 93.1027, 96.6768, 91.9305, 138.108, 134.054, 109.847, 117.301, 117.39, 104.988, 182.97, 116.667, 175.42, 102.594, 109.11, 139.415, 140.525, 226.463, 99.0174, 126.236, 234.577, 110.107, 173.787, 115.22, 289.387, 94.9674, 167.004, 112.398, 355.848, 100.852, 172.785, 105.966, 144.227, 237.577, 276.919, 265.644, 120.118, 229.572, 431.592, 257.091, 32.5039, 151.033, 42.8617, 1246.02, 35.0367, 29.9818, 633.354, 56.3043, 18.0221, 23.9514, 66.8898, 457.008, 684.921, 88.6129, 32.5818, 17.1884, 12.2483, 11.87, 15.3204, 25.073, 50.5621, 144.159, 1068.95, 551.32, 112.683, 47.362, 26.2229, 16.8029, 11.973, 9.35213, 7.92082, 7.19963, 6.9467
};

const G4double G4BaryonPartialWidth::pwL2110_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0686973, 0.862792, 2.52764, 5.11864, 8.60034, 12.9429, 18.0146, 23.9296, 30.55, 37.8081, 45.5011, 53.8071, 62.5283, 71.5894, 80.917, 90.2861, 99.9389, 109.662, 119.399, 128.944, 138.567, 148.07, 157.42, 166.443, 175.412, 184.157, 192.663, 200.788, 208.792, 216.532, 224.006, 231.215, 238.048, 244.734, 251.162, 257.338, 263.172, 268.865, 274.324, 279.557, 284.494, 289.302, 293.909, 298.321, 302.48, 306.529, 310.407, 314.121, 317.679, 321.032, 324.298, 327.427, 330.426, 333.254, 336.011, 338.654, 341.189, 343.583, 344.384, 374.943, 390.662, 399.496, 404.855, 408.3, 410.629, 412.264, 413.451, 414.336, 415.013, 415.539, 415.956, 416.292, 416.566, 416.792, 416.981, 417.14, 417.275, 417.39, 417.49, 417.576, 417.651, 417.717, 417.776, 417.828, 417.874, 417.915, 417.952, 417.985, 418.015, 418.043, 418.068, 418.09, 418.111, 418.13, 418.147, 418.163, 418.178, 418.192
};
const G4double G4BaryonPartialWidth::pwL2110_NKstarbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6.49594e-06, 0.00189981, 0.0211259, 0.164203, 2.47004, 19.8456, 40.8622, 61.0642, 79.9178, 98.0856, 115.331, 131.736, 147.373, 162.072, 176.373, 190.079, 203.236, 215.684, 227.867, 239.609, 250.938, 261.709, 272.298, 282.551, 292.483, 301.94, 311.297, 320.385, 329.159, 337.814, 345.919, 354.163, 362.008, 369.659, 377.367, 384.277, 391.631, 399.09, 405.121, 411.68, 419.27, 425.534, 430.379, 436.57, 444.275, 450.718, 454.677, 458.561, 464.87, 473.017, 479.97, 483.52, 485.27, 488.301, 494.352, 502.861, 505.994, 576.251, 666.871, 642.104, 722.34, 675.326, 977.433, 776.136, 705.72, 764.314, 612.781, 860.709, 1521.73, 1548.69, 931.744, 598.783, 494.947, 530.567, 702.579, 1025.7, 1322.58, 1226.09, 896.238, 635.728, 481.775, 397.975, 356.05, 340.874, 344.931, 365.017, 400.542, 452.649, 524.283, 619.96, 746.622, 914.315, 1136.63, 1432.95, 1827.01, 2345.9
};
const G4double G4BaryonPartialWidth::pwL2110_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.000866016, 0.160576, 0.743086, 1.93112, 3.84295, 6.66427, 10.4606, 15.2877, 21.0645, 27.972, 35.8885, 44.7548, 54.3293, 64.8347, 76.0186, 87.7731, 99.9881, 112.35, 125.162, 138.124, 151.147, 163.939, 176.848, 189.6, 202.141, 214.231, 226.228, 237.903, 249.234, 260.03, 270.633, 280.859, 290.703, 300.168, 309.112, 317.835, 326.196, 334.203, 341.745, 349.081, 356.096, 362.801, 369.109, 375.237, 381.092, 386.686, 391.946, 397.056, 401.939, 406.606, 411.066, 415.263, 419.343, 423.246, 426.979, 430.495, 433.917, 437.194, 440.332, 443.291, 444.281, 481.78, 500.958, 511.764, 518.361, 522.636, 525.551, 527.614, 529.126, 530.261, 531.136, 531.821, 532.368, 532.812, 533.175, 533.477, 533.731, 533.945, 534.128, 534.285, 534.422, 534.541, 534.645, 534.736, 534.818, 534.89, 534.955, 535.013, 535.065, 535.112, 535.155, 535.194, 535.229, 535.261, 535.291, 535.318, 535.343, 535.367, 535.388, 535.408
};

const G4double G4BaryonPartialWidth::pwS1385_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.517308, 5.32969, 10.1545, 14.9232, 19.4852, 23.9436, 28.198, 32.2386, 36.0049, 39.6255, 43.0452, 46.274, 49.2751, 52.1578, 54.8826, 57.4597, 59.8994, 62.1745, 64.3685, 66.4511, 68.43, 70.2824, 72.0755, 73.7841, 75.4138, 76.9451, 78.4328, 79.8555, 81.2174, 82.5013, 83.7529, 84.9538, 86.1069, 87.215, 88.2637, 89.2897, 90.2777, 91.2297, 92.1331, 93.0193, 93.8747, 94.7011, 95.487, 96.2597, 97.0073, 97.7311, 98.4209, 99.1004, 99.7592, 100.398, 101.018, 101.611, 102.195, 102.764, 103.316, 103.844, 104.367, 104.876, 105.371, 105.845, 106.006, 112.973, 117.695, 121.104, 123.686, 125.708, 127.336, 128.675, 129.796, 130.748, 131.568, 132.28, 132.905, 133.458, 133.95, 134.392, 134.79, 135.151, 135.48, 135.781, 136.057, 136.311, 136.546, 136.763, 136.966, 137.155, 137.331, 137.496, 137.651, 137.796, 137.933, 138.063, 138.185, 138.301, 138.41, 138.515, 138.614, 138.708, 138.798, 138.883
};
const G4double G4BaryonPartialWidth::pwS1385_Lpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.43483, 19.291, 35.0027, 50.8954, 66.6483, 81.8108, 96.7567, 111.163, 124.995, 138.033, 150.707, 162.814, 174.373, 185.234, 195.777, 205.847, 215.469, 224.668, 233.329, 241.759, 249.834, 257.575, 264.883, 272.017, 278.871, 285.46, 291.7, 297.807, 303.691, 309.363, 314.749, 320.035, 325.14, 330.075, 334.847, 339.391, 343.865, 348.198, 352.398, 356.405, 360.358, 364.195, 367.922, 371.484, 375.005, 378.428, 381.758, 384.947, 388.104, 391.178, 394.174, 397.093, 399.895, 402.672, 405.382, 408.027, 410.568, 413.091, 415.556, 417.964, 420.281, 421.067, 456.176, 481.214, 500.004, 514.68, 526.457, 536.14, 544.235, 551.117, 557.032, 562.18, 566.695, 570.69, 574.255, 577.449, 580.333, 582.945, 585.327, 587.504, 589.505, 591.347, 593.052, 594.631, 596.1, 597.47, 598.749, 599.948, 601.072, 602.131, 603.127, 604.068, 604.956, 605.798, 606.596, 607.353, 608.074, 608.759, 609.413, 610.036, 610.631
};

const G4double G4BaryonPartialWidth::pwS1660_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.63049, 12.54, 20.5556, 28.1275, 35.2158, 41.8856, 48.0867, 54.0608, 59.7355, 65.1381, 70.2108, 75.1399, 79.8583, 84.3821, 88.7252, 92.8343, 96.8554, 100.73, 104.468, 108.019, 111.509, 114.886, 118.154, 121.271, 124.344, 127.326, 130.221, 132.99, 135.726, 138.389, 140.98, 143.504, 145.924, 148.323, 150.663, 152.945, 155.138, 157.316, 159.443, 161.522, 163.523, 165.512, 167.458, 169.363, 171.199, 173.026, 174.816, 176.57, 178.29, 179.949, 181.603, 183.226, 184.818, 186.356, 187.89, 189.397, 190.877, 192.308, 192.794, 215.424, 232.732, 246.453, 257.651, 266.966, 274.859, 281.627, 287.508, 292.659, 297.217, 301.273, 304.909, 308.191, 311.163, 313.871, 316.346, 318.621, 320.714, 322.652, 324.446, 326.116, 327.671, 329.124, 330.486, 331.763, 332.965, 334.096, 335.165, 336.174, 337.13, 338.036, 338.897, 339.715, 340.493, 341.235, 341.943, 342.619, 343.266, 343.885
};
const G4double G4BaryonPartialWidth::pwS1660_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.58111, 6.33902, 12.6955, 19.4193, 26.2209, 33.1996, 40.1576, 47.0346, 53.682, 60.2911, 66.7347, 73.0028, 78.9937, 84.9024, 90.6307, 96.1814, 101.559, 106.685, 111.735, 116.627, 121.368, 125.891, 130.351, 134.677, 138.875, 142.886, 146.847, 150.695, 154.436, 158.015, 161.556, 165.001, 168.356, 171.624, 174.758, 177.864, 180.892, 183.846, 186.683, 189.499, 192.249, 194.935, 197.518, 200.085, 202.596, 205.051, 207.415, 209.767, 212.07, 214.325, 216.534, 218.664, 220.785, 222.865, 224.905, 226.873, 228.835, 230.761, 232.651, 234.477, 235.098, 263.784, 285.476, 302.517, 316.324, 327.744, 337.375, 345.601, 352.724, 358.946, 364.439, 369.316, 373.68, 377.612, 381.168, 384.405, 387.359, 390.07, 392.564, 394.869, 397.003, 398.987, 400.833, 402.557, 404.172, 405.686, 407.11, 408.449, 409.714, 410.908, 412.038, 413.109, 414.126, 415.092, 416.011, 416.887, 417.722, 418.52, 419.282, 420.012
};
const G4double G4BaryonPartialWidth::pwS1660_Lpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.34523, 6.07483, 11.3098, 16.7972, 22.4063, 27.9551, 33.5634, 39.0974, 44.5283, 49.753, 54.9316, 59.9708, 64.8681, 69.5477, 74.1644, 78.6433, 82.9879, 87.2024, 91.2262, 95.196, 99.0492, 102.791, 106.367, 109.9, 113.335, 116.674, 119.872, 123.036, 126.117, 129.118, 131.996, 134.849, 137.63, 140.345, 142.994, 145.539, 148.067, 150.536, 152.95, 155.273, 157.582, 159.842, 162.053, 164.184, 166.305, 168.382, 170.418, 172.382, 174.338, 176.257, 178.139, 179.986, 181.769, 183.548, 185.295, 187.01, 188.668, 190.323, 191.95, 193.549, 195.096, 195.622, 220.215, 239.173, 254.29, 266.685, 277.037, 285.839, 293.408, 300.001, 305.79, 310.922, 315.497, 319.606, 323.319, 326.687, 329.76, 332.571, 335.157, 337.54, 339.747, 341.792, 343.698, 345.473, 347.134, 348.691, 350.152, 351.528, 352.824, 354.048, 355.205, 356.302, 357.341, 358.329, 359.268, 360.162, 361.015, 361.829, 362.607, 363.35, 364.062
};

const G4double G4BaryonPartialWidth::pwS1670_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.326158, 2.20721, 4.74356, 7.69372, 10.8525, 14.1149, 17.3573, 20.6379, 23.8693, 27.0277, 30.0481, 33.0192, 35.884, 38.639, 41.2831, 43.7767, 46.2032, 48.5234, 50.7405, 52.8246, 54.8479, 56.7793, 58.623, 60.355, 62.0363, 63.6415, 65.1744, 66.6155, 68.0156, 69.3537, 70.6331, 71.8567, 73.0089, 74.1303, 75.204, 76.2326, 77.2026, 78.1482, 79.0551, 79.9252, 80.7472, 81.5498, 82.3208, 83.0618, 83.7629, 84.4486, 85.1084, 85.7435, 86.3551, 86.9349, 87.5031, 88.0508, 88.5791, 89.0807, 89.5729, 90.0481, 90.5071, 90.9436, 91.0904, 97.054, 100.572, 102.806, 104.312, 105.371, 106.146, 106.728, 107.177, 107.53, 107.813, 108.043, 108.232, 108.39, 108.523, 108.636, 108.733, 108.817, 108.89, 108.953, 109.009, 109.059, 109.103, 109.142, 109.178, 109.209, 109.238, 109.264, 109.288, 109.309, 109.329, 109.347, 109.363, 109.379, 109.393, 109.406, 109.418, 109.429, 109.44, 109.449
};
const G4double G4BaryonPartialWidth::pwS1670_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0807088, 2.78302, 8.20648, 15.961, 25.5277, 36.8558, 49.439, 62.9403, 76.8306, 91.3143, 105.957, 120.587, 134.838, 149.073, 162.98, 176.499, 189.593, 202.033, 214.214, 225.921, 237.155, 247.751, 258.066, 267.935, 277.372, 286.25, 294.875, 303.117, 310.991, 318.396, 325.59, 332.466, 339.038, 345.323, 351.239, 356.994, 362.501, 367.774, 372.745, 377.587, 382.227, 386.677, 390.878, 394.977, 398.912, 402.691, 406.265, 409.757, 413.115, 416.346, 419.454, 422.4, 425.284, 428.062, 430.74, 433.282, 435.774, 438.179, 440.5, 442.706, 443.448, 473.451, 491.021, 502.127, 509.588, 514.827, 518.651, 521.52, 523.731, 525.468, 526.859, 527.989, 528.919, 529.695, 530.348, 530.903, 531.379, 531.79, 532.147, 532.46, 532.734, 532.978, 533.194, 533.387, 533.56, 533.715, 533.856, 533.983, 534.099, 534.204, 534.301, 534.389, 534.471, 534.545, 534.614, 534.678, 534.737, 534.792, 534.844, 534.891
};
const G4double G4BaryonPartialWidth::pwS1670_Lpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0540702, 0.550826, 1.45619, 2.71612, 4.28272, 6.07429, 8.10024, 10.2862, 12.5896, 14.9345, 17.3661, 19.8197, 22.273, 24.669, 27.0719, 29.4309, 31.7372, 33.9844, 36.1332, 38.2507, 40.2994, 42.2783, 44.157, 45.9975, 47.7696, 49.4744, 51.0878, 52.6644, 54.1792, 55.6344, 57.0099, 58.3531, 59.643, 60.8819, 62.0718, 63.1968, 64.2956, 65.3515, 66.3663, 67.3264, 68.265, 69.1677, 70.0362, 70.8586, 71.6635, 72.4385, 73.185, 73.8927, 74.5862, 75.2546, 75.8993, 76.5211, 77.1116, 77.6911, 78.2505, 78.7909, 79.3046, 79.8094, 80.2974, 80.7692, 81.2184, 81.3697, 87.5576, 91.2479, 93.6064, 95.2024, 96.3287, 97.1535, 97.7741, 98.2534, 98.6304, 98.9327, 99.1785, 99.381, 99.5501, 99.6924, 99.8135, 99.9172, 100.007, 100.085, 100.153, 100.213, 100.266, 100.314, 100.356, 100.393, 100.428, 100.458, 100.486, 100.511, 100.534, 100.556, 100.575, 100.593, 100.609, 100.624, 100.638, 100.651, 100.663, 100.674, 100.685
};

const G4double G4BaryonPartialWidth::pwS1750_NKbar[120] =
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10.9857, 20.5377, 26.231, 30.529, 33.9466, 36.769, 39.1208, 41.1795, 42.9728, 44.5506, 45.9288, 47.181, 48.3056, 49.321, 50.2417, 51.0671, 51.8341, 52.5373, 53.1837, 53.7705, 54.322, 54.8329, 55.3072, 55.7416, 56.1534, 56.5379, 56.8975, 57.2292, 57.5457, 57.843, 58.1228, 58.3864, 58.6311, 58.8662, 59.0885, 59.2988, 59.4951, 59.6843, 59.864, 60.0347, 60.1945, 60.3492, 60.4966, 60.6372, 60.7692, 60.8974, 61.0199, 61.137, 61.2491, 61.3548, 61.4577, 61.5564, 61.6511, 61.7405, 61.8279, 61.9118, 61.9926, 62.069, 62.0946, 63.1069, 63.6789, 64.0332, 64.2682, 64.4319, 64.5506, 64.6393, 64.7074, 64.7608, 64.8035, 64.8381, 64.8665, 64.8902, 64.9101, 64.9271, 64.9416, 64.9541, 64.965, 64.9745, 64.9828, 64.9902, 64.9968, 65.0027, 65.0079, 65.0127, 65.0169, 65.0208, 65.0243, 65.0275, 65.0304, 65.0331, 65.0356, 65.0379, 65.04, 65.0419, 65.0437, 65.0454, 65.0469, 65.0484
};
const G4double G4BaryonPartialWidth::pwS1750_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.508819, 1.76035, 2.47718, 3.04154, 3.50737, 3.91549, 4.27237, 4.58773, 4.86428, 5.11635, 5.34334, 5.54865, 5.73221, 5.90233, 6.05781, 6.20033, 6.33132, 6.45014, 6.56174, 6.66502, 6.76079, 6.8484, 6.93133, 7.00866, 7.08088, 7.14738, 7.21073, 7.27016, 7.32599, 7.37769, 7.42719, 7.47387, 7.51794, 7.55958, 7.59835, 7.63569, 7.67108, 7.70466, 7.73605, 7.76638, 7.79524, 7.82272, 7.84848, 7.87347, 7.89731, 7.92008, 7.94149, 7.96231, 7.98223, 8.00131, 8.01959, 8.03684, 8.05366, 8.0698, 8.08531, 8.09997, 8.1143, 8.12808, 8.14135, 8.15392, 8.15814, 8.32558, 8.42095, 8.48029, 8.51977, 8.54731, 8.56732, 8.58228, 8.59378, 8.6028, 8.61001, 8.61586, 8.62067, 8.62469, 8.62806, 8.63092, 8.63338, 8.6355, 8.63734, 8.63895, 8.64036, 8.64162, 8.64273, 8.64372, 8.64461, 8.64541, 8.64614, 8.64679, 8.64739, 8.64793, 8.64843, 8.64888, 8.6493, 8.64968, 8.65004, 8.65037, 8.65067, 8.65095, 8.65122, 8.65146
};
const G4double G4BaryonPartialWidth::pwS1750_Seta[120] =
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75.4271, 126.878, 160.756, 186.608, 207.628, 225.052, 240.3, 253.614, 265.374, 275.854, 285.119, 293.631, 301.359, 308.405, 314.757, 320.691, 326.16, 331.214, 335.823, 340.178, 344.23, 348.01, 351.487, 354.796, 357.9, 360.814, 363.555, 366.096, 368.532, 370.833, 373.008, 375.035, 376.987, 378.838, 380.596, 382.24, 383.83, 385.344, 386.787, 388.141, 389.455, 390.709, 391.909, 393.056, 394.136, 395.189, 396.197, 397.164, 398.078, 398.969, 399.825, 400.649, 401.428, 401.689, 411.986, 417.786, 421.373, 423.751, 425.405, 426.604, 427.5, 428.188, 428.727, 429.158, 429.507, 429.794, 430.033, 430.234, 430.405, 430.552, 430.678, 430.788, 430.884, 430.968, 431.043, 431.109, 431.168, 431.221, 431.269, 431.312, 431.351, 431.386, 431.419, 431.448, 431.475, 431.5, 431.523, 431.544, 431.564, 431.582, 431.599, 431.614, 431.629
};

const G4double G4BaryonPartialWidth::pwS1775_NKbar[120] =
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.00195, 6.88858, 15.0304, 24.7448, 35.4104, 46.6976, 58.1811, 70.0642, 82.0273, 93.9676, 105.616, 117.294, 128.763, 139.987, 150.941, 161.436, 171.805, 181.864, 191.61, 200.893, 210.018, 218.835, 227.348, 235.433, 243.363, 251.01, 258.383, 265.378, 272.233, 278.839, 285.206, 291.342, 297.163, 302.867, 308.365, 313.666, 318.697, 323.629, 328.387, 332.977, 337.336, 341.613, 345.742, 349.729, 353.518, 357.239, 360.835, 364.311, 367.67, 370.868, 374.012, 377.053, 379.996, 382.8, 385.559, 388.232, 390.821, 393.289, 394.121, 428.567, 449.501, 463.04, 472.276, 478.829, 483.648, 487.285, 490.099, 492.317, 494.099, 495.548, 496.744, 497.743, 498.584, 499.301, 499.915, 500.446, 500.908, 501.312, 501.668, 501.983, 502.263, 502.513, 502.737, 502.939, 503.121, 503.287, 503.437, 503.574, 503.699, 503.814, 503.919, 504.017, 504.106, 504.189, 504.266, 504.338, 504.404, 504.466
};
const G4double G4BaryonPartialWidth::pwS1775_Spi[120] =
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00560232, 0.194063, 0.577254, 1.13394, 1.83289, 2.67621, 3.63151, 4.67718, 5.7745, 6.94138, 8.14417, 9.36891, 10.5838, 11.8188, 13.0459, 14.2585, 15.4513, 16.6014, 17.7435, 18.856, 19.9374, 20.9699, 21.9866, 22.9702, 23.9206, 24.8236, 25.7093, 26.5633, 27.3862, 28.1664, 28.9303, 29.6658, 30.3739, 31.0555, 31.7013, 32.3333, 32.9417, 33.5275, 34.0826, 34.6261, 35.1496, 35.6539, 36.1322, 36.6008, 37.0525, 37.4881, 37.9015, 38.3069, 38.6982, 39.0758, 39.4404, 39.7869, 40.1272, 40.456, 40.7738, 41.0762, 41.3735, 41.661, 41.9393, 42.2043, 42.2936, 45.9598, 48.1586, 49.5684, 50.5243, 51.1998, 51.6949, 52.0677, 52.3558, 52.5825, 52.7643, 52.9122, 53.034, 53.1358, 53.2215, 53.2944, 53.3568, 53.4108, 53.4578, 53.4989, 53.535, 53.5671, 53.5955, 53.6209, 53.6437, 53.6641, 53.6827, 53.6994, 53.7147, 53.7286, 53.7413, 53.7529, 53.7637, 53.7735, 53.7826, 53.791, 53.7988, 53.8061, 53.8128, 53.8191
};
const G4double G4BaryonPartialWidth::pwS1775_Sstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.74153e-10, 3.02756e-05, 0.0228279, 0.959474, 3.3257, 6.88701, 11.4345, 16.6548, 22.5062, 28.7154, 35.1198, 41.4842, 47.9172, 54.2389, 60.3948, 66.3476, 71.9828, 77.4719, 82.7136, 87.7054, 92.3875, 96.8905, 101.197, 105.241, 109.036, 112.754, 116.125, 119.423, 122.661, 125.544, 128.115, 130.881, 133.793, 136.246, 138.116, 139.847, 142.009, 144.593, 147.171, 149.077, 150.137, 150.771, 151.63, 153.116, 155.305, 157.924, 160.563, 162.571, 163.54, 163.519, 162.975, 162.445, 162.334, 162.811, 163.891, 165.623, 167.994, 170.903, 174.018, 175.072, 178.246, 178.15, 172.418, 224.898, 245.31, 157.241, 155.888, 206.475, 202.219, 147.458, 116.561, 109.257, 117.615, 139.774, 178.424, 239.825, 332.607, 458.994, 592.381, 663.822, 625.744, 515.976, 399.677, 306.611, 238.926, 190.529, 155.627, 129.898, 110.536, 95.6212, 83.9232, 74.5683, 66.9828, 60.7404, 55.5361, 51.1582, 47.4335, 44.2432, 41.4851
};
const G4double G4BaryonPartialWidth::pwS1775_Lpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.109395, 1.12014, 2.97965, 5.59653, 8.89117, 12.7093, 17.0873, 21.8796, 27.004, 32.2969, 37.8657, 43.5666, 49.3482, 55.0728, 60.8914, 66.6792, 72.4103, 78.0636, 83.5331, 88.9848, 94.3176, 99.5236, 104.516, 109.455, 114.255, 118.915, 123.363, 127.745, 131.989, 136.098, 140.01, 143.856, 147.575, 151.17, 154.645, 157.949, 161.195, 164.332, 167.362, 170.243, 173.074, 175.809, 178.452, 180.966, 183.437, 185.826, 188.135, 190.333, 192.494, 194.584, 196.607, 198.564, 200.429, 202.264, 204.041, 205.762, 207.403, 209.019, 210.586, 212.104, 213.553, 214.042, 234.359, 246.785, 254.85, 260.364, 264.282, 267.165, 269.343, 271.03, 272.359, 273.427, 274.297, 275.014, 275.614, 276.119, 276.549, 276.917, 277.236, 277.513, 277.756, 277.97, 278.159, 278.327, 278.477, 278.612, 278.733, 278.843, 278.942, 279.032, 279.114, 279.19, 279.258, 279.322, 279.38, 279.434, 279.484, 279.53, 279.573, 279.613, 279.65
};
const G4double G4BaryonPartialWidth::pwS1775_Lstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.057579, 3.00643, 9.94199, 17.9938, 26.6054, 35.3662, 44.392, 53.4203, 62.3666, 71.0311, 79.6581, 88.0769, 96.2706, 104.229, 111.825, 119.307, 126.551, 133.561, 140.234, 146.797, 153.143, 159.282, 165.13, 170.881, 176.439, 181.819, 186.96, 192.039, 196.954, 201.688, 206.249, 210.6, 214.929, 219.193, 223.389, 227.418, 231.364, 235.117, 238.661, 241.964, 245.18, 248.32, 251.448, 254.563, 257.799, 261.112, 264.486, 267.884, 271.196, 274.465, 277.568, 280.443, 283.008, 285.325, 287.355, 289.125, 290.66, 291.15, 328.997, 367.152, 346.922, 357.012, 351.922, 352.366, 392.367, 475.914, 591.622, 710.329, 786.912, 790.076, 728.479, 635.933, 540.981, 457.544, 388.888, 334.013, 290.406, 255.743, 227.957, 205.535, 187.262, 172.228, 159.78, 149.379, 140.648, 133.264, 127.001, 121.657, 117.093, 113.178, 109.822, 106.941, 104.467, 102.349, 100.539, 99, 97.6982
};

const G4double G4BaryonPartialWidth::pwS1915_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0450596, 0.617306, 1.81983, 3.6712, 6.11843, 9.10932, 12.5224, 16.4021, 20.6251, 25.1203, 29.7419, 34.5779, 39.4952, 44.4416, 49.3715, 54.1684, 58.9581, 63.6355, 68.1804, 72.5081, 76.7496, 80.8258, 84.7325, 88.4094, 91.9779, 95.3785, 98.615, 101.644, 104.569, 107.345, 109.98, 112.478, 114.81, 117.058, 119.189, 121.209, 123.094, 124.912, 126.636, 128.272, 129.8, 131.274, 132.675, 134.005, 135.25, 136.453, 137.597, 138.686, 139.723, 140.695, 141.636, 142.534, 143.39, 144.194, 144.975, 145.721, 146.433, 147.104, 147.328, 155.719, 159.962, 162.349, 163.81, 164.76, 165.41, 165.871, 166.211, 166.467, 166.664, 166.82, 166.944, 167.045, 167.128, 167.197, 167.256, 167.305, 167.347, 167.383, 167.415, 167.442, 167.466, 167.488, 167.507, 167.524, 167.539, 167.552, 167.564, 167.575, 167.585, 167.594, 167.603, 167.61, 167.617, 167.624, 167.63, 167.635, 167.64, 167.645
};
const G4double G4BaryonPartialWidth::pwS1915_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00283933, 0.292298, 1.29355, 3.295, 6.46319, 11.0581, 17.121, 24.661, 33.4656, 43.7132, 55.1172, 67.4961, 80.4364, 94.1659, 108.286, 122.617, 136.999, 151.064, 165.156, 178.948, 192.364, 205.141, 217.656, 229.671, 241.167, 251.967, 262.425, 272.368, 281.807, 290.617, 299.105, 307.141, 314.746, 321.941, 328.64, 335.082, 341.176, 346.941, 352.311, 357.478, 362.37, 367.004, 371.325, 375.49, 379.44, 383.188, 386.69, 390.071, 393.285, 396.34, 399.247, 401.969, 404.606, 407.118, 409.513, 411.761, 413.942, 416.025, 418.016, 419.888, 420.513, 443.965, 455.91, 462.707, 466.916, 469.685, 471.601, 472.976, 473.996, 474.772, 475.376, 475.854, 476.239, 476.554, 476.815, 477.033, 477.217, 477.374, 477.509, 477.625, 477.727, 477.816, 477.894, 477.963, 478.025, 478.08, 478.13, 478.174, 478.214, 478.251, 478.284, 478.314, 478.342, 478.367, 478.391, 478.412, 478.432, 478.45, 478.467, 478.483
};
const G4double G4BaryonPartialWidth::pwS1915_Sstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.36631e-07, 0.000724683, 0.0581803, 0.683716, 1.54327, 2.49503, 3.5036, 4.52888, 5.58806, 6.6524, 7.71302, 8.7466, 9.78242, 10.8001, 11.7974, 12.7727, 13.71, 14.6395, 15.5454, 16.4274, 17.2743, 18.1086, 18.927, 19.7154, 20.4745, 21.2376, 21.9493, 22.6628, 23.3799, 24.0388, 24.645, 25.3067, 26.0148, 26.6331, 27.1318, 27.607, 28.1909, 28.883, 29.5878, 30.1422, 30.4981, 30.7518, 31.0654, 31.5394, 32.1977, 32.9735, 33.7681, 34.4086, 34.7828, 34.8974, 34.8697, 34.8459, 34.9335, 35.1798, 35.5895, 36.1837, 36.9612, 37.8986, 38.9031, 39.2465, 42.5028, 44.5671, 44.5139, 64.4139, 73.5729, 43.411, 43.9668, 63.3153, 62.7282, 43.4103, 32.9485, 30.8702, 34.3281, 42.9126, 57.9196, 81.9631, 118.518, 168.481, 221.342, 249.884, 235.332, 192.58, 147.283, 111.148, 85.003, 66.4367, 53.1599, 43.4672, 36.2513, 30.7565, 26.4989, 23.1365, 20.4446, 18.2575, 16.4574, 14.9621, 13.7057, 12.6428, 11.7348
};
const G4double G4BaryonPartialWidth::pwS1915_Lpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0138455, 0.317599, 1.20897, 2.89302, 5.53301, 9.17464, 14.0014, 19.9799, 27.0843, 35.1114, 44.2326, 54.2094, 64.9117, 76.0161, 87.7496, 99.8, 112.04, 124.355, 136.444, 148.614, 160.591, 172.312, 183.546, 194.622, 205.326, 215.636, 225.384, 234.884, 243.972, 252.651, 260.798, 268.689, 276.199, 283.342, 290.131, 296.479, 302.609, 308.431, 313.958, 319.123, 324.109, 328.844, 333.341, 337.545, 341.607, 345.468, 349.139, 352.575, 355.899, 359.063, 362.075, 364.945, 367.636, 370.246, 372.734, 375.109, 377.34, 379.507, 381.577, 383.556, 385.419, 386.041, 409.416, 421.283, 427.982, 432.093, 434.772, 436.61, 437.919, 438.883, 439.611, 440.174, 440.618, 440.973, 441.263, 441.501, 441.699, 441.866, 442.008, 442.129, 442.234, 442.324, 442.404, 442.473, 442.535, 442.59, 442.638, 442.682, 442.721, 442.756, 442.788, 442.817, 442.844, 442.868, 442.89, 442.91, 442.929, 442.946, 442.962, 442.976, 442.99
};

const G4double G4BaryonPartialWidth::pwS1940_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.253875, 1.76589, 3.89749, 6.49134, 9.39654, 12.533, 15.7872, 19.2208, 22.7449, 26.3296, 29.8918, 33.5281, 37.1634, 40.7835, 44.3765, 47.8757, 51.3877, 54.8483, 58.2519, 61.5409, 64.8196, 68.0311, 71.1732, 74.1957, 77.1968, 80.1259, 82.9828, 85.7235, 88.4383, 91.0822, 93.6563, 96.1616, 98.5603, 100.933, 103.24, 105.483, 107.629, 109.751, 111.813, 113.817, 115.734, 117.628, 119.469, 121.259, 122.97, 124.661, 126.305, 127.903, 129.456, 130.942, 132.412, 133.84, 135.229, 136.559, 137.873, 139.152, 140.397, 141.588, 141.991, 159.166, 170.107, 177.397, 182.47, 186.119, 188.83, 190.891, 192.496, 193.766, 194.79, 195.625, 196.316, 196.894, 197.382, 197.798, 198.155, 198.464, 198.733, 198.969, 199.177, 199.36, 199.524, 199.67, 199.801, 199.919, 200.026, 200.122, 200.21, 200.29, 200.364, 200.431, 200.493, 200.55, 200.602, 200.651, 200.696, 200.738, 200.777, 200.813
};
const G4double G4BaryonPartialWidth::pwS1940_NKstarbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0114446, 0.236624, 0.783955, 2.146, 8.12097, 24.1199, 34.9488, 42.7679, 48.8312, 53.9105, 58.207, 61.9112, 65.1494, 67.9674, 70.5223, 72.8156, 74.8863, 76.7367, 78.4527, 80.0233, 81.4659, 82.7746, 84.0049, 85.1456, 86.2047, 87.1719, 88.0953, 88.9567, 89.7559, 90.5236, 91.2065, 91.8912, 92.5139, 93.0917, 93.6962, 94.161, 94.6837, 95.2383, 95.5816, 95.9787, 96.5441, 96.9293, 97.0986, 97.4422, 98.0221, 98.4455, 98.508, 98.5456, 98.9114, 99.5547, 100.062, 100.111, 99.8855, 99.8165, 100.156, 100.848, 101.121, 103.084, 108.352, 101.222, 106.985, 98.6427, 127.552, 105.103, 95.0988, 100.184, 82.4959, 106.079, 170.68, 173.895, 111.451, 76.4431, 64.7443, 67.5159, 84.0212, 115.318, 144.49, 135.324, 102.329, 75.7226, 59.6389, 50.6311, 45.9248, 44.0023, 44.0825, 45.8097, 49.0871, 53.9923, 60.78, 69.86, 81.8768, 97.7737, 118.837, 146.909, 184.269, 233.562
};
const G4double G4BaryonPartialWidth::pwS1940_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0214672, 0.74625, 2.23557, 4.42783, 7.22136, 10.6467, 14.5945, 18.994, 23.6961, 28.79, 34.1402, 39.6912, 45.2999, 51.1065, 56.9808, 62.889, 68.8014, 74.5982, 80.4481, 86.238, 91.9525, 97.4894, 103.02, 108.445, 113.757, 118.87, 123.947, 128.901, 133.73, 138.359, 142.941, 147.398, 151.731, 155.943, 159.97, 163.946, 167.807, 171.555, 175.135, 178.666, 182.093, 185.418, 188.593, 191.724, 194.762, 197.709, 200.523, 203.299, 205.993, 208.606, 211.143, 213.565, 215.956, 218.277, 220.531, 222.684, 224.81, 226.875, 228.881, 230.799, 231.447, 258.768, 275.851, 287.092, 294.845, 300.389, 304.488, 307.593, 310.004, 311.909, 313.441, 314.69, 315.721, 316.584, 317.311, 317.931, 318.462, 318.922, 319.322, 319.673, 319.981, 320.254, 320.497, 320.714, 320.909, 321.084, 321.242, 321.386, 321.516, 321.635, 321.744, 321.844, 321.935, 322.02, 322.098, 322.17, 322.237, 322.299, 322.356, 322.41
};
const G4double G4BaryonPartialWidth::pwS1940_Sstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0067822, 0.367423, 3.23944, 11.144, 16.6716, 21.0744, 24.8138, 28.0289, 30.9275, 33.5211, 35.858, 37.9424, 39.8715, 41.6333, 43.2476, 44.7311, 46.0768, 47.3411, 48.5114, 49.5964, 50.592, 51.5288, 52.413, 53.226, 53.9814, 54.7198, 55.3651, 56.0027, 56.6423, 57.1806, 57.6365, 58.1678, 58.7588, 59.2248, 59.5164, 59.7768, 60.1847, 60.7412, 61.3036, 61.6649, 61.7685, 61.7498, 61.8073, 62.0728, 62.5712, 63.219, 63.8798, 64.3466, 64.4869, 64.315, 63.9819, 63.6557, 63.4699, 63.4791, 63.6908, 64.1176, 64.7583, 65.5813, 66.4802, 66.7853, 66.1858, 65.1439, 62.5413, 80.0868, 86.8678, 56.2884, 55.6273, 72.9665, 71.3844, 52.3226, 41.5746, 38.9738, 41.7803, 49.3952, 62.7947, 84.1866, 116.594, 160.791, 207.45, 232.426, 219.077, 180.655, 139.961, 107.404, 83.7335, 66.8134, 54.6164, 45.6291, 38.8692, 33.6643, 29.5841, 26.3226, 23.6789, 21.5039, 19.6909, 18.1659, 16.8683, 15.7567, 14.7954
};
const G4double G4BaryonPartialWidth::pwS1940_Lpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0789079, 0.811602, 2.17082, 4.10295, 6.56325, 9.44961, 12.8028, 16.5241, 20.5603, 24.7898, 29.3051, 33.9962, 38.8248, 43.6761, 48.6789, 53.7274, 58.7978, 63.8695, 68.8433, 73.8669, 78.8456, 83.768, 88.547, 93.3315, 98.0361, 102.656, 107.114, 111.553, 115.897, 120.145, 124.229, 128.283, 132.238, 136.096, 139.856, 143.462, 147.032, 150.509, 153.893, 157.135, 160.341, 163.461, 166.496, 169.401, 172.274, 175.068, 177.784, 180.385, 182.955, 185.455, 187.886, 190.25, 192.513, 194.751, 196.927, 199.044, 201.071, 203.076, 205.027, 206.925, 208.744, 209.358, 235.604, 252.343, 263.5, 271.263, 276.849, 280.997, 284.151, 286.606, 288.549, 290.115, 291.393, 292.45, 293.335, 294.081, 294.717, 295.263, 295.736, 296.147, 296.508, 296.825, 297.106, 297.356, 297.58, 297.78, 297.961, 298.124, 298.272, 298.406, 298.529, 298.641, 298.744, 298.838, 298.925, 299.006, 299.08, 299.149, 299.213, 299.272, 299.328
};
const G4double G4BaryonPartialWidth::pwS1940_Lstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0342001, 1.814, 6.08939, 11.1507, 16.6531, 22.3319, 28.2595, 34.2613, 40.2764, 46.164, 52.0848, 57.9184, 63.6478, 69.2613, 74.6638, 80.0275, 85.2607, 90.3622, 95.2537, 100.097, 104.813, 109.404, 113.805, 118.16, 122.394, 126.516, 130.477, 134.411, 138.239, 141.947, 145.538, 148.982, 152.423, 155.827, 159.189, 162.433, 165.625, 168.678, 171.58, 174.3, 176.963, 179.572, 182.178, 184.776, 187.477, 190.243, 193.063, 195.907, 198.686, 201.44, 204.068, 206.522, 208.731, 210.751, 212.546, 214.137, 215.538, 215.991, 249.7, 284.054, 269.996, 280.691, 278.423, 280.553, 316.12, 389.263, 490.803, 595.539, 663.837, 668.014, 615.483, 535.814, 454, 382.216, 323.303, 276.367, 239.202, 209.769, 186.266, 167.373, 152.033, 139.459, 129.087, 120.452, 113.231, 107.146, 102.004, 97.6354, 93.9191, 90.7463, 88.0397, 85.7289, 83.7568, 82.0811, 80.6606, 79.4656, 78.4671
};
const G4double G4BaryonPartialWidth::pwS1940_DKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0539394, 1.33354, 5.36327, 13.8927, 22.1428, 28.7292, 34.0268, 38.4366, 42.1427, 45.4172, 48.2979, 50.8582, 53.1522, 55.1898, 57.0698, 58.7832, 60.3514, 61.7698, 63.0993, 64.3282, 65.4672, 66.509, 67.4956, 68.4162, 69.2769, 70.0705, 70.8277, 71.5392, 72.2088, 72.8398, 73.426, 73.9892, 74.522, 75.0266, 75.4975, 75.952, 76.3838, 76.7945, 77.1793, 77.552, 77.9073, 78.2464, 78.5652, 78.875, 79.1714, 79.4552, 79.7269, 79.9831, 80.2328, 80.4724, 80.7025, 80.9202, 81.1333, 81.3385, 81.5361, 81.7234, 81.7863, 84.2969, 85.7276, 86.6533, 86.5702, 87.9207, 90.0418, 89.9823, 87.5827, 85.3309, 84.3139, 83.8776, 83.2315, 82.3971, 81.9968, 82.6633, 84.7548, 88.3686, 93.4057, 99.6456, 106.723, 114.172, 121.39, 127.74, 132.616, 135.544, 136.298, 134.909, 131.64, 126.903, 121.151, 114.823, 108.265, 101.759, 95.4809, 89.541, 84.0098, 78.901, 74.222, 69.9477
};

const G4double G4BaryonPartialWidth::pwS2030_NKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0573911, 0.788771, 2.33668, 4.7439, 7.96601, 11.9619, 16.5965, 21.959, 27.9083, 34.3689, 41.1486, 48.3927, 55.917, 63.6487, 71.5191, 79.3369, 87.3022, 95.2367, 103.096, 110.718, 118.322, 125.755, 132.996, 139.917, 146.733, 153.319, 159.671, 165.689, 171.57, 177.215, 182.627, 187.811, 192.693, 197.441, 201.978, 206.313, 210.388, 214.343, 218.118, 221.72, 225.104, 228.387, 231.52, 234.51, 237.318, 240.044, 242.647, 245.132, 247.506, 249.738, 251.907, 253.98, 255.963, 257.829, 259.644, 261.381, 263.045, 264.612, 265.137, 284.953, 295.043, 300.703, 304.144, 306.363, 307.869, 308.93, 309.705, 310.284, 310.729, 311.076, 311.352, 311.576, 311.758, 311.909, 312.036, 312.142, 312.233, 312.311, 312.379, 312.438, 312.489, 312.534, 312.574, 312.609, 312.641, 312.669, 312.695, 312.718, 312.739, 312.757, 312.775, 312.79, 312.805, 312.818, 312.83, 312.841, 312.851, 312.861
};
const G4double G4BaryonPartialWidth::pwS2030_NKstarbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.80836e-14, 3.70854e-09, 4.99301e-07, 3.12045e-05, 0.00707853, 0.593896, 2.72195, 6.20157, 10.5403, 15.4901, 20.6697, 25.8512, 30.8838, 35.6012, 40.11, 44.3105, 48.2012, 51.7363, 55.0477, 58.0943, 60.8967, 63.4355, 65.8137, 68.0068, 70.0304, 71.8675, 73.6038, 75.2111, 76.6944, 78.0944, 79.3465, 80.5696, 81.6861, 82.7194, 83.7467, 84.5972, 85.4865, 86.3871, 87.0312, 87.7195, 88.571, 89.2111, 89.6021, 90.1692, 90.973, 91.5978, 91.8313, 92.0274, 92.5606, 93.373, 94.033, 94.2087, 94.0955, 94.1392, 94.5977, 95.4107, 95.7232, 98.9117, 104.686, 97.9478, 103.783, 95.7191, 124.027, 102.159, 92.4285, 97.4189, 80.1822, 103.198, 166.122, 169.255, 108.455, 74.3528, 62.9539, 65.6657, 81.7557, 112.237, 140.639, 131.716, 99.5944, 73.6879, 58.0228, 49.2471, 44.6623, 42.7913, 42.8732, 44.5601, 47.7567, 52.5374, 59.1497, 67.9924, 79.6926, 95.169, 115.673, 143, 179.367, 227.349
};
const G4double G4BaryonPartialWidth::pwS2030_Spi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.000671464, 0.0690884, 0.306354, 0.782911, 1.54255, 2.65458, 4.13911, 6.01118, 8.23209, 10.863, 13.8479, 17.1555, 20.6878, 24.5191, 28.5495, 32.7342, 37.0298, 41.3244, 45.7214, 50.1166, 54.4802, 58.7175, 62.9458, 67.0776, 71.0985, 74.9358, 78.7075, 82.3442, 85.8427, 89.1484, 92.3699, 95.4532, 98.4006, 101.215, 103.859, 106.421, 108.864, 111.191, 113.372, 115.483, 117.494, 119.407, 121.201, 122.937, 124.59, 126.164, 127.641, 129.071, 130.434, 131.733, 132.972, 134.136, 135.265, 136.343, 137.372, 138.34, 139.28, 140.18, 141.04, 141.85, 142.121, 152.317, 157.505, 160.434, 162.229, 163.399, 164.2, 164.77, 165.189, 165.506, 165.751, 165.943, 166.098, 166.223, 166.326, 166.412, 166.485, 166.546, 166.598, 166.644, 166.683, 166.717, 166.747, 166.774, 166.798, 166.819, 166.838, 166.854, 166.87, 166.884, 166.896, 166.907, 166.918, 166.927, 166.936, 166.944, 166.952, 166.958, 166.965, 166.971
};
const G4double G4BaryonPartialWidth::pwS2030_Sstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.53459e-15, 8.4183e-08, 0.000593985, 0.0898052, 0.500459, 1.40979, 2.96129, 5.21245, 8.28777, 12.1578, 16.778, 21.9771, 27.8201, 34.1063, 40.7111, 47.5143, 54.2955, 61.1834, 67.9867, 74.6396, 81.0048, 87.2204, 93.2216, 98.8996, 104.242, 109.468, 114.227, 118.847, 123.332, 127.339, 130.916, 134.676, 138.554, 141.824, 144.366, 146.705, 149.509, 152.754, 155.949, 158.332, 159.719, 160.602, 161.723, 163.529, 166.095, 169.105, 172.108, 174.383, 175.499, 175.521, 174.967, 174.425, 174.337, 174.88, 176.067, 177.946, 180.497, 183.608, 186.918, 188.033, 190.687, 189.735, 183.073, 236.614, 257.152, 165.914, 164.207, 216.157, 211.523, 154.781, 122.743, 115.064, 123.556, 146.331, 186.229, 249.796, 346.022, 477.214, 615.697, 689.815, 650.183, 536.144, 415.366, 318.74, 248.483, 198.258, 162.048, 135.362, 115.284, 99.8214, 87.6953, 77.9987, 70.1356, 63.664, 58.2674, 53.7261, 49.8607, 46.5483, 43.6829
};
const G4double G4BaryonPartialWidth::pwS2030_Lpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00689107, 0.158204, 0.603219, 1.44715, 2.77732, 4.62515, 7.09586, 10.1884, 13.9078, 18.167, 23.0783, 28.5365, 34.4912, 40.7781, 47.5417, 54.6173, 61.9397, 69.445, 76.9487, 84.641, 92.3476, 100.022, 107.501, 114.996, 122.352, 129.545, 136.444, 143.258, 149.861, 156.246, 162.309, 168.246, 173.955, 179.438, 184.698, 189.659, 194.488, 199.11, 203.529, 207.686, 211.725, 215.583, 219.267, 222.73, 226.091, 229.301, 232.365, 235.245, 238.041, 240.711, 243.262, 245.7, 247.992, 250.22, 252.351, 254.388, 256.306, 258.173, 259.96, 261.671, 263.284, 263.823, 284.24, 294.663, 300.526, 304.1, 306.412, 307.985, 309.096, 309.909, 310.519, 310.988, 311.355, 311.647, 311.884, 312.078, 312.239, 312.374, 312.488, 312.585, 312.668, 312.74, 312.803, 312.859, 312.907, 312.95, 312.988, 313.022, 313.053, 313.08, 313.105, 313.128, 313.148, 313.167, 313.184, 313.199, 313.214, 313.227, 313.239, 313.25, 313.261
};
const G4double G4BaryonPartialWidth::pwS2030_Lstarpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.000581063, 0.239352, 1.55507, 4.01226, 7.5597, 12.0385, 17.4925, 23.736, 30.6432, 37.9665, 45.8303, 54.0112, 62.4133, 70.9523, 79.4169, 88.0237, 96.5829, 105.052, 113.262, 121.457, 129.477, 137.308, 144.819, 152.243, 159.442, 166.421, 173.09, 179.669, 186.023, 192.129, 197.991, 203.558, 209.062, 214.442, 219.694, 224.698, 229.567, 234.17, 238.494, 242.497, 246.368, 250.112, 253.798, 257.426, 261.145, 264.905, 268.688, 272.453, 276.084, 279.633, 282.969, 286.034, 288.743, 291.169, 293.275, 295.092, 296.649, 297.142, 332.131, 363.055, 340.32, 344.944, 336.619, 333.435, 363.507, 428.434, 517.84, 608.543, 665.651, 665.222, 614.285, 539.298, 462.538, 394.893, 338.934, 293.905, 257.851, 228.962, 205.614, 186.619, 171.012, 158.069, 147.269, 138.176, 130.485, 123.931, 118.329, 113.513, 109.366, 105.779, 102.675, 99.9837, 97.6464, 95.6205, 93.863, 92.3437, 91.0318
};
const G4double G4BaryonPartialWidth::pwS2030_DKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6.47407e-11, 2.71567e-05, 0.0079478, 0.395251, 2.76574, 8.36114, 17.2787, 29.1483, 43.139, 59.0633, 76.0771, 93.6259, 111.256, 128.344, 145.199, 161.368, 176.745, 191.045, 204.72, 217.534, 229.513, 240.518, 250.953, 260.677, 269.737, 278.05, 285.931, 293.284, 300.149, 306.563, 312.468, 318.09, 323.358, 328.3, 332.868, 337.235, 341.344, 345.214, 348.806, 352.254, 355.512, 358.593, 361.463, 364.229, 366.852, 369.342, 371.707, 373.92, 376.061, 378.099, 380.042, 381.866, 383.639, 385.333, 386.953, 388.478, 388.988, 408.37, 418.561, 424.739, 425.211, 432.469, 443.329, 443.259, 431.548, 420.536, 415.604, 413.522, 410.387, 406.312, 404.373, 407.697, 418.05, 435.911, 460.791, 491.601, 526.54, 563.303, 598.924, 630.259, 654.319, 668.765, 672.481, 665.626, 649.491, 626.119, 597.734, 566.509, 534.154, 502.05, 471.076, 441.768, 414.477, 389.27, 366.184, 345.095
};

const G4double G4BaryonPartialWidth::pwX1530_Xpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.482836, 7.52121, 14.8124, 22.3271, 29.7874, 37.0871, 44.0487, 50.8633, 57.3958, 63.6394, 69.5016, 75.181, 80.5888, 85.7368, 90.6372, 95.2297, 99.6774, 103.916, 107.957, 111.752, 115.436, 118.955, 122.32, 125.489, 128.574, 131.529, 134.363, 137.039, 139.652, 142.162, 144.576, 146.898, 149.098, 151.254, 153.331, 155.335, 157.239, 159.108, 160.913, 162.659, 164.321, 165.956, 167.539, 169.072, 170.535, 171.977, 173.376, 174.733, 176.052, 177.312, 178.556, 179.766, 180.943, 182.07, 183.184, 184.27, 185.327, 186.34, 186.683, 201.621, 211.807, 219.194, 224.811, 229.221, 232.783, 235.718, 238.181, 240.276, 242.082, 243.653, 245.034, 246.257, 247.347, 248.327, 249.21, 250.011, 250.741, 251.41, 252.023, 252.589, 253.112, 253.597, 254.048, 254.469, 254.862, 255.23, 255.576, 255.901, 256.207, 256.496, 256.769, 257.028, 257.273, 257.506, 257.728, 257.938, 258.139, 258.331
};
const G4double G4BaryonPartialWidth::pwX1530_Xgamma[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00237721, 0.0342598, 0.0920876, 0.165801, 0.247443, 0.335401, 0.425498, 0.515808, 0.603633, 0.691033, 0.776029, 0.858306, 0.936435, 1.01291, 1.08641, 1.157, 1.22474, 1.2887, 1.35108, 1.41092, 1.46834, 1.52258, 1.57554, 1.62641, 1.6753, 1.72156, 1.76682, 1.81038, 1.85233, 1.89212, 1.93113, 1.96875, 2.00508, 2.04016, 2.07352, 2.10631, 2.13803, 2.16873, 2.19798, 2.22679, 2.25472, 2.2818, 2.30765, 2.33316, 2.35793, 2.382, 2.40501, 2.42776, 2.44988, 2.4714, 2.49235, 2.51243, 2.53231, 2.55168, 2.57056, 2.58867, 2.60663, 2.62416, 2.64127, 2.6577, 2.66327, 2.90976, 3.08261, 3.21068, 3.30971, 3.38856, 3.45298, 3.50656, 3.55191, 3.59074, 3.62443, 3.65389, 3.67991, 3.70307, 3.72378, 3.74245, 3.75934, 3.77472, 3.78875, 3.80164, 3.81349, 3.82445, 3.83459, 3.84401, 3.8528, 3.86099, 3.86867, 3.87587, 3.88264, 3.88901, 3.89502, 3.90069, 3.90607, 3.91116, 3.91599, 3.92058, 3.92495, 3.92912, 3.93309, 3.93688
};

const G4double G4BaryonPartialWidth::pwX1690_Xpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0763157, 1.19538, 2.43041, 3.7617, 19.4347, 57.2792, 87.2369, 113.457, 136.633, 157.443, 176.033, 193.319, 209.213, 223.898, 237.52, 250.001, 261.851, 272.943, 283.351, 292.984, 302.214, 310.926, 319.165, 326.845, 334.252, 341.287, 347.979, 354.251, 360.331, 366.135, 371.681, 376.986, 381.985, 386.856, 391.528, 396.014, 400.256, 404.403, 408.393, 412.237, 415.882, 419.456, 422.905, 426.235, 429.401, 432.514, 435.524, 438.438, 441.26, 443.95, 446.601, 449.173, 451.667, 454.051, 456.404, 458.69, 460.912, 463.038, 463.757, 494.633, 515.236, 529.965, 541.052, 549.694, 556.636, 562.329, 567.092, 571.131, 574.605, 577.621, 580.266, 582.608, 584.692, 586.562, 588.246, 589.775, 591.165, 592.437, 593.605, 594.681, 595.674, 596.596, 597.453, 598.251, 598.998, 599.696, 600.352, 600.969, 601.549, 602.097, 602.615, 603.105, 603.57, 604.012, 604.431, 604.83, 605.211, 605.574
};
const G4double G4BaryonPartialWidth::pwX1690_LKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13.3728, 37.1794, 58.5179, 77.7659, 95.8875, 112.771, 128.574, 143.186, 157.185, 170.405, 182.919, 194.787, 205.885, 216.624, 226.858, 236.626, 245.813, 254.751, 263.312, 271.523, 279.28, 286.859, 294.148, 301.166, 307.82, 314.344, 320.639, 326.72, 332.596, 338.188, 343.691, 349.019, 354.182, 359.107, 363.965, 368.68, 373.258, 377.636, 381.962, 386.168, 390.261, 394.182, 398.063, 401.844, 405.528, 409.121, 412.568, 415.988, 419.325, 422.583, 425.715, 428.825, 431.864, 434.835, 437.694, 438.664, 482.161, 513.422, 537.051, 555.621, 570.604, 582.983, 593.374, 602.239, 609.884, 616.556, 622.422, 627.625, 632.276, 636.451, 640.228, 643.655, 646.783, 649.646, 652.281, 654.709, 656.958, 659.044, 660.985, 662.798, 664.492, 666.081, 667.572, 668.976, 670.299, 671.549, 672.73, 673.85, 674.911, 675.92, 676.879, 677.792, 678.664, 679.495, 680.29
};
const G4double G4BaryonPartialWidth::pwX1690_SKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

const G4double G4BaryonPartialWidth::pwX1820_Xpi[120] =
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00396219, 0.187158, 0.570095, 1.14009, 2.09188, 4.50415, 7.51268, 10.8768, 14.3806, 17.9217, 21.3786, 24.8224, 28.1683, 31.399, 34.5045, 37.4325, 40.2775, 42.9914, 45.5768, 47.9986, 50.3408, 52.5676, 54.6842, 56.6645, 58.5784, 60.3979, 62.1281, 63.748, 65.3153, 66.8073, 68.2281, 69.5819, 70.8519, 72.0835, 73.2586, 74.3804, 75.4349, 76.4596, 77.4393, 78.3764, 79.2592, 80.1187, 80.9422, 81.7315, 82.4765, 83.2033, 83.9009, 84.5709, 85.2147, 85.8238, 86.4193, 86.9923, 87.5439, 88.0666, 88.5786, 89.0721, 89.5479, 89.9995, 90.1514, 96.2464, 99.7774, 101.995, 103.479, 104.518, 105.275, 105.843, 106.279, 106.622, 106.896, 107.119, 107.302, 107.455, 107.583, 107.693, 107.786, 107.867, 107.937, 107.999, 108.053, 108.101, 108.143, 108.181, 108.215, 108.246, 108.273, 108.298, 108.321, 108.342, 108.361, 108.378, 108.394, 108.409, 108.422, 108.435, 108.447, 108.457, 108.467, 108.477
};
const G4double G4BaryonPartialWidth::pwX1820_LKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.07295, 5.39104, 11.0988, 17.446, 24.3007, 31.344, 38.4281, 45.3387, 52.2329, 58.9484, 65.4535, 71.7281, 77.6656, 83.4557, 88.9989, 94.2982, 99.2792, 104.112, 108.722, 113.117, 117.241, 121.237, 125.047, 128.679, 132.089, 135.395, 138.549, 141.559, 144.433, 147.135, 149.76, 152.269, 154.669, 156.928, 159.127, 161.233, 163.25, 165.153, 167.008, 168.787, 170.495, 172.109, 173.686, 175.201, 176.657, 178.058, 179.385, 180.683, 181.934, 183.139, 184.282, 185.402, 186.482, 187.525, 188.516, 188.849, 202.291, 210.141, 215.096, 218.421, 220.755, 222.457, 223.735, 224.719, 225.492, 226.111, 226.613, 227.027, 227.372, 227.663, 227.91, 228.121, 228.304, 228.463, 228.602, 228.724, 228.832, 228.928, 229.014, 229.091, 229.16, 229.222, 229.279, 229.331, 229.377, 229.42, 229.46, 229.496, 229.529, 229.56, 229.588, 229.614, 229.639, 229.662, 229.683
};
const G4double G4BaryonPartialWidth::pwX1820_SKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

const G4double G4BaryonPartialWidth::pwX1950_Xpi[120] =
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.100617, 1.59133, 3.2792, 5.13422, 8.35781, 14.1717, 19.6589, 25.0433, 30.2478, 35.2806, 40.0706, 44.7806, 49.3366, 53.7445, 58.0102, 62.0741, 66.0752, 69.9514, 73.7084, 77.2934, 80.8293, 84.2611, 87.5935, 90.7795, 93.9277, 96.9892, 99.9677, 102.821, 105.645, 108.396, 111.078, 113.693, 116.203, 118.693, 121.124, 123.498, 125.781, 128.048, 130.265, 132.434, 134.521, 136.598, 138.631, 140.622, 142.541, 144.452, 146.326, 148.162, 149.963, 151.702, 153.435, 155.137, 156.807, 158.421, 160.031, 161.614, 163.168, 164.671, 165.183, 189.031, 207.372, 221.991, 233.985, 244.011, 252.546, 259.896, 266.307, 271.943, 276.946, 281.412, 285.426, 289.059, 292.356, 295.368, 298.126, 300.665, 303.006, 305.176, 307.19, 309.066, 310.815, 312.453, 313.989, 315.431, 316.79, 318.07, 319.281, 320.425, 321.51, 322.539, 323.517, 324.447, 325.333, 326.179, 326.985, 327.757, 328.495, 329.201
};
const G4double G4BaryonPartialWidth::pwX1950_LKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.21075, 9.26561, 14.9408, 20.2303, 25.3476, 30.2313, 34.9025, 39.3079, 43.6066, 47.7378, 51.7129, 55.5424, 59.177, 62.7442, 66.1912, 69.5251, 72.7009, 75.8289, 78.8617, 81.8042, 84.6158, 87.393, 90.093, 92.7197, 95.2358, 97.7271, 100.155, 102.522, 104.831, 107.048, 109.249, 111.399, 113.5, 115.521, 117.531, 119.497, 121.421, 123.275, 125.121, 126.93, 128.702, 130.412, 132.116, 133.788, 135.428, 137.038, 138.593, 140.145, 141.67, 143.168, 144.616, 146.063, 147.485, 148.884, 150.237, 150.698, 172.323, 189.153, 202.697, 213.894, 223.314, 231.376, 238.348, 244.454, 249.838, 254.632, 258.921, 262.786, 266.291, 269.477, 272.393, 275.066, 277.531, 279.807, 281.918, 283.879, 285.709, 287.416, 289.015, 290.517, 291.928, 293.258, 294.512, 295.698, 296.82, 297.885, 298.895, 299.856, 300.77, 301.64, 302.472, 303.266, 304.025, 304.751, 305.447
};
const G4double G4BaryonPartialWidth::pwX1950_SKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

const G4double G4BaryonPartialWidth::pwX2030_Xpi[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.05812e-05, 0.0112536, 0.0516028, 0.135582, 0.323693, 1.34213, 3.3862, 6.46245, 10.438, 15.1749, 20.4303, 26.2244, 32.3292, 38.6134, 44.9635, 51.1845, 57.4064, 63.4692, 69.3306, 74.8724, 80.2579, 85.3843, 90.2481, 94.7785, 99.1295, 103.233, 107.098, 110.679, 114.105, 117.327, 120.357, 123.207, 125.846, 128.371, 130.749, 132.987, 135.064, 137.055, 138.934, 140.707, 142.356, 143.94, 145.44, 146.859, 148.182, 149.457, 150.666, 151.815, 152.905, 153.925, 154.912, 155.851, 156.746, 157.585, 158.398, 159.174, 159.915, 160.612, 160.845, 169.559, 174.016, 176.574, 178.173, 179.235, 179.975, 180.511, 180.912, 181.218, 181.458, 181.649, 181.804, 181.931, 182.036, 182.125, 182.2, 182.264, 182.319, 182.367, 182.409, 182.446, 182.479, 182.507, 182.533, 182.556, 182.577, 182.595, 182.612, 182.628, 182.641, 182.654, 182.666, 182.677, 182.686, 182.695, 182.704, 182.712, 182.719, 182.726
};
const G4double G4BaryonPartialWidth::pwX2030_LKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0234717, 0.216667, 0.604176, 1.16704, 1.90897, 2.80245, 3.82469, 4.93263, 6.13871, 7.40245, 8.7026, 10.0203, 11.3181, 12.6251, 13.909, 15.161, 16.3554, 17.5266, 18.6514, 19.7278, 20.7389, 21.7177, 22.6478, 23.5302, 24.3532, 25.1456, 25.8951, 26.604, 27.274, 27.8973, 28.4964, 29.0625, 29.5977, 30.0958, 30.5748, 31.028, 31.4569, 31.8567, 32.2418, 32.6067, 32.9528, 33.2759, 33.5879, 33.8841, 34.1656, 34.4333, 34.6839, 34.9265, 35.1576, 35.3777, 35.5843, 35.7847, 35.976, 36.1587, 36.3305, 36.3879, 38.5345, 39.6239, 40.2424, 40.6249, 40.8762, 41.05, 41.1746, 41.2671, 41.3373, 41.392, 41.4353, 41.4702, 41.4987, 41.5223, 41.542, 41.5587, 41.5729, 41.5851, 41.5956, 41.6048, 41.6129, 41.6199, 41.6262, 41.6318, 41.6368, 41.6413, 41.6453, 41.6489, 41.6522, 41.6552, 41.6579, 41.6604, 41.6627, 41.6648, 41.6668, 41.6686, 41.6702, 41.6718, 41.6732
};
const G4double G4BaryonPartialWidth::pwX2030_SKbar[120] = 
{
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};


G4BaryonPartialWidth::G4BaryonPartialWidth() : wSize(120)
{ 
  wMap["N1440_Npi"] = (G4double*) pwN1440_Npi;
  wMap["N1440_Npipi"] = (G4double*) pwN1440_Npipi;
  wMap["N1440_Dpi"] = (G4double*) pwN1440_Dpi;
  
  wMap["N1520_Ngamma"] = (G4double*) pwN1520_Ngamma;
  wMap["N1520_Npi"] = (G4double*) pwN1520_Npi;
  wMap["N1520_Npipi"] = (G4double*) pwN1520_Npipi;
  wMap["N1520_Dp"] = (G4double*) pwN1520_Dpi;

  wMap["N1535_Ngamma"] = (G4double*) pwN1535_Ngamma;
  wMap["N1535_Npi"] = (G4double*) pwN1535_Npi;
  wMap["N1535_Neta"] = (G4double*) pwN1535_Neta;
  wMap["N1535_Npipi"] = (G4double*) pwN1535_Npipi;
  wMap["N1535_Nstarpi"] = (G4double*) pwN1535_Nstarpi;

  wMap["N1650_Ngamma"] = (G4double*) pwN1650_Ngamma;
  wMap["N1650_Npi"] = (G4double*) pwN1650_Npi;
  wMap["N1650_Neta"] = (G4double*) pwN1650_Neta;
  wMap["N1650_Npipi"] = (G4double*) pwN1650_Npipi;
  wMap["N1650_Dpi"] = (G4double*) pwN1650_Dpi;
  wMap["N1650_Nstarpi"] = (G4double*) pwN1650_Nstarpi;
  wMap["N1650_LK"] = (G4double*) pwN1650_LK;

  wMap["N1675_Npi"] = (G4double*) pwN1675_Npi;
  wMap["N1675_Dpi"] = (G4double*) pwN1675_Dpi;

  wMap["N1680_Ngamma"] = (G4double*) pwN1680_Ngamma;
  wMap["N1680_Npi"] = (G4double*) pwN1680_Npi;
  wMap["N1680_Npipi"] = (G4double*) pwN1680_Npipi;
  wMap["N1680_Dpi"] = (G4double*) pwN1680_Dpi;

  wMap["D1700_Npi"] = (G4double*) pwN1700_Npi;
  wMap["D1700_Neta"] = (G4double*) pwN1700_Neta;
  wMap["D1700_Nrho"] = (G4double*) pwN1700_Nrho;
  wMap["D1700_Npipi"] = (G4double*) pwN1700_Npipi;
  wMap["D1700_Dpi"] = (G4double*) pwN1700_Dpi;

  wMap["N1710_Npi"] = (G4double*) pwN1710_Npi;
  wMap["N1710_Neta"] = (G4double*) pwN1710_Neta;
  wMap["N1710_Nrho"] = (G4double*) pwN1710_Nrho;
  wMap["N1710_Npipi"] = (G4double*) pwN1710_Npipi;
  wMap["N1710_Dpi"] = (G4double*) pwN1710_Dpi;
  wMap["N1710_Nstarpi"] = (G4double*) pwN1710_Nstarpi;
  wMap["N1710_LK"] = (G4double*) pwN1710_LK;

  wMap["N1720_Ngamma"] = (G4double*) pwN1720_Ngamma;
  wMap["N1720_Npi"] = (G4double*) pwN1720_Npi;
  wMap["N1720_Nrho"] = (G4double*) pwN1720_Nrho;
  wMap["N1720_Npipi"] = (G4double*) pwN1720_Npipi;
  wMap["N1720_Dpi"] = (G4double*) pwN1720_Dpi;
  wMap["N1720_LK"] = (G4double*) pwN1720_LK;

  wMap["N1900_Npi"] = (G4double*) pwN1900_Npi;
  wMap["N1900_Nomega"] = (G4double*) pwN1900_Nomega;
  wMap["N1900_Nrho"] = (G4double*) pwN1900_Nrho;
  wMap["N1900_Dpi"] = (G4double*) pwN1900_Dpi;

  wMap["N1990_Npi"] = (G4double*) pwN1990_Npi;
  wMap["N1990_Nrho"] = (G4double*) pwN1990_Nrho;
  wMap["N1990_Npipi"] = (G4double*) pwN1990_Npipi;
  wMap["N1990_Dpi"] = (G4double*) pwN1990_Dpi;
  wMap["N1990_Nstarpi"] = (G4double*) pwN1990_Nstarpi;
  wMap["N1990_LK"] = (G4double*) pwN1990_LK;

  wMap["N2090_Npi"] = (G4double*) pwN2090_Npi;
  wMap["N2090_Neta"] = (G4double*) pwN2090_Neta;
  wMap["N2090_Nrho"] = (G4double*) pwN2090_Nrho;
  wMap["N2090_Npipi"] = (G4double*) pwN2090_Npipi;
  wMap["N2090_Dpi"] = (G4double*) pwN2090_Dpi;

  wMap["N2190_Npi"] = (G4double*) pwN2190_Npi;
  wMap["N2190_Nrho"] = (G4double*) pwN2190_Nrho;
  wMap["N2190_Npipi"] = (G4double*) pwN2190_Npipi;
  wMap["N2190_Dpi"] = (G4double*) pwN2190_Dpi;
  wMap["N2190_Nstarpi"] = (G4double*) pwN2190_Nstarpi;

  wMap["N2220_Npi"] = (G4double*) pwN2220_Npi;
  wMap["N2220_Nrho"] = (G4double*) pwN2220_Nrho;
  wMap["N2220_Npipi"] = (G4double*) pwN2220_Npipi;
  wMap["N2220_Dpi"] = (G4double*) pwN2220_Dpi;
  wMap["N2250_Npi"] = (G4double*) pwN2250_Npi;
  wMap["N2250_Nrho"] = (G4double*) pwN2250_Nrho;
  wMap["N2250_Npipi"] = (G4double*) pwN2250_Npipi;
  wMap["N2250_Dpi"] = (G4double*) pwN2250_Dpi;
  wMap["N2250_Nstarpi"] = (G4double*) pwN2250_Nstarpi;
  
  wMap["D1232_Ngamma"]  = (G4double*) pwD1232_Ngamma;
  wMap["D1232_Npi"]     = (G4double*) pwD1232_Npi;
  
  wMap["D1600_Npi"]     = (G4double*) pwD1600_Npi;
  wMap["D1600_Dpi"]     = (G4double*) pwD1600_Dpi;
  wMap["D1600_Nstarpi"] = (G4double*) pwD1600_Nstarpi;
  
  wMap["D1620_Ngamma"] = (G4double*) pwD1620_Ngamma;
  wMap["D1620_Npi"] = (G4double*) pwD1620_Npi;
  wMap["D1620_Dp"] = (G4double*) pwD1620_Dpi;
  wMap["D1620_Nstarpi"] = (G4double*) pwD1620_Nstarpi;

  wMap["D1700_Ngamma"] = (G4double*) pwD1700_Ngamma;
  wMap["D1700_Npi"] = (G4double*) pwD1700_Npi;
  wMap["D1700_Nrho"] = (G4double*) pwD1700_Nrho;
  wMap["D1700_Dpi"] = (G4double*) pwD1700_Dpi;
  wMap["D1700_Nstarpi"] = (G4double*) pwD1700_Nstarpi;
  
  wMap["D1900_Npi"] = (G4double*) pwD1900_Npi;
  wMap["D1900_Nrho"] = (G4double*) pwD1900_Nrho;
  wMap["D1900_Dpi"] = (G4double*) pwD1900_Dpi;
  wMap["D1900_Nstarpi"] = (G4double*) pwD1900_Nstarpi;

  wMap["D1905_Ngamma"] = (G4double*) pwD1905_Ngamma;
  wMap["D1905_Npi"] = (G4double*) pwD1905_Npi;
  wMap["D1905_Nrho"] = (G4double*) pwD1905_Nrho;
  wMap["D1905_Dpi"] = (G4double*) pwD1905_Dpi;
  wMap["D1905_Nstarpi"] = (G4double*) pwD1905_Nstarpi;

  wMap["D1910_Npi"] = (G4double*) pwD1910_Npi;
  wMap["D1910_Nrho"] = (G4double*) pwD1910_Nrho;
  wMap["D1910_Dpi"] = (G4double*) pwD1910_Dpi;
  wMap["D1910_Nstarpi"] = (G4double*) pwD1910_Nstarpi;

  wMap["D1920_Npi"] = (G4double*) pwD1920_Npi;
  wMap["D1920_Nrho"] = (G4double*) pwD1920_Nrho;
  wMap["D1920_Dpi"] = (G4double*) pwD1920_Dpi;
  wMap["D1920_Nstarpi"] = (G4double*) pwD1920_Nstarpi;

  wMap["D1930_Npi"] = (G4double*) pwD1930_Npi;
  wMap["D1930_Nrho"] = (G4double*) pwD1930_Nrho;
  wMap["D1930_Dpi"] = (G4double*) pwD1930_Dpi;
  wMap["D1930_Nstarpi"] = (G4double*) pwD1930_Nstarpi;

  wMap["D1950_Ngamma"] = (G4double*) pwD1950_Ngamma;
  wMap["D1950_Npi"] = (G4double*) pwD1950_Npi;
  wMap["D1950_Nrho"] = (G4double*) pwD1950_Nrho;
  wMap["D1950_Dpi"] = (G4double*) pwD1950_Dpi;
  wMap["D1950_Nstarpi"] = (G4double*) pwD1950_Nstarpi;

  wMap["L1405_Spi"] = (G4double*) pwL1405_Spi;

  wMap["L1520_NKbar"] = (G4double*) pwL1520_NKbar;
  wMap["L1520_Spi"] = (G4double*) pwL1520_Spi;
  wMap["L1520_Sstarpi"] = (G4double*) pwL1520_Sstarpi;
  wMap["L1520_Lgamma"] = (G4double*) pwL1520_Lgamma;

  wMap["L1600_NKbar"] = (G4double*) pwL1600_NKbar;
  wMap["L1600_Spi"] = (G4double*) pwL1600_Spi;

  wMap["L1670_NKbar"] = (G4double*) pwL1670_NKbar;
  wMap["L1670_Spi"] = (G4double*) pwL1670_Spi;
  wMap["L1670_Leta"] = (G4double*) pwL1670_Leta;

  wMap["L1690_NKbar"] = (G4double*) pwL1690_NKbar;
  wMap["L1690_Spi"] = (G4double*) pwL1690_Spi;
  wMap["L1690_Sstarpi"] = (G4double*) pwL1690_Sstarpi;
  
  wMap["L1800_NKbar"] = (G4double*) pwL1800_NKbar;
  wMap["L1800_NKstarbar"] = (G4double*) pwL1800_NKstarbar;
  wMap["L1800_Spi"] = (G4double*) pwL1800_Spi;
  wMap["L1800_Sstarpi"] = (G4double*) pwL1800_Sstarpi;

  wMap["L1810_NKbar"] = (G4double*) pwL1810_NKbar;
  wMap["L1810_NKstarbar"] = (G4double*) pwL1810_NKstarbar;
  wMap["L1810_Spi"] = (G4double*) pwL1810_Spi;
  wMap["L1810_Sstarpi"] = (G4double*) pwL1810_Sstarpi;

  wMap["L1820_NKbar"] = (G4double*) pwL1820_NKbar;
  wMap["L1820_Spi"] = (G4double*) pwL1820_Spi;
  wMap["L1820_Sstarpi"] = (G4double*) pwL1820_Sstarpi;

  wMap["L1830_NKbar"] = (G4double*) pwL1830_NKbar;
  wMap["L1830_Spi"] = (G4double*) pwL1830_Spi;
  wMap["L1830_Sstarpi"] = (G4double*) pwL1830_Sstarpi;

  wMap["L1890_NKbar"] = (G4double*) pwL1890_NKbar;
  wMap["L1890_NKstarbar"] = (G4double*) pwL1890_NKstarbar;
  wMap["L1890_Spi"] = (G4double*) pwL1890_Spi;
  wMap["L1890_Sstarpi"] = (G4double*) pwL1890_Sstarpi;

  wMap["L2100_NKbar"] = (G4double*) pwL2100_NKbar;
  wMap["L2100_NKstarbar"] = (G4double*) pwL2100_NKstarbar;
  wMap["L2100_Spi"] = (G4double*) pwL2100_Spi;
  wMap["L2100_Sstarpi"] = (G4double*) pwL2100_Sstarpi;
  wMap["L2100_Leta"] = (G4double*) pwL2100_Leta;
  wMap["L2100_Lomega"] = (G4double*) pwL2100_Lomega;
  
  wMap["L2110_NKbar"] = (G4double*) pwL2110_NKbar;
  wMap["L2110_NKstarbar"] = (G4double*) pwL2110_NKstarbar;
  wMap["L2110_Spi"] = (G4double*) pwL2110_Spi;

  wMap["S1385_Spi"] = (G4double*) pwS1385_Spi;
  wMap["S1385_Lpi"] = (G4double*) pwS1385_Lpi;

  wMap["S1660_NKbar"] = (G4double*) pwS1660_NKbar;
  wMap["S1660_Spi"] = (G4double*) pwS1660_Spi;
  wMap["S1660_Lpi"] = (G4double*) pwS1660_Lpi;

  wMap["S1670_NKbar"] = (G4double*) pwS1670_NKbar;
  wMap["S1670_Spi"] = (G4double*) pwS1670_Spi;
  wMap["S1670_Lpi"] = (G4double*) pwS1670_Lpi;

  wMap["S1750_NKbar"] = (G4double*) pwS1750_NKbar;
  wMap["S1750_Spi"] = (G4double*) pwS1750_Spi;
  wMap["S1750_Seta"] = (G4double*) pwS1750_Seta;

  wMap["S1775_NKbar"] = (G4double*) pwS1775_NKbar;
  wMap["S1775_Spi"] = (G4double*) pwS1775_Spi;
  wMap["S1775_Sstarpi"] = (G4double*) pwS1775_Sstarpi;
  wMap["S1775_Lpi"] = (G4double*) pwS1775_Lpi;
  wMap["S1775_Lstarpi"] = (G4double*) pwS1775_Lstarpi;

  wMap["S1915_NKbar"] = (G4double*) pwS1915_NKbar;
  wMap["S1915_Spi"] = (G4double*) pwS1915_Spi;
  wMap["S1915_Sstarpi"] = (G4double*) pwS1915_Sstarpi;
  wMap["S1915_Lpi"] = (G4double*) pwS1915_Lpi;

  wMap["S1940_NKbar"] = (G4double*) pwS1940_NKbar;
  wMap["S1940_NKstarbar"] = (G4double*) pwS1940_NKstarbar;
  wMap["S1940_Spi"] = (G4double*) pwS1940_Spi;
  wMap["S1940_Sstarpi"] = (G4double*) pwS1940_Sstarpi;
  wMap["S1940_Lpi"] = (G4double*) pwS1940_Lpi;
  wMap["S1940_Lstarpi"] = (G4double*) pwS1940_Lstarpi;
  wMap["S1940_DKbar"] = (G4double*) pwS1940_DKbar;

  wMap["S2030_NKbar"] = (G4double*) pwS2030_NKbar;
  wMap["S2030_NKstarbar"] = (G4double*) pwS2030_NKstarbar;
  wMap["S2030_Spi"] = (G4double*) pwS2030_Spi;
  wMap["S2030_Sstarpi"] = (G4double*) pwS2030_Sstarpi;
  wMap["S2030_Lpi"] = (G4double*) pwS2030_Lpi;
  wMap["S2030_Lstarpi"] = (G4double*) pwS2030_Lstarpi;
  wMap["S2030_DKbar"] = (G4double*) pwS2030_DKbar;

  wMap["X1530_Xpi"] = (G4double*) pwX1530_Xpi;
  wMap["X1530_Xgamma"] = (G4double*) pwX1530_Xgamma;

  wMap["X1690_Xpi"] = (G4double*) pwX1690_Xpi;
  wMap["X1690_LKbar"] = (G4double*) pwX1690_LKbar;
  wMap["X1690_SKbar"] = (G4double*) pwX1690_SKbar;

  wMap["X1820_Xpi"] = (G4double*) pwX1820_Xpi;
  wMap["X1820_LKbar"] = (G4double*) pwX1820_LKbar;
  wMap["X1820_SKbar"] = (G4double*) pwX1820_SKbar;

  wMap["X1950_Xpi"] = (G4double*) pwX1950_Xpi;
  wMap["X1950_LKbar"] = (G4double*) pwX1950_LKbar;
  wMap["X1950_SKbar"] = (G4double*) pwX1950_SKbar;

  wMap["X2030_Xpi"] = (G4double*) pwX2030_Xpi;
  wMap["X2030_LKbar"] = (G4double*) pwX2030_LKbar;
  wMap["X2030_SKbar"] = (G4double*) pwX2030_SKbar;

}


G4BaryonPartialWidth::~G4BaryonPartialWidth()
{ }


G4PhysicsVector* G4BaryonPartialWidth::MassDependentWidth(const G4String& name) const
{
  // NOTE: the returned pointer is owned by the client
  std::map <G4String, G4double*, std::less<G4String> >::const_iterator iter;

  if ((iter=wMap.find(name)) != wMap.end())
    {
      // Cross section table for the requested particle available in the Map
      G4PhysicsFreeVector* wVector = new G4PhysicsFreeVector(wSize);
      G4String key = name;
      G4double* wPointer = (*iter).second; 
      
      //     G4double* wPointer = wMap[key];
      G4int i;
      for (i=0; i<wSize; i++)
	{
	  G4double value = *(wPointer + i);
	  G4double energy = energies[i] * GeV;
	  wVector->PutValue(i,energy,value);
	}	          
      return wVector;
    }
  else
    {
      return 0;
    }
}
