//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: PrimaryGeneratorAction.hh,v 1.3 2010-07-16 07:37:48 maire Exp $
// GEANT4 tag $Name: not supported by cvs2svn $
// 
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo...... 

#ifndef PrimaryGeneratorAction_h
#define PrimaryGeneratorAction_h 1

#include "G4VUserPrimaryGeneratorAction.hh"
#include "globals.hh"

class PrimaryGeneratorAction1;
class PrimaryGeneratorAction2;
class PrimaryGeneratorAction3;
class PrimaryGeneratorAction4;
class PrimaryGeneratorMessenger;

class G4ParticleGun;
class G4Event;

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

class PrimaryGeneratorAction : public G4VUserPrimaryGeneratorAction
{
  public:
    PrimaryGeneratorAction();    
   ~PrimaryGeneratorAction();

  public:
    void GeneratePrimaries(G4Event*);

  public:
    G4ParticleGun* GetParticleGun() { return particleGun; };
    
    void SelectAction(G4int i) { selectedAction = i; };    
    G4int GetSelectedAction()  { return selectedAction; };    
    PrimaryGeneratorAction1*  GetAction1() { return action1; };
    PrimaryGeneratorAction2*  GetAction2() { return action2; };
    PrimaryGeneratorAction3*  GetAction3() { return action3; };
    PrimaryGeneratorAction4*  GetAction4() { return action4; };            
    
  private:
    G4ParticleGun*           particleGun;
    PrimaryGeneratorAction1* action1;
    PrimaryGeneratorAction2* action2;
    PrimaryGeneratorAction3* action3;
    PrimaryGeneratorAction4* action4;
    G4int                    selectedAction;
        
    PrimaryGeneratorMessenger* gunMessenger;     
};

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

#endif
