// $Id: Doxymain.h 55087 2011-11-16 10:11:00Z gcosmo $

/// \file Doxymain.h
/// \brief The main page for Geant4 Examples code documenation

/*! \mainpage Geant4 Examples

This module collects four sets of user examples aimed to demonstrate to
the user how to make correct use of the GEANT4 toolkit by implementing
in a correct way those user-classes which the user is supposed to
customize in order to define his/her own simulation setup.

The <b>"novice"</b> set of examples is oriented to novice users and covering all
possible general use-cases typical of an "application"-oriented kind of
development. As several examples in this "novice" set became too complicated, 
a new <b>"basic"</b> set, covering the most typical use-cases of a Geant4 application
with keeping simplicity and ease of use, is provided and is going to replace
the "novice" set in future.

An <b>"extended"</b> set of examples require some additional
libraries besides of Geant4. This set covers some specific use cases
for actual detector simulation. An <b>"advanced"</b> set of examples covers
the use-cases typical of a "toolkit"-oriented kind of development,
where real complete applications for different simulation studies are
provided; may require additional third party products to be built.

Most of the examples can be run both in interactive and batch mode, and 
input macro files (*.in) and reference output files (*.out) are provided.
Basic, novice and most of the extended examples are considered part of the
system testing suite for validation of the official releases of the
GEANT4 toolkit. Basic, novice and some of the extended and advanced
examples are also used as "acceptance"-tests for the release process.

See more on each examples category pages:
- \ref README_basic
- \ref README_extended
- <a href="http://geant4advancedexampleswg.wikispaces.com/ExamplesDocumentation">
  Geant4 Advanced Examples </a>
*/


