// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef HEPREP_HEPREPATTRIBUTELISTENER_H
#define HEPREP_HEPREPATTRIBUTELISTENER_H 1

// Copyright 2000-2005, FreeHEP.

#include <string>
#include <vector>

namespace HEPREP {

class HepRepInstance;

/**
 * HepRepAttributeListener interface. The implementor is called back for changes
 * of attributes while using the HepRepIterator to iterate over all the HepRepInstances.
 *
 * All names are lowercased.
 *
 * @author Mark Donszelmann
 */
class HepRepAttributeListener {

public: 
    /// Destructor.
    virtual ~HepRepAttributeListener() { /* nop */; }

    /**
     * Called if attribute key changes its value.
     *
     * @param instance instance for which this attribute is set.
     * @param key name of the changed attribute.
     * @param value value of the changed attribute.
     * @param lowerCaseValue lower case value of the changed attribute.
     * @param showLabel value of showLabel.
     */
    virtual void setAttribute(HepRepInstance * instance, std::string key, std::string value, std::string lowerCaseValue, int showLabel) = 0;

    /**
     * Called if attribute key changes its value.
     *
     * @param instance instance for which this attribute is set.
     * @param key name of the changed attribute.
     * @param value value of the changed attribute.
     * @param showLabel value of showLabel.
     */
    virtual void setAttribute(HepRepInstance * instance, std::string key, std::vector<double> value, int showLabel) = 0;

    /**
     * Called if attribute key changes its value.
     *
     * @param instance instance for which this attribute is set.
     * @param key name of the changed attribute.
     * @param value value of the changed attribute.
     * @param showLabel value of showLabel.
     */
    virtual void setAttribute(HepRepInstance * instance, std::string key, long value, int showLabel) = 0;

    /**
     * Called if attribute key changes its value.
     *
     * @param instance instance for which this attribute is set.
     * @param key name of the changed attribute.
     * @param value value of the changed attribute.
     * @param showLabel value of showLabel.
     */
    virtual void setAttribute(HepRepInstance * instance, std::string key, int value, int showLabel) = 0;

    /**
     * Called if attribute key changes its value.
     *
     * @param instance instance for which this attribute is set.
     * @param key name of the changed attribute.
     * @param value value of the changed attribute.
     * @param showLabel value of showLabel.
     */
    virtual void setAttribute(HepRepInstance * instance, std::string key, double value, int showLabel) = 0;

    /**
     * Called if attribute key changes its value.
     *
     * @param instance instance for which this attribute is set.
     * @param key name of the changed attribute.
     * @param value value of the changed attribute.
     * @param showLabel value of showLabel.
     */
    virtual void setAttribute(HepRepInstance * instance, std::string key, bool value, int showLabel) = 0;

    /**
     * Called if attribute key is removed from the attribute set.
     *
     * @param instance instance for which this attribute is set.
     * @param key name of the removed attribute.
     */
    virtual void removeAttribute(HepRepInstance * instance, std::string key) = 0;
}; // class
} // namespace HEPREP
#endif /* ifndef HEPREP_HEPREPATTRIBUTELISTENER_H */
