/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

class MOMOpipe {
    private Process ps;
    private BufferedReader inpS;
    private BufferedReader errS;
    private PrintWriter outS;
    private String errMsg = null;
    private boolean isErr = false;
    public boolean isMaking;

    MOMOpipe(String cmdMAKE) {
        try {
            this.ps = Runtime.getRuntime().exec(cmdMAKE);
        }
        catch (IOException e) {
            this.isErr = true;
            this.errMsg = e.getMessage();
            return;
        }
        this.inpS = new BufferedReader(new InputStreamReader(this.ps.getInputStream()));
        this.errS = new BufferedReader(new InputStreamReader(this.ps.getErrorStream()));
        this.outS = new PrintWriter(new DataOutputStream(this.ps.getOutputStream()));
    }

    String readStdLine() {
        String stdLine = null;
        try {
            stdLine = this.inpS.readLine();
        }
        catch (IOException e) {
            this.isErr = true;
            this.errMsg = e.getMessage();
        }
        return stdLine;
    }

    String readErrLine() {
        String errLine = null;
        try {
            errLine = this.errS.readLine();
        }
        catch (IOException e) {
            this.isErr = true;
            this.errMsg = e.getMessage();
            System.err.println(this.errMsg);
        }
        return errLine;
    }

    synchronized boolean writeLine(String st) {
        this.outS.println(st);
        return this.outS.checkError();
    }

    synchronized void processKill() {
        this.ps.destroy();
    }

    boolean isError() {
        return this.isErr;
    }

    String getErrorMsg() {
        if (!this.isErr) {
            return "";
        }
        return this.errMsg;
    }
}

