//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id$
//
// Author: Mathieu Karamitros (kara (AT) cenbg . in2p3 . fr) 
//
// History:
// -----------
// 10 Oct 2011 M.Karamitros created
//
// -------------------------------------------------------------------


#include "G4VITRestProcess.hh"
G4VITRestProcess::G4VITRestProcess()
                   :G4VITProcess("No Name Rest Process")
{
  G4Exception("G4VITRestProcess::G4VITRestProcess()","Illegal operation",
	      JustWarning,"default constructor is called");
}

G4VITRestProcess::G4VITRestProcess(const G4String& aName , G4ProcessType aType)
                  : G4VITProcess(aName, aType)
{
  enableAlongStepDoIt = false;
  enablePostStepDoIt = false;
}

G4VITRestProcess::~G4VITRestProcess()
{
}

G4VITRestProcess::G4VITRestProcess(const G4VITRestProcess& right)
                  : G4VITProcess(right)
{
}











