//$Id: GAGcommandItem.java,v 1.2 2004/09/24 08:50:51 suzuki Exp $
// GAG (Geant4 Adaptive GUI)
// first created :   1998/Mar/31
// GEANT4 GUI Group, Toshiaki Kodama
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GAG;

class GAGcommandItem extends Object {
  static final int NAME=0, GUIDE=1, TYPE=2, OMITTABLE=3, DEFAULT=4, RANGE=5, CANDIDATE=6;
  static final int MAX = 7;
  private String name, guide[], range;
  private int paramEnts;
  String params[][];
  GAGcommandItem(String name, String guide[], String range, int ents){
    this.name = name;
    this.guide = guide;
    paramEnts = ents;
    if (ents > 0) {
      params = new String[paramEnts][MAX];
    }
    this.range = range;
    return;
  }
  String getCommandName(){
    return name;
  }
  String[] getCommandGuide(){
    return guide;
  }
  String getTitle(){
    return guide[0];
  }
  String getCommandRange(){
    return range;
  }
  int getParamEntries(){
    return paramEnts;
  }
  String getParamName(int pos){
    return params[pos][NAME];
  }
  String getParamGuide(int pos){
    return params[pos][GUIDE];
  }
  String getParamType(int pos){
    return params[pos][TYPE];
  }
  boolean isOmittable(int ent){
    return params[ent][OMITTABLE].equals("1");
  }
  String getParamDefault(int pos){
    return params[pos][DEFAULT];
  }
  String getParamRange(int pos){
    return params[pos][RANGE];
  }
  String getParamCandidate(int pos){
    return params[pos][CANDIDATE];
  }
}
