//$Id: RatioCellEditor.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $

//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.Serializable;

public class RatioCellEditor extends Object implements TableCellEditor, ActionListener, java.io.Serializable {  
  private Component compo;  
  private Vector editorListener;  
  private Object value;  
  private RatioDialog ratioDialog;  
//MOMO
  MaterialFrame parent;  

    //public  RatioCellEditor(Frame parent){  
public  RatioCellEditor(MaterialFrame parent){  
    this.parent = parent;  
    editorListener = new Vector();  
    compo = new JLabel();  
  }  
  public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int columnIndex){  
    this.value = value;  
    return compo;  
  }  
  public Object getCellEditorValue(){  
    ratioDialog.getValues();  
    return value;  
  }   
  public boolean isCellEditable(EventObject ev){  
    return true;  
  }   
  public boolean shouldSelectCell(EventObject ev){  
    ratioDialog = new RatioDialog(this, (RatioItem)value );  
    return true;  
  }   
  public boolean stopCellEditing(){  
    ratioDialog.editStop();  
    castStop();  
    return true;  
  }   
  public void cancelCellEditing(){  
    ratioDialog.editStop();  
    castCancel();  
  }  
  private void castStop(){  
    for (int i=0; i<editorListener.size(); i++){  
      CellEditorListener cel = (CellEditorListener)editorListener.elementAt(i);  
      cel.editingStopped(new ChangeEvent(this));  
    }  
  }  
  private void castCancel(){  
    for (int i=0; i<editorListener.size(); i++){  
      CellEditorListener cel = (CellEditorListener)editorListener.elementAt(i);  
      cel.editingCanceled(new ChangeEvent(this));  
    }  
  }  
  public void addCellEditorListener(CellEditorListener ce){  
    editorListener.addElement(ce);  
  }  
  public void removeCellEditorListener(CellEditorListener ce){  
    editorListener.removeElement(ce);  
  }   
  public void actionPerformed(ActionEvent ae){  
    stopCellEditing();  
  }  
}  
