//$Id: MaterialCombiItem.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
// GGE (Geant4 Geometry Editor)
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// Material Combination  Items

// Toshiaki Kodama

package GGE;



class MaterialCombiItem extends MaterialItem {

  ElementItem elements[];

  float ratios[];

  boolean byNum;

  MaterialCombiItem(String name, float density, int densityUnit,int state, float tempe,int tempeUnit, float pressure, ElementItem[] elements, boolean byNum, float[] ratios){

    this.name = name;

    this.density = density;

    this.densityUnit = densityUnit;

    this.state = state;

//    this.tempeOmit = tempeOmit;

    this.tempe = tempe;

    this.tempeUnit = tempeUnit;

    this.pressure = pressure;

    this.elements = elements;

    this.byNum = byNum;

    this.ratios = ratios;

  }

  MaterialCombiItem(ElementItem[] elements){

    ratios = new float[elements.length];

    this.elements = elements;

  }

  public String getRatioNum(int pos){

    if (byNum){

      return ""+(int)ratios[pos];

    }

    return ""+ratios[pos];

  }



}

