//$Id: LogicalPanel.java,v 1.14 2004/11/16 06:42:18 suzuki Exp $
//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//// 2002 Jan link between LogicalPanel and materialFrame must be revised
//2004 feb 26 prefix logical removed, prefix solid is left
package GGE;

import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class LogicalPanel extends JPanel implements ActionListener,
							MouseListener {
  private JButton ok, app, ins, del;
  private JComboBox solidSelect;
  private JComboBox matSelect, colorSelect;
  DefaultComboBoxModel matComboModel, colComboModel;
  private JFrame messageFrame, frame1;
  JTable logTable;
  MaterialScratchTable msTable;
  MaterialCombiTable mcTable;
    //  CreateLogicalDialog createLogDialog;
//  DellLogicalDialog dellDialog;
//  InsertLogicalDialog insertLogDialog;

    private boolean noSld = false;
    private StringBuffer noSldName;
  public GGETableModel logDataModel;
  String tableIdent[] = {"Name","Solid","Material","VisAtb"};
  VolumesFrame volFrame;

  LogicalPanel(VolumesFrame volFrame){
    this.volFrame = volFrame;
    //    createLogDialog = new CreateLogicalDialog(volFrame);
//    insertLogDialog = new InsertLogicalDialog(volFrame);
    setLayout(new BorderLayout(2,2));
    noSldName = new StringBuffer();

    logTable = new JTable(logDataModel = new GGETableModel(tableIdent,0));
    logTable.setAutoCreateColumnsFromModel(false);
    //logTable.setColumnSelectionAllowed(false);
    logTable.setColumnSelectionAllowed(true);
    logTable.setRowSelectionAllowed(true);
    logTable.getTableHeader().setReorderingAllowed(false);
    logTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    logTable.addMouseListener(this);

    matSelect = new JComboBox();
      matSelect.setEditable(true);
      matComboModel = new DefaultComboBoxModel();
      matSelect.setModel(matComboModel);
      matComboModel.addElement("");

    colorSelect = new JComboBox();
      colorSelect.setEditable(true);
      colComboModel = new DefaultComboBoxModel();
      colorSelect.setModel(colComboModel);
      colComboModel.addElement("");

    TableColumn columns[] = new TableColumn[tableIdent.length];
    for (int i=0; i<tableIdent.length; i++){
      columns[i] = logTable.getColumn(tableIdent[i]);
    }
    DefaultTableCellRenderer logNameCellRenderer = new DefaultTableCellRenderer();
      logNameCellRenderer.setBackground(Color.pink);

    columns[0].setCellEditor(new NameCellEditor());
    columns[0].setCellRenderer(logNameCellRenderer);
    columns[0].setMinWidth(50);
    columns[1].setCellEditor(new SolidCellEditor(volFrame));
    columns[1].setMinWidth(60);
    columns[2].setCellEditor(new DefaultCellEditor(matSelect));
    columns[2].setMinWidth(60);
    columns[3].setCellEditor(new DefaultCellEditor(colorSelect));
    columns[3].setMinWidth(50);
    JScrollPane scrollpane = new JScrollPane(logTable);
    scrollpane.setPreferredSize(new Dimension(350, 270));
    scrollpane.setMinimumSize(new Dimension(100, 30));

    JPanel tablePanel = new JPanel();
    tablePanel.setLayout(new BorderLayout(2,2));
     tablePanel.setBorder(new TitledBorder(LineBorder.createBlackLineBorder(),
                                                         " Logical Volume "));
     tablePanel.add("Center", scrollpane);


    JPanel south = new JPanel(new BorderLayout());
     solidSelect = new JComboBox();
     solidSelect.setMaximumRowCount(10);
     for (int i=0; i<CSGItem.solidName.length; i++){
       solidSelect.addItem(new CSGItem(i));
     }
    for (int i=0; i<BREPItem.solidName.length; i++){
      solidSelect.addItem(new BREPItem(i));
    }
     south.add("West",new JLabel("Select a solid "));
     south.add("Center", solidSelect);

    JPanel buttonPanel = new JPanel();
     buttonPanel.setLayout(new GridLayout(1,3));
     buttonPanel.add(app = new JButton("Append"));
     buttonPanel.add(ins = new JButton("Insert"));
     buttonPanel.add(del = new JButton("Delete"));

     app.setForeground(Color.cyan);
    ins.setForeground(Color.cyan);
    del.setForeground(Color.cyan);

     south.add("North", buttonPanel);

    JPanel materialPane =new JPanel();
    materialPane.setBorder(new TitledBorder(LineBorder.createBlackLineBorder(),
                                                               " Materials "));
     materialPane.setLayout(new BorderLayout(2,2));
     materialPane.add("North", ok = new JButton("Mark the Used Materials"));

     ok.addActionListener(this);
     ok.setForeground(Color.cyan);
     ins.addActionListener(this);
     del.addActionListener(this);
     app.addActionListener(this);
     tablePanel.add("North", south);

    add("Center", tablePanel);
    add("South", materialPane);
    setSize(250,580);
  }

  public void actionPerformed(ActionEvent ae){
    Object o = ae.getSource();
    if (o == ok ){ 
       ok.setForeground(Color.red);
       JOptionPane opane = new JOptionPane();
       int choose = opane.showConfirmDialog(this, "Clear and set flags to materials Used in Logical Volum","Used Materials Dialog", JOptionPane.YES_NO_OPTION);
       JDialog dialog = opane.createDialog(this, "Warning Dialog");
      ///////////////////////////
      try{
         Class targetClass = dialog.getClass();
         Class[] parameters = new Class[]{boolean.class};
         java.lang.reflect.Method method
                 = targetClass.getDeclaredMethod("setAlwaysOnTop",parameters);
         Object targetInstance = targetClass.newInstance();
         Object[] params = new Object[]{new boolean[]{true}};
         if(System.getProperty("java.version").equals("1.5.0")){
            method.invoke(targetInstance, params);
          }
       }catch(Exception e){ }
       ///////////////////////////
       if(choose == JOptionPane.YES_OPTION){

         volFrame.okCommand();
         ok.setForeground(Color.black); 
       }else{
         ok.setForeground(Color.black);
         return;
       }
    }
    if (o == app){        
        addLogicalRow();
        app.setForeground(Color.red);
        repaint();
        appLogCloseAct();
        return; 
    }
    if (o == ins){
//        insertLogDialog.setVisible(true);
	insertLogicalRow();
        ins.setForeground(Color.red);
        return;      
    }
    if (o == del){
//        dellDialog = new DellLogicalDialog(volFrame);
//        dellDialog.setVisible(true);
	dell();
        del.setForeground(Color.red);
       
    }
  }
  public void dellLogCloseAct(){del.setForeground(Color.black);repaint();}
  public void appLogCloseAct(){app.setForeground(Color.black);repaint();}
  public void insertLogCloseAct(){ins.setForeground(Color.black);repaint();}

  public void logClear(){
    logTable.setModel(logDataModel = new GGETableModel(tableIdent,0));
    repaint();
  }

  public void addLogicalRow(){
    SolidItem seleItem = (SolidItem)solidSelect.getSelectedItem();
    Object newRow[] = new Object[4];
    newRow[0] = "";
    newRow[2] = "";
    if (seleItem instanceof CSGItem){
      newRow[1] = new CSGItem(seleItem.getSolidType());
    }else{
      newRow[1] = new BREPItem(seleItem.getSolidType());
    }
    newRow[3] = volFrame.visPanel.getSelectedVis();
    if (newRow[3] == null) newRow[3] = "";
    logDataModel.addRow(newRow);
    appLogCloseAct();
    app.setForeground(Color.black);
    repaint();
  }

  public void insertLogicalRow(){
    SolidItem seleItem = (SolidItem)solidSelect.getSelectedItem();
    Object newRow[] = new Object[4];
    newRow[0] = "";
    newRow[2] = "";
    if (seleItem instanceof CSGItem){
      newRow[1] = new CSGItem(seleItem.getSolidType());
    }else{
      newRow[1] = new BREPItem(seleItem.getSolidType());
    }
    newRow[3] = volFrame.visPanel.getSelectedVis();
    if (newRow[3] == null) newRow[3] = "";

     if(logTable.getSelectedRow()==-1){
       JOptionPane opane = new JOptionPane();
      opane.showMessageDialog(this, "Choose the Name","Warning Dialog" , JOptionPane.WARNING_MESSAGE);
       JDialog dialog = opane.createDialog(this, "Warning Dialog");
      ///////////////////////////
      try{
         Class targetClass = dialog.getClass();
         Class[] parameters = new Class[]{boolean.class};
         java.lang.reflect.Method method
                 = targetClass.getDeclaredMethod("setAlwaysOnTop",parameters);
         Object targetInstance = targetClass.newInstance();
         Object[] params = new Object[]{new boolean[]{true}};
         if(System.getProperty("java.version").equals("1.5.0")){
            method.invoke(targetInstance, params);
          }
       }catch(Exception e){ }
       ///////////////////////////
     }else{
      int logRowCount = logTable.getSelectedRow()+1;
      logDataModel.insertRow(logRowCount,newRow);
//      insertLogDialog.setVisible(false);
      ins.setForeground(Color.black);
      repaint();
     }
  }

  public void dell(){
     if(logTable.getSelectedRow()==-1){
      JOptionPane opane = new JOptionPane();
      opane.showMessageDialog(this, "Choose the Name","Warning Dialog", JOptionPane.WARNING_MESSAGE);
      JDialog dialog = opane.createDialog(this, "Warning Dialog");
      ///////////////////////////
      try{
         Class targetClass = dialog.getClass();
         Class[] parameters = new Class[]{boolean.class};
         java.lang.reflect.Method method
	         = targetClass.getDeclaredMethod("setAlwaysOnTop",parameters);
         Object targetInstance = targetClass.newInstance();
         Object[] params = new Object[]{new boolean[]{true}};
         if(System.getProperty("java.version").equals("1.5.0")){
            method.invoke(targetInstance, params);
          }
       }catch(Exception e){ e.printStackTrace(); }
       ///////////////////////////
     }else{
       stopEditing();
      logDataModel.removeRow(logTable.getSelectedRow());
//      dellDialog.setVisible(false);
      del.setForeground(Color.black);
      repaint();
     }
  }

  public void stopEditing(){
   int row =0, column =0;
   if(  (row = logTable.getEditingRow()) != -1 &&
          (column = logTable.getEditingColumn()) != -1 ){
         TableCellEditor cellEditor = logTable.getCellEditor(row,column);
         cellEditor.stopCellEditing();
    }
  }

/* Data Save Method */
  Vector getSaveData(){
    Vector logicalData = new Vector();
    Component compo[];
    compo = getComponents();
    for (int i = 0; i<compo.length; i++) {
    } 
    return logicalData;
    }
/* Data Load Method */  
  void setLoadData(Vector logicalData){
    removeAll();
    for (int i=0; i<logicalData.size(); i++){
    }
    validate();
  }
 
  public String getCPP(){
    StringBuffer cpp = new StringBuffer("\n// Logical  Volumes\n\n");
    stopEditing();
    Vector data = logDataModel.getDataVector();
    Vector rowData;
    if(data.size()==0){
      return cpp.toString();
    }else{
      for (int i=0; i<data.size(); i++){
        rowData = (Vector)data.elementAt(i);
        String name = (String)rowData.elementAt(0);
        SolidItem solid = (SolidItem)rowData.elementAt(1);
//8-31
         cpp.append(solid.getCPP(name));
	 //         cpp.append("G4LogicalVolume * "+"logical"+name+ //2004 Feb 26
         cpp.append("G4LogicalVolume * "+name+
                    " = new G4LogicalVolume(solid"+name+", \t //its solid\n"+
                    "\t\t\t "+rowData.elementAt(2)+", \t\t //its material\n"+
		    //                    "\t\t\t \""logical"+name+"\" ,\t\t //its name\n"+
                    "\t\t\t\""+name+"\" ,\t\t //its name\n"+
                    "\t\t\t 0,0,0);\n\n");
         if (rowData.elementAt(3).equals("")){
           //next data
         }else{
	     //	   cpp.append("logical"+name+"->SetVisAttributes("+
	   cpp.append(name+"->SetVisAttributes("+
                                        rowData.elementAt(3)+");\n\n");
         }
      }
    }
    return cpp.toString();
  }

  String getXML(){
    StringBuffer xml = new StringBuffer("\n<!--Solid-->\n");
    StringBuffer solidxml = new StringBuffer();
    StringBuffer logicalxml = new StringBuffer("\n<!--Logical Volumes-->\n\n");
    StringBuffer defxml = new StringBuffer();
    stopEditing();

   Vector data = logDataModel.getDataVector();
    noSld = false;
    noSldName.delete(0, noSldName.length());
    Vector rowData;
    if(data.size()==0){
      return xml.toString();
    }else{
      xml.append("  <solids>\n");
      defxml.append("     <define>\n");
      logicalxml.append("  <structure>\n");
      for (int i=0; i<data.size(); i++){
        rowData = (Vector)data.elementAt(i);
        String name = (String)rowData.elementAt(0);
        SolidItem solid = (SolidItem)rowData.elementAt(1);
        String solidName =solid.toString();
         solidxml.append(solid.getXML(name, i));
         defxml.append(solid.getDefine(name, i));
         logicalxml.append("     <volume name=\""+rowData.elementAt(0)+"\">\n"+
                "\t<solidref ref=\"");
          if( solidName == "Box" ){ solidName = "box"+i;}
          else if( solidName == "SymTrapezoid" ){ solidName = "trd"+i; }
          else if( solidName == "TubeSegment" ){ solidName = "tube"+i; }
          else if( solidName == "ConeSegment" ){ solidName = "cone"+i;  }
          else if( solidName == "SphereSegment" ){ solidName = "sphere"+i;  }
          else if( solidName == "Parallelepiped" ){ solidName = "para"+i; }
	  else if( solidName == "TorusSegment" ){ solidName ="torus";
						  noSld = true;
					  noSldName.append("TorusSegment\n"); }
	  else if( solidName == "HYPE" ){  solidName = "hype";
					   noSld = true;
					   noSldName.append("HYPE\n"); }
	  else if( solidName == "PolyConeSegment" ){ solidName = "pcon";
						     noSld = true;
					noSldName.append("PolyConeSegment\n"); }
	  else if( solidName == "PolyGonSegment" ){ solidName = "pgon";
						    noSld = true;
					noSldName.append("PolyGonSegment\n");}
	  else{  noSld = true; noSldName.append(solidName); }

          logicalxml.append(solidName+"\"/>\n");

          logicalxml.append("\t<materialref ref=\""+rowData.elementAt(2)+"\"/>\n");
          logicalxml.append("     </volume>\n");

      }
      defxml.append("     </define>\n");
      xml.append(defxml.toString());
      xml.append(solidxml.toString());
      xml.append("  </solids>\n");

      logicalxml.append("  </structure>\n");
      xml.append(logicalxml.toString());
    }
    return xml.toString();
  }

  boolean isSaveOk(){ return noSld; }
  String noSldName(){ return noSldName.toString();  }

   public void mousePressed(MouseEvent e){
     JTable table = (JTable)e.getSource();
////material Combo
     if( table.getSelectedColumn() == 2){
       String matStr[] = volFrame.getMaterialName();

       //add
       int modelSize = matComboModel.getSize();
       String modelStr[] = new String[modelSize];
       for(int i=0; i < modelSize; i++){
             modelStr[i] = matComboModel.getElementAt(i).toString();
       }
       boolean exist = false;
       for(int i=0; i < matStr.length; i++){
          for(int j=0; j <  modelSize; j++){
            if( modelStr[j].equals(matStr[i])){
                exist = true;
            }
          }
          if(!exist){ matComboModel.addElement(matStr[i]); }
         exist = false;
       }
       //remove
       modelSize = matComboModel.getSize();
       modelStr = new String[modelSize];
       for(int i=0; i < modelSize; i++){
             modelStr[i] = matComboModel.getElementAt(i).toString();
       }
       exist = false;
       for(int j=0; j < modelSize; j++ ){
          for(int i=0; i < matStr.length; i++){
             if( modelStr[j].equals(matStr[i])){
               exist = true;
             }
          }
          if(!exist &&! modelStr[j].equals("") ){ matComboModel.removeElementAt(j);}
          exist = false;
       }
       repaint();
/////color Combo
     }else if(table.getSelectedColumn() == 3){
       String colStr[] = volFrame.visPanel.getColorName();

       //add
       int modelSize = colComboModel.getSize();
       String modelStr[] = new String[modelSize];
       for(int i=0; i < modelSize; i++){
             modelStr[i] = colComboModel.getElementAt(i).toString();
       }
       boolean exist = false;
       for(int i=0; i < colStr.length; i++){
          for(int j=0; j <  modelSize; j++){
            if( modelStr[j].equals(colStr[i])){
                exist = true;
            }
          }
          if(!exist){ colComboModel.addElement(colStr[i]); }
         exist = false;
                     }
       //remove
       modelSize = colComboModel.getSize();
       modelStr = new String[modelSize];
       for(int i=0; i < modelSize; i++){
             modelStr[i] = colComboModel.getElementAt(i).toString();
       }
       exist = false;
       for(int j=0; j < modelSize; j++ ){
          for(int i=0; i < colStr.length; i++){
             if( modelStr[j].equals(colStr[i])){
               exist = true;
             }
          }
          if(!exist &&! modelStr[j].equals("") ){ colComboModel.removeElementAt(j);}
          exist = false;
       }
       repaint();
     }
   }

 /* public String[] getMaterialName(){
   GGETableModel msModel = volFrame.matFrame.msDataModel;
   GGETableModel mcModel = volFrame.matFrame.mcDataModel;
   int sRow = msModel.getRowCount();
   int cRow  = mcModel.getRowCount();
   int scratchRow = 0; int combiRow = 0;    //number of "used"
   //check "used"
   for( int i=0; i < sRow; i++ ){
     if(msModel.getValueAt(i,0).equals("Used")){ scratchRow++; }
   }
   for( int i=0; i < cRow; i++ ){
     if(mcModel.getValueAt(i,0).equals("Used")){ combiRow++; }
   }

   int matRow = scratchRow + combiRow;
   String materialName[] = new String[matRow];
   matRow = 0;
   
   for( int i=0; i < sRow; i++ ){
     if( msModel.getValueAt(i,0).equals("Used")){
        materialName[matRow] = msModel.getValueAt(i,1).toString();
	matRow++;
      }
   }
   for( int i=0; i < cRow;  i++ ){
     if( mcModel.getValueAt(i,0).equals("Used")){
         materialName[matRow] = mcModel.getValueAt(i,1).toString();
	 matRow++;
     }
   }
   return materialName;
  }*/

  public void mouseDragged(MouseEvent e){}
  public void mouseReleased(MouseEvent e){}
  public void mouseClicked(MouseEvent e){}
  public void mouseEntered(MouseEvent e){}
  public void mouseExited(MouseEvent e){}


}
