//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// $Id: G4CascadeOmegaMinusPChannel.cc 67796 2013-03-08 06:18:39Z mkelsey $
//
// Author:  D.H. Wright (SLAC)
// Date:    1 October 2012
//
// Description: partial cross sections for 2-7 body final states of the
//              omega- p reaction
//

#include "G4CascadeOmegaMinusPChannel.hh"
#include "G4InuclParticleNames.hh"
using namespace G4InuclParticleNames;

namespace {
  // Outgoing particle types of a given multiplicity

  static const G4int omp2bfs[4][2] =
    {{om,pro}, {xi0,lam}, {xi0,s0}, {xim,sp}};

  static const G4int omp3bfs[18][3] =
    {{om,pro,pi0},  {om,neu,pip}, {xim,pro,k0b}, {xi0,pro,kmi}, {xi0,neu,k0b},
     {xi0,lam,pi0}, {xi0,s0,pi0}, {xim,lam,pip}, {xim,s0,pip},  {xim,sp,pi0},
     {xi0,sm,pip},  {xi0,sp,pim}, {sm,sp,k0b},   {s0,s0,k0b},   {s0,sp,kmi},
     {s0,lam,k0b},  {sp,lam,kmi}, {lam,lam,k0b}};

  static const G4int omp4bfs[55][4] =
    {{om,pro,pip,pim},  {om,pro,pi0,pi0},  {om,neu,pip,pi0},  {xim,pro,kmi,pip},
     {xim,pro,k0b,pi0}, {xim,neu,k0b,pip}, {xi0,pro,kmi,pi0}, {xi0,pro,k0b,pim},
     {xi0,neu,k0b,pi0}, {xi0,neu,kmi,pip}, {xim,lam,pip,pi0}, {xi0,lam,pip,pim},
     {xi0,lam,pi0,pi0}, {xim,lam,kpl,k0b}, {xi0,lam,kpl,kmi}, {xi0,lam,k0,k0b},
     {xim,s0,pip,pi0},  {xi0,s0,pip,pim},  {xi0,s0,pi0,pi0},  {xim,s0,kpl,k0b},
     {xi0,s0,kpl,kmi},  {xi0,s0,k0,k0b},   {xim,sp,pip,pim},  {xim,sp,pi0,pi0},
     {xi0,sp,pim,pi0},  {xim,sp,kpl,kmi},  {xim,sp,k0,k0b},   {xi0,sp,kmi,k0},
     {xim,sm,pip,pip},  {xi0,sm,pip,pi0},  {xi0,sm,kpl,k0b},  {xim,xi0,kpl,pi0},
     {xim,xi0,k0,pip},  {sm,pro,k0b,k0b},  {s0,pro,kmi,k0b},  {s0,neu,k0b,k0b},
     {sp,pro,kmi,kmi},  {sp,neu,kmi,k0b},  {sm,lam,k0b,pip},  {sm,s0,k0b,pip},
     {sm,sp,kmi,pip},   {sm,sp,k0b,pi0},   {s0,lam,kmi,pip},  {s0,lam,k0b,pi0},
     {s0,sp,kmi,pi0},   {s0,sp,k0b,pim},   {s0,s0,kmi,pip},   {s0,s0,k0b,pi0},
     {sp,lam,kmi,pi0},  {sp,lam,k0b,pim},  {sp,sp,kmi,pim},   {lam,pro,kmi,k0b},
     {lam,neu,k0b,k0b}, {lam,lam,kmi,pip}, {lam,lam,k0b,pi0}};
 
  static const G4int omp5bfs[76][5] =
    {{om,pro,pip,pim,pi0},  {om,pro,pi0,pi0,pi0},  {om,neu,pip,pip,pim}, 
     {om,neu,pip,pi0,pi0},  {xim,pro,kmi,pip,pi0}, {xim,pro,k0b,pip,pim},
     {xim,pro,k0b,pi0,pi0}, {xim,neu,kmi,pip,pip}, {xim,neu,k0b,pip,pi0},
     {xi0,pro,kmi,pip,pim}, {xi0,pro,kmi,pi0,pi0}, {xi0,pro,k0b,pim,pi0},
     {xi0,neu,k0b,pip,pim}, {xi0,neu,k0b,pi0,pi0}, {xi0,neu,kmi,pip,pi0},
     {xim,lam,pip,pip,pim}, {xim,lam,pip,pi0,pi0}, {xi0,lam,pip,pim,pi0},
     {xi0,lam,pi0,pi0,pi0}, {xim,sm,pip,pip,pi0},  {xim,s0,pip,pip,pim},
     {xim,s0,pip,pi0,pi0},  {xim,sp,pip,pim,pi0},  {xim,sp,pi0,pi0,pi0},
     {xi0,sm,pip,pip,pim},  {xi0,sm,pip,pi0,pi0},  {xi0,s0,pip,pim,pi0},
     {xi0,s0,pi0,pi0,pi0},  {xi0,sp,pip,pim,pim},  {xi0,sp,pim,pi0,pi0},  
     {sm,pro,k0b,k0b,pi0},  {sm,pro,k0b,kmi,pip},  {sm,neu,k0b,k0b,pip},
     {s0,pro,kmi,k0b,pi0},  {s0,pro,kmi,kmi,pip},  {s0,pro,k0b,k0b,pim},
     {s0,neu,k0b,k0b,pi0},  {s0,neu,k0b,kmi,pip},  {sp,pro,kmi,kmi,pi0},
     {sp,pro,k0b,kmi,pim},  {sp,neu,k0b,k0b,pim},  {sp,neu,k0b,kmi,pi0},
     {sp,neu,kmi,kmi,pip},  {sm,lam,k0b,pip,pi0},  {sm,lam,kmi,pip,pip},
     {s0,lam,k0b,pip,pim},  {s0,lam,k0b,pi0,pi0},  {s0,lam,kmi,pip,pi0},
     {sp,lam,k0b,pim,pi0},  {sp,lam,kmi,pip,pim},  {sp,lam,kmi,pi0,pi0},
     {sm,sm,k0b,pip,pip},   {sm,s0,kmi,pip,pip},   {sm,s0,k0b,pip,pi0},
     {sm,sp,k0b,pip,pim},   {sm,sp,k0b,pi0,pi0},   {sm,sp,kmi,pip,pi0},
     {s0,s0,k0b,pip,pim},   {s0,s0,k0b,pi0,pi0},   {s0,s0,kmi,pip,pi0},
     {s0,sp,k0b,pim,pi0},   {s0,sp,kmi,pip,pim},   {s0,sp,kmi,pi0,pi0},
     {sp,sp,k0b,pim,pim},   {sp,sp,kmi,pim,pi0},   {lam,pro,k0b,k0b,pim},
     {lam,pro,k0b,kmi,pi0}, {lam,pro,kmi,kmi,pip}, {lam,neu,k0b,k0b,pi0},
     {lam,neu,k0b,kmi,pip}, {lam,lam,k0b,pip,pim}, {lam,lam,k0b,pi0,pi0},
     {lam,lam,kmi,pip,pi0}, {pro,pro,k0b,kmi,kmi}, {pro,neu,k0b,k0b,kmi},
     {neu,neu,k0b,k0b,k0b}};

  static const G4int omp6bfs[20][6] =
    {{om,pro,pip,pim,pi0,pi0},  {om,neu,pip,pip,pim,pi0}, 
     {xim,pro,k0b,pip,pim,pi0}, {xim,neu,kmi,pip,pip,pi0},
     {xi0,pro,kmi,pip,pim,pi0}, {xi0,pro,k0b,pip,pim,pim},
     {xi0,neu,k0b,pip,pim,pi0}, {sm,pro,k0b,kmi,pip,pi0},
     {s0,pro,k0b,kmi,pip,pim},  {s0,neu,k0b,kmi,pip,pi0},
     {sp,pro,k0b,kmi,pim,pi0},  {sp,neu,k0b,kmi,pip,pim},
     {s0,lam,k0b,pip,pim,pi0},  {sp,lam,kmi,pip,pim,pi0},
     {sm,sp,k0b,pip,pim,pi0},   {s0,sp,kmi,pip,pim,pi0},
     {lam,pro,k0b,kmi,pip,pim}, {lam,neu,k0b,kmi,pip,pi0},
     {pro,neu,k0b,k0b,kmi,pi0}, {pro,neu,k0b,kmi,kmi,pip}};

  static const G4int omp7bfs[34][7] =
    {{om,pro,pip,pip,pim,pim,pi0},  {om,neu,pip,pip,pim,pi0,pi0},
     {xim,pro,kmi,pip,pip,pim,pi0}, {xim,pro,k0b,pip,pim,pi0,pi0},
     {xim,neu,k0b,pip,pip,pim,pi0}, {xi0,pro,kmi,pip,pim,pi0,pi0},
     {xi0,pro,k0b,pip,pim,pim,pi0}, {xi0,neu,kmi,pip,pip,pim,pi0},
     {xi0,neu,k0b,pip,pim,pi0,pi0}, {xim,lam,pip,pip,pim,pi0,pi0},
     {xi0,lam,pip,pip,pim,pim,pi0}, {sm,pro,k0b,k0b,pip,pim,pi0}, 
     {sm,pro,k0b,kmi,pip,pip,pim},  {sm,pro,k0b,kmi,pip,pi0,pi0},
     {sm,neu,k0b,kmi,pip,pip,pi0},  {s0,pro,k0b,kmi,pip,pim,pi0},
     {s0,neu,k0b,k0b,pip,pim,pi0},  {s0,neu,k0b,kmi,pip,pip,pim},
     {s0,neu,k0b,kmi,pip,pi0,pi0},  {sp,pro,k0b,kmi,pip,pim,pim},
     {sp,pro,k0b,kmi,pim,pi0,pi0},  {sp,pro,kmi,kmi,pip,pim,pi0},
     {sp,neu,k0b,kmi,pip,pim,pi0},  {sm,lam,k0b,pip,pip,pim,pi0},
     {s0,lam,k0b,pip,pim,pi0,pi0},  {s0,lam,kmi,pip,pip,pim,pi0},
     {sp,lam,k0b,pip,pim,pim,pi0},  {sp,lam,kmi,pip,pim,pi0,pi0},
     {lam,pro,k0b,kmi,pip,pim,pi0}, {lam,neu,k0b,k0b,pip,pim,pi0},
     {lam,neu,k0b,kmi,pip,pip,pim}, {lam,neu,k0b,kmi,pip,pi0,pi0},
     {pro,neu,k0b,k0b,kmi,pip,pim}, {pro,neu,k0b,kmi,kmi,pip,pi0}}; 

  // Cross sections for Om- p -> 2-7 body final states
  // 
  // first index:    0-3: channels for mult = 2
  //                4-21: channels for mult = 3 
  //               22-76: channels for mult = 4
  //              77-152: channels for mult = 5
  //             153-172: channels for mult = 6
  //             173-206: channels for mult = 7
  //
  // second index: kinetic energy
  // 
  static const G4double ompCrossSections[207][31] = {

    // multiplicity 2 (4 channels)
    //
    // Om- p
    { 9.0, 5.0, 5.0, 5.0, 6.0, 6.9, 7.2, 6.7, 6.2, 5.8,
      5.1, 3.3, 2.8, 2.0, 1.7, 1.4, 1.0, 0.7, 0.5, 0.4,
      0.3, 0.2, 0.2, 0.1, 0.1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
 
    // Xi0 L
    { 5.0, 4.5, 4.0, 3.0, 2.2, 1.5, 1.1, 1.0, 0.9, 0.8,
      0.8, 0.7, 0.6, 0.7, 0.7, 0.7, 0.6, 0.6, 0.5, 0.5,
      0.4, 0.3, 0.2, 0.2, 0.1, 0.1, 0.1, 0.0, 0.0, 0.0, 0.0},
 
    // Xi0 S0
    { 5.0, 4.5, 3.5, 3.0, 2.2, 1.5, 1.1, 1.0, 0.9, 0.8,
      0.8, 0.7, 0.6, 0.7, 0.7, 0.7, 0.6, 0.6, 0.5, 0.5,
      0.4, 0.3, 0.2, 0.2, 0.1, 0.1, 0.1, 0.0, 0.0, 0.0, 0.0},

    // Xi- S+
    { 5.0, 4.5, 3.5, 3.0, 2.2, 1.5, 1.1, 1.0, 0.9, 0.8,
      0.8, 0.7, 0.6, 0.7, 0.7, 0.7, 0.6, 0.6, 0.5, 0.5,
      0.4, 0.3, 0.2, 0.2, 0.1, 0.1, 0.1, 0.0, 0.0, 0.0, 0.0},

    //  multiplicity 3 (18 channels) 2 OZI suppressed channels not included
    //
    // Om- p pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
      0.05, 0.16, 0.14, 0.11, 0.12, 0.13, 0.13, 0.13, 0.13, 0.13,
      0.13, 0.12, 0.12, 0.12, 0.12, 0.09, 0.07, 0.06, 0.04, 0.03, 0.02},
 
    // Om- n pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,  
      0.05, 0.16, 0.14, 0.11, 0.12, 0.13, 0.13, 0.13, 0.13, 0.13, 
      0.13, 0.12, 0.12, 0.12, 0.12, 0.09, 0.07, 0.06, 0.04, 0.03, 0.02},

    // Xi- p K0bar
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02,
      0.10, 0.20, 0.30, 0.30, 0.25, 0.20, 0.15, 0.10, 0.05, 0.02,
      0.01, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0, 0.0},

    // Xi0 p K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02,
      0.10, 0.20, 0.30, 0.30, 0.25, 0.20, 0.15, 0.10, 0.05, 0.02,
      0.01, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0, 0.0},

    // Xi0 n K0bar
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.02,
      0.10, 0.20, 0.30, 0.30, 0.25, 0.20, 0.15, 0.10, 0.05, 0.02,
      0.01, 0.0, 0.0, 0.0, 0.0, 0.0,  0.0,  0.0,  0.0,  0.0, 0.0},

    // Xi0 L pi0 (T=0)
    { 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15,
      0.15, 0.16, 0.14, 0.11, 0.15, 0.17, 0.20, 0.22, 0.28, 0.22,
      0.17, 0.15, 0.14, 0.13, 0.11, 0.10, 0.07, 0.06, 0.04, 0.03, 0.02},

    // Xi0 S0 pi0 (T=0.089)
    { 0.0,  0.0,  0.0,  0.02, 0.05, 0.10, 0.12, 0.15, 0.15, 0.15,
      0.15, 0.16, 0.14, 0.12, 0.11, 0.11, 0.10, 0.10, 0.10, 0.10,
      0.09, 0.08, 0.07, 0.06, 0.05, 0.04, 0.03, 0.02, 0.01, 0.0, 0.0},

    // Xi- L pi+ (T=0)
    { 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15,
      0.15, 0.16, 0.14, 0.12, 0.11, 0.11, 0.10, 0.10, 0.10, 0.10,
      0.09, 0.08, 0.07, 0.06, 0.05, 0.04, 0.03, 0.02, 0.01, 0.0, 0.0},

    // Xi- S0 pi+ (T=0.119)
    { 0.0,  0.0,  0.0,  0.02, 0.05, 0.10, 0.12, 0.15, 0.15, 0.15,
      0.15, 0.16, 0.14, 0.12, 0.11, 0.11, 0.10, 0.10, 0.10, 0.10,
      0.09, 0.08, 0.07, 0.06, 0.05, 0.04, 0.03, 0.02, 0.01, 0.0, 0.0},

    // Xi- S+ pi0 (T=0.098)
    { 0.0,  0.0,  0.0,  0.02, 0.05, 0.10, 0.12, 0.15, 0.15, 0.15,
      0.15, 0.16, 0.14, 0.12, 0.11, 0.11, 0.10, 0.10, 0.10, 0.10,
      0.09, 0.08, 0.07, 0.06, 0.05, 0.04, 0.03, 0.02, 0.01, 0.0, 0.0},

    // Xi0 S- pi+ (T=0.116)
    { 0.0,  0.0,  0.0,  0.02, 0.05, 0.10, 0.12, 0.15, 0.15, 0.15,
      0.15, 0.16, 0.14, 0.12, 0.11, 0.11, 0.10, 0.10, 0.10, 0.10,
      0.09, 0.08, 0.07, 0.06, 0.05, 0.04, 0.03, 0.02, 0.01, 0.0, 0.0},

    // Xi0 S+ pi- (T=0.094)
    { 0.0,  0.0,  0.0,  0.02, 0.05, 0.10, 0.12, 0.15, 0.15, 0.15,
      0.15, 0.16, 0.14, 0.12, 0.11, 0.11, 0.10, 0.10, 0.10, 0.10,
      0.09, 0.08, 0.07, 0.06, 0.05, 0.04, 0.03, 0.02, 0.01, 0.0, 0.0},

    // S- S+ K0bar (T=0.801)
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.05, 0.10, 0.16, 0.16, 0.16, 0.16, 0.16, 0.16, 0.16,
      0.15, 0.14, 0.12, 0.11, 0.10, 0.08, 0.07, 0.06, 0.05, 0.04, 0.03},

    // S0 S0 K0bar (T=0.795)
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.02, 0.05, 0.08, 0.08, 0.09, 0.10, 0.10, 0.09, 0.08,
      0.07, 0.07, 0.06, 0.05, 0.05, 0.04, 0.03, 0.03, 0.02, 0.02, 0.01},

    // S0 S+ K- (T=0.773)
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.05, 0.10, 0.16, 0.16, 0.16, 0.16, 0.16, 0.16, 0.16,
      0.15, 0.14, 0.12, 0.11, 0.10, 0.08, 0.07, 0.06, 0.05, 0.04, 0.03},

    // S0 L K0bar (T=0.564)
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.05, 0.10, 0.16, 0.16, 0.16, 0.16, 0.16, 0.16, 0.16,
      0.15, 0.14, 0.12, 0.11, 0.10, 0.08, 0.07, 0.06, 0.05, 0.04, 0.03},

    // S+ L K- (T=0.544)
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.05, 0.10, 0.16, 0.16, 0.16, 0.16, 0.16, 0.16, 0.16,
      0.15, 0.14, 0.12, 0.11, 0.10, 0.08, 0.07, 0.06, 0.05, 0.04, 0.03},

    // L L K0bar (T=0.340)
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
      0.2,  0.05, 0.10, 0.16, 0.16, 0.16, 0.16, 0.16, 0.16, 0.16,
      0.15, 0.14, 0.12, 0.11, 0.10, 0.08, 0.07, 0.06, 0.05, 0.04, 0.03},

    // Xi- Xi0 K+ (T=1.589)  negligible (OZI suppressed)
    // Xi0 Xi0 K0 (T=1.583)  negligible (OZI suppressed)

    //  multiplicity 4 (55 channels)  6 OZI suppressed channels not included
    //
    // Om- p pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.01, 0.02, 0.03, 0.04, 0.05, 0.07, 0.10, 0.11, 0.11,
      0.11, 0.11, 0.11, 0.10, 0.10, 0.10, 0.09, 0.09, 0.08, 0.07, 0.07},

    // Om- p pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.03, 0.05, 0.06, 0.06,
      0.06, 0.06, 0.06, 0.05, 0.05, 0.05, 0.04, 0.04, 0.04, 0.03, 0.03},

    // Om- n pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.01, 0.02, 0.03, 0.04, 0.05, 0.07, 0.10, 0.11, 0.11,
      0.11, 0.11, 0.11, 0.10, 0.10, 0.10, 0.09, 0.09, 0.08, 0.07, 0.05},

    // Om- p K+ K-    negligible (OZI suppressed) 
    // Om- p K0 K0b   negligible (OZI suppressed)
    // Om- n K+ K0b   negligible (OZI suppressed)
 
    // Xi- p K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.03, 0.05, 0.07, 0.09, 0.10, 0.10, 0.10,
      0.10, 0.10, 0.10, 0.10, 0.10, 0.10, 0.09, 0.09, 0.08, 0.08, 0.07},

    // Xi- p K0b pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.03, 0.05, 0.07, 0.09, 0.10, 0.10, 0.10,
      0.10, 0.10, 0.10, 0.10, 0.10, 0.10, 0.09, 0.09, 0.08, 0.08, 0.07},

    // Xi- n K0b pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.03, 0.05, 0.07, 0.09, 0.10, 0.10, 0.10,
      0.10, 0.10, 0.10, 0.10, 0.10, 0.10, 0.09, 0.09, 0.08, 0.08, 0.07},

    // Xi0 p K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.03, 0.05, 0.07, 0.09, 0.10, 0.10, 0.10,
      0.10, 0.10, 0.10, 0.10, 0.10, 0.10, 0.09, 0.09, 0.08, 0.08, 0.07},

    // Xi0 p K0b pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.03, 0.05, 0.07, 0.09, 0.10, 0.10, 0.10,
      0.10, 0.10, 0.10, 0.10, 0.10, 0.10, 0.09, 0.09, 0.08, 0.08, 0.07},

    // Xi0 n K0b pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.03, 0.05, 0.07, 0.09, 0.10, 0.10, 0.10,
      0.10, 0.10, 0.10, 0.10, 0.10, 0.10, 0.09, 0.09, 0.08, 0.08, 0.07},

    // Xi0 n K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.03, 0.05, 0.07, 0.09, 0.10, 0.10, 0.10,
      0.10, 0.10, 0.10, 0.10, 0.10, 0.10, 0.09, 0.09, 0.08, 0.08, 0.07},

    // Xi- L pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
      0.02, 0.03, 0.04, 0.06, 0.08, 0.10, 0.11, 0.12, 0.12, 0.12,
      0.12, 0.11, 0.11, 0.10, 0.10, 0.09, 0.09, 0.08, 0.08, 0.07, 0.07},

    // Xi0 L pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
      0.02, 0.03, 0.04, 0.06, 0.08, 0.10, 0.11, 0.12, 0.12, 0.12,
      0.12, 0.11, 0.11, 0.10, 0.10, 0.09, 0.09, 0.08, 0.08, 0.07, 0.07},

    // Xi0 L pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
      0.02, 0.02, 0.03, 0.04, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06,
      0.06, 0.05, 0.05, 0.05, 0.05, 0.04, 0.04, 0.04, 0.04, 0.03, 0.03},

    // Xi- L K+ K0b
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.04,
      0.04, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.02},

    // Xi0 L K+ K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.04,
      0.04, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.02},

    // Xi0 L K0 K0b
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.04,
      0.04, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.02},

    // Xi- S0 pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02,
      0.03, 0.04, 0.05, 0.07, 0.10, 0.10, 0.10, 0.09, 0.09, 0.08,
      0.08, 0.07, 0.07, 0.06, 0.06, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // Xi0 S0 pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02,
      0.03, 0.04, 0.05, 0.07, 0.10, 0.10, 0.10, 0.09, 0.09, 0.08,
      0.08, 0.07, 0.07, 0.06, 0.06, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // Xi0 S0 pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
      0.02, 0.05, 0.06, 0.06, 0.05, 0.05, 0.05, 0.04, 0.04, 0.04,
      0.04, 0.03, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.02},

    // Xi- S0 K+ K0b
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0 , 0.0,  0.01, 0.02, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01},

    // Xi0 S0 K+ K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0 , 0.0,  0.01, 0.02, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01},

    // Xi0 S0 K0 K0b
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0 , 0.0,  0.01, 0.02, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01},

    // Xi- S+ pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02,
      0.03, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05,
      0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // Xi- S+ pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
      0.02, 0.02, 0.02, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03,
      0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02},

    // Xi0 S+ pi- pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02,
      0.03, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05,
      0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // Xi- S+ K+ K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01},

    // Xi- S+ K0 K0b
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01},

    // Xi0 S+ K- K0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01},

    // Xi- S- pi+ pi+ 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01,
      0.02, 0.03, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05,
      0.05, 0.05, 0.05, 0.05, 0.05, 0.04, 0.04, 0.04, 0.04, 0.04, 0.03},

    // Xi0 S- pi+ pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02,
      0.05, 0.07, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09, 0.09,
      0.08, 0.08, 0.07, 0.07, 0.06, 0.05, 0.05, 0.05, 0.05, 0.05, 0.04},

    // Xi0 S- K+ K0b
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01},

    // Xi- Xi0 K+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01},

    // Xi- Xi0 K0 pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01},

    // Xi- Xi- K+ pi+  negligible (OZI suppressed)
    // Xi0 Xi0 K+ pi-  negligible (OZI suppressed)
    // Xi0 Xi0 K0 pi0  negligible (OZI suppressed)

    // S- p K0b K0b 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.04, 0.04, 0.04,
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.03, 0.03},

    // S0 p K- K0b 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.05, 0.08, 0.08, 0.08, 0.08, 0.08,
      0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.07, 0.05},

    // S0 n K0b K0b 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.04, 0.05, 0.06, 0.07, 0.07,
      0.08, 0.08, 0.08, 0.08, 0.07, 0.06, 0.06, 0.06, 0.05, 0.04, 0.04},

    // S+ p K- K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.04, 0.04, 0.04,
      0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.03, 0.03},

    // S+ n K- K0b 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.05, 0.08, 0.08, 0.08, 0.08, 0.08,
      0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.07, 0.05},

    // S- L K0b pi+ 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.02, 0.05, 0.08, 0.08, 0.08, 0.08, 0.08,
      0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.08, 0.07, 0.05},

    // S- S0 K0b pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.03, 0.05, 0.05, 0.06, 0.06, 0.06,
      0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S- S+ K- pi+ 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.03, 0.05, 0.05, 0.06, 0.06, 0.06,
      0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S- S+ K0b pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.03, 0.05, 0.05, 0.06, 0.06, 0.06,
      0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S0 L K- pi+ 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.03, 0.05, 0.05, 0.06, 0.06, 0.06,
      0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S0 L K0b pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.03, 0.05, 0.05, 0.06, 0.06, 0.06,
      0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S0 S+ K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.03, 0.05, 0.05, 0.06, 0.06, 0.06,
      0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S0 S+ K0b pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.03, 0.05, 0.05, 0.06, 0.06, 0.06,
      0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S0 S0 K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.05, 0.06, 0.06, 0.06,
      0.06, 0.06, 0.07, 0.07, 0.07, 0.07, 0.08, 0.08, 0.08, 0.08, 0.08},

    // S0 S0 K0b pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.05, 0.06, 0.06, 0.06,
      0.06, 0.06, 0.07, 0.07, 0.07, 0.07, 0.08, 0.08, 0.08, 0.08, 0.08},

    // S+ L K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.02, 0.05, 0.07, 0.10, 0.09, 0.09, 0.08,
      0.08, 0.07, 0.07, 0.06, 0.06, 0.06, 0.06, 0.05, 0.05, 0.05, 0.05},

    // S+ L K0b pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.02, 0.05, 0.07, 0.10, 0.09, 0.09, 0.08,
      0.08, 0.07, 0.07, 0.06, 0.06, 0.06, 0.06, 0.05, 0.05, 0.05, 0.05},

    // S+ S+ K- pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.05, 0.06, 0.06, 0.06,
      0.06, 0.06, 0.07, 0.07, 0.07, 0.07, 0.08, 0.08, 0.08, 0.08, 0.08},

    // L p K- K0b
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.02, 0.05, 0.10, 0.12, 0.12, 0.12, 0.12,
      0.12, 0.12, 0.12, 0.12, 0.12, 0.12, 0.12, 0.12, 0.12, 0.12, 0.12},

    // L n K0b K0b
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.05, 0.06, 0.06, 0.06, 0.06,
      0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // L L K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.05, 0.06, 0.07, 0.08, 0.10,
      0.11, 0.12, 0.12, 0.11, 0.10, 0.09, 0.09, 0.08, 0.08, 0.07, 0.07},

    // L L K0b pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.02, 0.05, 0.06, 0.07, 0.08, 0.10,
      0.11, 0.12, 0.12, 0.11, 0.10, 0.09, 0.09, 0.08, 0.08, 0.07, 0.07},

    // multiplicity 5 (76 channels)  62 OZI suppressed channels not included
    //
    // Om- p pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.05, 0.06, 0.07, 0.08, 0.08, 0.08, 0.07, 0.07, 0.06, 0.05},

    // Om- p pi0 pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01,
      0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01},

    // Om- n pi+ pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
      0.03, 0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.03, 0.03},

    // Om- n pi+ pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02,
      0.03, 0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04, 0.03, 0.03},

    // Om- p K+ K- pi0     negligible (OZI suppressed)
    // Om- p K0 K0bar pi0  negligible (OZI suppressed)
    // Om- p K0 K- pi+     negligible (OZI suppressed)
    // Om- p K+ K0bar pi-  negligible (OZI suppressed)
    // Om- n K+ K- pi+     negligible (OZI suppressed)
    // Om- n K0 K0b pi+    negligible (OZI suppressed)
    // Om- n K+ K0b pi0    negligible (OZI suppressed)

    // Xi- p  K- pi+ pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.05, 0.06, 0.07, 0.08, 0.08, 0.08, 0.07, 0.07, 0.06, 0.05},

    // Xi- p K0bar pi+ pi- 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.05, 0.06, 0.07, 0.08, 0.08, 0.08, 0.07, 0.07, 0.06, 0.05},

    // Xi- p K0bar pi0 pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.04, 0.05, 0.05, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04},

    // Xi- n K- pi+ pi+ 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.04, 0.05, 0.05, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04},

    // Xi- n K0bar pi+ pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.05, 0.06, 0.07, 0.08, 0.08, 0.08, 0.07, 0.07, 0.06, 0.05},

    // Xi0 p K- pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.05, 0.06, 0.07, 0.08, 0.08, 0.08, 0.07, 0.07, 0.06, 0.05},

    // Xi0 p K- pi0 pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.04, 0.05, 0.05, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04},

    // Xi0 p K0bar pi- pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.05, 0.06, 0.07, 0.08, 0.08, 0.08, 0.07, 0.07, 0.06, 0.05},

    // Xi0 n K0bar pi+ pi- 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.05, 0.06, 0.07, 0.08, 0.08, 0.08, 0.07, 0.07, 0.06, 0.05},

    // Xi0 n K0bar pi0 pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.04, 0.05, 0.05, 0.04, 0.04, 0.04, 0.04, 0.04, 0.04},

    // Xi0 n K- pi+ pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.05, 0.06, 0.07, 0.08, 0.08, 0.08, 0.07, 0.07, 0.06, 0.05},

    // Xi- p K- K+ K0bar     negligible (OZI suppressed)
    // Xi- p K0bar K0 K0bar  negligible (OZI suppressed)
    // Xi- n K+ K0bar K0bar  negligible (OZI suppressed)
    // Xi0 p K- K0 K0bar     negligible (OZI suppressed)
    // Xi0 p K- K+ K-        negligible (OZI suppressed)
    // Xi0 n K+ K- K0bar     negligible (OZI suppressed)
    // Xi0 n K+ K0bar K0bar  negligible (OZI suppressed)

    // Xi- L pi+ pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.05, 0.06, 0.07, 0.08, 0.08, 0.08, 0.07, 0.07, 0.06, 0.05},

    // Xi- L pi+ pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.05, 0.06, 0.07, 0.08, 0.08, 0.08, 0.07, 0.07, 0.06, 0.05},

    // Xi0 L pi+ pi- pi0  (T=0.683) 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.05, 0.06, 0.07, 0.08, 0.08, 0.08, 0.07, 0.07, 0.06, 0.05},

    // Xi0 L pi0 pi0 pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03,
      0.03, 0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.03, 0.03, 0.03, 0.03},

    // Xi- L K+ K- pi+      negligible (OZI suppressed)
    // Xi- L K0 K0bar pi+   negligible (OZI suppressed)
    // Xi- L K+ K0bar pi0   negligible (OZI suppressed)
    // Xi0 L K+ K- pi0      negligible (OZI suppressed)
    // Xi0 L K0 K0bar pi0   negligible (OZI suppressed)
    // Xi0 L K0 K- pi+      negligible (OZI suppressed)
    // Xi0 L K+ K0bar pi-   negligible (OZI suppressed)

    // Xi- S- pi+ pi+ pi0 
     { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.04, 0.04,
       0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // Xi- S0 pi+ pi+ pi-
     { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.04, 0.04,
       0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // Xi- S0 pi+ pi0 pi0 
     { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.04, 0.04,
       0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // Xi- S+ pi+ pi- pi0 
     { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.04, 0.04,
       0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // Xi- S+ pi0 pi0 pi0
     { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.03,
       0.03, 0.03, 0.03, 0.04, 0.04, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // Xi0 S- pi+ pi+ pi-
     { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.04, 0.04,
       0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // Xi0 S- pi+ pi0 pi0
     { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.04, 0.04,
       0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // Xi0 S0 pi+ pi- pi0  (T= 0.916)
     { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.04, 0.04,
       0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // Xi0 S0 pi0 pi0 pi0
     { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.03,
       0.03, 0.03, 0.03, 0.04, 0.04, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // Xi0 S+ pi+ pi- pi-
     { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.04, 0.04,
       0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // Xi0 S+ pi- pi0 pi0 
     { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
       0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.03, 0.04, 0.04,
       0.05, 0.05, 0.05, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06, 0.06},

    // Xi- S- K+ K0bar pi+  negligible (OZI suppressed)
    // Xi- S0 K+ K- pi+     negligible (OZI suppressed)
    // Xi- S0 K0 K0bar pi+  negligible (OZI suppressed)
    // Xi- S0 K+ K0bar pi0  negligible (OZI suppressed)
    // Xi- S+ K+ K- pi0     negligible (OZI suppressed)
    // Xi- S+ K0 K0bar pi0  negligible (OZI suppressed)
    // Xi- S+ K0 K- pi+     negligible (OZI suppressed)
    // Xi- S+ K+ K0bar pi-  negligible (OZI suppressed)

    // Xi0 S- K0 K0bar pi+  negligible (OZI suppressed)
    // Xi0 S- K+ K- pi+     negligible (OZI suppressed)
    // Xi0 S- K+ K0bar pi0  negligible (OZI suppressed)
    // Xi0 S0 K0 K0bar pi0  negligible (OZI suppressed)
    // Xi0 S0 K+ K- pi0     negligible (OZI suppressed)
    // Xi0 S0 K0 K- pi+     negligible (OZI suppressed)
    // Xi0 S0 K+ K0bar pi-  negligible (OZI suppressed)
    // Xi0 S+ K0 K0bar pi-  negligible (OZI suppressed)
    // Xi0 S+ K+ K- pi-     negligible (OZI suppressed)
    // Xi0 S+ K0 K- pi0     negligible (OZI suppressed)

    // Xi- Xi- K+ pi+ pi0   negligible (OZI suppressed)
    // Xi- Xi- K0 pi+ pi+   negligible (OZI suppressed)
    // Xi- Xi0 K+ pi+ pi+   negligible (OZI suppressed)
    // Xi- Xi0 K+ pi0 pi0   negligible (OZI suppressed)
    // Xi- Xi0 K0 pi+ pi0   negligible (OZI suppressed)
    // Xi0 Xi0 K0 pi+ pi-   negligible (OZI suppressed)
    // Xi0 Xi0 K0 pi0 pi0   negligible (OZI suppressed)
    // Xi0 Xi0 K+ pi- pi0   negligible (OZI suppressed)

    // S- p K0b K0b pi0 (T = 2.053)
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S- p K0b K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S- n K0b K0b pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // S0 p K0b K- pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S0 p K- K- pi+ 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // S0 p K0b K0b pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // S0 n K0b K0b pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // S0 n K0b K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S+ p K- K- pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // S+ p K0b K- pi- 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S+ n K0b K0b pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // S+ n K0b K- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S+ n K- K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // S- L K0b pi+ pi0 (T = 1.442)
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.05,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S- L K- pi+ pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // S0 L K0b pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S0 L K0b pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // S0 L K- pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S+ L K0b pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // S+ L K- pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},
 
    // S+ L K- pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // S- L K0b K+ K0b   negligible (OZI suppressed)
    // S0 L K0b K+ K-    negligible (OZI suppressed)
    // S0 L K0b K0 K0b   negligible (OZI suppressed)
    // S+ L K0b K0 K-    negligible (OZI suppressed)
    // S+ L K- K+ K-     negligible (OZI suppressed)

    // S- S- K0b pi+ pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},

    // S- S0 K- pi+ pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.03,
      0.03, 0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.03, 0.03, 0.03, 0.02},

    // S- S0 K0b pi+ pi0 (T = 1.695)
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // S- S+ K0b pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03,
      0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05, 0.05},

    // S- S+ K0b pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.03,
      0.03, 0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.03, 0.03, 0.03, 0.02},

    // S- S+ K- pi+ pi0 
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.03,
      0.03, 0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.03, 0.03, 0.03, 0.02},

    // S0 S0 K0b pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.03,
      0.03, 0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.03, 0.03, 0.03, 0.02},

    // S0 S0 K0b pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},

    // S0 S0 K- pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.03,
      0.03, 0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.03, 0.03, 0.03, 0.02},

    // S0 S+ K0b pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.06, 0.06, 0.06, 0.06, 0.06, 0.05},

    // S0 S+ K- pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.06, 0.06, 0.06, 0.06, 0.06, 0.05},

    // S0 S+ K- pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.03,
      0.03, 0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.03, 0.03, 0.03, 0.02},

    // S+ S+ K0b pi- pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},

    // S+ S+ K- pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.03,
      0.03, 0.03, 0.04, 0.04, 0.04, 0.04, 0.04, 0.03, 0.03, 0.03, 0.02},

    // S- S0 K0b K+ K0b   negligible  (OZI suppressed)
    // S- S+ K0b K0 K0b   negligible  (OZI suppressed)
    // S- S+ K0b K+ K-    negligible  (OZI suppressed)
    // S0 S0 K0b K0 K0b   negligible  (OZI suppressed)
    // S0 S0 K0b K+ K-    negligible  (OZI suppressed)
    // S0 S+ K- K+ K-     negligible  (OZI suppressed)
    // S0 S+ K- K0 K0b    negligible  (OZI suppressed)
    // S+ S+ K- K0 K-     negligible  (OZI suppressed)

    // L p K0b K0b pi- (T = 1.790)
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // L p K0b K- pi0  
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // L p K- K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // L n K0b K0b pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // L n K0b K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.03, 0.04, 0.04,
      0.05, 0.06, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07, 0.07},

    // L L K0b pi+ pi- (T = 1.194)
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.03,
      0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.02},

    // L L K0b pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01},

    // L L K- pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.02, 0.02, 0.03,
      0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.02},

    // L L K0b K+ K-   negligible (OZI suppressed)
    // L L K0b K0 K0b  negligible (OZI suppressed)

    // p p K0b K- K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.02, 0.03,
      0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03},

    // p n K0b K0b K-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.02, 0.03, 0.04,
      0.05, 0.06, 0.06, 0.06, 0.06, 0.6,  0.06, 0.06, 0.06, 0.06, 0.06},

    // n n K0b K0b K0b (T = 2.430)
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02,
      0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02},

    // multiplicity 6 (20 channels)
    //
    // Om- p pi+ pi- pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.03, 0.04, 0.04, 0.05, 0.06, 0.07, 0.06, 0.06},

    // Om- n pi+ pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.03, 0.04, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09},

    // Xi- p K0b pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.08, 0.10, 0.11, 0.11, 0.11},

    // Xi- n K- pi+ pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05},

    // Xi0 p K- pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.04, 0.05, 0.07, 0.09, 0.11, 0.11, 0.11},

    // Xi0 p K0b pi+ pi- pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05},

    // Xi0 n K0b pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.08, 0.10, 0.11, 0.11, 0.11},

    // S- p K0b K- pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.08, 0.10, 0.11, 0.11, 0.11},

    // S0 p K0b K- pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.08, 0.10, 0.11, 0.11, 0.11},

    // S0 n K0b K- pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.08, 0.10, 0.11, 0.11, 0.11},

    // S+ p K0b K- pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.08, 0.10, 0.11, 0.11, 0.11},

    // S+ n K0b K- pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.08, 0.10, 0.11, 0.11, 0.11},

    // S0 L K0b pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.08, 0.10, 0.11, 0.11, 0.11},

    // S+ L K- pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.08, 0.10, 0.11, 0.11, 0.11},

    // S- S+ K0b pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05},

    // S0 S+ K- pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05},

    // L p K0b K- pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05},

    // L n K0b K- pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.04, 0.04, 0.05, 0.05, 0.05, 0.05, 0.05},

    // p n K0b K0b K- pi0 (T= 2.904)  
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.05, 0.05, 0.06, 0.07, 0.07, 0.07, 0.07},

    // p n K0b K- K- pi+
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.01, 0.02, 0.03, 0.04, 0.05, 0.05, 0.06, 0.07, 0.07, 0.07, 0.07},

    // multiplicity 7 (34 channels)
    //
    // Om- p pi+ pi+ pi- pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // Om- n pi+ pi+ pi- pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // Xi- p K- pi+ pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // Xi- p K0b pi+ pi- pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // Xi- n K0b pi+ pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // Xi0 p K- pi+ pi- pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // Xi0 p K0b pi+ pi- pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // Xi0 n K- pi+ pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // Xi0 n K0b pi+ pi- pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // Xi- L pi+ pi+ pi- pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03, 0.04, 0.04, 0.05, 0.05},

    // Xi0 L pi+ pi+ pi- pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03, 0.04, 0.04, 0.05, 0.05},

    // S- p K0b K0b pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S- p K0b K- pi+ pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S- p K0b K- pi+ pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S- n K0b K- pi+ pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S0 p K0b K- pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03, 0.04, 0.04, 0.05, 0.05},

    // S0 n K0b K0b pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S0 n K0b K- pi+ pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S0 n K0b K- pi+ pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S+ p K0b K- pi+ pi- pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S+ p K0b K- pi- pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S+ p K- K- pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02},

    // S+ n K0b K- pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03, 0.04, 0.04, 0.05, 0.05},

    // S- L K0b pi+ pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.01},

    // S0 L K0b pi+ pi- pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.01},

    // S0 L K- pi+ pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.01},

    // S+ L K0b pi+ pi- pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.01},

    // S+ L K- pi+ pi- pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.01},

    // L p K0b K- pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.01, 0.02, 0.02, 0.03, 0.03, 0.04, 0.04, 0.05, 0.05},

    // L n K0b K0b pi+ pi- pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02},

    // L n K0b K- pi+ pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02},

    // L n K0b K- pi+ pi0 pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02},

    // p n K0b K0b K- pi+ pi-
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02},

    // p n K0b K- K- pi+ pi0
    { 0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,  0.0,
      0.0,  0.0,  0.0,  0.01, 0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02}};

}

const G4CascadeOmegaMinusPChannelData::data_t
G4CascadeOmegaMinusPChannelData::data(omp2bfs, omp3bfs, omp4bfs,
                                      omp5bfs, omp6bfs, omp7bfs,
                                      ompCrossSections, om*pro, "OmegaMinusP");
