//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;


import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
//import com.sun.java.swing.preview.*;


//import com.sun.java.swing.preview.JColorChooser;


import javax.swing.JColorChooser;

class VisAtbDialog extends JDialog implements ActionListener {
  boolean isCanceled;
  VisMethodPanel atb[];
  private JButton ok, cancel;
  JTextField nameField;
  JColorChooser colorChooser;
  private VolumesFrame parent;
// MOMO
    private JFrame frame1;


 public VisAtbDialog(VolumesFrame parent) {
  //super(parent, "VisAttribute", true);
  
    this.parent = parent;
    atb = new VisMethodPanel[5];

    getContentPane().setLayout(new BorderLayout(3,0));
    getContentPane().add("East", colorChooser = new JColorChooser());

    JPanel p1,p2,p3,c;
    p1 = new JPanel();
	    p1.setLayout(new BorderLayout(1,8));
	    p1.add("West",new JLabel("Name"));
	    p1.add("Center", nameField = new JTextField());

    JComboBox lineStyle = new JComboBox();
	    lineStyle.addItem("unbroken");
	    lineStyle.addItem("dashed");
	    lineStyle.addItem("dotted");

    c = new JPanel();
	    c.setLayout(new BoxLayout(c, BoxLayout.Y_AXIS));
	    c.setBorder(new LineBorder(Color.darkGray, 1));
	    c.add(atb[0] = new VisMethodPanel(VisAtbItem.atbMethodName[0], new BooleanCombo()));
	    c.add(atb[1] = new VisMethodPanel(VisAtbItem.atbMethodName[1], lineStyle));
	    c.add(atb[2] = new VisMethodPanel(VisAtbItem.atbMethodName[2], new JTextField() ));
	    c.add(atb[3] = new VisMethodPanel(VisAtbItem.atbMethodName[3], new BooleanCombo()));
	    c.add(atb[4] = new VisMethodPanel(VisAtbItem.atbMethodName[4], new BooleanCombo()));

    p1.add("South", c);

    p2 = new JPanel(new BorderLayout());
	    p2.add("North", p1);


    p3 = new JPanel(new BorderLayout(3,0));
	    p3.add("Center", ok = new JButton("OK"));
	    p3.add("East", cancel = new JButton("Cancel"));

    ok.addActionListener(this);
    cancel.addActionListener(this);

    p2.add("South", p3);
    getContentPane().add("Center", p2);

    pack();
    setResizable(false);
  }

  VisAtbItem getNewAtb(){

    //nameField.setText("");
    setVisible(true);
    if (isCanceled) return null;
    return getValues();
  }

  VisAtbItem getChangedAtb(VisAtbItem visItem){
//MOMO
//	this.visItem = visItem;
    setValues(visItem);
    setVisible(true);
    if (isCanceled) return null;
    return getValues();
  }

  private void setValues(VisAtbItem visItem){

    colorChooser.setColor(visItem.color);
    nameField.setText(visItem.name);
    for (int i=0; i<5; i++){
      atb[i].setAtbState(visItem.atbsIsValid[i]);
      atb[i].setValues(visItem.atbsValue[i]);
    }
  }

  private VisAtbItem getValues(){

    VisAtbItem newVisItem = new VisAtbItem();
    newVisItem.name = nameField.getText().trim();
    if (newVisItem.name.equals("")) return null;
    newVisItem.color = colorChooser.getColor();

    for (int i=0; i<5; i++){
      newVisItem.atbsIsValid[i] = atb[i].getAtbState();
      newVisItem.atbsValue[i] = atb[i].toString();
    }
    return newVisItem;
  }

  public void actionPerformed(ActionEvent ae){

//MOMO
	Object ob = ae.getSource();
	if (ob == cancel) {
	    isCanceled = (ob == cancel);
	    setVisible(false);
	    parent.visPanel.visCloseAct();
	} else if (ob == ok) {
	  isCanceled = !(ob == ok);
	    // System.out.println("TESTING VIS");
	  //System.out.println(getValues());  //MOMO DEBUG
	  //if (String.valueOf(getValues())) == null){
	  if ( getValues() == null){
              JOptionPane opane = new JOptionPane();

	      opane.showMessageDialog(this,
					    "No given name for color",
					    "Warning Dialog",
 					    JOptionPane.WARNING_MESSAGE);
              JDialog dialog = opane.createDialog(this, "Warning Dialog");
              ///////////////////////////
              try{
                 Class targetClass = dialog.getClass();
                 Class[] parameters = new Class[]{boolean.class};
                 java.lang.reflect.Method method
                   = targetClass.getDeclaredMethod("setAlwaysOnTop",parameters);
                  Object targetInstance = targetClass.newInstance();
                  Object[] params = new Object[]{new boolean[]{true}};
                  if(System.getProperty("java.version").equals("1.5.0")){
                    method.invoke(targetInstance, params);
                  }
                }catch(Exception e){ }
              ///////////////////////////
	      return;
	  }
	  parent.visPanel.listModel.addElement(getNewAtb());
         nameField.setText("");
	}
  }
}

class VisMethodPanel extends JPanel implements ItemListener {

  private JCheckBox checkbox;
  private JComponent compo;
  VisMethodPanel(String label, JComponent compo){

    this.compo = compo;
    setLayout(new BorderLayout());
    add("West", checkbox = new JCheckBox(label));
    add("Center", compo);
    compo.setEnabled(false);
    checkbox.addItemListener(this);
  }

  void setValues(String label){
    if (compo instanceof JTextField){
      ((JTextField)compo).setText(label);
      return;
    }

    if (compo instanceof JComboBox){
      ((JComboBox)compo).setSelectedItem(label);
      return;
    }
  }

  void setAtbState(boolean state){
    checkbox.setSelected(state);
  }

  boolean getAtbState(){
    return checkbox.isSelected();
  }

  public String toString(){
    if (!compo.isEnabled()) return null;
    if (compo instanceof JTextField){
      return ((JTextField)compo).getText();
    }

    if (compo instanceof JComboBox){
      return (String)((JComboBox)compo).getSelectedItem();
    }
    return null;
  }


  public void itemStateChanged(ItemEvent i){
    compo.setEnabled(i.getStateChange() == ItemEvent.SELECTED);
  }
}

class BooleanCombo extends JComboBox {

  BooleanCombo(){
    addItem("true");
    addItem("false");
  }
}























