//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
// MODULE:              G4NuclideTable2.cc
//
// Date:                10/10/13
// Author:              T.Koi
//
// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//
// HISTORY

#include "G4NuclideTable.hh"

const G4double G4NuclideTable::groundStateTable[G4NuclideTable::nEntries_ground_state][6] =
{
{    1,    1,               0,              -1,    1,  1.410387912255e-26}, //     1H
{    1,    2,               0,              -1,    2,    4.3300630615e-27}, //     2H
{    1,    3,               0,    5.609054e+17,    1,        1.504376e-26}, //     3H
{    1,    6,               0,    4.109084e-13,    0,                   0}, //     6H
{    2,    3,               0,              -1,    1,  -1.07445054925e-26}, //    3HE
{    2,    4,               0,              -1,    0,                   0}, //    4HE
{    2,    5,               0,    1.014575e-12,    0,                   0}, //    5HE
{    2,    6,               0,    1.163822e+09,    0,                   0}, //    6HE
{    2,    7,               0,    4.382908e-12,    0,                   0}, //    7HE
{    2,    8,               0,     1.71825e+08,    0,                   0}, //    8HE
{    2,   10,               0,    2.191454e-12,    0,                   0}, //   10HE
{    3,    5,               0,    5.345041e-13,    0,                   0}, //    5LI
{    3,    6,               0,              -1,    2,    4.1513861835e-27}, //    6LI
{    3,    7,               0,              -1,    3,     1.644495534e-26}, //    7LI
{    3,    8,               0,     1.21172e+09,    4,        8.350478e-27}, //    8LI
{    3,    9,               0,    2.572325e+08,    3,        1.736745e-26}, //    9LI
{    3,   11,               0,    1.262358e+07,    3,        1.851987e-26}, //   11LI
{    4,    6,               0,    7.146101e-12,    0,                   0}, //    6BE
{    4,    7,               0,      6.6338e+15,    0,                   0}, //    7BE
{    4,    8,               0,    1.180327e-07,    0,                   0}, //    8BE
{    4,    9,               0,              -1,    3,        -5.94789e-27}, //    9BE
{    4,   10,               0,     6.87473e+22,    0,                   0}, //   10BE
{    4,   11,               0,    1.985148e+10,    1,        -8.49107e-27}, //   11BE
{    4,   12,               0,     3.07294e+07,    0,                   0}, //   12BE
{    4,   13,               0,    3.895277e-12,    0,                   0}, //   13BE
{    4,   14,               0,         6275723,    0,                   0}, //   14BE
{    5,    7,               0,    4.695972e-13,    0,                   0}, //     7B
{    5,    8,               0,    1.110875e+09,    4,        5.229275e-27}, //     8B
{    5,    9,               0,     1.21749e-09,    0,                   0}, //     9B
{    5,   10,               0,              -1,    6,     9.093256139e-27}, //    10B
{    5,   11,               0,              -1,    3,    1.3577676945e-26}, //    11B
{    5,   12,               0,    2.914244e+07,    2,        5.065453e-27}, //    12B
{    5,   13,               0,    2.500191e+07,    3,        1.604789e-26}, //    13B
{    5,   14,               0,    1.803369e+07,    0,                   0}, //    14B
{    5,   15,               0,    1.432596e+07,    0,                   0}, //    15B
{    5,   16,               0,       0.2741121,    0,                   0}, //    16B
{    5,   17,               0,         7328891,    0,                   0}, //    17B
{    6,    8,               0,    2.858412e-12,    0,                   0}, //     8C
{    6,    9,               0,    1.825009e+08,    0,                   0}, //     9C
{    6,   10,               0,    2.782959e+10,    0,                   0}, //    10C
{    6,   11,               0,    1.762685e+12,    3,         -4.8682e-27}, //    11C
{    6,   12,               0,              -1,    0,                   0}, //    12C
{    6,   13,               0,              -1,    1,      3.54717959e-27}, //    13C
{    6,   14,               0,     2.59512e+20,    0,                   0}, //    14C
{    6,   15,               0,     3.53316e+09,    1,           6.666e-27}, //    15C
{    6,   16,               0,    1.077693e+09,    0,                   0}, //    16C
{    6,   17,               0,    2.784401e+08,    0,                   0}, //    17C
{    6,   18,               0,    1.327279e+08,    0,                   0}, //    18C
{    6,   20,               0,    2.019773e+07,    0,                   0}, //    20C
{    6,   22,               0,         8800440,    0,                   0}, //    22C
{    7,   11,               0,    7.920973e-13,    0,                   0}, //    11N
{    7,   12,               0,    1.586965e+07,    2,        2.309365e-27}, //    12N
{    7,   13,               0,    8.625874e+11,    1,         1.62711e-27}, //    13N
{    7,   14,               0,              -1,    2,      2.03899305e-27}, //    14N
{    7,   15,               0,              -1,    1,    -1.430103642e-27}, //    15N
{    7,   16,               0,    1.028642e+10,    0,                   0}, //    16N
{    7,   17,               0,    6.020366e+09,    0,                   0}, //    17N
{    7,   18,               0,    9.002417e+08,    0,                   0}, //    18N
{    7,   19,               0,    3.909704e+08,    0,                   0}, //    19N
{    7,   20,               0,    1.875504e+08,    0,                   0}, //    20N
{    7,   21,               0,    1.226291e+08,    0,                   0}, //    21N
{    7,   22,               0,    3.462468e+07,    0,                   0}, //    22N
{    7,   23,               0,      2.0342e+07,    0,                   0}, //    23N
{    7,   24,               0,        75.02014,    0,                   0}, //    24N
{    8,   12,               0,    1.643662e-12,    0,                   0}, //    12O
{    8,   13,               0,    1.237832e+07,    0,                   0}, //    13O
{    8,   14,               0,    1.018629e+11,    0,                   0}, //    14O
{    8,   15,               0,     1.76355e+11,    1,        3.630445e-27}, //    15O
{    8,   16,               0,              -1,    0,                   0}, //    16O
{    8,   17,               0,              -1,    5,      -9.5636395e-27}, //    17O
{    8,   18,               0,              -1,    0,                   0}, //    18O
{    8,   19,               0,    3.877964e+10,    0,                   0}, //    19O
{    8,   20,               0,    1.949081e+10,    0,                   0}, //    20O
{    8,   21,               0,    4.934017e+09,    0,                   0}, //    21O
{    8,   22,               0,    3.246064e+09,    0,                   0}, //    22O
{    8,   23,               0,     1.18301e+08,    0,                   0}, //    23O
{    8,   24,               0,    9.377518e+07,    0,                   0}, //    24O
{    9,   15,               0,    6.574506e-13,    0,                   0}, //    15F
{    9,   16,               0,    1.643662e-11,    0,                   0}, //    16F
{    9,   17,               0,     9.30394e+10,    5,        2.384761e-26}, //    17F
{    9,   18,               0,    9.501878e+12,    0,                   0}, //    18F
{    9,   19,               0,              -1,    0,                   0}, //    19F
{    9,   20,               0,    1.597063e+10,    4,        1.057218e-26}, //    20F
{    9,   21,               0,    5.998726e+09,    5,          1.9897e-26}, //    21F
{    9,   22,               0,      6.1026e+09,    0,                   0}, //    22F
{    9,   23,               0,     3.21721e+09,    0,                   0}, //    23F
{    9,   24,               0,    5.626511e+08,    0,                   0}, //    24F
{    9,   25,               0,    1.154156e+08,    0,                   0}, //    25F
{    9,   26,               0,    1.399414e+07,    0,                   0}, //    26F
{    9,   27,               0,         7213475,    0,                   0}, //    27F
{    9,   28,               0,         57.7078,    0,                   0}, //    28F
{    9,   29,               0,         3606738,    0,                   0}, //    29F
{    9,   31,               0,        360.6738,    0,                   0}, //    31F
{   10,   16,               0,    5.388899e-12,    0,                   0}, //   16NE
{   10,   17,               0,    1.575423e+08,    0,                   0}, //   17NE
{   10,   18,               0,    2.412186e+09,    0,                   0}, //   18NE
{   10,   19,               0,    2.484321e+10,    0,                   0}, //   19NE
{   10,   20,               0,              -1,    0,                   0}, //   20NE
{   10,   21,               0,              -1,    3,     -3.34207485e-27}, //   21NE
{   10,   22,               0,              -1,    0,                   0}, //   22NE
{   10,   23,               0,    5.372596e+10,    5,        -5.43885e-27}, //   23NE
{   10,   24,               0,    2.925786e+11,    0,                   0}, //   24NE
{   10,   25,               0,    8.685024e+08,    1,        -5.08131e-27}, //   25NE
{   10,   26,               0,    2.842109e+08,    0,                   0}, //   26NE
{   10,   27,               0,    4.544489e+07,    0,                   0}, //   27NE
{   10,   28,               0,    2.726694e+07,    0,                   0}, //   28NE
{   10,   29,               0,    2.164043e+07,    0,                   0}, //   29NE
{   10,   30,               0,    1.053167e+07,    0,                   0}, //   30NE
{   10,   31,               0,         4905163,    0,                   0}, //   31NE
{   10,   32,               0,         5049433,    0,                   0}, //   32NE
{   10,   34,               0,         86.5617,    0,                   0}, //   34NE
{   11,   20,               0,    6.461831e+08,    4,         1.86547e-27}, //   20NA
{   11,   21,               0,    3.244621e+10,    3,        1.205081e-26}, //   21NA
{   11,   22,               0,    1.184958e+17,    6,          8.8173e-27}, //   22NA
{   11,   23,               0,              -1,    3,       1.1198476e-26}, //   23NA
{   11,   24,               0,    7.788966e+13,    8,        8.536015e-27}, //   24NA
{   11,   25,               0,    8.526328e+10,    5,        1.859915e-26}, //   25NA
{   11,   26,               0,    1.553783e+09,    6,        1.439755e-26}, //   26NA
{   11,   27,               0,    4.342512e+08,    5,        1.966975e-26}, //   27NA
{   11,   28,               0,     4.40022e+07,    2,          1.2221e-26}, //   28NA
{   11,   29,               0,    6.362285e+07,    3,        1.236745e-26}, //   29NA
{   11,   30,               0,    6.924936e+07,    4,        1.044845e-26}, //   30NA
{   11,   31,               0,    2.452582e+07,    0,                   0}, //   31NA
{   11,   32,               0,    1.904357e+07,    0,                   0}, //   32NA
{   11,   33,               0,    1.154156e+07,    0,                   0}, //   33NA
{   11,   34,               0,         7934823,    0,                   0}, //   34NA
{   11,   35,               0,         2164043,    0,                   0}, //   35NA
{   11,   37,               0,         86.5617,    0,                   0}, //   37NA
{   12,   20,               0,    1.309967e+08,    0,                   0}, //   20MG
{   12,   21,               0,    1.760088e+08,    0,                   0}, //   21MG
{   12,   22,               0,    5.591165e+09,    0,                   0}, //   22MG
{   12,   23,               0,    1.632698e+10,    0,                   0}, //   23MG
{   12,   24,               0,              -1,    0,                   0}, //   24MG
{   12,   25,               0,              -1,    5,      -4.3200225e-27}, //   25MG
{   12,   26,               0,              -1,    0,                   0}, //   26MG
{   12,   27,               0,    8.187006e+11,    1,       -2.074035e-28}, //   27MG
{   12,   28,               0,    1.086263e+14,    0,                   0}, //   28MG
{   12,   29,               0,    1.875504e+09,    3,          4.9389e-27}, //   29MG
{   12,   30,               0,    4.833028e+08,    0,                   0}, //   30MG
{   12,   31,               0,    3.347052e+08,    0,                   0}, //   31MG
{   12,   32,               0,    1.240718e+08,    0,                   0}, //   32MG
{   12,   33,               0,    1.305639e+08,    3,        -3.76528e-27}, //   33MG
{   12,   34,               0,     2.88539e+07,    0,                   0}, //   34MG
{   12,   35,               0,    1.009887e+08,    0,                   0}, //   35MG
{   12,   36,               0,         5626511,    0,                   0}, //   36MG
{   12,   37,               0,    1.154156e+07,    0,                   0}, //   37MG
{   12,   38,               0,        375.1007,    0,                   0}, //   38MG
{   12,   40,               0,        245.2582,    0,                   0}, //   40MG
{   13,   21,               0,        50.49433,    0,                   0}, //   21AL
{   13,   22,               0,    8.511901e+07,    0,                   0}, //   22AL
{   13,   23,               0,    6.780667e+08,    0,                   0}, //   23AL
{   13,   24,               0,    2.961853e+09,    0,                   0}, //   24AL
{   13,   25,               0,    1.036288e+10,    5,        1.840978e-26}, //   25AL
{   13,   26,               0,    3.264386e+22,    0,                   0}, //   26AL
{   13,   27,               0,              -1,    5,    1.8389609845e-26}, //   27AL
{   13,   28,               0,    1.940136e+11,    6,         1.63721e-26}, //   28AL
{   13,   29,               0,    5.678448e+11,    0,                   0}, //   29AL
{   13,   30,               0,    5.222556e+09,    6,         1.52005e-26}, //   30AL
{   13,   31,               0,    9.290956e+08,    0,                   0}, //   31AL
{   13,   32,               0,    4.760894e+07,    2,         9.89295e-27}, //   32AL
{   13,   33,               0,    6.016038e+07,    0,                   0}, //   33AL
{   13,   34,               0,    8.122373e+07,    0,                   0}, //   34AL
{   13,   35,               0,    5.366826e+07,    0,                   0}, //   35AL
{   13,   36,               0,    1.298426e+08,    0,                   0}, //   36AL
{   13,   37,               0,    1.543684e+07,    0,                   0}, //   37AL
{   13,   38,               0,    1.096448e+07,    0,                   0}, //   38AL
{   13,   39,               0,    1.096448e+07,    0,                   0}, //   39AL
{   13,   40,               0,        375.1007,    0,                   0}, //   40AL
{   13,   41,               0,        375.1007,    0,                   0}, //   41AL
{   13,   42,               0,        245.2582,    0,                   0}, //   42AL
{   14,   22,               0,    4.183816e+07,    0,                   0}, //   22SI
{   14,   23,               0,      6.1026e+07,    0,                   0}, //   23SI
{   14,   26,               0,    3.222981e+09,    0,                   0}, //   26SI
{   14,   27,               0,    5.987184e+09,    5,         4.37027e-27}, //   27SI
{   14,   28,               0,              -1,    0,                   0}, //   28SI
{   14,   29,               0,              -1,    1,      -2.8042145e-27}, //   29SI
{   14,   30,               0,              -1,    0,                   0}, //   30SI
{   14,   31,               0,    1.361616e+13,    0,                   0}, //   31SI
{   14,   32,               0,    6.965764e+18,    0,                   0}, //   32SI
{   14,   33,               0,    8.814867e+09,    3,          6.1105e-27}, //   33SI
{   14,   34,               0,    3.996265e+09,    0,                   0}, //   34SI
{   14,   35,               0,    1.125302e+09,    0,                   0}, //   35SI
{   14,   36,               0,    6.492128e+08,    0,                   0}, //   36SI
{   14,   37,               0,    1.298426e+08,    0,                   0}, //   37SI
{   14,   38,               0,        1442.695,    0,                   0}, //   38SI
{   14,   39,               0,    6.852801e+07,    0,                   0}, //   39SI
{   14,   40,               0,    4.760894e+07,    0,                   0}, //   40SI
{   14,   41,               0,         288.539,    0,                   0}, //   41SI
{   14,   42,               0,    1.803369e+07,    0,                   0}, //   42SI
{   14,   43,               0,         86.5617,    0,                   0}, //   43SI
{   14,   44,               0,        519.3702,    0,                   0}, //   44SI
{   15,   25,               0,        43.28085,    0,                   0}, //    25P
{   15,   26,               0,     2.88539e+07,    0,                   0}, //    26P
{   15,   27,               0,    3.751007e+08,    0,                   0}, //    27P
{   15,   28,               0,    3.899605e+08,    0,                   0}, //    28P
{   15,   29,               0,    5.975643e+09,    1,         6.23473e-27}, //    29P
{   15,   30,               0,    2.162311e+11,    0,                   0}, //    30P
{   15,   31,               0,              -1,    1,         5.71458e-27}, //    31P
{   15,   32,               0,    1.778554e+15,    2,        -1.27462e-27}, //    32P
{   15,   33,               0,    3.159791e+15,    0,                   0}, //    33P
{   15,   34,               0,     1.79327e+10,    0,                   0}, //    34P
{   15,   35,               0,    6.823948e+10,    0,                   0}, //    35P
{   15,   36,               0,    8.079092e+09,    0,                   0}, //    36P
{   15,   37,               0,    3.332626e+09,    0,                   0}, //    37P
{   15,   38,               0,    9.233248e+08,    0,                   0}, //    38P
{   15,   39,               0,    4.039546e+08,    0,                   0}, //    39P
{   15,   40,               0,    2.164043e+08,    0,                   0}, //    40P
{   15,   41,               0,    1.442695e+08,    0,                   0}, //    41P
{   15,   42,               0,    1.586965e+08,    0,                   0}, //    42P
{   15,   43,               0,    5.265837e+07,    0,                   0}, //    43P
{   15,   44,               0,    2.668986e+07,    0,                   0}, //    44P
{   15,   45,               0,         288.539,    0,                   0}, //    45P
{   16,   27,               0,    2.236177e+07,    0,                   0}, //    27S
{   16,   28,               0,    1.803369e+08,    0,                   0}, //    28S
{   16,   29,               0,    2.712267e+08,    0,                   0}, //    29S
{   16,   30,               0,    1.699495e+09,    0,                   0}, //    30S
{   16,   31,               0,    3.710612e+09,    1,        2.464046e-27}, //    31S
{   16,   32,               0,              -1,    0,                   0}, //    32S
{   16,   33,               0,              -1,    3,      3.25129706e-27}, //    33S
{   16,   34,               0,              -1,    0,                   0}, //    34S
{   16,   35,               0,    1.089062e+16,    0,                   0}, //    35S
{   16,   36,               0,              -1,    0,                   0}, //    36S
{   16,   37,               0,    4.371366e+11,    0,                   0}, //    37S
{   16,   38,               0,    1.474146e+13,    0,                   0}, //    38S
{   16,   39,               0,    1.659099e+10,    0,                   0}, //    39S
{   16,   40,               0,    1.269572e+10,    0,                   0}, //    40S
{   16,   41,               0,    2.870963e+09,    0,                   0}, //    41S
{   16,   42,               0,     1.46145e+09,    0,                   0}, //    42S
{   16,   43,               0,    3.173929e+08,    0,                   0}, //    43S
{   16,   44,               0,    1.442695e+08,    0,                   0}, //    44S
{   16,   45,               0,    9.810326e+07,    0,                   0}, //    45S
{   16,   46,               0,    7.213475e+07,    0,                   0}, //    46S
{   16,   48,               0,         288.539,    0,                   0}, //    48S
{   17,   29,               0,         28.8539,    0,                   0}, //   29CL
{   17,   30,               0,        43.28085,    0,                   0}, //   30CL
{   17,   31,               0,    2.164043e+08,    0,                   0}, //   31CL
{   17,   32,               0,    4.299231e+08,    0,                   0}, //   32CL
{   17,   33,               0,    3.622607e+09,    3,        3.812245e-27}, //   33CL
{   17,   34,               0,    2.202418e+09,    0,                   0}, //   34CL
{   17,   35,               0,              -1,    0,                   0}, //   35CL
{   17,   36,               0,    1.371758e+22,    4,        6.491623e-27}, //   36CL
{   17,   37,               0,              -1,    3,      3.45482418e-27}, //   37CL
{   17,   38,               0,    3.223558e+12,    4,         1.03525e-26}, //   38CL
{   17,   39,               0,    4.864768e+12,    0,                   0}, //   39CL
{   17,   40,               0,    1.168583e+11,    0,                   0}, //   40CL
{   17,   41,               0,    5.539949e+10,    0,                   0}, //   41CL
{   17,   42,               0,    9.810326e+09,    0,                   0}, //   42CL
{   17,   43,               0,    4.515635e+09,    0,                   0}, //   43CL
{   17,   44,               0,    8.079092e+08,    0,                   0}, //   44CL
{   17,   45,               0,    5.958331e+08,    0,                   0}, //   45CL
{   17,   46,               0,     3.21721e+08,    0,                   0}, //   46CL
{   17,   47,               0,    1.457122e+08,    0,                   0}, //   47CL
{   17,   48,               0,         288.539,    0,                   0}, //   48CL
{   17,   50,               0,        894.4709,    0,                   0}, //   50CL
{   17,   51,               0,         288.539,    0,                   0}, //   51CL
{   18,   31,               0,    2.077481e+07,    0,                   0}, //   31AR
{   18,   32,               0,    1.413841e+08,    0,                   0}, //   32AR
{   18,   33,               0,    2.495862e+08,    1,        -3.65115e-27}, //   33AR
{   18,   34,               0,    1.217346e+09,    0,                   0}, //   34AR
{   18,   35,               0,    2.561649e+09,    3,         3.19261e-27}, //   35AR
{   18,   36,               0,              -1,    0,                   0}, //   36AR
{   18,   37,               0,    4.364152e+15,    3,         5.78225e-27}, //   37AR
{   18,   38,               0,              -1,    0,                   0}, //   38AR
{   18,   39,               0,    1.224704e+19,    7,         -8.0194e-27}, //   39AR
{   18,   40,               0,              -1,    0,                   0}, //   40AR
{   18,   41,               0,    9.488028e+12,    0,                   0}, //   41AR
{   18,   42,               0,    1.497806e+18,    0,                   0}, //   42AR
{   18,   43,               0,    4.648363e+11,    0,                   0}, //   43AR
{   18,   44,               0,    1.027487e+12,    0,                   0}, //   44AR
{   18,   45,               0,    3.098909e+10,    0,                   0}, //   45AR
{   18,   46,               0,    1.211864e+10,    0,                   0}, //   46AR
{   18,   47,               0,    1.774515e+09,    0,                   0}, //   47AR
{   18,   48,               0,    6.852801e+08,    0,                   0}, //   48AR
{   18,   49,               0,    2.452582e+08,    0,                   0}, //   49AR
{   18,   50,               0,    1.226291e+08,    0,                   0}, //   50AR
{   18,   51,               0,    1.154156e+08,    0,                   0}, //   51AR
{   18,   53,               0,        894.4709,    0,                   0}, //   53AR
{   19,   35,               0,    2.567997e+08,    0,                   0}, //    35K
{   19,   36,               0,     4.91959e+08,    0,                   0}, //    36K
{   19,   37,               0,    1.767301e+09,    3,        1.026211e-27}, //    37K
{   19,   38,               0,    6.609852e+11,    6,         6.92355e-27}, //    38K
{   19,   39,               0,              -1,    3,     1.976904108e-27}, //    39K
{   19,   40,               0,     5.68191e+25,    8,       -6.555405e-27}, //    40K
{   19,   41,               0,              -1,    3,    1.0850939545e-27}, //    41K
{   19,   42,               0,    6.419416e+13,    4,       -5.769625e-27}, //    42K
{   19,   43,               0,    1.158196e+14,    3,         8.24665e-28}, //    43K
{   19,   44,               0,     1.91561e+12,    4,         -4.3228e-27}, //    44K
{   19,   45,               0,    1.541664e+12,    3,          8.7567e-28}, //    45K
{   19,   46,               0,     1.51483e+11,    0,                   0}, //    46K
{   19,   47,               0,    2.524716e+10,    1,         9.76165e-27}, //    47K
{   19,   48,               0,    9.810326e+09,    0,                   0}, //    48K
{   19,   49,               0,    1.817796e+09,    0,                   0}, //    49K
{   19,   50,               0,    6.809521e+08,    0,                   0}, //    50K
{   19,   51,               0,    5.265837e+08,    0,                   0}, //    51K
{   19,   52,               0,     1.51483e+08,    0,                   0}, //    52K
{   19,   53,               0,    4.328085e+07,    0,                   0}, //    53K
{   19,   54,               0,    1.442695e+07,    0,                   0}, //    54K
{   19,   55,               0,        519.3702,    0,                   0}, //    55K
{   19,   56,               0,        894.4709,    0,                   0}, //    56K
{   20,   35,               0,    3.707726e+07,    0,                   0}, //   35CA
{   20,   36,               0,    1.460007e+08,    0,                   0}, //   36CA
{   20,   37,               0,    2.612721e+08,    0,                   0}, //   37CA
{   20,   38,               0,    6.347858e+08,    0,                   0}, //   38CA
{   20,   39,               0,    1.240141e+09,    3,        5.159484e-27}, //   39CA
{   20,   40,               0,              -1,    0,                   0}, //   40CA
{   20,   41,               0,    4.643891e+21,    7,       -8.053644e-27}, //   41CA
{   20,   42,               0,              -1,    0,                   0}, //   42CA
{   20,   43,               0,              -1,    7,       -6.652163e-27}, //   43CA
{   20,   44,               0,              -1,    0,                   0}, //   44CA
{   20,   45,               0,    2.026987e+16,    7,        -6.70337e-27}, //   45CA
{   20,   46,               0,              -1,    0,                   0}, //   46CA
{   20,   47,               0,    5.654066e+14,    7,          -6.969e-27}, //   47CA
{   20,   48,               0,    8.650255e+35,    0,                   0}, //   48CA
{   20,   49,               0,    7.546449e+11,    3,          -6.969e-27}, //   49CA
{   20,   50,               0,    2.005346e+10,    0,                   0}, //   50CA
{   20,   51,               0,    1.442695e+10,    0,                   0}, //   51CA
{   20,   52,               0,    6.636397e+09,    0,                   0}, //   52CA
{   20,   53,               0,    1.298426e+08,    0,                   0}, //   53CA
{   20,   55,               0,    3.173929e+07,    0,                   0}, //   55CA
{   20,   56,               0,    1.586965e+07,    0,                   0}, //   56CA
{   20,   57,               0,        894.4709,    0,                   0}, //   57CA
{   20,   58,               0,        894.4709,    0,                   0}, //   58CA
{   21,   39,               0,        432.8085,    0,                   0}, //   39SC
{   21,   40,               0,    2.630033e+08,    0,                   0}, //   40SC
{   21,   41,               0,    8.602791e+08,    7,        2.742403e-26}, //   41SC
{   21,   42,               0,    9.829081e+08,    0,                   0}, //   42SC
{   21,   43,               0,    2.020927e+13,    7,          2.3331e-26}, //   43SC
{   21,   44,               0,      2.0619e+13,    4,        1.261995e-26}, //   44SC
{   21,   45,               0,              -1,    7,     2.402025935e-26}, //   45SC
{   21,   46,               0,    1.044439e+16,    8,         1.53015e-26}, //   46SC
{   21,   47,               0,    4.174727e+14,    7,          2.6967e-26}, //   47SC
{   21,   48,               0,    2.268061e+14,    0,                   0}, //   48SC
{   21,   49,               0,    4.949598e+12,    0,                   0}, //   49SC
{   21,   50,               0,    1.478762e+11,    0,                   0}, //   50SC
{   21,   51,               0,    1.788942e+10,    0,                   0}, //   51SC
{   21,   52,               0,     1.18301e+10,    0,                   0}, //   52SC
{   21,   53,               0,    4.328085e+09,    0,                   0}, //   53SC
{   21,   54,               0,     4.21267e+08,    0,                   0}, //   54SC
{   21,   55,               0,     1.51483e+08,    0,                   0}, //   55SC
{   21,   56,               0,    3.751007e+07,    0,                   0}, //   56SC
{   21,   57,               0,    1.875504e+07,    0,                   0}, //   57SC
{   21,   58,               0,    1.731234e+07,    0,                   0}, //   58SC
{   21,   59,               0,        519.3702,    0,                   0}, //   59SC
{   21,   60,               0,        519.3702,    0,                   0}, //   60SC
{   21,   61,               0,        519.3702,    0,                   0}, //   61SC
{   22,   39,               0,    4.472355e+07,    0,                   0}, //   39TI
{   22,   40,               0,    7.689565e+07,    0,                   0}, //   40TI
{   22,   41,               0,    1.159927e+08,    0,                   0}, //   41TI
{   22,   42,               0,    2.870963e+08,    0,                   0}, //   42TI
{   22,   43,               0,    7.343318e+08,    7,          4.2925e-27}, //   43TI
{   22,   44,               0,    2.690771e+18,    0,                   0}, //   44TI
{   22,   45,               0,     1.59966e+13,    7,          4.7975e-28}, //   45TI
{   22,   46,               0,              -1,    0,                   0}, //   46TI
{   22,   47,               0,              -1,    5,       -3.981824e-27}, //   47TI
{   22,   48,               0,              -1,    0,                   0}, //   48TI
{   22,   49,               0,              -1,    7,      -5.5760585e-27}, //   49TI
{   22,   50,               0,              -1,    0,                   0}, //   50TI
{   22,   51,               0,    4.985954e+11,    0,                   0}, //   51TI
{   22,   52,               0,    1.471549e+11,    0,                   0}, //   52TI
{   22,   53,               0,    4.717613e+10,    0,                   0}, //   53TI
{   22,   54,               0,    2.164043e+09,    0,                   0}, //   54TI
{   22,   55,               0,    1.875504e+09,    0,                   0}, //   55TI
{   22,   56,               0,     2.88539e+08,    0,                   0}, //   56TI
{   22,   57,               0,    1.413841e+08,    0,                   0}, //   57TI
{   22,   58,               0,    8.511901e+07,    0,                   0}, //   58TI
{   22,   59,               0,    8.367631e+07,    0,                   0}, //   59TI
{   22,   61,               0,    2.164043e+07,    0,                   0}, //   61TI
{   22,   62,               0,        894.4709,    0,                   0}, //   62TI
{   22,   63,               0,        519.3702,    0,                   0}, //   63TI
{   23,   42,               0,        79.34823,    0,                   0}, //    42V
{   23,   43,               0,    1.154156e+09,    0,                   0}, //    43V
{   23,   44,               0,    1.601391e+08,    0,                   0}, //    44V
{   23,   45,               0,    7.891542e+08,    0,                   0}, //    45V
{   23,   46,               0,    6.095387e+08,    0,                   0}, //    46V
{   23,   47,               0,    2.821911e+12,    0,                   0}, //    47V
{   23,   48,               0,    1.991063e+15,    8,         1.01606e-26}, //    48V
{   23,   49,               0,    4.113412e+16,    7,         2.25735e-26}, //    49V
{   23,   50,               0,    6.373971e+33,   12,        1.689573e-26}, //    50V
{   23,   51,               0,              -1,    0,                   0}, //    51V
{   23,   52,               0,    3.240005e+11,    0,                   0}, //    52V
{   23,   53,               0,    1.335647e+11,    0,                   0}, //    53V
{   23,   54,               0,    7.184621e+10,    0,                   0}, //    54V
{   23,   55,               0,    9.435226e+09,    0,                   0}, //    55V
{   23,   56,               0,    3.116221e+08,    0,                   0}, //    56V
{   23,   57,               0,    4.616624e+08,    0,                   0}, //    57V
{   23,   58,               0,    2.755548e+08,    0,                   0}, //    58V
{   23,   59,               0,    1.082021e+08,    0,                   0}, //    59V
{   23,   61,               0,    6.780667e+07,    0,                   0}, //    61V
{   23,   62,               0,    4.847455e+07,    0,                   0}, //    62V
{   23,   63,               0,    2.452582e+07,    0,                   0}, //    63V
{   23,   64,               0,    2.741121e+07,    0,                   0}, //    64V
{   23,   65,               0,        519.3702,    0,                   0}, //    65V
{   23,   66,               0,        519.3702,    0,                   0}, //    66V
{   24,   42,               0,    1.918784e+07,    0,                   0}, //   42CR
{   24,   43,               0,    3.116221e+07,    0,                   0}, //   43CR
{   24,   44,               0,    6.174735e+07,    0,                   0}, //   44CR
{   24,   45,               0,    8.786013e+07,    0,                   0}, //   45CR
{   24,   46,               0,    3.751007e+08,    0,                   0}, //   46CR
{   24,   47,               0,    7.213475e+08,    0,                   0}, //   47CR
{   24,   48,               0,    1.119762e+14,    0,                   0}, //   48CR
{   24,   49,               0,     3.66156e+12,    5,          2.4038e-27}, //   49CR
{   24,   50,               0,    5.918656e+34,    0,                   0}, //   50CR
{   24,   51,               0,    3.452946e+15,    0,                   0}, //   51CR
{   24,   52,               0,              -1,    0,                   0}, //   52CR
{   24,   53,               0,              -1,    3,       -2.396427e-27}, //   53CR
{   24,   54,               0,              -1,    0,                   0}, //   54CR
{   24,   55,               0,    3.027063e+11,    0,                   0}, //   55CR
{   24,   56,               0,    5.141765e+11,    0,                   0}, //   56CR
{   24,   57,               0,    3.044087e+10,    0,                   0}, //   57CR
{   24,   58,               0,    1.009887e+10,    0,                   0}, //   58CR
{   24,   59,               0,    6.636397e+08,    0,                   0}, //   59CR
{   24,   60,               0,    7.069206e+08,    0,                   0}, //   60CR
{   24,   61,               0,    3.505749e+08,    0,                   0}, //   61CR
{   24,   62,               0,    2.971952e+08,    0,                   0}, //   62CR
{   24,   63,               0,    1.861077e+08,    0,                   0}, //   63CR
{   24,   64,               0,    6.203589e+07,    0,                   0}, //   64CR
{   24,   65,               0,    3.895277e+07,    0,                   0}, //   65CR
{   24,   66,               0,    1.442695e+07,    0,                   0}, //   66CR
{   24,   68,               0,        519.3702,    0,                   0}, //   68CR
{   25,   44,               0,         151.483,    0,                   0}, //   44MN
{   25,   46,               0,    5.222556e+07,    0,                   0}, //   46MN
{   25,   47,               0,    1.442695e+08,    0,                   0}, //   47MN
{   25,   48,               0,    2.280901e+08,    0,                   0}, //   48MN
{   25,   49,               0,    5.511095e+08,    0,                   0}, //   49MN
{   25,   50,               0,    4.085568e+08,    0,                   0}, //   50MN
{   25,   51,               0,    3.999151e+12,    0,                   0}, //   51MN
{   25,   52,               0,    6.969083e+14,   12,        1.546815e-26}, //   52MN
{   25,   53,               0,    1.702813e+23,    0,                   0}, //   53MN
{   25,   54,               0,     3.88965e+16,    6,         1.65736e-26}, //   54MN
{   25,   55,               0,              -1,    5,        1.743866e-26}, //   55MN
{   25,   56,               0,    1.339398e+13,    6,        1.629433e-26}, //   56MN
{   25,   57,               0,    1.232062e+11,    0,                   0}, //   57MN
{   25,   58,               0,    4.328085e+09,    0,                   0}, //   58MN
{   25,   59,               0,     6.62197e+09,    0,                   0}, //   59MN
{   25,   60,               0,    4.039546e+08,    0,                   0}, //   60MN
{   25,   61,               0,    9.666057e+08,    0,                   0}, //   61MN
{   25,   63,               0,    3.967411e+08,    0,                   0}, //   63MN
{   25,   64,               0,    1.298426e+08,    0,                   0}, //   64MN
{   25,   65,               0,    1.327279e+08,    0,                   0}, //   65MN
{   25,   66,               0,    9.377518e+07,    0,                   0}, //   66MN
{   25,   67,               0,    6.780667e+07,    0,                   0}, //   67MN
{   25,   68,               0,    4.039546e+07,    0,                   0}, //   68MN
{   25,   69,               0,    2.019773e+07,    0,                   0}, //   69MN
{   25,   70,               0,        519.3702,    0,                   0}, //   70MN
{   25,   71,               0,        918.9967,    0,                   0}, //   71MN
{   26,   45,               0,         2726694,    0,                   0}, //   45FE
{   26,   46,               0,    1.875504e+07,    0,                   0}, //   46FE
{   26,   47,               0,    3.145075e+07,    0,                   0}, //   47FE
{   26,   48,               0,    6.347858e+07,    0,                   0}, //   48FE
{   26,   49,               0,    9.334237e+07,    0,                   0}, //   49FE
{   26,   50,               0,    2.236177e+08,    0,                   0}, //   50FE
{   26,   51,               0,     4.40022e+08,    0,                   0}, //   51FE
{   26,   52,               0,    4.297789e+13,    0,                   0}, //   52FE
{   26,   53,               0,    7.366401e+11,    0,                   0}, //   53FE
{   26,   54,               0,              -1,    0,                   0}, //   54FE
{   26,   55,               0,    1.249287e+17,    0,                   0}, //   55FE
{   26,   56,               0,              -1,    0,                   0}, //   56FE
{   26,   57,               0,              -1,    1,         4.56722e-28}, //   57FE
{   26,   58,               0,              -1,    0,                   0}, //   58FE
{   26,   59,               0,    5.546297e+15,    3,        -1.69579e-27}, //   59FE
{   26,   60,               0,    6.829141e+22,    0,                   0}, //   60FE
{   26,   61,               0,     5.17639e+11,    0,                   0}, //   61FE
{   26,   62,               0,    9.810326e+10,    0,                   0}, //   62FE
{   26,   63,               0,     8.80044e+09,    0,                   0}, //   63FE
{   26,   64,               0,     2.88539e+09,    0,                   0}, //   64FE
{   26,   65,               0,    1.168583e+09,    0,                   0}, //   65FE
{   26,   66,               0,    6.347858e+08,    0,                   0}, //   66FE
{   26,   67,               0,     8.65617e+08,    0,                   0}, //   67FE
{   26,   68,               0,    2.712267e+08,    0,                   0}, //   68FE
{   26,   69,               0,    2.452582e+08,    0,                   0}, //   69FE
{   26,   70,               0,    1.356133e+08,    0,                   0}, //   70FE
{   26,   71,               0,    4.039546e+07,    0,                   0}, //   71FE
{   26,   72,               0,        216.4043,    0,                   0}, //   72FE
{   26,   73,               0,         913.226,    0,                   0}, //   73FE
{   26,   74,               0,        920.4394,    0,                   0}, //   74FE
{   27,   50,               0,    5.597657e+07,    0,                   0}, //   50CO
{   27,   51,               0,         288.539,    0,                   0}, //   51CO
{   27,   52,               0,    1.659099e+08,    0,                   0}, //   52CO
{   27,   53,               0,    3.462468e+08,    0,                   0}, //   53CO
{   27,   54,               0,    2.788441e+08,    0,                   0}, //   54CO
{   27,   55,               0,     9.10456e+13,    7,         2.43511e-26}, //   55CO
{   27,   56,               0,    9.627393e+15,    8,         1.94425e-26}, //   56CO
{   27,   57,               0,    3.387159e+16,    7,          2.3836e-26}, //   57CO
{   27,   58,               0,    8.832612e+15,    4,         2.04222e-26}, //   58CO
{   27,   59,               0,              -1,    7,        2.336635e-26}, //   59CO
{   27,   60,               0,    2.399779e+17,   10,        1.918495e-26}, //   60CO
{   27,   61,               0,    8.569609e+12,    0,                   0}, //   61CO
{   27,   62,               0,     1.33305e+11,    0,                   0}, //   62CO
{   27,   63,               0,    3.952984e+10,    0,                   0}, //   63CO
{   27,   64,               0,    4.328085e+08,    0,                   0}, //   64CO
{   27,   65,               0,    1.673526e+09,    0,                   0}, //   65CO
{   27,   66,               0,     2.88539e+08,    0,                   0}, //   66CO
{   27,   67,               0,    6.131454e+08,    0,                   0}, //   67CO
{   27,   68,               0,     2.88539e+08,    0,                   0}, //   68CO
{   27,   69,               0,    3.895277e+08,    0,                   0}, //   69CO
{   27,   70,               0,    1.716807e+08,    0,                   0}, //   70CO
{   27,   71,               0,    1.154156e+08,    0,                   0}, //   71CO
{   27,   72,               0,    8.641743e+07,    0,                   0}, //   72CO
{   27,   73,               0,        216.4043,    0,                   0}, //   73CO
{   27,   74,               0,    4.328085e+07,    0,                   0}, //   74CO
{   27,   76,               0,        914.6687,    0,                   0}, //   76CO
{   28,   48,               0,         3029660,    0,                   0}, //   48NI
{   28,   49,               0,    1.082021e+07,    0,                   0}, //   49NI
{   28,   50,               0,    2.668986e+07,    0,                   0}, //   50NI
{   28,   51,               0,         288.539,    0,                   0}, //   51NI
{   28,   52,               0,    5.482241e+07,    0,                   0}, //   52NI
{   28,   53,               0,    6.492128e+07,    0,                   0}, //   53NI
{   28,   54,               0,    1.500403e+08,    0,                   0}, //   54NI
{   28,   55,               0,    2.953197e+08,    0,                   0}, //   55NI
{   28,   56,               0,    7.572418e+14,    0,                   0}, //   56NI
{   28,   57,               0,    1.848958e+14,    3,       -4.027375e-27}, //   57NI
{   28,   58,               0,              -1,    0,                   0}, //   58NI
{   28,   59,               0,     3.46016e+21,    0,                   0}, //   59NI
{   28,   60,               0,              -1,    0,                   0}, //   60NI
{   28,   61,               0,              -1,    0,                   0}, //   61NI
{   28,   62,               0,              -1,    0,                   0}, //   62NI
{   28,   63,               0,    4.607391e+18,    0,                   0}, //   63NI
{   28,   64,               0,              -1,    0,                   0}, //   64NI
{   28,   65,               0,    1.307515e+13,    5,          3.4845e-27}, //   65NI
{   28,   66,               0,    2.835761e+14,    0,                   0}, //   66NI
{   28,   67,               0,     3.02966e+10,    0,                   0}, //   67NI
{   28,   68,               0,    4.183816e+10,    0,                   0}, //   68NI
{   28,   69,               0,    1.644672e+10,    0,                   0}, //   69NI
{   28,   70,               0,     8.65617e+09,    0,                   0}, //   70NI
{   28,   71,               0,    3.693299e+09,    0,                   0}, //   71NI
{   28,   72,               0,    2.265031e+09,    0,                   0}, //   72NI
{   28,   73,               0,    1.211864e+09,    0,                   0}, //   73NI
{   28,   74,               0,    9.810326e+08,    0,                   0}, //   74NI
{   28,   75,               0,     8.65617e+08,    0,                   0}, //   75NI
{   28,   76,               0,    3.433614e+08,    0,                   0}, //   76NI
{   28,   77,               0,     1.84665e+08,    0,                   0}, //   77NI
{   28,   78,               0,    1.586965e+08,    0,                   0}, //   78NI
{   28,   79,               0,        916.1114,    0,                   0}, //   79NI
{   29,   53,               0,        432.8085,    0,                   0}, //   53CU
{   29,   54,               0,        108.2021,    0,                   0}, //   54CU
{   29,   55,               0,     5.77078e+07,    0,                   0}, //   55CU
{   29,   56,               0,    1.341706e+08,    0,                   0}, //   56CU
{   29,   57,               0,     2.83201e+08,    0,                   0}, //   57CU
{   29,   58,               0,    4.622395e+09,    2,           2.626e-27}, //   58CU
{   29,   59,               0,    1.175796e+11,    0,                   0}, //   59CU
{   29,   60,               0,    2.051512e+12,    4,         6.15595e-27}, //   60CU
{   29,   61,               0,     1.73109e+13,    3,          1.0807e-26}, //   61CU
{   29,   62,               0,    8.370517e+11,    2,        -1.91698e-27}, //   62CU
{   29,   63,               0,              -1,    3,      1.12276145e-26}, //   63CU
{   29,   64,               0,    6.596579e+13,    2,        -1.09585e-27}, //   64CU
{   29,   65,               0,              -1,    3,        1.202708e-26}, //   65CU
{   29,   66,               0,    4.431959e+11,    2,         -1.4241e-27}, //   66CU
{   29,   67,               0,    3.211295e+14,    0,                   0}, //   67CU
{   29,   68,               0,    4.457928e+10,    2,        1.208617e-26}, //   68CU
{   29,   69,               0,    2.467009e+11,    0,                   0}, //   69CU
{   29,   70,               0,    6.419993e+10,    0,                   0}, //   70CU
{   29,   71,               0,    2.798828e+10,    0,                   0}, //   71CU
{   29,   72,               0,    9.565068e+09,    0,                   0}, //   72CU
{   29,   73,               0,    6.059319e+09,    0,                   0}, //   73CU
{   29,   74,               0,    2.351593e+09,    0,                   0}, //   74CU
{   29,   75,               0,    1.765859e+09,    0,                   0}, //   75CU
{   29,   77,               0,     6.75037e+08,    5,          8.1305e-27}, //   77CU
{   29,   78,               0,    4.833028e+08,    0,                   0}, //   78CU
{   29,   79,               0,    2.712267e+08,    0,                   0}, //   79CU
{   29,   80,               0,        432.8085,    0,                   0}, //   80CU
{   29,   81,               0,        911.7833,    0,                   0}, //   81CU
{   29,   82,               0,         917.554,    0,                   0}, //   82CU
{   30,   54,               0,         4616624,    0,                   0}, //   54ZN
{   30,   55,               0,     2.88539e+07,    0,                   0}, //   55ZN
{   30,   56,               0,    4.328085e+07,    0,                   0}, //   56ZN
{   30,   57,               0,     5.77078e+07,    0,                   0}, //   57ZN
{   30,   58,               0,    1.240718e+08,    0,                   0}, //   58ZN
{   30,   59,               0,    2.625705e+08,    0,                   0}, //   59ZN
{   30,   60,               0,    2.060169e+11,    0,                   0}, //   60ZN
{   30,   61,               0,    1.285441e+11,    0,                   0}, //   61ZN
{   30,   62,               0,    4.774599e+13,    0,                   0}, //   62ZN
{   30,   63,               0,    3.330029e+12,    3,       -1.422282e-27}, //   63ZN
{   30,   64,               0,              -1,    0,                   0}, //   64ZN
{   30,   65,               0,    3.040624e+16,    5,         3.88345e-27}, //   65ZN
{   30,   66,               0,              -1,    0,                   0}, //   66ZN
{   30,   67,               0,              -1,    5,      4.42116895e-27}, //   67ZN
{   30,   68,               0,              -1,    0,                   0}, //   68ZN
{   30,   69,               0,     4.88208e+12,    0,                   0}, //   69ZN
{   30,   70,               0,    5.918656e+32,    0,                   0}, //   70ZN
{   30,   71,               0,    2.120762e+11,    0,                   0}, //   71ZN
{   30,   72,               0,    2.415071e+14,    0,                   0}, //   72ZN
{   30,   73,               0,    3.390333e+10,    0,                   0}, //   73ZN
{   30,   74,               0,    1.379216e+11,    0,                   0}, //   74ZN
{   30,   75,               0,    1.471549e+10,    0,                   0}, //   75ZN
{   30,   76,               0,    8.223362e+09,    0,                   0}, //   76ZN
{   30,   77,               0,    3.000806e+09,    0,                   0}, //   77ZN
{   30,   78,               0,    2.120762e+09,    0,                   0}, //   78ZN
{   30,   79,               0,    1.435482e+09,    0,                   0}, //   79ZN
{   30,   80,               0,    7.790553e+08,    0,                   0}, //   80ZN
{   30,   81,               0,    4.616624e+08,    0,                   0}, //   81ZN
{   30,   82,               0,        216.4043,    0,                   0}, //   82ZN
{   30,   83,               0,        432.8085,    0,                   0}, //   83ZN
{   30,   84,               0,         913.226,    0,                   0}, //   84ZN
{   31,   60,               0,    1.009887e+08,    0,                   0}, //   60GA
{   31,   61,               0,    2.409301e+08,    0,                   0}, //   61GA
{   31,   62,               0,    1.675257e+08,    0,                   0}, //   62GA
{   31,   63,               0,    4.674332e+10,    0,                   0}, //   63GA
{   31,   64,               0,    2.273976e+11,    0,                   0}, //   64GA
{   31,   65,               0,    1.315738e+12,    0,                   0}, //   65GA
{   31,   66,               0,    4.928823e+13,    0,                   0}, //   66GA
{   31,   67,               0,    4.065659e+14,    3,        9.346035e-27}, //   67GA
{   31,   68,               0,    5.861093e+12,    2,         5.93375e-29}, //   68GA
{   31,   69,               0,              -1,    3,      1.01837795e-26}, //   69GA
{   31,   70,               0,    1.829914e+12,    0,                   0}, //   70GA
{   31,   71,               0,              -1,    3,      1.29394433e-26}, //   71GA
{   31,   72,               0,     7.32312e+13,    6,        -6.67812e-28}, //   72GA
{   31,   73,               0,    2.524139e+13,    0,                   0}, //   73GA
{   31,   74,               0,     7.02881e+11,    0,                   0}, //   74GA
{   31,   75,               0,    1.817796e+11,    0,                   0}, //   75GA
{   31,   76,               0,    4.703186e+10,    0,                   0}, //   76GA
{   31,   77,               0,    1.904357e+10,    0,                   0}, //   77GA
{   31,   78,               0,    7.343318e+09,    0,                   0}, //   78GA
{   31,   79,               0,    4.107353e+09,    0,                   0}, //   79GA
{   31,   80,               0,    2.417957e+09,    0,                   0}, //   80GA
{   31,   81,               0,     1.75576e+09,    0,                   0}, //   81GA
{   31,   82,               0,    8.641743e+08,    0,                   0}, //   82GA
{   31,   83,               0,    4.444943e+08,    0,                   0}, //   83GA
{   31,   84,               0,    1.226291e+08,    0,                   0}, //   84GA
{   31,   85,               0,        216.4043,    0,                   0}, //   85GA
{   31,   86,               0,        216.4043,    0,                   0}, //   86GA
{   31,   87,               0,        914.6687,    0,                   0}, //   87GA
{   32,   60,               0,        158.6965,    0,                   0}, //   60GE
{   32,   61,               0,    6.347858e+07,    0,                   0}, //   61GE
{   32,   62,               0,    1.861077e+08,    0,                   0}, //   62GE
{   32,   63,               0,    2.164043e+08,    0,                   0}, //   63GE
{   32,   64,               0,    9.189967e+10,    0,                   0}, //   64GE
{   32,   65,               0,    4.457928e+10,    0,                   0}, //   65GE
{   32,   66,               0,    1.173777e+13,    0,                   0}, //   66GE
{   32,   67,               0,    1.636016e+12,    0,                   0}, //   67GE
{   32,   68,               0,    3.377061e+16,    0,                   0}, //   68GE
{   32,   69,               0,    2.028141e+14,    5,         3.71175e-27}, //   69GE
{   32,   70,               0,              -1,    0,                   0}, //   70GE
{   32,   71,               0,    1.424733e+15,    1,         2.76235e-27}, //   71GE
{   32,   72,               0,              -1,    0,                   0}, //   72GE
{   32,   73,               0,              -1,    9,    -4.441311885e-27}, //   73GE
{   32,   74,               0,              -1,    0,                   0}, //   74GE
{   32,   75,               0,    7.165578e+12,    1,          2.5755e-27}, //   75GE
{   32,   76,               0,              -1,    0,                   0}, //   76GE
{   32,   77,               0,    5.822717e+13,    0,                   0}, //   77GE
{   32,   78,               0,     7.61743e+12,    0,                   0}, //   78GE
{   32,   79,               0,    2.738235e+10,    0,                   0}, //   79GE
{   32,   80,               0,     4.25595e+10,    0,                   0}, //   80GE
{   32,   81,               0,    1.096448e+10,    0,                   0}, //   81GE
{   32,   82,               0,    6.578689e+09,    0,                   0}, //   82GE
{   32,   83,               0,    2.668986e+09,    0,                   0}, //   83GE
{   32,   84,               0,    1.376331e+09,    0,                   0}, //   84GE
{   32,   85,               0,    7.718418e+08,    0,                   0}, //   85GE
{   32,   86,               0,        216.4043,    0,                   0}, //   86GE
{   32,   87,               0,    2.019773e+08,    0,                   0}, //   87GE
{   32,   88,               0,        432.8085,    0,                   0}, //   88GE
{   32,   90,               0,        916.1114,    0,                   0}, //   90GE
{   33,   63,               0,        62.03589,    0,                   0}, //   63AS
{   33,   64,               0,    2.596851e+07,    0,                   0}, //   64AS
{   33,   65,               0,     1.84665e+08,    0,                   0}, //   65AS
{   33,   66,               0,    1.381669e+08,    0,                   0}, //   66AS
{   33,   67,               0,    6.131454e+10,    0,                   0}, //   67AS
{   33,   68,               0,    2.187126e+11,    0,                   0}, //   68AS
{   33,   69,               0,    1.315738e+12,    5,           7.979e-27}, //   69AS
{   33,   70,               0,    4.553146e+12,    8,        1.063581e-26}, //   70AS
{   33,   71,               0,    3.391488e+14,    0,                   0}, //   71AS
{   33,   72,               0,    1.350363e+14,    4,       -1.089083e-26}, //   72AS
{   33,   73,               0,    1.000927e+16,    0,                   0}, //   73AS
{   33,   74,               0,     2.21497e+15,    4,        -8.06485e-27}, //   74AS
{   33,   75,               0,              -1,    3,      7.26934875e-27}, //   75AS
{   33,   76,               0,    1.362827e+14,    4,         -4.5753e-27}, //   76AS
{   33,   77,               0,    2.014579e+14,    3,         6.53773e-27}, //   77AS
{   33,   78,               0,    7.851146e+12,    0,                   0}, //   78AS
{   33,   79,               0,    7.799209e+11,    0,                   0}, //   79AS
{   33,   80,               0,    2.192896e+10,    0,                   0}, //   80AS
{   33,   81,               0,    4.804174e+10,    0,                   0}, //   81AS
{   33,   82,               0,    2.755548e+10,    0,                   0}, //   82AS
{   33,   83,               0,    1.933211e+10,    0,                   0}, //   83AS
{   33,   84,               0,    6.059319e+09,    0,                   0}, //   84AS
{   33,   85,               0,    2.915687e+09,    0,                   0}, //   85AS
{   33,   86,               0,    1.363347e+09,    0,                   0}, //   86AS
{   33,   87,               0,    8.079092e+08,    0,                   0}, //   87AS
{   33,   88,               0,     2.88539e+08,    0,                   0}, //   88AS
{   33,   90,               0,        432.8085,    0,                   0}, //   90AS
{   34,   64,               0,        259.6851,    0,                   0}, //   64SE
{   34,   65,               0,    4.760894e+07,    0,                   0}, //   65SE
{   34,   67,               0,    1.962065e+08,    0,                   0}, //   67SE
{   34,   68,               0,    5.121567e+10,    0,                   0}, //   68SE
{   34,   69,               0,    3.952984e+10,    0,                   0}, //   69SE
{   34,   70,               0,    3.557686e+12,    0,                   0}, //   70SE
{   34,   71,               0,    4.103025e+11,    0,                   0}, //   71SE
{   34,   72,               0,     1.04705e+15,    0,                   0}, //   72SE
{   34,   73,               0,    3.713497e+13,    9,          4.3935e-27}, //   73SE
{   34,   74,               0,              -1,    0,                   0}, //   74SE
{   34,   75,               0,    1.493189e+16,    5,          3.3835e-27}, //   75SE
{   34,   76,               0,              -1,    0,                   0}, //   76SE
{   34,   77,               0,              -1,    1,      2.70196311e-27}, //   77SE
{   34,   78,               0,              -1,    0,                   0}, //   78SE
{   34,   79,               0,    1.343077e+22,    7,         -5.1409e-27}, //   79SE
{   34,   80,               0,              -1,    0,                   0}, //   80SE
{   34,   81,               0,    1.597063e+12,    0,                   0}, //   81SE
{   34,   82,               0,              -1,    0,                   0}, //   82SE
{   34,   83,               0,    1.930326e+12,    0,                   0}, //   83SE
{   34,   84,               0,    2.821911e+11,    0,                   0}, //   84SE
{   34,   85,               0,    4.573343e+10,    0,                   0}, //   85SE
{   34,   86,               0,    2.063054e+10,    0,                   0}, //   86SE
{   34,   87,               0,    7.934823e+09,    0,                   0}, //   87SE
{   34,   88,               0,    2.207323e+09,    0,                   0}, //   88SE
{   34,   89,               0,     5.91505e+08,    0,                   0}, //   89SE
{   34,   90,               0,    2.813255e+08,    0,                   0}, //   90SE
{   34,   91,               0,    3.895277e+08,    0,                   0}, //   91SE
{   34,   94,               0,        216.4043,    0,                   0}, //   94SE
{   34,   95,               0,        565.5365,    0,                   0}, //   95SE
{   35,   69,               0,        34.62468,    0,                   0}, //   69BR
{   35,   70,               0,    1.141172e+08,    0,                   0}, //   70BR
{   35,   71,               0,    3.087367e+10,    0,                   0}, //   71BR
{   35,   72,               0,    1.133958e+11,    2,            3.03e-27}, //   72BR
{   35,   73,               0,    2.943098e+11,    0,                   0}, //   73BR
{   35,   74,               0,    2.198667e+12,    0,                   0}, //   74BR
{   35,   75,               0,    8.370517e+12,    3,           3.838e-27}, //   75BR
{   35,   76,               0,    8.413797e+13,    2,         2.76846e-27}, //   76BR
{   35,   77,               0,     2.96243e+14,    3,         4.91769e-27}, //   77BR
{   35,   78,               0,     5.58323e+11,    2,           6.565e-28}, //   78BR
{   35,   79,               0,              -1,    3,        1.063732e-26}, //   79BR
{   35,   80,               0,    1.530411e+12,    2,          2.5957e-27}, //   80BR
{   35,   81,               0,              -1,    3,      1.14663381e-26}, //   81BR
{   35,   82,               0,    1.832511e+14,   10,         8.21635e-27}, //   82BR
{   35,   83,               0,    1.246489e+13,    0,                   0}, //   83BR
{   35,   84,               0,      2.7492e+12,    4,           9.595e-27}, //   84BR
{   35,   85,               0,    2.510289e+11,    0,                   0}, //   85BR
{   35,   86,               0,     7.94925e+10,    0,                   0}, //   86BR
{   35,   87,               0,    8.028598e+10,    0,                   0}, //   87BR
{   35,   88,               0,     2.35015e+10,    0,                   0}, //   88BR
{   35,   89,               0,    6.347858e+09,    0,                   0}, //   89BR
{   35,   90,               0,    2.755548e+09,    0,                   0}, //   90BR
{   35,   91,               0,     7.80498e+08,    0,                   0}, //   91BR
{   35,   92,               0,    4.948444e+08,    0,                   0}, //   92BR
{   35,   93,               0,    1.471549e+08,    0,                   0}, //   93BR
{   35,   94,               0,    1.009887e+08,    0,                   0}, //   94BR
{   35,   95,               0,        216.4043,    0,                   0}, //   95BR
{   35,   96,               0,        216.4043,    0,                   0}, //   96BR
{   35,   97,               0,        432.8085,    0,                   0}, //   97BR
{   35,   98,               0,        914.6687,    0,                   0}, //   98BR
{   36,   69,               0,    4.616624e+07,    0,                   0}, //   69KR
{   36,   70,               0,    7.502014e+07,    0,                   0}, //   70KR
{   36,   71,               0,    1.442695e+08,    0,                   0}, //   71KR
{   36,   72,               0,    2.467009e+10,    0,                   0}, //   72KR
{   36,   73,               0,    3.938557e+10,    0,                   0}, //   73KR
{   36,   74,               0,    9.954596e+11,    0,                   0}, //   74KR
{   36,   75,               0,    3.713497e+11,    5,        -2.68155e-27}, //   75KR
{   36,   76,               0,    7.686679e+13,    0,                   0}, //   76KR
{   36,   77,               0,    6.440191e+12,    5,        -2.94415e-27}, //   77KR
{   36,   78,               0,              -1,    0,                   0}, //   78KR
{   36,   79,               0,    1.819816e+14,    1,          2.7068e-27}, //   79KR
{   36,   80,               0,              -1,    0,                   0}, //   80KR
{   36,   81,               0,    1.042592e+22,    7,         -4.5854e-27}, //   81KR
{   36,   82,               0,              -1,    0,                   0}, //   82KR
{   36,   83,               0,              -1,    9,     -4.90187845e-27}, //   83KR
{   36,   84,               0,              -1,    0,                   0}, //   84KR
{   36,   85,               0,     4.89694e+17,    9,       -5.062625e-27}, //   85KR
{   36,   86,               0,              -1,    0,                   0}, //   86KR
{   36,   87,               0,    6.604658e+12,    5,        -5.16615e-27}, //   87KR
{   36,   88,               0,    1.475011e+13,    0,                   0}, //   88KR
{   36,   89,               0,    2.726694e+11,    0,                   0}, //   89KR
{   36,   90,               0,     4.66279e+10,    0,                   0}, //   90KR
{   36,   91,               0,     1.23639e+10,    0,                   0}, //   91KR
{   36,   92,               0,    2.654559e+09,    0,                   0}, //   92KR
{   36,   93,               0,    1.855306e+09,    1,        -2.08565e-27}, //   93KR
{   36,   94,               0,    3.058513e+08,    0,                   0}, //   94KR
{   36,   95,               0,    1.644672e+08,    0,                   0}, //   95KR
{   36,   96,               0,    1.154156e+08,    0,                   0}, //   96KR
{   36,   97,               0,    9.088979e+07,    0,                   0}, //   97KR
{   36,   98,               0,    6.636397e+07,    0,                   0}, //   98KR
{   36,   99,               0,    1.875504e+07,    0,                   0}, //   99KR
{   36,  100,               0,    1.009887e+07,    0,                   0}, //  100KR
{   36,  101,               0,        916.1114,    0,                   0}, //  101KR
{   37,   73,               0,        43.28085,    0,                   0}, //   73RB
{   37,   74,               0,    9.345201e+07,    0,                   0}, //   74RB
{   37,   75,               0,    2.741121e+10,    0,                   0}, //   75RB
{   37,   76,               0,    5.265837e+10,    0,                   0}, //   76RB
{   37,   77,               0,    3.272032e+11,    3,        3.305063e-27}, //   77RB
{   37,   78,               0,     1.52868e+12,    0,                   0}, //   78RB
{   37,   79,               0,    1.982263e+12,    5,        1.695739e-26}, //   79RB
{   37,   80,               0,    4.818601e+10,    2,         -4.2218e-28}, //   80RB
{   37,   81,               0,    2.374532e+13,    3,        1.040047e-26}, //   81RB
{   37,   82,               0,    1.088513e+11,    2,        2.800267e-27}, //   82RB
{   37,   83,               0,    1.074476e+16,    5,           7.171e-27}, //   83RB
{   37,   84,               0,    4.090906e+15,    4,       -6.686786e-27}, //   84RB
{   37,   85,               0,              -1,    5,         6.85285e-27}, //   85RB
{   37,   86,               0,    2.323749e+15,    4,         -8.5446e-27}, //   86RB
{   37,   87,               0,    2.189867e+27,    3,        1.389412e-26}, //   87RB
{   37,   88,               0,     1.53849e+12,    4,        2.584085e-27}, //   88RB
{   37,   89,               0,     1.31141e+12,    3,        1.203718e-26}, //   89RB
{   37,   90,               0,    2.279458e+11,    0,                   0}, //   90RB
{   37,   91,               0,    8.425339e+10,    0,                   0}, //   91RB
{   37,   92,               0,    6.480586e+09,    0,                   0}, //   92RB
{   37,   93,               0,    8.425339e+09,    5,        7.117975e-27}, //   93RB
{   37,   94,               0,    3.898162e+09,    0,                   0}, //   94RB
{   37,   95,               0,    5.449059e+08,    5,         6.73468e-27}, //   95RB
{   37,   96,               0,    2.928671e+08,    0,                   0}, //   96RB
{   37,   97,               0,    2.439597e+08,    3,         9.29705e-27}, //   97RB
{   37,   98,               0,    1.644672e+08,    0,                   0}, //   98RB
{   37,   99,               0,    7.790553e+07,    0,                   0}, //   99RB
{   37,  100,               0,    7.357745e+07,    0,                   0}, //  100RB
{   37,  101,               0,    4.616624e+07,    0,                   0}, //  101RB
{   37,  102,               0,    5.337972e+07,    0,                   0}, //  102RB
{   37,  103,               0,         913.226,    0,                   0}, //  103RB
{   38,   73,               0,    3.606738e+07,    0,                   0}, //   73SR
{   38,   74,               0,        1731.234,    0,                   0}, //   74SR
{   38,   75,               0,    1.024313e+08,    0,                   0}, //   75SR
{   38,   76,               0,    1.138286e+10,    0,                   0}, //   76SR
{   38,   77,               0,    1.298426e+10,    0,                   0}, //   77SR
{   38,   78,               0,    2.308312e+11,    0,                   0}, //   78SR
{   38,   79,               0,    1.947638e+11,    0,                   0}, //   79SR
{   38,   80,               0,    9.201509e+12,    0,                   0}, //   80SR
{   38,   81,               0,    1.930326e+12,    1,         2.74215e-27}, //   81SR
{   38,   82,               0,    3.159791e+15,    0,                   0}, //   82SR
{   38,   83,               0,    1.683337e+14,    7,        -4.18645e-27}, //   83SR
{   38,   84,               0,              -1,    0,                   0}, //   84SR
{   38,   85,               0,    8.082266e+15,    9,        -5.04697e-27}, //   85SR
{   38,   86,               0,              -1,    0,                   0}, //   86SR
{   38,   87,               0,              -1,    9,        -5.51864e-27}, //   87SR
{   38,   88,               0,              -1,    0,                   0}, //   88SR
{   38,   89,               0,    6.298518e+15,    5,       -5.797905e-27}, //   89SR
{   38,   90,               0,    1.310746e+18,    0,                   0}, //   90SR
{   38,   91,               0,    5.001535e+13,    5,        -4.47834e-27}, //   91SR
{   38,   92,               0,    1.381525e+13,    0,                   0}, //   92SR
{   38,   93,               0,    6.431534e+11,    5,        -4.00263e-27}, //   93SR
{   38,   94,               0,    1.086349e+11,    0,                   0}, //   94SR
{   38,   95,               0,    3.448041e+10,    1,        -2.71185e-27}, //   95SR
{   38,   96,               0,    1.543684e+09,    0,                   0}, //   96SR
{   38,   97,               0,    6.189162e+08,    1,       -2.516415e-27}, //   97SR
{   38,   98,               0,    9.420799e+08,    0,                   0}, //   98SR
{   38,   99,               0,     3.88085e+08,    3,        -1.31805e-27}, //   99SR
{   38,  100,               0,    2.914244e+08,    0,                   0}, //  100SR
{   38,  101,               0,     1.70238e+08,    0,                   0}, //  101SR
{   38,  102,               0,    9.954596e+07,    0,                   0}, //  102SR
{   38,  103,               0,        216.4043,    0,                   0}, //  103SR
{   38,  106,               0,        565.5365,    0,                   0}, //  106SR
{   38,  107,               0,        569.8645,    0,                   0}, //  107SR
{   39,   76,               0,         288.539,    0,                   0}, //    76Y
{   39,   77,               0,    8.223362e+07,    0,                   0}, //    77Y
{   39,   78,               0,    7.646284e+07,    0,                   0}, //    78Y
{   39,   79,               0,    2.135189e+10,    0,                   0}, //    79Y
{   39,   80,               0,    4.342512e+10,    0,                   0}, //    80Y
{   39,   81,               0,    1.015657e+11,    0,                   0}, //    81Y
{   39,   82,               0,    1.197437e+10,    0,                   0}, //    82Y
{   39,   83,               0,    6.128569e+11,    0,                   0}, //    83Y
{   39,   84,               0,    3.419187e+12,    0,                   0}, //    84Y
{   39,   85,               0,    1.391912e+13,    0,                   0}, //    85Y
{   39,   86,               0,    7.655517e+13,    8,            3.03e-27}, //    86Y
{   39,   87,               0,    4.144574e+14,    0,                   0}, //    87Y
{   39,   88,               0,    1.329083e+16,    0,                   0}, //    88Y
{   39,   89,               0,              -1,    1,      -6.9394777e-28}, //    89Y
{   39,   90,               0,    3.323969e+14,    4,         -8.2315e-27}, //    90Y
{   39,   91,               0,    7.293256e+15,    1,         8.28705e-28}, //    91Y
{   39,   92,               0,    1.838571e+13,    0,                   0}, //    92Y
{   39,   93,               0,    5.287189e+13,    1,         -7.0195e-28}, //    93Y
{   39,   94,               0,    1.618704e+12,    0,                   0}, //    94Y
{   39,   95,               0,    8.915855e+11,    1,           -8.08e-28}, //    95Y
{   39,   96,               0,    7.703992e+09,    0,                   0}, //    96Y
{   39,   97,               0,    5.410106e+09,    0,                   0}, //    97Y
{   39,   98,               0,    7.905969e+08,    0,                   0}, //    98Y
{   39,   99,               0,    2.140959e+09,    0,                   0}, //    99Y
{   39,  100,               0,    1.060381e+09,    0,                   0}, //   100Y
{   39,  101,               0,    6.492128e+08,    0,                   0}, //   101Y
{   39,  103,               0,    3.318199e+08,    0,                   0}, //   103Y
{   39,  104,               0,    2.596851e+08,    0,                   0}, //   104Y
{   39,  106,               0,        216.4043,    0,                   0}, //   106Y
{   39,  107,               0,    4.328085e+07,    0,                   0}, //   107Y
{   39,  108,               0,        910.3406,    0,                   0}, //   108Y
{   39,  109,               0,        566.9792,    0,                   0}, //   109Y
{   40,   78,               0,        245.2582,    0,                   0}, //   78ZR
{   40,   79,               0,    8.079092e+07,    0,                   0}, //   79ZR
{   40,   80,               0,    6.636397e+09,    0,                   0}, //   80ZR
{   40,   81,               0,    7.934823e+09,    0,                   0}, //   81ZR
{   40,   82,               0,    4.616624e+10,    0,                   0}, //   82ZR
{   40,   83,               0,    6.001611e+10,    0,                   0}, //   83ZR
{   40,   84,               0,    2.233292e+12,    0,                   0}, //   84ZR
{   40,   85,               0,     6.80375e+11,    0,                   0}, //   85ZR
{   40,   86,               0,    8.569609e+13,    0,                   0}, //   86ZR
{   40,   87,               0,     8.72542e+12,    0,                   0}, //   87ZR
{   40,   88,               0,    1.039577e+16,    0,                   0}, //   88ZR
{   40,   89,               0,     4.07244e+14,    9,         -5.4338e-27}, //   89ZR
{   40,   90,               0,              -1,    0,                   0}, //   90ZR
{   40,   91,               0,              -1,    5,       -6.583281e-27}, //   91ZR
{   40,   92,               0,              -1,    0,                   0}, //   92ZR
{   40,   93,               0,    7.330045e+22,    0,                   0}, //   93ZR
{   40,   94,               0,              -1,    0,                   0}, //   94ZR
{   40,   95,               0,    7.981566e+15,    5,          5.7065e-27}, //   95ZR
{   40,   96,               0,     9.10557e+35,    0,                   0}, //   96ZR
{   40,   97,               0,    8.698874e+13,    1,        -4.73185e-27}, //   97ZR
{   40,   98,               0,    4.429074e+10,    0,                   0}, //   98ZR
{   40,   99,               0,     3.02966e+09,    0,                   0}, //   99ZR
{   40,  100,               0,    1.024313e+10,    0,                   0}, //  100ZR
{   40,  101,               0,    3.318199e+09,    0,                   0}, //  101ZR
{   40,  102,               0,    4.183816e+09,    0,                   0}, //  102ZR
{   40,  103,               0,    1.875504e+09,    0,                   0}, //  103ZR
{   40,  104,               0,    1.731234e+09,    0,                   0}, //  104ZR
{   40,  105,               0,     8.65617e+08,    0,                   0}, //  105ZR
{   40,  106,               0,    2.755548e+08,    0,                   0}, //  106ZR
{   40,  107,               0,    2.164043e+08,    0,                   0}, //  107ZR
{   40,  108,               0,    1.053167e+08,    0,                   0}, //  108ZR
{   40,  110,               0,    5.337972e+07,    0,                   0}, //  110ZR
{   40,  111,               0,        565.5365,    0,                   0}, //  111ZR
{   40,  112,               0,        568.4218,    0,                   0}, //  112ZR
{   41,   81,               0,         288.539,    0,                   0}, //   81NB
{   41,   82,               0,    7.213475e+07,    0,                   0}, //   82NB
{   41,   83,               0,     5.91505e+09,    0,                   0}, //   83NB
{   41,   84,               0,    1.413841e+10,    0,                   0}, //   84NB
{   41,   85,               0,    3.015233e+10,    0,                   0}, //   85NB
{   41,   87,               0,    3.246064e+11,    0,                   0}, //   87NB
{   41,   88,               0,    1.259473e+12,    0,                   0}, //   88NB
{   41,   89,               0,    1.054322e+13,    0,                   0}, //   89NB
{   41,   90,               0,    7.582805e+13,   16,        2.505305e-26}, //   90NB
{   41,   91,               0,    3.095879e+19,    0,                   0}, //   91NB
{   41,   92,               0,    1.579751e+24,    0,                   0}, //   92NB
{   41,   93,               0,              -1,    9,       3.1161025e-26}, //   93NB
{   41,   94,               0,    9.242193e+20,    0,                   0}, //   94NB
{   41,   95,               0,    4.361556e+15,    9,        3.101205e-26}, //   95NB
{   41,   96,               0,    1.212729e+14,   12,         2.51288e-26}, //   96NB
{   41,   97,               0,    6.241099e+12,    9,        3.107265e-26}, //   97NB
{   41,   98,               0,    4.126108e+09,    0,                   0}, //   98NB
{   41,   99,               0,    2.164043e+10,    9,         3.01485e-26}, //   99NB
{   41,  100,               0,    2.164043e+09,    0,                   0}, //  100NB
{   41,  101,               0,    1.024313e+10,    0,                   0}, //  101NB
{   41,  102,               0,    6.203589e+09,    0,                   0}, //  102NB
{   41,  103,               0,    2.164043e+09,    0,                   0}, //  103NB
{   41,  104,               0,    7.069206e+09,    0,                   0}, //  104NB
{   41,  105,               0,     4.25595e+09,    0,                   0}, //  105NB
{   41,  106,               0,    1.341706e+09,    0,                   0}, //  106NB
{   41,  107,               0,    4.328085e+08,    0,                   0}, //  107NB
{   41,  108,               0,    2.784401e+08,    0,                   0}, //  108NB
{   41,  109,               0,    2.741121e+08,    0,                   0}, //  109NB
{   41,  110,               0,     1.18301e+08,    0,                   0}, //  110NB
{   41,  111,               0,    1.154156e+08,    0,                   0}, //  111NB
{   41,  112,               0,        216.4043,    0,                   0}, //  112NB
{   41,  113,               0,    4.328085e+07,    0,                   0}, //  113NB
{   41,  114,               0,        565.5365,    0,                   0}, //  114NB
{   41,  115,               0,        568.4218,    0,                   0}, //  115NB
{   42,   83,               0,     5.77078e+08,    0,                   0}, //   83MO
{   42,   84,               0,    3.318199e+09,    0,                   0}, //   84MO
{   42,   85,               0,        216.4043,    0,                   0}, //   85MO
{   42,   86,               0,    2.827682e+10,    0,                   0}, //   86MO
{   42,   87,               0,    2.022658e+10,    0,                   0}, //   87MO
{   42,   88,               0,    6.924936e+11,    0,                   0}, //   88MO
{   42,   89,               0,    1.826452e+11,    0,                   0}, //   89MO
{   42,   90,               0,    2.887698e+13,    0,                   0}, //   90MO
{   42,   91,               0,    1.340841e+12,    0,                   0}, //   91MO
{   42,   92,               0,              -1,    0,                   0}, //   92MO
{   42,   93,               0,    1.821114e+20,    0,                   0}, //   93MO
{   42,   94,               0,              -1,    0,                   0}, //   94MO
{   42,   95,               0,              -1,    5,        -4.61671e-27}, //   95MO
{   42,   96,               0,              -1,    0,                   0}, //   96MO
{   42,   97,               0,              -1,    5,       -4.714175e-27}, //   97MO
{   42,   98,               0,              -1,    0,                   0}, //   98MO
{   42,   99,               0,    3.426545e+14,    1,         1.89375e-27}, //   99MO
{   42,  100,               0,    3.323537e+35,    0,                   0}, //  100MO
{   42,  101,               0,    1.264666e+12,    0,                   0}, //  101MO
{   42,  102,               0,    9.781472e+11,    0,                   0}, //  102MO
{   42,  103,               0,    9.738192e+10,    0,                   0}, //  103MO
{   42,  104,               0,     8.65617e+10,    0,                   0}, //  104MO
{   42,  105,               0,    5.135994e+10,    0,                   0}, //  105MO
{   42,  106,               0,    1.259473e+10,    0,                   0}, //  106MO
{   42,  107,               0,    5.049433e+09,    0,                   0}, //  107MO
{   42,  108,               0,    1.572538e+09,    0,                   0}, //  108MO
{   42,  109,               0,    7.646284e+08,    0,                   0}, //  109MO
{   42,  110,               0,    4.270377e+08,    0,                   0}, //  110MO
{   42,  111,               0,     2.88539e+08,    0,                   0}, //  111MO
{   42,  113,               0,    1.442695e+08,    0,                   0}, //  113MO
{   42,  114,               0,     8.65617e+07,    0,                   0}, //  114MO
{   42,  115,               0,        561.2084,    0,                   0}, //  115MO
{   42,  116,               0,        564.0938,    0,                   0}, //  116MO
{   42,  117,               0,        566.9792,    0,                   0}, //  117MO
{   43,   86,               0,    7.790553e+07,    0,                   0}, //   86TC
{   43,   87,               0,    3.173929e+09,    0,                   0}, //   87TC
{   43,   89,               0,     1.84665e+10,    0,                   0}, //   89TC
{   43,   91,               0,    2.718037e+11,    0,                   0}, //   91TC
{   43,   92,               0,    3.678872e+11,    0,                   0}, //   92TC
{   43,   93,               0,    1.428268e+13,    9,          3.1916e-26}, //   93TC
{   43,   94,               0,    2.536258e+13,   14,          2.5654e-26}, //   94TC
{   43,   95,               0,     1.03874e+14,    9,          2.9997e-26}, //   95TC
{   43,   96,               0,    5.334942e+14,   14,          2.5452e-26}, //   96TC
{   43,   97,               0,    1.916765e+23,    0,                   0}, //   97TC
{   43,   98,               0,    1.912148e+23,    0,                   0}, //   98TC
{   43,   99,               0,    9.610946e+21,    9,        2.870774e-26}, //   99TC
{   43,  100,               0,    2.230407e+10,    0,                   0}, //  100TC
{   43,  101,               0,    1.230907e+12,    0,                   0}, //  101TC
{   43,  102,               0,     7.61743e+09,    0,                   0}, //  102TC
{   43,  103,               0,    7.819407e+10,    0,                   0}, //  103TC
{   43,  104,               0,    1.584079e+12,    0,                   0}, //  104TC
{   43,  105,               0,    6.578689e+11,    0,                   0}, //  105TC
{   43,  106,               0,    5.135994e+10,    0,                   0}, //  106TC
{   43,  107,               0,    3.058513e+10,    0,                   0}, //  107TC
{   43,  108,               0,    7.458733e+09,    0,                   0}, //  108TC
{   43,  109,               0,    1.240718e+09,    0,                   0}, //  109TC
{   43,  110,               0,    1.298426e+09,    0,                   0}, //  110TC
{   43,  111,               0,    4.183816e+08,    0,                   0}, //  111TC
{   43,  112,               0,    4.039546e+08,    0,                   0}, //  112TC
{   43,  113,               0,    2.308312e+08,    0,                   0}, //  113TC
{   43,  115,               0,    1.053167e+08,    0,                   0}, //  115TC
{   43,  116,               0,    1.298426e+08,    0,                   0}, //  116TC
{   43,  117,               0,     5.77078e+07,    0,                   0}, //  117TC
{   43,  119,               0,        565.5365,    0,                   0}, //  119TC
{   43,  120,               0,        568.4218,    0,                   0}, //  120TC
{   44,   88,               0,    1.731234e+09,    0,                   0}, //   88RU
{   44,   89,               0,    2.164043e+09,    0,                   0}, //   89RU
{   44,   90,               0,    1.586965e+10,    0,                   0}, //   90RU
{   44,   91,               0,    1.298426e+10,    0,                   0}, //   91RU
{   44,   92,               0,    3.159502e+11,    0,                   0}, //   92RU
{   44,   93,               0,    8.612889e+10,    0,                   0}, //   93RU
{   44,   94,               0,    4.483896e+12,    0,                   0}, //   94RU
{   44,   95,               0,    8.533253e+12,    0,                   0}, //   95RU
{   44,   96,               0,              -1,    0,                   0}, //   96RU
{   44,   97,               0,    3.527534e+14,    0,                   0}, //   97RU
{   44,   98,               0,              -1,    0,                   0}, //   98RU
{   44,   99,               0,              -1,    5,        -3.23705e-27}, //   99RU
{   44,  100,               0,              -1,    0,                   0}, //  100RU
{   44,  101,               0,              -1,    5,        -3.63095e-27}, //  101RU
{   44,  102,               0,              -1,    0,                   0}, //  102RU
{   44,  103,               0,    4.892035e+15,    3,            1.01e-27}, //  103RU
{   44,  104,               0,              -1,    0,                   0}, //  104RU
{   44,  105,               0,    2.306004e+13,    0,                   0}, //  105RU
{   44,  106,               0,    4.634514e+16,    0,                   0}, //  106RU
{   44,  107,               0,    3.246064e+11,    0,                   0}, //  107RU
{   44,  108,               0,    3.938557e+11,    0,                   0}, //  108RU
{   44,  109,               0,    4.977298e+10,    0,                   0}, //  109RU
{   44,  110,               0,    1.737005e+10,    0,                   0}, //  110RU
{   44,  111,               0,    3.058513e+09,    0,                   0}, //  111RU
{   44,  112,               0,    2.524716e+09,    0,                   0}, //  112RU
{   44,  113,               0,    1.154156e+09,    0,                   0}, //  113RU
{   44,  114,               0,    7.790553e+08,    0,                   0}, //  114RU
{   44,  115,               0,    1.067594e+09,    0,                   0}, //  115RU
{   44,  116,               0,    2.943098e+08,    0,                   0}, //  116RU
{   44,  117,               0,    2.048627e+08,    0,                   0}, //  117RU
{   44,  118,               0,    1.774515e+08,    0,                   0}, //  118RU
{   44,  119,               0,        432.8085,    0,                   0}, //  119RU
{   44,  120,               0,        216.4043,    0,                   0}, //  120RU
{   44,  121,               0,        562.6511,    0,                   0}, //  121RU
{   44,  122,               0,        565.5365,    0,                   0}, //  122RU
{   44,  123,               0,        568.4218,    0,                   0}, //  123RU
{   44,  124,               0,        571.3072,    0,                   0}, //  124RU
{   45,   89,               0,        2164.043,    0,                   0}, //   89RH
{   45,   90,               0,        216.4043,    0,                   0}, //   90RH
{   45,   91,               0,        144.2695,    0,                   0}, //   91RH
{   45,   92,               0,    4.183816e+09,    0,                   0}, //   92RH
{   45,   93,               0,    1.760088e+10,    0,                   0}, //   93RH
{   45,   94,               0,    1.018543e+11,    0,                   0}, //   94RH
{   45,   95,               0,    4.345397e+11,    0,                   0}, //   95RH
{   45,   96,               0,    8.569609e+11,    0,                   0}, //   96RH
{   45,   97,               0,    2.657444e+12,    0,                   0}, //   97RH
{   45,   98,               0,     7.54818e+11,    0,                   0}, //   98RH
{   45,   99,               0,    2.006789e+15,    0,                   0}, //   99RH
{   45,  100,               0,     1.08029e+14,    0,                   0}, //  100RH
{   45,  101,               0,    1.502423e+17,    0,                   0}, //  101RH
{   45,  102,               0,    2.584011e+16,    0,                   0}, //  102RH
{   45,  103,               0,              -1,    1,         -4.4642e-28}, //  103RH
{   45,  104,               0,      6.1026e+10,    0,                   0}, //  104RH
{   45,  105,               0,    1.836551e+14,    7,         2.24826e-26}, //  105RH
{   45,  106,               0,    4.338184e+10,    2,        1.300375e-26}, //  106RH
{   45,  107,               0,    1.878389e+12,    0,                   0}, //  107RH
{   45,  108,               0,    2.423728e+10,    0,                   0}, //  108RH
{   45,  109,               0,    1.154156e+11,    0,                   0}, //  109RH
{   45,  110,               0,    4.833028e+09,    0,                   0}, //  110RH
{   45,  111,               0,    1.586965e+10,    0,                   0}, //  111RH
{   45,  113,               0,    4.039546e+09,    0,                   0}, //  113RH
{   45,  114,               0,    2.668986e+09,    0,                   0}, //  114RH
{   45,  115,               0,    1.428268e+09,    0,                   0}, //  115RH
{   45,  116,               0,    9.810326e+08,    0,                   0}, //  116RH
{   45,  117,               0,    6.347858e+08,    0,                   0}, //  117RH
{   45,  118,               0,    3.837569e+08,    0,                   0}, //  118RH
{   45,  119,               0,    2.467009e+08,    0,                   0}, //  119RH
{   45,  120,               0,    1.962065e+08,    0,                   0}, //  120RH
{   45,  121,               0,     2.17847e+08,    0,                   0}, //  121RH
{   45,  122,               0,        432.8085,    0,                   0}, //  122RH
{   45,  123,               0,        581.4061,    0,                   0}, //  123RH
{   45,  124,               0,        564.0938,    0,                   0}, //  124RH
{   45,  125,               0,        566.9792,    0,                   0}, //  125RH
{   45,  126,               0,        569.8645,    0,                   0}, //  126RH
{   46,   92,               0,    1.009887e+09,    0,                   0}, //   92PD
{   46,   93,               0,    1.442695e+09,    0,                   0}, //   93PD
{   46,   94,               0,    1.298426e+10,    0,                   0}, //   94PD
{   46,   95,               0,    7.213475e+09,    0,                   0}, //   95PD
{   46,   96,               0,    1.760088e+11,    0,                   0}, //   96PD
{   46,   97,               0,    2.683413e+11,    0,                   0}, //   97PD
{   46,   98,               0,    1.532142e+12,    0,                   0}, //   98PD
{   46,   99,               0,     1.85242e+12,    0,                   0}, //   99PD
{   46,  100,               0,    4.524724e+14,    0,                   0}, //  100PD
{   46,  101,               0,    4.399066e+13,    5,          -3.333e-27}, //  101PD
{   46,  102,               0,              -1,    0,                   0}, //  102PD
{   46,  103,               0,    2.117876e+15,    0,                   0}, //  103PD
{   46,  104,               0,              -1,    0,                   0}, //  104PD
{   46,  105,               0,              -1,    5,         -3.2421e-27}, //  105PD
{   46,  106,               0,              -1,    0,                   0}, //  106PD
{   46,  107,               0,    2.959256e+23,    0,                   0}, //  107PD
{   46,  108,               0,              -1,    0,                   0}, //  108PD
{   46,  109,               0,    7.115949e+13,    0,                   0}, //  109PD
{   46,  110,               0,              -1,    0,                   0}, //  110PD
{   46,  111,               0,    2.025544e+12,    0,                   0}, //  111PD
{   46,  112,               0,    1.092236e+14,    0,                   0}, //  112PD
{   46,  113,               0,    1.341706e+11,    0,                   0}, //  113PD
{   46,  114,               0,    2.094793e+11,    0,                   0}, //  114PD
{   46,  115,               0,    3.606738e+10,    0,                   0}, //  115PD
{   46,  116,               0,     1.70238e+10,    0,                   0}, //  116PD
{   46,  117,               0,    6.203589e+09,    0,                   0}, //  117PD
{   46,  118,               0,    2.741121e+09,    0,                   0}, //  118PD
{   46,  119,               0,    1.327279e+09,    0,                   0}, //  119PD
{   46,  120,               0,    7.213475e+08,    0,                   0}, //  120PD
{   46,  121,               0,    4.111681e+08,    0,                   0}, //  121PD
{   46,  122,               0,    2.524716e+08,    0,                   0}, //  122PD
{   46,  123,               0,        216.4043,    0,                   0}, //  123PD
{   46,  124,               0,    5.482241e+07,    0,                   0}, //  124PD
{   46,  125,               0,        331.8199,    0,                   0}, //  125PD
{   46,  126,               0,        331.8199,    0,                   0}, //  126PD
{   46,  128,               0,        568.4218,    0,                   0}, //  128PD
{   47,   94,               0,    3.751007e+07,    0,                   0}, //   94AG
{   47,   95,               0,    2.524716e+09,    0,                   0}, //   95AG
{   47,   97,               0,    3.678872e+10,    0,                   0}, //   97AG
{   47,   98,               0,    6.852801e+10,    0,                   0}, //   98AG
{   47,   99,               0,    1.788942e+11,    0,                   0}, //   99AG
{   47,  100,               0,     1.73989e+11,    0,                   0}, //  100AG
{   47,  101,               0,    9.608349e+11,    9,        2.841635e-26}, //  101AG
{   47,  102,               0,    1.116646e+12,    0,                   0}, //  102AG
{   47,  103,               0,    5.687104e+12,    7,         2.25735e-26}, //  103AG
{   47,  104,               0,     5.99007e+12,   10,        1.979095e-26}, //  104AG
{   47,  105,               0,    5.146815e+15,    1,          5.1207e-28}, //  105AG
{   47,  106,               0,    2.074018e+12,    2,         1.43925e-26}, //  106AG
{   47,  107,               0,              -1,    1,       -5.735285e-28}, //  107AG
{   47,  108,               0,      2.0619e+11,    2,        1.357642e-26}, //  108AG
{   47,  109,               0,              -1,    1,      -6.5934315e-28}, //  109AG
{   47,  110,               0,    3.543259e+10,    0,                   0}, //  110AG
{   47,  111,               0,    9.286339e+14,    1,          -7.373e-28}, //  111AG
{   47,  112,               0,    1.625629e+13,    0,                   0}, //  112AG
{   47,  113,               0,    2.789018e+13,    1,          8.0295e-28}, //  113AG
{   47,  114,               0,    6.636397e+09,    0,                   0}, //  114AG
{   47,  115,               0,    1.731234e+12,    0,                   0}, //  115AG
{   47,  116,               0,    3.318199e+11,    0,                   0}, //  116AG
{   47,  117,               0,    1.050282e+11,    0,                   0}, //  117AG
{   47,  118,               0,    5.424533e+09,    0,                   0}, //  118AG
{   47,  120,               0,    1.774515e+09,    0,                   0}, //  120AG
{   47,  121,               0,    1.125302e+09,    0,                   0}, //  121AG
{   47,  122,               0,    7.631857e+08,    0,                   0}, //  122AG
{   47,  123,               0,    4.328085e+08,    0,                   0}, //  123AG
{   47,  124,               0,    2.481435e+08,    0,                   0}, //  124AG
{   47,  125,               0,    2.394874e+08,    0,                   0}, //  125AG
{   47,  126,               0,    1.543684e+08,    0,                   0}, //  126AG
{   47,  127,               0,    1.572538e+08,    0,                   0}, //  127AG
{   47,  128,               0,    8.367631e+07,    0,                   0}, //  128AG
{   47,  129,               0,    6.636397e+07,    0,                   0}, //  129AG
{   48,   96,               0,    1.485976e+09,    0,                   0}, //   96CD
{   48,   97,               0,    4.039546e+09,    0,                   0}, //   97CD
{   48,   98,               0,    1.327279e+10,    0,                   0}, //   98CD
{   48,   99,               0,    2.308312e+10,    0,                   0}, //   99CD
{   48,  100,               0,    7.083633e+10,    0,                   0}, //  100CD
{   48,  101,               0,    1.177239e+11,    0,                   0}, //  101CD
{   48,  102,               0,    4.760894e+11,    0,                   0}, //  102CD
{   48,  103,               0,    6.319004e+11,    0,                   0}, //  103CD
{   48,  104,               0,     4.99461e+12,    0,                   0}, //  104CD
{   48,  105,               0,    4.804174e+12,    5,       -3.733465e-27}, //  105CD
{   48,  106,               0,              -1,    0,                   0}, //  106CD
{   48,  107,               0,    3.375906e+13,    5,        -3.10603e-27}, //  107CD
{   48,  108,               0,              -1,    0,                   0}, //  108CD
{   48,  109,               0,    5.751304e+16,    5,       -4.180623e-27}, //  109CD
{   48,  110,               0,              -1,    0,                   0}, //  110CD
{   48,  111,               0,              -1,    1,    -3.004174805e-27}, //  111CD
{   48,  112,               0,              -1,    0,                   0}, //  112CD
{   48,  113,               0,    3.660406e+32,    1,        -3.14262e-27}, //  113CD
{   48,  114,               0,              -1,    0,                   0}, //  114CD
{   48,  115,               0,    2.776611e+14,    1,       -3.274551e-27}, //  115CD
{   48,  116,               0,    1.502423e+36,    0,                   0}, //  116CD
{   48,  117,               0,    1.293232e+13,    0,                   0}, //  117CD
{   48,  118,               0,    4.354054e+12,    0,                   0}, //  118CD
{   48,  119,               0,     2.32851e+11,    0,                   0}, //  119CD
{   48,  120,               0,    7.328891e+10,    0,                   0}, //  120CD
{   48,  121,               0,    1.947638e+10,    0,                   0}, //  121CD
{   48,  122,               0,    7.559722e+09,    0,                   0}, //  122CD
{   48,  123,               0,     3.02966e+09,    0,                   0}, //  123CD
{   48,  124,               0,    1.803369e+09,    0,                   0}, //  124CD
{   48,  125,               0,    9.810326e+08,    0,                   0}, //  125CD
{   48,  126,               0,    7.429879e+08,    0,                   0}, //  126CD
{   48,  127,               0,    5.337972e+08,    0,                   0}, //  127CD
{   48,  128,               0,    4.039546e+08,    0,                   0}, //  128CD
{   48,  129,               0,    3.895277e+08,    0,                   0}, //  129CD
{   48,  130,               0,    2.337166e+08,    0,                   0}, //  130CD
{   48,  131,               0,    9.810326e+07,    0,                   0}, //  131CD
{   48,  132,               0,    1.399414e+08,    0,                   0}, //  132CD
{   48,  133,               0,    8.223362e+07,    0,                   0}, //  133CD
{   49,   99,               0,    4.328085e+09,    0,                   0}, //   99IN
{   49,  100,               0,    8.511901e+09,    0,                   0}, //  100IN
{   49,  101,               0,     2.17847e+10,    0,                   0}, //  101IN
{   49,  102,               0,    3.361479e+10,    0,                   0}, //  102IN
{   49,  103,               0,    9.377518e+10,    0,                   0}, //  103IN
{   49,  104,               0,    1.558111e+11,    0,                   0}, //  104IN
{   49,  105,               0,    4.388678e+11,    9,        2.865875e-26}, //  105IN
{   49,  106,               0,    5.366826e+11,   14,         2.48258e-26}, //  106IN
{   49,  107,               0,    2.804599e+12,    9,        2.820425e-26}, //  107IN
{   49,  108,               0,    5.020579e+12,    0,                   0}, //  108IN
{   49,  109,               0,    2.164187e+13,    9,         2.79669e-26}, //  109IN
{   49,  110,               0,    2.555301e+13,   14,        2.380065e-26}, //  110IN
{   49,  111,               0,    3.496083e+14,    9,        2.779015e-26}, //  111IN
{   49,  112,               0,    1.295829e+12,    2,          1.4241e-26}, //  112IN
{   49,  113,               0,              -1,    0,                   0}, //  113IN
{   49,  114,               0,    1.037298e+11,    2,        1.422585e-26}, //  114IN
{   49,  115,               0,    2.007799e+31,    9,        2.798104e-26}, //  115IN
{   49,  116,               0,      2.0342e+10,    2,        1.407738e-26}, //  116IN
{   49,  117,               0,    3.739466e+12,    9,        2.787095e-26}, //  117IN
{   49,  118,               0,    7.213475e+09,    0,                   0}, //  118IN
{   49,  119,               0,    2.077481e+11,    9,        2.785075e-26}, //  119IN
{   49,  120,               0,    4.443501e+09,    0,                   0}, //  120IN
{   49,  121,               0,    3.332626e+10,    9,         2.77851e-26}, //  121IN
{   49,  122,               0,    2.164043e+09,    0,                   0}, //  122IN
{   49,  123,               0,    8.901428e+09,    0,                   0}, //  123IN
{   49,  124,               0,    4.501209e+09,    0,                   0}, //  124IN
{   49,  125,               0,     3.40476e+09,    9,         2.77851e-26}, //  125IN
{   49,  126,               0,    2.207323e+09,    0,                   0}, //  126IN
{   49,  127,               0,    1.572538e+09,    0,                   0}, //  127IN
{   49,  128,               0,    1.211864e+09,    0,                   0}, //  128IN
{   49,  129,               0,     8.80044e+08,    0,                   0}, //  129IN
{   49,  130,               0,    4.183816e+08,    0,                   0}, //  130IN
{   49,  131,               0,    4.039546e+08,    0,                   0}, //  131IN
{   49,  132,               0,    2.986379e+08,    0,                   0}, //  132IN
{   49,  133,               0,    2.380447e+08,    0,                   0}, //  133IN
{   49,  134,               0,    2.019773e+08,    0,                   0}, //  134IN
{   49,  135,               0,    1.327279e+08,    0,                   0}, //  135IN
{   50,  100,               0,    1.240718e+09,    0,                   0}, //  100SN
{   50,  101,               0,    2.452582e+09,    0,                   0}, //  101SN
{   50,  102,               0,    5.482241e+09,    0,                   0}, //  102SN
{   50,  103,               0,    1.009887e+10,    0,                   0}, //  103SN
{   50,  104,               0,    3.000806e+10,    0,                   0}, //  104SN
{   50,  105,               0,    4.905163e+10,    0,                   0}, //  105SN
{   50,  106,               0,    1.659099e+11,    0,                   0}, //  106SN
{   50,  107,               0,    2.510289e+11,    0,                   0}, //  107SN
{   50,  108,               0,    8.915855e+11,    0,                   0}, //  108SN
{   50,  109,               0,    1.558111e+12,    5,        -5.44895e-27}, //  109SN
{   50,  110,               0,    2.157406e+13,    0,                   0}, //  110SN
{   50,  111,               0,    3.055628e+12,    7,          3.0704e-27}, //  111SN
{   50,  112,               0,              -1,    0,                   0}, //  112SN
{   50,  113,               0,    1.434587e+16,    1,       -4.439455e-27}, //  113SN
{   50,  114,               0,              -1,    0,                   0}, //  114SN
{   50,  115,               0,              -1,    1,      -4.6400915e-27}, //  115SN
{   50,  116,               0,              -1,    0,                   0}, //  116SN
{   50,  117,               0,              -1,    1,       -5.055252e-27}, //  117SN
{   50,  118,               0,              -1,    0,                   0}, //  118SN
{   50,  119,               0,              -1,    1,       -5.288764e-27}, //  119SN
{   50,  120,               0,              -1,    0,                   0}, //  120SN
{   50,  121,               0,    1.403858e+14,    3,         3.52389e-27}, //  121SN
{   50,  122,               0,              -1,    0,                   0}, //  122SN
{   50,  123,               0,     1.61048e+16,   11,         -6.9185e-27}, //  123SN
{   50,  124,               0,              -1,    0,                   0}, //  124SN
{   50,  125,               0,    1.201621e+15,   11,         -6.8074e-27}, //  125SN
{   50,  126,               0,    1.047137e+22,    0,                   0}, //  126SN
{   50,  127,               0,    1.090677e+13,   11,        -6.71145e-27}, //  127SN
{   50,  128,               0,      5.1132e+12,    0,                   0}, //  128SN
{   50,  129,               0,    1.930326e+11,    0,                   0}, //  129SN
{   50,  130,               0,    3.220095e+11,    0,                   0}, //  130SN
{   50,  131,               0,    8.079092e+10,    0,                   0}, //  131SN
{   50,  132,               0,    5.727499e+10,    0,                   0}, //  132SN
{   50,  133,               0,    2.106335e+09,    0,                   0}, //  133SN
{   50,  134,               0,     1.51483e+09,    0,                   0}, //  134SN
{   50,  135,               0,    7.646284e+08,    0,                   0}, //  135SN
{   50,  136,               0,    3.606738e+08,    0,                   0}, //  136SN
{   50,  137,               0,    2.741121e+08,    0,                   0}, //  137SN
{   50,  138,               0,        588.6196,    0,                   0}, //  138SN
{   51,  104,               0,    6.347858e+08,    0,                   0}, //  104SB
{   51,  105,               0,    1.760088e+09,    0,                   0}, //  105SB
{   51,  106,               0,     8.65617e+08,    0,                   0}, //  106SB
{   51,  107,               0,     5.77078e+09,    0,                   0}, //  107SB
{   51,  108,               0,    1.067594e+10,    0,                   0}, //  108SB
{   51,  109,               0,    2.452582e+10,    0,                   0}, //  109SB
{   51,  110,               0,     3.40476e+10,    0,                   0}, //  110SB
{   51,  111,               0,    1.082021e+11,    0,                   0}, //  111SB
{   51,  112,               0,    7.415453e+10,    0,                   0}, //  112SB
{   51,  113,               0,    5.773666e+11,    0,                   0}, //  113SB
{   51,  114,               0,    3.021003e+11,    6,           8.686e-27}, //  114SB
{   51,  115,               0,    2.778631e+12,    5,          1.7473e-26}, //  115SB
{   51,  116,               0,    1.367675e+12,    6,        1.371075e-26}, //  116SB
{   51,  117,               0,    1.454237e+13,    5,         1.73215e-26}, //  117SB
{   51,  118,               0,    3.116221e+11,    2,         1.24735e-26}, //  118SB
{   51,  119,               0,    1.983417e+14,    5,         1.74225e-26}, //  119SB
{   51,  120,               0,    1.375465e+12,    2,          1.1817e-26}, //  120SB
{   51,  121,               0,              -1,    5,        1.698517e-26}, //  121SB
{   51,  122,               0,    3.395239e+14,    4,          -9.595e-27}, //  122SB
{   51,  123,               0,              -1,    7,        1.287649e-26}, //  123SB
{   51,  124,               0,     7.50389e+15,    6,            6.06e-27}, //  124SB
{   51,  125,               0,    1.255924e+17,    7,         1.32815e-26}, //  125SB
{   51,  126,               0,    1.539356e+15,    0,                   0}, //  126SB
{   51,  127,               0,    4.798981e+14,    0,                   0}, //  127SB
{   51,  128,               0,    4.679526e+13,   16,          6.6155e-27}, //  128SB
{   51,  129,               0,    2.285229e+13,    7,        1.422585e-26}, //  129SB
{   51,  130,               0,    3.419187e+12,    0,                   0}, //  130SB
{   51,  131,               0,    1.993516e+12,    0,                   0}, //  131SB
{   51,  132,               0,    2.415071e+11,    0,                   0}, //  132SB
{   51,  133,               0,    2.025544e+11,    0,                   0}, //  133SB
{   51,  134,               0,    1.125302e+09,    0,                   0}, //  134SB
{   51,  135,               0,    2.422285e+09,    0,                   0}, //  135SB
{   51,  136,               0,    1.331608e+09,    0,                   0}, //  136SB
{   51,  137,               0,    6.492128e+08,    0,                   0}, //  137SB
{   51,  139,               0,        216.4043,    0,                   0}, //  139SB
{   51,  140,               0,        587.1769,    0,                   0}, //  140SB
{   52,  105,               0,        894.4709,    0,                   0}, //  105TE
{   52,  106,               0,        100988.7,    0,                   0}, //  106TE
{   52,  107,               0,         4472355,    0,                   0}, //  107TE
{   52,  108,               0,     3.02966e+09,    0,                   0}, //  108TE
{   52,  109,               0,    6.636397e+09,    0,                   0}, //  109TE
{   52,  110,               0,    2.683413e+10,    0,                   0}, //  110TE
{   52,  111,               0,    2.784401e+10,    0,                   0}, //  111TE
{   52,  112,               0,    1.731234e+11,    0,                   0}, //  112TE
{   52,  113,               0,    1.471549e+11,    0,                   0}, //  113TE
{   52,  114,               0,    1.315738e+12,    0,                   0}, //  114TE
{   52,  115,               0,    5.020579e+11,    0,                   0}, //  115TE
{   52,  116,               0,    1.293232e+13,    0,                   0}, //  116TE
{   52,  117,               0,    5.366826e+12,    0,                   0}, //  117TE
{   52,  118,               0,    7.478931e+14,    0,                   0}, //  118TE
{   52,  119,               0,    8.335892e+13,    1,          1.2625e-27}, //  119TE
{   52,  120,               0,              -1,    0,                   0}, //  120TE
{   52,  121,               0,    2.389536e+15,    0,                   0}, //  121TE
{   52,  122,               0,              -1,    0,                   0}, //  122TE
{   52,  123,               0,    4.188577e+33,    1,       -3.721586e-27}, //  123TE
{   52,  124,               0,              -1,    0,                   0}, //  124TE
{   52,  125,               0,              -1,    1,    -4.486950755e-27}, //  125TE
{   52,  126,               0,              -1,    0,                   0}, //  126TE
{   52,  127,               0,    4.856112e+13,    3,         3.20675e-27}, //  127TE
{   52,  128,               0,    3.505605e+41,    0,                   0}, //  128TE
{   52,  129,               0,    6.024694e+12,    3,          3.5451e-27}, //  129TE
{   52,  130,               0,    3.596783e+37,    0,                   0}, //  130TE
{   52,  131,               0,    2.164043e+12,    3,          3.5148e-27}, //  131TE
{   52,  132,               0,    3.993813e+14,    0,                   0}, //  132TE
{   52,  133,               0,    1.082021e+12,    0,                   0}, //  133TE
{   52,  134,               0,    3.618279e+12,    0,                   0}, //  134TE
{   52,  135,               0,    2.741121e+10,    0,                   0}, //  135TE
{   52,  136,               0,    2.543471e+10,    0,                   0}, //  136TE
{   52,  137,               0,    3.592311e+09,    0,                   0}, //  137TE
{   52,  138,               0,    2.019773e+09,    0,                   0}, //  138TE
{   52,  139,               0,        216.4043,    0,                   0}, //  139TE
{   52,  143,               0,        588.6196,    0,                   0}, //  143TE
{   53,  108,               0,    5.193702e+07,    0,                   0}, //   108I
{   53,  109,               0,        148597.6,    0,                   0}, //   109I
{   53,  110,               0,    9.579495e+08,    0,                   0}, //   110I
{   53,  111,               0,    3.606738e+09,    0,                   0}, //   111I
{   53,  112,               0,    4.934017e+09,    0,                   0}, //   112I
{   53,  113,               0,    9.521787e+09,    0,                   0}, //   113I
{   53,  114,               0,     3.02966e+09,    0,                   0}, //   114I
{   53,  115,               0,    1.125302e+11,    0,                   0}, //   115I
{   53,  116,               0,    4.198243e+09,    0,                   0}, //   116I
{   53,  117,               0,     1.92167e+11,    0,                   0}, //   117I
{   53,  118,               0,    1.185895e+12,    4,            1.01e-26}, //   118I
{   53,  119,               0,    1.653329e+12,    0,                   0}, //   119I
{   53,  120,               0,    7.063435e+12,    0,                   0}, //   120I
{   53,  121,               0,    1.101065e+13,    5,          1.1615e-26}, //   121I
{   53,  122,               0,     3.14219e+11,    2,           4.747e-27}, //   122I
{   53,  123,               0,     6.86795e+13,    5,         1.42309e-26}, //   123I
{   53,  124,               0,    5.205388e+14,    4,          7.2922e-27}, //   124I
{   53,  125,               0,    7.405065e+15,    5,        1.424605e-26}, //   125I
{   53,  126,               0,    1.611779e+15,    4,          7.2619e-27}, //   126I
{   53,  127,               0,              -1,    5,     1.420702865e-26}, //   127I
{   53,  128,               0,    2.163177e+12,    0,                   0}, //   128I
{   53,  129,               0,    7.147833e+23,    7,        1.323605e-26}, //   129I
{   53,  130,               0,    6.419416e+13,   10,        1.691245e-26}, //   130I
{   53,  131,               0,    1.000336e+15,    7,         1.38471e-26}, //   131I
{   53,  132,               0,    1.191955e+13,    8,         1.55944e-26}, //   132I
{   53,  133,               0,    1.081848e+14,    7,         1.44228e-26}, //   133I
{   53,  134,               0,    4.544489e+12,    0,                   0}, //   134I
{   53,  135,               0,    3.417456e+13,    0,                   0}, //   135I
{   53,  136,               0,    1.203208e+11,    0,                   0}, //   136I
{   53,  137,               0,    3.534603e+10,    0,                   0}, //   137I
{   53,  138,               0,     8.98799e+09,    0,                   0}, //   138I
{   53,  139,               0,    3.289345e+09,    0,                   0}, //   139I
{   53,  140,               0,    1.240718e+09,    0,                   0}, //   140I
{   53,  141,               0,    6.203589e+08,    0,                   0}, //   141I
{   53,  142,               0,    3.202783e+08,    0,                   0}, //   142I
{   53,  143,               0,    1.875504e+08,    0,                   0}, //   143I
{   53,  145,               0,        587.1769,    0,                   0}, //   145I
{   54,  109,               0,    1.875504e+07,    0,                   0}, //  109XE
{   54,  110,               0,    1.341706e+08,    0,                   0}, //  110XE
{   54,  111,               0,    1.067594e+09,    0,                   0}, //  111XE
{   54,  112,               0,    3.895277e+09,    0,                   0}, //  112XE
{   54,  113,               0,    3.952984e+09,    0,                   0}, //  113XE
{   54,  114,               0,    1.442695e+10,    0,                   0}, //  114XE
{   54,  115,               0,    2.596851e+10,    0,                   0}, //  115XE
{   54,  116,               0,    8.511901e+10,    0,                   0}, //  116XE
{   54,  117,               0,     8.80044e+10,    0,                   0}, //  117XE
{   54,  118,               0,    3.289345e+11,    0,                   0}, //  118XE
{   54,  119,               0,    5.020579e+11,    0,                   0}, //  119XE
{   54,  120,               0,    3.462468e+12,    0,                   0}, //  120XE
{   54,  121,               0,    3.471124e+12,    0,                   0}, //  121XE
{   54,  122,               0,    1.043934e+14,    0,                   0}, //  122XE
{   54,  123,               0,     1.08029e+13,    0,                   0}, //  123XE
{   54,  124,               0,    7.284456e+30,    0,                   0}, //  124XE
{   54,  125,               0,    8.777357e+13,    0,                   0}, //  125XE
{   54,  126,               0,              -1,    0,                   0}, //  126XE
{   54,  127,               0,    4.530495e+15,    1,       -2.544695e-27}, //  127XE
{   54,  128,               0,              -1,    0,                   0}, //  128XE
{   54,  129,               0,              -1,    1,    -3.928780315e-27}, //  129XE
{   54,  130,               0,              -1,    0,                   0}, //  130XE
{   54,  131,               0,              -1,    3,       3.4939031e-27}, //  131XE
{   54,  132,               0,              -1,    0,                   0}, //  132XE
{   54,  133,               0,    6.540891e+14,    0,                   0}, //  133XE
{   54,  134,               0,    2.640565e+39,    0,                   0}, //  134XE
{   54,  135,               0,    4.747044e+13,    3,         4.56116e-27}, //  135XE
{   54,  136,               0,    1.639046e+37,    0,                   0}, //  136XE
{   54,  137,               0,    3.304926e+11,    7,        -4.90052e-27}, //  137XE
{   54,  138,               0,    1.218789e+12,    0,                   0}, //  138XE
{   54,  139,               0,    5.724614e+10,    3,         -1.5352e-27}, //  139XE
{   54,  140,               0,    1.962065e+10,    0,                   0}, //  140XE
{   54,  141,               0,    2.495862e+09,    0,                   0}, //  141XE
{   54,  142,               0,    1.774515e+09,    0,                   0}, //  142XE
{   54,  143,               0,    7.372172e+08,    5,       -2.322495e-27}, //  143XE
{   54,  144,               0,    1.659099e+09,    0,                   0}, //  144XE
{   54,  145,               0,    2.712267e+08,    0,                   0}, //  145XE
{   54,  147,               0,    1.442695e+08,    0,                   0}, //  147XE
{   54,  148,               0,        588.6196,    0,                   0}, //  148XE
{   55,  112,               0,        721347.5,    0,                   0}, //  112CS
{   55,  113,               0,        24093.01,    0,                   0}, //  113CS
{   55,  114,               0,    8.223362e+08,    0,                   0}, //  114CS
{   55,  115,               0,    2.019773e+09,    0,                   0}, //  115CS
{   55,  116,               0,    1.009887e+09,    0,                   0}, //  116CS
{   55,  118,               0,    2.019773e+10,    4,         1.95738e-26}, //  118CS
{   55,  119,               0,    6.203589e+10,    9,          2.7573e-26}, //  119CS
{   55,  120,               0,    8.843721e+10,    0,                   0}, //  120CS
{   55,  121,               0,    2.236177e+11,    0,                   0}, //  121CS
{   55,  122,               0,    3.055628e+10,    2,        -6.73165e-28}, //  122CS
{   55,  123,               0,    5.089828e+11,    1,         6.95385e-27}, //  123CS
{   55,  124,               0,    4.457928e+10,    2,         3.39865e-27}, //  124CS
{   55,  125,               0,    4.042432e+12,    0,                   0}, //  125CS
{   55,  126,               0,    1.419612e+11,    2,         3.92385e-27}, //  126CS
{   55,  127,               0,    3.246064e+13,    1,         7.36795e-27}, //  127CS
{   55,  128,               0,    3.168158e+11,    2,          4.9187e-27}, //  128CS
{   55,  129,               0,    1.665159e+14,    1,         7.52955e-27}, //  129CS
{   55,  130,               0,    2.528467e+12,    2,           7.373e-27}, //  130CS
{   55,  131,               0,    1.207723e+15,    5,        1.789215e-26}, //  131CS
{   55,  132,               0,    8.077217e+14,    4,         1.12211e-26}, //  132CS
{   55,  133,               0,              -1,    7,     1.303922625e-26}, //  133CS
{   55,  134,               0,    9.402476e+16,    8,        1.511818e-26}, //  134CS
{   55,  135,               0,    1.047137e+23,    7,        1.379862e-26}, //  135CS
{   55,  136,               0,    1.640344e+15,   10,        1.874055e-26}, //  136CS
{   55,  137,               0,    1.369478e+18,    7,        1.434857e-26}, //  137CS
{   55,  138,               0,    2.892026e+12,    6,           3.535e-27}, //  138CS
{   55,  139,               0,     8.02427e+11,    7,         1.36148e-26}, //  139CS
{   55,  140,               0,    9.189967e+10,    2,        6.761713e-28}, //  140CS
{   55,  141,               0,    3.583654e+10,    7,         1.23119e-26}, //  141CS
{   55,  142,               0,    2.429498e+09,    0,                   0}, //  142CS
{   55,  143,               0,    2.583867e+09,    0,                   0}, //  143CS
{   55,  144,               0,    1.434039e+09,    0,                   0}, //  144CS
{   55,  145,               0,     8.46862e+08,    3,          3.9592e-27}, //  145CS
{   55,  146,               0,    4.631051e+08,    2,        -2.60075e-27}, //  146CS
{   55,  147,               0,    3.318199e+08,    0,                   0}, //  147CS
{   55,  148,               0,    2.106335e+08,    0,                   0}, //  148CS
{   55,  149,               0,    7.213475e+07,    0,                   0}, //  149CS
{   55,  150,               0,    7.213475e+07,    0,                   0}, //  150CS
{   55,  151,               0,    7.213475e+07,    0,                   0}, //  151CS
{   56,  114,               0,    6.203589e+08,    0,                   0}, //  114BA
{   56,  115,               0,    6.492128e+08,    0,                   0}, //  115BA
{   56,  116,               0,    1.875504e+09,    0,                   0}, //  116BA
{   56,  117,               0,    2.524716e+09,    0,                   0}, //  117BA
{   56,  118,               0,    7.934823e+09,    0,                   0}, //  118BA
{   56,  119,               0,    7.790553e+09,    0,                   0}, //  119BA
{   56,  120,               0,    3.462468e+10,    0,                   0}, //  120BA
{   56,  121,               0,    4.284804e+10,    0,                   0}, //  121BA
{   56,  122,               0,    1.687953e+11,    0,                   0}, //  122BA
{   56,  123,               0,    2.337166e+11,    0,                   0}, //  123BA
{   56,  124,               0,    9.521787e+11,    0,                   0}, //  124BA
{   56,  125,               0,    2.856536e+11,    0,                   0}, //  125BA
{   56,  126,               0,     8.65617e+12,    0,                   0}, //  126BA
{   56,  127,               0,    1.099334e+12,    1,          4.4945e-28}, //  127BA
{   56,  128,               0,    3.028938e+14,    0,                   0}, //  128BA
{   56,  129,               0,    1.158196e+13,    1,         -2.0099e-27}, //  129BA
{   56,  130,               0,              -1,    0,                   0}, //  130BA
{   56,  131,               0,    1.433462e+15,    1,        3.575971e-27}, //  131BA
{   56,  132,               0,    1.365843e+38,    0,                   0}, //  132BA
{   56,  133,               0,    4.803597e+17,    1,        3.896954e-27}, //  133BA
{   56,  134,               0,              -1,    0,                   0}, //  134BA
{   56,  135,               0,              -1,    3,      4.23161215e-27}, //  135BA
{   56,  136,               0,              -1,    0,                   0}, //  136BA
{   56,  137,               0,              -1,    3,      4.73369325e-27}, //  137BA
{   56,  138,               0,              -1,    0,                   0}, //  138BA
{   56,  139,               0,    7.189815e+12,    7,        -4.91365e-27}, //  139BA
{   56,  140,               0,    1.589561e+15,    0,                   0}, //  140BA
{   56,  141,               0,    1.581482e+12,    3,        -1.70185e-27}, //  141BA
{   56,  142,               0,     9.17554e+11,    0,                   0}, //  142BA
{   56,  143,               0,    2.091908e+10,    5,         2.23715e-27}, //  143BA
{   56,  144,               0,    1.659099e+10,    0,                   0}, //  144BA
{   56,  145,               0,    6.218016e+09,    5,        -1.43925e-27}, //  145BA
{   56,  146,               0,    3.202783e+09,    0,                   0}, //  146BA
{   56,  147,               0,    1.289769e+09,    0,                   0}, //  147BA
{   56,  148,               0,    8.829294e+08,    0,                   0}, //  148BA
{   56,  149,               0,    4.962871e+08,    0,                   0}, //  149BA
{   56,  150,               0,    4.328085e+08,    0,                   0}, //  150BA
{   56,  151,               0,        432.8085,    0,                   0}, //  151BA
{   56,  152,               0,        585.7342,    0,                   0}, //  152BA
{   57,  117,               0,    3.390333e+07,    0,                   0}, //  117LA
{   57,  121,               0,    7.646284e+09,    0,                   0}, //  121LA
{   57,  122,               0,    1.240718e+10,    0,                   0}, //  122LA
{   57,  123,               0,    2.452582e+10,    0,                   0}, //  123LA
{   57,  125,               0,    9.348664e+10,    0,                   0}, //  125LA
{   57,  127,               0,    4.414647e+11,    0,                   0}, //  127LA
{   57,  128,               0,    4.483896e+11,    0,                   0}, //  128LA
{   57,  129,               0,    1.004116e+12,    0,                   0}, //  129LA
{   57,  130,               0,    7.530868e+11,    0,                   0}, //  130LA
{   57,  131,               0,     5.10714e+12,    0,                   0}, //  131LA
{   57,  132,               0,    2.492977e+13,    0,                   0}, //  132LA
{   57,  133,               0,    2.031747e+13,    0,                   0}, //  133LA
{   57,  134,               0,     5.58323e+11,    0,                   0}, //  134LA
{   57,  135,               0,    1.012772e+14,    5,          1.8685e-26}, //  135LA
{   57,  136,               0,     8.54364e+11,    0,                   0}, //  136LA
{   57,  137,               0,    2.731743e+21,    7,          1.3635e-26}, //  137LA
{   57,  138,               0,    4.643891e+27,   10,        1.886912e-26}, //  138LA
{   57,  139,               0,              -1,    7,    1.4054379775e-26}, //  139LA
{   57,  140,               0,    2.092341e+14,    6,          3.6865e-27}, //  140LA
{   57,  141,               0,    2.035931e+13,    0,                   0}, //  141LA
{   57,  142,               0,    7.885771e+12,    0,                   0}, //  142LA
{   57,  143,               0,    1.229176e+12,    0,                   0}, //  143LA
{   57,  144,               0,    5.886196e+10,    0,                   0}, //  144LA
{   57,  145,               0,    3.577884e+10,    0,                   0}, //  145LA
{   57,  146,               0,    9.045698e+09,    0,                   0}, //  146LA
{   57,  147,               0,    5.857342e+09,    0,                   0}, //  147LA
{   57,  148,               0,    1.817796e+09,    0,                   0}, //  148LA
{   57,  149,               0,     1.51483e+09,    0,                   0}, //  149LA
{   57,  150,               0,    1.240718e+09,    0,                   0}, //  150LA
{   57,  151,               0,        432.8085,    0,                   0}, //  151LA
{   57,  152,               0,        216.4043,    0,                   0}, //  152LA
{   57,  153,               0,        144.2695,    0,                   0}, //  153LA
{   58,  121,               0,    1.586965e+09,    0,                   0}, //  121CE
{   58,  123,               0,    5.482241e+09,    0,                   0}, //  123CE
{   58,  124,               0,     8.65617e+09,    0,                   0}, //  124CE
{   58,  125,               0,    1.399414e+10,    0,                   0}, //  125CE
{   58,  126,               0,    7.357745e+10,    0,                   0}, //  126CE
{   58,  127,               0,    4.905163e+10,    0,                   0}, //  127CE
{   58,  128,               0,    3.401875e+11,    0,                   0}, //  128CE
{   58,  129,               0,     3.02966e+11,    0,                   0}, //  129CE
{   58,  130,               0,    1.982263e+12,    0,                   0}, //  130CE
{   58,  131,               0,    8.915855e+11,    0,                   0}, //  131CE
{   58,  132,               0,    1.822989e+13,    0,                   0}, //  132CE
{   58,  133,               0,    8.396485e+12,    0,                   0}, //  133CE
{   58,  134,               0,    3.938846e+14,    0,                   0}, //  134CE
{   58,  135,               0,    9.192853e+13,    0,                   0}, //  135CE
{   58,  136,               0,    3.186913e+30,    0,                   0}, //  136CE
{   58,  137,               0,    4.674332e+13,    3,           4.848e-27}, //  137CE
{   58,  138,               0,    4.097542e+30,    0,                   0}, //  138CE
{   58,  139,               0,    1.715653e+16,    3,           5.353e-27}, //  139CE
{   58,  140,               0,              -1,    0,                   0}, //  140CE
{   58,  141,               0,    4.052098e+15,    7,          5.5045e-27}, //  141CE
{   58,  142,               0,    2.276429e+33,    0,                   0}, //  142CE
{   58,  143,               0,    1.715941e+14,    3,          2.1715e-27}, //  143CE
{   58,  144,               0,    3.551338e+16,    0,                   0}, //  144CE
{   58,  145,               0,    2.605507e+11,    0,                   0}, //  145CE
{   58,  146,               0,    1.170314e+12,    0,                   0}, //  146CE
{   58,  147,               0,      8.1368e+10,    0,                   0}, //  147CE
{   58,  148,               0,    8.079092e+10,    0,                   0}, //  148CE
{   58,  149,               0,    7.646284e+09,    0,                   0}, //  149CE
{   58,  150,               0,     5.77078e+09,    0,                   0}, //  150CE
{   58,  151,               0,    2.539143e+09,    0,                   0}, //  151CE
{   58,  152,               0,    2.019773e+09,    0,                   0}, //  152CE
{   58,  153,               0,        144.2695,    0,                   0}, //  153CE
{   58,  154,               0,        144.2695,    0,                   0}, //  154CE
{   58,  155,               0,        432.8085,    0,                   0}, //  155CE
{   59,  121,               0,    1.442695e+07,    0,                   0}, //  121PR
{   59,  124,               0,    1.731234e+09,    0,                   0}, //  124PR
{   59,  125,               0,    4.760894e+09,    0,                   0}, //  125PR
{   59,  126,               0,    4.530062e+09,    0,                   0}, //  126PR
{   59,  127,               0,    6.059319e+09,    0,                   0}, //  127PR
{   59,  128,               0,    4.097254e+09,    0,                   0}, //  128PR
{   59,  129,               0,    4.328085e+10,    0,                   0}, //  129PR
{   59,  131,               0,    1.307082e+11,    0,                   0}, //  131PR
{   59,  132,               0,    1.384987e+11,    0,                   0}, //  132PR
{   59,  133,               0,    5.626511e+11,    0,                   0}, //  133PR
{   59,  135,               0,    2.077481e+12,    0,                   0}, //  135PR
{   59,  136,               0,    1.133958e+12,    0,                   0}, //  136PR
{   59,  137,               0,    6.647939e+12,    0,                   0}, //  137PR
{   59,  138,               0,    1.255145e+11,    0,                   0}, //  138PR
{   59,  139,               0,    2.290423e+13,    0,                   0}, //  139PR
{   59,  140,               0,    2.934442e+11,    0,                   0}, //  140PR
{   59,  141,               0,              -1,    5,        2.159077e-26}, //  141PR
{   59,  142,               0,    9.930359e+13,    4,          1.1817e-27}, //  142PR
{   59,  143,               0,    1.691416e+15,    7,        1.364005e-26}, //  143PR
{   59,  144,               0,    1.495786e+12,    0,                   0}, //  144PR
{   59,  145,               0,    3.107854e+13,    0,                   0}, //  145PR
{   59,  146,               0,    2.090465e+12,    0,                   0}, //  146PR
{   59,  147,               0,    1.159927e+12,    0,                   0}, //  147PR
{   59,  148,               0,    1.982263e+11,    0,                   0}, //  148PR
{   59,  149,               0,    1.956294e+11,    0,                   0}, //  149PR
{   59,  150,               0,    8.930282e+09,    0,                   0}, //  150PR
{   59,  151,               0,    2.726694e+10,    0,                   0}, //  151PR
{   59,  152,               0,    5.236983e+09,    0,                   0}, //  152PR
{   59,  153,               0,    6.174735e+09,    0,                   0}, //  153PR
{   59,  154,               0,    3.318199e+09,    0,                   0}, //  154PR
{   59,  155,               0,        432.8085,    0,                   0}, //  155PR
{   60,  125,               0,    9.377518e+08,    0,                   0}, //  125ND
{   60,  127,               0,    2.596851e+09,    0,                   0}, //  127ND
{   60,  128,               0,    7.213475e+09,    0,                   0}, //  128ND
{   60,  129,               0,    7.069206e+09,    0,                   0}, //  129ND
{   60,  130,               0,    1.875504e+10,    0,                   0}, //  130ND
{   60,  131,               0,    3.664445e+10,    0,                   0}, //  131ND
{   60,  132,               0,    1.356133e+11,    0,                   0}, //  132ND
{   60,  133,               0,    1.009887e+11,    0,                   0}, //  133ND
{   60,  134,               0,    7.357745e+11,    0,                   0}, //  134ND
{   60,  135,               0,    1.073365e+12,    0,                   0}, //  135ND
{   60,  136,               0,     4.38435e+12,    0,                   0}, //  136ND
{   60,  137,               0,    3.332626e+12,    0,                   0}, //  137ND
{   60,  138,               0,    2.617626e+13,    0,                   0}, //  138ND
{   60,  139,               0,    2.570883e+12,    3,         4.58035e-27}, //  139ND
{   60,  140,               0,    4.200695e+14,    0,                   0}, //  140ND
{   60,  141,               0,    1.293232e+13,    3,          5.1106e-27}, //  141ND
{   60,  142,               0,              -1,    0,                   0}, //  142ND
{   60,  143,               0,              -1,    7,        -5.37825e-27}, //  143ND
{   60,  144,               0,    1.042592e+32,    0,                   0}, //  144ND
{   60,  145,               0,              -1,    7,         -3.3128e-27}, //  145ND
{   60,  146,               0,              -1,    0,                   0}, //  146ND
{   60,  147,               0,    1.368642e+15,    5,          2.9189e-27}, //  147ND
{   60,  148,               0,              -1,    0,                   0}, //  148ND
{   60,  149,               0,    8.974717e+12,    5,         1.77255e-27}, //  149ND
{   60,  150,               0,    5.008027e+35,    0,                   0}, //  150ND
{   60,  151,               0,    1.076828e+12,    0,                   0}, //  151ND
{   60,  152,               0,    9.868034e+11,    0,                   0}, //  152ND
{   60,  153,               0,    4.558916e+10,    0,                   0}, //  153ND
{   60,  154,               0,     3.73658e+10,    0,                   0}, //  154ND
{   60,  155,               0,    1.283999e+10,    0,                   0}, //  155ND
{   60,  156,               0,    7.920396e+09,    0,                   0}, //  156ND
{   60,  157,               0,        144.2695,    0,                   0}, //  157ND
{   60,  158,               0,        72.13475,    0,                   0}, //  158ND
{   61,  128,               0,    1.442695e+09,    0,                   0}, //  128PM
{   61,  129,               0,    3.462468e+09,    0,                   0}, //  129PM
{   61,  130,               0,    3.751007e+09,    0,                   0}, //  130PM
{   61,  131,               0,    9.088979e+09,    0,                   0}, //  131PM
{   61,  132,               0,    8.944709e+09,    0,                   0}, //  132PM
{   61,  133,               0,    1.947638e+10,    0,                   0}, //  133PM
{   61,  134,               0,    7.213475e+09,    0,                   0}, //  134PM
{   61,  137,               0,    2.077481e+11,    0,                   0}, //  137PM
{   61,  138,               0,    1.442695e+10,    0,                   0}, //  138PM
{   61,  139,               0,    3.592311e+11,    0,                   0}, //  139PM
{   61,  140,               0,    1.327279e+10,    0,                   0}, //  140PM
{   61,  141,               0,     1.80914e+12,    0,                   0}, //  141PM
{   61,  142,               0,    5.842915e+10,    0,                   0}, //  142PM
{   61,  143,               0,    3.303195e+16,    5,           1.919e-26}, //  143PM
{   61,  144,               0,    4.524724e+16,    0,                   0}, //  144PM
{   61,  145,               0,    8.058462e+17,    0,                   0}, //  145PM
{   61,  146,               0,    2.517647e+17,    0,                   0}, //  146PM
{   61,  147,               0,    1.194378e+17,    7,          1.3029e-26}, //  147PM
{   61,  148,               0,     6.69122e+14,    2,           9.292e-27}, //  148PM
{   61,  149,               0,    2.756846e+14,    7,          1.6665e-26}, //  149PM
{   61,  150,               0,    1.391912e+13,    0,                   0}, //  150PM
{   61,  151,               0,    1.475011e+14,    5,            9.09e-27}, //  151PM
{   61,  152,               0,    3.566342e+11,    0,                   0}, //  152PM
{   61,  153,               0,    4.544489e+11,    0,                   0}, //  153PM
{   61,  154,               0,    2.319854e+11,    0,                   0}, //  154PM
{   61,  155,               0,    5.987184e+10,    0,                   0}, //  155PM
{   61,  157,               0,    1.523486e+10,    0,                   0}, //  157PM
{   61,  158,               0,    6.924936e+09,    0,                   0}, //  158PM
{   61,  159,               0,    2.164043e+09,    0,                   0}, //  159PM
{   62,  129,               0,    7.934823e+08,    0,                   0}, //  129SM
{   62,  131,               0,    1.731234e+09,    0,                   0}, //  131SM
{   62,  132,               0,     5.77078e+09,    0,                   0}, //  132SM
{   62,  133,               0,    4.169389e+09,    0,                   0}, //  133SM
{   62,  134,               0,     1.37056e+10,    0,                   0}, //  134SM
{   62,  135,               0,    1.485976e+10,    0,                   0}, //  135SM
{   62,  136,               0,    6.780667e+10,    0,                   0}, //  136SM
{   62,  137,               0,    6.492128e+10,    0,                   0}, //  137SM
{   62,  138,               0,    2.683413e+11,    0,                   0}, //  138SM
{   62,  139,               0,    2.224636e+11,    1,         -2.6967e-27}, //  139SM
{   62,  140,               0,    1.282844e+12,    0,                   0}, //  140SM
{   62,  141,               0,    8.829294e+11,    1,        -3.71175e-27}, //  141SM
{   62,  142,               0,    6.274858e+12,    0,                   0}, //  142SM
{   62,  143,               0,    7.574149e+11,    3,          5.1005e-27}, //  143SM
{   62,  144,               0,              -1,    0,                   0}, //  144SM
{   62,  145,               0,    4.238061e+16,    7,         -5.6055e-27}, //  145SM
{   62,  146,               0,    4.689336e+24,    0,                   0}, //  146SM
{   62,  147,               0,    4.825959e+27,    7,        -4.11474e-27}, //  147SM
{   62,  148,               0,    3.186913e+32,    0,                   0}, //  148SM
{   62,  149,               0,              -1,    7,       -3.371885e-27}, //  149SM
{   62,  150,               0,              -1,    0,                   0}, //  150SM
{   62,  151,               0,    4.097542e+18,    5,       -1.823555e-27}, //  151SM
{   62,  152,               0,              -1,    0,                   0}, //  152SM
{   62,  153,               0,    2.403818e+14,    3,         -1.0908e-28}, //  153SM
{   62,  154,               0,              -1,    0,                   0}, //  154SM
{   62,  155,               0,    1.930326e+12,    0,                   0}, //  155SM
{   62,  156,               0,     4.88208e+13,    0,                   0}, //  156SM
{   62,  157,               0,    6.950905e+11,    0,                   0}, //  157SM
{   62,  158,               0,     4.58777e+11,    0,                   0}, //  158SM
{   62,  159,               0,    1.640344e+10,    0,                   0}, //  159SM
{   62,  160,               0,    1.384987e+10,    0,                   0}, //  160SM
{   62,  161,               0,    6.924936e+09,    0,                   0}, //  161SM
{   62,  162,               0,    3.462468e+09,    0,                   0}, //  162SM
{   63,  130,               0,         1298426,    0,                   0}, //  130EU
{   63,  131,               0,    2.567997e+07,    0,                   0}, //  131EU
{   63,  134,               0,    7.213475e+08,    0,                   0}, //  134EU
{   63,  135,               0,    2.164043e+09,    0,                   0}, //  135EU
{   63,  137,               0,    1.586965e+10,    0,                   0}, //  137EU
{   63,  138,               0,    1.745661e+10,    0,                   0}, //  138EU
{   63,  139,               0,    2.582424e+10,    0,                   0}, //  139EU
{   63,  140,               0,     2.17847e+09,    2,         6.89325e-27}, //  140EU
{   63,  141,               0,    5.871769e+10,    5,         1.76447e-26}, //  141EU
{   63,  142,               0,    3.375906e+09,    2,          7.7568e-27}, //  142EU
{   63,  143,               0,    2.241948e+11,    0,                   0}, //  143EU
{   63,  144,               0,    1.471549e+10,    2,         9.55965e-27}, //  144EU
{   63,  145,               0,    7.391648e+14,    5,        2.016465e-26}, //  145EU
{   63,  146,               0,    5.746254e+14,    8,         7.17605e-27}, //  146EU
{   63,  147,               0,     3.00398e+15,    5,         1.88062e-26}, //  147EU
{   63,  148,               0,    6.793362e+15,   10,          1.1817e-26}, //  148EU
{   63,  149,               0,    1.160475e+16,    5,        1.800325e-26}, //  149EU
{   63,  150,               0,    1.680018e+18,    0,                   0}, //  150EU
{   63,  151,               0,     7.73977e+34,    5,        1.753208e-26}, //  151EU
{   63,  152,               0,    6.163193e+17,    6,        -9.80407e-27}, //  152EU
{   63,  153,               0,              -1,    5,         7.73862e-27}, //  153EU
{   63,  154,               0,    3.915907e+17,    6,       -1.012525e-26}, //  154EU
{   63,  155,               0,    2.163898e+17,    5,           7.676e-27}, //  155EU
{   63,  156,               0,    1.893393e+15,    0,                   0}, //  156EU
{   63,  157,               0,     7.88404e+13,    5,           7.575e-27}, //  157EU
{   63,  158,               0,    3.973182e+12,    0,                   0}, //  158EU
{   63,  159,               0,    1.566767e+12,    5,           6.969e-27}, //  159EU
{   63,  160,               0,    5.482241e+10,    0,                   0}, //  160EU
{   63,  161,               0,    3.751007e+10,    0,                   0}, //  161EU
{   63,  162,               0,    1.529257e+10,    0,                   0}, //  162EU
{   63,  163,               0,    1.110875e+10,    0,                   0}, //  163EU
{   63,  164,               0,    6.059319e+09,    0,                   0}, //  164EU
{   63,  165,               0,    3.318199e+09,    0,                   0}, //  165EU
{   64,  135,               0,    1.586965e+09,    0,                   0}, //  135GD
{   64,  136,               0,         288.539,    0,                   0}, //  136GD
{   64,  137,               0,    3.173929e+09,    0,                   0}, //  137GD
{   64,  138,               0,    6.780667e+09,    0,                   0}, //  138GD
{   64,  139,               0,    8.367631e+09,    0,                   0}, //  139GD
{   64,  140,               0,    2.279458e+10,    0,                   0}, //  140GD
{   64,  141,               0,    2.019773e+10,    0,                   0}, //  141GD
{   64,  142,               0,    1.012772e+11,    0,                   0}, //  142GD
{   64,  143,               0,    5.626511e+10,    0,                   0}, //  143GD
{   64,  144,               0,    3.869308e+11,    0,                   0}, //  144GD
{   64,  145,               0,    1.990919e+12,    1,          -3.737e-27}, //  145GD
{   64,  146,               0,     6.01676e+15,    0,                   0}, //  146GD
{   64,  147,               0,    1.976781e+14,    7,           5.151e-27}, //  147GD
{   64,  148,               0,    3.396393e+18,    0,                   0}, //  148GD
{   64,  149,               0,    1.156738e+15,    7,           4.444e-27}, //  149GD
{   64,  150,               0,    8.149496e+22,    0,                   0}, //  150GD
{   64,  151,               0,    1.544405e+16,    7,          3.8885e-27}, //  151GD
{   64,  152,               0,    4.916993e+30,    0,                   0}, //  152GD
{   64,  153,               0,    2.996622e+16,    3,           1.919e-27}, //  153GD
{   64,  154,               0,              -1,    0,                   0}, //  154GD
{   64,  155,               0,              -1,    3,      -1.2990115e-27}, //  155GD
{   64,  156,               0,              -1,    0,                   0}, //  156GD
{   64,  157,               0,              -1,    3,        -1.71599e-27}, //  157GD
{   64,  158,               0,              -1,    0,                   0}, //  158GD
{   64,  159,               0,    9.597384e+13,    3,          -2.222e-27}, //  159GD
{   64,  160,               0,              -1,    0,                   0}, //  160GD
{   64,  161,               0,    3.168158e+11,    0,                   0}, //  161GD
{   64,  162,               0,    7.271183e+11,    0,                   0}, //  162GD
{   64,  163,               0,    9.810326e+10,    0,                   0}, //  163GD
{   64,  164,               0,    6.492128e+10,    0,                   0}, //  164GD
{   64,  165,               0,    1.485976e+10,    0,                   0}, //  165GD
{   64,  166,               0,    6.924936e+09,    0,                   0}, //  166GD
{   65,  135,               0,         1356133,    0,                   0}, //  135TB
{   65,  139,               0,    2.308312e+09,    0,                   0}, //  139TB
{   65,  140,               0,    3.462468e+09,    0,                   0}, //  140TB
{   65,  141,               0,    5.049433e+09,    0,                   0}, //  141TB
{   65,  142,               0,    8.612889e+08,    0,                   0}, //  142TB
{   65,  143,               0,    1.731234e+10,    0,                   0}, //  143TB
{   65,  144,               0,    1.442695e+09,    0,                   0}, //  144TB
{   65,  146,               0,    1.154156e+10,    0,                   0}, //  146TB
{   65,  147,               0,    8.517672e+12,    0,                   0}, //  147TB
{   65,  148,               0,    5.193702e+12,    4,         -8.8375e-27}, //  148TB
{   65,  149,               0,    2.138795e+13,    1,          6.8175e-27}, //  149TB
{   65,  150,               0,    1.807408e+13,    0,                   0}, //  150TB
{   65,  151,               0,    9.145532e+13,    0,                   0}, //  151TB
{   65,  152,               0,    9.088979e+13,    4,          -2.929e-27}, //  152TB
{   65,  153,               0,    2.916841e+14,    5,          1.7372e-26}, //  153TB
{   65,  154,               0,    1.116646e+14,    0,                   0}, //  154TB
{   65,  155,               0,    6.631348e+14,    3,         1.01505e-26}, //  155TB
{   65,  156,               0,    6.668714e+14,    6,          7.1205e-27}, //  156TB
{   65,  157,               0,    3.232503e+18,    3,         1.01505e-26}, //  157TB
{   65,  158,               0,    8.195085e+18,    6,          8.8779e-27}, //  158TB
{   65,  159,               0,              -1,    3,         1.01707e-26}, //  159TB
{   65,  160,               0,    9.012083e+15,    6,          9.0395e-27}, //  160TB
{   65,  161,               0,    8.588364e+14,    3,           1.111e-26}, //  161TB
{   65,  162,               0,    6.578689e+11,    0,                   0}, //  162TB
{   65,  163,               0,    1.687953e+12,    0,                   0}, //  163TB
{   65,  164,               0,    2.596851e+11,    0,                   0}, //  164TB
{   65,  165,               0,    1.826452e+11,    0,                   0}, //  165TB
{   65,  166,               0,    3.621165e+10,    0,                   0}, //  166TB
{   65,  167,               0,    2.798828e+10,    0,                   0}, //  167TB
{   65,  168,               0,     1.18301e+10,    0,                   0}, //  168TB
{   66,  139,               0,     8.65617e+08,    0,                   0}, //  139DY
{   66,  141,               0,    1.298426e+09,    0,                   0}, //  141DY
{   66,  142,               0,    3.318199e+09,    0,                   0}, //  142DY
{   66,  143,               0,    8.079092e+09,    0,                   0}, //  143DY
{   66,  144,               0,    1.312852e+10,    0,                   0}, //  144DY
{   66,  145,               0,     8.65617e+09,    0,                   0}, //  145DY
{   66,  146,               0,    4.183816e+10,    0,                   0}, //  146DY
{   66,  147,               0,    9.666057e+10,    0,                   0}, //  147DY
{   66,  148,               0,    2.856536e+11,    0,                   0}, //  148DY
{   66,  149,               0,    3.635592e+11,    0,                   0}, //  149DY
{   66,  150,               0,    6.206474e+11,    0,                   0}, //  150DY
{   66,  151,               0,    1.549454e+12,    0,                   0}, //  151DY
{   66,  152,               0,    1.236101e+13,    0,                   0}, //  152DY
{   66,  153,               0,    3.323969e+13,    0,                   0}, //  153DY
{   66,  154,               0,    1.365843e+23,    0,                   0}, //  154DY
{   66,  155,               0,    5.141765e+13,    3,        -1.71195e-27}, //  155DY
{   66,  156,               0,              -1,    0,                   0}, //  156DY
{   66,  157,               0,    4.227674e+13,    3,        -1.52005e-27}, //  157DY
{   66,  158,               0,              -1,    0,                   0}, //  158DY
{   66,  159,               0,    1.799906e+16,    3,         -1.7877e-27}, //  159DY
{   66,  160,               0,              -1,    0,                   0}, //  160DY
{   66,  161,               0,              -1,    5,       -2.425515e-27}, //  161DY
{   66,  162,               0,              -1,    0,                   0}, //  162DY
{   66,  163,               0,              -1,    5,         3.39663e-27}, //  163DY
{   66,  164,               0,              -1,    0,                   0}, //  164DY
{   66,  165,               0,     1.21221e+13,    7,          -2.626e-27}, //  165DY
{   66,  166,               0,    4.238061e+14,    0,                   0}, //  166DY
{   66,  167,               0,    5.366826e+11,    0,                   0}, //  167DY
{   66,  168,               0,    7.530868e+11,    0,                   0}, //  168DY
{   66,  169,               0,    5.626511e+10,    0,                   0}, //  169DY
{   67,  140,               0,         8656170,    0,                   0}, //  140HO
{   67,  141,               0,         5915050,    0,                   0}, //  141HO
{   67,  142,               0,     5.77078e+08,    0,                   0}, //  142HO
{   67,  144,               0,    1.009887e+09,    0,                   0}, //  144HO
{   67,  145,               0,    3.462468e+09,    0,                   0}, //  145HO
{   67,  146,               0,    5.193702e+09,    0,                   0}, //  146HO
{   67,  147,               0,    8.367631e+09,    0,                   0}, //  147HO
{   67,  148,               0,    3.173929e+09,    0,                   0}, //  148HO
{   67,  149,               0,    3.044087e+10,    0,                   0}, //  149HO
{   67,  150,               0,     1.03874e+11,    0,                   0}, //  150HO
{   67,  151,               0,    5.078287e+10,    0,                   0}, //  151HO
{   67,  152,               0,    2.334281e+11,    4,          -5.151e-27}, //  152HO
{   67,  153,               0,     1.73989e+11,   11,         3.43905e-26}, //  153HO
{   67,  154,               0,    1.017966e+12,    4,        -3.24715e-27}, //  154HO
{   67,  155,               0,    4.154962e+12,    5,         1.77255e-26}, //  155HO
{   67,  156,               0,    4.847455e+12,    8,          1.5049e-26}, //  156HO
{   67,  157,               0,    1.090677e+12,    7,          2.1917e-26}, //  157HO
{   67,  158,               0,    9.781472e+11,   10,         1.90385e-26}, //  158HO
{   67,  159,               0,    2.860864e+12,    7,          2.1614e-26}, //  159HO
{   67,  160,               0,     2.21598e+12,   10,         1.87355e-26}, //  160HO
{   67,  161,               0,    1.288038e+13,    7,         2.14625e-26}, //  161HO
{   67,  162,               0,    1.298426e+12,    2,          1.1716e-26}, //  162HO
{   67,  163,               0,    2.080655e+20,    7,          2.1311e-26}, //  163HO
{   67,  164,               0,    2.510289e+12,    0,                   0}, //  164HO
{   67,  165,               0,              -1,    7,        2.109385e-26}, //  165HO
{   67,  166,               0,    1.393153e+14,    0,                   0}, //  166HO
{   67,  167,               0,    1.610048e+13,    0,                   0}, //  167HO
{   67,  168,               0,    2.588195e+11,    0,                   0}, //  168HO
{   67,  169,               0,    4.085712e+11,    0,                   0}, //  169HO
{   67,  170,               0,    2.389103e+11,    0,                   0}, //  170HO
{   67,  171,               0,    7.646284e+10,    0,                   0}, //  171HO
{   67,  172,               0,    3.606738e+10,    0,                   0}, //  172HO
{   68,  144,               0,         288.539,    0,                   0}, //  144ER
{   68,  146,               0,    2.452582e+09,    0,                   0}, //  146ER
{   68,  147,               0,    3.606738e+09,    0,                   0}, //  147ER
{   68,  148,               0,    6.636397e+09,    0,                   0}, //  148ER
{   68,  149,               0,     5.77078e+09,    0,                   0}, //  149ER
{   68,  150,               0,    2.668986e+10,    0,                   0}, //  150ER
{   68,  151,               0,    3.390333e+10,    0,                   0}, //  151ER
{   68,  152,               0,    1.485976e+10,    0,                   0}, //  152ER
{   68,  153,               0,    5.352399e+10,    0,                   0}, //  153ER
{   68,  154,               0,    3.228752e+11,    0,                   0}, //  154ER
{   68,  155,               0,     4.58777e+11,    7,        -3.37845e-27}, //  155ER
{   68,  156,               0,    1.687953e+12,    0,                   0}, //  156ER
{   68,  157,               0,    1.614376e+12,    3,         -2.0806e-27}, //  157ER
{   68,  158,               0,    1.189358e+13,    0,                   0}, //  158ER
{   68,  159,               0,    3.116221e+12,    3,         -1.5352e-27}, //  159ER
{   68,  160,               0,    1.484389e+14,    0,                   0}, //  160ER
{   68,  161,               0,    1.667178e+13,    3,        -1.84325e-27}, //  161ER
{   68,  162,               0,              -1,    0,                   0}, //  162ER
{   68,  163,               0,    6.492128e+12,    5,         2.81285e-27}, //  163ER
{   68,  164,               0,              -1,    0,                   0}, //  164ER
{   68,  165,               0,    5.380675e+13,    5,         3.24715e-27}, //  165ER
{   68,  166,               0,              -1,    0,                   0}, //  166ER
{   68,  167,               0,              -1,    7,      -2.8474425e-27}, //  167ER
{   68,  168,               0,              -1,    0,                   0}, //  168ER
{   68,  169,               0,    1.170704e+15,    1,         2.60075e-27}, //  169ER
{   68,  170,               0,              -1,    0,                   0}, //  170ER
{   68,  171,               0,    3.903644e+13,    5,         3.32795e-27}, //  171ER
{   68,  172,               0,    2.560495e+14,    0,                   0}, //  172ER
{   68,  173,               0,    1.211864e+11,    0,                   0}, //  173ER
{   68,  174,               0,    2.769974e+11,    0,                   0}, //  174ER
{   68,  175,               0,     1.03874e+11,    0,                   0}, //  175ER
{   69,  144,               0,        2741.121,    0,                   0}, //  144TM
{   69,  145,               0,        4573.343,    0,                   0}, //  145TM
{   69,  146,               0,    3.390333e+08,    0,                   0}, //  146TM
{   69,  147,               0,    8.367631e+08,    0,                   0}, //  147TM
{   69,  149,               0,    1.298426e+09,    0,                   0}, //  149TM
{   69,  150,               0,    3.173929e+09,    0,                   0}, //  150TM
{   69,  151,               0,    6.016038e+09,    0,                   0}, //  151TM
{   69,  152,               0,    1.154156e+10,    0,                   0}, //  152TM
{   69,  153,               0,    2.135189e+09,    0,                   0}, //  153TM
{   69,  154,               0,    1.168583e+10,    0,                   0}, //  154TM
{   69,  155,               0,    3.116221e+10,    0,                   0}, //  155TM
{   69,  156,               0,    1.208978e+11,    0,                   0}, //  156TM
{   69,  157,               0,     3.14219e+11,    1,          2.4038e-27}, //  157TM
{   69,  158,               0,    3.445156e+11,    4,           2.121e-28}, //  158TM
{   69,  159,               0,    7.903083e+11,    5,          1.7271e-26}, //  159TM
{   69,  160,               0,      8.1368e+11,    2,           7.878e-28}, //  160TM
{   69,  161,               0,    2.614163e+12,    7,           1.212e-26}, //  161TM
{   69,  162,               0,    1.878389e+12,    2,           3.434e-28}, //  162TM
{   69,  163,               0,    9.400601e+12,    1,          -4.141e-28}, //  163TM
{   69,  164,               0,    1.731234e+11,    2,         1.19685e-26}, //  164TM
{   69,  165,               0,    1.561285e+14,    1,         -7.0195e-28}, //  165TM
{   69,  166,               0,    3.999151e+13,    4,          4.6763e-28}, //  166TM
{   69,  167,               0,    1.153002e+15,    1,         -9.9485e-28}, //  167TM
{   69,  168,               0,    1.160475e+16,    6,         1.14635e-27}, //  168TM
{   69,  169,               0,              -1,    1,        -1.16958e-27}, //  169TM
{   69,  170,               0,    1.602978e+16,    2,         1.24634e-27}, //  170TM
{   69,  171,               0,    8.741434e+16,    1,       -1.163015e-27}, //  171TM
{   69,  172,               0,    3.303195e+14,    0,                   0}, //  172TM
{   69,  173,               0,    4.279611e+13,    0,                   0}, //  173TM
{   69,  174,               0,    4.674332e+11,    0,                   0}, //  174TM
{   69,  175,               0,    1.315738e+12,    0,                   0}, //  175TM
{   69,  176,               0,    1.644672e+11,    0,                   0}, //  176TM
{   69,  178,               0,        432.8085,    0,                   0}, //  178TM
{   70,  149,               0,    1.009887e+09,    0,                   0}, //  149YB
{   70,  151,               0,    2.308312e+09,    0,                   0}, //  151YB
{   70,  152,               0,    4.385793e+09,    0,                   0}, //  152YB
{   70,  153,               0,    6.059319e+09,    7,         -5.3025e-27}, //  153YB
{   70,  154,               0,    5.900623e+08,    0,                   0}, //  154YB
{   70,  155,               0,    2.586752e+09,    0,                   0}, //  155YB
{   70,  156,               0,    3.765434e+10,    0,                   0}, //  156YB
{   70,  157,               0,    5.568803e+10,    7,        -3.22695e-27}, //  157YB
{   70,  158,               0,    1.289769e+11,    0,                   0}, //  158YB
{   70,  159,               0,     1.44558e+11,    0,                   0}, //  159YB
{   70,  160,               0,    4.154962e+11,    0,                   0}, //  160YB
{   70,  161,               0,    3.635592e+11,    3,        -1.65135e-27}, //  161YB
{   70,  162,               0,    1.633419e+12,    0,                   0}, //  162YB
{   70,  163,               0,    9.565068e+11,    3,         -1.8887e-27}, //  163YB
{   70,  164,               0,    6.561377e+12,    0,                   0}, //  164YB
{   70,  165,               0,    8.569609e+11,    5,          2.4139e-27}, //  165YB
{   70,  166,               0,    2.944829e+14,    0,                   0}, //  166YB
{   70,  167,               0,     1.51483e+12,    5,         3.14615e-27}, //  167YB
{   70,  168,               0,              -1,    0,                   0}, //  168YB
{   70,  169,               0,    3.991072e+15,    7,        -3.20675e-27}, //  169YB
{   70,  170,               0,              -1,    0,                   0}, //  170YB
{   70,  171,               0,              -1,    1,       2.4930335e-27}, //  171YB
{   70,  172,               0,              -1,    0,                   0}, //  172YB
{   70,  173,               0,              -1,    5,      -3.4334445e-27}, //  173YB
{   70,  174,               0,              -1,    0,                   0}, //  174YB
{   70,  175,               0,    5.216497e+14,    0,                   0}, //  175YB
{   70,  176,               0,              -1,    0,                   0}, //  176YB
{   70,  177,               0,    9.925165e+12,    0,                   0}, //  177YB
{   70,  178,               0,    6.405566e+12,    0,                   0}, //  178YB
{   70,  179,               0,    6.924936e+11,    0,                   0}, //  179YB
{   70,  180,               0,    2.077481e+11,    0,                   0}, //  180YB
{   71,  150,               0,    6.636397e+07,    0,                   0}, //  150LU
{   71,  151,               0,    1.162812e+08,    0,                   0}, //  151LU
{   71,  152,               0,    1.009887e+09,    0,                   0}, //  152LU
{   71,  153,               0,    1.298426e+09,    0,                   0}, //  153LU
{   71,  155,               0,    9.810326e+07,    0,                   0}, //  155LU
{   71,  156,               0,    7.126914e+08,    0,                   0}, //  156LU
{   71,  157,               0,    9.810326e+09,    0,                   0}, //  157LU
{   71,  158,               0,    1.529257e+10,    0,                   0}, //  158LU
{   71,  159,               0,    1.745661e+10,    0,                   0}, //  159LU
{   71,  160,               0,    5.208129e+10,    0,                   0}, //  160LU
{   71,  161,               0,    1.110875e+11,    1,         1.12615e-27}, //  161LU
{   71,  162,               0,    1.185895e+11,    2,         2.79265e-28}, //  162LU
{   71,  163,               0,      3.4365e+11,    0,                   0}, //  163LU
{   71,  164,               0,    2.718037e+11,    0,                   0}, //  164LU
{   71,  165,               0,    9.296727e+11,    1,        -1.23725e-28}, //  165LU
{   71,  166,               0,    2.293885e+11,   12,         1.47056e-26}, //  166LU
{   71,  167,               0,    4.457928e+12,    7,        1.174125e-26}, //  167LU
{   71,  168,               0,    4.760894e+11,    0,                   0}, //  168LU
{   71,  169,               0,    1.769033e+14,    7,        1.158975e-26}, //  169LU
{   71,  170,               0,    2.507981e+14,    0,                   0}, //  170LU
{   71,  171,               0,    1.027112e+15,    7,        1.157965e-26}, //  171LU
{   71,  172,               0,    8.351473e+14,    8,         1.13625e-26}, //  172LU
{   71,  173,               0,    6.237348e+16,    7,          1.1817e-26}, //  173LU
{   71,  174,               0,    1.507039e+17,    0,                   0}, //  174LU
{   71,  175,               0,              -1,    7,       1.1275135e-26}, //  175LU
{   71,  176,               0,    1.711902e+27,   14,        1.600446e-26}, //  176LU
{   71,  177,               0,    8.285398e+14,    7,        1.130392e-26}, //  177LU
{   71,  178,               0,    2.458352e+12,    0,                   0}, //  178LU
{   71,  179,               0,    2.383909e+13,    7,        1.199375e-26}, //  179LU
{   71,  180,               0,    4.934017e+11,    0,                   0}, //  180LU
{   71,  181,               0,     3.02966e+11,    0,                   0}, //  181LU
{   71,  182,               0,    1.731234e+11,    0,                   0}, //  182LU
{   71,  183,               0,    8.367631e+10,    0,                   0}, //  183LU
{   71,  184,               0,    2.741121e+10,    0,                   0}, //  184LU
{   72,  153,               0,         86.5617,    0,                   0}, //  153HF
{   72,  154,               0,     2.88539e+09,    0,                   0}, //  154HF
{   72,  155,               0,    1.283999e+09,    0,                   0}, //  155HF
{   72,  156,               0,    3.318199e+07,    0,                   0}, //  156HF
{   72,  157,               0,    1.586965e+08,    0,                   0}, //  157HF
{   72,  158,               0,    4.111681e+09,    0,                   0}, //  158HF
{   72,  159,               0,    8.079092e+09,    0,                   0}, //  159HF
{   72,  160,               0,    1.962065e+10,    0,                   0}, //  160HF
{   72,  161,               0,    2.625705e+10,    0,                   0}, //  161HF
{   72,  162,               0,    5.684218e+10,    0,                   0}, //  162HF
{   72,  163,               0,     5.77078e+10,    0,                   0}, //  163HF
{   72,  164,               0,    1.601391e+11,    0,                   0}, //  164HF
{   72,  165,               0,    1.096448e+11,    0,                   0}, //  165HF
{   72,  166,               0,    5.860227e+11,    0,                   0}, //  166HF
{   72,  167,               0,    1.774515e+11,    0,                   0}, //  167HF
{   72,  168,               0,    2.246276e+12,    0,                   0}, //  168HF
{   72,  169,               0,    2.804599e+11,    0,                   0}, //  169HF
{   72,  170,               0,    8.315117e+13,    0,                   0}, //  170HF
{   72,  171,               0,     6.28438e+13,    0,                   0}, //  171HF
{   72,  172,               0,    8.513776e+16,    0,                   0}, //  172HF
{   72,  173,               0,    1.225714e+14,    0,                   0}, //  173HF
{   72,  174,               0,     9.10557e+31,    0,                   0}, //  174HF
{   72,  175,               0,     8.72542e+15,    0,                   0}, //  175HF
{   72,  176,               0,              -1,    0,                   0}, //  176HF
{   72,  177,               0,              -1,    0,                   0}, //  177HF
{   72,  178,               0,              -1,    0,                   0}, //  178HF
{   72,  179,               0,              -1,    9,       -3.236545e-27}, //  179HF
{   72,  180,               0,              -1,    0,                   0}, //  180HF
{   72,  181,               0,    5.283871e+15,    0,                   0}, //  181HF
{   72,  182,               0,    4.051953e+23,    0,                   0}, //  182HF
{   72,  183,               0,     5.54168e+12,    0,                   0}, //  183HF
{   72,  184,               0,    2.139805e+13,    0,                   0}, //  184HF
{   72,  185,               0,     3.02966e+11,    0,                   0}, //  185HF
{   72,  186,               0,    2.250604e+11,    0,                   0}, //  186HF
{   72,  189,               0,        432.8085,    0,                   0}, //  189HF
{   73,  156,               0,    2.077481e+08,    0,                   0}, //  156TA
{   73,  157,               0,    1.457122e+07,    0,                   0}, //  157TA
{   73,  158,               0,    7.934823e+07,    0,                   0}, //  158TA
{   73,  159,               0,    1.197437e+09,    0,                   0}, //  159TA
{   73,  160,               0,    2.236177e+09,    0,                   0}, //  160TA
{   73,  162,               0,    5.150421e+09,    0,                   0}, //  162TA
{   73,  163,               0,    1.529257e+10,    0,                   0}, //  163TA
{   73,  164,               0,    2.048627e+10,    0,                   0}, //  164TA
{   73,  165,               0,    4.472355e+10,    0,                   0}, //  165TA
{   73,  166,               0,    4.962871e+10,    0,                   0}, //  166TA
{   73,  167,               0,    1.154156e+11,    0,                   0}, //  167TA
{   73,  168,               0,    1.731234e+11,    0,                   0}, //  168TA
{   73,  169,               0,    4.241523e+11,    0,                   0}, //  169TA
{   73,  170,               0,    5.851571e+11,    0,                   0}, //  170TA
{   73,  171,               0,    2.016888e+12,    0,                   0}, //  171TA
{   73,  172,               0,    3.185471e+12,    0,                   0}, //  172TA
{   73,  173,               0,    1.630822e+13,    5,         8.60015e-27}, //  173TA
{   73,  174,               0,     5.92082e+12,    0,                   0}, //  174TA
{   73,  175,               0,    5.453387e+13,    7,         1.14635e-26}, //  175TA
{   73,  176,               0,    4.201705e+13,    0,                   0}, //  176TA
{   73,  177,               0,    2.937616e+14,    0,                   0}, //  177TA
{   73,  179,               0,    8.286119e+16,    7,        1.155945e-26}, //  179TA
{   73,  180,               0,    4.234887e+13,    0,                   0}, //  180TA
{   73,  181,               0,              -1,    7,       1.1971025e-26}, //  181TA
{   73,  182,               0,    1.430216e+16,    0,                   0}, //  182TA
{   73,  183,               0,    6.357091e+14,    7,          1.1514e-26}, //  183TA
{   73,  184,               0,    4.518521e+13,    0,                   0}, //  184TA
{   73,  185,               0,    4.276148e+12,    0,                   0}, //  185TA
{   73,  186,               0,    9.088979e+11,    0,                   0}, //  186TA
{   73,  190,               0,    7.646284e+09,    0,                   0}, //  190TA
{   73,  191,               0,        432.8085,    0,                   0}, //  191TA
{   74,  158,               0,         1803369,    0,                   0}, //   158W
{   74,  159,               0,    1.053167e+07,    0,                   0}, //   159W
{   74,  160,               0,    1.312852e+08,    0,                   0}, //   160W
{   74,  161,               0,    5.900623e+08,    0,                   0}, //   161W
{   74,  162,               0,    1.962065e+09,    0,                   0}, //   162W
{   74,  163,               0,    3.851996e+09,    0,                   0}, //   163W
{   74,  164,               0,    9.088979e+09,    0,                   0}, //   164W
{   74,  165,               0,    7.357745e+09,    0,                   0}, //   165W
{   74,  166,               0,    2.769974e+10,    0,                   0}, //   166W
{   74,  167,               0,    2.870963e+10,    0,                   0}, //   167W
{   74,  168,               0,    7.343318e+10,    0,                   0}, //   168W
{   74,  169,               0,    1.067594e+11,    0,                   0}, //   169W
{   74,  170,               0,    2.094793e+11,    0,                   0}, //   170W
{   74,  171,               0,    2.060169e+11,    0,                   0}, //   171W
{   74,  172,               0,    5.713072e+11,    0,                   0}, //   172W
{   74,  173,               0,    6.578689e+11,    0,                   0}, //   173W
{   74,  174,               0,    2.873849e+12,    0,                   0}, //   174W
{   74,  175,               0,    3.046972e+12,    0,                   0}, //   175W
{   74,  176,               0,    1.298426e+13,    0,                   0}, //   176W
{   74,  177,               0,    1.142614e+13,    0,                   0}, //   177W
{   74,  178,               0,    2.692357e+15,    0,                   0}, //   178W
{   74,  179,               0,    3.207111e+12,    0,                   0}, //   179W
{   74,  180,               0,    5.008027e+33,    0,                   0}, //   180W
{   74,  181,               0,     1.51079e+16,    0,                   0}, //   181W
{   74,  182,               0,              -1,    0,                   0}, //   182W
{   74,  183,               0,    5.008027e+33,    1,         5.94813e-28}, //   183W
{   74,  184,               0,              -1,    0,                   0}, //   184W
{   74,  185,               0,    9.361071e+15,    0,                   0}, //   185W
{   74,  186,               0,              -1,    0,                   0}, //   186W
{   74,  187,               0,    1.246489e+14,    3,         3.13605e-27}, //   187W
{   74,  188,               0,    8.698008e+15,    0,                   0}, //   188W
{   74,  189,               0,    9.262102e+11,    0,                   0}, //   189W
{   74,  190,               0,    2.596851e+12,    0,                   0}, //   190W
{   74,  193,               0,        432.8085,    0,                   0}, //   193W
{   74,  194,               0,        432.8085,    0,                   0}, //   194W
{   75,  160,               0,         1183010,    0,                   0}, //  160RE
{   75,  161,               0,        634785.8,    0,                   0}, //  161RE
{   75,  162,               0,    1.543684e+08,    0,                   0}, //  162RE
{   75,  163,               0,    5.626511e+08,    0,                   0}, //  163RE
{   75,  164,               0,    7.646284e+08,    0,                   0}, //  164RE
{   75,  165,               0,    3.765434e+09,    0,                   0}, //  165RE
{   75,  166,               0,    3.246064e+09,    0,                   0}, //  166RE
{   75,  167,               0,    8.511901e+09,    0,                   0}, //  167RE
{   75,  168,               0,    6.347858e+09,    0,                   0}, //  168RE
{   75,  169,               0,    1.168583e+10,    0,                   0}, //  169RE
{   75,  170,               0,    1.327279e+10,    0,                   0}, //  170RE
{   75,  171,               0,    2.192896e+10,    0,                   0}, //  171RE
{   75,  173,               0,    1.713922e+11,    0,                   0}, //  173RE
{   75,  174,               0,    2.077481e+11,    0,                   0}, //  174RE
{   75,  175,               0,    5.098484e+11,    0,                   0}, //  175RE
{   75,  176,               0,     4.58777e+11,    0,                   0}, //  176RE
{   75,  177,               0,    1.211864e+12,    0,                   0}, //  177RE
{   75,  178,               0,    1.142614e+12,    0,                   0}, //  178RE
{   75,  179,               0,    1.687953e+12,    5,           1.414e-26}, //  179RE
{   75,  180,               0,    2.112106e+11,    0,                   0}, //  180RE
{   75,  181,               0,    1.033547e+14,    5,         1.61095e-26}, //  181RE
{   75,  182,               0,    3.323969e+14,   14,          1.4342e-26}, //  182RE
{   75,  183,               0,     8.72542e+15,    0,                   0}, //  183RE
{   75,  184,               0,    4.412627e+15,    0,                   0}, //  184RE
{   75,  185,               0,              -1,    5,       1.6094855e-26}, //  185RE
{   75,  186,               0,    4.634802e+14,    2,         8.78195e-27}, //  186RE
{   75,  187,               0,    1.971299e+27,    5,        1.625948e-26}, //  187RE
{   75,  188,               0,    8.831313e+13,    2,          9.0294e-27}, //  188RE
{   75,  189,               0,     1.26207e+14,    0,                   0}, //  189RE
{   75,  190,               0,    2.683413e+11,    0,                   0}, //  190RE
{   75,  191,               0,    8.483047e+11,    0,                   0}, //  191RE
{   75,  192,               0,    2.308312e+10,    0,                   0}, //  192RE
{   75,  194,               0,    1.442695e+09,    0,                   0}, //  194RE
{   75,  195,               0,     8.65617e+09,    0,                   0}, //  195RE
{   76,  161,               0,        923324.8,    0,                   0}, //  161OS
{   76,  162,               0,         3029660,    0,                   0}, //  162OS
{   76,  163,               0,         7934823,    0,                   0}, //  163OS
{   76,  164,               0,     3.02966e+07,    0,                   0}, //  164OS
{   76,  165,               0,    1.024313e+08,    0,                   0}, //  165OS
{   76,  166,               0,    2.870963e+08,    0,                   0}, //  166OS
{   76,  167,               0,    1.168583e+09,    0,                   0}, //  167OS
{   76,  168,               0,     3.02966e+09,    0,                   0}, //  168OS
{   76,  169,               0,    4.948444e+09,    0,                   0}, //  169OS
{   76,  170,               0,    1.063266e+10,    0,                   0}, //  170OS
{   76,  171,               0,    1.197437e+10,    0,                   0}, //  171OS
{   76,  172,               0,    2.769974e+10,    0,                   0}, //  172OS
{   76,  173,               0,    2.308312e+10,    0,                   0}, //  173OS
{   76,  174,               0,    6.347858e+10,    0,                   0}, //  174OS
{   76,  175,               0,    1.211864e+11,    0,                   0}, //  175OS
{   76,  176,               0,    3.116221e+11,    0,                   0}, //  176OS
{   76,  177,               0,    2.596851e+11,    0,                   0}, //  177OS
{   76,  178,               0,    4.328085e+11,    0,                   0}, //  178OS
{   76,  179,               0,    5.626511e+11,    0,                   0}, //  179OS
{   76,  180,               0,    1.861077e+12,    0,                   0}, //  180OS
{   76,  181,               0,    9.088979e+12,    0,                   0}, //  181OS
{   76,  182,               0,    1.134305e+14,    0,                   0}, //  182OS
{   76,  183,               0,    6.751813e+13,    0,                   0}, //  183OS
{   76,  184,               0,    2.549531e+30,    0,                   0}, //  184OS
{   76,  185,               0,    1.166707e+16,    0,                   0}, //  185OS
{   76,  186,               0,     9.10557e+31,    0,                   0}, //  186OS
{   76,  187,               0,              -1,    1,     3.264920445e-28}, //  187OS
{   76,  188,               0,              -1,    0,                   0}, //  188OS
{   76,  189,               0,              -1,    3,      3.33266165e-27}, //  189OS
{   76,  190,               0,              -1,    0,                   0}, //  190OS
{   76,  191,               0,     1.91965e+15,    9,           4.848e-27}, //  191OS
{   76,  192,               0,              -1,    0,                   0}, //  192OS
{   76,  193,               0,    1.563881e+14,    3,        3.684985e-27}, //  193OS
{   76,  194,               0,    2.731743e+17,    0,                   0}, //  194OS
{   76,  195,               0,    7.790553e+11,    0,                   0}, //  195OS
{   76,  196,               0,    3.021003e+12,    0,                   0}, //  196OS
{   76,  197,               0,    2.423728e+11,    0,                   0}, //  197OS
{   76,  199,               0,    7.213475e+09,    0,                   0}, //  199OS
{   76,  200,               0,     8.65617e+09,    0,                   0}, //  200OS
{   77,  165,               0,        1442.695,    0,                   0}, //  165IR
{   77,  166,               0,     1.51483e+07,    0,                   0}, //  166IR
{   77,  167,               0,    5.078287e+07,    0,                   0}, //  167IR
{   77,  168,               0,    3.202783e+08,    0,                   0}, //  168IR
{   77,  169,               0,    5.092713e+08,    0,                   0}, //  169IR
{   77,  170,               0,    1.255145e+09,    0,                   0}, //  170IR
{   77,  171,               0,    4.616624e+09,    0,                   0}, //  171IR
{   77,  172,               0,    6.347858e+09,    0,                   0}, //  172IR
{   77,  174,               0,    1.139729e+10,    0,                   0}, //  174IR
{   77,  175,               0,    1.298426e+10,    0,                   0}, //  175IR
{   77,  176,               0,    1.255145e+10,    0,                   0}, //  176IR
{   77,  177,               0,    4.328085e+10,    0,                   0}, //  177IR
{   77,  178,               0,    1.731234e+10,    0,                   0}, //  178IR
{   77,  179,               0,    1.139729e+11,    0,                   0}, //  179IR
{   77,  180,               0,    1.298426e+11,    0,                   0}, //  180IR
{   77,  181,               0,    4.241523e+11,    0,                   0}, //  181IR
{   77,  182,               0,    1.298426e+12,    6,           1.313e-26}, //  182IR
{   77,  183,               0,    5.020579e+12,    0,                   0}, //  183IR
{   77,  184,               0,    1.604854e+13,   10,          3.5148e-27}, //  184IR
{   77,  185,               0,    7.478931e+13,    5,        1.315525e-26}, //  185IR
{   77,  186,               0,     8.64232e+13,   10,          1.9594e-26}, //  186IR
{   77,  187,               0,    5.453387e+13,    3,          8.6355e-28}, //  187IR
{   77,  188,               0,    2.155386e+14,    2,          1.5251e-27}, //  188IR
{   77,  189,               0,    1.645394e+15,    3,           6.565e-28}, //  189IR
{   77,  190,               0,    1.468375e+15,    8,            2.02e-28}, //  190IR
{   77,  191,               0,              -1,    3,         7.61035e-28}, //  191IR
{   77,  192,               0,    9.202519e+15,    8,          9.7162e-27}, //  192IR
{   77,  193,               0,              -1,    3,         8.26685e-28}, //  193IR
{   77,  194,               0,    1.001346e+14,    2,          1.9695e-27}, //  194IR
{   77,  195,               0,    1.298426e+13,    0,                   0}, //  195IR
{   77,  196,               0,    7.502014e+10,    0,                   0}, //  196IR
{   77,  197,               0,    5.020579e+11,    0,                   0}, //  197IR
{   77,  198,               0,    1.154156e+10,    0,                   0}, //  198IR
{   77,  199,               0,     8.65617e+09,    0,                   0}, //  199IR
{   77,  200,               0,        432.8085,    0,                   0}, //  200IR
{   77,  201,               0,        432.8085,    0,                   0}, //  201IR
{   77,  202,               0,    1.586965e+10,    0,                   0}, //  202IR
{   78,  166,               0,        432808.5,    0,                   0}, //  166PT
{   78,  167,               0,         1009887,    0,                   0}, //  167PT
{   78,  168,               0,         2914244,    0,                   0}, //  168PT
{   78,  169,               0,    1.009887e+07,    0,                   0}, //  169PT
{   78,  170,               0,    1.990919e+07,    0,                   0}, //  170PT
{   78,  171,               0,    6.564262e+07,    0,                   0}, //  171PT
{   78,  172,               0,     1.40807e+08,    0,                   0}, //  172PT
{   78,  173,               0,    5.511095e+08,    0,                   0}, //  173PT
{   78,  174,               0,    1.282556e+09,    0,                   0}, //  174PT
{   78,  175,               0,    3.650018e+09,    0,                   0}, //  175PT
{   78,  176,               0,     9.13226e+09,    0,                   0}, //  176PT
{   78,  177,               0,    1.529257e+10,    0,                   0}, //  177PT
{   78,  178,               0,    2.986379e+10,    0,                   0}, //  178PT
{   78,  179,               0,    3.058513e+10,    1,          2.1715e-27}, //  179PT
{   78,  180,               0,    8.079092e+10,    0,                   0}, //  180PT
{   78,  181,               0,    7.502014e+10,    1,          2.4442e-27}, //  181PT
{   78,  182,               0,    2.311197e+11,    0,                   0}, //  182PT
{   78,  183,               0,    5.626511e+11,    1,         2.63105e-27}, //  183PT
{   78,  184,               0,    1.497517e+12,    0,                   0}, //  184PT
{   78,  185,               0,    6.137225e+12,    9,         -3.9087e-27}, //  185PT
{   78,  186,               0,     1.08029e+13,    0,                   0}, //  186PT
{   78,  187,               0,     1.22052e+13,    3,        -2.02505e-27}, //  187PT
{   78,  188,               0,    1.271418e+15,    0,                   0}, //  188PT
{   78,  189,               0,    5.645554e+13,    3,        -2.12605e-27}, //  189PT
{   78,  190,               0,    2.959256e+28,    0,                   0}, //  190PT
{   78,  191,               0,    3.527534e+14,    3,        -2.53005e-27}, //  191PT
{   78,  192,               0,              -1,    0,                   0}, //  192PT
{   78,  193,               0,    2.276429e+18,    1,         3.04515e-27}, //  193PT
{   78,  194,               0,              -1,    0,                   0}, //  194PT
{   78,  195,               0,              -1,    1,        3.078076e-27}, //  195PT
{   78,  196,               0,              -1,    0,                   0}, //  196PT
{   78,  197,               0,    1.033099e+14,    1,          2.5755e-27}, //  197PT
{   78,  198,               0,              -1,    0,                   0}, //  198PT
{   78,  199,               0,      2.6661e+12,    0,                   0}, //  199PT
{   78,  200,               0,    6.544065e+13,    0,                   0}, //  200PT
{   78,  201,               0,    2.164043e+11,    0,                   0}, //  201PT
{   78,  202,               0,    2.285229e+14,    0,                   0}, //  202PT
{   78,  203,               0,    1.442695e+10,    0,                   0}, //  203PT
{   78,  204,               0,    1.485976e+10,    0,                   0}, //  204PT
{   78,  205,               0,        432.8085,    0,                   0}, //  205PT
{   79,  170,               0,        432808.5,    0,                   0}, //  170AU
{   79,  171,               0,        24525.82,    0,                   0}, //  171AU
{   79,  172,               0,    3.173929e+07,    0,                   0}, //  172AU
{   79,  173,               0,    3.606738e+07,    0,                   0}, //  173AU
{   79,  174,               0,    1.731234e+08,    0,                   0}, //  174AU
{   79,  177,               0,     2.10922e+09,    0,                   0}, //  177AU
{   79,  178,               0,    3.751007e+09,    0,                   0}, //  178AU
{   79,  179,               0,    1.024313e+10,    0,                   0}, //  179AU
{   79,  180,               0,    1.168583e+10,    0,                   0}, //  180AU
{   79,  181,               0,    1.976492e+10,    0,                   0}, //  181AU
{   79,  182,               0,    2.236177e+10,    0,                   0}, //  182AU
{   79,  183,               0,    6.174735e+10,    0,                   0}, //  183AU
{   79,  184,               0,    2.971952e+10,   10,         1.04535e-26}, //  184AU
{   79,  185,               0,    3.678872e+11,    5,         1.09585e-26}, //  185AU
{   79,  186,               0,    9.262102e+11,    6,         -6.4236e-27}, //  186AU
{   79,  187,               0,    7.184621e+11,    0,                   0}, //  187AU
{   79,  188,               0,    7.652054e+11,    0,                   0}, //  188AU
{   79,  189,               0,    2.484321e+12,    1,          2.4947e-27}, //  189AU
{   79,  190,               0,    3.704841e+12,    2,         -3.2825e-28}, //  190AU
{   79,  191,               0,    1.651597e+13,    3,         6.91345e-28}, //  191AU
{   79,  192,               0,    2.565689e+13,    2,         -5.4035e-29}, //  192AU
{   79,  193,               0,    9.166884e+13,    3,          7.0498e-28}, //  193AU
{   79,  194,               0,    1.974617e+14,    2,         3.85315e-28}, //  194AU
{   79,  195,               0,    2.319709e+16,    0,                   0}, //  195AU
{   79,  196,               0,    7.686968e+14,    0,                   0}, //  196AU
{   79,  197,               0,              -1,    0,                   0}, //  197AU
{   79,  198,               0,    3.358883e+14,    4,         2.99667e-27}, //  198AU
{   79,  199,               0,    3.912733e+14,    3,        1.371075e-27}, //  199AU
{   79,  200,               0,    4.189586e+12,    0,                   0}, //  200AU
{   79,  201,               0,    2.250604e+12,    0,                   0}, //  201AU
{   79,  202,               0,    4.097254e+10,    0,                   0}, //  202AU
{   79,  203,               0,     8.65617e+10,    0,                   0}, //  203AU
{   79,  204,               0,    5.741926e+10,    0,                   0}, //  204AU
{   79,  205,               0,    4.472355e+10,    0,                   0}, //  205AU
{   79,  206,               0,        432.8085,    0,                   0}, //  206AU
{   79,  207,               0,        432.8085,    0,                   0}, //  207AU
{   79,  208,               0,        432.8085,    0,                   0}, //  208AU
{   79,  209,               0,        432.8085,    0,                   0}, //  209AU
{   79,  210,               0,        432.8085,    0,                   0}, //  210AU
{   80,  171,               0,        85119.01,    0,                   0}, //  171HG
{   80,  172,               0,        333262.6,    0,                   0}, //  172HG
{   80,  173,               0,         1298426,    0,                   0}, //  173HG
{   80,  174,               0,         3029660,    0,                   0}, //  174HG
{   80,  175,               0,    1.529257e+07,    0,                   0}, //  175HG
{   80,  176,               0,    2.928671e+07,    0,                   0}, //  176HG
{   80,  177,               0,    1.836551e+08,    0,                   0}, //  177HG
{   80,  178,               0,    3.844782e+08,    0,                   0}, //  178HG
{   80,  179,               0,     1.51483e+09,    0,                   0}, //  179HG
{   80,  180,               0,    3.722153e+09,    0,                   0}, //  180HG
{   80,  181,               0,    5.193702e+09,    1,        2.560855e-27}, //  181HG
{   80,  182,               0,    1.562439e+10,    0,                   0}, //  182HG
{   80,  183,               0,    1.356133e+10,    1,          2.6462e-27}, //  183HG
{   80,  184,               0,      4.4536e+10,    0,                   0}, //  184HG
{   80,  185,               0,    7.083633e+10,    1,          2.5654e-27}, //  185HG
{   80,  186,               0,    1.194551e+11,    0,                   0}, //  186HG
{   80,  187,               0,    2.077481e+11,    0,                   0}, //  187HG
{   80,  188,               0,    2.813255e+11,    0,                   0}, //  188HG
{   80,  189,               0,    6.578689e+11,    3,        -3.07343e-27}, //  189HG
{   80,  190,               0,    1.731234e+12,    0,                   0}, //  190HG
{   80,  191,               0,    4.241523e+12,    0,                   0}, //  191HG
{   80,  192,               0,    2.518946e+13,    0,                   0}, //  192HG
{   80,  193,               0,    1.973607e+13,    0,                   0}, //  193HG
{   80,  194,               0,    2.021504e+19,    0,                   0}, //  194HG
{   80,  195,               0,    5.468968e+13,    1,        2.734448e-27}, //  195HG
{   80,  196,               0,              -1,    0,                   0}, //  196HG
{   80,  197,               0,    3.331183e+14,    0,                   0}, //  197HG
{   80,  198,               0,              -1,    0,                   0}, //  198HG
{   80,  199,               0,              -1,    1,     2.554721775e-27}, //  199HG
{   80,  200,               0,              -1,    0,                   0}, //  200HG
{   80,  201,               0,              -1,    3,    -2.829139785e-27}, //  201HG
{   80,  202,               0,              -1,    0,                   0}, //  202HG
{   80,  203,               0,    5.807857e+15,    5,        4.287197e-27}, //  203HG
{   80,  204,               0,              -1,    0,                   0}, //  204HG
{   80,  205,               0,    4.449272e+11,    0,                   0}, //  205HG
{   80,  206,               0,    7.201934e+11,    0,                   0}, //  206HG
{   80,  207,               0,    2.510289e+11,    0,                   0}, //  207HG
{   80,  208,               0,     3.54903e+12,    0,                   0}, //  208HG
{   80,  209,               0,    5.049433e+10,    0,                   0}, //  209HG
{   80,  211,               0,        432.8085,    0,                   0}, //  211HG
{   80,  212,               0,        432.8085,    0,                   0}, //  212HG
{   80,  213,               0,        432.8085,    0,                   0}, //  213HG
{   80,  214,               0,        432.8085,    0,                   0}, //  214HG
{   80,  215,               0,        432.8085,    0,                   0}, //  215HG
{   80,  216,               0,        432.8085,    0,                   0}, //  216HG
{   81,  176,               0,         7502014,    0,                   0}, //  176TL
{   81,  177,               0,    2.596851e+07,    0,                   0}, //  177TL
{   81,  178,               0,    3.664445e+08,    0,                   0}, //  178TL
{   81,  179,               0,    3.318199e+08,    0,                   0}, //  179TL
{   81,  180,               0,    2.164043e+09,    0,                   0}, //  180TL
{   81,  181,               0,    4.616624e+09,    0,                   0}, //  181TL
{   81,  182,               0,    4.472355e+09,    0,                   0}, //  182TL
{   81,  183,               0,    9.954596e+09,    0,                   0}, //  183TL
{   81,  184,               0,    1.457122e+10,    0,                   0}, //  184TL
{   81,  185,               0,    2.813255e+10,    0,                   0}, //  185TL
{   81,  187,               0,    7.357745e+10,    0,                   0}, //  187TL
{   81,  189,               0,    1.990919e+11,    0,                   0}, //  189TL
{   81,  192,               0,    8.309923e+11,    0,                   0}, //  192TL
{   81,  193,               0,    1.869733e+12,    0,                   0}, //  193TL
{   81,  194,               0,    2.856536e+12,    4,            7.07e-28}, //  194TL
{   81,  195,               0,    6.024694e+12,    1,           7.979e-27}, //  195TL
{   81,  196,               0,    9.556412e+12,    0,                   0}, //  196TL
{   81,  197,               0,    1.475011e+13,    0,                   0}, //  197TL
{   81,  198,               0,    2.752662e+13,    4,                   0}, //  198TL
{   81,  199,               0,    3.853727e+13,    1,            8.08e-27}, //  199TL
{   81,  200,               0,    1.355556e+14,    4,            2.02e-28}, //  200TL
{   81,  201,               0,     3.79198e+14,    1,         8.10525e-27}, //  201TL
{   81,  202,               0,     1.53445e+15,    0,                   0}, //  202TL
{   81,  203,               0,              -1,    1,    8.1924022435e-27}, //  203TL
{   81,  204,               0,    1.722289e+17,    4,           4.545e-28}, //  204TL
{   81,  205,               0,              -1,    0,                   0}, //  205TL
{   81,  206,               0,    3.637323e+11,    0,                   0}, //  206TL
{   81,  207,               0,    4.128993e+11,    1,          9.4738e-27}, //  207TL
{   81,  208,               0,    2.642729e+11,   10,          1.4746e-27}, //  208TL
{   81,  209,               0,    1.904357e+11,    0,                   0}, //  209TL
{   81,  210,               0,    1.125302e+11,    0,                   0}, //  210TL
{   81,  214,               0,        432.8085,    0,                   0}, //  214TL
{   81,  215,               0,        432.8085,    0,                   0}, //  215TL
{   81,  216,               0,        432.8085,    0,                   0}, //  216TL
{   81,  217,               0,        432.8085,    0,                   0}, //  217TL
{   82,  178,               0,        173123.4,    0,                   0}, //  178PB
{   82,  179,               0,         5049433,    0,                   0}, //  179PB
{   82,  180,               0,         6059319,    0,                   0}, //  180PB
{   82,  182,               0,    7.934823e+07,    0,                   0}, //  182PB
{   82,  183,               0,    7.718418e+08,    0,                   0}, //  183PB
{   82,  184,               0,    7.069206e+08,    0,                   0}, //  184PB
{   82,  185,               0,    9.088979e+09,    3,          -5.555e-27}, //  185PB
{   82,  186,               0,     6.95379e+09,    0,                   0}, //  186PB
{   82,  187,               0,    2.640132e+10,    0,                   0}, //  187PB
{   82,  188,               0,    3.621165e+10,    0,                   0}, //  188PB
{   82,  189,               0,    5.626511e+10,    0,                   0}, //  189PB
{   82,  190,               0,    1.024313e+11,    0,                   0}, //  190PB
{   82,  191,               0,    1.151271e+11,    0,                   0}, //  191PB
{   82,  192,               0,     3.02966e+11,    0,                   0}, //  192PB
{   82,  194,               0,    9.262102e+11,    0,                   0}, //  194PB
{   82,  195,               0,    1.298426e+12,    0,                   0}, //  195PB
{   82,  196,               0,    3.202783e+12,    0,                   0}, //  196PB
{   82,  197,               0,    7.011498e+11,    3,        -5.42875e-27}, //  197PB
{   82,  198,               0,    1.246489e+13,    0,                   0}, //  198PB
{   82,  199,               0,    7.790553e+12,    3,        -5.42471e-27}, //  199PB
{   82,  200,               0,    1.116646e+14,    0,                   0}, //  200PB
{   82,  201,               0,    4.845724e+13,    5,        3.410265e-27}, //  201PB
{   82,  202,               0,    2.390257e+21,    0,                   0}, //  202PB
{   82,  203,               0,    2.696541e+14,    5,         3.46632e-27}, //  203PB
{   82,  204,               0,    6.373971e+33,    0,                   0}, //  204PB
{   82,  205,               0,    7.876394e+23,    0,                   0}, //  205PB
{   82,  206,               0,              -1,    0,                   0}, //  206PB
{   82,  207,               0,              -1,    0,                   0}, //  207PB
{   82,  208,               0,              -1,    0,                   0}, //  208PB
{   82,  209,               0,     1.68954e+13,    9,       -7.441175e-27}, //  209PB
{   82,  210,               0,    1.010723e+18,    0,                   0}, //  210PB
{   82,  211,               0,    3.124877e+12,    0,                   0}, //  211PB
{   82,  212,               0,    5.526099e+13,    0,                   0}, //  212PB
{   82,  213,               0,    8.829294e+11,    0,                   0}, //  213PB
{   82,  214,               0,    2.319854e+12,    0,                   0}, //  214PB
{   82,  215,               0,    2.120762e+11,    0,                   0}, //  215PB
{   82,  216,               0,        432.8085,    0,                   0}, //  216PB
{   82,  217,               0,        432.8085,    0,                   0}, //  217PB
{   82,  218,               0,        432.8085,    0,                   0}, //  218PB
{   82,  219,               0,        432.8085,    0,                   0}, //  219PB
{   82,  220,               0,        432.8085,    0,                   0}, //  220PB
{   83,  185,               0,        83676.31,    0,                   0}, //  185BI
{   83,  186,               0,    2.164043e+07,    0,                   0}, //  186BI
{   83,  187,               0,    5.337972e+07,    0,                   0}, //  187BI
{   83,  189,               0,    9.492933e+08,    0,                   0}, //  189BI
{   83,  191,               0,    1.788942e+10,    0,                   0}, //  191BI
{   83,  192,               0,    4.991725e+10,    0,                   0}, //  192BI
{   83,  193,               0,     9.17554e+10,    0,                   0}, //  193BI
{   83,  194,               0,     1.37056e+11,    0,                   0}, //  194BI
{   83,  195,               0,    2.640132e+11,    0,                   0}, //  195BI
{   83,  196,               0,    4.443501e+11,    0,                   0}, //  196BI
{   83,  197,               0,    8.076207e+11,    0,                   0}, //  197BI
{   83,  198,               0,    8.915855e+11,    0,                   0}, //  198BI
{   83,  199,               0,    2.337166e+12,    9,           2.323e-26}, //  199BI
{   83,  200,               0,    3.150846e+12,    0,                   0}, //  200BI
{   83,  201,               0,    8.915855e+12,    9,           2.424e-26}, //  201BI
{   83,  202,               0,    8.881231e+12,   10,        2.150795e-26}, //  202BI
{   83,  203,               0,    6.107794e+13,    9,         -3.3835e-27}, //  203BI
{   83,  204,               0,    5.827334e+13,   12,         2.18261e-26}, //  204BI
{   83,  205,               0,    1.908397e+15,    0,                   0}, //  205BI
{   83,  206,               0,    7.781897e+14,   12,        2.202305e-26}, //  206BI
{   83,  207,               0,    1.436405e+18,    0,                   0}, //  207BI
{   83,  208,               0,    1.675402e+22,   10,         2.31189e-26}, //  208BI
{   83,  209,               0,              -1,    9,        2.075853e-26}, //  209BI
{   83,  210,               0,    6.247447e+14,    2,       -2.247755e-28}, //  210BI
{   83,  211,               0,     1.85242e+11,    9,          1.7675e-26}, //  211BI
{   83,  212,               0,    5.241311e+12,    0,                   0}, //  212BI
{   83,  213,               0,    3.946348e+12,    9,        1.877085e-26}, //  213BI
{   83,  214,               0,    1.722578e+12,    0,                   0}, //  214BI
{   83,  215,               0,    6.578689e+11,    0,                   0}, //  215BI
{   83,  216,               0,    1.947638e+11,    0,                   0}, //  216BI
{   83,  217,               0,    1.341706e+11,    0,                   0}, //  217BI
{   83,  218,               0,    4.760894e+10,    0,                   0}, //  218BI
{   83,  219,               0,        432.8085,    0,                   0}, //  219BI
{   83,  220,               0,        432.8085,    0,                   0}, //  220BI
{   83,  221,               0,        432.8085,    0,                   0}, //  221BI
{   83,  223,               0,        432.8085,    0,                   0}, //  223BI
{   83,  224,               0,        432.8085,    0,                   0}, //  224BI
{   84,  187,               0,         2019773,    0,                   0}, //  187PO
{   84,  188,               0,          577078,    0,                   0}, //  188PO
{   84,  189,               0,         5049433,    0,                   0}, //  189PO
{   84,  190,               0,         3549030,    0,                   0}, //  190PO
{   84,  191,               0,    3.173929e+07,    0,                   0}, //  191PO
{   84,  192,               0,    4.789748e+07,    0,                   0}, //  192PO
{   84,  194,               0,    5.655365e+08,    0,                   0}, //  194PO
{   84,  195,               0,    6.694105e+09,    0,                   0}, //  195PO
{   84,  196,               0,    8.367631e+09,    0,                   0}, //  196PO
{   84,  197,               0,    1.211864e+11,    0,                   0}, //  197PO
{   84,  198,               0,    1.532142e+11,    0,                   0}, //  198PO
{   84,  199,               0,    4.734925e+11,    0,                   0}, //  199PO
{   84,  200,               0,    9.963252e+11,    0,                   0}, //  200PO
{   84,  201,               0,    1.350363e+12,    3,           4.747e-27}, //  201PO
{   84,  202,               0,    3.860652e+12,    0,                   0}, //  202PO
{   84,  203,               0,    3.176814e+12,    0,                   0}, //  203PO
{   84,  204,               0,    1.827606e+13,    0,                   0}, //  204PO
{   84,  205,               0,    9.037042e+12,    5,           3.838e-27}, //  205PO
{   84,  206,               0,     1.09691e+15,    0,                   0}, //  206PO
{   84,  207,               0,    3.012347e+13,    5,          3.9895e-27}, //  207PO
{   84,  208,               0,    1.319402e+17,    0,                   0}, //  208PO
{   84,  209,               0,    4.643891e+18,    1,          3.8885e-27}, //  209PO
{   84,  210,               0,    1.724886e+16,    0,                   0}, //  210PO
{   84,  211,               0,    7.444306e+08,    0,                   0}, //  211PO
{   84,  212,               0,        431.3658,    0,                   0}, //  212PO
{   84,  213,               0,        5366.826,    0,                   0}, //  213PO
{   84,  214,               0,        237034.8,    0,                   0}, //  214PO
{   84,  215,               0,         2569440,    0,                   0}, //  215PO
{   84,  216,               0,    2.091908e+08,    0,                   0}, //  216PO
{   84,  217,               0,    2.106335e+09,    0,                   0}, //  217PO
{   84,  218,               0,    2.681682e+11,    0,                   0}, //  218PO
{   84,  219,               0,        432.8085,    0,                   0}, //  219PO
{   84,  220,               0,        432.8085,    0,                   0}, //  220PO
{   84,  222,               0,    7.934823e+11,    0,                   0}, //  222PO
{   84,  223,               0,        432.8085,    0,                   0}, //  223PO
{   84,  224,               0,        432.8085,    0,                   0}, //  224PO
{   84,  225,               0,        432.8085,    0,                   0}, //  225PO
{   84,  226,               0,        432.8085,    0,                   0}, //  226PO
{   84,  227,               0,        432.8085,    0,                   0}, //  227PO
{   85,  191,               0,         2452582,    0,                   0}, //  191AT
{   85,  193,               0,    4.039546e+07,    0,                   0}, //  193AT
{   85,  195,               0,     4.73204e+08,    0,                   0}, //  195AT
{   85,  196,               0,    5.597657e+08,    0,                   0}, //  196AT
{   85,  197,               0,    5.597657e+08,    0,                   0}, //  197AT
{   85,  198,               0,    5.482241e+09,    0,                   0}, //  198AT
{   85,  199,               0,    1.014215e+10,    0,                   0}, //  199AT
{   85,  200,               0,    6.203589e+10,    0,                   0}, //  200AT
{   85,  201,               0,    1.229176e+11,    0,                   0}, //  201AT
{   85,  202,               0,    2.654559e+11,    0,                   0}, //  202AT
{   85,  203,               0,    6.405566e+11,    0,                   0}, //  203AT
{   85,  204,               0,    7.894427e+11,    0,                   0}, //  204AT
{   85,  205,               0,     2.32851e+12,    0,                   0}, //  205AT
{   85,  206,               0,    2.648788e+12,    0,                   0}, //  206AT
{   85,  207,               0,    9.400601e+12,    0,                   0}, //  207AT
{   85,  208,               0,    8.465734e+12,    0,                   0}, //  208AT
{   85,  209,               0,    2.809793e+13,    0,                   0}, //  209AT
{   85,  210,               0,    4.206899e+13,    0,                   0}, //  210AT
{   85,  211,               0,    3.746679e+13,    0,                   0}, //  211AT
{   85,  212,               0,    4.530062e+08,    0,                   0}, //  212AT
{   85,  213,               0,        180.3369,    0,                   0}, //  213AT
{   85,  214,               0,        805.0238,    0,                   0}, //  214AT
{   85,  215,               0,        144269.5,    0,                   0}, //  215AT
{   85,  216,               0,        432808.5,    0,                   0}, //  216AT
{   85,  217,               0,    4.659905e+07,    0,                   0}, //  217AT
{   85,  218,               0,    2.164043e+09,    0,                   0}, //  218AT
{   85,  219,               0,    8.079092e+10,    0,                   0}, //  219AT
{   85,  220,               0,    3.211439e+11,    0,                   0}, //  220AT
{   85,  221,               0,    1.990919e+11,    0,                   0}, //  221AT
{   85,  222,               0,    7.790553e+10,    0,                   0}, //  222AT
{   85,  223,               0,    7.213475e+10,    0,                   0}, //  223AT
{   85,  224,               0,    2.164043e+11,    0,                   0}, //  224AT
{   85,  225,               0,        432.8085,    0,                   0}, //  225AT
{   85,  226,               0,        432.8085,    0,                   0}, //  226AT
{   85,  227,               0,        432.8085,    0,                   0}, //  227AT
{   85,  228,               0,        432.8085,    0,                   0}, //  228AT
{   85,  229,               0,        432.8085,    0,                   0}, //  229AT
{   86,  194,               0,         1125302,    0,                   0}, //  194RN
{   86,  195,               0,         8656170,    0,                   0}, //  195RN
{   86,  196,               0,         6347858,    0,                   0}, //  196RN
{   86,  197,               0,    9.377518e+07,    0,                   0}, //  197RN
{   86,  198,               0,    9.377518e+07,    0,                   0}, //  198RN
{   86,  199,               0,    8.511901e+08,    0,                   0}, //  199RN
{   86,  200,               0,    1.485976e+09,    0,                   0}, //  200RN
{   86,  201,               0,    1.009887e+10,    0,                   0}, //  201RN
{   86,  202,               0,    1.399414e+10,    0,                   0}, //  202RN
{   86,  203,               0,    6.347858e+10,    0,                   0}, //  203RN
{   86,  204,               0,    1.074808e+11,    0,                   0}, //  204RN
{   86,  205,               0,    2.452582e+11,    5,          4.0501e-27}, //  205RN
{   86,  206,               0,    4.908049e+11,    0,                   0}, //  206RN
{   86,  207,               0,    8.006957e+11,    5,          4.1208e-27}, //  207RN
{   86,  208,               0,    2.107777e+12,    0,                   0}, //  208RN
{   86,  209,               0,    2.467009e+12,    5,         4.23594e-27}, //  209RN
{   86,  210,               0,    1.246489e+13,    0,                   0}, //  210RN
{   86,  211,               0,    7.582805e+13,    1,         3.03505e-27}, //  211RN
{   86,  212,               0,    2.068825e+12,    0,                   0}, //  212RN
{   86,  213,               0,    2.813255e+07,    0,                   0}, //  213RN
{   86,  214,               0,        389.5277,    0,                   0}, //  214RN
{   86,  215,               0,        3318.199,    0,                   0}, //  215RN
{   86,  216,               0,        64921.28,    0,                   0}, //  216RN
{   86,  217,               0,        779055.3,    0,                   0}, //  217RN
{   86,  218,               0,    5.049433e+07,    0,                   0}, //  218RN
{   86,  219,               0,    5.713072e+09,    5,         -2.2321e-27}, //  219RN
{   86,  220,               0,    8.021384e+10,    0,                   0}, //  220RN
{   86,  221,               0,    2.164043e+12,    7,           -1.01e-28}, //  221RN
{   86,  222,               0,    4.765943e+14,    0,                   0}, //  222RN
{   86,  223,               0,    2.103449e+12,82914,         -3.9188e-27}, //  223RN
{   86,  224,               0,    9.262102e+12,    0,                   0}, //  224RN
{   86,  225,               0,    4.033775e+11,    7,         -3.5148e-27}, //  225RN
{   86,  226,               0,    6.405566e+11,    0,                   0}, //  226RN
{   86,  227,               0,    3.000806e+10,    0,                   0}, //  227RN
{   86,  228,               0,    9.377518e+10,    0,                   0}, //  228RN
{   86,  229,               0,    1.731234e+10,    0,                   0}, //  229RN
{   86,  230,               0,        432.8085,    0,                   0}, //  230RN
{   86,  231,               0,        432.8085,    0,                   0}, //  231RN
{   87,  199,               0,    1.731234e+07,    0,                   0}, //  199FR
{   87,  200,               0,    7.069206e+07,    0,                   0}, //  200FR
{   87,  201,               0,    8.944709e+07,    0,                   0}, //  201FR
{   87,  202,               0,    4.328085e+08,    0,                   0}, //  202FR
{   87,  203,               0,    7.934823e+08,    0,                   0}, //  203FR
{   87,  204,               0,    2.596851e+09,    0,                   0}, //  204FR
{   87,  205,               0,    5.655365e+09,    0,                   0}, //  205FR
{   87,  206,               0,    2.308312e+10,    0,                   0}, //  206FR
{   87,  207,               0,    2.135189e+10,    9,         1.96445e-26}, //  207FR
{   87,  208,               0,    8.526328e+10,   14,         2.39875e-26}, //  208FR
{   87,  209,               0,    7.213475e+10,    9,         1.99475e-26}, //  209FR
{   87,  210,               0,    2.752662e+11,   12,           2.222e-26}, //  210FR
{   87,  211,               0,    2.683413e+11,    9,            2.02e-26}, //  211FR
{   87,  212,               0,    1.731234e+12,   10,          2.3331e-26}, //  212FR
{   87,  213,               0,    5.023464e+10,    9,          2.0301e-26}, //  213FR
{   87,  214,               0,         7213475,    0,                   0}, //  214FR
{   87,  215,               0,        124.0718,    0,                   0}, //  215FR
{   87,  216,               0,        1009.887,    0,                   0}, //  216FR
{   87,  217,               0,        27411.21,    0,                   0}, //  217FR
{   87,  218,               0,         1442695,    0,                   0}, //  218FR
{   87,  219,               0,     2.88539e+07,    0,                   0}, //  219FR
{   87,  220,               0,    3.952984e+10,    2,         -3.3835e-27}, //  220FR
{   87,  221,               0,    4.241523e+11,    5,           7.979e-27}, //  221FR
{   87,  222,               0,    1.229176e+12,    4,          3.1815e-27}, //  222FR
{   87,  223,               0,    1.904357e+12,    0,                   0}, //  223FR
{   87,  224,               0,    2.882505e+11,    2,            2.02e-27}, //  224FR
{   87,  225,               0,    3.419187e+11,    3,          5.4035e-27}, //  225FR
{   87,  226,               0,    7.069206e+10,    2,          3.5956e-28}, //  226FR
{   87,  227,               0,    2.138074e+11,    1,           7.575e-27}, //  227FR
{   87,  228,               0,    5.482241e+10,    4,          -3.838e-27}, //  228FR
{   87,  229,               0,    7.242329e+10,    0,                   0}, //  229FR
{   87,  230,               0,    2.755548e+10,    0,                   0}, //  230FR
{   87,  231,               0,    2.539143e+10,    0,                   0}, //  231FR
{   87,  232,               0,    7.934823e+09,    0,                   0}, //  232FR
{   87,  233,               0,        432.8085,    0,                   0}, //  233FR
{   88,  202,               0,    2.308312e+07,    0,                   0}, //  202RA
{   88,  203,               0,    4.472355e+07,    0,                   0}, //  203RA
{   88,  204,               0,    8.223362e+07,    0,                   0}, //  204RA
{   88,  205,               0,     3.02966e+08,    0,                   0}, //  205RA
{   88,  206,               0,    3.462468e+08,    0,                   0}, //  206RA
{   88,  207,               0,    1.947638e+09,    0,                   0}, //  207RA
{   88,  208,               0,    1.875504e+09,    0,                   0}, //  208RA
{   88,  209,               0,    6.636397e+09,    5,         4.36825e-27}, //  209RA
{   88,  210,               0,    5.337972e+09,    0,                   0}, //  210RA
{   88,  211,               0,    1.875504e+10,    0,                   0}, //  211RA
{   88,  212,               0,    1.875504e+10,    0,                   0}, //  212RA
{   88,  213,               0,    2.363134e+11,    1,        3.097165e-27}, //  213RA
{   88,  214,               0,     3.54903e+09,    0,                   0}, //  214RA
{   88,  215,               0,         2236177,    0,                   0}, //  215RA
{   88,  216,               0,        262.5705,    0,                   0}, //  216RA
{   88,  217,               0,        2308.312,    0,                   0}, //  217RA
{   88,  218,               0,        36355.92,    0,                   0}, //  218RA
{   88,  219,               0,    1.442695e+07,    0,                   0}, //  219RA
{   88,  220,               0,    2.596851e+07,    0,                   0}, //  220RA
{   88,  221,               0,    4.039546e+10,    5,        -9.08495e-28}, //  221RA
{   88,  222,               0,    5.482241e+10,    0,                   0}, //  222RA
{   88,  223,               0,    1.424733e+15,    3,        1.366025e-27}, //  223RA
{   88,  224,               0,     4.56209e+14,    0,                   0}, //  224RA
{   88,  225,               0,    1.857326e+15,    1,        -3.70569e-27}, //  225RA
{   88,  226,               0,    7.284456e+19,    0,                   0}, //  226RA
{   88,  227,               0,    3.652904e+12,    3,        -2.03919e-27}, //  227RA
{   88,  228,               0,    2.617914e+17,    0,                   0}, //  228RA
{   88,  229,               0,    3.462468e+11,    5,        2.537625e-27}, //  229RA
{   88,  230,               0,    8.050238e+12,    0,                   0}, //  230RA
{   88,  231,               0,    1.485976e+11,    0,                   0}, //  231RA
{   88,  232,               0,    3.635592e+11,    0,                   0}, //  232RA
{   88,  233,               0,    4.328085e+10,    0,                   0}, //  233RA
{   88,  234,               0,    4.328085e+10,    0,                   0}, //  234RA
{   89,  206,               0,    3.173929e+07,    0,                   0}, //  206AC
{   89,  207,               0,    3.895277e+07,    0,                   0}, //  207AC
{   89,  208,               0,     1.37056e+08,    0,                   0}, //  208AC
{   89,  209,               0,    1.442695e+08,    0,                   0}, //  209AC
{   89,  210,               0,    5.049433e+08,    0,                   0}, //  210AC
{   89,  211,               0,     3.02966e+08,    0,                   0}, //  211AC
{   89,  212,               0,    1.341706e+09,    0,                   0}, //  212AC
{   89,  213,               0,    1.064709e+09,    0,                   0}, //  213AC
{   89,  214,               0,     1.18301e+10,    0,                   0}, //  214AC
{   89,  215,               0,    2.452582e+08,    0,                   0}, //  215AC
{   89,  216,               0,        634785.8,    0,                   0}, //  216AC
{   89,  217,               0,        99.54596,    9,          1.9291e-26}, //  217AC
{   89,  218,               0,        1558.111,    0,                   0}, //  218AC
{   89,  219,               0,         17023.8,    0,                   0}, //  219AC
{   89,  220,               0,    3.808715e+07,    0,                   0}, //  220AC
{   89,  221,               0,    7.502014e+07,    0,                   0}, //  221AC
{   89,  222,               0,    7.213475e+09,    0,                   0}, //  222AC
{   89,  223,               0,    1.817796e+11,    0,                   0}, //  223AC
{   89,  224,               0,    1.443849e+13,    0,                   0}, //  224AC
{   89,  225,               0,    1.246489e+15,    0,                   0}, //  225AC
{   89,  226,               0,    1.525361e+14,    0,                   0}, //  226AC
{   89,  227,               0,    9.912325e+17,    3,           5.555e-27}, //  227AC
{   89,  228,               0,    3.194127e+13,    0,                   0}, //  228AC
{   89,  229,               0,    5.427419e+12,    0,                   0}, //  229AC
{   89,  230,               0,    1.760088e+11,    0,                   0}, //  230AC
{   89,  231,               0,    6.492128e+11,    0,                   0}, //  231AC
{   89,  232,               0,    1.716807e+11,    0,                   0}, //  232AC
{   89,  233,               0,    2.091908e+11,    0,                   0}, //  233AC
{   89,  234,               0,    6.347858e+10,    0,                   0}, //  234AC
{   89,  235,               0,     8.65617e+10,    0,                   0}, //  235AC
{   90,  208,               0,         2452582,    0,                   0}, //  208TH
{   90,  209,               0,         5482241,    0,                   0}, //  209TH
{   90,  210,               0,    1.298426e+07,    0,                   0}, //  210TH
{   90,  211,               0,     5.77078e+07,    0,                   0}, //  211TH
{   90,  212,               0,    4.328085e+07,    0,                   0}, //  212TH
{   90,  213,               0,    2.077481e+08,    0,                   0}, //  213TH
{   90,  214,               0,    1.255145e+08,    0,                   0}, //  214TH
{   90,  215,               0,    1.731234e+09,    0,                   0}, //  215TH
{   90,  216,               0,    3.751007e+07,    0,                   0}, //  216TH
{   90,  217,               0,        347689.5,    0,                   0}, //  217TH
{   90,  218,               0,        168.7953,    0,                   0}, //  218TH
{   90,  219,               0,         1514.83,    0,                   0}, //  219TH
{   90,  220,               0,        13994.14,    0,                   0}, //  220TH
{   90,  221,               0,         2510289,    0,                   0}, //  221TH
{   90,  222,               0,         3231637,    0,                   0}, //  222TH
{   90,  223,               0,     8.65617e+08,    0,                   0}, //  223TH
{   90,  224,               0,     1.51483e+09,    0,                   0}, //  224TH
{   90,  225,               0,    7.574149e+11,    0,                   0}, //  225TH
{   90,  226,               0,    2.646191e+12,    0,                   0}, //  226TH
{   90,  227,               0,     2.32851e+15,    0,                   0}, //  227TH
{   90,  228,               0,    8.703202e+16,    0,                   0}, //  228TH
{   90,  229,               0,     3.58755e+20,    5,           2.323e-27}, //  229TH
{   90,  230,               0,    3.432749e+21,    0,                   0}, //  230TH
{   90,  231,               0,    1.325433e+14,    0,                   0}, //  231TH
{   90,  232,               0,    6.373971e+26,    0,                   0}, //  232TH
{   90,  233,               0,    1.889642e+12,    0,                   0}, //  233TH
{   90,  234,               0,     3.00398e+15,    0,                   0}, //  234TH
{   90,  235,               0,    6.232443e+11,    0,                   0}, //  235TH
{   90,  236,               0,    3.228752e+12,    0,                   0}, //  236TH
{   90,  237,               0,    4.154962e+11,    0,                   0}, //  237TH
{   90,  238,               0,      8.1368e+11,    0,                   0}, //  238TH
{   91,  212,               0,         7357745,    0,                   0}, //  212PA
{   91,  213,               0,         7646284,    0,                   0}, //  213PA
{   91,  214,               0,    2.452582e+07,    0,                   0}, //  214PA
{   91,  215,               0,    2.019773e+07,    0,                   0}, //  215PA
{   91,  216,               0,    2.164043e+08,    0,                   0}, //  216PA
{   91,  217,               0,         5193702,    0,                   0}, //  217PA
{   91,  218,               0,        163024.5,    0,                   0}, //  218PA
{   91,  221,               0,        8511.901,    0,                   0}, //  221PA
{   91,  222,               0,         4183816,    0,                   0}, //  222PA
{   91,  223,               0,         7357745,    0,                   0}, //  223PA
{   91,  224,               0,    1.139729e+09,    0,                   0}, //  224PA
{   91,  225,               0,    2.452582e+09,    0,                   0}, //  225PA
{   91,  226,               0,    1.558111e+11,    0,                   0}, //  226PA
{   91,  227,               0,    3.315313e+12,    0,                   0}, //  227PA
{   91,  228,               0,    1.142614e+14,    6,          1.7675e-26}, //  228PA
{   91,  229,               0,    1.869733e+14,    0,                   0}, //  229PA
{   91,  230,               0,    2.168948e+15,    0,                   0}, //  230PA
{   91,  231,               0,    1.491458e+21,    3,         1.01505e-26}, //  231PA
{   91,  232,               0,    1.645394e+14,    0,                   0}, //  232PA
{   91,  233,               0,    3.362345e+15,    3,           1.717e-26}, //  233PA
{   91,  234,               0,     3.47978e+13,    0,                   0}, //  234PA
{   91,  235,               0,    2.115568e+12,    0,                   0}, //  235PA
{   91,  236,               0,    7.877115e+11,    0,                   0}, //  236PA
{   91,  237,               0,    7.530868e+11,    0,                   0}, //  237PA
{   91,  238,               0,    1.964951e+11,    0,                   0}, //  238PA
{   91,  239,               0,    9.348664e+12,    0,                   0}, //  239PA
{   92,  217,               0,    2.308312e+07,    0,                   0}, //   217U
{   92,  218,               0,        735774.5,    0,                   0}, //   218U
{   92,  219,               0,        60593.19,    0,                   0}, //   219U
{   92,  221,               0,        1009.887,    0,                   0}, //   221U
{   92,  222,               0,        1442.695,    0,                   0}, //   222U
{   92,  223,               0,        25968.51,    0,                   0}, //   223U
{   92,  224,               0,         1298426,    0,                   0}, //   224U
{   92,  225,               0,     1.37056e+08,    0,                   0}, //   225U
{   92,  226,               0,    5.049433e+08,    0,                   0}, //   226U
{   92,  227,               0,    9.521787e+10,    0,                   0}, //   227U
{   92,  228,               0,    7.877115e+11,    0,                   0}, //   228U
{   92,  229,               0,    5.020579e+12,    0,                   0}, //   229U
{   92,  230,               0,    2.592667e+15,    0,                   0}, //   230U
{   92,  231,               0,    5.235252e+14,    0,                   0}, //   231U
{   92,  232,               0,    3.136852e+18,    0,                   0}, //   232U
{   92,  233,               0,      7.2481e+21,    5,          2.9795e-27}, //   233U
{   92,  234,               0,    1.117714e+22,    0,                   0}, //   234U
{   92,  235,               0,    3.205236e+25,    7,          -1.919e-27}, //   235U
{   92,  236,               0,    1.066267e+24,    0,                   0}, //   236U
{   92,  237,               0,     8.41625e+14,    0,                   0}, //   237U
{   92,  238,               0,      2.0342e+26,    0,                   0}, //   238U
{   92,  239,               0,    2.029872e+12,    0,                   0}, //   239U
{   92,  240,               0,     7.32312e+13,    0,                   0}, //   240U
{   92,  242,               0,    1.454237e+12,    0,                   0}, //   242U
{   93,  226,               0,    5.049433e+07,    0,                   0}, //  226NP
{   93,  227,               0,    7.357745e+08,    0,                   0}, //  227NP
{   93,  228,               0,    8.858148e+10,    0,                   0}, //  228NP
{   93,  229,               0,    3.462468e+11,    0,                   0}, //  229NP
{   93,  230,               0,    3.981838e+11,    0,                   0}, //  230NP
{   93,  231,               0,    4.224211e+12,    0,                   0}, //  231NP
{   93,  232,               0,    1.272457e+12,    0,                   0}, //  232NP
{   93,  233,               0,    3.133534e+12,    0,                   0}, //  233NP
{   93,  234,               0,    5.484549e+14,    0,                   0}, //  234NP
{   93,  235,               0,    4.937335e+16,    0,                   0}, //  235NP
{   93,  236,               0,    6.965764e+21,    0,                   0}, //  236NP
{   93,  237,               0,     9.76113e+22,    5,          1.5857e-26}, //  237NP
{   93,  238,               0,    2.638833e+14,    0,                   0}, //  238NP
{   93,  239,               0,     2.93675e+14,    0,                   0}, //  239NP
{   93,  240,               0,    5.358169e+12,    0,                   0}, //  240NP
{   93,  241,               0,    1.203208e+12,    0,                   0}, //  241NP
{   93,  242,               0,    1.904357e+11,    0,                   0}, //  242NP
{   93,  243,               0,    1.601391e+11,    0,                   0}, //  243NP
{   93,  244,               0,    1.982263e+11,    0,                   0}, //  244NP
{   94,  229,               0,    1.298426e+11,    0,                   0}, //  229PU
{   94,  230,               0,    1.471549e+11,    0,                   0}, //  230PU
{   94,  231,               0,    7.444306e+11,    0,                   0}, //  231PU
{   94,  232,               0,    2.925786e+12,    0,                   0}, //  232PU
{   94,  233,               0,     1.80914e+12,    0,                   0}, //  233PU
{   94,  234,               0,    4.570458e+13,    0,                   0}, //  234PU
{   94,  235,               0,    2.190011e+12,    0,                   0}, //  235PU
{   94,  236,               0,    1.301196e+17,    0,                   0}, //  236PU
{   94,  237,               0,    5.688979e+15,    0,                   0}, //  237PU
{   94,  238,               0,    3.992803e+18,    0,                   0}, //  238PU
{   94,  239,               0,    1.097675e+21,    1,         1.02515e-27}, //  239PU
{   94,  240,               0,      2.9871e+20,    0,                   0}, //  240PU
{   94,  241,               0,    6.505978e+17,    5,        -3.44915e-27}, //  241PU
{   94,  242,               0,    1.707285e+22,    0,                   0}, //  242PU
{   94,  243,               0,    2.574056e+13,    0,                   0}, //  243PU
{   94,  244,               0,    3.642228e+24,    0,                   0}, //  244PU
{   94,  245,               0,    5.453387e+13,    0,                   0}, //  245PU
{   94,  246,               0,    1.351199e+15,    0,                   0}, //  246PU
{   94,  247,               0,    2.829558e+14,    0,                   0}, //  247PU
{   95,  230,               0,    2.452582e+10,    0,                   0}, //  230AM
{   95,  232,               0,    1.139729e+11,    0,                   0}, //  232AM
{   95,  233,               0,    2.769974e+11,    0,                   0}, //  233AM
{   95,  234,               0,    2.008231e+11,    0,                   0}, //  234AM
{   95,  236,               0,    3.116221e+11,    0,                   0}, //  236AM
{   95,  237,               0,    6.370941e+12,    0,                   0}, //  237AM
{   95,  238,               0,    8.483047e+12,    0,                   0}, //  238AM
{   95,  239,               0,    6.180506e+13,    0,                   0}, //  239AM
{   95,  240,               0,    2.638401e+14,    0,                   0}, //  240AM
{   95,  241,               0,    1.969567e+19,    5,          8.1305e-27}, //  241AM
{   95,  242,               0,    8.320311e+13,    2,        1.958895e-27}, //  242AM
{   95,  243,               0,     3.35542e+20,    5,           7.575e-27}, //  243AM
{   95,  244,               0,    5.245639e+13,    0,                   0}, //  244AM
{   95,  245,               0,    1.064709e+13,    0,                   0}, //  245AM
{   95,  246,               0,    3.375906e+12,    0,                   0}, //  246AM
{   95,  247,               0,    1.990919e+12,    0,                   0}, //  247AM
{   96,  234,               0,    7.357745e+10,    0,                   0}, //  234CM
{   96,  238,               0,    1.246489e+13,    0,                   0}, //  238CM
{   96,  239,               0,    1.506174e+13,    0,                   0}, //  239CM
{   96,  240,               0,    3.365519e+15,    0,                   0}, //  240CM
{   96,  241,               0,    4.088453e+15,    0,                   0}, //  241CM
{   96,  242,               0,    2.029295e+16,    0,                   0}, //  242CM
{   96,  243,               0,     1.32487e+18,    5,          2.0705e-27}, //  243CM
{   96,  244,               0,     8.24053e+17,    0,                   0}, //  244CM
{   96,  245,               0,    3.834828e+20,    7,            2.02e-27}, //  245CM
{   96,  246,               0,    2.142546e+20,    0,                   0}, //  246CM
{   96,  247,               0,    7.102388e+23,    9,          1.8685e-27}, //  247CM
{   96,  248,               0,    1.584368e+22,    0,                   0}, //  248CM
{   96,  249,               0,    5.552933e+12,    0,                   0}, //  249CM
{   96,  250,               0,    3.778851e+20,    0,                   0}, //  250CM
{   96,  251,               0,    1.454237e+12,    0,                   0}, //  251CM
{   96,  252,               0,    2.492977e+14,    0,                   0}, //  252CM
{   97,  234,               0,    2.019773e+11,    0,                   0}, //  234BK
{   97,  238,               0,    2.077481e+11,    0,                   0}, //  238BK
{   97,  240,               0,    4.154962e+11,    0,                   0}, //  240BK
{   97,  241,               0,    3.981838e+11,    0,                   0}, //  241BK
{   97,  242,               0,    6.059319e+11,    0,                   0}, //  242BK
{   97,  243,               0,    2.337166e+13,    0,                   0}, //  243BK
{   97,  244,               0,     2.25926e+13,    0,                   0}, //  244BK
{   97,  245,               0,    6.170118e+14,    0,                   0}, //  245BK
{   97,  247,               0,    6.282793e+19,    0,                   0}, //  247BK
{   97,  248,               0,    4.097542e+17,    0,                   0}, //  248BK
{   97,  249,               0,    4.113412e+16,    7,            1.01e-26}, //  249BK
{   97,  250,               0,    1.668188e+13,    0,                   0}, //  250BK
{   97,  251,               0,    4.812831e+12,    0,                   0}, //  251BK
{   98,  237,               0,     3.02966e+09,    0,                   0}, //  237CF
{   98,  238,               0,     3.02966e+07,    0,                   0}, //  238CF
{   98,  239,               0,    5.626511e+10,    0,                   0}, //  239CF
{   98,  240,               0,    8.309923e+10,    0,                   0}, //  240CF
{   98,  241,               0,    3.272032e+11,    0,                   0}, //  241CF
{   98,  242,               0,    3.202783e+11,    0,                   0}, //  242CF
{   98,  243,               0,    9.262102e+11,    0,                   0}, //  243CF
{   98,  244,               0,    1.679297e+12,    0,                   0}, //  244CF
{   98,  245,               0,    3.895277e+12,    0,                   0}, //  245CF
{   98,  246,               0,    1.854152e+14,    0,                   0}, //  246CF
{   98,  247,               0,    1.615241e+13,    0,                   0}, //  247CF
{   98,  248,               0,    4.156981e+16,    0,                   0}, //  248CF
{   98,  249,               0,    1.598073e+19,    9,          -1.414e-27}, //  249CF
{   98,  250,               0,    5.955012e+17,    0,                   0}, //  250CF
{   98,  251,               0,    4.088453e+19,    0,                   0}, //  251CF
{   98,  252,               0,    1.204218e+17,    0,                   0}, //  252CF
{   98,  253,               0,    2.220019e+15,    0,                   0}, //  253CF
{   98,  254,               0,    7.541256e+15,    0,                   0}, //  254CF
{   98,  255,               0,    7.357745e+12,    0,                   0}, //  255CF
{   98,  256,               0,    1.064709e+12,    0,                   0}, //  256CF
{   99,  241,               0,    1.154156e+10,    0,                   0}, //  241ES
{   99,  242,               0,    1.947638e+10,    0,                   0}, //  242ES
{   99,  243,               0,     3.02966e+10,    0,                   0}, //  243ES
{   99,  244,               0,    5.337972e+10,    0,                   0}, //  244ES
{   99,  245,               0,    9.521787e+10,    0,                   0}, //  245ES
{   99,  247,               0,    3.938557e+11,    0,                   0}, //  247ES
{   99,  248,               0,    2.337166e+12,    0,                   0}, //  248ES
{   99,  249,               0,    8.846606e+12,    0,                   0}, //  249ES
{   99,  250,               0,    4.466584e+13,    0,                   0}, //  250ES
{   99,  251,               0,    1.713922e+14,    0,                   0}, //  251ES
{   99,  252,               0,    5.879704e+16,    0,                   0}, //  252ES
{   99,  253,               0,     2.55155e+15,    7,          2.0705e-26}, //  253ES
{   99,  254,               0,      3.4365e+16,    0,                   0}, //  254ES
{   99,  255,               0,    4.960995e+15,    0,                   0}, //  255ES
{   99,  256,               0,    2.198667e+12,    0,                   0}, //  256ES
{   99,  257,               0,    9.597962e+14,    0,                   0}, //  257ES
{  100,  241,               0,         1053167,    0,                   0}, //  241FM
{  100,  242,               0,         1154156,    0,                   0}, //  242FM
{  100,  243,               0,    2.596851e+08,    0,                   0}, //  243FM
{  100,  244,               0,         4760894,    0,                   0}, //  244FM
{  100,  245,               0,    6.059319e+09,    0,                   0}, //  245FM
{  100,  246,               0,     2.22175e+09,    0,                   0}, //  246FM
{  100,  247,               0,    5.049433e+10,    0,                   0}, //  247FM
{  100,  248,               0,    5.193702e+10,    0,                   0}, //  248FM
{  100,  249,               0,    2.250604e+11,    0,                   0}, //  249FM
{  100,  250,               0,    2.596851e+12,    0,                   0}, //  250FM
{  100,  251,               0,    2.752662e+13,    0,                   0}, //  251FM
{  100,  252,               0,    1.318681e+14,    0,                   0}, //  252FM
{  100,  253,               0,    3.739466e+14,    0,                   0}, //  253FM
{  100,  254,               0,    1.682759e+13,    0,                   0}, //  254FM
{  100,  255,               0,    1.042376e+14,    0,                   0}, //  255FM
{  100,  256,               0,    1.364212e+13,    0,                   0}, //  256FM
{  100,  257,               0,    1.252721e+16,    0,                   0}, //  257FM
{  100,  258,               0,        533797.2,    0,                   0}, //  258FM
{  100,  259,               0,    2.164043e+09,    0,                   0}, //  259FM
{  101,  245,               0,         1298426,    0,                   0}, //  245MD
{  101,  247,               0,    1.615818e+09,    0,                   0}, //  247MD
{  101,  248,               0,    1.009887e+10,    0,                   0}, //  248MD
{  101,  249,               0,    3.130648e+10,    0,                   0}, //  249MD
{  101,  250,               0,    7.502014e+10,    0,                   0}, //  250MD
{  101,  251,               0,    3.462468e+11,    0,                   0}, //  251MD
{  101,  252,               0,    1.990919e+11,    0,                   0}, //  252MD
{  101,  253,               0,    5.193702e+11,    0,                   0}, //  253MD
{  101,  255,               0,    2.337166e+12,    0,                   0}, //  255MD
{  101,  256,               0,    6.665251e+12,    0,                   0}, //  256MD
{  101,  257,               0,    2.866924e+13,    0,                   0}, //  257MD
{  101,  258,               0,    6.419416e+15,    0,                   0}, //  258MD
{  101,  259,               0,    8.309923e+12,    0,                   0}, //  259MD
{  101,  260,               0,    3.963805e+15,    0,                   0}, //  260MD
{  102,  251,               0,    1.154156e+09,    0,                   0}, //  251NO
{  102,  252,               0,    3.520176e+09,    0,                   0}, //  252NO
{  102,  253,               0,      1.4023e+11,    0,                   0}, //  253NO
{  102,  254,               0,    7.357745e+10,    0,                   0}, //  254NO
{  102,  255,               0,    2.683413e+11,    0,                   0}, //  255NO
{  102,  256,               0,    4.198243e+09,    0,                   0}, //  256NO
{  102,  257,               0,    3.606738e+10,    0,                   0}, //  257NO
{  102,  258,               0,         1731234,    0,                   0}, //  258NO
{  102,  259,               0,    5.020579e+12,    0,                   0}, //  259NO
{  102,  260,               0,    1.529257e+08,    0,                   0}, //  260NO
{  102,  262,               0,         7213475,    0,                   0}, //  262NO
{  103,  252,               0,    5.193702e+08,    0,                   0}, //  252LR
{  103,  253,               0,    8.223362e+08,    0,                   0}, //  253LR
{  103,  254,               0,    1.875504e+10,    0,                   0}, //  254LR
{  103,  255,               0,    3.173929e+10,    0,                   0}, //  255LR
{  103,  256,               0,    3.895277e+10,    0,                   0}, //  256LR
{  103,  257,               0,     5.77078e+09,    0,                   0}, //  257LR
{  103,  258,               0,     5.91505e+09,    0,                   0}, //  258LR
{  103,  259,               0,    8.944709e+09,    0,                   0}, //  259LR
{  103,  260,               0,    2.596851e+11,    0,                   0}, //  260LR
{  103,  261,               0,    3.375906e+12,    0,                   0}, //  261LR
{  103,  262,               0,    2.077481e+13,    0,                   0}, //  262LR
{  104,  254,               0,        33181.99,    0,                   0}, //  254RF
{  104,  255,               0,    2.423728e+09,    0,                   0}, //  255RF
{  104,  256,               0,         9233248,    0,                   0}, //  256RF
{  104,  257,               0,    6.780667e+09,    0,                   0}, //  257RF
{  104,  258,               0,    1.731234e+07,    0,                   0}, //  258RF
{  104,  259,               0,    4.616624e+09,    0,                   0}, //  259RF
{  104,  260,               0,     3.02966e+07,    0,                   0}, //  260RF
{  104,  262,               0,    3.318199e+09,    0,                   0}, //  262RF
{  104,  263,               0,     8.65617e+11,    0,                   0}, //  263RF
{  105,  255,               0,    2.308312e+09,    0,                   0}, //  255DB
{  105,  256,               0,    3.751007e+09,    0,                   0}, //  256DB
{  105,  257,               0,    1.096448e+09,    0,                   0}, //  257DB
{  105,  258,               0,     5.77078e+09,    0,                   0}, //  258DB
{  105,  260,               0,    2.192896e+09,    0,                   0}, //  260DB
{  105,  261,               0,    2.596851e+09,    0,                   0}, //  261DB
{  105,  262,               0,    5.049433e+10,    0,                   0}, //  262DB
{  105,  263,               0,    3.895277e+10,    0,                   0}, //  263DB
{  106,  258,               0,         4183816,    0,                   0}, //  258SG
{  106,  259,               0,    6.924936e+08,    0,                   0}, //  259SG
{  106,  260,               0,         5193702,    0,                   0}, //  260SG
{  106,  261,               0,    3.318199e+08,    0,                   0}, //  261SG
{  106,  262,               0,         9954596,    0,                   0}, //  262SG
{  106,  263,               0,    1.442695e+09,    0,                   0}, //  263SG
{  106,  264,               0,    5.337972e+07,    0,                   0}, //  264SG
{  106,  266,               0,     3.02966e+10,    0,                   0}, //  266SG
{  107,  261,               0,    1.731234e+07,    0,                   0}, //  261BH
{  107,  264,               0,    6.347858e+08,    0,                   0}, //  264BH
{  108,  264,               0,         1154156,    0,                   0}, //  264HS
{  108,  265,               0,         2885390,    0,                   0}, //  265HS
{  108,  266,               0,         3318199,    0,                   0}, //  266HS
{  108,  267,               0,    7.502014e+07,    0,                   0}, //  267HS
{  110,  271,               0,         2351593,    0,                   0}, //  271DS
{  110,  273,               0,        245258.2,    0,                   0}, //  273DS
{  112,  277,               0,        995459.6,    0,                   0}, //  277CN
};
