//$Id: PhysicalPanel.java,v 1.2 2004/09/24 08:50:52 suzuki Exp $
/* Changes of Physical Panel(Repeated vols Button) 9,13,1998
 *
 */

//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
package GGE;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
//import FileChooserDemo.src.ExampleFileFilter;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

class PhysicalPanel extends JPanel implements ActionListener{

  private JButton single, replicas, trans, rotate, transSlice, 
                  rotateSlice, transParame, axiParame;
  private JLabel phyLabel,repeatedLabel,singleLabel,sliceLabel,parameLabel;
  PhysicalItem phyItem;

  VolumesFrame parent;
  PhysicalPanel(VolumesFrame parent){
    this.parent = parent;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints gbc = new GridBagConstraints();
    setLayout(gbl);
    setBorder(new TitledBorder(LineBorder.createBlackLineBorder()," Physical Volume "));
    
      gbc.gridx = 0; gbc.gridy = 0;
      gbc.weightx = 1; gbc.weighty = 1;
      gbc.fill = GridBagConstraints.BOTH;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      single   = new JButton(" Single Placement");
      single.setForeground(Color.cyan);
      gbl.setConstraints(single, gbc);
      add(single);

      JPanel repPanel = new JPanel();
      repPanel.setLayout(new BorderLayout());
      repeatedLabel = new JLabel("  Repeated Placement ",SwingConstants.LEFT);
      repeatedLabel.setForeground(Color.black);
      repPanel.add("North",repeatedLabel);      
      
      JPanel axialortrans = new JPanel();
       axialortrans.setLayout(new GridLayout(1,2));

        trans = new JButton("Translational");
          trans.setForeground(Color.cyan);
         axialortrans.add("Center",trans);      

        rotate = new JButton("Axially Symmetric");
          rotate.setForeground(Color.cyan);
         axialortrans.add("East",rotate);
      
      repPanel.add("Center",axialortrans);

      gbc.gridx = 0; gbc.gridy = 1;
      gbc.weightx = 1; gbc.weighty = 1;
      gbc.fill = GridBagConstraints.BOTH;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbl.setConstraints(repPanel, gbc);
      add(repPanel);
      
      JPanel slicePanel = new JPanel();
      slicePanel.setLayout(new BorderLayout());
      sliceLabel = new JLabel("  Slicing ",SwingConstants.LEFT);
      //sliceLabel.setForeground(Color.blue);
      slicePanel.add("North",sliceLabel);

      JPanel axiatransSlice = new JPanel();
       axiatransSlice.setLayout(new GridLayout(1,2));

        transSlice = new JButton("Translational");
          transSlice.setForeground(Color.cyan);
         axiatransSlice.add("Center",transSlice);

        rotateSlice = new JButton("Axially Symmetric");
          rotateSlice.setForeground(Color.cyan);
         axiatransSlice.add("East",rotateSlice);

      slicePanel.add("Center",axiatransSlice);



      gbc.gridx = 0; gbc.gridy = 2;
      gbc.weightx = 1; gbc.weighty = 1;
      gbc.fill = GridBagConstraints.BOTH;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbl.setConstraints(slicePanel, gbc);
      add(slicePanel);

      JPanel paramePanel = new JPanel();
      paramePanel.setLayout(new BorderLayout());
      parameLabel = new JLabel("  Parametrisation",SwingConstants.LEFT);
      //parameLabel.setForeground(Color.blue);
      paramePanel.add("North",parameLabel);
      
      JPanel axiatransParame = new JPanel();
      axiatransParame.setLayout(new GridLayout(1,2));
      transParame = new JButton("Translational");
        transParame.setForeground(Color.cyan);
      axiatransParame.add("Center",transParame);
      axiParame = new JButton("Axially Symmetric");
        axiParame.setForeground(Color.cyan);
      axiatransParame.add("East",axiParame);
      paramePanel.add("Center",axiatransParame);

      gbc.gridx = 0; gbc.gridy = 3;
      gbc.weightx = 1; gbc.weighty = 1;
      gbc.fill = GridBagConstraints.BOTH;
      gbc.gridwidth = GridBagConstraints.REMAINDER;
      gbl.setConstraints(paramePanel, gbc);
      add(paramePanel);

    single.addActionListener(this);
    single.setForeground(Color.red);
    repeatedLabel.setForeground(Color.blue);
    trans.addActionListener(this);
    rotate.addActionListener(this);
    trans.setForeground(Color.red);
    rotate.setForeground(Color.red);
    transSlice.addActionListener(this);
    transSlice.setForeground(Color.red);
    rotateSlice.addActionListener(this);
    rotateSlice.setForeground(Color.red);
    transParame.addActionListener(this);
    axiParame.addActionListener(this);
    transParame.setForeground(Color.red);
    axiParame.setForeground(Color.red);

    setSize(280, 400);
  }

  public void actionPerformed(ActionEvent ae){
    Object o = ae.getSource();
    if (o == single){ 
      parent.singleOpen();
      repaint();
    }else if (o == trans){
      parent.repeatOpen();
    }else if (o == rotate){
      parent.repeatRotateOpen();
    }else if (o == transSlice){
      parent.replicaOpen();
    }else if (o == rotateSlice){
      parent.slicingOpen();
    }else if (o == transParame){
      parent.transParameOpen();
    }else if (o == axiParame){
      parent.axiParameOpen();
    }
  }


//C++ source code
  String getCPP(){
    StringBuffer cpp = new StringBuffer("\n// Physical Volumes ----  Single Positioned Placement,   Repeated Placement,   Slicing  --------------------------- \n\n");
    return cpp.toString();
  }

}
