//  Define the swig module name.
%module pygdsio

//  The following code is copied verbatim to the wrapper file.
//  Note that this code is not passed through CPP
%{
#define SWIG_FILE_WITH_INIT
#include "Dacc.hh"
#include "TSeries.hh"
#include "FrWriter.hh"
%}

//  ANSI C/C++ wrapper declarations.

class Dacc {
 public:
  Dacc(void);
  ~Dacc(void);
  void addChannel(const char* name);
  void addFile(const char* path);
  void addFileList(const char* path);
  void rmChannel(const char*);
  int fillData(double stride);
  const TSeries* refData(const char*) const;
  int seek(Time);
  Time getFillTime();
};

class FrWriter {
 public:
  FrWriter(const char* Name, int Run);
  ~FrWriter();
  int open(const char* File, bool toc);
  void close(void);
  void erase(void);
  int writeFrame(void);
  int buildFrame(const Time& Start, double dT);
  bool is_open(void) const;
  void addProcSeries(const char* Name, const TSeries& TS);
  void addRawSeries(const char* Name, const TSeries& TS);
  void addWriterHistory(void);
  void addHistory(const std::string& Name, const Time& t, 
		  const std::string& cmt);
};
