//////////////////////////////////////////////////////////////////////////
//  									//
//  ColumnInfo								//
//  									//
//////////////////////////////////////////////////////////////////////////


#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include "events/ColumnInfo.hh"
#include "events/Factory.hh"


namespace events {

//______________________________________________________________________________
   bool ColumnInfo::operator== (const ColumnInfo& desc) const
   {
      return strcasecmp (mName.c_str(), desc.mName.c_str()) == 0;
   }

//______________________________________________________________________________
   bool ColumnInfo::operator< (const ColumnInfo& desc) const 
   {
      // fixed columns first
      if (mFixed) {
         if (desc.mFixed) {
            return mColumn < desc.mColumn;
         }
         else {
            return true;
         }
      }
      if (desc.mFixed) {
         return false;
      }
      // rest ordered by type
      int s = mType - desc.mType;
      if (s != 0) {
         return s < 0;
      }
      // and name
      return strcasecmp (mName.c_str(), desc.mName.c_str()) < 0;
   }

//______________________________________________________________________________
   bool ColumnInfo::SetNameType (const char* name, Enum type)
   {
      Init (name, type);
      return mType != kInvalid;
   
   }

//______________________________________________________________________________
   bool ColumnInfo::CheckName (const char* name)
   {
      // must be at least one character
      if (!name || !*name) {
         return false;
      }
      // must not containe "[", "]", "*", "?" or "."
      if (strpbrk (name, "[].?*") != 0) {
         return false;
      }
      // good if there are no paranthesis
      if (strpbrk (name, "()") == 0) {
         return true;
      }
      // open parenthesis and digit?
      const char* p = strchr (name, '(');
      if (!p | !isdigit (*(p+1))) {
         return false;
      }
      // if parenthesis, the name has to be "Event".
      // :TODO: COULD BE RELAXED   
      // if (strncasecmp (name, "Event", p - name) != 0) {
         // return false;
      // }
      // check index
      char* end;
      long i = strtol (p + 1, &end, 10);
      return (i >= 0) && end && (*end == ')') && (strlen(end) == 1);
   }

//______________________________________________________________________________
   void ColumnInfo::Init (const char* name, Enum type) 
   {
      if ((type != kInvalid) && CheckName (name)) {
         mName = name;
         // eliminate space
         std::string::size_type pos;
         while ((pos = mName.find_first_of (" \t\f\n\r\v")) != 
               std::string::npos) {
            mName.erase (pos, 1);
         }
         // check of fixed column
         const ColumnInfo* desc = Factory::Get().GetFixedColumn (name);
         if (desc) {
            mType = desc->GetType();
            mFixed = true;
            mColumn = desc->GetColumn();
            mOffset = desc->GetOffset();
         }
         // else set it
         else {
            mType = type;
            mFixed = false;
            mColumn = 0;
            mOffset = 0;
         }
      }
      // invalid
      else {
         mName = "";
         mType = kInvalid;
         mFixed = false;
         mColumn = 0;
         mOffset = 0;
      }
   }

}
