#ifndef _LIGO_EVENTALGORITHMUTIL_H
#define _LIGO_EVENTALGORITHMUTIL_H
/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Module Name: AlgorithmUtil						*/
/*                                                         		*/
/* Module Description: Defines utility classes for event algorithms	*/
/*                                                         		*/
/* Revision History:					   		*/
/* Rel   Date     Programmer  	Comments				*/
/* 1.0	 25Jun01  D. Sigg    	First release		   		*/
/*                                                         		*/
/* Documentation References:						*/
/*	Man Pages: AlgorithmUtil.html					*/
/*	References: none						*/
/*                                                         		*/
/* Author Information:							*/
/* Name          Telephone       Fax             e-mail 		*/
/* Daniel Sigg   (509) 372-8132  (509) 372-8137  sigg_d@ligo.mit.edu	*/
/*                                                         		*/
/*                                                         		*/
/*                      -------------------                             */
/*                                                         		*/
/*                             LIGO					*/
/*                                                         		*/
/*        THE LASER INTERFEROMETER GRAVITATIONAL WAVE OBSERVATORY.	*/
/*                                                         		*/
/*                     (C) The LIGO Project, 1999.			*/
/*                                                         		*/
/*                                                         		*/
/* Caltech				MIT		   		*/
/* LIGO Project MS 51-33		LIGO Project NW-17 161		*/
/* Pasadena CA 91125			Cambridge MA 01239 		*/
/*                                                         		*/
/* LIGO Hanford Observatory		LIGO Livingston Observatory	*/
/* P.O. Box 1970 S9-02			19100 LIGO Lane Rd.		*/
/* Richland WA 99352			Livingston, LA 70754		*/
/*                                                         		*/
/*----------------------------------------------------------------------*/

#include "PConfig.h"
#ifdef __GNU_STDC_OLD
#include <math.h>
#else
#include <limits>
#endif
#include "events/Event.hh"
#include "events/Value.hh"

namespace events {

   class SortElement {
   public:
      // Sort function must convertable to real
      typedef ColumnType::Real sorttype;
      // Create a sort element
      SortElement (const Event& event, const Function& func,
      bool ascending) 
      : mEvent (&event) {
         Value val;
         bool valid = func (event, val); // calculate value
         if (valid) {
            valid = val.Write (mValue); // convert to Real
         }
         if (!valid) { // Make sure invalid elements go to the end
         #ifdef __GNU_STDC_OLD
            mValue = ascending ? HUGE_VAL : -HUGE_VAL;
         #else
            mValue = ascending ?
               std::numeric_limits<sorttype>::infinity() :
               -std::numeric_limits<sorttype>::infinity();
         #endif
         }
      }
      // Equal (for CINT)
      bool operator== (const SortElement& s) const {
         return mValue == s.mValue; }
      // Smaller (ascending)
      bool operator< (const SortElement& s) const {
         return mValue < s.mValue; }
      // Greater (descending)
      bool operator> (const SortElement& s) const {
         return mValue > s.mValue; }
      // Get the event
      const Event* Get() const {
         return mEvent; }
      // Convert into an event reference
      operator const Event& () const {
         return *mEvent; }
   private:
      // Event pointer
      const Event*	mEvent;
      // Sort value
      sorttype 		mValue;
   };
   // Array of sort elements
   typedef std::vector <SortElement> sortarray;

}

#endif // _LIGO_EVENTALGORITHMUTIL_H
